/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import spec.jbb.Address;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.District;
import spec.jbb.History;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBButil;
import spec.jbb.Order;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class CustomerReportTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private byte districtId;
    private boolean home;
    private char use_customerId;
    private String cust_last_name;
    private short customerId;
    private short customerWarehouseId;
    private byte customerDistrictId;
    private Date reportTime;
    private Warehouse warehousePtr;
    private District districtPtr;
    private Customer customerPtr;
    private TransactionLogBuffer initLog;
    private TransactionLogBuffer customerLog;
    private XMLTransactionLog xmlCustomerLog;
    int lastPaymentsQuantity = 5;
    int lastOrdersQuantity = 5;
    Date[] paymentDates = new Date[this.lastPaymentsQuantity];
    BigDecimal[] paymentAmount = new BigDecimal[this.lastPaymentsQuantity];
    Date[] orderDates = new Date[this.lastOrdersQuantity];
    BigDecimal[] orderAmount = new BigDecimal[this.lastOrdersQuantity];
    String[] validationScreen = new String[]{"                                 CUSTOMER REPORT", "Date: 31-12-2004 04:30:07", "", "Warehouse:    1                          District:  1", "mypIw7RUtW7hoQdmASd                      Q5pck00LNkV         ", "vIfg0HYwMq                               U2KXH6WkfD          ", "PWBAjD5CvVrZNaS      Vv 76447-9863       8FUvKJooC6SiWztmS    Wu 76407-6439", "", "Customer:   19  Cust-Warehouse:    1  Cust-District:  1", "Name:   5C8n4mfBkU32Y8   OE BARABLEPRES          Since:  31-12-2004", "        Dy6cn4FXooQQHqDkl                        Credit: GC", "        syXdFH3PQeJjwyR6Kr                       %Disc:   2.65", "Last payments         Date:                   Amount:", "                      31-12-2004 04:30:07    $10.00", "                      31-12-2004 04:30:07    $10.00", "                      31-12-2004 04:30:07    $10.00", "                      31-12-2004 04:30:07    $10.00", "                      31-12-2004 04:30:07    $10.00", "Last orders           Date:                   Amount:", "                      31-12-2004 04:30:07    $3594.00", "", "", "", ""};
    boolean[] checkLine = new boolean[]{true, false, true, true, true, true, true, true, true, false, true, true, true, false, false, false, false, false, true, false, true, true, true, true};

    public CustomerReportTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.warehousePtr = this.company.getWarehousePtr(this.warehouseId, false);
        this.customerLog = new TransactionLogBuffer();
        this.setupCustomerLog();
        this.xmlCustomerLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.customerLog);
        this.setupInitLog();
    }

    private void setupCustomerLog() {
        this.customerLog.putText("CUSTOMER REPORT", 33, 0, 15);
        this.customerLog.putText("Date:", 0, 1, 5);
        this.customerLog.putText("Warehouse:", 0, 3, 10);
        this.customerLog.putText("District:", 41, 3, 9);
        this.customerLog.putText("Customer:", 0, 8, 9);
        this.customerLog.putText("Cust-Warehouse:", 16, 8, 15);
        this.customerLog.putText("Cust-District:", 38, 8, 14);
        this.customerLog.putText("Name:", 0, 9, 5);
        this.customerLog.putText("Since:", 49, 9, 6);
        this.customerLog.putText("Credit:", 49, 10, 7);
        this.customerLog.putText("%Disc:", 49, 11, 6);
        this.customerLog.putText("Last payments", 0, 12, 13);
        this.customerLog.putText("Date:", 22, 12, 5);
        this.customerLog.putText("Amount:", 46, 12, 7);
        this.customerLog.putText("Last orders", 0, 18, 11);
        this.customerLog.putText("Date:", 22, 18, 5);
        this.customerLog.putText("Amount:", 46, 18, 7);
    }

    private void setupInitLog() {
        int n;
        this.initLog.putText("DD-MM-YYYY", 6, 1, 10);
        this.initLog.putText("hh:mm:ss", 17, 1, 8);
        this.initLog.putCharFill('9', 11, 3, 4);
        this.initLog.putCharFill('9', 51, 3, 2);
        this.initLog.putCharFill('X', 0, 4, 20);
        this.initLog.putCharFill('X', 41, 4, 20);
        this.initLog.putCharFill('X', 0, 5, 20);
        this.initLog.putCharFill('X', 41, 5, 20);
        this.initLog.putCharFill('X', 0, 6, 20);
        this.initLog.putCharFill('X', 21, 6, 2);
        this.initLog.putText("XXXXX-XXXX", 24, 6, 10);
        this.initLog.putCharFill('X', 41, 6, 20);
        this.initLog.putCharFill('X', 62, 6, 2);
        this.initLog.putText("XXXXX-XXXX", 65, 6, 10);
        this.initLog.putCharFill('9', 10, 8, 4);
        this.initLog.putCharFill('9', 32, 8, 4);
        this.initLog.putCharFill('9', 53, 8, 2);
        this.initLog.putCharFill('X', 8, 9, 16);
        this.initLog.putCharFill('X', 25, 9, 2);
        this.initLog.putCharFill('X', 28, 9, 16);
        this.initLog.putText("DD-MM-YYYY", 57, 9, 10);
        this.initLog.putCharFill('X', 8, 10, 20);
        this.initLog.putCharFill('X', 57, 10, 2);
        this.initLog.putCharFill('X', 8, 11, 20);
        this.initLog.putText("99.99", 57, 11, 5);
        for (n = 0; n < 5; ++n) {
            this.initLog.putText("DD-MM-YYYY", 22, 13 + n, 10);
            this.initLog.putText("hh:mm:ss", 33, 13 + n, 8);
            this.initLog.putText("$9999.99", 45, 13 + n, 8);
        }
        for (n = 0; n < 5; ++n) {
            this.initLog.putText("DD-MM-YYYY", 22, 19 + n, 10);
            this.initLog.putText("hh:mm:ss", 33, 19 + n, 8);
            this.initLog.putText("$9999.99", 45, 19 + n, 8);
        }
    }

    public String getMenuName() {
        return "CustomerReport";
    }

    public synchronized void delete() {
    }

    public synchronized void init() {
        JBButil.getLog().entering("spec.jbb.CustomerReportTransaction", "init");
        this.districtId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
        this.districtPtr = this.warehousePtr.getDistrictPtr(this.districtId, false);
        int n = JBButil.random(1, 100, this.warehouseId);
        int n2 = JBButil.random(1, 100, this.warehouseId);
        if (n2 <= 60) {
            this.cust_last_name = JBButil.choose_random_last_name(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = (char)70;
        } else {
            this.customerId = JBButil.create_random_customer_id(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = (char)84;
        }
        if (n <= 85) {
            this.customerDistrictId = this.districtId;
            this.customerWarehouseId = this.warehouseId;
        } else {
            this.customerDistrictId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
            short s = this.company.getMaxWarehouses();
            this.customerWarehouseId = (short)JBButil.random(1, (int)s, this.warehouseId);
            while (this.customerWarehouseId == this.warehouseId && s > 1) {
                this.customerWarehouseId = (short)JBButil.random(1, (int)s, this.warehouseId);
            }
        }
        this.home = this.customerWarehouseId == this.warehouseId;
        JBButil.getLog().exiting("spec.jbb.CustomerReportTransaction", "init");
    }

    public boolean process() {
        JBButil.getLog().entering("spec.jbb.CustomerReportTransaction", "process");
        String string = this.warehousePtr.getName();
        switch (this.use_customerId) {
            case 'T': {
                long l = this.company.buildUniqueCustomerKey(this.customerWarehouseId, this.customerDistrictId, this.customerId);
                this.customerPtr = this.company.getCustomer(l, true);
                break;
            }
            case 'F': {
                this.customerPtr = this.company.getCustomerByLastName(this.customerWarehouseId, this.customerDistrictId, this.cust_last_name);
            }
        }
        if (this.customerPtr != null) {
            JBBDataStorage jBBDataStorage = this.warehousePtr.getHistoryTable();
            Iterator iterator = jBBDataStorage.elements();
            History[] historyArray = new History[jBBDataStorage.size()];
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                History history = (History)iterator.next();
                if (history.getCustomerId() != this.customerPtr.getId()) continue;
                historyArray[++n] = history;
            }
            for (n2 = n; n2 > 0 && n - n2 < this.lastPaymentsQuantity; --n2) {
                this.paymentDates[n - n2] = historyArray[n2].getDate();
                this.paymentAmount[n - n2] = historyArray[n2].getAmount();
            }
            JBBDataStorage jBBDataStorage2 = this.districtPtr.getOrderTable();
            Iterator iterator2 = jBBDataStorage2.elements();
            Order[] orderArray = new Order[jBBDataStorage2.size()];
            int n3 = 0;
            int n4 = 5;
            while (iterator2.hasNext()) {
                Order order = (Order)iterator2.next();
                if (order.getCustomerPtr() != this.customerPtr) continue;
                orderArray[++n3] = order;
            }
            for (n2 = n3; n2 > 0 && n3 - n2 < n4; --n2) {
                this.orderDates[n3 - n2] = orderArray[n2].getEntryTime();
                this.orderAmount[n3 - n2] = orderArray[n2].getTotalAmount();
            }
            this.reportTime = new Date();
        }
        JBButil.getLog().exiting("spec.jbb.CustomerReportTransaction", "process");
        return true;
    }

    public synchronized void display() {
        System.out.println("CustomerTransaction Display *********************");
        System.out.println("Warehouse ID is " + this.warehouseId + " ******************");
        System.out.println("District  ID is " + this.districtId + " ******************");
        System.out.println("Customer  ID is " + this.customerId + " ******************");
        System.out.println("**************************************************");
    }

    public synchronized void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.CustomerReportTransaction", "initializeTransactionLog");
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.CustomerReportTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        String[] stringArray;
        JBButil.getLog().entering("spec.jbb.CustomerReportTransaction", "processTransactionLog");
        this.customerLog.clearBuffer();
        this.xmlCustomerLog.clear();
        this.setupCustomerLog();
        Address address = this.warehousePtr.getAddress();
        Address address2 = this.districtPtr.getAddress();
        this.customerLog.putDate(this.reportTime, 6, 1, 10);
        this.customerLog.putTime(this.reportTime, 17, 1, 8);
        this.customerLog.putInt(this.warehouseId, 11, 3, 4);
        this.customerLog.putInt(this.districtId, 51, 3, 2);
        this.customerLog.putText(address.getStreet1(), 0, 4, 20);
        this.customerLog.putText(address2.getStreet1(), 41, 4, 20);
        this.customerLog.putText(address.getStreet2(), 0, 5, 20);
        this.customerLog.putText(address2.getStreet2(), 41, 5, 20);
        this.customerLog.putText(address.getCity(), 0, 6, 20);
        this.customerLog.putText(address.getState(), 21, 6, 2);
        String string = address.getZip();
        this.customerLog.putSubstring(string, 24, 6, 0, 5);
        this.customerLog.putChar('-', 29, 6);
        this.customerLog.putSubstring(string, 30, 6, 5, 4);
        this.customerLog.putText(address2.getCity(), 41, 6, 20);
        this.customerLog.putText(address2.getState(), 62, 6, 2);
        string = address2.getZip();
        this.customerLog.putSubstring(string, 65, 6, 0, 5);
        this.customerLog.putChar('-', 70, 6);
        this.customerLog.putSubstring(string, 71, 6, 5, 4);
        if (this.customerPtr != null) {
            int n;
            stringArray = this.customerPtr.getAddress();
            Date date = this.customerPtr.getSince();
            this.customerLog.putInt(this.customerPtr.getId(), 10, 8, 4);
            this.customerLog.putInt(this.customerPtr.getWarehouseId(), 32, 8, 4);
            this.customerLog.putInt(this.customerPtr.getDistrictId(), 53, 8, 2);
            this.customerLog.putText(this.customerPtr.getFirstName(), 8, 9, 16);
            this.customerLog.putText(this.customerPtr.getMiddleName(), 25, 9, 2);
            this.customerLog.putText(this.customerPtr.getLastName(), 28, 9, 16);
            this.customerLog.putDate(date, 57, 9, 10);
            this.customerLog.putText(stringArray.getStreet1(), 8, 10, 20);
            this.customerLog.putText(this.customerPtr.getCreditStatus(), 57, 10, 2);
            this.customerLog.putText(stringArray.getStreet2(), 8, 11, 20);
            this.customerLog.putDouble(this.customerPtr.getDiscountRate().movePointRight(2).toString(), 57, 11, 5);
            for (n = 0; n < this.lastPaymentsQuantity && this.paymentDates[n] != null; ++n) {
                this.customerLog.putDate(this.paymentDates[n], 22, 13 + n, 10);
                this.customerLog.putTime(this.paymentDates[n], 33, 13 + n, 8);
                this.customerLog.putDollars(this.paymentAmount[n], 45, 13 + n, 8);
            }
            for (n = 0; n < this.lastOrdersQuantity && this.orderDates[n] != null; ++n) {
                this.customerLog.putDate(this.orderDates[n], 22, 19 + n, 10);
                this.customerLog.putTime(this.orderDates[n], 33, 19 + n, 8);
                this.customerLog.putDollars(this.orderAmount[n], 45, 19 + n, 8);
            }
        }
        this.xmlCustomerLog.populateXML(this.customerLog);
        if (Transaction.enableLogWrite) {
            this.customerLog.display();
        }
        if (Transaction.validationFlag) {
            stringArray = this.customerLog.validate();
            if (stringArray.length != this.validationScreen.length) {
                System.out.println("VALIDATION ERROR:  mismatch in screen lengths for CustomerReportTransaction");
                System.out.println("    Screen length should be:  " + this.validationScreen.length);
                System.out.println("    Screen length is:  " + stringArray.length);
                Transaction.invalidateRun();
            }
            for (int i = 0; i < this.validationScreen.length; ++i) {
                if (!this.checkLine[i] || stringArray[i].equals(this.validationScreen[i])) continue;
                System.out.println("VALIDATION ERROR:  incorrect output for CustomerReportTransaction");
                System.out.println("    Line " + (i + 1) + " should be:  |" + this.validationScreen[i] + "|");
                System.out.println("    Line " + (i + 1) + " is:  |" + stringArray[i] + "|");
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.CustomerReportTransaction", "processTransactionLog");
    }
}

