##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# https://morningstarsecurity.com/research/whatweb
#
Plugin.define do
	name "Plugin-Tutorial-3"
	authors [
		"Your preferred name <email@address>", # v0.1 # 2019-01-01 # Created plugin
		"@examplename" # v0.2 # 2019-03-12 # Added cookie detection     # <----- updated from tutorial 1
	]
	version "0.2" # <----- updated from tutorial 1
	description "Generic CMS is an open-source Content Management System developed in PHP."
	website "http://example.com/"

	# The Google Dorks list is an array. This can help people find the product using a search engine.
	# Dorks #     # <----- updated from tutorial 1
	dorks [
	'"Generic CMS login"',
	'Generic login register linkname',
	]

	# This is the matches array. 
	# Each match is treated independently.

	# Matches #
	matches [

		# This searches for a text string.
		{ :text => "This page was generated by <b>Generic CMS</b>" },

		# This searches for a regular expression. Note that the slashes are escaped.
		{ :regexp => /This page was generated by <a href="http:\/\/www.genericcms.com\/en\/products\/generic-cms\/">Generic CMS<\/a>/ },

		# This extracts the version of Generic CMS from the Mega generator tag.
		{ :name => "Meta generator",  :version => /<meta name="generator" content="Generic CMS version ([a-z0-9])+/ },

		# Generic Cookie  # <----- updated from tutorial 1
		# This detects the generic CMS cookie. Note the :search is set to "headers[set-cookie]"
		{ :search => "headers[set-cookie]", :regexp => /genericcms=[^;]+;/ },
		
	] 

end
