/*
 * sact.h: SACT
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/* $Id: sact.h,v 1.3 2003/07/14 16:22:51 chikama Exp $ */

#ifndef __SACT_H__
#define __SACT_H__

#include "config.h"

#include <glib.h>
#include "portab.h"
#include "graphics.h"
#include "surface.h"
#include "sacttimer.h"
#include "variable.h"


// ץ饤Ȥκ
#define SPRITEMAX 21845

// CGκ
#define CGMAX 63336

// åκĹ
#define MSGBUFMAX 257*10

// κǿ
#define SEL_ELEMENT_MAX 20


// Ȥμ
#define KEYWAIT_NONE 0
#define KEYWAIT_SIMPLE 1
#define KEYWAIT_SPRITE 2
#define KEYWAIT_MESSAGE 3
#define KEYWAIT_SELECT 4
#define KEYWAIT_BACKLOG 5

// ʸִ
typedef struct {
	char *src; // ֤ʸ
	char *dst; // ֤ʸ
} strexchange_t;

// SACTEFAM Ȥäޥ
typedef struct {
	int fd;       // SACTEFAM.KLD Υեǥץ꥿
	char *mapadr; // mmap 줿ǽΥɥ쥹
	off_t size;   // mmap 礭
	int datanum;  // SACTEFAM.KLD Υޥեο
	int *no;      // ʥꥪ¦Ǥֹ
	int *offset;  // ǡؤΥեå
} SACTEFAM_t;


// CG_XX ǺCGμ
enum cgtype {
	CG_NOTUSED = 0,
	CG_LINKED  = 1,
	CG_SET     = 2,
	CG_REVERSE = 3,
	CG_STRETCH = 4
};

// cg˴ؤ
struct _cginfo {
	enum cgtype type;  // CGμ, 0: ̤, 1:󥯤Ƥ, ...
	int no;            // CGֹ
	surface_t *sf;     // CG
	int refcnt;        // ȥ󥿡ˤʤä鳫Ƥ褤
};
typedef struct _cginfo cginfo_t;

// ץ饤ȤΥ
enum spritetype {
	SPRITE_NORMAL = 0,
	SPRITE_SWITCH = 1,
	SPRITE_GETA   = 2,
	SPRITE_GETB   = 3,
	SPRITE_PUT    = 4,
	SPRITE_ANIME  = 5,
	SPRITE_SWPUT  = 6,
	SPRITE_MSG    =100,
	SPRITE_WP,
	SPRITE_NONE   =-1
};

// ()
struct _sprite;

// ץ饤Ȥ˴ؤƼ
struct _sprite {
	// ץ饤ȤΥ
	enum spritetype type;
	
	// ץ饤ֹ
	int no;
	
	// 줾ξ֤λĤ餹ֹ
	int numsound1, numsound2, numsound3;
	
	//  sprite 礭(cg1礭)
	MyDimension cursize;
	
	// 줾ξ֤ɽ CG
	cginfo_t *cg1, *cg2, *cg3;
	
	// update Ȥɽcg
	cginfo_t *curcg;
	
	// ץ饤Ȥɽ뤫
	boolean show;
	boolean show_save; // Zkey hide save
	
	// ɽݤΥ֥Ψ 0:ʤ, 255: ̾ɽ
	int blendrate; 
	
	// ץ饤Ȥ Freeze Ƥ뤫(0:No 1-3: ֹ)
	int freezed_state;
	
	// ɽ (SetPos)
	MyPoint loc;
	
	// ߤΥץ饤Ȥɽ
	MyPoint cur;
	
	// event callback
	int (* eventcb)(struct _sprite *sp, agsevent_t *e);  // for key/mouse
	int (* teventcb)(struct _sprite *sp, agsevent_t *e); // for timer
        // sprite callback
	void (* remove)(struct _sprite *sp);
	// sprite褹Ȥ callback
	int  (* update)(struct _sprite *sp);
	
	boolean focused; // forcusƤ뤫
	boolean pressed; // spriteǥޥƤ뤫
	
	GSList *expsp; // ץ饤ȤΥꥹ
	
	// move command ѥѥ᡼
	struct {
		MyPoint to;     // ư
		int time;       // ưλ
		int speed;      // ư®
		int starttime;  // ưϻ
		int endtime;    // ưλͽ
		boolean moving; // ư椫ɤ
	} move;
	
	// SACT.Numeralѥѥ᡼
	struct {
		int cg[10];
		MyPoint pos;
		int span;
	} numeral;
	
	// ץ饤Ȥμξ
	union {
		// åץ饤
		struct {
			
		} sw;
		
		// åȥץ饤
		struct {
			boolean dragging;  // ɥå
			MyPoint dragstart; // ɥåϰ
		} get;

		// ץåȥץ饤
		struct {
			
		} put;

		// ˥᡼󥹥ץ饤
		struct {
			int interval;      // ޤδֳ(10msec)
			int starttime;     // ϻ
			int npat;          // ˥ᥳ޿(1/2/3)
			unsigned int tick; // 
		} anime;
		
		// åץ饤
		struct {
			GSList    *buf;       // ɽʸΥꥹ
			surface_t *canvas;    // ʸ褹surface
			MyPoint    dspcur;    // ߤɽ
		} msg;
	} u;
};
typedef struct _sprite sprite_t;

// SACTΤξ
struct _sact {
	// SACTΥС
	int version;
	
	// ץ饤
	sprite_t *sp[SPRITEMAX];
	
	GSList *sp_zhide;  // ZǾäץ饤ȤΥꥹ
	GSList *sp_quake;  // Quakeɤ餹ץ饤ȤΥꥹ
	
	GSList *updatelist; // 褹륹ץ饤ȤΥꥹ
	
	cginfo_t *cg[CGMAX]; // cgޤCG_xxǺä CG
	
	// ɸϤθ
	MyPoint origin;
	
	// ʸ push/pop/replce 
	GSList *strstack;
	GSList *strreplace;
	char   *strreplacesrc;
	char   *strreplacedst; 
	
	// åץ饤ѥåХåե
	char msgbuf[MSGBUFMAX];
	char msgbuf2[MSGBUFMAX];
	
	// 򥦥
	struct {
		char *elem[SEL_ELEMENT_MAX]; // ʸ
		int spno; // طʥץ饤ֹ
		int font_size; // ʸ
		int font_type; // ե
		int frame_dot; // ȥץ饤Ȥγ¦Υԥ
		int linespace; // ιԴ
		int movecursor; // 
		int align; // Ԥ
		void (* cbmove)(agsevent_t *);
		void (* cbrelease)(agsevent_t *);
		surface_t   *charcanvas;
	} sel;
	
	// event listener
	GSList *eventlisteners;
	GSList *teventlisteners;
	GSList *teventremovelist;
	
	// MOVE륹ץ饤ȤΥꥹ
	GSList *movelist;
	int movestarttime; // Ƥ˰ư򳫻Ϥ뤿γϻ
	int movecurtime;
	
	MyRectangle updaterect; // ɬפspriteΰ
	
	// sact timer
	stimer_t timer[65536];
	
	// DnD˴ؤ
	sprite_t *draggedsp;  // dragΥץ饤
	boolean dropped;      // ץ饤Ȥɥåפ줿ɤ
	
	// keywaitμ
	int waittype;
	int waitkey;
	int sp_result_sw;
	int sp_result_get;
	int sp_result_put;
	
	// wait skip level
	//  0 ̾省Ԥ
	//  1 ɤΤߥå
	//  2 ̤ɤ⥹å
	int waitskiplv;
	
	// ϰϳ򥯥åȤβ
	int numsoundob;
	
	// depth map
	surface_t *dmap;
	
	// SACTEFAM.KLD
	SACTEFAM_t am;
	
	boolean zhiding;  // Zkeyˤ뱣
	int     zofftime;
	boolean zdooff;
	
	// Хå
	boolean logging;
	GList  *log;
};
typedef struct _sact sact_t;

// shortcut
#define sact sactprv
extern sact_t sact;

#endif /* __SACT_H__ */
