//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 4>, 229> gamma_inv_small_data = { {
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.2239623606222809074122747811596115646210220735131141509259977248899758059576948436798908594057794725e-517862)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4348301951174619607003912855228982264838968134589390827069898370149065135278987288014463439625604227e-34079)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.9832661142546970309065948494116195914044751609094617663675341704778529043412686011701793912754530322e-501622)), SC_(BOOST_MATH_SMALL_CONSTANT(0.174464879621346471044494182889773112103066192989857880445657763562407515813032064473382568887549155e-36531)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.8367188988033804556441828789142666841098768711906267440588049611090664598162301930590308375972597743e-378782)), SC_(BOOST_MATH_SMALL_CONSTANT(0.258455732678645501224573885451125893770282157149004436646252270592694652815341234774299743101856032e-62682)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.2205873777306860224249147129964654825654772808335654855092638386176586877302351181235652317545193535e-295387)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8841860184607764624716199689352601821223421516721282102648409952215997935928956722103353938434066324e-92450)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.6323592662811279296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3493006236342872627718268547235558974110453236408370553242260146873678814721124761086879547194341511e-115006)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4608598583105815395151633406100700185774288566360162761619249236808047706604292396779780216945145655e-251105)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.814723670482635498046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1307814977375223234061697346935750965506413900088172878810937417241710162327371948752530053786611785e-51419)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3622247004413029118815942894731774856416774764001901351075227450895011592470141353244995696694896319e-423065)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.835008561611175537109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.3407200009988954922968231040073535782592944660979975072820794043769535120578823528671413904276314187e-45248)), SC_(BOOST_MATH_SMALL_CONSTANT(0.40372680297867266879468280760885460454290870234025769400910020388606341293084660523346882864736631e-452163)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.905791938304901123046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1289547938840298804104533289571370292449761595410863583261482629787772675014213604864800473713128265e-24829)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4473385981314550569653428208559396173592281928696895222750064028650962596615670418178431916147100131e-592788)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.9133758544921875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2660916718277898648353162270511365962890563186837505224306478516822433113175485818467727525519960066e-22737)), SC_(BOOST_MATH_SMALL_CONSTANT(0.6065564736497368801762295026989180367578487822196046971460097223432141011146248705024295896736469553e-613849)) }}, 
      {{ SC_(0.1730655412757187150418758392333984375e-5), SC_(0.968867778778076171875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1473132778697774093465699897329346789995005439716750867355563556776005696738800270428366009192934656e-7936)), SC_(BOOST_MATH_SMALL_CONSTANT(0.6008673144885279892931053509531579477623416731984800692761855880946172764550286223383877167245766902e-870647)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.8500545195325853360129687030255002945655259106744411868936199400386357779413785394252606937409149347e-413825)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1168004659330719336985231445704960139768804061229080049955849277439667205757483213992057220049540351e-27232)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.7202712693841376368216354323694296792211539722228687704587193232171864702453427173668794173358037833e-400847)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2252614264634486253201447701279415032436991420138140648287940022937659078016357382571415445200213866e-29192)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3000327882810984063485886505392286395644270610646887344028999837107973933925695988567563167728045096e-302685)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1498490062697145666757563645833685565995577423177516513148297134617720423214544808430852418820345691e-50089)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.1307004433406758598014428627573055623164994782163856086219980606033295840179348304515381612579150121e-236044)), SC_(BOOST_MATH_SMALL_CONSTANT(0.8660761056125063203743178336674650301770491595301193399539391174485981887085468404902606561784465577e-73877)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.6323592662811279296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1183316844216403526657583856991948601012391672622156410900987978451851712537691445331530312832797228e-91901)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1591103740030003499118723418460479045052885251014777131066205491018123438721843692240137750119143378e-200658)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.814723670482635498046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1674134325233505112606127764095613275142520744956844047709789044616079191515075547796473275770297974e-41089)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3612384181299129469928622773435995792869558303198558837492185251476669534034831500723829680749590518e-338072)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.835008561611175537109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.6513834432351054603935790801928696636769937839154029815627322893900997971153735962011923847861105547e-36158)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2131860779789139256037424176809792095632204680337931857718865949785434825481960848149849797507583928e-361324)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.905791938304901123046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2178005192333624215784803979717837598562757410620706503281900091107825680350931337396209745019443998e-19841)), SC_(BOOST_MATH_SMALL_CONSTANT(0.4588085686858952503042372234625485480201105499533793863948812241019952913466033029898154440318470087e-473698)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.9133758544921875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2044546663391562477705354540370760821409485274148331480980359986548683615601729039239239614213065235e-18169)), SC_(BOOST_MATH_SMALL_CONSTANT(0.7629190706250225994074616748192014275571599576934851198947217095948168969106405661485602778753139218e-490528)) }}, 
      {{ SC_(0.216575062950141727924346923828125e-5), SC_(0.968867778778076171875), SC_(BOOST_MATH_SMALL_CONSTANT(0.4096487433832820170639333743831954761351590021205697452562807451168473548459292965564190974788844749e-6342)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1297397706877886168379273776356177633807822967666079798581567618567115144239687805362946264983224597e-695735)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.460289138417023240211835453578728773675893958998560741266616339802513531273727174963248143404409346e-123279)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1227830593913913689043483463822718345251662053270570059659747620207531684387617971000150489495390622e-8112)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.6439991263768059081770908658752929598087302065287439367522303278837306676039083594400840449710127147e-119413)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1936099411280065786600982265792717722767945024296565235561154800531592756609798398701501116557434413e-8696)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2064880008938546016135832883384716687050715182089334885089172611730709160883330305789994119189833204e-90170)), SC_(BOOST_MATH_SMALL_CONSTANT(0.9636789658116208361662045675832611481515953065813422246552622845538828381107902733604814371406262203e-14922)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.4672763627314931787409452529965189883928299396526058431027743531008131781333308125789010166445570443e-70318)), SC_(BOOST_MATH_SMALL_CONSTANT(0.5333958645484846264899444976530540348886306684971665853490471154195979393073606296468477524956455995e-22008)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.6323592662811279296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1232079542911688319553284787645084489874316487664902104337227730213965329139279051931070447347538552e-27377)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1745508475051527213009559427098382072109145551947732820968960362083588524860039683359355038443208669e-59776)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.814723670482635498046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1296871584563229453031476552376127081733495432987283917208707733104304941994062901047954719016264728e-12240)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3119684049016554066402196968135164105103042293007478934952055073327703314807997817770702753165916888e-100712)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.835008561611175537109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1744156521766280393141688111513263176846896834358940986864024481897475752003777342235119371016119832e-10771)), SC_(BOOST_MATH_SMALL_CONSTANT(0.414282922235332770074768291902894089464647802773088955269313913489638472173573774702189380297337679e-107639)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.905791938304901123046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.9134084128666229552771771583922013819958821761786059137020004689307969234520514787745058008336030516e-5911)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2085723217142930347094312090575084590094262400334108078273206186864903163220911787400224976002324296e-141115)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.9133758544921875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1106626349398291975361851522331692345605272541414957089479290323484012747768775482956833740133997023e-5412)), SC_(BOOST_MATH_SMALL_CONSTANT(0.5019947814569084821972649400070925089480757099017899755164384177383260941610254064551897764836241042e-146129)) }}, 
      {{ SC_(0.72700195232755504548549652099609375e-5), SC_(0.968867778778076171875), SC_(0.2608738285704836848239817641016769732591640383513307387951906227411127886545943640386587729196529798e-1889), SC_(BOOST_MATH_SMALL_CONSTANT(0.9391569555686887348572282531856270103209070385690661485800330330324704801693506326997201625650584228e-207261)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.339390501360481883384596846727229310838380493148059239101677398294559127652204528478268766605745691e-64017)), SC_(0.8930970995970272744149034236099991596203915342210295009610487968429898591362281212215882612432334172e-4213) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1478165479650781320569422389970436453616410129224510514070984667774343182955852078638154528221379033e-62009)), SC_(0.6166505887233514954458318978151305493474273629828733433707686152568316580969117228752011354754100409e-4516) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2636223483866300712285073854631877501273640030610221560132162856371236675991856524728587705746297074e-46824)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1179070268459566531464548375815239425103518998753490696351340626821057948491563316259813424943317095e-7748)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.3085719676015113786900559879398114388323199985826467699671192420873003184123044267039751593375655573e-36515)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1866107010075390801548946745085437000221498205178902450996305353941274930070444383308861599008651802e-11428)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.6323592662811279296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.7743073115105881135630532411055705358953657608902295030130428779685124579667759424182550282392251774e-14217)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3891618185709909838836983643181316431906213234898591756880393231944196898745253316876972214816450983e-31041)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.814723670482635498046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.222216709392403859077345757164648641055669472167062646627925353942822049167347003774956605136793258e-6356)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1553098038974094715628835971928945389167186664370201233578708844500900929376674522237036066734443409e-52298)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.835008561611175537109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.1762412434192703586953808931252239830607212327509661647619944439092944014510892565024867820443452495e-5593)), SC_(BOOST_MATH_SMALL_CONSTANT(0.1427522693565869357184324274786304328120490007393000466898389151996230157936654133010870707870098114e-55895)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.905791938304901123046875), SC_(0.2259490828022611962651286035615477033923299926896382236832176774513532167028895827574135582466792268e-3069), SC_(BOOST_MATH_SMALL_CONSTANT(0.2241017130581831897730462424904751051004418852587147386250684104551402650352326106103864234388080914e-73279)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.9133758544921875), SC_(0.1005028821672110309415483560972173499716663965719086172500020531716576068606833471119991129664424692e-2810), SC_(BOOST_MATH_SMALL_CONSTANT(0.6979771306818377405428798318204058016896524472057195949985191958384843690760804078528960881333370124e-75883)) }}, 
      {{ SC_(0.14000004739500582218170166015625e-4), SC_(0.968867778778076171875), SC_(0.4399884537105952873524158618429125109607698051551640190711957784190261472987797258480803340986411014e-981), SC_(BOOST_MATH_SMALL_CONSTANT(0.8636123050850289155805959438262889417641775752173387265269754240416817175647540561424609415147039372e-107628)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.8931367727030424252994406039858535255018561374129051577258665728233205820316949561800237503288164831e-52118)), SC_(0.104535845548742628763976899233973069829736957363121321494519130075530673267495622335035426409117717e-3429) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2589093342255974756648686300693355584048765521630894862720053856422193831195464113676002513110719721e-50483)), SC_(0.16198355017053579069996072009618961612118734166699913346916923061929129768370182367736118778593987e-3676) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.1131654056362539852227074104110635132727613506886451792169695589196046225490082242712248876956203819e-38120)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2418895718086420844325145820876239350943692602292988120400434717351012753484624854522329731793070942e-6308)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.7737905254468185735537123684595618067772979718013636259212988387325859473074990334198003279697030936e-29728)), SC_(BOOST_MATH_SMALL_CONSTANT(0.3789484131191558145146646615273547527416033448113469449596149406457540248009040893261262302435368351e-9304)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.6323592662811279296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.3137871276904600122078241916282438984659729219024238596335891667491938041450321977041506616782238e-11574)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2965711263826589720683465047050190541366519308458462201756314491278502965590196986656248475977616153e-25271)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.814723670482635498046875), SC_(BOOST_MATH_SMALL_CONSTANT(0.7326832021626652729926634452678165177166851058442304763758241120359336029481475591271983428389901225e-5175)), SC_(BOOST_MATH_SMALL_CONSTANT(0.2318348542835619519901827000824812239793449432180459609887843839490589299765256524982276851927704163e-42577)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.835008561611175537109375), SC_(0.9072264440263374752486629470877711396201875705326118961327802635563036219892924006850270554141376785e-4554), SC_(BOOST_MATH_SMALL_CONSTANT(0.8711416684170844816954635283039605021423223228389166020499752751997518422712015098390278042969483672e-45506)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.905791938304901123046875), SC_(0.7733918387072244011789525914900951463450874222624581078251551054909444827960192900592203159773605989e-2499), SC_(BOOST_MATH_SMALL_CONSTANT(0.2571614323671499433984893431798511621767008667253572255135699548767389412223368502318608579885806739e-59658)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.9133758544921875), SC_(0.2880392224683552008509186538991920740926457663134606188864795658000814467352709744686493645033034548e-2288), SC_(BOOST_MATH_SMALL_CONSTANT(0.6907597702339754306046761268666758595826983111062588436918559231568829549328274669882079071902690878e-61778)) }}, 
      {{ SC_(0.17196454791701398789882659912109375e-4), SC_(0.968867778778076171875), SC_(0.1022975882773694387190778303740674368993455977250017664945426765113234255858470803315310166922905371e-798), SC_(BOOST_MATH_SMALL_CONSTANT(0.4221221067519434825549040047213825597247842932163338061854159935919427768014137623800912125956789909e-87622)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.3495586827191531770535231367080732953937412615151725020717996080086485589322652358680193672275949898e-14916)), SC_(0.1427408156921550203964733950491640458157220298138194009074319242547971197914912790465510416201935332e-981) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2135466730997637347930895979558997098695943227325314240670753140974513599520909745766884732886655805e-14448)), SC_(0.3289650507739338949969385888328899090131305388988539989881991832060549330782773650444691368664734468e-1052) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.345959891505994573920146532876979428616649904934071674464948074830873268130904440040136502276139602e-10910)), SC_(0.1922865381371752376627657245783892335772421066560217575311011311368498385558583990275666613793226423e-1805) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.308167040348052978515625), SC_(BOOST_MATH_SMALL_CONSTANT(0.3829822614343259616831020022328609580180989772106774197697228391575249415735806534706101978431990667e-8508)), SC_(0.7572927936365265126558450099180450202432844005568818989453609586651932854239926958201865023965242319e-2663) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.6323592662811279296875), SC_(0.1505939828418726687381398631458743669409627162041838070367135649373806227725011954989680487803891401e-3312), SC_(BOOST_MATH_SMALL_CONSTANT(0.1162084281422969377226523082569747326821725361483871487282780438115902733161392316080316605540230283e-7232)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.814723670482635498046875), SC_(0.4878605561199170254993555550797777052716601720140458448451172217585515433949731427090377765716097212e-1481), SC_(BOOST_MATH_SMALL_CONSTANT(0.1063915552171246679201552775630173002963289477510275148968381199465573516908634786030473651045783934e-12185)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.835008561611175537109375), SC_(0.2793510340491223179257861943279119048708385675764655558162807552719005454520920320041493548667648507e-1303), SC_(BOOST_MATH_SMALL_CONSTANT(0.8062724058997189528788123299280499937216685401578538979985976698039322816246111574568131825618363452e-13024)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.905791938304901123046875), SC_(0.3723369364599241695177888518370141855064474706077264974725355828069490776654597120310317692557528914e-715), SC_(BOOST_MATH_SMALL_CONSTANT(0.2675898630365685302839648550793845147075820261853792964188019963414156834541244282744703718483685635e-17074)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.9133758544921875), SC_(0.686661318428780198379649389187459622222641698815843660306340661130449872396450257428209063508091594e-655), SC_(BOOST_MATH_SMALL_CONSTANT(0.6346671704911213035096115747653835531630846832152154403390282927003498855267031866758008107863915401e-17681)) }}, 
      {{ SC_(0.60085076256655156612396240234375e-4), SC_(0.968867778778076171875), SC_(0.1408309142624800225107896427273371067150419787065439439024094472721083328341474031598813748773825589e-228), SC_(BOOST_MATH_SMALL_CONSTANT(0.1389798156337807295947127479191824417596961602671849528553981940395023410910494839804442748480910921e-25077)) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.2217067042070261656114441331372031056796482747774007544530459644859070550516331388940310599871235441e-7674)), SC_(0.5221646641482264704755333400660433306534344743849778997838663392671213632920091372806932416847456426e-505) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.105233435264908696721158867206120047209589060765634758100281587073699030442056794890590820165442202e-7433)), SC_(0.2370236641827873916593769301860779629219958726808667166915237399481829007502028048228683540298377156e-541) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.22103404998779296875), SC_(BOOST_MATH_SMALL_CONSTANT(0.2720692749476253433194485594804086624863867951230595896914130979792434561231106235256886587990710606e-5613)), SC_(0.684727384218509774616151552639132642516873634348657590026321675141070778694592753558587501067032324e-929) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.308167040348052978515625), SC_(0.1945012262728113947174092742153820077658597862905731912818669165842855882338833757206696600313843808e-4377), SC_(0.5010782163204587164990362139900406618666271013083021513642451903006783829276845763652918240207035204e-1370) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.6323592662811279296875), SC_(0.2678076814684253388207891549015203441815387696909210275114031463037462825184779525302927782878112018e-1704), SC_(0.3355699609556020763761818703516660718965707115611808065243164333646480380401408451621152937718649945e-3721) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.814723670482635498046875), SC_(0.5519443694295817358667560227277734050233658512973422585235619565148594801790465772880702625518466729e-762), SC_(BOOST_MATH_SMALL_CONSTANT(0.1521784147836719873429974745180948701783240959166067438690358394858795409898569420554712263193503787e-6269)) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.835008561611175537109375), SC_(0.157942290116999715496899441614386437418372850300529884937353323341838987405061685005424700586694651e-670), SC_(BOOST_MATH_SMALL_CONSTANT(0.9300638747707064248838234333003135359793243459187200542535851863926418832283653872151990341768442837e-6701)) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.905791938304901123046875), SC_(0.6156292720469250152191172977847735846672093818556639529154131998043270417507793402988855017473876543e-368), SC_(BOOST_MATH_SMALL_CONSTANT(0.9835608551327350462842211000204483083175377942415395254552324222852108420746589293651996143411926356e-8785)) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.9133758544921875), SC_(0.6253743527010208852460893728919175814204088534982411548439945271078509605242716100053403273517595345e-337), SC_(BOOST_MATH_SMALL_CONSTANT(0.7649623463360145768926462776036988864408675923758317376955853151958300585672667306524247171463173293e-9097)) }}, 
      {{ SC_(0.000116783194243907928466796875), SC_(0.968867778778076171875), SC_(0.1361725185925066404699231307445713287240077451502469225873588813126039928575926034147580871482594361e-117), SC_(BOOST_MATH_SMALL_CONSTANT(0.1970152731145422501566851277990128812683805989338922500352787857395891626410876936571713429989797078e-12902)) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.12698681652545928955078125), SC_(BOOST_MATH_SMALL_CONSTANT(0.6389419951365505168213742535607083801424774564325987934934320986183843469503298391268834096210384788e-6013)), SC_(0.1132257114686176234011736341834046927596967272385604144092389093309188024362428818319072190846006759e-395) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.135477006435394287109375), SC_(BOOST_MATH_SMALL_CONSTANT(0.2381927813471867112836439772059583211544291930893077773183488576064825635114446625206544102956590674e-5824)), SC_(0.3792814100179551144868861498633247032095979823165205190557116303390384013164367512797566918532298706e-424) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.22103404998779296875), SC_(0.480502281371541323510453286429380108383847434196562929430889417823667454309781431802390267860464642e-4398), SC_(0.869923210970446775403812791329035518913267972514758421741352735004103670263658218621055807149889839e-728) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.308167040348052978515625), SC_(0.9579390051284372806338599117207986988623456690676593707891369126675631673683496595535062285698484254e-3430), SC_(0.2027352139344072302169602968458387297725861222591064073568084413094637648206161549322711611266665852e-1073) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.6323592662811279296875), SC_(0.252715079209943016894239891780405650507203415479186589329662192446200300419348083258509471825568878e-1335), SC_(0.1403081619061688835919802963399237605442962090617704076725629642161530595967917719397788786896506275e-2915) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.814723670482635498046875), SC_(0.5148574706569430386641987063601033253830428118093670131363449532199675730799583712667871199946857343e-597), SC_(0.319031006547729922943758015717164739726038835119416722315254234904437269217055210321155694677845045e-4912) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.835008561611175537109375), SC_(0.2336232060636468680298763086592315128520864805577827877335195943286399564396468640251084171088188349e-525), SC_(BOOST_MATH_SMALL_CONSTANT(0.4416237396840875270455255045802517084401101447247106118309253277459771697052944520730353485873255011e-5250)) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.905791938304901123046875), SC_(0.2820619087618214712586580492879138245117856541724464329377249767437182870498139716594924089127883574e-288), SC_(BOOST_MATH_SMALL_CONSTANT(0.686841976395102755795354846511530418971756957162735766100482927595263735008547634284729277201118786e-6883)) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.9133758544921875), SC_(0.5551180136919825874947373282742567924663694577557624395315113366298468961803654270194668889810023739e-264), SC_(BOOST_MATH_SMALL_CONSTANT(0.198311682935662628620401335083784485107643910427839233819119308115206998402883037266058134006220653e-7127)) }}, 
      {{ SC_(0.000149052008055150508880615234375), SC_(0.968867778778076171875), SC_(0.3954218544494374628285692941954536478743569125315731147622958212628060558583646866269887091192423723e-92), SC_(BOOST_MATH_SMALL_CONSTANT(0.3927403032923167204720626686805690283947153220433473944029398069872610810854541045510542047794087263e-10109)) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.12698681652545928955078125), SC_(0.7152190427298601594571159938212251086727382665743757471985690406777609605559890885949770886823916422e-2249), SC_(0.5699249277609096543624494507830937487962804479457359767676834065232598749036497233458920062585731546e-148) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.135477006435394287109375), SC_(0.2409135648458346302800756296889879854959535365354709895644810074566687455139859746087284776201028457e-2178), SC_(0.1276198129287563187800451501928656024314768400617821939379735513033808929977111820512238247732326539e-158) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.22103404998779296875), SC_(0.6802256292332066376146874410039580432569421387156606795388161811485643529868965898859950121665320351e-1645), SC_(0.3483577767702590198649809139957360887592650219312098941409457297880080360156436690426366723037964841e-272) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.308167040348052978515625), SC_(0.9669745994667051072958033562210641197812612386155295937654192982957413364712601378577440225372777341e-1283), SC_(0.1872178312093914666668353664699354048359196970346066862643846850154220490587353027681868660975081806e-401) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.6323592662811279296875), SC_(0.2078680364196807438298849740835285317736801092810921854376625185494666027388757500531965937494823423e-499), SC_(0.1940980586320713711601009157647719108902915992900798566465326564277930264960553562790389101222581526e-1090) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.814723670482635498046875), SC_(0.2831424539072253988416634201709116176591661423194009934428563883171035338046521635771507798074786634e-223), SC_(0.3353627472060982062455262714971853766759653506601897258914838347358670615581935804795450176146751688e-1837) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.835008561611175537109375), SC_(0.1787732507262943521016753570313681503916005001825267040428291048751405389623124964236582735328991528e-196), SC_(0.1456454013656017509017193130193556406330581120853832120451513707811484896457312901359168156072878575e-1963) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.905791938304901123046875), SC_(0.837597737033172538479888642057065130353796165100392988262588362474329484706276059971274306307155119e-108), SC_(0.3008625919959673243147469221155123482674030292229970752872798035256229502042306937044715207517659813e-2574) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.9133758544921875), SC_(0.1021468449862823305724475539348472481037993301048482146392495351886035410769693162884352551561523984e-98), SC_(0.1043268069386227245142603247836117871751827097506460570358735405648218855837835551714018440441663018e-2665) }}, 
      {{ SC_(0.0003985252114944159984588623046875), SC_(0.968867778778076171875), SC_(0.1921625974656960084278584956148389202015121326275638657364605765927234103392106212033821685696706061e-34), SC_(0.6832913251746222014629050560245817851054188567279554314561011277334087978083026411495512314152584718e-3781) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.12698681652545928955078125), SC_(0.435951734378349504670143158799756189349632667643742866396243382027351113858457154770515455172933863e-1403), SC_(0.2598364282807541353448110171130121253417733753751070504713968695495643543375162712791810949499302078e-92) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.135477006435394287109375), SC_(0.438798951745511504942617484037937842312650500233507360765735632931970912394687838070336110981145645e-1359), SC_(0.5889950801941227664825867161625817382134336618358372865614870963034210185897851485297025871941305886e-99) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.22103404998779296875), SC_(0.2937832652187445365522059951783816698628857990709748945948205909114811170011660290110319809151999498e-1026), SC_(0.8248247424680557124739655403382142597284692730327890358590707801455920937695292335324732929792733254e-170) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.308167040348052978515625), SC_(0.2624710128964698602781692379549822996817788462277196737813463196762182169598881287389630123345121596e-800), SC_(0.1834851239042801978257387702640984049496558520540791424871676680462873841394339231917050408059790019e-250) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.6323592662811279296875), SC_(0.1408263333403943388213811919547331502465208843711790106320604018633618989850176084161430265212442785e-311), SC_(0.2504797654775849465672851883838285806350916920754502829556652423197002579757157641758806147030921615e-680) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.814723670482635498046875), SC_(0.2702905140450769489562235446380298080970743159741668229553875254451415451021832338127459148340572674e-139), SC_(0.3058497706538771128912496243510323679002380098028763121648416859749854278370000559274689077369791842e-1146) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.835008561611175537109375), SC_(0.1421767099981648653216354287198064993440984578703213594813652601477915702373642195351993849051038935e-122), SC_(0.4433466932536742341010245725866726427924764930888699154511124712548631101699699061481949648355932349e-1225) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.905791938304901123046875), SC_(0.298858019269062627575202640806018466547335880039171436217152078978529044645241784040551624050656216e-67), SC_(0.4302912112315149668479478913707507921397882476078881327110897753950280572082479742655204690513801732e-1606) }}, 
      {{ SC_(0.00063875340856611728668212890625), SC_(0.9133758544921875), SC_(0.139456102218711708875141870979554379452297019547351606137029613857321058945576300566095331573197826e-61), SC_(0.3722967279193048586273151243612803789662566758954243628128337065898874242714110766785997687377882095e-1663) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.12698681652545928955078125), SC_(0.3636911353163549700481828846437202047662394842560639671377719516246322218140213470369307105316149577e-836), SC_(0.5277003842175730738964234523637928842336426857103517172939274726818627697185579198286277884628995847e-55) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.135477006435394287109375), SC_(0.608681406840184818556962671283859215946482995246082277766118830672764649137516873090522234937994091e-810), SC_(0.5787872129486312445598910001278113860406181973375126228384162537210307678911216065201460866655035651e-59) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.22103404998779296875), SC_(0.1358961275247621619932936567989389579760774814970527979419173359036601365076893330734814754102481618e-611), SC_(0.3443094278735170491727472862019685791797372605756777354390510430208179108157623980508595400183125822e-101) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.308167040348052978515625), SC_(0.6160606832890380935878330309433382797226441857446258120070639898258048174846141324813487571158125995e-477), SC_(0.2962238271406780552439084757135629175683912680406991277734574708116269531527842794576484471201555172e-149) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.6323592662811279296875), SC_(0.1121878105670253144651925010226465353820830037935758546168041328200407250360767463503314579549909518e-185), SC_(0.1958803084188248146286671169689302162382701484363106711288736656461400909819246366412581721629969734e-405) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.814723670482635498046875), SC_(0.5281561525547911086654960077765381038207217825484576875912612245363920784399137086804664497139148268e-83), SC_(0.4257500228385779172178559226641569865858231947343082463820866363553421388529335473275471368837060372e-683) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.835008561611175537109375), SC_(0.4871990510229756393012029517376866933653428447630385204698493526679481624108090602925172311680432997e-73), SC_(0.4414523777811261356627457039049220513512707045266034433295015354579450541298739086187595602928279031e-730) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.905791938304901123046875), SC_(0.4544106096831925883440844414388864898463879116850082772484152477000553099135173255580141883657390329e-40), SC_(0.3790569558904096747865071553590980521152975863683255524137956053935724817360731211745328186192255967e-957) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.9133758544921875), SC_(0.1086162759431365124829677514910516885043104253508798079993173993707145080756341442382449999133012657e-36), SC_(0.3731311425362206946529801716687133821376192736460326608901538020795478287325694488364611177806158989e-991) }}, 
      {{ SC_(0.0010718167759478092193603515625), SC_(0.968867778778076171875), SC_(0.8601148345312941322738150573063841495188261303140333197907871550285714600859919936165421525265718962e-13), SC_(0.8352834206432652444362710861342143756206408334103821708098446058593603133470885322865713545764683793e-1406) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.12698681652545928955078125), SC_(0.147848456885616963723858782577688099464687345497584971907959533932848350397293187566016020419464683e-296), SC_(0.171095196212328617510769493652594858040119887670079283811603189789776654658126040015618071197771285e-19) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.135477006435394287109375), SC_(0.2957040845775463914630038837259432330963758820019079082432109472364649718465076614337825618561161409e-287), SC_(0.6741345202122238953267423202125420728578822656607145823452010405613191732640708785839767750075396765e-21) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.22103404998779296875), SC_(0.6629351131315922881665344686822927576739593099159434514320097662182695263750632548413010637690364644e-217), SC_(0.7114216068371001385039281525729691284058986283072617729662881038438840314208670783902168223858121757e-36) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.308167040348052978515625), SC_(0.3815769167836024805134076416192047910095961222261460332870986405579422427921655027535859716936975843e-169), SC_(0.6371685465093446409752543968505366216352552332836247579191890099605647310988615239262857932799766056e-53) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.6323592662811279296875), SC_(0.7694280395304282847410685434446591615706979969704299031490513282804433883328732698081496647926271541e-66), SC_(0.8752532760684835521550167862674350105051548504587214897847872524825568250927165306635965147698185443e-144) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.814723670482635498046875), SC_(0.2005832956521630211437152667735208325796416832199594115003767245066538476897352327765893343091455703e-29), SC_(0.2886168571056877419355854554209175661893028458797529230518602296422070194886678789038101987943260869e-242) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.835008561611175537109375), SC_(0.6865528229747848189232773661997763248093499850406354042275021912389583061913029394943159696972353458e-26), SC_(0.6250000490477042500136121049490793548266462692265196607061120103479786030609161693776398430368885384e-259) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.905791938304901123046875), SC_(0.3391755135462610074415389891958859539997617901370655933508544831879396613673036144442847305192589105e-14), SC_(0.1818675924626906137616786515393448442910052617644540234110899175508311562676748949563021061222052779e-339) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.9133758544921875), SC_(0.535422015430024406152742721696715286234084249588450655449294177375047451920120879529838516946459663e-13), SC_(0.1578208893318344169144307257243732070782315536202416713146132453636154945574870523695843695112933656e-351) }}, 
      {{ SC_(0.00302191521041095256805419921875), SC_(0.968867778778076171875), SC_(0.1603655936658238507041762864095609991206409637781631862917716472622350223709417432611687870638492434e-4), SC_(0.1347593915139988423589891399900730404555177905402429752776186845477701283560229186139855251364605614e-498) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.12698681652545928955078125), SC_(0.1960043160161097127314765902342028029637100032858359797167497142970577663508673923178770845319031247e-179), SC_(0.8737798725189214432173030452603586609683133445417930658285549865482753254167754675828194725150352446e-12) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.135477006435394287109375), SC_(0.832262148614591833675964023466563010668606253010054406826287456971856701489910398594471111367044182e-174), SC_(0.1234679433161566505478878684685958790961520769448464716935820169690448511156911545087941709206177126e-12) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.22103404998779296875), SC_(0.3082648337777240938387316277514192190638565128784838738703204529112823541784513324193198708181720523e-131), SC_(0.1069809851954365732690433666374001825368669283755370002586551197744912384639257845266311057466705445e-21) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.308167040348052978515625), SC_(0.244474088855515549719549873564983683372478191876556137745925680554692010166727535433513521160309518e-102), SC_(0.5173186755917748102875237344943846806104778231305726111910816409608983162590944495635303589146888933e-32) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.6323592662811279296875), SC_(0.7890682362375343388552652074005659698032703932054665968930029754030761295033810973289026527912295319e-40), SC_(0.5416579185618341885238133713302699218827874081717350730681058553770746092171688571578695678273140255e-87) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.814723670482635498046875), SC_(0.8555746713015471936194648739785852738420437331993712970264442131065331596959785507180943772297766965e-18), SC_(0.1390176915155720203520073171375102444583393444625494006007267413489170702474379749611143944459906321e-146) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.835008561611175537109375), SC_(0.1177296970233201556610850952072859274505621270298597634555491681817196552669783944282273349530020469e-15), SC_(0.1146919928623087651322602095529651080113416847530599334879782421117453132347830595672214998882693604e-156) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.905791938304901123046875), SC_(0.140182115555967781943563614615247496730452325652948114853358198213045387687075435576329039573798008e-8), SC_(0.2126609930456338792647930428291603776712075748226084115023911904315969452254195862487931115193344454e-205) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.9133758544921875), SC_(0.7443178760362183879911334884783828565596407069447100617344709236008251816280960984096876505664882645e-8), SC_(0.1069802641495460304001399364295198727186160551517817761467497440353111514593626989309613100748853985e-212) }}, 
      {{ SC_(0.00499413348734378814697265625), SC_(0.968867778778076171875), SC_(0.001002782701988676408699076824248552804317085346771311231406115185829175623758404483762790928035661549), SC_(0.1094258942968236052477371715322239109504537070196869847801765306094952692940407904732024959605867895e-301) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.12698681652545928955078125), SC_(0.1655490464189179008433039464428648955503509347909130493109522912597237241958388863718497166454003528e-96), SC_(0.2511892383034341936236921608372563719085453780360488901586948806602719227382818898740466381871758172e-6) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.135477006435394287109375), SC_(0.1763243690192028224701803302285803485696184516790561347225377139581977827436522916556354689200859928e-93), SC_(0.8767072859304154424188321298914872141291729196263624314193204640959152058672909133320438239736743333e-7) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.22103404998779296875), SC_(0.1395268386741118006222074665192542100298344858095902215103247576786883530666070051947950447778132896e-70), SC_(0.1169851770326083963924900602686862858269576479470988689778890500266578257470688071876653763458233191e-11) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.308167040348052978515625), SC_(0.4898293707911054311574077227106293209623974966337211669027010089486565032157441679873097914324657413e-55), SC_(0.3305499696480968213607185416034676582433008909848636192837387930427940790932001427167053714152028616e-17) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.6323592662811279296875), SC_(0.2063208559211849039281825369458618894800841778446082486779938762804237213895886089778065430981546666e-21), SC_(0.8802852822646538740098296657571215554542316529460859269157994251482539622501237491021007572223848725e-47) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.814723670482635498046875), SC_(0.1470919725037019237635552858366387887228556925525671168915044276220267359503421807960277057091164595e-9), SC_(0.776040877472254293052049173297864027873371594667142507008915783811615435233212971957026247944556931e-79) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.835008561611175537109375), SC_(0.2079649982498031834679314497053845483208559911665962636114361516063870334336199634428582560062268746e-8), SC_(0.2922761999016211106617308476548265090931319076120766321451356756088374129715949526437709487166989658e-84) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.905791938304901123046875), SC_(0.1331012790246183679135743834382351893703549285142885766206403513477817047693065973960307592401761687e-4), SC_(0.1787215940526454792117473142820444031698541740199406251943516212722643767015148275809527436294486488e-110) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.9133758544921875), SC_(0.3267493528614537466422720595540634632686083105060950626479453284438163732762495648150414813880639496e-4), SC_(0.2119643540026624068095560574572289675469253348800503452347205819265698570952692838016053575548831888e-114) }}, 
      {{ SC_(0.00928423367440700531005859375), SC_(0.968867778778076171875), SC_(0.01911454499897180940600574461593428605776103533603062667536158390175717662005867849433871252039909365), SC_(0.2864580184700468308537655700800823452800619533190012008531407862767381549449468765790714912520439872e-162) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.12698681652545928955078125), SC_(0.4755007874645363599110558709767351843977893430130989448515393790274941468301592450084579104359798493e-37), SC_(0.002082354339089825932206329565555884302753553474844735089128561922487730302732482504729778026642360888) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.135477006435394287109375), SC_(0.6918886567431946298096783699264720693735004847338734244592467556045794852361098879683835025254335118e-36), SC_(0.001388867805417009119772805788800260872877564688995918659271544250894617962361202936059332912226184037) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.22103404998779296875), SC_(0.4323056887999694108538986226121688043701406265432994041704820186098837980771115859968832741829681924e-27), SC_(0.1860339320605454925735763876112536284360047842503928097950223960430000275905577490076862981083123169e-4) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.308167040348052978515625), SC_(0.4046818691422747628420442575861742481670295659400511102375870506457392764732487896821800847991430295e-21), SC_(0.1374462930061820898052244532341899541451017350568010018338622604439808580476436540696464294876730848e-6) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.6323592662811279296875), SC_(0.3334403487278273462708995000148717863585880987029873382051654969321559841649693780064298523870757696e-8), SC_(0.5996222426132679940269665712478111110103185607660464978996991591256898038817448172018892128858363079e-18) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.814723670482635498046875), SC_(0.000119146842104297411410195647734689332434240266032091228469756942817940738201897213037148470615813508), SC_(0.2917106179004315827849745763967763395603781179596286897491731220518611339556296738289059201235850883e-30) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.835008561611175537109375), SC_(0.0003296598495085953197600007054735462149322936071793832995498219578493088389902287308414658719609526215), SC_(0.240680179432773856042893992975635590655015966928265407314049438721986528213955161545013797302730715e-32) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.905791938304901123046875), SC_(0.009639257233815527295558867035539514631954783530626403663078664766509688335853532912815447707238446202), SC_(0.2052189982662066417317642456809545878292289013164262888362290358529165754449803709580684197275536899e-42) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.9133758544921875), SC_(0.01366335082411676503426812795826074384518242194417984302389558300465670193241960017317871044495895392), SC_(0.6370714600531229351028933057209195315039848145972839708393337900673162652220564905279371591735045738e-44) }}, 
      {{ SC_(0.0241700224578380584716796875), SC_(0.968867778778076171875), SC_(0.1837159201614905810162056258214426405625321487490921387042484059797197463584135933859405861689173258), SC_(0.2609647866436712703184614158029656015599386600669142553098944996170824882297464531425702393094308666e-62) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.12698681652545928955078125), SC_(0.2397899327990210217945237520825027337249314580313255742558188735539395128771207466059933105586895801e-14), SC_(0.07120701321639861672730146751403337388636080685060784427795166211560688546973978967036189875632652293) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.135477006435394287109375), SC_(0.6778734704727671347342116967926882030572723270331607054064451043360812010149557098744948382614825263e-14), SC_(0.0602598946592406336119407298808692659798985080384884708169987555922877323792632867174236488785352996) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.22103404998779296875), SC_(0.1757099850202481753365993363784463387895171833664242008187350899141562237968228296765150189320156787e-10), SC_(0.01079979944341924186567270403124714866300331562834978093084682499332166135923522216838671914449270537) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.308167040348052978515625), SC_(0.3649868926413298954597242228102928635484611330522144836339322839539995144414369520388754117706224566e-8), SC_(0.001593832313978824373841228238392792687053408246667296219192610926752720622826899515687015871804115245) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.6323592662811279296875), SC_(0.0003759378444055722004393091547465790970598302895163681174960437738413745696703445203741128560602699408), SC_(0.620663696267368847712486628823225913460097237421094388671496629889791298720503745367324748584589878e-7) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.814723670482635498046875), SC_(0.02244525653614308575166234088544520546682935745920844279908975238875123978052118225748359171330777621), SC_(0.1033209496324995312394536082618363029550794625250363550205517988108214448200453624621398598435440588e-11) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.835008561611175537109375), SC_(0.03366297028171611386194115325176788755923911705829073649633441589027105713823007866451109874918512119), SC_(0.1605364929455264787114516115080877998259339545160954415146706494593817189910643046804862406563564714e-12) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.905791938304901123046875), SC_(0.1364621766813123240886509793644182139045421711802239650823084181353667509638804410042704091269570725), SC_(0.1984681397504802198491518881783777375428173303278723680821020335210268994608425059813305321120655523e-16) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.9133758544921875), SC_(0.1591608584445551963160497158932417610236433064038886581960065666630258912420826090955653336410218449), SC_(0.5157294656561139161954148813029084251160461862581303116626804550120502686536232501755415069309872419e-17) }}, 
      {{ SC_(0.06227754056453704833984375), SC_(0.968867778778076171875), SC_(0.5706002148003562024675967419933014645545890498671384246800047121502078763524393136100895070887797336), SC_(0.3768424261625840088916808672832463019346092796851739497972854069623289031307295120933948388504211193e-24) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.12698681652545928955078125), SC_(0.2917675307501393521701978150767907941177672065924891118886771405922859641487784147377516025455036611e-7), SC_(0.2517816799209477962363003293087745830790228944794038153990714298608834385644019377723297301562319997) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.135477006435394287109375), SC_(0.4951921240548201466128564350442795757511483177015364955526498903315672696072305721738250316807749574e-7), SC_(0.2280442905035761762923559006699423406008704100991080659489091811281903247498659142591476392432592615) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.22103404998779296875), SC_(0.2706717505606267935694731130362165880760688816561270736754737057060064757656659854697456655231479473e-5), SC_(0.08645181696960127763637910697972952172197582371166841825995565932382970348564883168236139813751067668) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.308167040348052978515625), SC_(0.4093906422833465436981126725371850110509069113389089805389022397880079259780593912997598414514220272e-4), SC_(0.03124990161065573210878608715524591895346977134693932986982763272382549307224120618970522438192567651) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.6323592662811279296875), SC_(0.01477255849190767130779562374978723722972978808603632058750592869480763133679527762735482893972319478), SC_(0.000173219831271877948335919727039453409963192313806313058514400053226735134702002657874262377409902787) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.814723670482635498046875), SC_(0.129415374554952745238873579421907728426509370328753351224524538118079768076343431913946929256485204), SC_(0.6397626082313879266032436450179293886393687263809287504956339699519759176544626231100692136549418162e-6) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.835008561611175537109375), SC_(0.1627069901465925782476277536170875116551881920701025682482514156908382545100679746811024237068067437), SC_(0.2479733987223831941645449344880068288689764125534241367620317091635352758643470859110836758891192526e-6) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.905791938304901123046875), SC_(0.3746570524495683716297648401889196783384938577123039192797117912526722651515732395049765693698250817), SC_(0.25418712058635408057485797010041189197820679325299203243431788140961048909196552468074745837786707e-8) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.9133758544921875), SC_(0.412853358728883540335684676442114700846244749719956087902593838515602643671959687316038985526993008), SC_(0.1280061610273510933442845630496168781419537462499944407703238655882648749223650289571066805558939821e-8) }}, 
      {{ SC_(0.12234418094158172607421875), SC_(0.968867778778076171875), SC_(0.9787395191154988075727958715091047710612825668286193391649260163898336068888458362682012849227767468), SC_(0.2982768579322194458377853985166850512910908875750207565713660271136890844136108584112462230664399033e-12) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.12698681652545928955078125), SC_(0.0001729408351181867910946777042168593367548662713933245021197087415434496992696779200097194108839751772), SC_(0.6058065114765388482746593313053712216441947551322497986044088489348997208319848176297434342507600095) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.135477006435394287109375), SC_(0.0002241519102773175611138507396325277413617429480537538878667053083065425094634883159191144605357025743), SC_(0.5686151078349344771031971471375403354721955451594154977603352348538687391850162271158335444249182502) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.22103404998779296875), SC_(0.001595513616070568082945733861157891219132405526763081139868004533247647856388162004166813696766457559), SC_(0.3147499587257283286475843117673594550769668592417932063266241383313864709137053311821198619187683608) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.308167040348052978515625), SC_(0.00606433025279873579205212606109071114127470924946480443259120078597516628484655194478033626742976614), SC_(0.1768484195007227594639307057959930790280552286720308691454989394878960902793946976587308560031007614) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.6323592662811279296875), SC_(0.1179650561324075528992903225848147868756942682237052177942740819154402285791230618097441178197346836), SC_(0.01236110428029709405738994179320427104939420622715812133883147446465408347949113875328822633417557986) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.814723670482635498046875), SC_(0.400151158756360458015567018815432047279722583669528746897688264440309636295972485089031983723283412), SC_(0.0007861746132015000429054089584735092797147631741298395907804200517411522207698314297448948558866196851) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.835008561611175537109375), SC_(0.4601999712924982214723189551339248465295920458859026091046158869079649628640804304809932234086055938), SC_(0.0004938855303788196215081660872846070867835696427546516959680290298943434193317649163521301815172286175) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.905791938304901123046875), SC_(0.7863273330252674862553211767967663339038620678631034425070423080693867453252930911164808313360712789), SC_(0.5227018174999379781325549887500215561917168025603780836048065324690864016337897961000989515342940514e-4) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.9133758544921875), SC_(0.8394599392779975917886333392575163813801180770789039686433252648275481430070794506158735659303587734), SC_(0.373416915384257863268132774848812007558194713642029410373736507955136046937608139895733790842501857e-4) }}, 
      {{ SC_(0.249557673931121826171875), SC_(0.968867778778076171875), SC_(1.55064806934047311003207497740233507495138893446973652339146361951925002802326377196566679899437148), SC_(0.6184646854163605575571198689399195255548852029735399215689599364527250064463808853546125834736909896e-6) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.12698681652545928955078125), SC_(0.01179999107261517245711734099321175262024322427536111722579792130430795039352225923732875696993108428), SC_(1.146781836673227294411343111549562570916875706944764995205279614934161942445271463984045188893154299) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.135477006435394287109375), SC_(0.01347680005190320824495823024041006258683054239049315292957407436091912784252503889850706106759795736), SC_(1.096942250682153278684991315434251167577990808568885211432970704705260534839722679246736760333818943) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.22103404998779296875), SC_(0.03708520794937207522186672453116934049416336908087963757400656366527415843223106807566187232395132201), SC_(0.7344037228018428936575252313749151692350999140334190669972342222354811281015168203457623869931078542) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.308167040348052978515625), SC_(0.07478742727324340023924529268137294447621068928026302313998618370705089690325624388285052260444738011), SC_(0.5072769867657609723634022984671279306427119801795633218278005114955827886141591769523944577356036436) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.6323592662811279296875), SC_(0.3953171167684806306534848834776653918978703258364788601641198779145343529360607023155841561486426645), SC_(0.109578577521261759574470587827775876258571564613747898905893349199828070364291298956570023636768712) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.814723670482635498046875), SC_(0.8618371340044833635042625236072247947308509234411487597503367932617905474216131811383046338270875832), SC_(0.02569772935484207748733320472091277906568494161356221491003849767356138577033550982833478767012837521) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.835008561611175537109375), SC_(0.9476842240184136859307262864949749166429256547788236967883289180092048583992256579829649775781823206), SC_(0.02022053428062083343451168294283034061825836977269227995602870747330949523633259645412512218564920562) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.905791938304901123046875), SC_(1.381314413433676218467699682079044981314837640289108871721622988665626514901418026268181070806111036), SC_(0.006402331141621925056309776927986094705654962508389581644459273015513266189369824070944290374038869035) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.9133758544921875), SC_(1.448461572346433145360514343830741564296392068240940782414163508296712759466650758570012073033272854), SC_(0.005393166618371413394786517538957208033588291043828844982680610840509081671962397142463259898605996501) }}, 
      {{ SC_(0.4912221431732177734375), SC_(0.968867778778076171875), SC_(2.299409064705521016627903698738797581220994757567875712087173923100290229883609182069652360326866461), SC_(0.0006694654532903551129656895216820134077743882676845908130412730599807742046809248198170530713447012925) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.12698681652545928955078125), SC_(0.1300865209797978009611003366610743995514124740108418385537521536106018623459854247310684557849847687), SC_(2.036896200379561213501874139309458592947234601319775884090713507340264351528872950487005758646207935) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.135477006435394287109375), SC_(0.1395829226113829891435096741354384020592989338540723970248168770387345584112813716003266402943853755), SC_(1.972552833831994436489598853128590709158018223550733538669371676665645607547765638731949845618031393) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.22103404998779296875), SC_(0.2412437977716976045954882142417206791924761869351292722918142258325655122194763458892634152440282245), SC_(1.486224027390307085209986844630573195115591634524152964679847584925193743814224125373700119038244969) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.308167040348052978515625), SC_(0.3575421924486699356512901533090120279494834496884211357613510920578191227799117437490364969176278163), SC_(1.156527249018123010464132374104159226728074378519382156883176440049944289231061307726399588963058722) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.6323592662811279296875), SC_(0.9816778040333153178137781120254196899483430716435981660166706033854220130522757086424990534201280296), SC_(0.4459263447286624679587744473404218936951315402087647021239688398243113362620390857394257313770054111) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.814723670482635498046875), SC_(1.661464996668627130855290643255035440441499138648602749033150402448170379975136041600286371505899699), SC_(0.1973842177852939019187662485373855176042953236532691014309227330439358378741590741665845889544778929) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.835008561611175537109375), SC_(1.776664519389033661206657687644212685971548384346483465773471835840005596288706546336952088459026359), SC_(0.1733964237505148001035729206684791920003990301710305875667203952803542363026077727667244276279610638) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.905791938304901123046875), SC_(2.333852143635521376583793983692908814613192084965131921329017568999597890042223066845782144217922465), SC_(0.09435362597956357997061362628518451467157237178561681585971236159384562553245746245889310005227828882) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.9133758544921875), SC_(2.41735263767090747971260704531768202019608204175812596889647915502861830149843901420023178185417741), SC_(0.08629255050864682671649867071997131498616075967670496930252659364507806875769843248265733981572531032) }}, 
      {{ SC_(0.98384749889373779296875), SC_(0.968867778778076171875), SC_(3.436253151819984400291457916536771641870461027576351440827763253405081072658046821073614339302446642), SC_(0.02964617137949879954381330114002840099655920244775355918800888626052539050791751092644824550473072238) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.12698681652545928955078125), SC_(0.1961597199596110836046664721317916790262358259807835627296587002411859510266149879619131918396954485), SC_(2.319857526146669037115512146164428411482810737120759704818839078699515280121389085412692614348323684) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.135477006435394287109375), SC_(0.2086026822959099028941961321444015576693556939552300221090416229088808015997654853572663008921540919), SC_(2.251670804133435855479603883114774229816437238705176879719208679742380410079052189608090638334395607) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.22103404998779296875), SC_(0.3371312094790078671149170215056280742083287741053022101420790076691424633947120671151876658557000782), SC_(1.732748523226939946628109548933145149536078319881314826752836811320235271086811601900328572024213373) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.308167040348052978515625), SC_(0.4775817406294980404134846983877619770010791609168563211507672961242214485064567317986485188899638172), SC_(1.376193097486225353718357273680712792723104402765586947203626851859979776481513296632647074490421153) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.6323592662811279296875), SC_(1.184845656449188886352302784801892366172678989733029483747236713715732719740072708913716549478085946), SC_(0.581471881382274003173880196210362036321484761408550346865366600573915568145720619039301125333373905) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.814723670482635498046875), SC_(1.920539558256590476431015528402948661755409409849878156031124007205305267835713939520863868659293583), SC_(0.2825606964816580505745168928365791801298476249315711294705870608100276597000213174366186220948389055) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.835008561611175537109375), SC_(2.043465440456490166287792059985063689775983483070329577212861593741459296558139325833073673463732894), SC_(0.2521961993473725269543103190526000592848006826712668650609107713979225891789595253816913570458321053) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.905791938304901123046875), SC_(2.633432043738438920475686365204867279535715696108322078844743253044475088750509042564699876424341881), SC_(0.1483234119621405878414264034510012616620586207451637965494203477538978586659149769842382367332429083) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.9133758544921875), SC_(2.72130872698585367980892827768093808349422735039784935732743888146428407234271507560375936478000293), SC_(0.1372597171858880965660262090243239004065344795529468715964073094745543966462191632895815182745602503) }}, 
      {{ SC_(1.1576130390167236328125), SC_(0.968867778778076171875), SC_(3.785791973663415980437557813576367686468274240280844818238132947111766562677797108571092977222954148), SC_(0.05460369537686154741964828809285588189958375691729530341605824976415924863104037841047769736294474202) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.12698681652545928955078125), SC_(1.530624210920382284399051690330519554082768377808227128434910351585439262396314857365872406127756053), SC_(5.574698692018694700071254764468530910674337221105810057056140063183708253803233221537898874285968149) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.135477006435394287109375), SC_(1.57362951537156159661431963850316197825725692404254310133476110219497865497181922972348704221144267), SC_(5.473138259331420669341549290189455776876089291573320486520460515454004459005991000402878126742323236) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.22103404998779296875), SC_(1.965746189751920939352691371708867882866485644934665910275215637276934063111994360502170024656532926), SC_(4.673268932629649290920788790871645128427792301349128507557725406338670163075890517015361340870973159) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.308167040348052978515625), SC_(2.327895119537809122811571079104146373091942499322663334330138868463649582849214297599497785464023609), SC_(4.087212616619640052827803625327882426668270211845906555717997902681324813869427584063421609836271661) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.6323592662811279296875), SC_(3.75528141373881029632814630875677475329797026383089604597730893204313705777013022465404183283606387), SC_(2.569587565718771610879334081961858540627292872731864015723807479426770255861746498923235709828384543) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.814723670482635498046875), SC_(4.96884003357348744166695303018087322225920527947015852633041450072604536715189275307836871232572009), SC_(1.808854082468155248893602071807914212511204947986080304490964939078875022325577669885755397028389777) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.835008561611175537109375), SC_(5.158353930264407591141911762793226010112593356998663398064398144517377920081089377422910049379929565), SC_(1.715980010073803534303771366139081776620894782167054529829701347745407112585687815364593264795112742) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.905791938304901123046875), SC_(6.033289965252111343235548988260081149382205549483973493795976997290232926915123620068323107608683628), SC_(1.352275181601738349544903018712053305322415074737749256814106096094379708637873120535301778996625571) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.9133758544921875), SC_(6.159558502218759156855593347123796639713710181006289624265126514849066440847214437545387207874425825), SC_(1.307343882589167249227348096476723299076394367682521236029969747367006850476646265679909563475382611) }}, 
      {{ SC_(3.451677799224853515625), SC_(0.968867778778076171875), SC_(7.629721526111596714926608293951817133394478840350583630509809227411335042302400047948310886098339447), SC_(0.8888562589855856249970510117949218013780557896569702678778170096314482315508385771830674194073130007) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.12698681652545928955078125), SC_(4.844756913723969959067287277171911999837470793758606581225223922671033928947591753701039975119122724), SC_(11.12140061565551307712696521346785564818459658303388261577657023731780253761925900663967051291410247) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.135477006435394287109375), SC_(4.92589841429445857984116213454195626941969554762437568942405393109061358846779703244707367287195874), SC_(10.98108673974325765715303476569448043717025909739070272421996079460616793044380919148069611984481183) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.22103404998779296875), SC_(5.638560786091699351123899548104079140326479351812437435515873530054583524774506292906280460797833098), SC_(9.856971749403947096825033526804503350139699007114203432014510548601579942970233052344921183682478769) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.308167040348052978515625), SC_(6.261950304915309281829468403028535426991401847081170989871860432142896140500397036811479661870310452), SC_(9.008089510076067200136139130648726551693948927672843011870424870503873689961795526187249783039453752) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.6323592662811279296875), SC_(8.515696299640880133197109983199329596272030624087086595627597017830637055606241372115218386957077541), SC_(6.663555576689267756072158572952790106439493579837933095211305263932099060610857357449696082841290954) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.814723670482635498046875), SC_(10.27654630671120554490045038357659906211059116424349156516366240949281281132412336553759708614503569), SC_(5.358806007367185234198567710812204619111113995842409126062778294563755657191876758668190895570062463) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.835008561611175537109375), SC_(10.54290123180201991341358069212563540909069376048726692932615624195393691868675916167585864103920169), SC_(5.189957597342458441237551570990662655102247885622660703905796425516481457633806742834164945056029809) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.905791938304901123046875), SC_(11.74906177063792723279214648184444217353993726634172219771095374095196747935628306762462714050027469), SC_(4.500589730419825679581934453582185709058743448290168867874541939460911484143125315702278379652817014) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.9133758544921875), SC_(11.92028503924933449320581621786613441617387709458224965565099431099659181938764039147894571145926575), SC_(4.411739446802953797688885844731597182665766011787872803903470630812608976887737596597075028566679532) }}, 
      {{ SC_(7.88237094879150390625), SC_(0.968867778778076171875), SC_(13.87112145371288914260504318784118251728461784612328590191541928786695318093130503135200110507250744), SC_(3.529662237308642030515257624627728599863992204849868392777953155280407948755004639499026009930636495) }}
   } };

