#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Form functionality tests.
#
# $Id: form.py 8871 2007-03-14 00:29:57Z andrewm $

import unittest
import albatross
import albatross_test
import time

class InputCase(albatross_test.AlbatrossTestCase):
    template_dir = "form"

    def check_input_text(self):
        self.ctx.locals.spam = "canned meat product"
        self.html_test("input-text.html", '<input name="spam" value="canned meat product" />')

    def check_input_text_escaping(self):
        self.ctx.locals.spam = '&<>"'
        self.html_test("input-text.html", '<input name="spam" value="&amp;&lt;&gt;&quot;" />')

    def check_input_text_zero(self):
        self.ctx.locals.spam = 0
        self.html_test("input-text.html", '<input name="spam" value="0" />')

    def check_input_text_expr(self):
        self.ctx.locals.str = "canned meat product"
        self.html_test("input-text-expr.html", '<input name="spam" value="canned meat product" />')

    def check_input_text_expr_escaping(self):
        self.ctx.locals.str = '&<>"\''
        self.html_test("input-text-expr.html", '<input name="spam" value="&amp;&lt;&gt;&quot;&#39;" />')

    def check_input_nameexpr_text(self):
        self.ctx.locals.str = 'spam'
        self.ctx.locals.num = 69
        self.ctx.locals.spam_69 = 'canned meat product'
        self.html_test("input-nameexpr-text.html", '<input type="text" name="spam_69" value="canned meat product" />')

    def check_input_password(self):
        self.html_test("input-password.html", '<input type="password" name="pwd" value="secret" />')

    def check_input_radio(self):
        self.ctx.locals.swallow = 'African'
        self.html_test("input-radio.html", """\
<input type="radio" name="swallow" value="African" checked />
<input type="radio" name="swallow" value="European" />
""")

    def check_input_radio_expr(self):
        self.ctx.locals.str = 'African'
        self.html_test("input-radio-expr.html", """\
<input type="radio" name="swallow" value="African" checked />
<input type="radio" name="swallow" value="European" />
""")

    def check_input_radio_valueexpr(self):
        self.ctx.locals.str = 'African'
        self.html_test("input-radio-valueexpr.html", """\
<input type="radio" name="swallow" value="African" checked />
""")

    def check_input_checkbox(self):
        self.ctx.locals.selected = ['two','four']
        self.ctx.locals.vexpr = 'four'
        self.html_test("input-checkbox.html", """\
<input type="checkbox" name="nums" value="one" />
<input type="checkbox" name="nums" value="two" checked />
<input type="checkbox" name="nums" value="three" />
<input type="checkbox" name="nums" value="four" checked />
""")

    def check_missing_multiple(self):
        self.test_raise("missing-multiple.html")

    def check_illegal_multiple(self):
        self.test_raise("illegal-multiple.html")

    def check_defined_single(self):
        self.test_raise("defined-single.html")

    def check_defined_multiple(self):
        self.test_raise("defined-multiple.html")

    def check_multiple_mixed_implicit(self):
        self.test_raise("multiple-mixed-implicit.html")

    def check_missing_name(self):
        self.test_raise("missing-name.html")

    def check_null_name(self):
        self.test_raise("null-name.html")

class InputSuite(unittest.TestSuite):
    test_list = (
        "check_input_text",
        "check_input_text_escaping",
        "check_input_text_zero",
        "check_input_text_expr",
        "check_input_text_expr_escaping",
        "check_input_nameexpr_text",
        "check_input_password",
        "check_input_radio",
        "check_input_radio_expr",
        "check_input_radio_valueexpr",
        "check_input_checkbox",
        "check_missing_multiple",
        "check_illegal_multiple",
        "check_defined_single",
        "check_defined_multiple",
        "check_multiple_mixed_implicit",
        "check_missing_name",
        "check_null_name",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(InputCase, self.test_list))


class SelectCase(albatross_test.AlbatrossTestCase):
    template_dir = "form"

    def check_select(self):
        self.ctx.locals.sel = 'spam'
        self.html_test("select.html", '<select name="sel"><option selected>spam</option><option>eggs</option></select>')

    def check_select_evaluate(self):
        self.ctx.locals.sel = 'spam'
        self.ctx.locals.val = 'spam'
        self.html_test("select-evaluate.html", '<select name="sel"><option selected>spam</option><option>eggs</option></select>')

    def check_select_value(self):
        self.ctx.locals.sel = 'spam'
        self.html_test("select-value.html", '<select name="sel"><option value="spam" selected>canned meat product</option><option>eggs</option></select>')

    def check_select_for(self):
        self.ctx.locals.sel = 'eggs'
        self.ctx.locals.values = 'spam', 'eggs'
        self.html_test("select-for.html", '<select name="sel"><option>spam</option><option selected>eggs</option></select>')

    def check_select_for_pair(self):
        self.ctx.locals.sel = 'eggs'
        self.ctx.locals.values = ('spam', 'canned meat product'), 'eggs'
        self.html_test("select-for.html", '<select name="sel"><option value="spam">canned meat product</option><option selected>eggs</option></select>')

    def check_select_for_label(self):
        self.ctx.locals.sel = 'eggs'
        self.ctx.locals.values = ('spam', 'canned meat product'), ('eggs', None)
        self.html_test("select-for-label.html", '<select name="sel"><option value="spam">canned meat product</option><option selected>eggs</option></select>')

    def check_select_for_content(self):
        self.ctx.locals.sel = 'eggs'
        self.ctx.locals.values = ('spam', 'canned meat product'), ('eggs', '')
        self.html_test("select-for-content.html", '<select name="sel"><option value="spam">canned meat product</option><option selected>eggs</option></select>')

    def check_select_select(self):
        self.test_raise('select-select.html')

    def check_bare_option(self):
        self.test_raise('bare-option.html')

    def check_select_name_expr(self):
        self.ctx.locals.val = 'spam'
        self.html_test("select-name-expr.html", '<select name="sel"><option selected>spam</option><option>eggs</option></select>')

    def check_select_optionexpr(self):
        self.ctx.locals.sel = '3'
        self.ctx.locals.opt = range(5)
        self.html_test("select-optionexpr.html", """\
<select name="sel"><option>0</option>
<option>1</option>
<option>2</option>
<option selected>3</option>
<option>4</option>
</select>""")

    def check_select_optionexpr_pairs(self):
        self.ctx.locals.sel = '2'
        self.ctx.locals.pairs = [(1, 'Spam'), (2, 'Eggs'), (3, 'Bacon')]
        self.html_test("select-optionexpr-pairs.html", """\
<select name="sel"><option value="1">Spam</option>
<option selected value="2">Eggs</option>
<option value="3">Bacon</option>
</select>""")

    def check_select_optionexpr_escaping(self):
        self.ctx.locals.sel = '<'
        self.ctx.locals.opt = ['&', '<', '>', '"']
        self.html_test("select-optionexpr.html", """\
<select name="sel"><option>&amp;</option>
<option selected>&lt;</option>
<option>&gt;</option>
<option>&quot;</option>
</select>""")

    def check_select_optionexpr_pair_escaping(self):
        self.ctx.locals.sel = '<'
        self.ctx.locals.pairs = [('&', '&'), ('<', '<'), ('>', '>'), ('"', '"')]
        self.html_test("select-optionexpr-pairs.html", """\
<select name="sel"><option value="&amp;">&amp;</option>
<option selected value="&lt;">&lt;</option>
<option value="&gt;">&gt;</option>
<option value="&quot;">&quot;</option>
</select>""")

class SelectSuite(unittest.TestSuite):
    test_list = (
        "check_select",
        "check_select_evaluate",
        "check_select_value",
        "check_select_for",
        "check_select_for_pair",
        "check_select_for_label",
        "check_select_for_content",
        "check_select_select",
        "check_bare_option",
        "check_select_name_expr",
        "check_select_optionexpr",
        "check_select_optionexpr_pairs",
        "check_select_optionexpr_escaping",
        "check_select_optionexpr_pair_escaping",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(SelectCase, self.test_list))


class TextareaCase(albatross_test.AlbatrossTestCase):
    template_dir = "form"

    def check_textarea(self):
        self.html_test("textarea.html", '<textarea name="msg">content\n</textarea>')

    def check_textarea_fromapp(self):
        self.ctx.locals.msg = "content\n"
        self.html_test("textarea-fromapp.html", '<textarea name="msg">content\n</textarea>')

    def check_textarea_fromapp_escaping(self):
        self.ctx.locals.msg = '&<>"'
        self.html_test("textarea-fromapp.html", '<textarea name="msg">&amp;&lt;&gt;&quot;</textarea>')


class TextareaSuite(unittest.TestSuite):
    test_list = (
        "check_textarea",
        "check_textarea_fromapp",
        "check_textarea_fromapp_escaping",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(TextareaCase, self.test_list))


class FormCase(albatross_test.AlbatrossTestCase):
    template_dir = "form"

    def check_nested_form(self):
        self.test_raise("nested-form.html")


class FormSuite(unittest.TestSuite):
    test_list = (
        'check_nested_form',
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(FormCase, self.test_list))
        self.addTest(InputSuite())
        self.addTest(SelectSuite())
        self.addTest(TextareaSuite())

def suite():
    return FormSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
