#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test iterator constructs.
#
# $Id: iterator.py 8878 2007-03-14 05:38:02Z andrewm $

import unittest
import albatross
import albatross_test

class IteratorCase(albatross_test.AlbatrossTestCase):
    template_dir = "iterator"

    def check_iterator(self):
        self.html_test("iterator.html", "01234")

    def check_var(self):
        self.html_test("var.html", "01234")

    def check_vars(self):
        self.html_test("vars.html", "0516273849")

    def check_anonymous(self):
        self.html_test("anonymous.html", "aaaaa")

    def check_nested(self):
        self.html_test("nested.html", "000102101112")

    def check_precreate(self):
        self.ctx.locals.i = albatross.ListIterator()
        self.ctx.locals.i.set_sequence(range(5))
        self.html_test("precreate.html", "01234")

    def check_unclosed(self):
        self.test_raise("unclosed.html")

    def check_missingname(self):
        self.test_raise("missingname.html")

    def check_noseq(self):
        self.test_raise("noseq.html")

    def check_colsdown(self):
        self.html_test("down.html", "+035+146+2+")

    def check_colsacross(self):
        self.html_test("across.html", "+012+345+6+")

    def check_paging(self):
        # Fields are:
        #  i.pagesize()
        #  i.has_prevpage()
        #  i.has_nextpage()
        #  i.index()
        #  i.start()
        #  i.count()
        #  i.value()
        self.html_test("paging.html", 
                            "3 False True 0 0 0 0\n"
                            "3 False True 1 0 1 1\n"
                            "3 False True 2 0 2 2\n")
        self.ctx.locals.i.set_backdoor('nextpage', 'nextpage,i')
        self.expect_html(   "3 True True 3 3 0 3\n"
                            "3 True True 4 3 1 4\n"
                            "3 True True 5 3 2 5\n")
        self.ctx.locals.i.set_backdoor('nextpage', 'nextpage,i')
        self.expect_html(   "3 True False 6 6 0 6\n"
                            "3 True False 7 6 1 7\n"
                            "3 True False 8 6 2 8\n")
        self.ctx.locals.i.set_backdoor('prevpage', 'prevpage,i')
        self.expect_html(   "3 True True 3 3 0 3\n"
                            "3 True True 4 3 1 4\n"
                            "3 True True 5 3 2 5\n")


class IteratorSuite(unittest.TestSuite):
    test_list = (
        "check_iterator",
        "check_var",
        "check_vars",
        "check_anonymous",
        "check_nested",
        "check_precreate",
        "check_unclosed",
        "check_missingname",
        "check_noseq",
        "check_colsdown",
        "check_colsacross",
        "check_paging",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(IteratorCase, self.test_list))

def suite():
    return IteratorSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
