/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:58:54 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.WorkingGZIPInputStream;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class WorkingGZIPInputStream_ESTest extends WorkingGZIPInputStream_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      byte[] byteArray0 = new byte[9];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(byteArrayInputStream0, (byte)9);
        fail("Expecting exception: ZipException");
      
      } catch(Throwable e) {
         //
         // Not in GZIP format
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream((InputStream) null, (-1372));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      byte[] byteArray0 = new byte[3];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (-1772), (byte)28);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(byteArrayInputStream0, (byte)87);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1772
         //
         verifyException("java.io.ByteArrayInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      PipedInputStream pipedInputStream0 = new PipedInputStream(42);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(pipedInputStream0, 42);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (-2435), (byte) (-64));
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(byteArrayInputStream0, (byte)1);
        fail("Expecting exception: EOFException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      byte[] byteArray0 = new byte[6];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(byteArrayInputStream0);
        fail("Expecting exception: ZipException");
      
      } catch(Throwable e) {
         //
         // Not in GZIP format
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream((InputStream) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test7()  throws Throwable  {
      byte[] byteArray0 = new byte[7];
      ByteArrayInputStream byteArrayInputStream0 = new ByteArrayInputStream(byteArray0, (-1531), (byte)0);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(byteArrayInputStream0);
        fail("Expecting exception: EOFException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.zip.GZIPInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test8()  throws Throwable  {
      Enumeration<ByteArrayInputStream> enumeration0 = (Enumeration<ByteArrayInputStream>) mock(Enumeration.class, new ViolatedAssumptionAnswer());
      doReturn(false).when(enumeration0).hasMoreElements();
      SequenceInputStream sequenceInputStream0 = new SequenceInputStream(enumeration0);
      DataInputStream dataInputStream0 = new DataInputStream(sequenceInputStream0);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(dataInputStream0, (-2789));
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // buffer size <= 0
         //
         verifyException("java.util.zip.InflaterInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test9()  throws Throwable  {
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream((InputStream) null);
      WorkingGZIPInputStream workingGZIPInputStream0 = null;
      try {
        workingGZIPInputStream0 = new WorkingGZIPInputStream(bufferedInputStream0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Stream closed
         //
         verifyException("java.io.BufferedInputStream", e);
      }
  }
}
