/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:29:59 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import htsjdk.variant.vcf.VCFHeader;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.PipedReader;
import java.text.CharacterIterator;
import javax.accessibility.AccessibleContext;
import javax.swing.JColorChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Level;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.GotoEventSource;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.components.BasePlotGroup;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class AminoAcidSequence_ESTest extends AminoAcidSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test000()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertFalse(string1.equals((Object)string0));
      assertEquals("Thr", string1);
      assertNotNull(string1);
      
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', ';');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('(');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("x)]ru^jkDJ*", false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertEquals(12, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  ", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getSymbolIndex('N');
      assertFalse(int1 == int0);
      assertEquals(2, int1);
      
      int int2 = AminoAcidSequence.getAminoAcidType('C');
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      assertEquals(4, int2);
  }

  @Test(timeout = 4000)
  public void test001()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("bw'x-k4O0-tl", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".  .  .  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(12, aminoAcidSequence0.length());
      
      int int0 = AminoAcidSequence.getSymbolIndex('#');
      assertEquals(21, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test002()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('O');
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('3', 'O', '3');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test003()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("feature_labels");
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      Short short0 = new Short((short) (-27006));
      assertEquals((short) (-27006), (short)short0);
      assertNotNull(short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 7, short0, (Integer) 2);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertNotNull(partialSequence0);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short) (-27006), (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getGCount());
      
      Bases bases0 = new Bases(partialSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short) (-27006), (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getGCount());
      
      Clipboard clipboard0 = new Clipboard("feature_labels");
      assertNotNull(clipboard0);
      assertEquals("feature_labels", clipboard0.getName());
      
      DataFlavor dataFlavor0 = DataFlavor.allHtmlFlavor;
      assertNotNull(dataFlavor0);
      assertFalse(dataFlavor0.isRepresentationClassReader());
      assertFalse(dataFlavor0.isFlavorJavaFileListType());
      assertFalse(dataFlavor0.isRepresentationClassInputStream());
      assertFalse(dataFlavor0.isRepresentationClassRemote());
      assertEquals("html", dataFlavor0.getSubType());
      assertFalse(dataFlavor0.isRepresentationClassCharBuffer());
      assertEquals("text/html", dataFlavor0.getHumanPresentableName());
      assertTrue(dataFlavor0.isRepresentationClassSerializable());
      assertEquals("text", dataFlavor0.getPrimaryType());
      assertEquals("text/html; document=all; class=java.lang.String; charset=Unicode", dataFlavor0.getMimeType());
      assertFalse(dataFlavor0.isRepresentationClassByteBuffer());
      
      boolean boolean0 = clipboard0.isDataFlavorAvailable(dataFlavor0);
      assertFalse(boolean0);
      assertEquals("feature_labels", clipboard0.getName());
      assertFalse(dataFlavor0.isRepresentationClassReader());
      assertFalse(dataFlavor0.isFlavorJavaFileListType());
      assertFalse(dataFlavor0.isRepresentationClassInputStream());
      assertFalse(dataFlavor0.isRepresentationClassRemote());
      assertEquals("html", dataFlavor0.getSubType());
      assertFalse(dataFlavor0.isRepresentationClassCharBuffer());
      assertEquals("text/html", dataFlavor0.getHumanPresentableName());
      assertTrue(dataFlavor0.isRepresentationClassSerializable());
      assertEquals("text", dataFlavor0.getPrimaryType());
      assertEquals("text/html; document=all; class=java.lang.String; charset=Unicode", dataFlavor0.getMimeType());
      assertFalse(dataFlavor0.isRepresentationClassByteBuffer());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("feature_labels", clipboard0.getName());
      
      Marker marker0 = selection0.getHighestBaseOfSelection();
      assertNull(marker0);
      assertEquals("feature_labels", clipboard0.getName());
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNull(markerRange0);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short) (-27006), (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getGCount());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("a8{\"", true);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('S');
      assertEquals(15, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType(' ');
      assertFalse(int1 == int0);
      assertEquals(7, int1);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(bases0.letter_index, false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short) (-27006), (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("s  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      boolean boolean1 = aminoAcidSequence2.containsStopCodon();
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short) (-27006), (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("s  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: _
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test004()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("FpH55Y9k7-5\"Kg/");
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('X', 'Q', '|');
      assertTrue(char1 == char0);
      assertEquals('.', char1);
      
      char[] charArray0 = new char[8];
      charArray0[0] = '.';
      charArray0[1] = 'X';
      charArray0[2] = '|';
      charArray0[3] = 'X';
      charArray0[4] = '.';
      charArray0[5] = '.';
      charArray0[6] = 'Q';
      charArray0[7] = 'X';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {'.', 'X', '|', 'X', '.', '.', 'Q', 'X'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('@');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: @
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test005()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("x)]ru^jkDJ*", false);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getSymbolIndex('C');
      assertFalse(int1 == int0);
      assertEquals(4, int1);
      
      AminoAcidSequence.setGeneCode();
      int int2 = AminoAcidSequence.getSymbolIndex('N');
      assertFalse(int2 == int0);
      assertFalse(int2 == int1);
      assertEquals(2, int2);
  }

  @Test(timeout = 4000)
  public void test006()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertFalse(string1.equals((Object)string0));
      assertEquals("Thr", string1);
      assertNotNull(string1);
      
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', ';');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('7');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("x)]ru^jkDJ*", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("ISn", false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(".", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char1 = AminoAcidSequence.getOneLetterCode("x)]ru^jkDJ*");
      assertFalse(char1 == char0);
      assertEquals('\uFFFF', char1);
      
      AminoAcidSequence aminoAcidSequence2 = new AminoAcidSequence("Ala");
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("Ala", aminoAcidSequence2.toString());
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence3);
      assertEquals(3, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getSymbolIndex('C');
      assertFalse(int1 == int0);
      assertEquals(4, int1);
      
      int int2 = aminoAcidSequence1.length();
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      assertEquals(1, int2);
      assertEquals(".", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        aminoAcidSequence2.elementAt(510);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test007()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('8');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Not(", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(".", string0);
      assertNotNull(string0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("Not(");
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("Not(", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence3);
      assertEquals("x", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(1, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('8');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 8
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test008()  throws Throwable  {
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Lys", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(1, aminoAcidSequence1.length());
      assertEquals("x", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence2.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('V');
      assertEquals(19, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon(',');
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Ser");
      assertEquals('s', char0);
  }

  @Test(timeout = 4000)
  public void test009()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Not(", false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(".", string0);
      assertNotNull(string0);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode(".");
      assertEquals('\uFFFF', char0);
      
      char char1 = File.pathSeparatorChar;
      assertFalse(char1 == char0);
      assertEquals(':', char1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("Not(", true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence3);
      assertEquals(1, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      String string1 = aminoAcidSequence0.toString();
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(".", string1);
      assertNotNull(string1);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt((-1692));
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test010()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = 'X';
      charArray0[1] = 'y';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertArrayEquals(new char[] {'X', 'y'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Sel", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('X');
      assertEquals(23, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('y');
      assertFalse(int1 == int0);
      assertEquals(18, int1);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Sel");
      assertEquals('u', char0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertEquals("............f.......g", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(21, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("ai*L@y:[|2&[K", true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence3);
      assertEquals("xxxx", aminoAcidSequence3.toString());
      assertEquals(4, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      boolean boolean0 = aminoAcidSequence3.checkForMatch(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(boolean0);
      assertArrayEquals(new char[] {'X', 'y'}, charArray0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals("xxxx", aminoAcidSequence3.toString());
      assertEquals(4, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      char char1 = AminoAcidSequence.getOneLetterCode("Sel");
      assertTrue(char1 == char0);
      assertEquals('u', char1);
  }

  @Test(timeout = 4000)
  public void test011()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('(');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: (
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test012()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('$');
      assertEquals(7, int0);
      
      char[] charArray0 = new char[2];
      charArray0[0] = '$';
      charArray0[1] = '$';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertArrayEquals(new char[] {'$', '$'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence.setGeneCode();
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0.0F, float0, 0.01F);
      assertArrayEquals(new char[] {'$', '$'}, charArray0);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'$', '$'}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertEquals(0, aminoAcidSequence1.length());
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test013()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('2');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 2
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test014()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("D7fg1y_a*phbinw ", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(21, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Alphabet of all doubles.");
      assertEquals('\uFFFF', char0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertEquals(63, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation(aminoAcidSequence3.codon_translation_array, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertEquals(63, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(21, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      
      char char1 = AminoAcidSequence.getOneLetterCode("Alphabet of all doubles.");
      assertTrue(char1 == char0);
      assertEquals('\uFFFF', char1);
      
      int int0 = AminoAcidSequence.getAminoAcidType('#');
      assertEquals(5, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(64);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 64
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test015()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('f');
      assertEquals(7, int0);
      
      char[] charArray0 = new char[6];
      charArray0[0] = 'f';
      charArray0[1] = 'f';
      charArray0[2] = 'f';
      charArray0[3] = 'f';
      charArray0[4] = 'f';
      charArray0[5] = 'f';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertArrayEquals(new char[] {'f', 'f', 'f', 'f', 'f', 'f'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("AwlC^j", true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(2, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("AwlC^j", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(2, aminoAcidSequence2.length());
      assertEquals("xx", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("AwlC^j");
      assertEquals('\uFFFF', char0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertEquals(63, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(21, aminoAcidSequence4.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getSpacedTranslation("AwlC^j", true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertNotNull(aminoAcidSequence5);
      assertEquals("x  x  ", aminoAcidSequence5.toString());
      assertEquals(6, aminoAcidSequence5.length());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      
      int int1 = AminoAcidSequence.getSymbolIndex('f');
      assertFalse(int1 == int0);
      assertEquals(13, int1);
      
      AminoAcidSequence.setGeneCode();
      int int2 = AminoAcidSequence.getSymbolIndex('f');
      assertFalse(int2 == int0);
      assertTrue(int2 == int1);
      assertEquals(13, int2);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(17);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test016()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      char[] charArray0 = new char[4];
      charArray0[0] = 'n';
      charArray0[1] = ',';
      charArray0[2] = '[';
      charArray0[3] = '{';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertArrayEquals(new char[] {'n', ',', '[', '{'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Ala", false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Ala");
      assertEquals('a', char0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'n', ',', '[', '{'}, charArray0);
      assertNotNull(aminoAcidSequence2);
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals(".  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      String string1 = aminoAcidSequence0.toString();
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(string1.equals((Object)string0));
      assertEquals("x", string1);
      assertArrayEquals(new char[] {'n', ',', '[', '{'}, charArray0);
      assertNotNull(string1);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      Character character0 = new Character(',');
      assertFalse(character0.equals((Object)char0));
      assertEquals(',', (char)character0);
      assertNotNull(character0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("Ala", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence3);
      assertEquals("x", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(1, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('1');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 1
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test017()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("", true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("", false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence3);
      assertEquals("", aminoAcidSequence3.toString());
      assertEquals(0, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation("R3?e", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(3, aminoAcidSequence4.length());
      assertEquals(".  ", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      
      int int1 = AminoAcidSequence.getSymbolIndex('s');
      assertFalse(int1 == int0);
      assertEquals(15, int1);
      
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertNotNull(aminoAcidSequence5);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence5.toString());
      assertEquals(63, aminoAcidSequence5.length());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence6 = AminoAcidSequence.getTranslation("", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence5));
      assertNotNull(aminoAcidSequence6);
      assertEquals("", aminoAcidSequence6.toString());
      assertFalse(aminoAcidSequence6.containsStopCodon());
      assertEquals(0, aminoAcidSequence6.length());
      assertNotSame(aminoAcidSequence6, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence5);
      
      AminoAcidSequence aminoAcidSequence7 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence7.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence7);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence7.toString());
      assertEquals(63, aminoAcidSequence7.length());
      assertFalse(aminoAcidSequence7.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence7, aminoAcidSequence1);
      
      int int2 = aminoAcidSequence0.length();
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      assertEquals(0, int2);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('E');
      assertEquals("Glu", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertFalse(string1.equals((Object)string0));
      assertEquals("Gln", string1);
      assertNotNull(string1);
      
      boolean boolean0 = aminoAcidSequence1.checkForMatch(aminoAcidSequence5);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(boolean0);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence5.toString());
      assertEquals(63, aminoAcidSequence5.length());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      
      boolean boolean1 = aminoAcidSequence5.checkForMatch(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertTrue(boolean1 == boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence7));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence6));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(boolean1);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence5.toString());
      assertEquals(63, aminoAcidSequence5.length());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence7);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence6);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Gln");
      assertEquals('q', char0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(91);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test018()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('y');
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("CeB^t'~e,HQZ", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals("....", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(4, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("", filteredEntryGroup0.getFilterName());
      
      Clipboard clipboard0 = new Clipboard((String) null);
      assertNotNull(clipboard0);
      assertNull(clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertNull(clipboard0.getName());
      
      SimpleEntryGroup simpleEntryGroup1 = new SimpleEntryGroup();
      assertFalse(simpleEntryGroup1.equals((Object)simpleEntryGroup0));
      assertNotNull(simpleEntryGroup1);
      assertEquals(0, simpleEntryGroup1.refCount());
      assertEquals(0, simpleEntryGroup1.size());
      
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup1);
      assertFalse(simpleEntryGroup1.equals((Object)simpleEntryGroup0));
      assertNotNull(simpleGotoEventSource0);
      assertEquals(0, simpleEntryGroup1.refCount());
      assertEquals(0, simpleEntryGroup1.size());
      
      JFormattedTextField jFormattedTextField0 = new JFormattedTextField();
      assertNotNull(jFormattedTextField0);
      assertTrue(jFormattedTextField0.getFocusTraversalKeysEnabled());
      assertFalse(jFormattedTextField0.isFocusTraversalPolicySet());
      assertFalse(jFormattedTextField0.getIgnoreRepaint());
      assertFalse(jFormattedTextField0.isFocusCycleRoot());
      assertFalse(jFormattedTextField0.isFocusTraversalPolicyProvider());
      
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup(filteredEntryGroup0, jFormattedTextField0, selection0, simpleGotoEventSource0);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class uk.ac.sanger.artemis.components.BasePlot
         //
         verifyException("uk.ac.sanger.artemis.components.BasePlotGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test019()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("X4ue;7}1#=\"y l43v");
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("X4ue;7}1#=\"y l43v", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("X4ue;7}1#=\"y l43v", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(5, aminoAcidSequence1.length());
      assertEquals("xxxxx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 4
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test020()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("X4ue;7}1#=\"y l43v");
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("X4ue;7}1#=\"y l43v", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('6');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 6
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test021()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('P');
      assertEquals(4, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('%');
      assertFalse(boolean0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      // Undeclared exception!
      try { 
        bioJavaSequence0.getGCount();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.biojava.bio.seq.io.SymbolListCharSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test022()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("dmE[d6+o,");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('\uFFFF', '', '(');
      assertFalse(char1 == char0);
      assertEquals('.', char1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('');
      assertFalse(boolean0);
      
      char[] charArray0 = new char[4];
      charArray0[0] = '\uFFFF';
      charArray0[1] = '\uFFFF';
      charArray0[2] = '(';
      charArray0[3] = '.';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertArrayEquals(new char[] {'\uFFFF', '\uFFFF', '(', '.'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("dmE[d6+o,", false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("...", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals((-36.03F), float0, 0.01F);
      assertEquals("...", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean1 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertArrayEquals(new char[] {'\uFFFF', '\uFFFF', '(', '.'}, charArray0);
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Something is screwey - map is lying about key/values", false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(51, aminoAcidSequence2.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('\uFFFF');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test023()  throws Throwable  {
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      int int0 = AminoAcidSequence.getSymbolIndex('U');
      assertEquals(24, int0);
      
      char char0 = File.separatorChar;
      assertEquals('/', char0);
      
      int int1 = aminoAcidSequence0.length();
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(int1 == int0);
      assertEquals(0, int1);
      assertArrayEquals(new char[] {}, charArray0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('\'');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("", false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('u');
      assertEquals("Sel", string0);
      assertNotNull(string0);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertArrayEquals(new char[] {}, charArray0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      char char1 = AminoAcidSequence.getCodonTranslation('u', 'w', '/');
      assertFalse(char1 == char0);
      assertEquals('.', char1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation("", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertNotNull(aminoAcidSequence3);
      assertEquals("", aminoAcidSequence3.toString());
      assertEquals(0, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('l');
      assertFalse(boolean2 == boolean1);
      assertFalse(boolean2 == boolean0);
      assertTrue(boolean2);
      
      boolean boolean3 = AminoAcidSequence.isLegalCodon(':');
      assertTrue(boolean3 == boolean1);
      assertTrue(boolean3 == boolean0);
      assertFalse(boolean3 == boolean2);
      assertFalse(boolean3);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation("", false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence4);
      assertEquals(0, aminoAcidSequence4.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals("", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      
      char char2 = AminoAcidSequence.getSymbolFromIndex(0);
      assertFalse(char2 == char1);
      assertFalse(char2 == char0);
      assertEquals('a', char2);
  }

  @Test(timeout = 4000)
  public void test024()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('(');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test025()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("org.biojava.bio.symbol.AbstractSymbolList$SubList");
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(49, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("org.biojava.bio.symbol.AbstractSymbolList$SubList", aminoAcidSequence0.toString());
      
      char[] charArray0 = new char[4];
      charArray0[1] = 'M';
      charArray0[2] = 'y';
      charArray0[3] = '[';
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(49, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("org.biojava.bio.symbol.AbstractSymbolList$SubList", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertArrayEquals(new char[] {'\u0000', 'M', 'y', '['}, charArray0);
      assertNotNull(aminoAcidSequence2);
      assertEquals(3, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = aminoAcidSequence0.elementAt(0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals('o', char0);
      assertEquals(49, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("org.biojava.bio.symbol.AbstractSymbolList$SubList", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
  }

  @Test(timeout = 4000)
  public void test026()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('9');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test027()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char[] charArray0 = new char[9];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  ", aminoAcidSequence0.toString());
      
      charArray0[0] = '$';
      charArray0[1] = 'f';
      charArray0[2] = 'n';
      charArray0[3] = '\\';
      charArray0[4] = '>';
      charArray0[5] = 'h';
      charArray0[6] = 'v';
      charArray0[7] = '>';
      charArray0[8] = 'V';
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'$', 'f', 'n', '\\', '>', 'h', 'v', '>', 'V'}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertEquals(9, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  .  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('?');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(25);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test028()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('M');
      assertEquals(12, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      int int1 = AminoAcidSequence.getAminoAcidType('e');
      assertFalse(int1 == int0);
      assertEquals(7, int1);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('e');
      assertFalse(int2 == int0);
      assertFalse(int2 == int1);
      assertEquals(6, int2);
  }

  @Test(timeout = 4000)
  public void test029()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('0');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test030()  throws Throwable  {
      String string0 = VCFHeader.METADATA_INDICATOR;
      assertEquals("##", string0);
      assertNotNull(string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("##");
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("##", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      
      int int0 = AminoAcidSequence.getAminoAcidType('X');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("##", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = aminoAcidSequence1.elementAt(7);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(' ', char0);
      assertEquals("##", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test031()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('X');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test032()  throws Throwable  {
      String string0 = JColorChooser.CHOOSER_PANELS_PROPERTY;
      assertEquals("chooserPanels", string0);
      assertNotNull(string0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('@');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(1747);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1747
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test033()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Thr", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Thr", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("x", aminoAcidSequence1.toString());
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.checkForMatch((AminoAcidSequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test034()  throws Throwable  {
      char[] charArray0 = new char[6];
      charArray0[0] = 'O';
      charArray0[1] = 'd';
      charArray0[2] = '2';
      charArray0[3] = '=';
      charArray0[4] = 'A';
      charArray0[5] = 'z';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertArrayEquals(new char[] {'O', 'd', '2', '=', 'A', 'z'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xx", aminoAcidSequence0.toString());
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getCodonTranslation('J', 'd', 'J');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('A');
      assertEquals(0, int0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertArrayEquals(new char[] {'O', 'd', '2', '=', 'A', 'z'}, charArray0);
      assertNotNull(aminoAcidSequence2);
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(' ');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test035()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('K');
      assertTrue(boolean0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      JScrollBar jScrollBar0 = new JScrollBar();
      assertNotNull(jScrollBar0);
      assertFalse(jScrollBar0.isFocusCycleRoot());
      assertFalse(jScrollBar0.getIgnoreRepaint());
      assertTrue(jScrollBar0.getFocusTraversalKeysEnabled());
      assertFalse(jScrollBar0.isFocusTraversalPolicySet());
      assertFalse(jScrollBar0.isFocusTraversalPolicyProvider());
      
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup(simpleEntryGroup0, jScrollBar0, selection0, (GotoEventSource) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.BasePlotGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test036()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("S&Dipm<2K", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".  .  .  ", aminoAcidSequence0.toString());
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(".  .  .  ", aminoAcidSequence0.toString());
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(".  .  .  ", aminoAcidSequence0.toString());
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('q');
      assertEquals(5, int0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("S&Dipm<2K", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence3);
      assertEquals("xxx", aminoAcidSequence3.toString());
      assertEquals(3, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertEquals("Arg", string0);
      assertNotNull(string0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("6\"N_OP&i+");
      assertEquals('\uFFFF', char0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test037()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("---");
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('*');
      assertEquals(20, int0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("---");
      assertTrue(char1 == char0);
      assertEquals('.', char1);
      
      int int1 = AminoAcidSequence.getSymbolIndex('*');
      assertTrue(int1 == int0);
      assertEquals(20, int1);
      
      char char2 = AminoAcidSequence.getCodonTranslation(']', '!', '\"');
      assertTrue(char2 == char0);
      assertTrue(char2 == char1);
      assertEquals('.', char2);
  }

  @Test(timeout = 4000)
  public void test038()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = '<';
      charArray0[1] = '<';
      charArray0[3] = 'X';
      charArray0[4] = 'D';
      charArray0[5] = 'K';
      charArray0[6] = 'w';
      charArray0[7] = '<';
      charArray0[8] = 'i';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertArrayEquals(new char[] {'<', '<', '\u0000', 'X', 'D', 'K', 'w', '<', 'i'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'<', '<', '\u0000', 'X', 'D', 'K', 'w', '<', 'i'}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals((-36.03F), float0, 0.01F);
      assertArrayEquals(new char[] {'<', '<', '\u0000', 'X', 'D', 'K', 'w', '<', 'i'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getOneLetterCode("th>9RQLD");
      assertEquals('\uFFFF', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('?');
      assertEquals(7, int0);
      
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals((-36.03F), float1, 0.01F);
      assertArrayEquals(new char[] {'<', '<', '\u0000', 'X', 'D', 'K', 'w', '<', 'i'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      float float2 = aminoAcidSequence1.getMolecularWeight();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotEquals(float2, float1, 0.01F);
      assertNotEquals(float2, float0, 0.01F);
      assertEquals((-120.03998F), float2, 0.01F);
      assertArrayEquals(new char[] {'<', '<', '\u0000', 'X', 'D', 'K', 'w', '<', 'i'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test039()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getCodonTranslation('2', '2', '2');
      assertEquals('.', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('2');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test040()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isStopCodon('+');
      assertTrue(boolean0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(766);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 766
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test041()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isStopCodon('x');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('=');
      assertEquals(7, int0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Cn=0");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("Cn=0", filteredEntryGroup0.getFilterName());
      
      Clipboard clipboard0 = new Clipboard((String) null);
      assertNotNull(clipboard0);
      assertNull(clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertNull(clipboard0.getName());
      
      DefaultTableCellRenderer.UIResource defaultTableCellRenderer_UIResource0 = new DefaultTableCellRenderer.UIResource();
      assertNotNull(defaultTableCellRenderer_UIResource0);
      assertTrue(defaultTableCellRenderer_UIResource0.getFocusTraversalKeysEnabled());
      assertFalse(defaultTableCellRenderer_UIResource0.getIgnoreRepaint());
      assertFalse(defaultTableCellRenderer_UIResource0.isFocusTraversalPolicySet());
      assertFalse(defaultTableCellRenderer_UIResource0.isFocusCycleRoot());
      assertFalse(defaultTableCellRenderer_UIResource0.isFocusTraversalPolicyProvider());
      
      BasePlotGroup basePlotGroup0 = null;
      try {
        basePlotGroup0 = new BasePlotGroup(filteredEntryGroup0, defaultTableCellRenderer_UIResource0, selection0, (GotoEventSource) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.BasePlotGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test042()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('O');
      assertEquals(7, int0);
      
      AminoAcidSequence.setGeneCode();
  }

  @Test(timeout = 4000)
  public void test043()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("%i;Cw");
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals("%i;Cw", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: %
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test044()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('/');
      assertEquals(7, int0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('/');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test045()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(")96t6[|:Ku3 F;)KJz", true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals("xxxxxx", string0);
      assertNotNull(string0);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(boolean0);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("xxxxxx", false);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertEquals("..", aminoAcidSequence2.toString());
      assertEquals(2, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence3);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals(63, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      int int0 = AminoAcidSequence.getSymbolIndex('p');
      assertEquals(14, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('l');
      assertFalse(int1 == int0);
      assertEquals(10, int1);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(980);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test046()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('W');
      assertEquals(3, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("$wnN%/2eaL^A");
      assertEquals('.', char0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('W');
      assertFalse(int1 == int0);
      assertEquals(17, int1);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('d');
      assertEquals("Asp", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(17);
      assertFalse(string1.equals((Object)string0));
      assertEquals("Trp", string1);
      assertNotNull(string1);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("eOBx", true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Asp", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence2.toString());
      assertEquals(21, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(boolean0);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      Feature feature0 = new Feature(genbankStreamFeature0);
      assertNotNull(feature0);
      assertFalse(feature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test047()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('\\', '\\', '\\');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('-');
      assertEquals(7, int0);
      
      Bases bases0 = new Bases((Sequence) null);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test048()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("X4ue;7}1#=\"y l43v");
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("X4ue;7}1#=\"y l43v", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      int int0 = AminoAcidSequence.getSymbolIndex('+');
      assertEquals(22, int0);
      
      int int1 = Level.TRACE_INT;
      assertFalse(int1 == int0);
      assertEquals(5000, int1);
  }

  @Test(timeout = 4000)
  public void test049()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('[');
      assertEquals(7, int0);
      
      char[] charArray0 = new char[8];
      charArray0[0] = '[';
      charArray0[1] = '[';
      charArray0[2] = '[';
      charArray0[3] = '[';
      charArray0[4] = '[';
      charArray0[5] = '[';
      charArray0[6] = '[';
      charArray0[7] = '[';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertArrayEquals(new char[] {'[', '[', '[', '[', '[', '[', '[', '['}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xx", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'[', '[', '[', '[', '[', '[', '[', '['}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertEquals(6, aminoAcidSequence1.length());
      assertEquals(".  .  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertArrayEquals(new char[] {'[', '[', '[', '[', '[', '[', '[', '['}, charArray0);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(2, aminoAcidSequence2.length());
      assertEquals("xx", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation("\" was loaded by ", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence3);
      assertEquals(15, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  x  x  x  x  ", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('[');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: [
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test050()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('$');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: $
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test051()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('k', 'k', 'S');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('.', '.', 'k');
      assertTrue(char1 == char0);
      assertEquals('.', char1);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("~");
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("~", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("KX`_!gxk3K(*9G\"6vsK");
      assertNotNull(rawStreamSequence0);
      assertEquals(18, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(19, rawStreamSequence0.length());
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      assertEquals(18, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(19, rawStreamSequence0.length());
      
      Clipboard clipboard0 = new Clipboard("KX`_!gxk3K(*9G\"6vsK");
      assertNotNull(clipboard0);
      assertEquals("KX`_!gxk3K(*9G\"6vsK", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("KX`_!gxk3K(*9G\"6vsK", clipboard0.getName());
      
      Marker marker0 = selection0.getEndBaseOfSelection();
      assertNull(marker0);
      assertEquals("KX`_!gxk3K(*9G\"6vsK", clipboard0.getName());
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, false, false, false);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(markerRange0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("~", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(18, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(19, rawStreamSequence0.length());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(simpleEntryGroup0);
      assertEquals(18, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(19, rawStreamSequence0.length());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt(0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test052()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getOneLetterCode("d7Fg1y_a*Phbinw ");
      assertEquals('\uFFFF', char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('`');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: `
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test053()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('t');
      assertEquals(16, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('{');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Trp");
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Trp", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Trp", false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('}');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test054()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('v');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('v');
      assertEquals(7, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('\"');
      assertTrue(int1 == int0);
      assertEquals(7, int1);
      
      int int2 = AminoAcidSequence.getAminoAcidType('c');
      assertTrue(int2 == int1);
      assertTrue(int2 == int0);
      assertEquals(7, int2);
      
      int int3 = AminoAcidSequence.getSymbolIndex('c');
      assertFalse(int3 == int2);
      assertFalse(int3 == int0);
      assertFalse(int3 == int1);
      assertEquals(4, int3);
      
      char[] charArray0 = new char[9];
      charArray0[0] = '\"';
      charArray0[1] = '\"';
      charArray0[2] = 'c';
      charArray0[3] = '\"';
      charArray0[4] = '\"';
      charArray0[5] = '\"';
      charArray0[6] = 'c';
      charArray0[7] = 'v';
      charArray0[8] = 'c';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {'\"', '\"', 'c', '\"', '\"', '\"', 'c', 'v', 'c'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  ", aminoAcidSequence0.toString());
  }

  @Test(timeout = 4000)
  public void test055()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((char[]) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test056()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon(',');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((char[]) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test057()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('G');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode("");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test058()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Gln", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      int int0 = aminoAcidSequence0.length();
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, int0);
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Q-~Tj", true);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Gln");
      assertEquals('q', char0);
      
      Clipboard clipboard0 = new Clipboard("Gln");
      assertNotNull(clipboard0);
      assertEquals("Gln", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("Gln", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals("Gln", clipboard0.getName());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.findMatch((Bases) null, (Marker) null, false, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test059()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test060()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("feature_labels");
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertEquals(14, aminoAcidSequence0.length());
      
      Short short0 = new Short((short) (-27008));
      assertEquals((short) (-27008), (short)short0);
      assertNotNull(short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 7, short0, (Integer) 2);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short) (-27008), (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      
      Bases bases0 = new Bases(partialSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short) (-27008), (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      
      Clipboard clipboard0 = new Clipboard("feature_labels");
      assertNotNull(clipboard0);
      assertEquals("feature_labels", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("feature_labels", clipboard0.getName());
      
      Marker marker0 = selection0.getHighestBaseOfSelection();
      assertNull(marker0);
      assertEquals("feature_labels", clipboard0.getName());
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNull(markerRange0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("feature_labels", aminoAcidSequence0.toString());
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short) (-27008), (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      
      int int0 = AminoAcidSequence.getSymbolIndex('S');
      assertEquals(15, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType(' ');
      assertFalse(int1 == int0);
      assertEquals(7, int1);
  }

  @Test(timeout = 4000)
  public void test061()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getCodonTranslation("-jGGqdT:jq?NETW>W8Q");
      assertEquals('.', char0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getAminoAcidType('J');
      assertEquals(7, int0);
      
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = new AminoAcidSequence("-jGGqdT:jq?NETW>W8Q");
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("-jGGqdT:jq?NETW>W8Q", aminoAcidSequence1.toString());
      assertEquals(19, aminoAcidSequence1.length());
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean0);
      assertArrayEquals(new char[] {}, charArray0);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("-jGGqdT:jq?NETW>W8Q", aminoAcidSequence1.toString());
      assertEquals(19, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("Iau=0E?+p^wU");
      assertTrue(char1 == char0);
      assertEquals('.', char1);
  }

  @Test(timeout = 4000)
  public void test062()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      
      char char0 = AminoAcidSequence.getOneLetterCode("GhJi?mUq7]");
      assertEquals('\uFFFF', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('l');
      assertEquals(10, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('l');
      assertTrue(int1 == int0);
      assertEquals(10, int1);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertEquals("", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode("");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test063()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('K');
      assertEquals(1, int0);
      
      String string0 = HTMLLayout.LOCATION_INFO_OPTION;
      assertEquals("LocationInfo", string0);
      assertNotNull(string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("LocationInfo");
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(12, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("LocationInfo", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: o
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test064()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertFalse(string1.equals((Object)string0));
      assertEquals("Thr", string1);
      assertNotNull(string1);
      
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', ';');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("x)]ru^jkDJ*", false);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getSymbolIndex('C');
      assertFalse(int1 == int0);
      assertEquals(4, int1);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(510);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test065()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertFalse(string1.equals((Object)string0));
      assertEquals("Thr", string1);
      assertNotNull(string1);
      
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', 't');
      assertEquals('f', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("x)]ru^jkDJ*", false);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  ", aminoAcidSequence0.toString());
      assertEquals(12, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getSymbolIndex('C');
      assertFalse(int1 == int0);
      assertEquals(4, int1);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(510);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test066()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertEquals("Thr", string0);
      assertNotNull(string0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('C');
      assertEquals(4, int0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(510);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test067()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('g');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('g', 'Z', 'Z');
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('.');
      assertEquals("---", string0);
      assertNotNull(string0);
      
      String string1 = aminoAcidSequence0.toString();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(string1.equals((Object)string0));
      assertEquals("", string1);
      assertNotNull(string1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      String string2 = aminoAcidSequence0.toString();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(string2.equals((Object)string0));
      assertEquals("", string2);
      assertNotNull(string2);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((String) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test068()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Ala", false);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Ala", true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(".", string0);
      assertNotNull(string0);
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
  }

  @Test(timeout = 4000)
  public void test069()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("Phe");
      assertEquals('f', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("Phe");
      assertFalse(char1 == char0);
      assertEquals('.', char1);
      
      char char2 = CharacterIterator.DONE;
      assertFalse(char2 == char1);
      assertFalse(char2 == char0);
      assertEquals('\uFFFF', char2);
  }

  @Test(timeout = 4000)
  public void test070()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isStopCodon('&');
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('B');
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test071()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Q>eD, SY&s%", true);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(9, aminoAcidSequence0.length());
      assertEquals("x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Q>eD, SY&s%", true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(9, aminoAcidSequence1.length());
      assertEquals("x  x  x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence2);
      assertEquals(9, aminoAcidSequence1.length());
      assertEquals("x  x  x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("Q>eD, SY&s%", false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertNotNull(aminoAcidSequence3);
      assertEquals("...", aminoAcidSequence3.toString());
      assertEquals(3, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation("Q>eD, SY&s%", true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence4);
      assertEquals("xxx", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(3, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('r');
      assertEquals(1, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('D');
      assertFalse(int1 == int0);
      assertEquals(3, int1);
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals("x  x  x  ", string0);
      assertNotNull(string0);
      assertEquals(9, aminoAcidSequence0.length());
      assertEquals("x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test072()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.length();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test073()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('/');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: /
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test074()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('E');
      assertEquals(2, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("'GsMz8l", true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
  }

  @Test(timeout = 4000)
  public void test075()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("!BG)h9IU2FzMHPJl", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(5, aminoAcidSequence0.length());
      
      AminoAcidSequence.setGeneCode();
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-72.06F), float0, 0.01F);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(5, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test076()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("internal error - illegal one letter amino acid code");
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("internal error - illegal one letter amino acid code", aminoAcidSequence0.toString());
      assertEquals(51, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\'');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: '
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test077()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('M');
      assertEquals(12, int0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Range range0 = new Range((-324), (-324));
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals((-324), range0.getEnd());
      assertEquals((-324), range0.getStart());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test078()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('P');
      assertEquals(4, int0);
      
      char[] charArray0 = new char[1];
      charArray0[0] = 'P';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertArrayEquals(new char[] {'P'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      
      String string0 = aminoAcidSequence0.toString();
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", string0);
      assertArrayEquals(new char[] {'P'}, charArray0);
      assertNotNull(string0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('P');
      assertFalse(string1.equals((Object)string0));
      assertEquals("Pro", string1);
      assertNotNull(string1);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Pro", false);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean0);
      assertArrayEquals(new char[] {'P'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test079()  throws Throwable  {
      char[] charArray0 = new char[5];
      charArray0[0] = 'O';
      charArray0[1] = 'U';
      charArray0[2] = 'h';
      charArray0[3] = 'w';
      charArray0[4] = 'm';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertArrayEquals(new char[] {'O', 'U', 'h', 'w', 'm'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertArrayEquals(new char[] {'O', 'U', 'h', 'w', 'm'}, charArray0);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean0);
      assertArrayEquals(new char[] {'O', 'U', 'h', 'w', 'm'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test080()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('I');
      assertEquals(9, int0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getAminoAcidType('Z');
      assertFalse(int1 == int0);
      assertEquals(7, int1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('I');
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(9);
      assertEquals('i', char0);
      
      int int2 = AminoAcidSequence.getAminoAcidType('}');
      assertTrue(int2 == int1);
      assertFalse(int2 == int0);
      assertEquals(7, int2);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Val", false);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      SimpleEntryGroup simpleEntryGroup0 = null;
      try {
        simpleEntryGroup0 = new SimpleEntryGroup((Bases) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test081()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('N');
      assertEquals(0, int0);
      
      char[] charArray0 = new char[7];
      charArray0[0] = 'N';
      charArray0[1] = 'N';
      charArray0[2] = 'N';
      charArray0[3] = 'N';
      charArray0[4] = 'N';
      charArray0[5] = 'N';
      charArray0[6] = 'N';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {'N', 'N', 'N', 'N', 'N', 'N', 'N'}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(boolean0);
      assertArrayEquals(new char[] {'N', 'N', 'N', 'N', 'N', 'N', 'N'}, charArray0);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
  }

  @Test(timeout = 4000)
  public void test082()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('%', '.', '%');
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = AminoAcidSequence.isLegalCodon('>');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(25);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 25
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test083()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('A');
      assertEquals("Ala", string0);
      assertNotNull(string0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('A');
      assertEquals(3, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('A');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test084()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('M');
      assertEquals(3, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(1664);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1664
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test085()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", true);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", true);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('=');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: =
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test086()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('i', '', 'i');
      assertEquals('.', char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getCodonTranslation((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test087()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('P');
      assertTrue(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test088()  throws Throwable  {
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode("");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test089()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isStopCodon('@');
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("PlSm*/p<MF/px$H");
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("PlSm*/p<MF/px$H");
      assertTrue(char1 == char0);
      assertEquals('.', char1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test090()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("APqV|pi'!=(");
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(11, aminoAcidSequence0.length());
      assertEquals("APqV|pi'!=(", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char char0 = AminoAcidSequence.getOneLetterCode("APqV|pi'!=(");
      assertEquals('\uFFFF', char0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertNotNull(aminoAcidSequence1);
      assertEquals(11, aminoAcidSequence0.length());
      assertEquals("APqV|pi'!=(", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\uFFFF');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: \uFFFF
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test091()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("org.gmod.schema.sequence.FeatureCvTermPub", true);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertNotNull(aminoAcidSequence0);
      assertEquals("x  x  x  x  x  x  x  x  x  i  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(39, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test092()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('.');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('.');
      assertEquals(7, int0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('.', '.', '.');
      assertTrue(char1 == char0);
      assertEquals('.', char1);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('.');
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Clipboard clipboard0 = new Clipboard("");
      assertNotNull(clipboard0);
      assertEquals("", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("", clipboard0.getName());
      
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource(simpleEntryGroup0);
      assertNotNull(simpleGotoEventSource0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      JFrame jFrame0 = null;
      try {
        jFrame0 = new JFrame("U^R!");
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test093()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test094()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(1);
      assertEquals("Arg", string0);
      assertNotNull(string0);
      
      String string1 = KeyEvent.getKeyModifiersText(1);
      assertFalse(string1.equals((Object)string0));
      assertEquals("\u21E7", string1);
      assertNotNull(string1);
  }

  @Test(timeout = 4000)
  public void test095()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(94);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test096()  throws Throwable  {
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertArrayEquals(new char[] {}, charArray0);
      assertNotNull(aminoAcidSequence0);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
  }

  @Test(timeout = 4000)
  public void test097()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("*CUpuo#");
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("*CUpuo#");
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals(8, aminoAcidSequence0.length());
      assertEquals("*CUpuo#", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      char char1 = AminoAcidSequence.getOneLetterCode("*CUpuo#");
      assertFalse(char1 == char0);
      assertEquals('\uFFFF', char1);
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      int int1 = aminoAcidSequence0.length();
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(int1 == int0);
      assertEquals(8, int1);
      assertEquals(8, aminoAcidSequence0.length());
      assertEquals("*CUpuo#", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(25);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 25
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test098()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(392);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 392
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test099()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("X4ue;7}1#=\"y l43v");
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNotNull(aminoAcidSequence0);
      assertEquals("X4ue;7}1#=\"y l43v", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('7');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 7
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test100()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(164);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 164
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test101()  throws Throwable  {
      String string0 = "S&Dipm<2K";
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("S&Dipm<2K", false);
      AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('?');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test102()  throws Throwable  {
      AminoAcidSequence.getTranslation("D0_r>,?K", true);
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.isLegalCodon('b');
      AminoAcidSequence.getAminoAcidType('b');
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('b');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: b
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test103()  throws Throwable  {
      AminoAcidSequence.getCodonTranslation("FpH55Y9k7-5\"Kg/");
      AminoAcidSequence.getCodonTranslation('X', 'Q', '|');
      char[] charArray0 = new char[8];
      charArray0[0] = '.';
      charArray0[1] = 'X';
      charArray0[2] = '|';
      charArray0[3] = 'X';
      charArray0[4] = '.';
      charArray0[5] = '.';
      charArray0[6] = 'Q';
      charArray0[7] = 'X';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('.');
      assertEquals("---", string0);
      
      AminoAcidSequence.getCodonTranslation("FpH55Y9k7-5\"Kg/");
      boolean boolean0 = AminoAcidSequence.isStopCodon('X');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test104()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      EmblStreamSequence emblStreamSequence0 = null;
      try {
        emblStreamSequence0 = new EmblStreamSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test105()  throws Throwable  {
      String string0 = "Can't set weight to negative score: ";
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Can't set weight to negative score: ");
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Can't set weight to negative score: ", true);
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      aminoAcidSequence2.getMolecularWeight();
      aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: '
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test106()  throws Throwable  {
      char char0 = 'K';
      AminoAcidSequence.getAminoAcidType('K');
      String string0 = AccessibleContext.ACCESSIBLE_TABLE_ROW_DESCRIPTION_CHANGED;
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("accessibleTableRowDescriptionChanged");
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: b
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test107()  throws Throwable  {
      AminoAcidSequence.getOneLetterCode("khhg? yk*(IS");
      AminoAcidSequence.getThreeLetterAbbreviation('H');
      AminoAcidSequence.getSymbolIndex('H');
      char[] charArray0 = new char[6];
      charArray0[0] = '\uFFFF';
      charArray0[1] = 'H';
      charArray0[2] = '\uFFFF';
      charArray0[3] = 'H';
      charArray0[4] = 'H';
      charArray0[5] = 'H';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("khhg? yk*(IS");
      Bases bases0 = new Bases(fastaStreamSequence0);
      AminoAcidSequence.isStopCodon('H');
      Strand strand0 = new Strand(bases0, 1);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      aminoAcidSequence0.findMatch(bases1, (Marker) null, true, false, true);
      aminoAcidSequence0.containsStopCodon();
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(8);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test108()  throws Throwable  {
      char char0 = '8';
      AminoAcidSequence.isLegalCodon('8');
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Not(", false);
      aminoAcidSequence0.getMolecularWeight();
      aminoAcidSequence0.toString();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      AminoAcidSequence.getOneLetterCode(".");
      AminoAcidSequence.getCodonTranslation("Not(");
      AminoAcidSequence.getTranslation("Not(", true);
      aminoAcidSequence0.toString();
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt((-1692));
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }
}
