/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:52:00 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.FTPSeekableStream;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FTPSeekableStream_ESTest extends FTPSeekableStream_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 1712, (-27));
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", fTPSeekableStream0.getSource());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          URL uRL0 = MockURL.getHttpExample();
          FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, (-3400));
          // Undeclared exception!
          try { 
            fTPSeekableStream0.eof();
            fail("Expecting exception: SecurityException");
          
          } catch(SecurityException e) {
             //
             // Security manager blocks (\"java.net.SocketPermission\" \"200.42.42.0:21\" \"connect,resolve\")
             // java.lang.Thread.getStackTrace(Thread.java:1559)
             // org.evosuite.runtime.sandbox.MSecurityManager.checkPermission(MSecurityManager.java:434)
             // java.lang.SecurityManager.checkConnect(SecurityManager.java:1051)
             // java.net.Socket.connect(Socket.java:584)
             // org.apache.commons.net.SocketClient._connect(SocketClient.java:243)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:202)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:306)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getClient(FTPSeekableStream.java:97)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.length(FTPSeekableStream.java:135)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.eof(FTPSeekableStream.java:203)
             // sun.reflect.GeneratedMethodAccessor111.invoke(Unknown Source)
             // sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
             // java.lang.reflect.Method.invoke(Method.java:498)
             // org.evosuite.testcase.statements.MethodStatement$1.execute(MethodStatement.java:257)
             // org.evosuite.testcase.statements.AbstractStatement.exceptionHandler(AbstractStatement.java:169)
             // org.evosuite.testcase.statements.MethodStatement.execute(MethodStatement.java:220)
             // org.evosuite.testcase.execution.TestRunnable.executeStatements(TestRunnable.java:307)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:213)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:55)
             // java.util.concurrent.FutureTask.run(FutureTask.java:266)
             // java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
             // java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
             // java.lang.Thread.run(Thread.java:748)
             //
             verifyException("org.evosuite.runtime.sandbox.MSecurityManager", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/tmp/l!96m*3b,gQB-.bai");
      byte[] byteArray0 = new byte[2];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      File file0 = fTPSeekableStream0.getTmpFolder();
      assertTrue(file0.isAbsolute());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/tmp");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "~} mkK4!hZSD0oFUh");
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      File file0 = fTPSeekableStream0.getTmpFolder();
      assertTrue(file0.isFile());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL1 = MockURL.URL(uRL0, "anonymous", uRLStreamHandler0);
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL1, (-3400));
      String string0 = fTPSeekableStream0.getSource();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("Saved ", "", 1, "", uRLStreamHandler0);
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0);
      File file0 = fTPSeekableStream0.getIndexFile();
      assertNotNull(file0);
      assertEquals("/tmp/.bai", file0.toString());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/tmp/l!96m*3b,gQB-.bai");
      byte[] byteArray0 = new byte[2];
      FileSystemHandling.appendDataToFile(evoSuiteFile0, byteArray0);
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      File file0 = fTPSeekableStream0.getIndexFile();
      assertNotNull(file0);
      assertEquals(2L, file0.length());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FTPSeekableStream fTPSeekableStream0 = null;
      try {
        fTPSeekableStream0 = new FTPSeekableStream((URL) null, "WARN", "WARN");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FTPSeekableStream fTPSeekableStream0 = null;
      try {
        fTPSeekableStream0 = new FTPSeekableStream((URL) null, 2064);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FTPSeekableStream fTPSeekableStream0 = null;
      try {
        fTPSeekableStream0 = new FTPSeekableStream((URL) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, "", "");
      // Undeclared exception!
      try { 
        fTPSeekableStream0.setTmpFolder((File) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.FTPSeekableStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          URL uRL0 = MockURL.getHttpExample();
          EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("/tmp/Not provided in original VCF header.bai");
          FileSystemHandling.createFolder(evoSuiteFile0);
          URL uRL1 = MockURL.URL(uRL0, "Not provided in original VCF header");
          URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
          URL uRL2 = MockURL.URL(uRL1, "Not provided in original VCF header", uRLStreamHandler0);
          FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL2);
          // Undeclared exception!
          try { 
            fTPSeekableStream0.getIndexFile();
            fail("Expecting exception: SecurityException");
          
          } catch(SecurityException e) {
             //
             // Security manager blocks (\"java.net.SocketPermission\" \"200.42.42.0:21\" \"connect,resolve\")
             // java.lang.Thread.getStackTrace(Thread.java:1559)
             // org.evosuite.runtime.sandbox.MSecurityManager.checkPermission(MSecurityManager.java:434)
             // java.lang.SecurityManager.checkConnect(SecurityManager.java:1051)
             // java.net.Socket.connect(Socket.java:584)
             // org.apache.commons.net.SocketClient._connect(SocketClient.java:243)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:202)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:306)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getClient(FTPSeekableStream.java:97)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getIndexFile(FTPSeekableStream.java:285)
             // sun.reflect.GeneratedMethodAccessor107.invoke(Unknown Source)
             // sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
             // java.lang.reflect.Method.invoke(Method.java:498)
             // org.evosuite.testcase.statements.MethodStatement$1.execute(MethodStatement.java:257)
             // org.evosuite.testcase.statements.AbstractStatement.exceptionHandler(AbstractStatement.java:169)
             // org.evosuite.testcase.statements.MethodStatement.execute(MethodStatement.java:220)
             // org.evosuite.testcase.execution.TestRunnable.executeStatements(TestRunnable.java:307)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:213)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:55)
             // java.util.concurrent.FutureTask.run(FutureTask.java:266)
             // java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
             // java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
             // java.lang.Thread.run(Thread.java:748)
             //
             verifyException("org.evosuite.runtime.sandbox.MSecurityManager", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0);
      fTPSeekableStream0.getIndexFile();
      File file0 = fTPSeekableStream0.getIndexFile();
      assertEquals("/tmp/fooExample.bai", file0.toString());
      assertNotNull(file0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      MockFile mockFile0 = new MockFile("log4j.renderer.");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 35, 35);
      try { 
        fTPSeekableStream0.setTmpFolder(mockFile0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // File log4j.renderer. is not a folder
         //
         verifyException("uk.ac.sanger.artemis.util.FTPSeekableStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      MockFile mockFile0 = new MockFile("log4j.renderer.");
      MockFile mockFile1 = new MockFile(mockFile0, "&N,*Iu2nw0? v~/[5[");
      URL uRL0 = mockFile1.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 35, 35);
      mockFile1.createNewFile();
      fTPSeekableStream0.setTmpFolder(mockFile0);
      assertFalse(mockFile0.isAbsolute());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      fTPSeekableStream0.getTmpFolder();
      File file0 = fTPSeekableStream0.getTmpFolder();
      assertNotNull(file0);
      assertTrue(file0.isFile());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      fTPSeekableStream0.close();
      assertEquals("file:"+java.lang.System.getProperty("user.dir") + "/Ignoring configuration file [/l!96m*3b,gQB-", fTPSeekableStream0.getSource());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
          URL uRL0 = mockFile0.toURL();
          FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
          // Undeclared exception!
          try { 
            fTPSeekableStream0.length();
            fail("Expecting exception: SecurityException");
          
          } catch(SecurityException e) {
             //
             // Security manager blocks (\"java.net.SocketPermission\" \"127.0.0.1:21\" \"connect,resolve\")
             // java.lang.Thread.getStackTrace(Thread.java:1559)
             // org.evosuite.runtime.sandbox.MSecurityManager.checkPermission(MSecurityManager.java:434)
             // java.lang.SecurityManager.checkConnect(SecurityManager.java:1051)
             // java.net.Socket.connect(Socket.java:584)
             // org.apache.commons.net.SocketClient._connect(SocketClient.java:243)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:202)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:306)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getClient(FTPSeekableStream.java:97)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.length(FTPSeekableStream.java:135)
             // sun.reflect.GeneratedMethodAccessor103.invoke(Unknown Source)
             // sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
             // java.lang.reflect.Method.invoke(Method.java:498)
             // org.evosuite.testcase.statements.MethodStatement$1.execute(MethodStatement.java:257)
             // org.evosuite.testcase.statements.AbstractStatement.exceptionHandler(AbstractStatement.java:169)
             // org.evosuite.testcase.statements.MethodStatement.execute(MethodStatement.java:220)
             // org.evosuite.testcase.execution.TestRunnable.executeStatements(TestRunnable.java:307)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:213)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:55)
             // java.util.concurrent.FutureTask.run(FutureTask.java:266)
             // java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
             // java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
             // java.lang.Thread.run(Thread.java:748)
             //
             verifyException("org.evosuite.runtime.sandbox.MSecurityManager", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          MockFile mockFile0 = new MockFile("", "");
          URL uRL0 = mockFile0.toURL();
          FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0);
          byte[] byteArray0 = new byte[5];
          // Undeclared exception!
          try { 
            fTPSeekableStream0.read(byteArray0, (int) (byte)44, 1148);
            fail("Expecting exception: SecurityException");
          
          } catch(SecurityException e) {
             //
             // Security manager blocks (\"java.net.SocketPermission\" \"127.0.0.1:21\" \"connect,resolve\")
             // java.lang.Thread.getStackTrace(Thread.java:1559)
             // org.evosuite.runtime.sandbox.MSecurityManager.checkPermission(MSecurityManager.java:434)
             // java.lang.SecurityManager.checkConnect(SecurityManager.java:1051)
             // java.net.Socket.connect(Socket.java:584)
             // org.apache.commons.net.SocketClient._connect(SocketClient.java:243)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:202)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:306)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getClient(FTPSeekableStream.java:97)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.initStream(FTPSeekableStream.java:237)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.read(FTPSeekableStream.java:152)
             // sun.reflect.GeneratedMethodAccessor102.invoke(Unknown Source)
             // sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
             // java.lang.reflect.Method.invoke(Method.java:498)
             // org.evosuite.testcase.statements.MethodStatement$1.execute(MethodStatement.java:257)
             // org.evosuite.testcase.statements.AbstractStatement.exceptionHandler(AbstractStatement.java:169)
             // org.evosuite.testcase.statements.MethodStatement.execute(MethodStatement.java:220)
             // org.evosuite.testcase.execution.TestRunnable.executeStatements(TestRunnable.java:307)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:213)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:55)
             // java.util.concurrent.FutureTask.run(FutureTask.java:266)
             // java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
             // java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
             // java.lang.Thread.run(Thread.java:748)
             //
             verifyException("org.evosuite.runtime.sandbox.MSecurityManager", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      String string0 = fTPSeekableStream0.getSource();
      assertEquals("file:"+java.lang.System.getProperty("user.dir") + "/Ignoring configuration file [/l!96m*3b,gQB-", string0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      fTPSeekableStream0.seek(0L);
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", fTPSeekableStream0.getSource());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
        try {
          URL uRL0 = MockURL.getHttpExample();
          FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0);
          // Undeclared exception!
          try { 
            fTPSeekableStream0.read();
            fail("Expecting exception: SecurityException");
          
          } catch(SecurityException e) {
             //
             // Security manager blocks (\"java.net.SocketPermission\" \"200.42.42.0:21\" \"connect,resolve\")
             // java.lang.Thread.getStackTrace(Thread.java:1559)
             // org.evosuite.runtime.sandbox.MSecurityManager.checkPermission(MSecurityManager.java:434)
             // java.lang.SecurityManager.checkConnect(SecurityManager.java:1051)
             // java.net.Socket.connect(Socket.java:584)
             // org.apache.commons.net.SocketClient._connect(SocketClient.java:243)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:202)
             // org.apache.commons.net.SocketClient.connect(SocketClient.java:306)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.getClient(FTPSeekableStream.java:97)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.initStream(FTPSeekableStream.java:237)
             // uk.ac.sanger.artemis.util.FTPSeekableStream.read(FTPSeekableStream.java:225)
             // sun.reflect.GeneratedMethodAccessor99.invoke(Unknown Source)
             // sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)
             // java.lang.reflect.Method.invoke(Method.java:498)
             // org.evosuite.testcase.statements.MethodStatement$1.execute(MethodStatement.java:257)
             // org.evosuite.testcase.statements.AbstractStatement.exceptionHandler(AbstractStatement.java:169)
             // org.evosuite.testcase.statements.MethodStatement.execute(MethodStatement.java:220)
             // org.evosuite.testcase.execution.TestRunnable.executeStatements(TestRunnable.java:307)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:213)
             // org.evosuite.testcase.execution.TestRunnable.call(TestRunnable.java:55)
             // java.util.concurrent.FutureTask.run(FutureTask.java:266)
             // java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1149)
             // java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:624)
             // java.lang.Thread.run(Thread.java:748)
             //
             verifyException("org.evosuite.runtime.sandbox.MSecurityManager", e);
          }
        } catch(Throwable t) {
            // Need to catch declared exceptions
        }
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      FTPSeekableStream fTPSeekableStream0 = null;
      try {
        fTPSeekableStream0 = new FTPSeekableStream((URL) null, 2763, 2763);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      MockFile mockFile0 = new MockFile("Ignoring configuration file [", "l!96m*3b,gQB-/");
      URL uRL0 = mockFile0.toURL();
      FTPSeekableStream fTPSeekableStream0 = new FTPSeekableStream(uRL0, 0);
      long long0 = fTPSeekableStream0.position();
      assertEquals(0L, long0);
  }
}
