/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:56:37 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.MockitoExtension.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.URLDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class URLDocument_ESTest extends URLDocument_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL1 = MockURL.URL(uRL0, "", uRLStreamHandler0);
      URLDocument uRLDocument0 = new URLDocument(uRL1);
      // Undeclared exception!
      try { 
        uRLDocument0.getParent();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      Object object0 = new Object();
      uRLDocument0.setLocation(object0);
      // Undeclared exception!
      try { 
        uRLDocument0.getParent();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to java.net.URL
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("", "", 0, "", uRLStreamHandler0);
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      // Undeclared exception!
      try { 
        uRLDocument0.getName();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      uRLDocument0.setLocation(uRLDocument0);
      // Undeclared exception!
      try { 
        uRLDocument0.getName();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.util.URLDocument cannot be cast to java.net.URL
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL("2uAkWpQ@%_]X=Z:a^", "", 0, "", uRLStreamHandler0);
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      // Undeclared exception!
      try { 
        uRLDocument0.getInputStream();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      uRLDocument0.setLocation("Fxsicv@FVgclwY?%");
      // Undeclared exception!
      try { 
        uRLDocument0.getInputStream();
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.String cannot be cast to java.net.URL
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      try { 
        uRLDocument0.getInputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Could not find: www.someFakeButWellFormedURL.org
         //
         verifyException("org.evosuite.runtime.mock.java.net.EvoHttpURLConnection", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL1 = MockURL.URL(uRL0, "", uRLStreamHandler0);
      URLDocument uRLDocument0 = new URLDocument(uRL1);
      try { 
        uRLDocument0.append((String) null);
        fail("Expecting exception: MalformedURLException");
      
      } catch(MalformedURLException e) {
         //
         // no protocol: null/null
         //
         verifyException("java.net.URL", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      uRLDocument0.setLocation((Object) null);
      // Undeclared exception!
      try { 
        uRLDocument0.append("#l~<E#>#Dh2");
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.net.MockURL", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      URLStreamHandler uRLStreamHandler0 = mock(URLStreamHandler.class, new ViolatedAssumptionAnswer());
      URL uRL0 = MockURL.URL(".gz", ":2", 10000, ".gz", uRLStreamHandler0);
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      Object object0 = new Object();
      uRLDocument0.setLocation(object0);
      // Undeclared exception!
      try { 
        uRLDocument0.append(".gz");
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // java.lang.Object cannot be cast to java.net.URL
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      URLDocument uRLDocument0 = null;
      try {
        uRLDocument0 = new URLDocument((URL) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      EvoSuiteURL evoSuiteURL0 = new EvoSuiteURL("http://www.someFakeButWellFormedURL.org/fooExample");
      NetworkHandling.createRemoteTextFile(evoSuiteURL0, ".gz");
      InputStream inputStream0 = uRLDocument0.getInputStream();
      assertNotNull(inputStream0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      boolean boolean0 = uRLDocument0.readable();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      try { 
        uRLDocument0.getOutputStream();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // this Document can not be written to
         //
         verifyException("uk.ac.sanger.artemis.util.URLDocument", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      boolean boolean0 = uRLDocument0.writable();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      Document document0 = uRLDocument0.getParent();
      assertNotNull(document0);
      assertEquals("www.someFakeButWellFormedURL.org", document0.getName());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      Document document0 = uRLDocument0.append("fooExample");
      assertEquals("fooExample", document0.getName());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      URL uRL0 = MockURL.getHttpExample();
      URLDocument uRLDocument0 = new URLDocument(uRL0);
      String string0 = uRLDocument0.getName();
      assertEquals("fooExample", string0);
  }
}
