/*
 * This file was automatically generated by EvoSuite
 * Wed Jun 06 18:20:03 GMT 2018
 */

package uk.ac.sanger.artemis.sequence;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import java.io.IOException;
import java.io.StringReader;
import org.biojava.bio.symbol.DNANoAmbPack;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.PackedSymbolList;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.sequence.AminoAcidSequence;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.MarkerInternal;
import uk.ac.sanger.artemis.sequence.MarkerRange;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class AminoAcidSequence_ESTest extends AminoAcidSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test000()  throws Throwable  {
      char[] charArray0 = new char[15];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      
      Strand strand0 = new Strand(bases0, ';');
      assertNotNull(strand0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      
      Marker marker0 = strand0.makeMarker((short)2888);
      assertNotNull(marker0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2888, marker0.getPosition());
      
      MarkerRange markerRange0 = new MarkerRange(marker0);
      assertNotNull(markerRange0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2888, marker0.getPosition());
      assertFalse(markerRange0.isForwardMarker());
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("xxxxx", string0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.findMatch(bases0, marker0, false, true, true);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test001()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = new Strand(bases0, 5);
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = selection0.getSelectionText();
      assertNotNull(string0);
      assertEquals("", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string1);
      assertEquals("Arg", string1);
      assertFalse(string1.equals((Object)string0));
      
      MarkerRange markerRange1 = aminoAcidSequence1.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(markerRange1.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertNotSame(markerRange1, markerRange0);
      
      String string2 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string2);
      assertEquals("Gln", string2);
      assertFalse(string2.equals((Object)string0));
      assertFalse(string2.equals((Object)string1));
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('=');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test002()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("The result class was null when trying to get results for ResultMap named ");
      assertEquals('\uFFFF', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('`');
      assertFalse(boolean0);
      
      System.setCurrentTimeMillis((-1579L));
  }

  @Test(timeout = 4000)
  public void test003()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('<');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test004()  throws Throwable  {
      char char0 = 'Z';
      int int0 = AminoAcidSequence.getAminoAcidType('Z');
      assertEquals(7, int0);
      
      char char1 = '/';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('/');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: /
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test005()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('D');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('5');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(63, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      int int2 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int2);
      assertTrue(int2 == int1);
      assertFalse(int2 == int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(1);
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean1 = AminoAcidSequence.isLegalCodon('3');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test006()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('3');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test007()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = selection0.getSelectionText();
      assertNotNull(string0);
      assertEquals("", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string1);
      assertEquals("Arg", string1);
      assertFalse(string1.equals((Object)string0));
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertTrue(markerRange0.isForwardMarker());
      
      String string2 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string2);
      assertEquals("Gln", string2);
      assertFalse(string2.equals((Object)string0));
      assertFalse(string2.equals((Object)string1));
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('7');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test008()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('?');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('?');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('?');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      char[] charArray0 = new char[1];
      charArray0[0] = '?';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'?'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test009()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('B', 'B', 'B');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('.', '.', 'B');
      assertEquals('.', char1);
      assertTrue(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("T#hr", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      char char2 = AminoAcidSequence.getCodonTranslation("T#hr");
      assertEquals('.', char2);
      assertTrue(char2 == char1);
      assertTrue(char2 == char0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char3 = AminoAcidSequence.getOneLetterCode("F|awc;rdec\"\"[");
      assertEquals('\uFFFF', char3);
      assertFalse(char3 == char1);
      assertFalse(char3 == char2);
      assertFalse(char3 == char0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-120.03998F), float0, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(21, aminoAcidSequence2.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = new AminoAcidSequence("A2'[$reD}%=V3.");
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("A2'[$reD}%=V3.", aminoAcidSequence3.toString());
      assertEquals(14, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('B');
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('1');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('.');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(63, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test010()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("U/<Gc]$\"HOf8Y+&4<");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("U/<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("U/<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("U/<Gc]$\"HOf8Y+&4<");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("U/<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("U/<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char2 = AminoAcidSequence.getCodonTranslation("U/<Gc]$\"HOf8Y+&4<");
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertTrue(char2 == char1);
      
      char char3 = new Character('.');
      assertEquals('.', char3);
      assertTrue(char3 == char1);
      assertFalse(char3 == char0);
      assertTrue(char3 == char2);
      
      int int0 = AminoAcidSequence.getSymbolIndex('H');
      assertEquals(8, int0);
      
      char char4 = aminoAcidSequence1.elementAt(25);
      assertEquals(' ', char4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(char4 == char0);
      assertFalse(char4 == char1);
      assertFalse(char4 == char2);
      assertFalse(char4 == char3);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("U/<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: /
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test011()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('D');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('5');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('5');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 5
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test012()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("U*<Gc]$\"HOf8Y+&4<");
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      char char2 = AminoAcidSequence.getCodonTranslation("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertTrue(char2 == char1);
      
      char char3 = AminoAcidSequence.getCodonTranslation('\uFFFF', '.', '.');
      assertEquals('.', char3);
      assertTrue(char3 == char2);
      assertTrue(char3 == char1);
      assertFalse(char3 == char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('5');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 5
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test013()  throws Throwable  {
      String string0 = "~~AZ.:-?Z~f";
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("~~AZ.:-?Z~f", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('%');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: %
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test014()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      char char0 = '<';
      boolean boolean0 = AminoAcidSequence.isStopCodon('<');
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(':');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: :
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test015()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = strand0.makeMarker(1);
      assertNotNull(marker0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1, marker0.getPosition());
      assertSame(bases0, bases1);
      
      Strand.addBases(marker0, "7\">]Y&");
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(12, fastaStreamSequence0.length());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(7, marker0.getPosition());
      assertSame(bases0, bases1);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, marker0, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(12, fastaStreamSequence0.length());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(7, marker0.getPosition());
      assertTrue(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      MarkerRange markerRange1 = aminoAcidSequence1.findMatch(bases0, marker0, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertTrue(markerRange1.isForwardMarker());
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(12, fastaStreamSequence0.length());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(7, marker0.getPosition());
      assertNotSame(markerRange1, markerRange0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string1);
      assertEquals("Gln", string1);
      assertFalse(string1.equals((Object)string0));
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test016()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('G');
      assertEquals(4, int0);
      
      System.setCurrentTimeMillis(4);
      boolean boolean0 = AminoAcidSequence.isLegalCodon('G');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(4);
      assertEquals('c', char0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(4);
      assertEquals('c', char1);
      assertTrue(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("JNk", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      
      DNANoAmbPack dNANoAmbPack0 = new DNANoAmbPack((byte) (-5));
      assertNotNull(dNANoAmbPack0);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      
      Clipboard clipboard0 = new Clipboard(" AW]AH_0");
      assertNotNull(clipboard0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("_jyf4WI:(Jf!", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("xxxx", aminoAcidSequence1.toString());
      assertEquals(4, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char2 = AminoAcidSequence.getCodonTranslation('\u001B', 'B', '6');
      assertEquals('.', char2);
      assertFalse(char2 == char1);
      assertFalse(char2 == char0);
      
      boolean boolean1 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean1 == boolean0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals("xxxx", aminoAcidSequence1.toString());
      assertEquals(4, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('6');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 6
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test017()  throws Throwable  {
      char char0 = 'E';
      boolean boolean0 = AminoAcidSequence.isLegalCodon('E');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('E');
      assertEquals(2, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('E');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("YQZDd\"!sASErYBNDhVz", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(18, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("*={f9%x@5))i}", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("x  x  x  x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(12, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('6');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 6
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test018()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('>');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("internal error - unexpected exception: ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("xxxxxxxxxxxxx", aminoAcidSequence0.toString());
      assertEquals(13, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-216.18F), float0, 0.01F);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("xxxxxxxxxxxxx", aminoAcidSequence0.toString());
      assertEquals(13, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("xxxxxxxxxxxxx", aminoAcidSequence0.toString());
      assertEquals(13, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("internal error - unexpected exception: ", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("xxxxxxxxxxxxx", aminoAcidSequence2.toString());
      assertEquals(13, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("xxxxxxxxxxxxx", aminoAcidSequence0.toString());
      assertEquals(13, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(63, aminoAcidSequence3.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation("~/ #ue", false);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, aminoAcidSequence4.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("com.ibatis.sqlmap.engine.mapping.result.ResultMapping");
      assertNotNull(rawStreamSequence0);
      assertEquals(42, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getTCount());
      assertEquals(53, rawStreamSequence0.length());
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(42, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getTCount());
      assertEquals(53, rawStreamSequence0.length());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      // Undeclared exception!
      try { 
        featureVector0.lastElement();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test019()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      byte[] byteArray0 = new byte[3];
      byteArray0[0] = (byte)22;
      byteArray0[1] = (byte)27;
      byteArray0[2] = (byte)122;
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertFalse(boolean0);
      assertEquals(3, byteArray0.length);
      assertArrayEquals(new byte[] {(byte)22, (byte)27, (byte)122}, byteArray0);
      
      boolean boolean1 = true;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertFalse(markerRange0.isForwardMarker());
      assertEquals(2, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(']');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ]
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test020()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('K');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('7');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 7
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test021()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('9');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex((-4687));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -4687
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test022()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      
      Strand strand0 = new Strand(bases0, 5);
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = selection0.getSelectionText();
      assertNotNull(string0);
      assertEquals("", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string1);
      assertEquals("Arg", string1);
      assertFalse(string1.equals((Object)string0));
      
      MarkerRange markerRange1 = aminoAcidSequence1.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertTrue(markerRange1.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertNotSame(markerRange1, markerRange0);
      
      String string2 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string2);
      assertEquals("Gln", string2);
      assertFalse(string2.equals((Object)string0));
      assertFalse(string2.equals((Object)string1));
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('5');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test023()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.NEGATIVELY_CHARGED_AA;
      assertEquals(2, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('5');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test024()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('_');
      assertFalse(boolean0);
      
      char char0 = 'j';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test025()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('_');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Sel");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("Sel", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("Sel", aminoAcidSequence0.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('s');
      assertEquals(15, int0);
      
      int int1 = aminoAcidSequence0.length();
      assertEquals(3, int1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(int1 == int0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("Sel", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
  }

  @Test(timeout = 4000)
  public void test026()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      
      Strand strand0 = new Strand(bases0, 5);
      assertNotNull(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = selection0.getSelectionText();
      assertNotNull(string0);
      assertEquals("", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string1);
      assertEquals("Arg", string1);
      assertFalse(string1.equals((Object)string0));
      
      MarkerRange markerRange1 = aminoAcidSequence1.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertTrue(markerRange1.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertNotSame(markerRange1, markerRange0);
      
      String string2 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string2);
      assertEquals("Gln", string2);
      assertFalse(string2.equals((Object)string0));
      assertFalse(string2.equals((Object)string1));
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('4');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test027()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('4');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test028()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, true, true);
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation(" other;");
      assertEquals('.', char0);
      
      AminoAcidSequence.setGeneCode();
      char[] charArray0 = new char[9];
      charArray0[0] = '8';
      charArray0[1] = '8';
      charArray0[2] = '.';
      charArray0[3] = '8';
      charArray0[4] = '8';
      charArray0[5] = '8';
      charArray0[6] = '8';
      boolean boolean1 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      charArray0[7] = '.';
      charArray0[8] = '.';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(9, charArray0.length);
      assertEquals("...", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'8', '8', '.', '8', '8', '8', '8', '.', '.'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Tr", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean2 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Tr", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      float float0 = aminoAcidSequence2.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(7);
      assertNotNull(string0);
      assertEquals("Gly", string0);
      
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-36.03F), float1, 0.01F);
      assertNotEquals(float1, float0, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(9, charArray0.length);
      assertEquals("...", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'8', '8', '.', '8', '8', '8', '8', '.', '.'}, charArray0);
      
      boolean boolean3 = aminoAcidSequence2.containsStopCodon();
      assertFalse(boolean3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertTrue(boolean3 == boolean0);
      assertTrue(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('8');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 8
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test029()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('7');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 7
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test030()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      char[] charArray0 = new char[3];
      charArray0[0] = 'I';
      boolean boolean1 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      charArray0[1] = 'k';
      charArray0[2] = '[';
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'I', 'k', '['}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Val", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('k');
      assertNotNull(string0);
      assertEquals("Lys", string0);
      
      int int0 = aminoAcidSequence0.length();
      assertEquals(3, int0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'I', 'k', '['}, charArray0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('*');
      assertEquals(5, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('[');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: [
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test031()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[0] = '5';
      charArray0[1] = 'Q';
      charArray0[2] = '<';
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(3, charArray0.length);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'5', 'Q', '<'}, charArray0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('Q');
      assertEquals(5, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('.');
      assertNotNull(string0);
      assertEquals("---", string0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('<');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: <
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test032()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "2}obl&7]akp4w~x,q=;");
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('\\');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(",K", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
  }

  @Test(timeout = 4000)
  public void test033()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, (String) null);
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('\\');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test034()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, true, true);
      assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "A4-F&<S0$6h#6K");
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('&');
      assertEquals(7, int0);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('&');
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('C');
      assertNotNull(string0);
      assertEquals("Cys", string0);
  }

  @Test(timeout = 4000)
  public void test035()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("U*<Gc]$\"HOf8Y+&4<");
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char2 = AminoAcidSequence.getCodonTranslation("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertTrue(char2 == char1);
      
      char char3 = AminoAcidSequence.getCodonTranslation('\uFFFF', '.', '.');
      assertEquals('.', char3);
      assertTrue(char3 == char1);
      assertFalse(char3 == char0);
      assertTrue(char3 == char2);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('>');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: >
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test036()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence.setGeneCode();
      boolean boolean1 = AminoAcidSequence.isLegalCodon('#');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      char char0 = '^';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('^');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ^
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test037()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, false);
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("The location of the clint's pcs#8 ssl key");
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("The location of the clint's pcs#8 ssl key", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(41, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("The location of the clint's pcs#8 ssl key", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(41, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("The location of the clint's pcs#8 ssl key", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(41, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertEquals(21, aminoAcidSequence2.length());
      assertEquals("............f.......g", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('x');
      assertEquals(23, int0);
      
      int int1 = aminoAcidSequence0.length();
      assertEquals(41, int1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(int1 == int0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("The location of the clint's pcs#8 ssl key", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(41, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertTrue(boolean1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(boolean1 == boolean0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("The location of the clint's pcs#8 ssl key", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(41, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean2 = AminoAcidSequence.isLegalCodon('x');
      assertFalse(boolean2);
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('^');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ^
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test038()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("Gly");
      assertEquals('g', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('g');
      assertEquals(7, int0);
      
      Range range0 = new Range(2);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      assertEquals(2, range0.getEnd());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('9');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 9
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test039()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation(';', 'Y', '-');
      assertEquals('.', char0);
      
      String string0 = "VCFHeaderLine: ID cannot contain angle brackets";
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("VCFHeaderLine: ID cannot contain angle brackets");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("VCFHeaderLine: ID cannot contain angle brackets", aminoAcidSequence0.toString());
      assertEquals(47, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: :
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test040()  throws Throwable  {
      int int0 = AminoAcidSequence.ILLEGAL_AA;
      assertEquals(7, int0);
      
      AminoAcidSequence.setGeneCode();
      char[] charArray0 = new char[5];
      charArray0[0] = '(';
      charArray0[1] = '(';
      charArray0[4] = '(';
      charArray0[3] = '(';
      charArray0[4] = '(';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, charArray0.length);
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'(', '(', '\u0000', '(', '('}, charArray0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\'');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: '
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test041()  throws Throwable  {
      char char0 = '=';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('=');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: =
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test042()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("arM", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("arM", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("Phv", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence2.length());
      assertEquals("x", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('=');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: =
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test043()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('8');
      assertFalse(boolean0);
      
      SymbolList symbolList0 = DoubleAlphabet.fromArray((double[]) null);
      assertNotNull(symbolList0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(symbolList0);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Entry entry0 = Entry.newEntry(bases0);
      assertNotNull(entry0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertFalse(entry0.isReadOnly());
      
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Location location0 = null;
      try {
        location0 = new Location("uk.ac.sanger.artemis.components.FeatureDisplay$2");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Parse error at this point: java.lang.String@0000000018java.lang.Integer@0000000019: parse error after reading \"uk.ac.sanger.artemis.components.FeatureDisplay\"
         //
         verifyException("uk.ac.sanger.artemis.io.Location", e);
      }
  }

  @Test(timeout = 4000)
  public void test044()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, false, true);
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean1 = AminoAcidSequence.isLegalCodon('8');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('8');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('_');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: _
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test045()  throws Throwable  {
      char char0 = 'I';
      char char1 = AminoAcidSequence.getCodonTranslation('I', 'I', 'I');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      char char2 = AminoAcidSequence.getCodonTranslation('.', '.', 'I');
      assertEquals('.', char2);
      assertTrue(char2 == char1);
      assertFalse(char2 == char0);
      
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      char char3 = AminoAcidSequence.getOneLetterCode("Thr");
      assertEquals('t', char3);
      assertFalse(char3 == char0);
      assertFalse(char3 == char2);
      assertFalse(char3 == char1);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-120.03998F), float0, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = new AminoAcidSequence("A2'[$reD}%=V3.");
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(14, aminoAcidSequence2.length());
      assertEquals("A2'[$reD}%=V3.", aminoAcidSequence2.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('3');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 3
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test046()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("The location of the client's PKCS#8 SSL key");
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("*xX3)6]^h");
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(9, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("*xX3)6]^h", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 3
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test047()  throws Throwable  {
      byte[] byteArray0 = new byte[9];
      byteArray0[1] = (byte) (-99);
      byteArray0[2] = (byte) (-1);
      byteArray0[3] = (byte)13;
      byteArray0[4] = (byte)7;
      byteArray0[7] = (byte)44;
      byteArray0[7] = (byte)20;
      byteArray0[8] = (byte)12;
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('q');
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Gln");
      assertNotNull(aminoAcidSequence0);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('q');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Phe");
      assertEquals('f', char0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(302.34F, float0, 0.01F);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      int int0 = AminoAcidSequence.getAminoAcidType('[');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('[');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(21);
      assertEquals('#', char1);
      assertFalse(char1 == char0);
      
      char char2 = AminoAcidSequence.getCodonTranslation('q', 'f', '');
      assertEquals('.', char2);
      assertFalse(char2 == char1);
      assertFalse(char2 == char0);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('(');
      assertFalse(boolean2);
      assertFalse(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      
      int int1 = AminoAcidSequence.getAminoAcidType('#');
      assertEquals(5, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertEquals(21, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('&');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: &
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test048()  throws Throwable  {
      char[] charArray0 = new char[15];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      
      Strand strand0 = new Strand(bases0, ';');
      assertNotNull(strand0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      
      Marker marker0 = markerInternal0.parent;
      assertNull(marker0);
      assertEquals(15, charArray0.length);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertNull(markerRange0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("xxxxx", string0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, (Marker) null, false, true, true);
      assertNull(markerRange1);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(15, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test049()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("&dl67&B", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('?');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ?
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test050()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Strand strand0 = new Strand(bases0, '\u0000');
      assertNotNull(strand0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Marker marker0 = markerInternal0.parent;
      assertNull(marker0);
      assertEquals(2, charArray0.length);
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      boolean boolean0 = false;
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertNull(markerRange0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      boolean boolean1 = true;
      boolean boolean2 = true;
      EvoSuiteFile evoSuiteFile0 = null;
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertNull(markerRange1);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      byte[] byteArray0 = new byte[3];
      byteArray0[0] = (byte)61;
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(';');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ;
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test051()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon(')');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("PLC;BP~", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("..", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
  }

  @Test(timeout = 4000)
  public void test052()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[1] = '-';
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      int int0 = 954;
      char[] charArray1 = new char[4];
      assertFalse(charArray1.equals((Object)charArray0));
      
      charArray1[2] = 'x';
      charArray1[3] = '-';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('-');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: -
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test053()  throws Throwable  {
      char char0 = '-';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('-');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: -
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test054()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Strand strand0 = new Strand(bases0, ';');
      assertNotNull(strand0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Marker marker0 = markerInternal0.parent;
      assertNull(marker0);
      assertEquals(2, charArray0.length);
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      assertNull(markerRange0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange1);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertTrue(markerRange1.isForwardMarker());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('s');
      assertEquals(15, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('-');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test055()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('-');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('-');
      assertEquals(7, int0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = "Ocr";
      boolean boolean1 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "Ocr");
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('_');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: _
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test056()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('G');
      assertEquals(4, int0);
      
      System.setCurrentTimeMillis(4);
      boolean boolean0 = AminoAcidSequence.isLegalCodon('G');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('G', 'G', 'G');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(4);
      assertEquals('c', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("JNk", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      DNANoAmbPack dNANoAmbPack0 = new DNANoAmbPack((byte) (-5));
      assertNotNull(dNANoAmbPack0);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      
      long[] longArray0 = new long[7];
      longArray0[0] = (long) 4;
      longArray0[1] = (long) 5;
      longArray0[2] = (long) 4;
      longArray0[3] = (long) 2;
      longArray0[4] = (long) 2;
      longArray0[5] = (long) 2;
      longArray0[6] = (long) 'c';
      PackedSymbolList packedSymbolList0 = new PackedSymbolList(dNANoAmbPack0, longArray0, 4);
      assertNotNull(packedSymbolList0);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 2L, 99L}, longArray0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(packedSymbolList0);
      assertNotNull(bioJavaSequence0);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 2L, 99L}, longArray0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 2L, 99L}, longArray0);
      
      Clipboard clipboard0 = new Clipboard(" AW]AH_0");
      assertNotNull(clipboard0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.findMatch(bases0, (Marker) null, false, false, true);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class org.biojava.bio.seq.DNATools
         //
         verifyException("org.biojava.bio.symbol.DNANoAmbPack", e);
      }
  }

  @Test(timeout = 4000)
  public void test057()  throws Throwable  {
      char char0 = ',';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(',');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ,
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test058()  throws Throwable  {
      System.setCurrentTimeMillis((-1938L));
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(',');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ,
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test059()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('T');
      assertEquals(16, int0);
      
      char[] charArray0 = new char[6];
      charArray0[0] = 'T';
      charArray0[1] = 'T';
      charArray0[2] = 'T';
      charArray0[3] = 'T';
      charArray0[4] = 'T';
      charArray0[5] = '<';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, charArray0.length);
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'T', 'T', 'T', 'T', 'T', '<'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("nYi&k`GR)t)", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(9, aminoAcidSequence1.length());
      assertEquals(".  .  .  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(')');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: )
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test060()  throws Throwable  {
      char char0 = ')';
      char char1 = AminoAcidSequence.getCodonTranslation(')', '`', '`');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(')');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: )
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test061()  throws Throwable  {
      char[] charArray0 = new char[9];
      charArray0[0] = 'O';
      charArray0[1] = 'o';
      charArray0[2] = '/';
      charArray0[3] = '';
      charArray0[4] = 'B';
      charArray0[5] = 'q';
      charArray0[6] = '{';
      charArray0[7] = '|';
      charArray0[8] = 't';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(9, charArray0.length);
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'O', 'o', '/', '', 'B', 'q', '{', '|', 't'}, charArray0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-36.03F), float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(9, charArray0.length);
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'O', 'o', '/', '', 'B', 'q', '{', '|', 't'}, charArray0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('O');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: o
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test062()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('6');
      assertFalse(boolean0);
      
      char char0 = '0';
      boolean boolean1 = AminoAcidSequence.isLegalCodon('0');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      char[] charArray0 = new char[3];
      charArray0[0] = '0';
      charArray0[1] = '0';
      charArray0[2] = '0';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'0', '0', '0'}, charArray0);
      
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      MarkerInternal markerInternal0 = null;
      try {
        markerInternal0 = new MarkerInternal(strand0, 2);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test063()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("j0^W:x|./FTAM[h{a", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("......", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("......", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("......", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(21, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("j0^W:x|./FTAM[h{a");
      assertEquals('\uFFFF', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('L');
      assertTrue(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('$');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: $
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test064()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('$');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: $
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test065()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('R');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('\'');
      assertFalse(boolean0);
      
      char[] charArray0 = new char[8];
      charArray0[0] = 'R';
      charArray0[1] = '5';
      charArray0[2] = '\'';
      charArray0[3] = '\'';
      charArray0[4] = 'R';
      charArray0[5] = 'R';
      charArray0[6] = 'R';
      charArray0[7] = '\'';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'R', '5', '\'', '\'', 'R', 'R', 'R', '\''}, charArray0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'R', '5', '\'', '\'', 'R', 'R', 'R', '\''}, charArray0);
  }

  @Test(timeout = 4000)
  public void test066()  throws Throwable  {
      char char0 = 'c';
      int int0 = AminoAcidSequence.getAminoAcidType('c');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('J');
      assertFalse(boolean0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('c', '[', 'J');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(1607);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 1607
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test067()  throws Throwable  {
      char char0 = 'j';
      boolean boolean0 = AminoAcidSequence.isLegalCodon('j');
      assertFalse(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test068()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('U');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("To'sgs|2~zr7%zBG,d");
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(18, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("To'sgs|2~zr7%zBG,d", aminoAcidSequence0.toString());
  }

  @Test(timeout = 4000)
  public void test069()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('2');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test070()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("-[)DNv7~c@y=;");
      assertEquals('\uFFFF', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("-[)DNv7~c@y=;", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxx", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxx", aminoAcidSequence0.toString());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\uFFFF');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: \uFFFF
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test071()  throws Throwable  {
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('`');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: `
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test072()  throws Throwable  {
      char[] charArray0 = new char[0];
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {}, charArray0);
      
      String string0 = "";
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('4');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 4
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test073()  throws Throwable  {
      char char0 = '\\';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\\');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: \\
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test074()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("nj6!`(mZPQBL{{5@r");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      assertEquals("nj6!`(mZPQBL{{5@r", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test075()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('&');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('@');
      assertFalse(boolean0);
      
      String string0 = "";
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      // Undeclared exception!
      try { 
        linePushBackReader0.read((char[]) null, 0, 0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.BufferedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test076()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      char char0 = 'd';
      char char1 = AminoAcidSequence.getCodonTranslation('d', 'd', '0');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("-XQRt\",|w]A%;UZP ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(5, aminoAcidSequence0.length());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('0');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test077()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('M');
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test078()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      char char0 = 'd';
      char char1 = AminoAcidSequence.getCodonTranslation('d', 'd', '0');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('0');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test079()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('%');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("history", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test080()  throws Throwable  {
      String string0 = "---";
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "---");
      assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      boolean boolean2 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, true, false);
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2 == boolean1);
      
      char[] charArray0 = new char[2];
      charArray0[0] = 'C';
      charArray0[1] = '#';
      boolean boolean3 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean3);
      assertTrue(boolean3 == boolean2);
      assertFalse(boolean3 == boolean1);
      assertTrue(boolean3 == boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'C', '#'}, charArray0);
      
      StringReader stringReader0 = new StringReader("g> B6As.*");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.length());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.findMatch(bases0, (Marker) null, false, true, false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: position: 0
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test081()  throws Throwable  {
      char char0 = 'q';
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('q');
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      char char1 = 'W';
      int int0 = AminoAcidSequence.getAminoAcidType('W');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('*');
      assertEquals(5, int1);
      assertFalse(int1 == int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('q');
      assertTrue(boolean0);
      
      Key key0 = new Key("8");
      assertNotNull(key0);
      assertEquals("8", key0.toString());
      assertEquals(1, key0.length());
      assertEquals("8", key0.getKeyString());
      
      Range range0 = new Range('*');
      assertNotNull(range0);
      assertEquals(42, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(42, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(42, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(42, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(blastStreamFeature0);
      assertEquals("8", key0.toString());
      assertEquals(1, key0.length());
      assertEquals("8", key0.getKeyString());
      assertEquals(42, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(42, range0.getStart());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('W');
      assertTrue(boolean1);
      assertTrue(boolean1 == boolean0);
      
      Feature feature0 = new Feature(blastStreamFeature0);
      assertNotNull(feature0);
      assertEquals("8", key0.toString());
      assertEquals(1, key0.length());
      assertEquals("8", key0.getKeyString());
      assertEquals(42, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(42, range0.getStart());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(feature0.isReadOnly());
      
      boolean boolean2 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Ile", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        feature0.addQualifierValues((Qualifier) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Feature", e);
      }
  }

  @Test(timeout = 4000)
  public void test082()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertNotNull(string0);
      assertEquals("Ala", string0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon(';');
      assertFalse(boolean0);
      
      char[] charArray0 = new char[3];
      charArray0[0] = ';';
      charArray0[1] = ';';
      charArray0[2] = ';';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', ';', ';'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Ala", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(".", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('#');
      assertEquals(21, int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("Ala", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, aminoAcidSequence2.length());
      assertEquals("x", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertTrue(boolean1 == boolean0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {';', ';', ';'}, charArray0);
      
      int int1 = AminoAcidSequence.getAminoAcidType(';');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test083()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Jn/g", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, aminoAcidSequence1.length());
      assertEquals(".", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("A/", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      partialSequence0.clear();
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      int int0 = strand0.getACount();
      assertEquals(0, int0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      bases0.reverseComplement();
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, false, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, marker0, false, false, true);
      assertNotNull(markerRange1);
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertFalse(markerRange1.isForwardMarker());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(markerRange1, markerRange0);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange2 = aminoAcidSequence0.findMatch(bases0, marker0, true, true, false);
      assertNull(markerRange2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('-', '*', '-');
      assertEquals('.', char0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('<');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation((-1461));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1461
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test084()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      int int0 = AminoAcidSequence.getAminoAcidType(';');
      assertEquals(7, int0);
      
      System.setCurrentTimeMillis(1634L);
  }

  @Test(timeout = 4000)
  public void test085()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('N');
      assertTrue(boolean0);
      
      char[] charArray0 = new char[1];
      boolean boolean1 = AminoAcidSequence.isStopCodon('\u0000');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test086()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("No sequence for ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("No sequence for ", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(".  .  .  .  .  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(15, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('t');
      assertEquals(16, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertNotNull(string0);
      assertEquals("Thr", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(2);
      assertNotNull(string1);
      assertEquals("Asn", string1);
      assertFalse(string1.equals((Object)string0));
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(15, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('@');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test087()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('@');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(12304);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 12304
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test088()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('B');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test089()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertEquals("", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('*');
      assertEquals(20, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('5');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int2 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int2);
      assertTrue(int2 == int1);
      assertFalse(int2 == int0);
  }

  @Test(timeout = 4000)
  public void test090()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("S", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('V', '3', '3');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test091()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-321), (-2227), short0, (Integer) 7);
      assertNotNull(partialSequence0);
      assertEquals(2, charArray0.length);
      assertEquals((-321), partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(7, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals((-321), partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(7, (int)partialSequence0.getPhase());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals((-321), partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(7, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals((-321), partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(7, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals((-321), partialSequence0.length());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(7, (int)partialSequence0.getPhase());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Clipboard clipboard0 = new Clipboard("");
      assertNotNull(clipboard0);
      assertEquals("", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals("", clipboard0.getName());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.findMatch(bases1, (Marker) null, true, true, false);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test092()  throws Throwable  {
      System.setCurrentTimeMillis(276L);
      int int0 = AminoAcidSequence.getAminoAcidType('9');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test093()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("No sequence for ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(15, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("No sequence for ", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence1.toString());
      assertEquals(15, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('H');
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test094()  throws Throwable  {
      int int0 = AminoAcidSequence.SPECIAL_AA;
      assertEquals(4, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('T');
      assertEquals(0, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test095()  throws Throwable  {
      System.setCurrentTimeMillis((-3668L));
      int int0 = AminoAcidSequence.getAminoAcidType('H');
      assertEquals(1, int0);
      
      char char0 = new Character('H');
      assertEquals('H', char0);
  }

  @Test(timeout = 4000)
  public void test096()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals((-4), marker0.getPosition());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, false, false, true);
      assertNull(markerRange0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals((-4), marker0.getPosition());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, marker0, true, false, true);
      assertNotNull(markerRange1);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals((-4), marker0.getPosition());
      assertFalse(markerRange1.isForwardMarker());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('#');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('-');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test097()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("!yCS ui", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x  x  ", aminoAcidSequence1.toString());
      assertEquals(6, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("!yCS ui", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("x  x  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(6, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation(aminoAcidSequence2.codon_translation_array, true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("x  x  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(6, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(21, aminoAcidSequence3.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation(aminoAcidSequence3.codon_translation_array, true);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("x  x  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(6, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(21, aminoAcidSequence3.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence4.toString());
      assertEquals(21, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getTranslation("uk.ac.sanger.a5temis.cado.IBaxisDAO", true);
      assertNotNull(aminoAcidSequence5);
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertEquals(11, aminoAcidSequence5.length());
      assertEquals("xxxxxxxxxxx", aminoAcidSequence5.toString());
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getCodonTranslation("colour_6");
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char1);
      assertTrue(char1 == char0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getAminoAcidType('6');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test098()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('D');
      assertEquals(2, int0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = AminoAcidSequence.isStopCodon('D');
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Pool.maximumactiveconnections", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("....t....", aminoAcidSequence0.toString());
      assertEquals(9, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
  }

  @Test(timeout = 4000)
  public void test099()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Fn$]7%#yfW ?");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals("Fn$]7%#yfW ?", aminoAcidSequence0.toString());
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertTrue(boolean0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals("Fn$]7%#yfW ?", aminoAcidSequence0.toString());
  }

  @Test(timeout = 4000)
  public void test100()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, (String) null);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      boolean boolean2 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, ")9,;p[w~da/x={hw");
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      
      boolean boolean3 = AminoAcidSequence.isLegalCodon('$');
      assertFalse(boolean3);
      assertTrue(boolean3 == boolean2);
      assertTrue(boolean3 == boolean0);
      assertTrue(boolean3 == boolean1);
      
      int int0 = AminoAcidSequence.getAminoAcidType('$');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(7);
      assertEquals('g', char0);
  }

  @Test(timeout = 4000)
  public void test101()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getCodonTranslation("\tOuter: ");
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('V');
      assertEquals(3, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(32);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 32
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test102()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("y2`6+E*f4rlK", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(12, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      int int0 = AminoAcidSequence.getAminoAcidType('Q');
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test103()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('6');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('6');
      assertEquals(7, int0);
      
      boolean boolean1 = new Boolean(false);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test104()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('l');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test105()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("O3SD,]w~e4:Qc:{UHo", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("O3SD,]w~e4:Qc:{UHo", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(18, aminoAcidSequence1.length());
      assertEquals("x  x  x  x  x  x  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("/:U:5J4b-p=I;mSiYY", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(6, aminoAcidSequence2.length());
      assertEquals("xxxxxx", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Fr");
      assertEquals('\uFFFF', char0);
      
      int int0 = aminoAcidSequence0.length();
      assertEquals(6, int0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('S');
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(18, aminoAcidSequence1.length());
      assertEquals("x  x  x  x  x  x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence3.toString());
      assertEquals(63, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      String string0 = aminoAcidSequence3.toString();
      assertNotNull(string0);
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", string0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(18, aminoAcidSequence1.length());
      assertEquals("x  x  x  x  x  x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence3.toString());
      assertEquals(63, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test106()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('S');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('S');
      assertEquals(0, int0);
      
      boolean boolean1 = new Boolean(true);
      assertTrue(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test107()  throws Throwable  {
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {}, charArray0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('X');
      assertEquals(23, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('k');
      assertNotNull(string0);
      assertEquals("Lys", string0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("|C(?F4JK#{", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("...", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('*');
      assertTrue(boolean0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('x');
      assertEquals(23, int1);
      assertTrue(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("S>[)", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      float float0 = aminoAcidSequence2.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("x", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(0);
      assertEquals('a', char0);
  }

  @Test(timeout = 4000)
  public void test108()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("7~BnP!ZpTa;evS!rW");
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      AminoAcidSequence.setGeneCode();
      int int1 = AminoAcidSequence.getAminoAcidType('X');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      System.setCurrentTimeMillis(410L);
  }

  @Test(timeout = 4000)
  public void test109()  throws Throwable  {
      String string0 = null;
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test110()  throws Throwable  {
      char char0 = '|';
      int int0 = AminoAcidSequence.getAminoAcidType('|');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('|');
      assertFalse(boolean0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('[', '[', '?');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      String string0 = null;
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test111()  throws Throwable  {
      char[] charArray0 = new char[2];
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('*');
      assertTrue(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex((short)2888);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 2888
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test112()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("IA}O=w$iu8QJ<q{*I-");
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("IA}O=w$iu8QJ<q{*I-", aminoAcidSequence0.toString());
      assertEquals(19, aminoAcidSequence0.length());
      
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertTrue(boolean0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("IA}O=w$iu8QJ<q{*I-", aminoAcidSequence0.toString());
      assertEquals(19, aminoAcidSequence0.length());
  }

  @Test(timeout = 4000)
  public void test113()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('X');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('X');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('X');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('X');
      assertEquals(7, int1);
      assertTrue(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test114()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('D');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('D');
      assertEquals(2, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('D');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test115()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('M');
      assertEquals(12, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('\'');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      char[] charArray0 = new char[9];
      charArray0[0] = '\'';
      charArray0[1] = 'Q';
      charArray0[2] = 'M';
      charArray0[4] = 'M';
      charArray0[6] = '\'';
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(9, charArray0.length);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'\'', 'Q', 'M', '\u0000', 'M', '\u0000', '\'', '\u0000', '\u0000'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(9, charArray0.length);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("...", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertArrayEquals(new char[] {'\'', 'Q', 'M', '\u0000', 'M', '\u0000', '\'', '\u0000', '\u0000'}, charArray0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('Q');
      assertEquals(5, int2);
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("The location of the client's PKCS#8 SSL key", false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(".  .  h  .  .  .  .  .  .  .  .  .  .  .  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(42, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int3 = AminoAcidSequence.getSymbolIndex('Q');
      assertEquals(5, int3);
      assertFalse(int3 == int0);
      assertFalse(int3 == int1);
      assertTrue(int3 == int2);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(boolean1 == boolean0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(9, charArray0.length);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxx", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'\'', 'Q', 'M', '\u0000', 'M', '\u0000', '\'', '\u0000', '\u0000'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence3 = new AminoAcidSequence("uk.ac.sanger.artemis.plot.GCFrameAlgorithm");
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", aminoAcidSequence3.toString());
      assertEquals(42, aminoAcidSequence3.length());
      
      boolean boolean2 = aminoAcidSequence1.checkForMatch(aminoAcidSequence3);
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean1);
      assertFalse(boolean2 == boolean0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(9, charArray0.length);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("...", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", aminoAcidSequence3.toString());
      assertEquals(42, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertArrayEquals(new char[] {'\'', 'Q', 'M', '\u0000', 'M', '\u0000', '\'', '\u0000', '\u0000'}, charArray0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence3.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: o
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test116()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('#');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test117()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('P');
      assertEquals(14, int0);
      
      char char0 = 'H';
      int int1 = AminoAcidSequence.getSymbolIndex('H');
      assertEquals(8, int1);
      assertFalse(int1 == int0);
      
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getOneLetterCode("");
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test118()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('?');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("P{`?)!P1+`|E");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(13, aminoAcidSequence0.length());
      assertEquals("P{`?)!P1+`|E", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('?');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test119()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('*');
      assertEquals(20, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('*');
      assertEquals(20, int1);
      assertTrue(int1 == int0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('v');
      assertEquals(19, int2);
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      
      int int3 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int3);
      assertFalse(int3 == int1);
      assertFalse(int3 == int0);
      assertFalse(int3 == int2);
      
      int int4 = aminoAcidSequence0.length();
      assertEquals(0, int4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(int4 == int3);
      assertFalse(int4 == int2);
      assertFalse(int4 == int1);
      assertFalse(int4 == int0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      int int5 = AminoAcidSequence.getSymbolIndex('f');
      assertEquals(13, int5);
      assertFalse(int5 == int2);
      assertFalse(int5 == int3);
      assertFalse(int5 == int1);
      assertFalse(int5 == int0);
      assertFalse(int5 == int4);
  }

  @Test(timeout = 4000)
  public void test120()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('V');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test121()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('U');
      assertEquals(7, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('*');
      assertEquals(5, int1);
      assertFalse(int1 == int0);
      
      char char0 = 'B';
      boolean boolean0 = AminoAcidSequence.isLegalCodon('B');
      assertFalse(boolean0);
      
      Key key0 = new Key("8");
      assertNotNull(key0);
      assertEquals(1, key0.length());
      assertEquals("8", key0.getKeyString());
      assertEquals("8", key0.toString());
      
      Range range0 = new Range('*');
      assertNotNull(range0);
      assertEquals(42, range0.getEnd());
      assertEquals(42, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(42, range0.getEnd());
      assertEquals(42, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      
      BlastStreamFeature blastStreamFeature0 = new BlastStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(blastStreamFeature0);
      assertEquals(1, key0.length());
      assertEquals("8", key0.getKeyString());
      assertEquals("8", key0.toString());
      assertEquals(42, range0.getEnd());
      assertEquals(42, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      
      boolean boolean1 = location0.isComplement(range0);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      assertEquals(42, range0.getEnd());
      assertEquals(42, range0.getStart());
      assertEquals(1, range0.getCount());
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('B');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: b
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test122()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', '2');
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("q=DuIml=W0/05].Dm|");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("q=DuIml=W0/05].Dm|", aminoAcidSequence0.toString());
      assertEquals(18, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("q=DuIml=W0/05].Dm|", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("xxxxxx", aminoAcidSequence1.toString());
      assertEquals(6, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(">=*|4MN\"", false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation(aminoAcidSequence2.codon_translation_array, false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(6, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence3.toString());
      assertEquals(21, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation("q=DuIml=W0/05].Dm|", true);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(18, aminoAcidSequence4.length());
      assertEquals("x  x  x  x  x  x  ", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence2.elementAt(8832);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test123()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('t');
      assertEquals(7, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('t');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('t', 't', 't');
      assertEquals('f', char0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(7);
      assertEquals('g', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Nk", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("_jyf4WI:(Jf!", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(4, aminoAcidSequence1.length());
      assertEquals("....", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('K');
      assertEquals(11, int1);
      assertFalse(int1 == int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('K');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test124()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("G2t#N=Q&;Pb4UZG");
      assertEquals('\uFFFF', char0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('x');
      assertFalse(boolean0);
      
      char char1 = AminoAcidSequence.getOneLetterCode("G2t#N=Q&;Pb4UZG");
      assertEquals('\uFFFF', char1);
      assertTrue(char1 == char0);
      
      char char2 = AminoAcidSequence.getCodonTranslation('a', '\uFFFF', '\uFFFF');
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertFalse(char2 == char1);
  }

  @Test(timeout = 4000)
  public void test125()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('X', '`', 'r');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getOneLetterCode("internal error - illegal one letter amino acid code");
      assertEquals('\uFFFF', char1);
      assertFalse(char1 == char0);
      
      char char2 = AminoAcidSequence.getSymbolFromIndex(1);
      assertEquals('r', char2);
      assertFalse(char2 == char0);
      assertFalse(char2 == char1);
      
      int int0 = AminoAcidSequence.getSymbolIndex('r');
      assertEquals(1, int0);
      
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      
      Range range0 = new Range(1);
      assertNotNull(range0);
      assertEquals(1, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1, range0.getEnd());
      
      // Undeclared exception!
      try { 
        bases0.getTranslation(range0, 1, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test126()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("E40");
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("E40", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char[] charArray0 = new char[5];
      charArray0[0] = '%';
      charArray0[1] = '&';
      charArray0[2] = '?';
      AminoAcidSequence.setGeneCode();
      charArray0[3] = '(';
      charArray0[4] = '/';
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, charArray0.length);
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertArrayEquals(new char[] {'%', '&', '?', '(', '/'}, charArray0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("E40");
      assertEquals('\uFFFF', char0);
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("E40", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, charArray0.length);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence2.length());
      assertEquals(".", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertArrayEquals(new char[] {'%', '&', '?', '(', '/'}, charArray0);
      
      char char1 = aminoAcidSequence0.elementAt(1);
      assertEquals('4', char1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(char1 == char0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("E40", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(8842);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 8842
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test127()  throws Throwable  {
      String string0 = "GAME1.2";
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("GAME1.2");
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, aminoAcidSequence0.length());
      assertEquals("GAME1.2", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, aminoAcidSequence0.length());
      assertEquals("GAME1.2", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean1 = true;
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("GAME1.2", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(2, aminoAcidSequence2.length());
      assertEquals("xx", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('L');
      assertEquals(10, int0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation("GAME1.2", true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(2, aminoAcidSequence3.length());
      assertEquals("xx", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence2.codon_translation_array, true);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(2, aminoAcidSequence2.length());
      assertEquals("xx", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence4.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      
      char char0 = aminoAcidSequence0.elementAt(0);
      assertEquals('G', char0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, aminoAcidSequence0.length());
      assertEquals("GAME1.2", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 1
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test128()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('h');
      assertEquals(8, int0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('+');
      assertTrue(boolean0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('+');
      assertEquals(22, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getCodonTranslation((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test129()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('#');
      assertEquals(5, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('#');
      assertNotNull(string0);
      assertEquals("Ocr", string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Ocr", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertEquals("x", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("Ocr", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("x", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(0);
      assertEquals('a', char0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation("Ocr", true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence3.toString());
      assertEquals(3, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation(aminoAcidSequence3.codon_translation_array, true);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence3.toString());
      assertEquals(3, aminoAcidSequence3.length());
      assertEquals(21, aminoAcidSequence4.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      
      char char1 = AminoAcidSequence.getOneLetterCode("~RuuB`mD{6$<gc~oO~b");
      assertEquals('\uFFFF', char1);
      assertFalse(char1 == char0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(1, aminoAcidSequence1.length());
      assertEquals("x", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      
      int int1 = AminoAcidSequence.getAminoAcidType('U');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.checkForMatch((AminoAcidSequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test130()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('y');
      assertNotNull(string0);
      assertEquals("Tyr", string0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('y');
      assertEquals(7, int0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('y');
      assertNotNull(string1);
      assertEquals("Tyr", string1);
      
      String string2 = AminoAcidSequence.getThreeLetterAbbreviation('P');
      assertNotNull(string2);
      assertEquals("Pro", string2);
      assertFalse(string2.equals((Object)string0));
      assertFalse(string2.equals((Object)string1));
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Tyr", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      
      System.setCurrentTimeMillis(6);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('B');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: b
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test131()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('U');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('U');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('U');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test132()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "A4-F&<S0$6h#6K");
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('*');
      assertEquals(5, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('*');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('C');
      assertNotNull(string0);
      assertEquals("Cys", string0);
  }

  @Test(timeout = 4000)
  public void test133()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("+g@3J%!");
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(7, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: @
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test134()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('S');
      assertNotNull(string0);
      assertEquals("Ser", string0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('+');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('+');
      assertEquals(5, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation((-1024));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1024
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test135()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('g');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test136()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("'D s-d2b%");
      assertEquals('.', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('E');
      assertEquals(6, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Gln", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
  }

  @Test(timeout = 4000)
  public void test137()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('&');
      assertEquals(7, int0);
      
      System.setCurrentTimeMillis(7);
      char char0 = AminoAcidSequence.getSymbolFromIndex(7);
      assertEquals('g', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("_jyf4WI:(Jf!", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, aminoAcidSequence0.length());
      assertEquals("xxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      int int1 = AminoAcidSequence.getSymbolIndex('k');
      assertEquals(11, int1);
      assertFalse(int1 == int0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('u');
      assertEquals(24, int2);
      assertFalse(int2 == int0);
      assertFalse(int2 == int1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('K');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test138()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('C');
      assertEquals(4, int0);
      
      char[] charArray0 = new char[9];
      charArray0[0] = 'C';
      charArray0[1] = 'q';
      charArray0[2] = 'C';
      charArray0[3] = 'C';
      charArray0[4] = 'C';
      charArray0[5] = 'C';
      charArray0[6] = 'C';
      charArray0[7] = 'C';
      charArray0[8] = 'F';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(9, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(9, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'C', 'q', 'C', 'C', 'C', 'C', 'C', 'C', 'F'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test139()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('M');
      assertTrue(boolean0);
      
      char[] charArray0 = new char[6];
      charArray0[0] = 'M';
      charArray0[1] = 'M';
      charArray0[2] = 'M';
      charArray0[3] = 'M';
      charArray0[4] = 'M';
      charArray0[5] = 'M';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'M', 'M', 'M', 'M', 'M', 'M'}, charArray0);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("..", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'M', 'M', 'M', 'M', 'M', 'M'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test140()  throws Throwable  {
      char char0 = AminoAcidSequence.getSymbolFromIndex(0);
      assertEquals('a', char0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      String string0 = null;
      String string1 = "@,G\\jj";
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertNull(aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.length();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test141()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertNull(aminoAcidSequence0.toString());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('p');
      assertTrue(boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test142()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('L');
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test143()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('M');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('M');
      assertEquals(3, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('M');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('S', 'e', 'n');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test144()  throws Throwable  {
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("dsR u0cMm%A:'", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, aminoAcidSequence0.length());
      assertEquals("....", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      int int0 = AminoAcidSequence.getSymbolIndex('K');
      assertEquals(11, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test145()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('f');
      assertNotNull(string0);
      assertEquals("Phe", string0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("No sequence for ", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char char0 = AminoAcidSequence.getOneLetterCode("Phe");
      assertEquals('f', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('f');
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(15, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test146()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("htsjdk.samtools.SAMException", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(27, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(27, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
  }

  @Test(timeout = 4000)
  public void test147()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNull(aminoAcidSequence0.toString());
      
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNull(aminoAcidSequence0.toString());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNull(string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertNull(aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('/');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("1YR>`(I?eih&VNe{u`-", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("xxxxxx", aminoAcidSequence2.toString());
      assertEquals(6, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.containsStopCodon();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test148()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('F');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('F');
      assertEquals(3, int1);
      assertTrue(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test149()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('f');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('L');
      assertEquals(10, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation(")3S@.=B+LsM");
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test150()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, true, false);
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('/');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test151()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('q');
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Gln");
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("Gln", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(302.34F, float0, 0.01F);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("Gln", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(3);
      assertEquals('d', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('S');
      assertEquals(0, int0);
      
      char char1 = AminoAcidSequence.getOneLetterCode("jn/6");
      assertEquals('\uFFFF', char1);
      assertFalse(char1 == char0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('C');
      assertEquals(4, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("i/WU-U", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(".  .  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(6, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test152()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('R');
      assertTrue(boolean0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(0);
      assertNotNull(string0);
      assertEquals("Ala", string0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(517);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 517
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test153()  throws Throwable  {
      char char0 = '(';
      int int0 = AminoAcidSequence.getAminoAcidType('(');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('(');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: (
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test154()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('(');
      assertEquals(7, int0);
      
      AminoAcidSequence.setGeneCode();
      char[] charArray0 = new char[5];
      charArray0[0] = '(';
      charArray0[1] = '(';
      charArray0[2] = '(';
      charArray0[3] = '(';
      charArray0[4] = '(';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("x  ", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'(', '(', '(', '(', '('}, charArray0);
  }

  @Test(timeout = 4000)
  public void test155()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('R');
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test156()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('I', 'I', 'I');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getOneLetterCode("Thr");
      assertEquals('t', char1);
      assertFalse(char1 == char0);
      
      System.setCurrentTimeMillis(0L);
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence0.toString());
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      char char2 = AminoAcidSequence.getOneLetterCode("Thr");
      assertEquals('t', char2);
      assertTrue(char2 == char1);
      assertFalse(char2 == char0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Thr", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char3 = AminoAcidSequence.getCodonTranslation('I', 't', ':');
      assertEquals('.', char3);
      assertFalse(char3 == char2);
      assertTrue(char3 == char0);
      assertFalse(char3 == char1);
      
      AminoAcidSequence aminoAcidSequence2 = new AminoAcidSequence("A2'[$reD}%=V3.");
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("A2'[$reD}%=V3.", aminoAcidSequence2.toString());
      assertEquals(14, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      
      boolean boolean0 = aminoAcidSequence1.checkForMatch(aminoAcidSequence2);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals("A2'[$reD}%=V3.", aminoAcidSequence2.toString());
      assertEquals(14, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('.');
      assertNotNull(string0);
      assertEquals("---", string0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence2.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 2
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test157()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      char char0 = '(';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('(');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: (
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test158()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('(');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('(');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('J');
      assertEquals(7, int1);
      assertTrue(int1 == int0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('X');
      assertEquals(23, int2);
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("firePostChangeEvent must be called in a synchronized block locking the ChangeSupport");
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test159()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('k');
      assertTrue(boolean0);
      
      char[] charArray0 = new char[2];
      charArray0[0] = 'k';
      charArray0[1] = 'k';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'k', 'k'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('A');
      assertEquals(0, int0);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(boolean1 == boolean0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'k', 'k'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test160()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('-');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(25);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 25
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test161()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[1] = '-';
      int int0 = AminoAcidSequence.getAminoAcidType('-');
      assertEquals(7, int0);
      
      System.setCurrentTimeMillis('-');
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test162()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('M');
      assertEquals(12, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("nOYm2,R% |=4Y}@=n", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(15, aminoAcidSequence0.length());
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test163()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('A');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('A');
      assertEquals(0, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test164()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("v}ES#3}\"&Tjl@");
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("v}ES#3}\"&Tjl@", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(13, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("v}ES#3}\"&Tjl@", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(13, aminoAcidSequence0.length());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('J');
      assertEquals(7, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(7);
      assertNotNull(string0);
      assertEquals("Gly", string0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test165()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('Y');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('Y');
      assertEquals(18, int0);
  }

  @Test(timeout = 4000)
  public void test166()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('m');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation("g93V&a<Jd`;r2~y2R");
      assertEquals('.', char0);
      
      System.setCurrentTimeMillis(1458L);
      char char1 = AminoAcidSequence.getCodonTranslation('.', 'm', '.');
      assertEquals('.', char1);
      assertTrue(char1 == char0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('7');
      assertEquals(7, int1);
      assertTrue(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test167()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('>');
      assertEquals(7, int0);
      
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {}, charArray0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("ZraL)>", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence1.toString());
      assertEquals(6, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("ZraL)>");
      assertEquals('\uFFFF', char0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {}, charArray0);
      
      int int1 = aminoAcidSequence0.length();
      assertEquals(0, int1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(int1 == int0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {}, charArray0);
      
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("", false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(0, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      int int2 = AminoAcidSequence.getSymbolIndex('N');
      assertEquals(2, int2);
      assertFalse(int2 == int1);
      assertFalse(int2 == int0);
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test168()  throws Throwable  {
      byte[] byteArray0 = new byte[9];
      byteArray0[0] = (byte)33;
      byteArray0[1] = (byte) (-99);
      byteArray0[2] = (byte) (-1);
      byteArray0[3] = (byte)13;
      byteArray0[4] = (byte)7;
      byteArray0[5] = (byte)44;
      byteArray0[6] = (byte)33;
      byteArray0[7] = (byte)20;
      byteArray0[8] = (byte)12;
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertFalse(boolean0);
      assertEquals(9, byteArray0.length);
      assertArrayEquals(new byte[] {(byte)33, (byte) (-99), (byte) (-1), (byte)13, (byte)7, (byte)44, (byte)33, (byte)20, (byte)12}, byteArray0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('q');
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Gln");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('q');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Phe");
      assertEquals('f', char0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(302.34F, float0, 0.01F);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(3);
      assertEquals('d', char1);
      assertFalse(char1 == char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('b');
      assertEquals(7, int0);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('b');
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2 == boolean1);
      
      char char2 = AminoAcidSequence.getSymbolFromIndex(21);
      assertEquals('#', char2);
      assertFalse(char2 == char0);
      assertFalse(char2 == char1);
  }

  @Test(timeout = 4000)
  public void test169()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('q');
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Gln");
      assertNotNull(aminoAcidSequence0);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('q');
      assertFalse(boolean0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(302.34F, float0, 0.01F);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("Gln", aminoAcidSequence0.toString());
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(3);
      assertEquals('d', char0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('Y');
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test170()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('h');
      assertEquals(8, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("g");
      assertNotNull(aminoAcidSequence0);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("g", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      boolean boolean0 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean0);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("g", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      int int1 = AminoAcidSequence.getAminoAcidType('K');
      assertEquals(1, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test171()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Phe");
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("Phe", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      
      char char0 = AminoAcidSequence.getOneLetterCode("Ile");
      assertEquals('i', char0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('s');
      assertNotNull(string0);
      assertEquals("Ser", string0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("Ile");
      assertEquals('.', char1);
      assertFalse(char1 == char0);
  }

  @Test(timeout = 4000)
  public void test172()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("U*<Gc]$\"HOf8Y+&4<");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("");
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char2 = AminoAcidSequence.getCodonTranslation("U*<Gc]$\"HOf8Y+&4<");
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertTrue(char2 == char1);
      
      char char3 = AminoAcidSequence.getCodonTranslation('\uFFFF', '.', '.');
      assertEquals('.', char3);
      assertFalse(char3 == char0);
      assertTrue(char3 == char1);
      assertTrue(char3 == char2);
      
      int int0 = AminoAcidSequence.getSymbolIndex('H');
      assertEquals(8, int0);
      
      char char4 = aminoAcidSequence1.elementAt(25);
      assertEquals(' ', char4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(char4 == char1);
      assertFalse(char4 == char3);
      assertFalse(char4 == char2);
      assertFalse(char4 == char0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("U*<Gc]$\"HOf8Y+&4<", aminoAcidSequence0.toString());
      assertEquals(17, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: <
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test173()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('I');
      assertEquals(3, int0);
      
      System.setCurrentTimeMillis(1634L);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test174()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('7');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(7);
      assertEquals('g', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("9)@vlq)`itss(", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(12, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(12, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('g');
      assertEquals(7, int1);
      assertTrue(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test175()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('Q');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test176()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation('B', 'B', 'B');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('.', '.', 'B');
      assertEquals('.', char1);
      assertTrue(char1 == char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("A2'[$reD}%=V3.");
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(14, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("A2'[$reD}%=V3.", aminoAcidSequence0.toString());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('B');
      assertFalse(boolean0);
      
      IndexedGFFDocumentEntry indexedGFFDocumentEntry0 = new IndexedGFFDocumentEntry((Document) null);
  }

  @Test(timeout = 4000)
  public void test177()  throws Throwable  {
      char char0 = 'w';
      int int0 = AminoAcidSequence.getSymbolIndex('w');
      assertEquals(17, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType(':');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation(':');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test178()  throws Throwable  {
      int int0 = AminoAcidSequence.getSymbolIndex('h');
      assertEquals(8, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("g", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('h');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("g");
      assertEquals('\uFFFF', char0);
  }

  @Test(timeout = 4000)
  public void test179()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("No sequence for ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("No sequence for ", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence1.toString());
      assertEquals(15, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('t');
      assertEquals(16, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('t');
      assertNotNull(string0);
      assertEquals("Thr", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(2);
      assertNotNull(string1);
      assertEquals("Asn", string1);
      assertFalse(string1.equals((Object)string0));
      
      boolean boolean0 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("x  x  x  x  x  ", aminoAcidSequence0.toString());
      assertEquals(15, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence1.toString());
      assertEquals(15, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('N');
      assertEquals(0, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test180()  throws Throwable  {
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(12);
      assertNotNull(string0);
      assertEquals("Met", string0);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('(');
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('(');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('(');
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Met", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      
      boolean boolean3 = AminoAcidSequence.isStopCodon('(');
      assertFalse(boolean3);
      assertTrue(boolean3 == boolean0);
      assertTrue(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      
      AminoAcidSequence aminoAcidSequence1 = new AminoAcidSequence("Met");
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("Met", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      
      boolean boolean4 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertFalse(boolean4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean4 == boolean2);
      assertTrue(boolean4 == boolean1);
      assertTrue(boolean4 == boolean0);
      assertTrue(boolean4 == boolean3);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("Met", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test181()  throws Throwable  {
      System.setCurrentTimeMillis((-3668L));
      int int0 = AminoAcidSequence.getAminoAcidType('J');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation(")c");
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test182()  throws Throwable  {
      char char0 = '2';
      int int0 = AminoAcidSequence.getAminoAcidType('2');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Glu", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('2');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 2
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test183()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('2');
      assertEquals(7, int0);
      
      Strand strand0 = new Strand((Bases) null, 7);
      assertNotNull(strand0);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      Range range0 = new Range(2);
      assertNotNull(range0);
      assertEquals(2, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2, range0.getStart());
      
      AminoAcidSequence.setGeneCode();
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('2');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 2
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test184()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("!yCS ui", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = 'T';
      boolean boolean0 = true;
      AminoAcidSequence.setGeneCode();
      String string0 = "uk.ac.sanger.a5temis.cado.IBaxisDAO";
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Gln", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation(aminoAcidSequence2.codon_translation_array, false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("............f.......g", aminoAcidSequence3.toString());
      assertEquals(21, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      Short short0 = new Short((short)30);
      assertNotNull(short0);
      assertEquals((short)30, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 1203, 200, short0, (Integer) 2);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Marker marker0 = new Marker(strand0, 46);
      assertNotNull(marker0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(1203, partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)30, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(2, (int)partialSequence0.getPhase());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(46, marker0.getPosition());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence3.findMatch(bases1, marker0, false, false, false);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -199
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test185()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('1');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('1');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 1
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test186()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('I');
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(" oS!&.n(", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
      
      char char0 = AminoAcidSequence.getOneLetterCode("Ile");
      assertEquals('i', char0);
      
      char[] charArray0 = new char[0];
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, charArray0.length);
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertArrayEquals(new char[] {}, charArray0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('I');
      assertEquals(9, int0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('I', '<', '!');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(86);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test187()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("previus_;ystematicid");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("previus_;ystematicid", aminoAcidSequence0.toString());
      assertEquals(20, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: _
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test188()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('D');
      assertEquals(2, int0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Arg");
      assertEquals('r', char0);
  }

  @Test(timeout = 4000)
  public void test189()  throws Throwable  {
      char[] charArray0 = new char[3];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      Marker marker0 = new Marker(strand0, 2);
      assertNotNull(marker0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(2, marker0.getPosition());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, true, true, true);
      assertNull(markerRange0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(2, marker0.getPosition());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("x", string0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, charArray0.length);
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      char[] charArray1 = new char[4];
      assertFalse(charArray1.equals((Object)charArray0));
      
      charArray1[0] = ';';
      charArray1[1] = ';';
      charArray1[2] = ';';
      charArray1[3] = ';';
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray1, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(charArray1.equals((Object)charArray0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, charArray1.length);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(3, aminoAcidSequence1.length());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(charArray1, charArray0);
      assertArrayEquals(new char[] {';', ';', ';', ';'}, charArray1);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(charArray0.equals((Object)charArray1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, charArray0.length);
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(charArray0, charArray1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertArrayEquals(new char[] {';', '-', '\u0000'}, charArray0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('0');
      assertEquals(7, int0);
      
      System.setCurrentTimeMillis(142L);
  }

  @Test(timeout = 4000)
  public void test190()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('0');
      assertEquals(7, int0);
      
      int int1 = AminoAcidSequence.symbol_count;
      assertEquals(25, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test191()  throws Throwable  {
      char[] charArray0 = new char[2];
      int int0 = AminoAcidSequence.getAminoAcidType(')');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation(';', ')', 'y');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test192()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getAminoAcidType(',');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test193()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      int int0 = strand0.getACount();
      assertEquals(0, int0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      partialSequence0.setFromChar(aminoAcidSequence0.codon_translation_array);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(954);
      assertNotNull(marker0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-953), marker0.getPosition());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      int int1 = marker0.getRawPosition();
      assertEquals(954, int1);
      assertFalse(int1 == int0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-953), marker0.getPosition());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      markerInternal0.parent = marker0;
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertEquals((-953), marker0.getPosition());
      assertEquals((-953), markerInternal0.parent.getPosition());
      
      Marker marker1 = strand0.makeMarker(0);
      assertNotNull(marker1);
      assertFalse(marker1.equals((Object)marker0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, marker1.getPosition());
      assertNotSame(marker1, marker0);
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker1, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(marker1.equals((Object)marker0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, marker1.getPosition());
      assertTrue(markerRange0.isForwardMarker());
      assertNotSame(marker1, marker0);
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, marker1, false, true, false);
      assertNull(markerRange1);
      assertFalse(marker1.equals((Object)marker0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, marker1.getPosition());
      assertNotSame(marker1, marker0);
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'\u0000', '-'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test194()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('E');
      assertTrue(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('E');
      assertEquals(2, int0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('E');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
  }

  @Test(timeout = 4000)
  public void test195()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("-[)DNv7~c@y=;");
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("-[)DNv7~c@y=;", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals("xxxx", aminoAcidSequence0.toString());
      assertEquals(4, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals("xxxx", aminoAcidSequence0.toString());
      assertEquals(4, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('.');
      assertEquals(23, int0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('d');
      assertEquals(3, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test196()  throws Throwable  {
      char char0 = AminoAcidSequence.getCodonTranslation("d!\u0007C1#|LF");
      assertEquals('.', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('.');
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('.');
      assertEquals(7, int0);
      
      char char1 = AminoAcidSequence.getCodonTranslation("d!\u0007C1#|LF");
      assertEquals('.', char1);
      assertTrue(char1 == char0);
  }

  @Test(timeout = 4000)
  public void test197()  throws Throwable  {
      char char0 = '\'';
      int int0 = AminoAcidSequence.getAminoAcidType('\'');
      assertEquals(7, int0);
      
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence((String) null);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertNull(aminoAcidSequence0.toString());
      
      String string0 = null;
      boolean boolean0 = false;
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSpacedTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test198()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('G');
      assertEquals(4, int0);
      
      System.setCurrentTimeMillis(4);
      boolean boolean0 = AminoAcidSequence.isLegalCodon('G');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('G', 'G', 'G');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(4);
      assertEquals('c', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("JNk", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(1, aminoAcidSequence0.length());
      
      DNANoAmbPack dNANoAmbPack0 = new DNANoAmbPack((byte) (-5));
      assertNotNull(dNANoAmbPack0);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      
      long[] longArray0 = new long[7];
      longArray0[0] = (long) 4;
      longArray0[1] = (long) 5;
      longArray0[2] = (long) 4;
      longArray0[3] = (long) 2;
      longArray0[4] = (long) 2;
      longArray0[5] = 776L;
      longArray0[6] = (long) 'c';
      PackedSymbolList packedSymbolList0 = new PackedSymbolList(dNANoAmbPack0, longArray0, 4);
      assertNotNull(packedSymbolList0);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 776L, 99L}, longArray0);
      
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(packedSymbolList0);
      assertNotNull(bioJavaSequence0);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 776L, 99L}, longArray0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(7, longArray0.length);
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertEquals(4, packedSymbolList0.length());
      assertArrayEquals(new long[] {4L, 5L, 4L, 2L, 2L, 776L, 99L}, longArray0);
      
      Clipboard clipboard0 = new Clipboard(" AW]AH_0");
      assertNotNull(clipboard0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.findMatch(bases0, (Marker) null, false, false, true);
        fail("Expecting exception: NoClassDefFoundError");
      
      } catch(NoClassDefFoundError e) {
         //
         // Could not initialize class org.biojava.bio.seq.DNATools
         //
         verifyException("org.biojava.bio.symbol.DNANoAmbPack", e);
      }
  }

  @Test(timeout = 4000)
  public void test199()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      MarkerRange markerRange1 = aminoAcidSequence1.findMatch(bases0, (Marker) null, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(6, fastaStreamSequence0.length());
      assertTrue(markerRange1.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertNotSame(markerRange1, markerRange0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string1);
      assertEquals("Gln", string1);
      assertFalse(string1.equals((Object)string0));
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test200()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals("x  x  ", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertEquals(63, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, true, true, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string1);
      assertEquals("Gln", string1);
      assertFalse(string1.equals((Object)string0));
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test201()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '/';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("A/", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      partialSequence0.setFromChar(charArray0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, false, false, true);
      assertNull(markerRange0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases0, marker0, true, true, false);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertTrue(markerRange1.isForwardMarker());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('/');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test202()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, false, true, false);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertTrue(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('r');
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string1);
      assertEquals("Gln", string1);
      assertFalse(string1.equals((Object)string0));
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test203()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("A/", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("", aminoAcidSequence1.toString());
      assertEquals(0, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, true, false, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals((-4), marker0.getPosition());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test204()  throws Throwable  {
      char[] charArray0 = new char[17];
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      
      Marker marker0 = markerInternal0.parent;
      assertNull(marker0);
      assertEquals(17, charArray0.length);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, false, false, true);
      assertNull(markerRange0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.getTCount());
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("xxxxx", string0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(17, charArray0.length);
      assertEquals(5, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("xxxxx", aminoAcidSequence0.toString());
      
      System.setCurrentTimeMillis((-1L));
      int int0 = AminoAcidSequence.getAminoAcidType('=');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test205()  throws Throwable  {
      char[] charArray0 = new char[8];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      Marker marker0 = markerInternal0.parent;
      assertNull(marker0);
      assertEquals(8, charArray0.length);
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, true);
      assertNull(markerRange0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.length());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("xx", string0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(8, charArray0.length);
      assertEquals(2, aminoAcidSequence0.length());
      assertEquals("xx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test206()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      Marker marker0 = new Marker(strand0, ';');
      assertNotNull(marker0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(59, marker0.getPosition());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, false, false, true);
      assertNotNull(markerRange0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(59, marker0.getPosition());
      assertFalse(markerRange0.isForwardMarker());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {';', '-'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test207()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('c');
      assertTrue(boolean0);
      
      char[] charArray0 = new char[1];
      charArray0[0] = 'c';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'c'}, charArray0);
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, charArray0.length);
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'c'}, charArray0);
  }

  @Test(timeout = 4000)
  public void test208()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals("", aminoAcidSequence0.toString());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.elementAt(90);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test209()  throws Throwable  {
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("org.biojava.ontology.AbstractTerm$1", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...........", aminoAcidSequence0.toString());
      assertEquals(11, aminoAcidSequence0.length());
      
      int int0 = aminoAcidSequence0.length();
      assertEquals(11, int0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...........", aminoAcidSequence0.toString());
      assertEquals(11, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...........", aminoAcidSequence0.toString());
      assertEquals(11, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean0 = aminoAcidSequence1.checkForMatch(aminoAcidSequence0);
      assertFalse(boolean0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...........", aminoAcidSequence0.toString());
      assertEquals(11, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('`', '0', 'N');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test210()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("v}ES#3}\"&Tjl@");
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(13, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("v}ES#3}\"&Tjl@", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(13, aminoAcidSequence0.length());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals("v}ES#3}\"&Tjl@", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(63, aminoAcidSequence1.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('O');
      assertEquals(7, int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(7);
      assertNotNull(string0);
      assertEquals("Gly", string0);
  }

  @Test(timeout = 4000)
  public void test211()  throws Throwable  {
      System.setCurrentTimeMillis((-1660L));
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Ser", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals("x  ", aminoAcidSequence0.toString());
      
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "Glu");
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('P');
      assertEquals(4, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation(']', '*', '#');
      assertEquals('.', char0);
  }

  @Test(timeout = 4000)
  public void test212()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('a');
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test213()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Thr");
      assertNotNull(aminoAcidSequence0);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("Thr", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("Thr", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("............f.......g", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(21, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      Clipboard clipboard0 = new Clipboard("G/Tlj}_i1RbT:B9");
      assertNotNull(clipboard0);
      assertEquals("G/Tlj}_i1RbT:B9", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals("G/Tlj}_i1RbT:B9", clipboard0.getName());
      
      Marker marker0 = selection0.getLowestBaseOfSelection();
      assertNull(marker0);
      assertEquals("G/Tlj}_i1RbT:B9", clipboard0.getName());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.findMatch((Bases) null, (Marker) null, false, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test214()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("Cys", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      int int0 = AminoAcidSequence.getAminoAcidType('4');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('4', '4', '4');
      assertEquals('.', char0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
  }

  @Test(timeout = 4000)
  public void test215()  throws Throwable  {
      char char0 = AminoAcidSequence.getOneLetterCode("2}obl&7]Akp4W~x,q=;");
      assertEquals('\uFFFF', char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("2}obl&7]Akp4W~x,q=;", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("xxxxxx", string0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
  }

  @Test(timeout = 4000)
  public void test216()  throws Throwable  {
      byte[] byteArray0 = new byte[5];
      byteArray0[0] = (byte) (-112);
      byteArray0[1] = (byte) (-117);
      byteArray0[2] = (byte)119;
      byteArray0[3] = (byte)115;
      byteArray0[4] = (byte)96;
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertFalse(boolean0);
      assertEquals(5, byteArray0.length);
      assertArrayEquals(new byte[] {(byte) (-112), (byte) (-117), (byte)119, (byte)115, (byte)96}, byteArray0);
      
      RawStreamSequence rawStreamSequence0 = null;
      try {
        rawStreamSequence0 = new RawStreamSequence((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test217()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("q@~d?ke*vyzyIml}d");
      assertNotNull(aminoAcidSequence0);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("q@~d?ke*vyzyIml}d", aminoAcidSequence0.toString());
      assertTrue(aminoAcidSequence0.containsStopCodon());
      assertEquals(17, aminoAcidSequence0.length());
      
      // Undeclared exception!
      try { 
        aminoAcidSequence0.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: @
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test218()  throws Throwable  {
      char[] charArray0 = new char[0];
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {}, charArray0);
      
      char[] charArray1 = new char[5];
      assertFalse(charArray1.equals((Object)charArray0));
      
      charArray1[0] = '0';
      charArray1[1] = 'U';
      charArray1[2] = '\\';
      charArray1[3] = '\"';
      charArray1[4] = ';';
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(charArray1, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(charArray1.equals((Object)charArray0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, charArray1.length);
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".", aminoAcidSequence1.toString());
      assertNotSame(charArray1, charArray0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertArrayEquals(new char[] {'0', 'U', '\\', '\"', ';'}, charArray1);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(charArray0.equals((Object)charArray1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, charArray0.length);
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(charArray0, charArray1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertArrayEquals(new char[] {}, charArray0);
      
      float float0 = aminoAcidSequence2.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertFalse(charArray0.equals((Object)charArray1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, charArray0.length);
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(charArray0, charArray1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertArrayEquals(new char[] {}, charArray0);
      
      float float1 = aminoAcidSequence2.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(charArray0.equals((Object)charArray1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, charArray0.length);
      assertEquals(0, aminoAcidSequence2.length());
      assertEquals("", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(charArray0, charArray1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertArrayEquals(new char[] {}, charArray0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation("com.ibatis.sqlmap.engine.exchange.BaseDataExchange", false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  .  i  .  .  ", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(48, aminoAcidSequence3.length());
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getSymbolFromIndex(1);
      assertEquals('r', char0);
      
      boolean boolean0 = AminoAcidSequence.isLegalCodon('r');
      assertTrue(boolean0);
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation("L,hff(y`iw4g?t>%", true);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("xxxxx", aminoAcidSequence4.toString());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(5, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence5);
      assertFalse(charArray0.equals((Object)charArray1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, charArray0.length);
      assertEquals(0, aminoAcidSequence5.length());
      assertEquals("", aminoAcidSequence5.toString());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertNotSame(charArray0, charArray1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertArrayEquals(new char[] {}, charArray0);
      
      AminoAcidSequence aminoAcidSequence6 = AminoAcidSequence.getSpacedTranslation("L,hff(y`iw4g?t>%", false);
      assertNotNull(aminoAcidSequence6);
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence5));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence6.equals((Object)aminoAcidSequence2));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(15, aminoAcidSequence6.length());
      assertEquals(".  .  .  .  .  ", aminoAcidSequence6.toString());
      assertFalse(aminoAcidSequence6.containsStopCodon());
      assertNotSame(aminoAcidSequence6, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence6, aminoAcidSequence2);
  }

  @Test(timeout = 4000)
  public void test219()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('9');
      assertFalse(boolean0);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.getDefaultEntry();
      assertNull(entry0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      assertNotNull(blastEntryInformation0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      
      Key key0 = blastEntryInformation0.getDefaultKey();
      assertNotNull(key0);
      assertFalse(blastEntryInformation0.useEMBLFormat());
      assertEquals("misc_feature", key0.getKeyString());
      assertEquals("misc_feature", key0.toString());
      assertEquals(12, key0.length());
      
      // Undeclared exception!
      try { 
        Marker.getRawLowest((Marker) null, (Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Marker", e);
      }
  }

  @Test(timeout = 4000)
  public void test220()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('9');
      assertEquals(7, int0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("PMID:");
      assertEquals('\uFFFF', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('\uFFFF', '^', '9');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      String string0 = "3=L]pHZ.wO";
      char char2 = AminoAcidSequence.getCodonTranslation("3=L]pHZ.wO");
      assertEquals('.', char2);
      assertFalse(char2 == char0);
      assertTrue(char2 == char1);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean0 = AminoAcidSequence.isLegalCodon('V');
      assertTrue(boolean0);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('R');
      assertNotNull(string1);
      assertEquals("Arg", string1);
      assertFalse(string1.equals((Object)string0));
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(85);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 85
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test221()  throws Throwable  {
      String string0 = "L+H";
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("L+H", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      int int0 = aminoAcidSequence0.length();
      assertEquals(1, int0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      
      char char0 = '4';
      int int1 = AminoAcidSequence.getAminoAcidType('4');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      String string1 = "Boolean";
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("Boolean", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".  .  ", aminoAcidSequence1.toString());
      assertEquals(6, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation('|');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - illegal one letter amino acid code
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test222()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '/';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      partialSequence0.setFromChar(charArray0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertNotNull(bases0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertNotNull(strand0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(0, markerInternal0.getPosition());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals((-4), marker0.getPosition());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerRange markerRange0 = aminoAcidSequence0.findMatch(bases0, marker0, false, false, true);
      assertNull(markerRange0);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals((-4), marker0.getPosition());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      MarkerRange markerRange1 = strand0.makeMarkerRangeFromPositions((-5), 2);
      assertNotNull(markerRange1);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(partialSequence0.isComplement());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(2, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(0, partialSequence0.length());
      assertEquals(0, partialSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertFalse(markerRange1.isForwardMarker());
      assertArrayEquals(new char[] {'/', '\u0000'}, charArray0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('/');
      assertEquals(7, int0);
  }

  @Test(timeout = 4000)
  public void test223()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      char[] charArray0 = new char[3];
      charArray0[0] = ':';
      charArray0[1] = 'H';
      charArray0[2] = '1';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(3, charArray0.length);
      assertEquals("x  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {':', 'H', '1'}, charArray0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Sel");
      assertEquals('u', char0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('Y');
      assertNotNull(string0);
      assertEquals("Tyr", string0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, charArray0.length);
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertArrayEquals(new char[] {':', 'H', '1'}, charArray0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('Y');
      assertEquals(18, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon(':');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Internal error - unexpected exception: ", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(39, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  x  ", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
  }

  @Test(timeout = 4000)
  public void test224()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      
      Integer integer0 = new Integer(0);
      assertNotNull(integer0);
      assertEquals(0, (int)integer0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean1 = AminoAcidSequence.isLegalCodon('#');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      int int0 = AminoAcidSequence.POLAR_UNCHARGED_AA;
      assertEquals(0, int0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation("l{~_d", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('u');
      assertNotNull(string0);
      assertEquals("Sel", string0);
      
      boolean boolean2 = AminoAcidSequence.isLegalCodon('^');
      assertFalse(boolean2);
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('^');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("?emOC2?gcv", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("xxx", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation(aminoAcidSequence2.codon_translation_array, true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("xxx", aminoAcidSequence2.toString());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence3.toString());
      assertEquals(21, aminoAcidSequence3.length());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      
      boolean boolean3 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean3);
      assertFalse(boolean3 == boolean0);
      assertFalse(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      
      int int2 = AminoAcidSequence.getAminoAcidType('T');
      assertEquals(0, int2);
      assertFalse(int2 == int1);
      assertTrue(int2 == int0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence1.codon_translation_array, false);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x  ", aminoAcidSequence1.toString());
      assertEquals(3, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence4.toString());
      assertEquals(63, aminoAcidSequence4.length());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence5);
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence4));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals("............f.......g", aminoAcidSequence5.toString());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertEquals(21, aminoAcidSequence5.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence5);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence4);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
  }

  @Test(timeout = 4000)
  public void test225()  throws Throwable  {
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("The locationsof the client's pkcs#8 ssl key", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("..h...........", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals((-79.03499F), float0, 0.01F);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(14, aminoAcidSequence0.length());
      assertEquals("..h...........", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char char0 = 'e';
      char char1 = AminoAcidSequence.getOneLetterCode("The locationsof the client's pkcs#8 ssl key");
      assertEquals('\uFFFF', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(']');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ]
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test226()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      System.setCurrentTimeMillis(0L);
      boolean boolean2 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      
      boolean boolean3 = AminoAcidSequence.isLegalCodon('C');
      assertTrue(boolean3);
      assertFalse(boolean3 == boolean0);
      assertFalse(boolean3 == boolean1);
      assertFalse(boolean3 == boolean2);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("SEQUENCE INSERT AT ", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("xxxxxx", aminoAcidSequence0.toString());
      assertEquals(6, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      char char0 = AminoAcidSequence.getSymbolFromIndex(3);
      assertEquals('d', char0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('F', 'C', 'P');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation((-166));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -166
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test227()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('P');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolFromIndex(198);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 198
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test228()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "A4-F&<S0$6h#6K");
      assertFalse(boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('&');
      assertEquals(7, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('&');
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('C');
      assertNotNull(string0);
      assertEquals("Cys", string0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('C');
      assertEquals(4, int1);
      assertFalse(int1 == int0);
  }

  @Test(timeout = 4000)
  public void test229()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("&dl67&_", true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("xx", aminoAcidSequence0.toString());
      assertEquals(2, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("&dl67&_", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("xx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('?');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ?
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test230()  throws Throwable  {
      String string0 = "q}tHM,wsq'";
      boolean boolean0 = false;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("q}tHM,wsq'", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      
      int int0 = AminoAcidSequence.getSymbolIndex('w');
      assertEquals(17, int0);
      
      boolean boolean1 = aminoAcidSequence0.containsStopCodon();
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("...", aminoAcidSequence0.toString());
      assertEquals(3, aminoAcidSequence0.length());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("Hky'nDN]X6qtDQa,g");
      assertNotNull(rawStreamSequence0);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(15, rawStreamSequence0.getOtherCount());
      assertEquals(18, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getACount());
      
      // Undeclared exception!
      try { 
        rawStreamSequence0.getCharSubSequence(6, 4);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test231()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('v');
      assertNotNull(string0);
      assertEquals("Val", string0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('v');
      assertEquals(19, int0);
  }

  @Test(timeout = 4000)
  public void test232()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "Amb");
      assertFalse(boolean0);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Amb");
      assertEquals('+', char0);
      
      int int0 = AminoAcidSequence.getSymbolIndex('+');
      assertEquals(22, int0);
      
      boolean boolean1 = AminoAcidSequence.isLegalCodon('+');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      char[] charArray0 = new char[4];
      EvoSuiteFile evoSuiteFile0 = null;
      boolean boolean2 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertFalse(boolean2);
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      
      charArray0[0] = '+';
      charArray0[1] = '+';
      charArray0[2] = 'h';
      charArray0[3] = '+';
      boolean boolean3 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean3);
      assertFalse(boolean3 == boolean0);
      assertFalse(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals("x", aminoAcidSequence0.toString());
      assertArrayEquals(new char[] {'+', '+', 'h', '+'}, charArray0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Amb", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals("x", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation('h');
      assertNotNull(string0);
      assertEquals("His", string0);
      
      boolean boolean4 = AminoAcidSequence.isStopCodon('+');
      assertTrue(boolean4);
      assertTrue(boolean4 == boolean1);
      assertTrue(boolean4 == boolean3);
      assertFalse(boolean4 == boolean2);
      assertFalse(boolean4 == boolean0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("W`5?", false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(".  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char[] charArray1 = new char[2];
      assertFalse(charArray1.equals((Object)charArray0));
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getTranslation(aminoAcidSequence2.codon_translation_array, true);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(".  ", aminoAcidSequence2.toString());
      assertEquals(3, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(21, aminoAcidSequence3.length());
      assertEquals("xxxxxxxxxxxxfxxxxxxxg", aminoAcidSequence3.toString());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      
      String string1 = AminoAcidSequence.getThreeLetterAbbreviation('+');
      assertNotNull(string1);
      assertEquals("Amb", string1);
      assertFalse(string1.equals((Object)string0));
      
      AminoAcidSequence aminoAcidSequence4 = AminoAcidSequence.getTranslation(charArray0, false);
      assertNotNull(aminoAcidSequence4);
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence4.equals((Object)aminoAcidSequence2));
      assertFalse(charArray0.equals((Object)charArray1));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, charArray0.length);
      assertEquals(1, aminoAcidSequence4.length());
      assertFalse(aminoAcidSequence4.containsStopCodon());
      assertEquals(".", aminoAcidSequence4.toString());
      assertNotSame(aminoAcidSequence4, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence4, aminoAcidSequence2);
      assertNotSame(charArray0, charArray1);
      assertArrayEquals(new char[] {'+', '+', 'h', '+'}, charArray0);
      
      charArray1[0] = 'h';
      charArray1[1] = 'h';
      AminoAcidSequence aminoAcidSequence5 = AminoAcidSequence.getSpacedTranslation(charArray1, true);
      assertNotNull(aminoAcidSequence5);
      assertFalse(charArray1.equals((Object)charArray0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence3));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence5.equals((Object)aminoAcidSequence4));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, charArray1.length);
      assertEquals("", aminoAcidSequence5.toString());
      assertFalse(aminoAcidSequence5.containsStopCodon());
      assertEquals(0, aminoAcidSequence5.length());
      assertNotSame(charArray1, charArray0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence5, aminoAcidSequence4);
      assertArrayEquals(new char[] {'h', 'h'}, charArray1);
      
      char char1 = AminoAcidSequence.getOneLetterCode("His");
      assertEquals('h', char1);
      assertFalse(char1 == char0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence2.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol:  
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test233()  throws Throwable  {
      boolean boolean0 = AminoAcidSequence.isLegalCodon('\"');
      assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean1);
      assertTrue(boolean1 == boolean0);
      
      boolean boolean2 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "Sel");
      assertFalse(boolean2);
      assertTrue(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      
      boolean boolean3 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean3);
      assertTrue(boolean3 == boolean0);
      assertTrue(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("Sel", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation("Sel", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, aminoAcidSequence2.length());
      assertEquals("x  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      char char0 = AminoAcidSequence.getOneLetterCode("Sel");
      assertEquals('u', char0);
      
      boolean boolean4 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean4);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(boolean4 == boolean1);
      assertFalse(boolean4 == boolean2);
      assertFalse(boolean4 == boolean0);
      assertFalse(boolean4 == boolean3);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(3, aminoAcidSequence0.length());
      assertEquals(".  ", aminoAcidSequence0.toString());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence1.toString());
      assertEquals(63, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      char char1 = AminoAcidSequence.getCodonTranslation('g', '*', '{');
      assertEquals('.', char1);
      assertFalse(char1 == char0);
  }

  @Test(timeout = 4000)
  public void test234()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('\'');
      assertEquals(7, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('\'');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: '
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test235()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, false, true);
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      boolean boolean1 = AminoAcidSequence.isLegalCodon('W');
      assertTrue(boolean1);
      assertFalse(boolean1 == boolean0);
      
      int int0 = AminoAcidSequence.getAminoAcidType('W');
      assertEquals(3, int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('_');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: _
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test236()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("");
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      float float0 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float0, 0.01F);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(0, aminoAcidSequence1.length());
      assertEquals("", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence.setGeneCode();
      float float1 = aminoAcidSequence0.getMolecularWeight();
      assertEquals(0.0F, float1, 0.01F);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(float1, float0, 0.01F);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      
      boolean boolean0 = AminoAcidSequence.isStopCodon('5');
      assertFalse(boolean0);
      
      AminoAcidSequence.setGeneCode();
      int int0 = AminoAcidSequence.getSymbolIndex('D');
      assertEquals(3, int0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('5');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals(63, aminoAcidSequence2.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence3 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      assertNotNull(aminoAcidSequence3);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence3.equals((Object)aminoAcidSequence0));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertFalse(aminoAcidSequence3.containsStopCodon());
      assertEquals(63, aminoAcidSequence3.length());
      assertEquals(".  .  .  .  .  .  .  .  .  .  .  .  f  .  .  .  .  .  .  .  g  ", aminoAcidSequence3.toString());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence3);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence3, aminoAcidSequence0);
      
      int int2 = AminoAcidSequence.getAminoAcidType('3');
      assertEquals(7, int2);
      assertTrue(int2 == int1);
      assertFalse(int2 == int0);
      
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(1);
      assertNotNull(string0);
      assertEquals("Arg", string0);
      
      AminoAcidSequence.setGeneCode();
      char char0 = AminoAcidSequence.getOneLetterCode("Arg");
      assertEquals('r', char0);
  }

  @Test(timeout = 4000)
  public void test237()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      float float0 = aminoAcidSequence1.getMolecularWeight();
      assertEquals((-18.015F), float0, 0.01F);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(".  .  ", aminoAcidSequence0.toString());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(6, aminoAcidSequence0.length());
      assertEquals(63, aminoAcidSequence2.length());
      assertEquals("x  x  x  x  x  x  x  x  x  x  x  x  f  x  x  x  x  x  x  x  g  ", aminoAcidSequence2.toString());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&");
      assertNotNull(fastaStreamSequence0);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      
      Strand strand0 = new Strand(bases0, 57);
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      assertNotNull(aGWindowAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      
      Bases bases1 = aGWindowAlgorithm0.getBases();
      assertNotNull(bases1);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, false, true, false);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence2));
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(2, aminoAcidSequence1.length());
      assertEquals("..", aminoAcidSequence1.toString());
      assertEquals(6, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(6, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertEquals(1.4E-45F, aGWindowAlgorithm0.getUserMin(), 0.01F);
      assertEquals("ag_content", aGWindowAlgorithm0.getAlgorithmShortName());
      assertTrue(aGWindowAlgorithm0.scalingFlag());
      assertEquals("AG Content (%)", aGWindowAlgorithm0.getAlgorithmName());
      assertFalse(aGWindowAlgorithm0.isUserMaxMin());
      assertEquals(1, aGWindowAlgorithm0.getValueCount());
      assertFalse(aGWindowAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, aGWindowAlgorithm0.getUserMax(), 0.01F);
      assertTrue(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence2);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      AminoAcidSequence.setGeneCode();
      String string0 = AminoAcidSequence.getThreeLetterAbbreviation(5);
      assertNotNull(string0);
      assertEquals("Gln", string0);
      
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test238()  throws Throwable  {
      int int0 = AminoAcidSequence.getAminoAcidType('G');
      assertEquals(4, int0);
      
      System.setCurrentTimeMillis(4);
      boolean boolean0 = AminoAcidSequence.isLegalCodon('G');
      assertTrue(boolean0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('G', 'G', 'G');
      assertEquals('.', char0);
      
      char char1 = AminoAcidSequence.getSymbolFromIndex(4);
      assertEquals('c', char1);
      assertFalse(char1 == char0);
      
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("JNk", false);
      assertNotNull(aminoAcidSequence0);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      
      DNANoAmbPack dNANoAmbPack0 = new DNANoAmbPack((byte) (-5));
      assertNotNull(dNANoAmbPack0);
      assertEquals((byte)2, dNANoAmbPack0.wordSize());
      assertFalse(dNANoAmbPack0.handlesAmbiguity());
      
      Clipboard clipboard0 = new Clipboard(" AW]AH_0");
      assertNotNull(clipboard0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      Marker marker0 = selection0.getStartBaseOfSelection();
      assertNull(marker0);
      assertEquals(" AW]AH_0", clipboard0.getName());
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("_Qyf4WI:(Jf!", true);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, aminoAcidSequence1.length());
      assertEquals("xxxx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean1 = AminoAcidSequence.isStopCodon('K');
      assertFalse(boolean1);
      assertFalse(boolean1 == boolean0);
      
      Character character0 = new Character('K');
      assertNotNull(character0);
      assertEquals('K', (char)character0);
      assertFalse(character0.equals((Object)char0));
      assertFalse(character0.equals((Object)char1));
      
      boolean boolean2 = aminoAcidSequence0.checkForMatch(aminoAcidSequence1);
      assertTrue(boolean2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2 == boolean1);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals(1, aminoAcidSequence0.length());
      assertEquals(".", aminoAcidSequence0.toString());
      assertEquals(4, aminoAcidSequence1.length());
      assertEquals("xxxx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      int int1 = AminoAcidSequence.getSymbolIndex('#');
      assertEquals(21, int1);
      assertFalse(int1 == int0);
      
      boolean boolean3 = aminoAcidSequence1.containsStopCodon();
      assertFalse(boolean3);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertFalse(boolean3 == boolean0);
      assertTrue(boolean3 == boolean1);
      assertFalse(boolean3 == boolean2);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(4, aminoAcidSequence1.length());
      assertEquals("xxxx", aminoAcidSequence1.toString());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      boolean boolean4 = AminoAcidSequence.isLegalCodon('.');
      assertFalse(boolean4);
      assertFalse(boolean4 == boolean2);
      assertFalse(boolean4 == boolean0);
      assertTrue(boolean4 == boolean3);
      assertTrue(boolean4 == boolean1);
  }

  @Test(timeout = 4000)
  public void test239()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      assertNotNull(aminoAcidSequence0);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Short short0 = new Short((short)2888);
      assertNotNull(short0);
      assertEquals((short)2888, (short)short0);
      
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("Jn/g", false);
      assertNotNull(aminoAcidSequence1);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".", aminoAcidSequence1.toString());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Jn/g");
      assertNotNull(fastaStreamSequence0);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, ":R!XX0a|)N\"+Ru{YY");
      assertNotNull(filteredEntryGroup0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(":R!XX0a|)N\"+Ru{YY", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      
      Bases bases1 = filteredEntryGroup0.getBases();
      assertNotNull(bases1);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(":R!XX0a|)N\"+Ru{YY", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      MarkerRange markerRange0 = aminoAcidSequence1.findMatch(bases1, (Marker) null, false, false, true);
      assertNotNull(markerRange0);
      assertFalse(aminoAcidSequence1.equals((Object)aminoAcidSequence0));
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, aminoAcidSequence1.length());
      assertFalse(aminoAcidSequence1.containsStopCodon());
      assertEquals(".", aminoAcidSequence1.toString());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(4, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(3, fastaStreamSequence0.getOtherCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(":R!XX0a|)N\"+Ru{YY", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertFalse(markerRange0.isForwardMarker());
      assertNotSame(aminoAcidSequence1, aminoAcidSequence0);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence2 = AminoAcidSequence.getTranslation("A/", true);
      assertNotNull(aminoAcidSequence2);
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence0));
      assertFalse(aminoAcidSequence2.equals((Object)aminoAcidSequence1));
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(0, aminoAcidSequence2.length());
      assertFalse(aminoAcidSequence2.containsStopCodon());
      assertEquals("", aminoAcidSequence2.toString());
      assertNotSame(aminoAcidSequence2, aminoAcidSequence0);
      assertNotSame(aminoAcidSequence2, aminoAcidSequence1);
      
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      assertNotNull(partialSequence0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Bases bases2 = new Bases(partialSequence0);
      assertNotNull(bases2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Strand strand0 = bases2.getReverseStrand();
      assertNotNull(strand0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      assertNotNull(markerInternal0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertEquals(0, markerInternal0.getPosition());
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(64, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      partialSequence0.clear();
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      int int0 = strand0.getACount();
      assertEquals(0, int0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      Marker marker0 = strand0.makeMarkerFromRawPosition(5);
      assertNotNull(marker0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals((-4), marker0.getPosition());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      bases2.reverseComplement();
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange1 = aminoAcidSequence0.findMatch(bases2, marker0, false, true, true);
      assertNotNull(markerRange1);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(markerRange1.equals((Object)markerRange0));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals((-4), marker0.getPosition());
      assertFalse(markerRange1.isForwardMarker());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(markerRange1, markerRange0);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange2 = aminoAcidSequence0.findMatch(bases2, marker0, false, false, true);
      assertNotNull(markerRange2);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(markerRange2.equals((Object)markerRange1));
      assertFalse(markerRange2.equals((Object)markerRange0));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals((-4), marker0.getPosition());
      assertFalse(markerRange2.isForwardMarker());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(markerRange2, markerRange1);
      assertNotSame(markerRange2, markerRange0);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      String string0 = aminoAcidSequence0.toString();
      assertNotNull(string0);
      assertEquals("", string0);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      MarkerRange markerRange3 = aminoAcidSequence0.findMatch(bases2, marker0, true, true, false);
      assertNull(markerRange3);
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence2));
      assertFalse(aminoAcidSequence0.equals((Object)aminoAcidSequence1));
      assertFalse(bases2.equals((Object)bases0));
      assertFalse(bases2.equals((Object)bases1));
      assertEquals(1, AminoAcidSequence.POSITIVELY_CHARGED_AA);
      assertEquals(7, AminoAcidSequence.ILLEGAL_AA);
      assertEquals(5, AminoAcidSequence.STOP_AA);
      assertEquals(2, AminoAcidSequence.NEGATIVELY_CHARGED_AA);
      assertEquals(6, AminoAcidSequence.UNKNOWN_AA);
      assertEquals(3, AminoAcidSequence.HYDROPHOBIC_AA);
      assertEquals(25, AminoAcidSequence.symbol_count);
      assertEquals(4, AminoAcidSequence.SPECIAL_AA);
      assertEquals(0, AminoAcidSequence.POLAR_UNCHARGED_AA);
      assertEquals(0, Marker.LISTENER_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(2, charArray0.length);
      assertFalse(aminoAcidSequence0.containsStopCodon());
      assertEquals("", aminoAcidSequence0.toString());
      assertEquals(0, aminoAcidSequence0.length());
      assertEquals((-4), marker0.getPosition());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getOtherCount());
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(25, (int)partialSequence0.getPhase());
      assertEquals(0, partialSequence0.getACount());
      assertFalse(partialSequence0.isComplement());
      assertEquals((short)2888, (short)partialSequence0.getStrand());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals(0, partialSequence0.length());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotSame(aminoAcidSequence0, aminoAcidSequence2);
      assertNotSame(aminoAcidSequence0, aminoAcidSequence1);
      assertNotSame(bases2, bases0);
      assertNotSame(bases2, bases1);
      assertArrayEquals(new char[] {'-', '\u0000'}, charArray0);
      
      char char0 = AminoAcidSequence.getCodonTranslation('-', '*', '-');
      assertEquals('.', char0);
      
      int int1 = AminoAcidSequence.getAminoAcidType('<');
      assertEquals(7, int1);
      assertFalse(int1 == int0);
      
      // Undeclared exception!
      try { 
        AminoAcidSequence.getThreeLetterAbbreviation((-1461));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1461
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test240()  throws Throwable  {
      AminoAcidSequence.getAminoAcidType('+');
      char[] charArray0 = new char[9];
      charArray0[0] = '+';
      charArray0[1] = 'Q';
      charArray0[6] = '+';
      boolean boolean0 = true;
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(charArray0, true);
      AminoAcidSequence.getSymbolIndex('Q');
      AminoAcidSequence.getSpacedTranslation("The location of the client's PKCS#8 SSL key", true);
      AminoAcidSequence.getOneLetterCode("The location of the client's PKCS#8 SSL key");
      AminoAcidSequence.getTranslation(aminoAcidSequence1.codon_translation_array, true);
      aminoAcidSequence0.containsStopCodon();
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence aminoAcidSequence2 = new AminoAcidSequence("uk.ac.sanger.artemis.plot.GCFrameAlgorithm");
      aminoAcidSequence1.checkForMatch(aminoAcidSequence2);
      // Undeclared exception!
      try { 
        aminoAcidSequence2.getMolecularWeight();
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: o
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test241()  throws Throwable  {
      byte[] byteArray0 = new byte[9];
      byteArray0[1] = (byte) (-99);
      byteArray0[2] = (byte) (-1);
      byteArray0[3] = (byte)13;
      byteArray0[4] = (byte)7;
      byteArray0[7] = (byte)44;
      byteArray0[7] = (byte)20;
      byteArray0[8] = (byte)12;
      AminoAcidSequence.getThreeLetterAbbreviation('k');
      AminoAcidSequence aminoAcidSequence0 = new AminoAcidSequence("Lys");
      AminoAcidSequence.isLegalCodon('k');
      AminoAcidSequence.getOneLetterCode("Phe");
      aminoAcidSequence0.getMolecularWeight();
      AminoAcidSequence.getAminoAcidType('[');
      AminoAcidSequence.isLegalCodon('[');
      AminoAcidSequence.getSymbolFromIndex(21);
      AminoAcidSequence.getCodonTranslation('k', 'f', '');
      AminoAcidSequence.isLegalCodon('(');
      AminoAcidSequence.getAminoAcidType('#');
      AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('&');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: &
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test242()  throws Throwable  {
      char[] charArray0 = new char[2];
      charArray0[0] = ';';
      charArray0[1] = '-';
      Short short0 = new Short((short)2888);
      AminoAcidSequence.getAminoAcidType('I');
      System.setCurrentTimeMillis(1634L);
      boolean boolean0 = false;
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((char[]) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test243()  throws Throwable  {
      char[] charArray0 = new char[15];
      charArray0[1] = '-';
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      Short short0 = new Short((short)2888);
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, '\u0000');
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      Marker marker0 = markerInternal0.parent;
      MarkerRange markerRange0 = new MarkerRange((Marker) null);
      aminoAcidSequence0.toString();
      aminoAcidSequence0.findMatch(bases0, (Marker) null, false, true, true);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('j');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: j
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test244()  throws Throwable  {
      char[] charArray0 = new char[16];
      charArray0[1] = '-';
      Short short0 = new Short((short)2888);
      int int0 = AminoAcidSequence.getAminoAcidType('R');
      System.setCurrentTimeMillis(1634L);
      Bases bases0 = new Bases((Sequence) null);
      int int1 = AminoAcidSequence.getSymbolIndex('R');
      assertTrue(int1 == int0);
      
      Strand strand0 = new Strand(bases0, 3826);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Range range0 = new Range(5, 8);
      boolean boolean0 = AminoAcidSequence.isLegalCodon(')');
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test245()  throws Throwable  {
      char[] charArray0 = new char[2];
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation(charArray0, true);
      Short short0 = new Short((short)2888);
      PartialSequence partialSequence0 = new PartialSequence(aminoAcidSequence0.codon_translation_array, 0, 0, short0, (Integer) 25);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = new Strand(bases0, '\u0000');
      MarkerInternal markerInternal0 = new MarkerInternal(strand0, 0);
      Marker marker0 = markerInternal0.parent;
      Short.compare((short)2888, (short)2888);
      boolean boolean0 = false;
      aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      aminoAcidSequence0.toString();
      markerInternal0.setPosition((-389));
      boolean boolean1 = true;
      boolean boolean2 = true;
      aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, true);
      byte[] byteArray0 = new byte[3];
      byteArray0[0] = (byte)61;
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex(';');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: ;
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test246()  throws Throwable  {
      AminoAcidSequence.getTranslation("7\">]Y&", false);
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getTranslation("7\">]Y&", false);
      aminoAcidSequence0.getMolecularWeight();
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&", "7\">]Y&");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 5);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      byte[] byteArray0 = new byte[5];
      byteArray0[0] = (byte)89;
      byteArray0[1] = (byte)32;
      byteArray0[2] = (byte)49;
      byteArray0[3] = (byte)42;
      byteArray0[4] = (byte)92;
      FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      Selection selection0 = new Selection((Clipboard) null);
      selection0.getStartBaseOfSelection();
      aminoAcidSequence0.findMatch(bases1, (Marker) null, false, true, false);
      AminoAcidSequence.setGeneCode();
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      selection0.getSelectionText();
      AminoAcidSequence.getThreeLetterAbbreviation('r');
      aminoAcidSequence0.findMatch(bases0, (Marker) null, true, true, false);
      AminoAcidSequence.getThreeLetterAbbreviation(5);
      char char0 = '4';
      // Undeclared exception!
      try { 
        AminoAcidSequence.getSymbolIndex('4');
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // Internal error - illegal one letter codon symbol: 4
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test247()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("7\">]Y&", true);
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation("7\">]Y&", true);
      aminoAcidSequence1.getMolecularWeight();
      AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, true);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("7\">]Y&");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = new Strand(bases0, 57);
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      Bases bases1 = aGWindowAlgorithm0.getBases();
      Selection selection0 = new Selection((Clipboard) null);
      Marker marker0 = strand0.makeMarker(1);
      aminoAcidSequence1.findMatch(bases1, marker0, true, true, true);
      AminoAcidSequence.setGeneCode();
      AminoAcidSequence.getThreeLetterAbbreviation('r');
      aminoAcidSequence1.findMatch(bases0, marker0, false, true, true);
      AminoAcidSequence.getThreeLetterAbbreviation(5);
      // Undeclared exception!
      try { 
        aminoAcidSequence1.elementAt(2);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test248()  throws Throwable  {
      AminoAcidSequence aminoAcidSequence0 = AminoAcidSequence.getSpacedTranslation("T#hr", false);
      AminoAcidSequence.getCodonTranslation("T#hr");
      AminoAcidSequence aminoAcidSequence1 = AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, false);
      AminoAcidSequence.getOneLetterCode("F|awc;rdec\"\"[");
      aminoAcidSequence1.getMolecularWeight();
      AminoAcidSequence.getTranslation(aminoAcidSequence0.codon_translation_array, true);
      AminoAcidSequence aminoAcidSequence2 = new AminoAcidSequence("A2'[$reD}%=V3.");
      AminoAcidSequence.isLegalCodon('6');
      AminoAcidSequence.isLegalCodon('@');
      AminoAcidSequence.getAminoAcidType('.');
      AminoAcidSequence.getSpacedTranslation(aminoAcidSequence0.codon_translation_array, false);
      // Undeclared exception!
      try { 
        AminoAcidSequence.getTranslation((String) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.AminoAcidSequence", e);
      }
  }
}
