# Test build for native linux and win32 

# MACRO camitk_test_build
#
# usage:
# camitk_test_build(Name BuildRoot Plateform SvnSubDir)
# 
# Name          Name of the project (camitk, myextension...)
# Plateform     Either "native" to compile for linux on linux or "win32" to compile using crosscompiling environment
# SvnSubDir     source subdirectory to use (starting from CAMITK_SVN_TRUNK
# BuildOptions  All the build options (independantly from the crosscompilation option and generator)
macro(camitk_test_build Name Plateform SvnSubDir BuildOptions)

set(CTEST_PROJECT_NAME ${Name}) 
set(CAMITK_TEST_PLATEFORM ${Plateform})
set(CAMITK_SVN_SUBDIR ${SvnSubDir})
set(CAMITK_BUILD_OPTIONS ${BuildOptions})

set(CTEST_SOURCE_DIRECTORY ${CAMITK_TEST_BUILD_ROOT}/src/${CTEST_PROJECT_NAME})
set(CTEST_BINARY_DIRECTORY ${CAMITK_TEST_BUILD_ROOT}/build-${CAMITK_TEST_PLATEFORM}/${CTEST_PROJECT_NAME})

# which ctest command to use for running the dashboard
set(CTEST_COMMAND "${CTEST_EXECUTABLE_NAME} -D Nightly")

# what cmake command to use for configuring this dashboard
set(CTEST_CMAKE_COMMAND "${CMAKE_EXECUTABLE_NAME}")

# should ctest wipe the binary tree before running
ctest_empty_binary_directory( ${CTEST_BINARY_DIRECTORY} )

# Output anything outputted by the test program if the test should fail
set(CTEST_OUTPUT_ON_FAILURE ON)

find_program(CTEST_SVN_COMMAND NAMES svn)
if(NOT EXISTS "${CTEST_SOURCE_DIRECTORY}")
  set(CTEST_CHECKOUT_COMMAND "${CTEST_SVN_COMMAND} co ${CAMITK_SVN_TRUNK}/${CAMITK_SVN_SUBDIR} ${CTEST_SOURCE_DIRECTORY}")
endif()
set(CTEST_UPDATE_COMMAND "${CTEST_SVN_COMMAND}")


if (CAMITK_TEST_PLATEFORM STREQUAL "native")
  set(CTEST_CMAKE_GENERATOR "Unix Makefiles")
  set(CAMITK_CROSSCOMPILATION_FLAGS "")
else()
  if (CAMITK_TEST_PLATEFORM STREQUAL "win32")
    set(CTEST_CMAKE_GENERATOR "Unix Makefiles")
    # specific cross compilation flags
    set(CAMITK_CROSSCOMPILATION_FLAGS "-DCMAKE_TOOLCHAIN_FILE=${MINGW32_CROSS_ENV}/usr/i686-pc-mingw32/share/cmake/mingw-cross-env-conf.cmake 
        -DQT_QMAKE_EXECUTABLE:FILEPATH=${MINGW32_CROSS_ENV}/usr/bin/i686-pc-mingw32-qmake
        -DXML2_CONFIG=${MINGW32_CROSS_ENV}/usr/i686-pc-mingw32/bin/xml2-config ")
  endif()
endif()

#set(CTEST_BUILD_CONFIGURATION "Profiling")

# NOTE beware of CAMITK_INSTALL_ROOT, do not leave it on its own line (but joined it with ${CAMITK_FLAGS_BASE})
set(CTEST_BUILD_OPTIONS "-DCMAKE_BUILD_TYPE=Release -DCAMITK_INSTALL_ROOT=${CAMITK_TEST_BUILD_ROOT}/install-${CAMITK_TEST_PLATEFORM} ${CAMITK_CROSSCOMPILATION_FLAGS} ${CAMITK_BUILD_OPTIONS}")

set(CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} \"-G${CTEST_CMAKE_GENERATOR}\" ${CTEST_BUILD_OPTIONS} ${CTEST_SOURCE_DIRECTORY}")
#-DCMAKE_BUILD_TYPE:STRING=${CTEST_BUILD_CONFIGURATION}")
# set(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DWITH_TESTING:BOOL=ON ${CTEST_BUILD_OPTIONS}")
# set(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} \"-G${CTEST_CMAKE_GENERATOR}\"")
# set(CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} \"${CTEST_SOURCE_DIRECTORY}\"")

ctest_start("Experimental") # or ctest_start("Nightly")
ctest_update()
ctest_configure()
ctest_configure() # 2nd time to make sure all parameters discovered during the previous configure are set properly)
ctest_configure() # 3rd time to make sure all parameters discovered during the previous configure are set properly)
ctest_configure() # 4th time to make sure all parameters discovered during the previous configure are set properly)
ctest_configure() # 5th time to make sure all parameters discovered during the previous configure are set properly)
ctest_build()
ctest_build(TARGET install)
#TODO add a ctest_test()
#TODO add a ctest_submit()

endmacro()
