/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include "ComponentExtension.h"

// -- QT stuff
#include <QDir>
#include <QtGui>

namespace camitk {

// -------------------- constructor --------------------
ComponentExtension::ComponentExtension() {
    autoload = false;
}

// -------------------- destructor --------------------
ComponentExtension::~ComponentExtension() {
}

// -------------------- save --------------------
bool ComponentExtension::save(Component* component) const {
    QString extension = QFileInfo(component->getFileName()).completeSuffix();

    QMessageBox::warning(NULL, "Saving Error", "Extension " + getName() + " can not export the component:<br/>\""
    + component->getName() + "\"<br/>To the file format \"." + extension + "\"<br>This is not implemented yet.");

    return false;
}



}
