package charactermanaj.model;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectInputStream.GetField;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * 最後に使用したデータの使用状況
 * @author seraphy
 */
public class RecentData implements Serializable {
	
	/**
	 * ロガー
	 */
	private static final Logger logger = Logger.getLogger(RecentData.class.getName());

	private static final long serialVersionUID = 7232012934972862661L;

	private String appVersion;

	private URI docBase;

	/**
	 * デシリアライズ
	 * @param inp オブジェクトの復元ストリーム
	 * @throws IOException 例外
	 * @throws ClassNotFoundException 例外
	 */
	private void readObject(ObjectInputStream inp) throws IOException,
			ClassNotFoundException {
		GetField fields = inp.readFields();

		ObjectStreamClass sig = fields.getObjectStreamClass();
		if (logger.isLoggable(Level.FINE)) {
			logger.log(Level.FINE, "RecentDataのデシリアライズ name=" + sig.getName()
					+ "/sid=" + sig.getSerialVersionUID());
		}
		
		appVersion = (String) fields.get("appVersion", null);
		
		Object anyDocBase = fields.get("docBase", null);
		if (anyDocBase != null && anyDocBase instanceof URL) {
			// 旧形式のURLの場合はURIに変換.
			File file = new File(((URL) anyDocBase).getPath());
			anyDocBase = file.toURI();
		}
		docBase = (URI) anyDocBase;
	}
	
	public String getAppVersion() {
		return appVersion;
	}

	public void setAppVersion(String appVersion) {
		this.appVersion = appVersion;
	}

	public URI getDocBase() {
		return docBase;
	}

	public void setDocBase(URI docBase) {
		this.docBase = docBase;
	}
	
	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("appVersion=" + appVersion + "/docBase=" + docBase);
		return buf.toString();
	}
}
