/****************************************************************************
 *    lib/c/ - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef QUERY_H
#define QUERY_H
#include "Statement.h"

#include <string>

namespace C {

/******************************* Abstract Class ****************************
Query does not have any pure virtual methods, but its author
  defined it as an abstract class, so you should not use it directly.
  Inherit from it instead and create only objects from the derived classes
*****************************************************************************/

class Query : virtual public Statement
{
public:

	Query(int line=0, Types* types=NULL);

	virtual ~Query ( );

	void print(Printer* p);

protected:
	string time_;

};
}; // end of package namespace

#endif // QUERY_H
