/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */
/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2006 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation (the
 * "Data Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 *
 * Unicode and the Unicode logo are trademarks of Unicode, Inc., and may be
 * registered in some jurisdictions. All other trademarks and registered
 * trademarks mentioned herein are the property of their respective owners.
 */
/*
 * This file has been modified by Sun Microsystems, Inc.
 */

#ifndef _SYS_U8_TEXTPREP_DATA_H
#define	_SYS_U8_TEXTPREP_DATA_H

#pragma ident	"%Z%%M%	%I%	%E% SMI"

#include <sys/types.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * To get to the combining class data, composition mappings, decomposition
 * mappings, and case conversion mappings of Unicode, the data structures
 * formulated and their meanings are like the following:
 *
 * Each UTF-8 character is seen as a 4-byte entity so that U+0061 (or 0x61 in
 * UTF-8) would be seen as 0x00 0x00 0x00 0x61. Similarly, U+1D15E would be
 * 0xF0 0x9D 0x85 0x9E in UTF-8.
 *
 * The first byte (MSB) value is an index to the b1_tbl, such as
 * u8_common_b1_tbl and u8_composition_b1_tbl tables. A b1_tbl has
 * indices to b2_tbl tables that have indices to b3_tbl. Each b3_tbl has
 * either indices to b4_tbl or indices to b4_tbl and base values for
 * displacement calculations later by using the u8_displacement_t type at
 * below. Each b4_tbl table then has indices to the final tables.
 *
 * As an example, if we have a character with code value of U+1D15E which is
 * 0xF0 0x9D 0x85 0x9E in UTF-8, the target decomposition character bytes
 * that will be mapped by the mapping procedure would be the ones between
 * the start_index and the end_index computed as like the following:
 *
 *	b2_tbl_id = u8_common_b1_tbl[0][0xF0];
 *	b3_tbl_id = u8_decomp_b2_tbl[0][b2_tbl_id][0x9D];
 *	b4_tbl_id = u8_decomp_b3_tbl[0][b3_tbl_id][0x85].tbl_id;
 *	b4_base = u8_decomp_b3_tbl[0][b3_tbl_id][0x85].base;
 *	if (b4_tbl_id >= 0x8000) {
 *		b4_tbl_id -= 0x8000;
 *      	start_index = u8_decomp_b4_16bit_tbl[0][b4_tbl_id][0x9E];
 *      	end_index = u8_decomp_b4_16bit_tbl[0][b4_tbl_id][0x9E + 1];
 *	} else {
 *      	start_index = u8_decomp_b4_tbl[0][b4_tbl_id][0x9E];
 *      	end_index = u8_decomp_b4_tbl[0][b4_tbl_id][0x9E + 1];
 *	}
 *
 * The start_index and the end_index can be used to retrieve the bytes
 * possibly of multiple UTF-8 characters from the final tables.
 *
 * The "[0]" at the above indicates this is for Unicode Version 3.2.0 data
 * as of today.  Consequently, the "[1]" indicates another Unicode version
 * data and it is Unicode 5.0.0 as of today.
 *
 * The mapping procedures and the data structures are more or less similar or
 * alike among different mappings. You might want to read the u8_textprep.c
 * for specific details.
 *
 * The tool programs created and used to generate the tables in this file are
 * saved at PSARC/2007/149/materials/ as tools.tar.gz file.
 */

/* The following is a component type for the b4_tbl vectors. */
typedef struct {
	uint16_t	tbl_id;
	uint16_t	base;
} u8_displacement_t;

/*
 * The U8_TBL_ELEMENT_NOT_DEF macro indicates a byte that is not defined or
 * used. The U8_TBL_ELEMENT_FILLER indicates the end of a UTF-8 character at
 * the final tables.
 */
#define	U8_TBL_ELEMENT_NOT_DEF		(0xff)
#define	N_				U8_TBL_ELEMENT_NOT_DEF

#define	U8_TBL_ELEMENT_FILLER		(0xf7)
#define	FIL_				U8_TBL_ELEMENT_FILLER

/*
 * The common b1_tbl for combining class, decompositions, tolower, and
 * toupper case conversion mappings.
 */
static const uchar_t u8_common_b1_tbl[2][256] = {
	{
		0,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		1,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
	},
	{
		0,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		1,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
	},
};

static const uchar_t u8_combining_class_b2_tbl[2][2][256] = {
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 5,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 6,  N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, 5,  N_, N_, N_, N_, 6,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			7,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 8,  N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},

};

static const uchar_t u8_combining_class_b3_tbl[2][9][256] = {
	{
		{	/* Third byte table 0. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 0,  1,  N_, N_,
			N_, N_, 2,  N_, N_, N_, 3,  4,
			N_, 5,  N_, 6,  7,  8,  N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 1. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 9,  10, 11, 12,
			13, 14, 15, 16, 17, 18, N_, 19,
			N_, 20, N_, 21, N_, 22, N_, 23,
			24, 25, 26, 27, 28, 29, 30, 31,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 2. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			32, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 33, N_, N_, 34,
			N_, N_, 35, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 3. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, 36, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 4. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			37, N_, 38, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 5. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 39, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			40, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 6. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 41, 42, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 7. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 8. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
	},
	{
		{	/* Third byte table 0. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 0,  1,  N_, N_,
			N_, N_, 2,  N_, N_, N_, 3,  4,
			5,  6,  N_, 7,  8,  9,  N_, 10,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 1. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 11, 12, 13, 14,
			15, 16, 17, 18, 19, 20, N_, 21,
			N_, 22, 23, 24, N_, 25, N_, 26,
			27, 28, 29, 30, 31, 32, 33, 34,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 2. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			35, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 36, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 37, N_, N_, 38,
			N_, N_, 39, N_, 40, N_, N_, N_,
			41, N_, N_, N_, 42, 43, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 44,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 3. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, 45, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 4. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			46, N_, 47, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 5. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			48, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 6. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, 49, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			50, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 7. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			51, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{	/* Third byte table 8. */
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 52, 53, N_,
			N_, 54, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
	},
};

/*
 * Unlike other b4_tbl, the b4_tbl for combining class data has
 * the combining class values not indices to the final tables.
 */
static const uchar_t u8_combining_class_b4_tbl[2][55][256] = {
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 232, 220, 220,
			220, 220, 232, 216, 220, 220, 220, 220,
			220, 202, 202, 220, 220, 220, 220, 202,
			202, 220, 220, 220, 220, 220, 220, 220,
			220, 220, 220, 220, 1,   1,   1,   1,
			1,   220, 220, 220, 220, 230, 230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 230, 240, 230, 220,
			220, 220, 230, 230, 230, 220, 220, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			234, 234, 233, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 230, 230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   230, 230, 230, 230, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   220, 230, 230, 230, 230, 220, 230,
			230, 230, 222, 220, 230, 230, 230, 230,
			230, 230, 0,   220, 220, 220, 220, 220,
			230, 230, 220, 230, 230, 222, 228, 230,
			10,  11,  12,  13,  14,  15,  16,  17,
			18,  19,  0,   20,  21,  22,  0,   23,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   24,  25,  0,   230, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   27,  28,  29,  30,  31,
			32,  33,  34,  230, 230, 220, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			35,  0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   230, 230,
			230, 230, 230, 230, 230, 0,   0,   230,
			230, 230, 230, 220, 230, 0,   0,   230,
			230, 0,   220, 230, 230, 220, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   36,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 220, 230, 230, 220, 230, 230, 220,
			220, 220, 230, 220, 220, 230, 220, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 220, 230, 220, 230, 220, 230,
			220, 230, 230, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   230, 220, 230, 230, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   84,  91,  0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			103, 103, 9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			107, 107, 107, 107, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			118, 118, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			122, 122, 122, 122, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			220, 220, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   220, 0,   220,
			0,   216, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   129, 130, 0,   132, 0,   0,   0,
			0,   0,   130, 130, 130, 130, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			130, 0,   230, 230, 9,   0,   230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   220, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			0,   9,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   228, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 1,   1,   230, 230, 230, 230,
			1,   1,   1,   230, 230, 0,   0,   0,
			0,   230, 0,   0,   0,   1,   1,   230,
			220, 230, 1,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   218, 228, 232, 222, 224, 224,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   26,  0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 41. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   216, 216, 1,
			1,   1,   0,   0,   0,   226, 216, 216,
			216, 216, 216, 0,   0,   0,   0,   0,
			0,   0,   0,   220, 220, 220, 220, 220,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 42. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			220, 220, 220, 0,   0,   230, 230, 230,
			230, 230, 220, 220, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   230, 230, 230, 230, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 43. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 44. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 45. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 46. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 47. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 48. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 49. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 50. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 51. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 52. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 53. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 54. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
	},
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 232, 220, 220,
			220, 220, 232, 216, 220, 220, 220, 220,
			220, 202, 202, 220, 220, 220, 220, 202,
			202, 220, 220, 220, 220, 220, 220, 220,
			220, 220, 220, 220, 1,   1,   1,   1,
			1,   220, 220, 220, 220, 230, 230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 230, 240, 230, 220,
			220, 220, 230, 230, 230, 220, 220, 0,
			230, 230, 230, 220, 220, 220, 220, 230,
			232, 220, 220, 230, 233, 234, 234, 233,
			234, 234, 233, 230, 230, 230, 230, 230,
			230, 230, 230, 230, 230, 230, 230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   230, 230, 230, 230, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   220, 230, 230, 230, 230, 220, 230,
			230, 230, 222, 220, 230, 230, 230, 230,
			230, 230, 220, 220, 220, 220, 220, 220,
			230, 230, 220, 230, 230, 222, 228, 230,
			10,  11,  12,  13,  14,  15,  16,  17,
			18,  19,  19,  20,  21,  22,  0,   23,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   24,  25,  0,   230, 220, 0,   18,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 230, 230, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   27,  28,  29,  30,  31,
			32,  33,  34,  230, 230, 220, 220, 230,
			230, 230, 230, 230, 220, 230, 230, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			35,  0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   230, 230,
			230, 230, 230, 230, 230, 0,   0,   230,
			230, 230, 230, 220, 230, 0,   0,   230,
			230, 0,   220, 230, 230, 220, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   36,  0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 220, 230, 230, 220, 230, 230, 220,
			220, 220, 230, 220, 220, 230, 220, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 220, 230, 220, 230, 220, 230,
			220, 230, 230, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   230, 230, 230, 230, 230,
			230, 230, 220, 230, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   230, 220, 230, 230, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   84,  91,  0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   9,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			103, 103, 9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			107, 107, 107, 107, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			118, 118, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			122, 122, 122, 122, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			220, 220, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   220, 0,   220,
			0,   216, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   129, 130, 0,   132, 0,   0,   0,
			0,   0,   130, 130, 130, 130, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			130, 0,   230, 230, 9,   0,   230, 230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   220, 0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			0,   9,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   230, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   228, 0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   222, 230, 220, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 41. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   230,
			220, 0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 42. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 43. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   230, 220, 230, 230, 230,
			230, 230, 230, 230, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 44. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 220, 230, 230, 230, 230, 230,
			230, 230, 220, 0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   230, 220,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 45. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 1,   1,   230, 230, 230, 230,
			1,   1,   1,   230, 230, 0,   0,   0,
			0,   230, 0,   0,   0,   1,   1,   230,
			220, 230, 1,   1,   220, 220, 220, 220,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 46. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   218, 228, 232, 222, 224, 224,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 47. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 48. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 49. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   26,  0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 50. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 230, 230, 230, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 51. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   220, 0,   230,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			230, 1,   220, 0,   0,   0,   0,   9,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 52. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   216, 216, 1,
			1,   1,   0,   0,   0,   226, 216, 216,
			216, 216, 216, 0,   0,   0,   0,   0,
			0,   0,   0,   220, 220, 220, 220, 220,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 53. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			220, 220, 220, 0,   0,   230, 230, 230,
			230, 230, 220, 220, 0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   230, 230, 230, 230, 0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
		{	/* Fourth byte table 54. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   230, 230, 230, 0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
		},
	},
};

static const uchar_t u8_composition_b1_tbl[2][256] = {
	{
		0,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
	},
	{
		0,  N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
		N_, N_, N_, N_, N_, N_, N_, N_,
	},
};

static const uchar_t u8_composition_b2_tbl[2][1][256] = {
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},

};

static const u8_displacement_t u8_composition_b3_tbl[2][5][256] = {
	{
		{	/* Third byte table 0. */
			{ 0x8000, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0, 2470 },
			{ 0x8001, 2491 }, { 1, 2871 }, { 2, 2959 },
			{ 3, 3061 }, { 4, 3212 }, { 5, 3226 },
			{ N_, 0 }, { 6, 3270 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0x8002, 3277 },
			{ 7, 3774 }, { 8, 3949 }, { 9, 4198 },
			{ N_, 0 }, { 10, 4265 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 11, 4293 }, { 12, 4312 }, { N_, 0 },
			{ 13, 4326 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 1. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 14, 4347 },
			{ N_, 0 }, { N_, 0 }, { 15, 4374 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 16, 4391 },
			{ 17, 4416 }, { 18, 4425 }, { N_, 0 },
			{ 19, 4451 }, { 20, 4460 }, { 21, 4469 },
			{ N_, 0 }, { 22, 4503 }, { N_, 0 },
			{ 23, 4529 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 2. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 24, 4563 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 25, 4572 }, { 26, 4588 },
			{ 27, 4620 }, { 28, 4666 }, { 0x8003, 4682 },
			{ 0x8004, 5254 }, { 29, 5616 }, { 30, 5646 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 3. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 31, 5684 },
			{ 32, 5708 }, { 33, 5732 }, { 34, 5780 },
			{ 35, 5900 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 4. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 36, 6012 }, { 37, 6241 }, { 38, 6358 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
	},
	{
		{	/* Third byte table 0. */
			{ 0x8000, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0, 2470 },
			{ 0x8001, 2491 }, { 1, 2871 }, { 2, 2959 },
			{ 3, 3061 }, { 4, 3212 }, { 5, 3226 },
			{ N_, 0 }, { 6, 3270 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0x8002, 3277 },
			{ 7, 3774 }, { 8, 3949 }, { 9, 4198 },
			{ N_, 0 }, { 10, 4265 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 11, 4293 }, { 12, 4312 }, { N_, 0 },
			{ 13, 4326 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 1. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 14, 4347 },
			{ N_, 0 }, { N_, 0 }, { 15, 4374 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 16, 4391 },
			{ 17, 4416 }, { 18, 4425 }, { N_, 0 },
			{ 19, 4451 }, { 20, 4460 }, { 21, 4469 },
			{ N_, 0 }, { 22, 4503 }, { N_, 0 },
			{ 23, 4529 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 2. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 24, 4563 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 25, 4572 }, { 26, 4662 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 27, 4671 }, { 28, 4687 },
			{ 29, 4719 }, { 30, 4765 }, { 0x8003, 4781 },
			{ 0x8004, 5353 }, { 31, 5715 }, { 32, 5745 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 3. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 33, 5783 },
			{ 34, 5807 }, { 35, 5831 }, { 36, 5879 },
			{ 37, 5999 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 4. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 38, 6111 }, { 39, 6340 }, { 40, 6457 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
	},
};

static const uchar_t u8_composition_b4_tbl[2][41][257] = {
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   29,  58,  58,  58,  58,
			58,  58,  58,  58,  58,  58,  58,  58,
			58,  58,  58,  73,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   15,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  38,  46,  46,  46,  46,
			46,  54,  62,  62,  62,  62,  62,  62,
			62,  70,  78,  86,  94,  94,  94,  94,
			94,  94,  94,  94,  94,  94,  94,  94,
			94,  94,  94,  94,  94,  94,  94,  94,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   36,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			108, 144, 144, 144, 144, 144, 144, 144,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			14,  22,  30,  30,  30,  30,  30,  37,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   15,  15,  15,  15,  70,  70,
			70,  70,  112, 133, 154, 154, 154, 162,
			162, 162, 162, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   20,  20,  20,  27,  27,  46,  59,
			66,  91,  91,  98,  98,  98,  98,  105,
			105, 105, 105, 105, 130, 130, 130, 130,
			137, 137, 137, 137, 144, 144, 151, 151,
			151, 164, 164, 164, 171, 171, 190, 203,
			210, 235, 235, 242, 242, 242, 242, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   25,  25,  25,  25,
			32,  32,  32,  32,  39,  39,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  60,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  21,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   14,  14,  14,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   9,   9,   9,   9,   9,   9,   9,
			9,   18,  18,  18,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   17,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   25,
			25,  25,  25,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   17,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   25,  25,  25,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   8,   16,  16,  16,  16,
			16,  16,  16,  24,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   15,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  38,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   8,   16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   16,
			16,  16,  16,  16,  16,  16,  16,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   16,  16,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   16,  16,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   8,   8,   8,   8,
			8,   16,  16,  16,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  32,  32,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   8,   8,   16,  16,
			16,  24,  24,  24,  24,  24,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  40,  40,  40,  48,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  64,  72,  72,  72,  80,
			88,  88,  88,  96,  104, 112, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   8,   16,  16,  16,  24,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  40,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  56,  56,  56,  56,  56,
			56,  64,  72,  72,  80,  80,  80,  80,
			80,  80,  80,  88,  96,  104, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			9,   9,   9,   9,   18,  18,  27,  27,
			36,  36,  45,  45,  54,  54,  63,  63,
			72,  72,  81,  81,  90,  90,  99,  99,
			108, 108, 117, 117, 117, 126, 126, 135,
			135, 144, 144, 144, 144, 144, 144, 144,
			161, 161, 161, 178, 178, 178, 195, 195,
			195, 212, 212, 212, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   18,
			18,  18,  18,  18,  27,  27,  36,  36,
			45,  45,  54,  54,  63,  63,  72,  72,
			81,  81,  90,  90,  99,  99,  108, 108,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   9,   9,   18,  18,  27,
			27,  36,  36,  36,  36,  36,  36,  36,
			53,  53,  53,  70,  70,  70,  87,  87,
			87,  104, 104, 104, 121, 121, 121, 121,
			121, 121, 121, 121, 121, 121, 121, 121,
			121, 121, 121, 121, 121, 121, 121, 121,
			130, 139, 148, 157, 157, 157, 157, 157,
			157, 157, 157, 157, 157, 157, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
	},
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   29,  58,  58,  58,  58,
			58,  58,  58,  58,  58,  58,  58,  58,
			58,  58,  58,  73,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   15,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  38,  46,  46,  46,  46,
			46,  54,  62,  62,  62,  62,  62,  62,
			62,  70,  78,  86,  94,  94,  94,  94,
			94,  94,  94,  94,  94,  94,  94,  94,
			94,  94,  94,  94,  94,  94,  94,  94,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102, 102, 102, 102, 102, 102, 102, 102,
			102,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   36,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			108, 144, 144, 144, 144, 144, 144, 144,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151, 151, 151, 151, 151, 151, 151, 151,
			151,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			14,  22,  30,  30,  30,  30,  30,  37,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,  44,  44,  44,  44,  44,  44,  44,
			44,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   15,  15,  15,  15,  70,  70,
			70,  70,  112, 133, 154, 154, 154, 162,
			162, 162, 162, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   20,  20,  20,  27,  27,  46,  59,
			66,  91,  91,  98,  98,  98,  98,  105,
			105, 105, 105, 105, 130, 130, 130, 130,
			137, 137, 137, 137, 144, 144, 151, 151,
			151, 164, 164, 164, 171, 171, 190, 203,
			210, 235, 235, 242, 242, 242, 242, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249, 249, 249, 249, 249, 249, 249, 249,
			249,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   25,  25,  25,  25,
			32,  32,  32,  32,  39,  39,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  53,  53,  53,
			53,  53,  53,  53,  53,  60,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  21,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   14,  14,  14,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   9,   9,   9,   9,   9,   9,   9,
			9,   18,  18,  18,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   17,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   25,
			25,  25,  25,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   17,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,  26,  26,  26,  26,  26,  26,  26,
			26,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   25,  25,  25,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  34,  34,
			34,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   9,
			18,  18,  27,  27,  36,  36,  45,  45,
			45,  45,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  63,  63,  72,  72,  81,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,  90,  90,  90,  90,  90,  90,  90,
			90,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   9,
			9,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   8,   16,  16,  16,  16,
			16,  16,  16,  24,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   15,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  38,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,  46,  46,  46,  46,  46,  46,  46,
			46,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   8,   16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,  30,  30,  30,  30,  30,  30,  30,
			30,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   16,
			16,  16,  16,  16,  16,  16,  16,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   16,  16,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   8,   8,   16,  16,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   8,   8,   8,   8,
			8,   16,  16,  16,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  32,  32,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   8,   8,   16,  16,
			16,  24,  24,  24,  24,  24,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  40,  40,  40,  48,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  64,  72,  72,  72,  80,
			88,  88,  88,  96,  104, 112, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120, 120, 120, 120, 120, 120, 120, 120,
			120,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   8,   16,  16,  16,  24,
			32,  32,  32,  32,  32,  32,  32,  32,
			32,  32,  40,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  56,  56,  56,  56,  56,
			56,  64,  72,  72,  80,  80,  80,  80,
			80,  80,  80,  88,  96,  104, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			9,   9,   9,   9,   18,  18,  27,  27,
			36,  36,  45,  45,  54,  54,  63,  63,
			72,  72,  81,  81,  90,  90,  99,  99,
			108, 108, 117, 117, 117, 126, 126, 135,
			135, 144, 144, 144, 144, 144, 144, 144,
			161, 161, 161, 178, 178, 178, 195, 195,
			195, 212, 212, 212, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229, 229, 229, 229, 229, 229, 229, 229,
			229,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   9,   9,
			9,   9,   9,   9,   9,   9,   9,   18,
			18,  18,  18,  18,  27,  27,  36,  36,
			45,  45,  54,  54,  63,  63,  72,  72,
			81,  81,  90,  90,  99,  99,  108, 108,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117, 117, 117, 117, 117, 117, 117, 117,
			117,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   9,   9,   9,   18,  18,  27,
			27,  36,  36,  36,  36,  36,  36,  36,
			53,  53,  53,  70,  70,  70,  87,  87,
			87,  104, 104, 104, 121, 121, 121, 121,
			121, 121, 121, 121, 121, 121, 121, 121,
			121, 121, 121, 121, 121, 121, 121, 121,
			130, 139, 148, 157, 157, 157, 157, 157,
			157, 157, 157, 157, 157, 157, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166, 166, 166, 166, 166, 166, 166, 166,
			166,
		},
	},
};

static const uint16_t u8_composition_b4_16bit_tbl[2][5][257] = {
	{
		{	/* Fourth byte 16-bit table 0. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    8,    16,   24,
			24,   24,   124,  146,  177,  219,  327,  335,
			379,  427,  521,  528,  562,  602,  624,  683,
			782,  797,  797,  849,  894,  941,  1061, 1076,
			1118, 1133, 1193, 1233, 1233, 1233, 1233, 1233,
			1233, 1233, 1333, 1355, 1386, 1428, 1536, 1544,
			1588, 1643, 1731, 1744, 1778, 1818, 1840, 1899,
			1998, 2013, 2013, 2065, 2110, 2164, 2284, 2299,
			2348, 2363, 2430, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470,
		},
		{	/* Fourth byte 16-bit table 1. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    29,   29,   36,   43,   56,
			64,   64,   64,   93,   93,   93,   93,   93,
			101,  101,  101,  101,  101,  130,  151,  158,
			158,  165,  165,  165,  165,  190,  190,  190,
			190,  190,  190,  219,  219,  226,  233,  246,
			254,  254,  254,  283,  283,  283,  283,  283,
			291,  291,  291,  291,  291,  320,  341,  348,
			348,  355,  355,  355,  355,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,
		},
		{	/* Fourth byte 16-bit table 2. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    49,   49,   49,   49,   77,   77,
			112,  112,  160,  160,  160,  160,  160,  160,
			188,  188,  196,  196,  196,  196,  237,  237,
			237,  237,  272,  272,  272,  280,  280,  288,
			288,  288,  344,  344,  344,  344,  372,  372,
			414,  414,  469,  469,  469,  469,  469,  469,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,
		},
		{	/* Fourth byte 16-bit table 3. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    29,   58,   66,   74,   82,   90,   98,
			106,  135,  164,  172,  180,  188,  196,  204,
			212,  227,  242,  242,  242,  242,  242,  242,
			242,  257,  272,  272,  272,  272,  272,  272,
			272,  301,  330,  338,  346,  354,  362,  370,
			378,  407,  436,  444,  452,  460,  468,  476,
			484,  506,  528,  528,  528,  528,  528,  528,
			528,  550,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,
		},
		{	/* Fourth byte 16-bit table 4. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   30,   30,   30,   30,   30,   30,
			30,   45,   60,   60,   60,   60,   60,   60,
			60,   82,   104,  104,  104,  104,  104,  104,
			104,  104,  126,  126,  126,  126,  126,  126,
			126,  155,  184,  192,  200,  208,  216,  224,
			232,  261,  290,  298,  306,  314,  322,  330,
			338,  346,  346,  346,  346,  354,  354,  354,
			354,  354,  354,  354,  354,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,
		},
	},
	{
		{	/* Fourth byte 16-bit table 0. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    8,    16,   24,
			24,   24,   124,  146,  177,  219,  327,  335,
			379,  427,  521,  528,  562,  602,  624,  683,
			782,  797,  797,  849,  894,  941,  1061, 1076,
			1118, 1133, 1193, 1233, 1233, 1233, 1233, 1233,
			1233, 1233, 1333, 1355, 1386, 1428, 1536, 1544,
			1588, 1643, 1731, 1744, 1778, 1818, 1840, 1899,
			1998, 2013, 2013, 2065, 2110, 2164, 2284, 2299,
			2348, 2363, 2430, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470, 2470, 2470, 2470, 2470, 2470, 2470, 2470,
			2470,
		},
		{	/* Fourth byte 16-bit table 1. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    29,   29,   36,   43,   56,
			64,   64,   64,   93,   93,   93,   93,   93,
			101,  101,  101,  101,  101,  130,  151,  158,
			158,  165,  165,  165,  165,  190,  190,  190,
			190,  190,  190,  219,  219,  226,  233,  246,
			254,  254,  254,  283,  283,  283,  283,  283,
			291,  291,  291,  291,  291,  320,  341,  348,
			348,  355,  355,  355,  355,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,  380,  380,  380,  380,  380,  380,  380,
			380,
		},
		{	/* Fourth byte 16-bit table 2. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    49,   49,   49,   49,   77,   77,
			112,  112,  160,  160,  160,  160,  160,  160,
			188,  188,  196,  196,  196,  196,  237,  237,
			237,  237,  272,  272,  272,  280,  280,  288,
			288,  288,  344,  344,  344,  344,  372,  372,
			414,  414,  469,  469,  469,  469,  469,  469,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,  497,  497,  497,  497,  497,  497,  497,
			497,
		},
		{	/* Fourth byte 16-bit table 3. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    29,   58,   66,   74,   82,   90,   98,
			106,  135,  164,  172,  180,  188,  196,  204,
			212,  227,  242,  242,  242,  242,  242,  242,
			242,  257,  272,  272,  272,  272,  272,  272,
			272,  301,  330,  338,  346,  354,  362,  370,
			378,  407,  436,  444,  452,  460,  468,  476,
			484,  506,  528,  528,  528,  528,  528,  528,
			528,  550,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,  572,  572,  572,  572,  572,  572,  572,
			572,
		},
		{	/* Fourth byte 16-bit table 4. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   30,   30,   30,   30,   30,   30,
			30,   45,   60,   60,   60,   60,   60,   60,
			60,   82,   104,  104,  104,  104,  104,  104,
			104,  104,  126,  126,  126,  126,  126,  126,
			126,  155,  184,  192,  200,  208,  216,  224,
			232,  261,  290,  298,  306,  314,  322,  330,
			338,  346,  346,  346,  346,  354,  354,  354,
			354,  354,  354,  354,  354,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,  362,  362,  362,  362,  362,  362,  362,
			362,
		},
	},
};

static const uchar_t u8_composition_final_tbl[2][6623] = {
	{
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xAE, FIL_,
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xA0, FIL_,
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xAF, FIL_,
		0x10, 0xCC, 0x86, FIL_, 0xC4, 0x82, FIL_, 0xCC,
		0x87, FIL_, 0xC8, 0xA6, FIL_, 0xCC, 0x8F, FIL_,
		0xC8, 0x80, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x82,
		FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x81, FIL_, 0xCC,
		0x80, FIL_, 0xC3, 0x80, FIL_, 0xCC, 0x83, FIL_,
		0xC3, 0x83, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA,
		0xA0, FIL_, 0xCC, 0xA5, FIL_, 0xE1, 0xB8, 0x80,
		FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x82, FIL_, 0xCC,
		0x84, FIL_, 0xC4, 0x80, FIL_, 0xCC, 0x88, FIL_,
		0xC3, 0x84, FIL_, 0xCC, 0x8A, FIL_, 0xC3, 0x85,
		FIL_, 0xCC, 0xA8, FIL_, 0xC4, 0x84, FIL_, 0xCC,
		0x89, FIL_, 0xE1, 0xBA, 0xA2, FIL_, 0xCC, 0x8C,
		FIL_, 0xC7, 0x8D, FIL_, 0x03, 0xCC, 0x87, FIL_,
		0xE1, 0xB8, 0x82, FIL_, 0xCC, 0xB1, FIL_, 0xE1,
		0xB8, 0x86, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0x84, FIL_, 0x05, 0xCC, 0xA7, FIL_, 0xC3, 0x87,
		FIL_, 0xCC, 0x81, FIL_, 0xC4, 0x86, FIL_, 0xCC,
		0x8C, FIL_, 0xC4, 0x8C, FIL_, 0xCC, 0x87, FIL_,
		0xC4, 0x8A, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0x88,
		FIL_, 0x06, 0xCC, 0xB1, FIL_, 0xE1, 0xB8, 0x8E,
		FIL_, 0xCC, 0xA7, FIL_, 0xE1, 0xB8, 0x90, FIL_,
		0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0x92, FIL_, 0xCC,
		0x87, FIL_, 0xE1, 0xB8, 0x8A, FIL_, 0xCC, 0x8C,
		FIL_, 0xC4, 0x8E, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB8, 0x8C, FIL_, 0x11, 0xCC, 0x80, FIL_, 0xC3,
		0x88, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x89, FIL_,
		0xCC, 0x82, FIL_, 0xC3, 0x8A, FIL_, 0xCC, 0x88,
		FIL_, 0xC3, 0x8B, FIL_, 0xCC, 0xA7, FIL_, 0xC8,
		0xA8, FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x86, FIL_,
		0xCC, 0x8F, FIL_, 0xC8, 0x84, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBA, 0xBA, FIL_, 0xCC, 0xB0, FIL_,
		0xE1, 0xB8, 0x9A, FIL_, 0xCC, 0xAD, FIL_, 0xE1,
		0xB8, 0x98, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBA,
		0xBC, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0xB8,
		FIL_, 0xCC, 0x84, FIL_, 0xC4, 0x92, FIL_, 0xCC,
		0x86, FIL_, 0xC4, 0x94, FIL_, 0xCC, 0x87, FIL_,
		0xC4, 0x96, FIL_, 0xCC, 0xA8, FIL_, 0xC4, 0x98,
		FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0x9A, FIL_, 0x01,
		0xCC, 0x87, FIL_, 0xE1, 0xB8, 0x9E, FIL_, 0x07,
		0xCC, 0x8C, FIL_, 0xC7, 0xA6, FIL_, 0xCC, 0x87,
		FIL_, 0xC4, 0xA0, FIL_, 0xCC, 0x84, FIL_, 0xE1,
		0xB8, 0xA0, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0x9C,
		FIL_, 0xCC, 0x81, FIL_, 0xC7, 0xB4, FIL_, 0xCC,
		0xA7, FIL_, 0xC4, 0xA2, FIL_, 0xCC, 0x86, FIL_,
		0xC4, 0x9E, FIL_, 0x07, 0xCC, 0xAE, FIL_, 0xE1,
		0xB8, 0xAA, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB8,
		0xA2, FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xB8, 0xA6,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8, 0xA4, FIL_,
		0xCC, 0xA7, FIL_, 0xE1, 0xB8, 0xA8, FIL_, 0xCC,
		0x8C, FIL_, 0xC8, 0x9E, FIL_, 0xCC, 0x82, FIL_,
		0xC4, 0xA4, FIL_, 0x0F, 0xCC, 0x84, FIL_, 0xC4,
		0xAA, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0x8C, FIL_,
		0xCC, 0xA8, FIL_, 0xC4, 0xAE, FIL_, 0xCC, 0x83,
		FIL_, 0xC4, 0xA8, FIL_, 0xCC, 0x88, FIL_, 0xC3,
		0x8F, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x8D, FIL_,
		0xCC, 0x8F, FIL_, 0xC8, 0x88, FIL_, 0xCC, 0x86,
		FIL_, 0xC4, 0xAC, FIL_, 0xCC, 0x91, FIL_, 0xC8,
		0x8A, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x8F, FIL_,
		0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x88, FIL_, 0xCC,
		0x87, FIL_, 0xC4, 0xB0, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xBB, 0x8A, FIL_, 0xCC, 0xB0, FIL_, 0xE1,
		0xB8, 0xAC, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x8E,
		FIL_, 0x01, 0xCC, 0x82, FIL_, 0xC4, 0xB4, FIL_,
		0x05, 0xCC, 0x8C, FIL_, 0xC7, 0xA8, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB8, 0xB4, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB8, 0xB0, FIL_, 0xCC, 0xA7, FIL_,
		0xC4, 0xB6, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB2, FIL_, 0x06, 0xCC, 0xA7, FIL_, 0xC4, 0xBB,
		FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0xBD, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB8, 0xBA, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xB8, 0xB6, FIL_, 0xCC, 0xAD, FIL_,
		0xE1, 0xB8, 0xBC, FIL_, 0xCC, 0x81, FIL_, 0xC4,
		0xB9, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1, 0xB8,
		0xBE, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x82,
		FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB9, 0x80, FIL_,
		0x09, 0xCC, 0x80, FIL_, 0xC7, 0xB8, FIL_, 0xCC,
		0xAD, FIL_, 0xE1, 0xB9, 0x8A, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0x84, FIL_, 0xCC, 0xB1, FIL_,
		0xE1, 0xB9, 0x88, FIL_, 0xCC, 0x83, FIL_, 0xC3,
		0x91, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x86,
		FIL_, 0xCC, 0x81, FIL_, 0xC5, 0x83, FIL_, 0xCC,
		0xA7, FIL_, 0xC5, 0x85, FIL_, 0xCC, 0x8C, FIL_,
		0xC5, 0x87, FIL_, 0x10, 0xCC, 0xA8, FIL_, 0xC7,
		0xAA, FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x8E, FIL_,
		0xCC, 0x80, FIL_, 0xC3, 0x92, FIL_, 0xCC, 0x9B,
		FIL_, 0xC6, 0xA0, FIL_, 0xCC, 0x8F, FIL_, 0xC8,
		0x8C, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x93, FIL_,
		0xCC, 0x87, FIL_, 0xC8, 0xAE, FIL_, 0xCC, 0x8C,
		FIL_, 0xC7, 0x91, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xBB, 0x8C, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x94,
		FIL_, 0xCC, 0x84, FIL_, 0xC5, 0x8C, FIL_, 0xCC,
		0x83, FIL_, 0xC3, 0x95, FIL_, 0xCC, 0x86, FIL_,
		0xC5, 0x8E, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0x96,
		FIL_, 0xCC, 0x8B, FIL_, 0xC5, 0x90, FIL_, 0xCC,
		0x89, FIL_, 0xE1, 0xBB, 0x8E, FIL_, 0x02, 0xCC,
		0x87, FIL_, 0xE1, 0xB9, 0x96, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0x94, FIL_, 0x08, 0xCC, 0x91,
		FIL_, 0xC8, 0x92, FIL_, 0xCC, 0xA7, FIL_, 0xC5,
		0x96, FIL_, 0xCC, 0x8C, FIL_, 0xC5, 0x98, FIL_,
		0xCC, 0xB1, FIL_, 0xE1, 0xB9, 0x9E, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xB9, 0x9A, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0x98, FIL_, 0xCC, 0x81, FIL_,
		0xC5, 0x94, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x90,
		FIL_, 0x07, 0xCC, 0x81, FIL_, 0xC5, 0x9A, FIL_,
		0xCC, 0x82, FIL_, 0xC5, 0x9C, FIL_, 0xCC, 0xA7,
		FIL_, 0xC5, 0x9E, FIL_, 0xCC, 0x8C, FIL_, 0xC5,
		0xA0, FIL_, 0xCC, 0xA6, FIL_, 0xC8, 0x98, FIL_,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xA0, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xB9, 0xA2, FIL_, 0x07, 0xCC,
		0x8C, FIL_, 0xC5, 0xA4, FIL_, 0xCC, 0xB1, FIL_,
		0xE1, 0xB9, 0xAE, FIL_, 0xCC, 0xA6, FIL_, 0xC8,
		0x9A, FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0xA2, FIL_,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xAA, FIL_, 0xCC,
		0xAD, FIL_, 0xE1, 0xB9, 0xB0, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xB9, 0xAC, FIL_, 0x13, 0xCC, 0xA8,
		FIL_, 0xC5, 0xB2, FIL_, 0xCC, 0x83, FIL_, 0xC5,
		0xA8, FIL_, 0xCC, 0x84, FIL_, 0xC5, 0xAA, FIL_,
		0xCC, 0x81, FIL_, 0xC3, 0x9A, FIL_, 0xCC, 0x86,
		FIL_, 0xC5, 0xAC, FIL_, 0xCC, 0x8A, FIL_, 0xC5,
		0xAE, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0x99, FIL_,
		0xCC, 0x91, FIL_, 0xC8, 0x96, FIL_, 0xCC, 0x8B,
		FIL_, 0xC5, 0xB0, FIL_, 0xCC, 0xA4, FIL_, 0xE1,
		0xB9, 0xB2, FIL_, 0xCC, 0xB0, FIL_, 0xE1, 0xB9,
		0xB4, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x94, FIL_,
		0xCC, 0xAD, FIL_, 0xE1, 0xB9, 0xB6, FIL_, 0xCC,
		0x9B, FIL_, 0xC6, 0xAF, FIL_, 0xCC, 0x82, FIL_,
		0xC3, 0x9B, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0x9C,
		FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x93, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBB, 0xA4, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0xA6, FIL_, 0x02, 0xCC, 0x83,
		FIL_, 0xE1, 0xB9, 0xBC, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xB9, 0xBE, FIL_, 0x06, 0xCC, 0x82, FIL_,
		0xC5, 0xB4, FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xBA,
		0x84, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xBA, 0x86,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0x88, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBA, 0x82, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBA, 0x80, FIL_, 0x02, 0xCC,
		0x87, FIL_, 0xE1, 0xBA, 0x8A, FIL_, 0xCC, 0x88,
		FIL_, 0xE1, 0xBA, 0x8C, FIL_, 0x09, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0xB6, FIL_, 0xCC, 0x87, FIL_,
		0xE1, 0xBA, 0x8E, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xBB, 0xB4, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x9D,
		FIL_, 0xCC, 0x84, FIL_, 0xC8, 0xB2, FIL_, 0xCC,
		0x82, FIL_, 0xC5, 0xB6, FIL_, 0xCC, 0x88, FIL_,
		0xC5, 0xB8, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBB,
		0xB2, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0xB8,
		FIL_, 0x06, 0xCC, 0x87, FIL_, 0xC5, 0xBB, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0x92, FIL_, 0xCC,
		0x8C, FIL_, 0xC5, 0xBD, FIL_, 0xCC, 0xB1, FIL_,
		0xE1, 0xBA, 0x94, FIL_, 0xCC, 0x82, FIL_, 0xE1,
		0xBA, 0x90, FIL_, 0xCC, 0x81, FIL_, 0xC5, 0xB9,
		FIL_, 0x10, 0xCC, 0x8C, FIL_, 0xC7, 0x8E, FIL_,
		0xCC, 0x8F, FIL_, 0xC8, 0x81, FIL_, 0xCC, 0xA8,
		FIL_, 0xC4, 0x85, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xBA, 0xA1, FIL_, 0xCC, 0x86, FIL_, 0xC4, 0x83,
		FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xA3, FIL_,
		0xCC, 0x84, FIL_, 0xC4, 0x81, FIL_, 0xCC, 0x91,
		FIL_, 0xC8, 0x83, FIL_, 0xCC, 0x8A, FIL_, 0xC3,
		0xA5, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0xA4, FIL_,
		0xCC, 0x83, FIL_, 0xC3, 0xA3, FIL_, 0xCC, 0x82,
		FIL_, 0xC3, 0xA2, FIL_, 0xCC, 0x81, FIL_, 0xC3,
		0xA1, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0xA0, FIL_,
		0xCC, 0x87, FIL_, 0xC8, 0xA7, FIL_, 0xCC, 0xA5,
		FIL_, 0xE1, 0xB8, 0x81, FIL_, 0x03, 0xCC, 0xB1,
		FIL_, 0xE1, 0xB8, 0x87, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xB8, 0x85, FIL_, 0xCC, 0x87, FIL_, 0xE1,
		0xB8, 0x83, FIL_, 0x05, 0xCC, 0x87, FIL_, 0xC4,
		0x8B, FIL_, 0xCC, 0xA7, FIL_, 0xC3, 0xA7, FIL_,
		0xCC, 0x82, FIL_, 0xC4, 0x89, FIL_, 0xCC, 0x8C,
		FIL_, 0xC4, 0x8D, FIL_, 0xCC, 0x81, FIL_, 0xC4,
		0x87, FIL_, 0x06, 0xCC, 0xAD, FIL_, 0xE1, 0xB8,
		0x93, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB8, 0x8B,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8, 0x8D, FIL_,
		0xCC, 0xB1, FIL_, 0xE1, 0xB8, 0x8F, FIL_, 0xCC,
		0xA7, FIL_, 0xE1, 0xB8, 0x91, FIL_, 0xCC, 0x8C,
		FIL_, 0xC4, 0x8F, FIL_, 0x11, 0xCC, 0xA8, FIL_,
		0xC4, 0x99, FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0x9B,
		FIL_, 0xCC, 0x87, FIL_, 0xC4, 0x97, FIL_, 0xCC,
		0x88, FIL_, 0xC3, 0xAB, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xBA, 0xB9, FIL_, 0xCC, 0xB0, FIL_, 0xE1,
		0xB8, 0x9B, FIL_, 0xCC, 0x84, FIL_, 0xC4, 0x93,
		FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0x99, FIL_,
		0xCC, 0x83, FIL_, 0xE1, 0xBA, 0xBD, FIL_, 0xCC,
		0x86, FIL_, 0xC4, 0x95, FIL_, 0xCC, 0xA7, FIL_,
		0xC8, 0xA9, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA,
		0xBB, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x85, FIL_,
		0xCC, 0x81, FIL_, 0xC3, 0xA9, FIL_, 0xCC, 0x91,
		FIL_, 0xC8, 0x87, FIL_, 0xCC, 0x80, FIL_, 0xC3,
		0xA8, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0xAA, FIL_,
		0x01, 0xCC, 0x87, FIL_, 0xE1, 0xB8, 0x9F, FIL_,
		0x07, 0xCC, 0x86, FIL_, 0xC4, 0x9F, FIL_, 0xCC,
		0xA7, FIL_, 0xC4, 0xA3, FIL_, 0xCC, 0x81, FIL_,
		0xC7, 0xB5, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0x9D,
		FIL_, 0xCC, 0x87, FIL_, 0xC4, 0xA1, FIL_, 0xCC,
		0x8C, FIL_, 0xC7, 0xA7, FIL_, 0xCC, 0x84, FIL_,
		0xE1, 0xB8, 0xA1, FIL_, 0x08, 0xCC, 0x8C, FIL_,
		0xC8, 0x9F, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0xA5,
		FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xB8, 0xA7, FIL_,
		0xCC, 0x87, FIL_, 0xE1, 0xB8, 0xA3, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xBA, 0x96, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xB8, 0xA5, FIL_, 0xCC, 0xA7, FIL_,
		0xE1, 0xB8, 0xA9, FIL_, 0xCC, 0xAE, FIL_, 0xE1,
		0xB8, 0xAB, FIL_, 0x0E, 0xCC, 0x81, FIL_, 0xC3,
		0xAD, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0xAC, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0x8B, FIL_, 0xCC,
		0x8C, FIL_, 0xC7, 0x90, FIL_, 0xCC, 0x89, FIL_,
		0xE1, 0xBB, 0x89, FIL_, 0xCC, 0x91, FIL_, 0xC8,
		0x8B, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x89, FIL_,
		0xCC, 0x82, FIL_, 0xC3, 0xAE, FIL_, 0xCC, 0xB0,
		FIL_, 0xE1, 0xB8, 0xAD, FIL_, 0xCC, 0xA8, FIL_,
		0xC4, 0xAF, FIL_, 0xCC, 0x86, FIL_, 0xC4, 0xAD,
		FIL_, 0xCC, 0x84, FIL_, 0xC4, 0xAB, FIL_, 0xCC,
		0x83, FIL_, 0xC4, 0xA9, FIL_, 0xCC, 0x88, FIL_,
		0xC3, 0xAF, FIL_, 0x02, 0xCC, 0x82, FIL_, 0xC4,
		0xB5, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0xB0, FIL_,
		0x05, 0xCC, 0xA3, FIL_, 0xE1, 0xB8, 0xB3, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xB1, FIL_, 0xCC,
		0xA7, FIL_, 0xC4, 0xB7, FIL_, 0xCC, 0x8C, FIL_,
		0xC7, 0xA9, FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB8,
		0xB5, FIL_, 0x06, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB7, FIL_, 0xCC, 0x81, FIL_, 0xC4, 0xBA, FIL_,
		0xCC, 0xA7, FIL_, 0xC4, 0xBC, FIL_, 0xCC, 0x8C,
		FIL_, 0xC4, 0xBE, FIL_, 0xCC, 0xB1, FIL_, 0xE1,
		0xB8, 0xBB, FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB8,
		0xBD, FIL_, 0x03, 0xCC, 0xA3, FIL_, 0xE1, 0xB9,
		0x83, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xBF,
		FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB9, 0x81, FIL_,
		0x09, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x87, FIL_,
		0xCC, 0x83, FIL_, 0xC3, 0xB1, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0x85, FIL_, 0xCC, 0xB1, FIL_,
		0xE1, 0xB9, 0x89, FIL_, 0xCC, 0x81, FIL_, 0xC5,
		0x84, FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0x86, FIL_,
		0xCC, 0xAD, FIL_, 0xE1, 0xB9, 0x8B, FIL_, 0xCC,
		0x8C, FIL_, 0xC5, 0x88, FIL_, 0xCC, 0x80, FIL_,
		0xC7, 0xB9, FIL_, 0x10, 0xCC, 0x89, FIL_, 0xE1,
		0xBB, 0x8F, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0xB3,
		FIL_, 0xCC, 0x80, FIL_, 0xC3, 0xB2, FIL_, 0xCC,
		0x87, FIL_, 0xC8, 0xAF, FIL_, 0xCC, 0x8F, FIL_,
		0xC8, 0x8D, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB,
		0x8D, FIL_, 0xCC, 0x84, FIL_, 0xC5, 0x8D, FIL_,
		0xCC, 0x8C, FIL_, 0xC7, 0x92, FIL_, 0xCC, 0x86,
		FIL_, 0xC5, 0x8F, FIL_, 0xCC, 0x8B, FIL_, 0xC5,
		0x91, FIL_, 0xCC, 0x9B, FIL_, 0xC6, 0xA1, FIL_,
		0xCC, 0x91, FIL_, 0xC8, 0x8F, FIL_, 0xCC, 0xA8,
		FIL_, 0xC7, 0xAB, FIL_, 0xCC, 0x88, FIL_, 0xC3,
		0xB6, FIL_, 0xCC, 0x83, FIL_, 0xC3, 0xB5, FIL_,
		0xCC, 0x82, FIL_, 0xC3, 0xB4, FIL_, 0x02, 0xCC,
		0x87, FIL_, 0xE1, 0xB9, 0x97, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0x95, FIL_, 0x08, 0xCC, 0xB1,
		FIL_, 0xE1, 0xB9, 0x9F, FIL_, 0xCC, 0x87, FIL_,
		0xE1, 0xB9, 0x99, FIL_, 0xCC, 0x81, FIL_, 0xC5,
		0x95, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x91, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x9B, FIL_, 0xCC,
		0x8C, FIL_, 0xC5, 0x99, FIL_, 0xCC, 0x91, FIL_,
		0xC8, 0x93, FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0x97,
		FIL_, 0x07, 0xCC, 0xA6, FIL_, 0xC8, 0x99, FIL_,
		0xCC, 0x8C, FIL_, 0xC5, 0xA1, FIL_, 0xCC, 0x81,
		FIL_, 0xC5, 0x9B, FIL_, 0xCC, 0x87, FIL_, 0xE1,
		0xB9, 0xA1, FIL_, 0xCC, 0x82, FIL_, 0xC5, 0x9D,
		FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0x9F, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xB9, 0xA3, FIL_, 0x08, 0xCC,
		0x88, FIL_, 0xE1, 0xBA, 0x97, FIL_, 0xCC, 0xAD,
		FIL_, 0xE1, 0xB9, 0xB1, FIL_, 0xCC, 0xB1, FIL_,
		0xE1, 0xB9, 0xAF, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB9, 0xAD, FIL_, 0xCC, 0x8C, FIL_, 0xC5, 0xA5,
		FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0xA3, FIL_, 0xCC,
		0x87, FIL_, 0xE1, 0xB9, 0xAB, FIL_, 0xCC, 0xA6,
		FIL_, 0xC8, 0x9B, FIL_, 0x13, 0xCC, 0x81, FIL_,
		0xC3, 0xBA, FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x97,
		FIL_, 0xCC, 0x83, FIL_, 0xC5, 0xA9, FIL_, 0xCC,
		0x8F, FIL_, 0xC8, 0x95, FIL_, 0xCC, 0xA8, FIL_,
		0xC5, 0xB3, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0xBB,
		FIL_, 0xCC, 0x88, FIL_, 0xC3, 0xBC, FIL_, 0xCC,
		0x80, FIL_, 0xC3, 0xB9, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xBB, 0xA5, FIL_, 0xCC, 0xA4, FIL_, 0xE1,
		0xB9, 0xB3, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB,
		0xA7, FIL_, 0xCC, 0xB0, FIL_, 0xE1, 0xB9, 0xB5,
		FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB9, 0xB7, FIL_,
		0xCC, 0x9B, FIL_, 0xC6, 0xB0, FIL_, 0xCC, 0x84,
		FIL_, 0xC5, 0xAB, FIL_, 0xCC, 0x8B, FIL_, 0xC5,
		0xB1, FIL_, 0xCC, 0x86, FIL_, 0xC5, 0xAD, FIL_,
		0xCC, 0x8C, FIL_, 0xC7, 0x94, FIL_, 0xCC, 0x8A,
		FIL_, 0xC5, 0xAF, FIL_, 0x02, 0xCC, 0x83, FIL_,
		0xE1, 0xB9, 0xBD, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB9, 0xBF, FIL_, 0x07, 0xCC, 0x82, FIL_, 0xC5,
		0xB5, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBA, 0x81,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0x83, FIL_,
		0xCC, 0x88, FIL_, 0xE1, 0xBA, 0x85, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBA, 0x89, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xBA, 0x87, FIL_, 0xCC, 0x8A, FIL_,
		0xE1, 0xBA, 0x98, FIL_, 0x02, 0xCC, 0x87, FIL_,
		0xE1, 0xBA, 0x8B, FIL_, 0xCC, 0x88, FIL_, 0xE1,
		0xBA, 0x8D, FIL_, 0x0A, 0xCC, 0x87, FIL_, 0xE1,
		0xBA, 0x8F, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB,
		0xB9, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBB, 0xB3,
		FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0xB7, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xB5, FIL_, 0xCC,
		0x82, FIL_, 0xC5, 0xB7, FIL_, 0xCC, 0x84, FIL_,
		0xC8, 0xB3, FIL_, 0xCC, 0x8A, FIL_, 0xE1, 0xBA,
		0x99, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0xBF, FIL_,
		0xCC, 0x81, FIL_, 0xC3, 0xBD, FIL_, 0x06, 0xCC,
		0x8C, FIL_, 0xC5, 0xBE, FIL_, 0xCC, 0x87, FIL_,
		0xC5, 0xBC, FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xBA,
		0x95, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0x93,
		FIL_, 0xCC, 0x81, FIL_, 0xC5, 0xBA, FIL_, 0xCC,
		0x82, FIL_, 0xE1, 0xBA, 0x91, FIL_, 0x03, 0xCC,
		0x80, FIL_, 0xE1, 0xBF, 0xAD, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x81, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x85, FIL_, 0x04, 0xCC, 0x89, FIL_, 0xE1,
		0xBA, 0xA8, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBA,
		0xAA, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xA4,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBA, 0xA6, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC7, 0x9E, FIL_, 0x01,
		0xCC, 0x81, FIL_, 0xC7, 0xBA, FIL_, 0x02, 0xCC,
		0x84, FIL_, 0xC7, 0xA2, FIL_, 0xCC, 0x81, FIL_,
		0xC7, 0xBC, FIL_, 0x01, 0xCC, 0x81, FIL_, 0xE1,
		0xB8, 0x88, FIL_, 0x04, 0xCC, 0x81, FIL_, 0xE1,
		0xBA, 0xBE, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBB,
		0x80, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0x84,
		FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x82, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xAE, FIL_,
		0x04, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0x96, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBB, 0x90, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBB, 0x92, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0x94, FIL_, 0x03, 0xCC, 0x84,
		FIL_, 0xC8, 0xAC, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xB9, 0x8C, FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xB9,
		0x8E, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC8, 0xAA,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xC7, 0xBE, FIL_,
		0x04, 0xCC, 0x80, FIL_, 0xC7, 0x9B, FIL_, 0xCC,
		0x84, FIL_, 0xC7, 0x95, FIL_, 0xCC, 0x8C, FIL_,
		0xC7, 0x99, FIL_, 0xCC, 0x81, FIL_, 0xC7, 0x97,
		FIL_, 0x04, 0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xA9,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBA, 0xA7, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xA5, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBA, 0xAB, FIL_, 0x01, 0xCC,
		0x84, FIL_, 0xC7, 0x9F, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xC7, 0xBB, FIL_, 0x02, 0xCC, 0x84, FIL_,
		0xC7, 0xA3, FIL_, 0xCC, 0x81, FIL_, 0xC7, 0xBD,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x89,
		FIL_, 0x04, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x83,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xBF, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBB, 0x81, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBB, 0x85, FIL_, 0x01, 0xCC,
		0x81, FIL_, 0xE1, 0xB8, 0xAF, FIL_, 0x04, 0xCC,
		0x83, FIL_, 0xE1, 0xBB, 0x97, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0x95, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBB, 0x93, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBB, 0x91, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1,
		0xB9, 0x8D, FIL_, 0xCC, 0x84, FIL_, 0xC8, 0xAD,
		FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xB9, 0x8F, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC8, 0xAB, FIL_, 0x01,
		0xCC, 0x81, FIL_, 0xC7, 0xBF, FIL_, 0x04, 0xCC,
		0x81, FIL_, 0xC7, 0x98, FIL_, 0xCC, 0x84, FIL_,
		0xC7, 0x96, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x9A,
		FIL_, 0xCC, 0x80, FIL_, 0xC7, 0x9C, FIL_, 0x04,
		0xCC, 0x80, FIL_, 0xE1, 0xBA, 0xB0, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBA, 0xAE, FIL_, 0xCC, 0x83,
		FIL_, 0xE1, 0xBA, 0xB4, FIL_, 0xCC, 0x89, FIL_,
		0xE1, 0xBA, 0xB2, FIL_, 0x04, 0xCC, 0x80, FIL_,
		0xE1, 0xBA, 0xB1, FIL_, 0xCC, 0x83, FIL_, 0xE1,
		0xBA, 0xB5, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA,
		0xAF, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xB3,
		FIL_, 0x02, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x96,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xB8, 0x94, FIL_,
		0x02, 0xCC, 0x80, FIL_, 0xE1, 0xB8, 0x95, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x97, FIL_, 0x02,
		0xCC, 0x80, FIL_, 0xE1, 0xB9, 0x90, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xB9, 0x92, FIL_, 0x02, 0xCC,
		0x80, FIL_, 0xE1, 0xB9, 0x91, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0x93, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA4, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA5, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA6, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA7, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0xB8, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0xB9, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xE1, 0xB9, 0xBA, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xE1, 0xB9, 0xBB, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xBA, 0x9B, FIL_, 0x05, 0xCC, 0x80,
		FIL_, 0xE1, 0xBB, 0x9C, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBB, 0x9A, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xBB, 0xA2, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB,
		0xA0, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x9E,
		FIL_, 0x05, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0xA1,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBB, 0x9B, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xA3, FIL_, 0xCC,
		0x89, FIL_, 0xE1, 0xBB, 0x9F, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBB, 0x9D, FIL_, 0x05, 0xCC, 0x83,
		FIL_, 0xE1, 0xBB, 0xAE, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xBB, 0xB0, FIL_, 0xCC, 0x89, FIL_, 0xE1,
		0xBB, 0xAC, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBB,
		0xA8, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBB, 0xAA,
		FIL_, 0x05, 0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xB1,
		FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0xAF, FIL_,
		0xCC, 0x89, FIL_, 0xE1, 0xBB, 0xAD, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBB, 0xA9, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBB, 0xAB, FIL_, 0x01, 0xCC, 0x8C,
		FIL_, 0xC7, 0xAE, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xC7, 0xAC, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7,
		0xAD, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7, 0xA0,
		FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7, 0xA1, FIL_,
		0x01, 0xCC, 0x86, FIL_, 0xE1, 0xB8, 0x9C, FIL_,
		0x01, 0xCC, 0x86, FIL_, 0xE1, 0xB8, 0x9D, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC8, 0xB0, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xC8, 0xB1, FIL_, 0x01, 0xCC,
		0x8C, FIL_, 0xC7, 0xAF, FIL_, 0x07, 0xCC, 0x93,
		FIL_, 0xE1, 0xBC, 0x88, FIL_, 0xCC, 0x94, FIL_,
		0xE1, 0xBC, 0x89, FIL_, 0xCC, 0x81, FIL_, 0xCE,
		0x86, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xBC,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBE, 0xBA, FIL_,
		0xCC, 0x84, FIL_, 0xE1, 0xBE, 0xB9, FIL_, 0xCC,
		0x86, FIL_, 0xE1, 0xBE, 0xB8, FIL_, 0x04, 0xCC,
		0x81, FIL_, 0xCE, 0x88, FIL_, 0xCC, 0x94, FIL_,
		0xE1, 0xBC, 0x99, FIL_, 0xCC, 0x93, FIL_, 0xE1,
		0xBC, 0x98, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF,
		0x88, FIL_, 0x05, 0xCC, 0x94, FIL_, 0xE1, 0xBC,
		0xA9, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF, 0x8A,
		FIL_, 0xCC, 0x81, FIL_, 0xCE, 0x89, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBF, 0x8C, FIL_, 0xCC, 0x93,
		FIL_, 0xE1, 0xBC, 0xA8, FIL_, 0x07, 0xCC, 0x81,
		FIL_, 0xCE, 0x8A, FIL_, 0xCC, 0x88, FIL_, 0xCE,
		0xAA, FIL_, 0xCC, 0x86, FIL_, 0xE1, 0xBF, 0x98,
		FIL_, 0xCC, 0x84, FIL_, 0xE1, 0xBF, 0x99, FIL_,
		0xCC, 0x93, FIL_, 0xE1, 0xBC, 0xB8, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBC, 0xB9, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBF, 0x9A, FIL_, 0x04, 0xCC, 0x94,
		FIL_, 0xE1, 0xBD, 0x89, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBF, 0xB8, FIL_, 0xCC, 0x81, FIL_, 0xCE,
		0x8C, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBD, 0x88,
		FIL_, 0x01, 0xCC, 0x94, FIL_, 0xE1, 0xBF, 0xAC,
		FIL_, 0x06, 0xCC, 0x81, FIL_, 0xCE, 0x8E, FIL_,
		0xCC, 0x86, FIL_, 0xE1, 0xBF, 0xA8, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBD, 0x99, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBF, 0xAA, FIL_, 0xCC, 0x84, FIL_,
		0xE1, 0xBF, 0xA9, FIL_, 0xCC, 0x88, FIL_, 0xCE,
		0xAB, FIL_, 0x05, 0xCC, 0x80, FIL_, 0xE1, 0xBF,
		0xBA, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0x8F, FIL_,
		0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xBC, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBD, 0xA9, FIL_, 0xCC, 0x93,
		FIL_, 0xE1, 0xBD, 0xA8, FIL_, 0x01, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0xB4, FIL_, 0x01, 0xCD, 0x85,
		FIL_, 0xE1, 0xBF, 0x84, FIL_, 0x08, 0xCC, 0x81,
		FIL_, 0xCE, 0xAC, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBD, 0xB0, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBC,
		0x80, FIL_, 0xCC, 0x94, FIL_, 0xE1, 0xBC, 0x81,
		FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBE, 0xB6, FIL_,
		0xCC, 0x86, FIL_, 0xE1, 0xBE, 0xB0, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xB3, FIL_, 0xCC, 0x84,
		FIL_, 0xE1, 0xBE, 0xB1, FIL_, 0x04, 0xCC, 0x81,
		FIL_, 0xCE, 0xAD, FIL_, 0xCC, 0x94, FIL_, 0xE1,
		0xBC, 0x91, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD,
		0xB2, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBC, 0x90,
		FIL_, 0x06, 0xCC, 0x81, FIL_, 0xCE, 0xAE, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xB4, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBF, 0x83, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x86, FIL_, 0xCC, 0x94, FIL_,
		0xE1, 0xBC, 0xA1, FIL_, 0xCC, 0x93, FIL_, 0xE1,
		0xBC, 0xA0, FIL_, 0x08, 0xCD, 0x82, FIL_, 0xE1,
		0xBF, 0x96, FIL_, 0xCC, 0x86, FIL_, 0xE1, 0xBF,
		0x90, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBC, 0xB0,
		FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xAF, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBC, 0xB1, FIL_, 0xCC, 0x84,
		FIL_, 0xE1, 0xBF, 0x91, FIL_, 0xCC, 0x88, FIL_,
		0xCF, 0x8A, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD,
		0xB6, FIL_, 0x04, 0xCC, 0x81, FIL_, 0xCF, 0x8C,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xB8, FIL_,
		0xCC, 0x93, FIL_, 0xE1, 0xBD, 0x80, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBD, 0x81, FIL_, 0x02, 0xCC,
		0x93, FIL_, 0xE1, 0xBF, 0xA4, FIL_, 0xCC, 0x94,
		FIL_, 0xE1, 0xBF, 0xA5, FIL_, 0x08, 0xCC, 0x93,
		FIL_, 0xE1, 0xBD, 0x90, FIL_, 0xCC, 0x94, FIL_,
		0xE1, 0xBD, 0x91, FIL_, 0xCC, 0x86, FIL_, 0xE1,
		0xBF, 0xA0, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF,
		0xA6, FIL_, 0xCC, 0x84, FIL_, 0xE1, 0xBF, 0xA1,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xBA, FIL_,
		0xCC, 0x81, FIL_, 0xCF, 0x8D, FIL_, 0xCC, 0x88,
		FIL_, 0xCF, 0x8B, FIL_, 0x06, 0xCC, 0x94, FIL_,
		0xE1, 0xBD, 0xA1, FIL_, 0xCD, 0x85, FIL_, 0xE1,
		0xBF, 0xB3, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD,
		0xBC, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF, 0xB6,
		FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBD, 0xA0, FIL_,
		0xCC, 0x81, FIL_, 0xCF, 0x8E, FIL_, 0x03, 0xCD,
		0x82, FIL_, 0xE1, 0xBF, 0x97, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBF, 0x92, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x90, FIL_, 0x03, 0xCC, 0x80, FIL_, 0xE1,
		0xBF, 0xA2, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xB0,
		FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF, 0xA7, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xB4, FIL_,
		0x02, 0xCC, 0x88, FIL_, 0xCF, 0x94, FIL_, 0xCC,
		0x81, FIL_, 0xCF, 0x93, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD0, 0x87, FIL_, 0x02, 0xCC, 0x86, FIL_,
		0xD3, 0x90, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0x92,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xD0, 0x83, FIL_,
		0x03, 0xCC, 0x86, FIL_, 0xD3, 0x96, FIL_, 0xCC,
		0x80, FIL_, 0xD0, 0x80, FIL_, 0xCC, 0x88, FIL_,
		0xD0, 0x81, FIL_, 0x02, 0xCC, 0x88, FIL_, 0xD3,
		0x9C, FIL_, 0xCC, 0x86, FIL_, 0xD3, 0x81, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9E, FIL_, 0x04,
		0xCC, 0x80, FIL_, 0xD0, 0x8D, FIL_, 0xCC, 0x88,
		FIL_, 0xD3, 0xA4, FIL_, 0xCC, 0x86, FIL_, 0xD0,
		0x99, FIL_, 0xCC, 0x84, FIL_, 0xD3, 0xA2, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xD0, 0x8C, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xA6, FIL_, 0x04, 0xCC,
		0x86, FIL_, 0xD0, 0x8E, FIL_, 0xCC, 0x8B, FIL_,
		0xD3, 0xB2, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0xB0,
		FIL_, 0xCC, 0x84, FIL_, 0xD3, 0xAE, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xB4, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xB8, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD3, 0xAC, FIL_, 0x02, 0xCC, 0x86, FIL_,
		0xD3, 0x91, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0x93,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xD1, 0x93, FIL_,
		0x03, 0xCC, 0x80, FIL_, 0xD1, 0x90, FIL_, 0xCC,
		0x88, FIL_, 0xD1, 0x91, FIL_, 0xCC, 0x86, FIL_,
		0xD3, 0x97, FIL_, 0x02, 0xCC, 0x88, FIL_, 0xD3,
		0x9D, FIL_, 0xCC, 0x86, FIL_, 0xD3, 0x82, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9F, FIL_, 0x04,
		0xCC, 0x88, FIL_, 0xD3, 0xA5, FIL_, 0xCC, 0x86,
		FIL_, 0xD0, 0xB9, FIL_, 0xCC, 0x80, FIL_, 0xD1,
		0x9D, FIL_, 0xCC, 0x84, FIL_, 0xD3, 0xA3, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xD1, 0x9C, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xA7, FIL_, 0x04, 0xCC,
		0x84, FIL_, 0xD3, 0xAF, FIL_, 0xCC, 0x86, FIL_,
		0xD1, 0x9E, FIL_, 0xCC, 0x8B, FIL_, 0xD3, 0xB3,
		FIL_, 0xCC, 0x88, FIL_, 0xD3, 0xB1, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xB5, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xB9, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD3, 0xAD, FIL_, 0x01, 0xCC, 0x88, FIL_,
		0xD1, 0x97, FIL_, 0x01, 0xCC, 0x8F, FIL_, 0xD1,
		0xB6, FIL_, 0x01, 0xCC, 0x8F, FIL_, 0xD1, 0xB7,
		FIL_, 0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9A, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9B, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xAA, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xAB, FIL_, 0x03, 0xD9, 0x94,
		FIL_, 0xD8, 0xA3, FIL_, 0xD9, 0x93, FIL_, 0xD8,
		0xA2, FIL_, 0xD9, 0x95, FIL_, 0xD8, 0xA5, FIL_,
		0x01, 0xD9, 0x94, FIL_, 0xD8, 0xA4, FIL_, 0x01,
		0xD9, 0x94, FIL_, 0xD8, 0xA6, FIL_, 0x01, 0xD9,
		0x94, FIL_, 0xDB, 0x82, FIL_, 0x01, 0xD9, 0x94,
		FIL_, 0xDB, 0x93, FIL_, 0x01, 0xD9, 0x94, FIL_,
		0xDB, 0x80, FIL_, 0x01, 0xE0, 0xA4, 0xBC, FIL_,
		0xE0, 0xA4, 0xA9, FIL_, 0x01, 0xE0, 0xA4, 0xBC,
		FIL_, 0xE0, 0xA4, 0xB1, FIL_, 0x01, 0xE0, 0xA4,
		0xBC, FIL_, 0xE0, 0xA4, 0xB4, FIL_, 0x02, 0xE0,
		0xA6, 0xBE, FIL_, 0xE0, 0xA7, 0x8B, FIL_, 0xE0,
		0xA7, 0x97, FIL_, 0xE0, 0xA7, 0x8C, FIL_, 0x03,
		0xE0, 0xAD, 0x97, FIL_, 0xE0, 0xAD, 0x8C, FIL_,
		0xE0, 0xAC, 0xBE, FIL_, 0xE0, 0xAD, 0x8B, FIL_,
		0xE0, 0xAD, 0x96, FIL_, 0xE0, 0xAD, 0x88, FIL_,
		0x01, 0xE0, 0xAF, 0x97, FIL_, 0xE0, 0xAE, 0x94,
		FIL_, 0x02, 0xE0, 0xAE, 0xBE, FIL_, 0xE0, 0xAF,
		0x8A, FIL_, 0xE0, 0xAF, 0x97, FIL_, 0xE0, 0xAF,
		0x8C, FIL_, 0x01, 0xE0, 0xAE, 0xBE, FIL_, 0xE0,
		0xAF, 0x8B, FIL_, 0x01, 0xE0, 0xB1, 0x96, FIL_,
		0xE0, 0xB1, 0x88, FIL_, 0x01, 0xE0, 0xB3, 0x95,
		FIL_, 0xE0, 0xB3, 0x80, FIL_, 0x03, 0xE0, 0xB3,
		0x95, FIL_, 0xE0, 0xB3, 0x87, FIL_, 0xE0, 0xB3,
		0x82, FIL_, 0xE0, 0xB3, 0x8A, FIL_, 0xE0, 0xB3,
		0x96, FIL_, 0xE0, 0xB3, 0x88, FIL_, 0x01, 0xE0,
		0xB3, 0x95, FIL_, 0xE0, 0xB3, 0x8B, FIL_, 0x02,
		0xE0, 0xB4, 0xBE, FIL_, 0xE0, 0xB5, 0x8A, FIL_,
		0xE0, 0xB5, 0x97, FIL_, 0xE0, 0xB5, 0x8C, FIL_,
		0x01, 0xE0, 0xB4, 0xBE, FIL_, 0xE0, 0xB5, 0x8B,
		FIL_, 0x03, 0xE0, 0xB7, 0x8F, FIL_, 0xE0, 0xB7,
		0x9C, FIL_, 0xE0, 0xB7, 0x8A, FIL_, 0xE0, 0xB7,
		0x9A, FIL_, 0xE0, 0xB7, 0x9F, FIL_, 0xE0, 0xB7,
		0x9E, FIL_, 0x01, 0xE0, 0xB7, 0x8A, FIL_, 0xE0,
		0xB7, 0x9D, FIL_, 0x01, 0xE1, 0x80, 0xAE, FIL_,
		0xE1, 0x80, 0xA6, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xE1, 0xB8, 0xB8, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xE1, 0xB8, 0xB9, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xE1, 0xB9, 0x9C, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xE1, 0xB9, 0x9D, FIL_, 0x01, 0xCC, 0x87, FIL_,
		0xE1, 0xB9, 0xA8, FIL_, 0x01, 0xCC, 0x87, FIL_,
		0xE1, 0xB9, 0xA9, FIL_, 0x02, 0xCC, 0x86, FIL_,
		0xE1, 0xBA, 0xB6, FIL_, 0xCC, 0x82, FIL_, 0xE1,
		0xBA, 0xAC, FIL_, 0x02, 0xCC, 0x86, FIL_, 0xE1,
		0xBA, 0xB7, FIL_, 0xCC, 0x82, FIL_, 0xE1, 0xBA,
		0xAD, FIL_, 0x01, 0xCC, 0x82, FIL_, 0xE1, 0xBB,
		0x86, FIL_, 0x01, 0xCC, 0x82, FIL_, 0xE1, 0xBB,
		0x87, FIL_, 0x01, 0xCC, 0x82, FIL_, 0xE1, 0xBB,
		0x98, FIL_, 0x01, 0xCC, 0x82, FIL_, 0xE1, 0xBB,
		0x99, FIL_, 0x04, 0xCC, 0x80, FIL_, 0xE1, 0xBC,
		0x82, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x84,
		FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x80, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBC, 0x86, FIL_, 0x04,
		0xCD, 0x82, FIL_, 0xE1, 0xBC, 0x87, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0x83, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBC, 0x85, FIL_, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x81, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x82, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x83, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x84, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x85, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x86, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x87, FIL_, 0x04, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x88, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBC, 0x8A, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBC,
		0x8E, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x8C,
		FIL_, 0x04, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x8D,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0x8B, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBC, 0x8F, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x89, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8A, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8B, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8C, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8D, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8E, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x8F, FIL_, 0x02, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0x92, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBC, 0x94, FIL_, 0x02, 0xCC, 0x80,
		FIL_, 0xE1, 0xBC, 0x93, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBC, 0x95, FIL_, 0x02, 0xCC, 0x80, FIL_,
		0xE1, 0xBC, 0x9A, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBC, 0x9C, FIL_, 0x02, 0xCC, 0x80, FIL_, 0xE1,
		0xBC, 0x9B, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC,
		0x9D, FIL_, 0x04, 0xCD, 0x82, FIL_, 0xE1, 0xBC,
		0xA6, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x90,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xA4, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xA2, FIL_, 0x04,
		0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xA3, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBC, 0xA5, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBC, 0xA7, FIL_, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x91, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x92, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x93, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x94, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x95, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x96, FIL_, 0x01, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0x97, FIL_, 0x04, 0xCD, 0x82, FIL_,
		0xE1, 0xBC, 0xAE, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBC, 0xAC, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE,
		0x98, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xAA,
		FIL_, 0x04, 0xCD, 0x82, FIL_, 0xE1, 0xBC, 0xAF,
		FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x99, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xAD, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0xAB, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9A, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9B, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9C, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9D, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9E, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0x9F, FIL_, 0x03, 0xCC,
		0x81, FIL_, 0xE1, 0xBC, 0xB4, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBC, 0xB6, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBC, 0xB2, FIL_, 0x03, 0xCC, 0x81, FIL_,
		0xE1, 0xBC, 0xB5, FIL_, 0xCD, 0x82, FIL_, 0xE1,
		0xBC, 0xB7, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC,
		0xB3, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1, 0xBC,
		0xBC, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xBA,
		FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBC, 0xBE, FIL_,
		0x03, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xBB, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBC, 0xBF, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBC, 0xBD, FIL_, 0x02, 0xCC,
		0x80, FIL_, 0xE1, 0xBD, 0x82, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBD, 0x84, FIL_, 0x02, 0xCC, 0x80,
		FIL_, 0xE1, 0xBD, 0x83, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBD, 0x85, FIL_, 0x02, 0xCC, 0x81, FIL_,
		0xE1, 0xBD, 0x8C, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBD, 0x8A, FIL_, 0x02, 0xCC, 0x81, FIL_, 0xE1,
		0xBD, 0x8D, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD,
		0x8B, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1, 0xBD,
		0x94, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBD, 0x96,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0x92, FIL_,
		0x03, 0xCD, 0x82, FIL_, 0xE1, 0xBD, 0x97, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBD, 0x95, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBD, 0x93, FIL_, 0x03, 0xCC,
		0x81, FIL_, 0xE1, 0xBD, 0x9D, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBD, 0x9F, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBD, 0x9B, FIL_, 0x04, 0xCC, 0x81, FIL_,
		0xE1, 0xBD, 0xA4, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBD, 0xA2, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBD,
		0xA6, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA0,
		FIL_, 0x04, 0xCD, 0x82, FIL_, 0xE1, 0xBD, 0xA7,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBD, 0xA5, FIL_,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA1, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBD, 0xA3, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA2, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA3, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA4, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA5, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA6, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA7, FIL_, 0x04, 0xCC,
		0x81, FIL_, 0xE1, 0xBD, 0xAC, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBD, 0xAA, FIL_, 0xCD, 0x82, FIL_,
		0xE1, 0xBD, 0xAE, FIL_, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xA8, FIL_, 0x04, 0xCC, 0x81, FIL_, 0xE1,
		0xBD, 0xAD, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE,
		0xA9, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBD, 0xAF,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xAB, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAA, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAB, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAC, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAD, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAE, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xAF, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xB2, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0x82, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xB2, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xB7, FIL_,
		0x03, 0xCD, 0x82, FIL_, 0xE1, 0xBF, 0x8F, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBF, 0x8D, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBF, 0x8E, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBF, 0x87, FIL_, 0x01, 0xCD,
		0x85, FIL_, 0xE1, 0xBF, 0xB7, FIL_, 0x03, 0xCC,
		0x80, FIL_, 0xE1, 0xBF, 0x9D, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x9F, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBF, 0x9E, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x86, 0x9A, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x86, 0x9B, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x86, 0xAE, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x87, 0x8D, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x87, 0x8F, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x87, 0x8E, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x88, 0x84, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x88, 0x89, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x88, 0x8C, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x88, 0xA4, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x88, 0xA6, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0x81, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0x84, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0x87, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0x89, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xAD, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xA2, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB0, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB1, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB4, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB5, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB8, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x89, 0xB9, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x80, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x81, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xA0, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xA1, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x84, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x85, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x88, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0x89, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xA2, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xA3, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0xAC, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0xAD, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0xAE, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8A, 0xAF, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xAA, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xAB, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xAC, FIL_, 0x01, 0xCC, 0xB8, FIL_,
		0xE2, 0x8B, 0xAD, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x82, 0x94, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x81, 0x8C, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x81, 0x8E, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0x90, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0x92,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81,
		0x94, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x81, 0x96, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x81, 0x98, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x81, 0x9A, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x81, 0x9C, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x81, 0x9E, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xA0, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xA2,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81,
		0xA5, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x81, 0xA7, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x81, 0xA9, FIL_, 0x02, 0xE3, 0x82, 0x9A,
		FIL_, 0xE3, 0x81, 0xB1, FIL_, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x81, 0xB0, FIL_, 0x02, 0xE3, 0x82,
		0x9A, FIL_, 0xE3, 0x81, 0xB4, FIL_, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x81, 0xB3, FIL_, 0x02, 0xE3,
		0x82, 0x9A, FIL_, 0xE3, 0x81, 0xB7, FIL_, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x81, 0xB6, FIL_, 0x02,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xB9, FIL_,
		0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x81, 0xBA, FIL_,
		0x02, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xBC,
		FIL_, 0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x81, 0xBD,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82,
		0x9E, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x83, 0xB4, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x82, 0xAC, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x82, 0xAE, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x82, 0xB0, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x82, 0xB2, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0xB4, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0xB6,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82,
		0xB8, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x82, 0xBA, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x82, 0xBC, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x82, 0xBE, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x83, 0x80, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x83, 0x82, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0x85, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0x87,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83,
		0x89, FIL_, 0x02, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x83, 0x90, FIL_, 0xE3, 0x82, 0x9A, FIL_, 0xE3,
		0x83, 0x91, FIL_, 0x02, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x83, 0x93, FIL_, 0xE3, 0x82, 0x9A, FIL_,
		0xE3, 0x83, 0x94, FIL_, 0x02, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x83, 0x96, FIL_, 0xE3, 0x82, 0x9A,
		FIL_, 0xE3, 0x83, 0x97, FIL_, 0x02, 0xE3, 0x82,
		0x9A, FIL_, 0xE3, 0x83, 0x9A, FIL_, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x83, 0x99, FIL_, 0x02, 0xE3,
		0x82, 0x9A, FIL_, 0xE3, 0x83, 0x9D, FIL_, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x83, 0x9C, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0xB7, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0xB8,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83,
		0xB9, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x83, 0xBA, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x83, 0xBE, FIL_, 0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,    0,
		0,    0,    0,    0,    0,    0,    0,
	},
	{
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xAE, FIL_,
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xA0, FIL_,
		0x01, 0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xAF, FIL_,
		0x10, 0xCC, 0xA5, FIL_, 0xE1, 0xB8, 0x80, FIL_,
		0xCC, 0x87, FIL_, 0xC8, 0xA6, FIL_, 0xCC, 0x83,
		FIL_, 0xC3, 0x83, FIL_, 0xCC, 0x91, FIL_, 0xC8,
		0x82, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x80, FIL_,
		0xCC, 0x8A, FIL_, 0xC3, 0x85, FIL_, 0xCC, 0x88,
		FIL_, 0xC3, 0x84, FIL_, 0xCC, 0x89, FIL_, 0xE1,
		0xBA, 0xA2, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA,
		0xA0, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x8D, FIL_,
		0xCC, 0x80, FIL_, 0xC3, 0x80, FIL_, 0xCC, 0x81,
		FIL_, 0xC3, 0x81, FIL_, 0xCC, 0x82, FIL_, 0xC3,
		0x82, FIL_, 0xCC, 0xA8, FIL_, 0xC4, 0x84, FIL_,
		0xCC, 0x86, FIL_, 0xC4, 0x82, FIL_, 0xCC, 0x84,
		FIL_, 0xC4, 0x80, FIL_, 0x03, 0xCC, 0xB1, FIL_,
		0xE1, 0xB8, 0x86, FIL_, 0xCC, 0x87, FIL_, 0xE1,
		0xB8, 0x82, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0x84, FIL_, 0x05, 0xCC, 0xA7, FIL_, 0xC3, 0x87,
		FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0x8C, FIL_, 0xCC,
		0x81, FIL_, 0xC4, 0x86, FIL_, 0xCC, 0x82, FIL_,
		0xC4, 0x88, FIL_, 0xCC, 0x87, FIL_, 0xC4, 0x8A,
		FIL_, 0x06, 0xCC, 0xA7, FIL_, 0xE1, 0xB8, 0x90,
		FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0x8E, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB8, 0x8E, FIL_, 0xCC, 0xAD,
		FIL_, 0xE1, 0xB8, 0x92, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xB8, 0x8C, FIL_, 0xCC, 0x87, FIL_, 0xE1,
		0xB8, 0x8A, FIL_, 0x11, 0xCC, 0x84, FIL_, 0xC4,
		0x92, FIL_, 0xCC, 0x86, FIL_, 0xC4, 0x94, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0xB8, FIL_, 0xCC,
		0x91, FIL_, 0xC8, 0x86, FIL_, 0xCC, 0x82, FIL_,
		0xC3, 0x8A, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x84,
		FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0x98, FIL_,
		0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xBA, FIL_, 0xCC,
		0xA7, FIL_, 0xC8, 0xA8, FIL_, 0xCC, 0x8C, FIL_,
		0xC4, 0x9A, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0x88,
		FIL_, 0xCC, 0xA8, FIL_, 0xC4, 0x98, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBA, 0xBC, FIL_, 0xCC, 0x87,
		FIL_, 0xC4, 0x96, FIL_, 0xCC, 0x81, FIL_, 0xC3,
		0x89, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0x8B, FIL_,
		0xCC, 0xB0, FIL_, 0xE1, 0xB8, 0x9A, FIL_, 0x01,
		0xCC, 0x87, FIL_, 0xE1, 0xB8, 0x9E, FIL_, 0x07,
		0xCC, 0x8C, FIL_, 0xC7, 0xA6, FIL_, 0xCC, 0x86,
		FIL_, 0xC4, 0x9E, FIL_, 0xCC, 0x82, FIL_, 0xC4,
		0x9C, FIL_, 0xCC, 0xA7, FIL_, 0xC4, 0xA2, FIL_,
		0xCC, 0x84, FIL_, 0xE1, 0xB8, 0xA0, FIL_, 0xCC,
		0x81, FIL_, 0xC7, 0xB4, FIL_, 0xCC, 0x87, FIL_,
		0xC4, 0xA0, FIL_, 0x07, 0xCC, 0x87, FIL_, 0xE1,
		0xB8, 0xA2, FIL_, 0xCC, 0xA7, FIL_, 0xE1, 0xB8,
		0xA8, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0xA4, FIL_,
		0xCC, 0x88, FIL_, 0xE1, 0xB8, 0xA6, FIL_, 0xCC,
		0x8C, FIL_, 0xC8, 0x9E, FIL_, 0xCC, 0xAE, FIL_,
		0xE1, 0xB8, 0xAA, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB8, 0xA4, FIL_, 0x0F, 0xCC, 0xB0, FIL_, 0xE1,
		0xB8, 0xAC, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x8F,
		FIL_, 0xCC, 0x80, FIL_, 0xC3, 0x8C, FIL_, 0xCC,
		0x89, FIL_, 0xE1, 0xBB, 0x88, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xBB, 0x8A, FIL_, 0xCC, 0x91, FIL_,
		0xC8, 0x8A, FIL_, 0xCC, 0x88, FIL_, 0xC3, 0x8F,
		FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x8E, FIL_, 0xCC,
		0x81, FIL_, 0xC3, 0x8D, FIL_, 0xCC, 0x83, FIL_,
		0xC4, 0xA8, FIL_, 0xCC, 0x87, FIL_, 0xC4, 0xB0,
		FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x88, FIL_, 0xCC,
		0xA8, FIL_, 0xC4, 0xAE, FIL_, 0xCC, 0x86, FIL_,
		0xC4, 0xAC, FIL_, 0xCC, 0x84, FIL_, 0xC4, 0xAA,
		FIL_, 0x01, 0xCC, 0x82, FIL_, 0xC4, 0xB4, FIL_,
		0x05, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xB0, FIL_,
		0xCC, 0x8C, FIL_, 0xC7, 0xA8, FIL_, 0xCC, 0xB1,
		FIL_, 0xE1, 0xB8, 0xB4, FIL_, 0xCC, 0xA7, FIL_,
		0xC4, 0xB6, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB2, FIL_, 0x06, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB6, FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0xBD, FIL_,
		0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0xBC, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB8, 0xBA, FIL_, 0xCC, 0xA7,
		FIL_, 0xC4, 0xBB, FIL_, 0xCC, 0x81, FIL_, 0xC4,
		0xB9, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1, 0xB8,
		0xBE, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB9, 0x80,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x82, FIL_,
		0x09, 0xCC, 0x83, FIL_, 0xC3, 0x91, FIL_, 0xCC,
		0x81, FIL_, 0xC5, 0x83, FIL_, 0xCC, 0xA7, FIL_,
		0xC5, 0x85, FIL_, 0xCC, 0x8C, FIL_, 0xC5, 0x87,
		FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB9, 0x84, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x86, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB9, 0x88, FIL_, 0xCC, 0xAD,
		FIL_, 0xE1, 0xB9, 0x8A, FIL_, 0xCC, 0x80, FIL_,
		0xC7, 0xB8, FIL_, 0x10, 0xCC, 0x89, FIL_, 0xE1,
		0xBB, 0x8E, FIL_, 0xCC, 0x84, FIL_, 0xC5, 0x8C,
		FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x94, FIL_, 0xCC,
		0x86, FIL_, 0xC5, 0x8E, FIL_, 0xCC, 0x83, FIL_,
		0xC3, 0x95, FIL_, 0xCC, 0x8B, FIL_, 0xC5, 0x90,
		FIL_, 0xCC, 0x88, FIL_, 0xC3, 0x96, FIL_, 0xCC,
		0x9B, FIL_, 0xC6, 0xA0, FIL_, 0xCC, 0x91, FIL_,
		0xC8, 0x8E, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x91,
		FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x8C, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBB, 0x8C, FIL_, 0xCC, 0x80,
		FIL_, 0xC3, 0x92, FIL_, 0xCC, 0xA8, FIL_, 0xC7,
		0xAA, FIL_, 0xCC, 0x87, FIL_, 0xC8, 0xAE, FIL_,
		0xCC, 0x81, FIL_, 0xC3, 0x93, FIL_, 0x02, 0xCC,
		0x87, FIL_, 0xE1, 0xB9, 0x96, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0x94, FIL_, 0x08, 0xCC, 0xA7,
		FIL_, 0xC5, 0x96, FIL_, 0xCC, 0x8C, FIL_, 0xC5,
		0x98, FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x92, FIL_,
		0xCC, 0x8F, FIL_, 0xC8, 0x90, FIL_, 0xCC, 0x81,
		FIL_, 0xC5, 0x94, FIL_, 0xCC, 0x87, FIL_, 0xE1,
		0xB9, 0x98, FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB9,
		0x9E, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x9A,
		FIL_, 0x07, 0xCC, 0xA6, FIL_, 0xC8, 0x98, FIL_,
		0xCC, 0x81, FIL_, 0xC5, 0x9A, FIL_, 0xCC, 0x82,
		FIL_, 0xC5, 0x9C, FIL_, 0xCC, 0xA7, FIL_, 0xC5,
		0x9E, FIL_, 0xCC, 0x8C, FIL_, 0xC5, 0xA0, FIL_,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xA0, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xB9, 0xA2, FIL_, 0x07, 0xCC,
		0xA6, FIL_, 0xC8, 0x9A, FIL_, 0xCC, 0x87, FIL_,
		0xE1, 0xB9, 0xAA, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB9, 0xAC, FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB9,
		0xAE, FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB9, 0xB0,
		FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0xA2, FIL_, 0xCC,
		0x8C, FIL_, 0xC5, 0xA4, FIL_, 0x13, 0xCC, 0x8A,
		FIL_, 0xC5, 0xAE, FIL_, 0xCC, 0x88, FIL_, 0xC3,
		0x9C, FIL_, 0xCC, 0x8B, FIL_, 0xC5, 0xB0, FIL_,
		0xCC, 0xAD, FIL_, 0xE1, 0xB9, 0xB6, FIL_, 0xCC,
		0xA8, FIL_, 0xC5, 0xB2, FIL_, 0xCC, 0x8C, FIL_,
		0xC7, 0x93, FIL_, 0xCC, 0x80, FIL_, 0xC3, 0x99,
		FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x94, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBB, 0xA4, FIL_, 0xCC, 0xA4,
		FIL_, 0xE1, 0xB9, 0xB2, FIL_, 0xCC, 0x81, FIL_,
		0xC3, 0x9A, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0x9B,
		FIL_, 0xCC, 0xB0, FIL_, 0xE1, 0xB9, 0xB4, FIL_,
		0xCC, 0x83, FIL_, 0xC5, 0xA8, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0xA6, FIL_, 0xCC, 0x84, FIL_,
		0xC5, 0xAA, FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x96,
		FIL_, 0xCC, 0x86, FIL_, 0xC5, 0xAC, FIL_, 0xCC,
		0x9B, FIL_, 0xC6, 0xAF, FIL_, 0x02, 0xCC, 0xA3,
		FIL_, 0xE1, 0xB9, 0xBE, FIL_, 0xCC, 0x83, FIL_,
		0xE1, 0xB9, 0xBC, FIL_, 0x06, 0xCC, 0x88, FIL_,
		0xE1, 0xBA, 0x84, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBA, 0x82, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBA,
		0x80, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0x88,
		FIL_, 0xCC, 0x82, FIL_, 0xC5, 0xB4, FIL_, 0xCC,
		0x87, FIL_, 0xE1, 0xBA, 0x86, FIL_, 0x02, 0xCC,
		0x88, FIL_, 0xE1, 0xBA, 0x8C, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xBA, 0x8A, FIL_, 0x09, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0xB6, FIL_, 0xCC, 0xA3, FIL_,
		0xE1, 0xBB, 0xB4, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBB, 0xB2, FIL_, 0xCC, 0x88, FIL_, 0xC5, 0xB8,
		FIL_, 0xCC, 0x81, FIL_, 0xC3, 0x9D, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBB, 0xB8, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xBA, 0x8E, FIL_, 0xCC, 0x84, FIL_,
		0xC8, 0xB2, FIL_, 0xCC, 0x82, FIL_, 0xC5, 0xB6,
		FIL_, 0x06, 0xCC, 0x82, FIL_, 0xE1, 0xBA, 0x90,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0x92, FIL_,
		0xCC, 0xB1, FIL_, 0xE1, 0xBA, 0x94, FIL_, 0xCC,
		0x8C, FIL_, 0xC5, 0xBD, FIL_, 0xCC, 0x87, FIL_,
		0xC5, 0xBB, FIL_, 0xCC, 0x81, FIL_, 0xC5, 0xB9,
		FIL_, 0x10, 0xCC, 0xA3, FIL_, 0xE1, 0xBA, 0xA1,
		FIL_, 0xCC, 0xA8, FIL_, 0xC4, 0x85, FIL_, 0xCC,
		0x81, FIL_, 0xC3, 0xA1, FIL_, 0xCC, 0x82, FIL_,
		0xC3, 0xA2, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA,
		0xA3, FIL_, 0xCC, 0x83, FIL_, 0xC3, 0xA3, FIL_,
		0xCC, 0x8C, FIL_, 0xC7, 0x8E, FIL_, 0xCC, 0x8A,
		FIL_, 0xC3, 0xA5, FIL_, 0xCC, 0x88, FIL_, 0xC3,
		0xA4, FIL_, 0xCC, 0x87, FIL_, 0xC8, 0xA7, FIL_,
		0xCC, 0x91, FIL_, 0xC8, 0x83, FIL_, 0xCC, 0xA5,
		FIL_, 0xE1, 0xB8, 0x81, FIL_, 0xCC, 0x84, FIL_,
		0xC4, 0x81, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x81,
		FIL_, 0xCC, 0x86, FIL_, 0xC4, 0x83, FIL_, 0xCC,
		0x80, FIL_, 0xC3, 0xA0, FIL_, 0x03, 0xCC, 0xA3,
		FIL_, 0xE1, 0xB8, 0x85, FIL_, 0xCC, 0x87, FIL_,
		0xE1, 0xB8, 0x83, FIL_, 0xCC, 0xB1, FIL_, 0xE1,
		0xB8, 0x87, FIL_, 0x05, 0xCC, 0x87, FIL_, 0xC4,
		0x8B, FIL_, 0xCC, 0x8C, FIL_, 0xC4, 0x8D, FIL_,
		0xCC, 0x82, FIL_, 0xC4, 0x89, FIL_, 0xCC, 0x81,
		FIL_, 0xC4, 0x87, FIL_, 0xCC, 0xA7, FIL_, 0xC3,
		0xA7, FIL_, 0x06, 0xCC, 0x87, FIL_, 0xE1, 0xB8,
		0x8B, FIL_, 0xCC, 0xA7, FIL_, 0xE1, 0xB8, 0x91,
		FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB8, 0x8F, FIL_,
		0xCC, 0xA3, FIL_, 0xE1, 0xB8, 0x8D, FIL_, 0xCC,
		0x8C, FIL_, 0xC4, 0x8F, FIL_, 0xCC, 0xAD, FIL_,
		0xE1, 0xB8, 0x93, FIL_, 0x11, 0xCC, 0x80, FIL_,
		0xC3, 0xA8, FIL_, 0xCC, 0x81, FIL_, 0xC3, 0xA9,
		FIL_, 0xCC, 0x82, FIL_, 0xC3, 0xAA, FIL_, 0xCC,
		0x88, FIL_, 0xC3, 0xAB, FIL_, 0xCC, 0x84, FIL_,
		0xC4, 0x93, FIL_, 0xCC, 0x86, FIL_, 0xC4, 0x95,
		FIL_, 0xCC, 0x87, FIL_, 0xC4, 0x97, FIL_, 0xCC,
		0xA8, FIL_, 0xC4, 0x99, FIL_, 0xCC, 0x8C, FIL_,
		0xC4, 0x9B, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x85,
		FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x87, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBA, 0xB9, FIL_, 0xCC, 0xA7,
		FIL_, 0xC8, 0xA9, FIL_, 0xCC, 0x83, FIL_, 0xE1,
		0xBA, 0xBD, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA,
		0xBB, FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0x99,
		FIL_, 0xCC, 0xB0, FIL_, 0xE1, 0xB8, 0x9B, FIL_,
		0x01, 0xCC, 0x87, FIL_, 0xE1, 0xB8, 0x9F, FIL_,
		0x07, 0xCC, 0x86, FIL_, 0xC4, 0x9F, FIL_, 0xCC,
		0x87, FIL_, 0xC4, 0xA1, FIL_, 0xCC, 0x82, FIL_,
		0xC4, 0x9D, FIL_, 0xCC, 0x84, FIL_, 0xE1, 0xB8,
		0xA1, FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0xA7, FIL_,
		0xCC, 0xA7, FIL_, 0xC4, 0xA3, FIL_, 0xCC, 0x81,
		FIL_, 0xC7, 0xB5, FIL_, 0x08, 0xCC, 0xA7, FIL_,
		0xE1, 0xB8, 0xA9, FIL_, 0xCC, 0xB1, FIL_, 0xE1,
		0xBA, 0x96, FIL_, 0xCC, 0x8C, FIL_, 0xC8, 0x9F,
		FIL_, 0xCC, 0xAE, FIL_, 0xE1, 0xB8, 0xAB, FIL_,
		0xCC, 0x88, FIL_, 0xE1, 0xB8, 0xA7, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xB8, 0xA5, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB8, 0xA3, FIL_, 0xCC, 0x82, FIL_,
		0xC4, 0xA5, FIL_, 0x0E, 0xCC, 0x88, FIL_, 0xC3,
		0xAF, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x89,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0x8B, FIL_,
		0xCC, 0x82, FIL_, 0xC3, 0xAE, FIL_, 0xCC, 0x81,
		FIL_, 0xC3, 0xAD, FIL_, 0xCC, 0x80, FIL_, 0xC3,
		0xAC, FIL_, 0xCC, 0x83, FIL_, 0xC4, 0xA9, FIL_,
		0xCC, 0x84, FIL_, 0xC4, 0xAB, FIL_, 0xCC, 0x86,
		FIL_, 0xC4, 0xAD, FIL_, 0xCC, 0xA8, FIL_, 0xC4,
		0xAF, FIL_, 0xCC, 0xB0, FIL_, 0xE1, 0xB8, 0xAD,
		FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x90, FIL_, 0xCC,
		0x91, FIL_, 0xC8, 0x8B, FIL_, 0xCC, 0x8F, FIL_,
		0xC8, 0x89, FIL_, 0x02, 0xCC, 0x8C, FIL_, 0xC7,
		0xB0, FIL_, 0xCC, 0x82, FIL_, 0xC4, 0xB5, FIL_,
		0x05, 0xCC, 0xB1, FIL_, 0xE1, 0xB8, 0xB5, FIL_,
		0xCC, 0xA7, FIL_, 0xC4, 0xB7, FIL_, 0xCC, 0x8C,
		FIL_, 0xC7, 0xA9, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xB8, 0xB1, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB3, FIL_, 0x06, 0xCC, 0xA3, FIL_, 0xE1, 0xB8,
		0xB7, FIL_, 0xCC, 0xAD, FIL_, 0xE1, 0xB8, 0xBD,
		FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB8, 0xBB, FIL_,
		0xCC, 0xA7, FIL_, 0xC4, 0xBC, FIL_, 0xCC, 0x81,
		FIL_, 0xC4, 0xBA, FIL_, 0xCC, 0x8C, FIL_, 0xC4,
		0xBE, FIL_, 0x03, 0xCC, 0x87, FIL_, 0xE1, 0xB9,
		0x81, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x83,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xBF, FIL_,
		0x09, 0xCC, 0x80, FIL_, 0xC7, 0xB9, FIL_, 0xCC,
		0xAD, FIL_, 0xE1, 0xB9, 0x8B, FIL_, 0xCC, 0x83,
		FIL_, 0xC3, 0xB1, FIL_, 0xCC, 0x81, FIL_, 0xC5,
		0x84, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0x87,
		FIL_, 0xCC, 0xB1, FIL_, 0xE1, 0xB9, 0x89, FIL_,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0x85, FIL_, 0xCC,
		0xA7, FIL_, 0xC5, 0x86, FIL_, 0xCC, 0x8C, FIL_,
		0xC5, 0x88, FIL_, 0x10, 0xCC, 0xA3, FIL_, 0xE1,
		0xBB, 0x8D, FIL_, 0xCC, 0x87, FIL_, 0xC8, 0xAF,
		FIL_, 0xCC, 0x80, FIL_, 0xC3, 0xB2, FIL_, 0xCC,
		0x91, FIL_, 0xC8, 0x8F, FIL_, 0xCC, 0x89, FIL_,
		0xE1, 0xBB, 0x8F, FIL_, 0xCC, 0x88, FIL_, 0xC3,
		0xB6, FIL_, 0xCC, 0x83, FIL_, 0xC3, 0xB5, FIL_,
		0xCC, 0x81, FIL_, 0xC3, 0xB3, FIL_, 0xCC, 0x8C,
		FIL_, 0xC7, 0x92, FIL_, 0xCC, 0xA8, FIL_, 0xC7,
		0xAB, FIL_, 0xCC, 0x9B, FIL_, 0xC6, 0xA1, FIL_,
		0xCC, 0x84, FIL_, 0xC5, 0x8D, FIL_, 0xCC, 0x86,
		FIL_, 0xC5, 0x8F, FIL_, 0xCC, 0x8B, FIL_, 0xC5,
		0x91, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0xB4, FIL_,
		0xCC, 0x8F, FIL_, 0xC8, 0x8D, FIL_, 0x02, 0xCC,
		0x87, FIL_, 0xE1, 0xB9, 0x97, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0x95, FIL_, 0x08, 0xCC, 0x8C,
		FIL_, 0xC5, 0x99, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB9, 0x9B, FIL_, 0xCC, 0x81, FIL_, 0xC5, 0x95,
		FIL_, 0xCC, 0xA7, FIL_, 0xC5, 0x97, FIL_, 0xCC,
		0xB1, FIL_, 0xE1, 0xB9, 0x9F, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0x99, FIL_, 0xCC, 0x91, FIL_,
		0xC8, 0x93, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x91,
		FIL_, 0x07, 0xCC, 0xA7, FIL_, 0xC5, 0x9F, FIL_,
		0xCC, 0x82, FIL_, 0xC5, 0x9D, FIL_, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA1, FIL_, 0xCC, 0xA6, FIL_,
		0xC8, 0x99, FIL_, 0xCC, 0x81, FIL_, 0xC5, 0x9B,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9, 0xA3, FIL_,
		0xCC, 0x8C, FIL_, 0xC5, 0xA1, FIL_, 0x08, 0xCC,
		0xA6, FIL_, 0xC8, 0x9B, FIL_, 0xCC, 0xAD, FIL_,
		0xE1, 0xB9, 0xB1, FIL_, 0xCC, 0xB1, FIL_, 0xE1,
		0xB9, 0xAF, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xB9,
		0xAD, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xAB,
		FIL_, 0xCC, 0x8C, FIL_, 0xC5, 0xA5, FIL_, 0xCC,
		0xA7, FIL_, 0xC5, 0xA3, FIL_, 0xCC, 0x88, FIL_,
		0xE1, 0xBA, 0x97, FIL_, 0x13, 0xCC, 0x8A, FIL_,
		0xC5, 0xAF, FIL_, 0xCC, 0x8F, FIL_, 0xC8, 0x95,
		FIL_, 0xCC, 0x8C, FIL_, 0xC7, 0x94, FIL_, 0xCC,
		0x80, FIL_, 0xC3, 0xB9, FIL_, 0xCC, 0x9B, FIL_,
		0xC6, 0xB0, FIL_, 0xCC, 0x82, FIL_, 0xC3, 0xBB,
		FIL_, 0xCC, 0x81, FIL_, 0xC3, 0xBA, FIL_, 0xCC,
		0x88, FIL_, 0xC3, 0xBC, FIL_, 0xCC, 0x83, FIL_,
		0xC5, 0xA9, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB,
		0xA7, FIL_, 0xCC, 0x84, FIL_, 0xC5, 0xAB, FIL_,
		0xCC, 0x86, FIL_, 0xC5, 0xAD, FIL_, 0xCC, 0xAD,
		FIL_, 0xE1, 0xB9, 0xB7, FIL_, 0xCC, 0x8B, FIL_,
		0xC5, 0xB1, FIL_, 0xCC, 0xA8, FIL_, 0xC5, 0xB3,
		FIL_, 0xCC, 0x91, FIL_, 0xC8, 0x97, FIL_, 0xCC,
		0xA4, FIL_, 0xE1, 0xB9, 0xB3, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xBB, 0xA5, FIL_, 0xCC, 0xB0, FIL_,
		0xE1, 0xB9, 0xB5, FIL_, 0x02, 0xCC, 0x83, FIL_,
		0xE1, 0xB9, 0xBD, FIL_, 0xCC, 0xA3, FIL_, 0xE1,
		0xB9, 0xBF, FIL_, 0x07, 0xCC, 0x8A, FIL_, 0xE1,
		0xBA, 0x98, FIL_, 0xCC, 0x87, FIL_, 0xE1, 0xBA,
		0x87, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0x83,
		FIL_, 0xCC, 0x82, FIL_, 0xC5, 0xB5, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBA, 0x81, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xBA, 0x89, FIL_, 0xCC, 0x88, FIL_,
		0xE1, 0xBA, 0x85, FIL_, 0x02, 0xCC, 0x87, FIL_,
		0xE1, 0xBA, 0x8B, FIL_, 0xCC, 0x88, FIL_, 0xE1,
		0xBA, 0x8D, FIL_, 0x0A, 0xCC, 0x87, FIL_, 0xE1,
		0xBA, 0x8F, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB,
		0xB5, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0xB7,
		FIL_, 0xCC, 0x8A, FIL_, 0xE1, 0xBA, 0x99, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBB, 0xB3, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBB, 0xB9, FIL_, 0xCC, 0x88,
		FIL_, 0xC3, 0xBF, FIL_, 0xCC, 0x81, FIL_, 0xC3,
		0xBD, FIL_, 0xCC, 0x84, FIL_, 0xC8, 0xB3, FIL_,
		0xCC, 0x82, FIL_, 0xC5, 0xB7, FIL_, 0x06, 0xCC,
		0xB1, FIL_, 0xE1, 0xBA, 0x95, FIL_, 0xCC, 0xA3,
		FIL_, 0xE1, 0xBA, 0x93, FIL_, 0xCC, 0x82, FIL_,
		0xE1, 0xBA, 0x91, FIL_, 0xCC, 0x81, FIL_, 0xC5,
		0xBA, FIL_, 0xCC, 0x87, FIL_, 0xC5, 0xBC, FIL_,
		0xCC, 0x8C, FIL_, 0xC5, 0xBE, FIL_, 0x03, 0xCC,
		0x80, FIL_, 0xE1, 0xBF, 0xAD, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x81, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x85, FIL_, 0x04, 0xCC, 0x83, FIL_, 0xE1,
		0xBA, 0xAA, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA,
		0xA4, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xA8,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBA, 0xA6, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC7, 0x9E, FIL_, 0x01,
		0xCC, 0x81, FIL_, 0xC7, 0xBA, FIL_, 0x02, 0xCC,
		0x84, FIL_, 0xC7, 0xA2, FIL_, 0xCC, 0x81, FIL_,
		0xC7, 0xBC, FIL_, 0x01, 0xCC, 0x81, FIL_, 0xE1,
		0xB8, 0x88, FIL_, 0x04, 0xCC, 0x83, FIL_, 0xE1,
		0xBB, 0x84, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBB,
		0x80, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x82,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xBE, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0xAE, FIL_,
		0x04, 0xCC, 0x81, FIL_, 0xE1, 0xBB, 0x90, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBB, 0x92, FIL_, 0xCC,
		0x89, FIL_, 0xE1, 0xBB, 0x94, FIL_, 0xCC, 0x83,
		FIL_, 0xE1, 0xBB, 0x96, FIL_, 0x03, 0xCC, 0x84,
		FIL_, 0xC8, 0xAC, FIL_, 0xCC, 0x88, FIL_, 0xE1,
		0xB9, 0x8E, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xB9,
		0x8C, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC8, 0xAA,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xC7, 0xBE, FIL_,
		0x04, 0xCC, 0x80, FIL_, 0xC7, 0x9B, FIL_, 0xCC,
		0x84, FIL_, 0xC7, 0x95, FIL_, 0xCC, 0x8C, FIL_,
		0xC7, 0x99, FIL_, 0xCC, 0x81, FIL_, 0xC7, 0x97,
		FIL_, 0x04, 0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xA5,
		FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBA, 0xAB, FIL_,
		0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xA9, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBA, 0xA7, FIL_, 0x01, 0xCC,
		0x84, FIL_, 0xC7, 0x9F, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xC7, 0xBB, FIL_, 0x02, 0xCC, 0x81, FIL_,
		0xC7, 0xBD, FIL_, 0xCC, 0x84, FIL_, 0xC7, 0xA3,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x89,
		FIL_, 0x04, 0xCC, 0x89, FIL_, 0xE1, 0xBB, 0x83,
		FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0x85, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBB, 0x81, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBA, 0xBF, FIL_, 0x01, 0xCC,
		0x81, FIL_, 0xE1, 0xB8, 0xAF, FIL_, 0x04, 0xCC,
		0x80, FIL_, 0xE1, 0xBB, 0x93, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBB, 0x91, FIL_, 0xCC, 0x83, FIL_,
		0xE1, 0xBB, 0x97, FIL_, 0xCC, 0x89, FIL_, 0xE1,
		0xBB, 0x95, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1,
		0xB9, 0x8D, FIL_, 0xCC, 0x88, FIL_, 0xE1, 0xB9,
		0x8F, FIL_, 0xCC, 0x84, FIL_, 0xC8, 0xAD, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC8, 0xAB, FIL_, 0x01,
		0xCC, 0x81, FIL_, 0xC7, 0xBF, FIL_, 0x04, 0xCC,
		0x8C, FIL_, 0xC7, 0x9A, FIL_, 0xCC, 0x84, FIL_,
		0xC7, 0x96, FIL_, 0xCC, 0x80, FIL_, 0xC7, 0x9C,
		FIL_, 0xCC, 0x81, FIL_, 0xC7, 0x98, FIL_, 0x04,
		0xCC, 0x81, FIL_, 0xE1, 0xBA, 0xAE, FIL_, 0xCC,
		0x83, FIL_, 0xE1, 0xBA, 0xB4, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBA, 0xB2, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBA, 0xB0, FIL_, 0x04, 0xCC, 0x83, FIL_,
		0xE1, 0xBA, 0xB5, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBA, 0xB1, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBA,
		0xAF, FIL_, 0xCC, 0x89, FIL_, 0xE1, 0xBA, 0xB3,
		FIL_, 0x02, 0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x96,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xB8, 0x94, FIL_,
		0x02, 0xCC, 0x80, FIL_, 0xE1, 0xB8, 0x95, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xB8, 0x97, FIL_, 0x02,
		0xCC, 0x80, FIL_, 0xE1, 0xB9, 0x90, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xB9, 0x92, FIL_, 0x02, 0xCC,
		0x81, FIL_, 0xE1, 0xB9, 0x93, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xB9, 0x91, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA4, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA5, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA6, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xB9, 0xA7, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0xB8, FIL_, 0x01, 0xCC, 0x81,
		FIL_, 0xE1, 0xB9, 0xB9, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xE1, 0xB9, 0xBA, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xE1, 0xB9, 0xBB, FIL_, 0x01, 0xCC, 0x87,
		FIL_, 0xE1, 0xBA, 0x9B, FIL_, 0x05, 0xCC, 0x80,
		FIL_, 0xE1, 0xBB, 0x9C, FIL_, 0xCC, 0x89, FIL_,
		0xE1, 0xBB, 0x9E, FIL_, 0xCC, 0x83, FIL_, 0xE1,
		0xBB, 0xA0, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBB,
		0x9A, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xA2,
		FIL_, 0x05, 0xCC, 0x83, FIL_, 0xE1, 0xBB, 0xA1,
		FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xA3, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBB, 0x9B, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBB, 0x9D, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0x9F, FIL_, 0x05, 0xCC, 0x81,
		FIL_, 0xE1, 0xBB, 0xA8, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBB, 0xAA, FIL_, 0xCC, 0x89, FIL_, 0xE1,
		0xBB, 0xAC, FIL_, 0xCC, 0x83, FIL_, 0xE1, 0xBB,
		0xAE, FIL_, 0xCC, 0xA3, FIL_, 0xE1, 0xBB, 0xB0,
		FIL_, 0x05, 0xCC, 0x80, FIL_, 0xE1, 0xBB, 0xAB,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBB, 0xA9, FIL_,
		0xCC, 0x83, FIL_, 0xE1, 0xBB, 0xAF, FIL_, 0xCC,
		0xA3, FIL_, 0xE1, 0xBB, 0xB1, FIL_, 0xCC, 0x89,
		FIL_, 0xE1, 0xBB, 0xAD, FIL_, 0x01, 0xCC, 0x8C,
		FIL_, 0xC7, 0xAE, FIL_, 0x01, 0xCC, 0x84, FIL_,
		0xC7, 0xAC, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7,
		0xAD, FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7, 0xA0,
		FIL_, 0x01, 0xCC, 0x84, FIL_, 0xC7, 0xA1, FIL_,
		0x01, 0xCC, 0x86, FIL_, 0xE1, 0xB8, 0x9C, FIL_,
		0x01, 0xCC, 0x86, FIL_, 0xE1, 0xB8, 0x9D, FIL_,
		0x01, 0xCC, 0x84, FIL_, 0xC8, 0xB0, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xC8, 0xB1, FIL_, 0x01, 0xCC,
		0x8C, FIL_, 0xC7, 0xAF, FIL_, 0x07, 0xCC, 0x93,
		FIL_, 0xE1, 0xBC, 0x88, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x86, FIL_, 0xCC, 0x86, FIL_, 0xE1, 0xBE,
		0xB8, FIL_, 0xCC, 0x84, FIL_, 0xE1, 0xBE, 0xB9,
		FIL_, 0xCC, 0x94, FIL_, 0xE1, 0xBC, 0x89, FIL_,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xBC, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBE, 0xBA, FIL_, 0x04, 0xCC,
		0x94, FIL_, 0xE1, 0xBC, 0x99, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBF, 0x88, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x88, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBC,
		0x98, FIL_, 0x05, 0xCD, 0x85, FIL_, 0xE1, 0xBF,
		0x8C, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0x89, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBF, 0x8A, FIL_, 0xCC,
		0x93, FIL_, 0xE1, 0xBC, 0xA8, FIL_, 0xCC, 0x94,
		FIL_, 0xE1, 0xBC, 0xA9, FIL_, 0x07, 0xCC, 0x80,
		FIL_, 0xE1, 0xBF, 0x9A, FIL_, 0xCC, 0x84, FIL_,
		0xE1, 0xBF, 0x99, FIL_, 0xCC, 0x93, FIL_, 0xE1,
		0xBC, 0xB8, FIL_, 0xCC, 0x94, FIL_, 0xE1, 0xBC,
		0xB9, FIL_, 0xCC, 0x86, FIL_, 0xE1, 0xBF, 0x98,
		FIL_, 0xCC, 0x81, FIL_, 0xCE, 0x8A, FIL_, 0xCC,
		0x88, FIL_, 0xCE, 0xAA, FIL_, 0x04, 0xCC, 0x81,
		FIL_, 0xCE, 0x8C, FIL_, 0xCC, 0x94, FIL_, 0xE1,
		0xBD, 0x89, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBD,
		0x88, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF, 0xB8,
		FIL_, 0x01, 0xCC, 0x94, FIL_, 0xE1, 0xBF, 0xAC,
		FIL_, 0x06, 0xCC, 0x94, FIL_, 0xE1, 0xBD, 0x99,
		FIL_, 0xCC, 0x86, FIL_, 0xE1, 0xBF, 0xA8, FIL_,
		0xCC, 0x88, FIL_, 0xCE, 0xAB, FIL_, 0xCC, 0x84,
		FIL_, 0xE1, 0xBF, 0xA9, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x8E, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF,
		0xAA, FIL_, 0x05, 0xCC, 0x93, FIL_, 0xE1, 0xBD,
		0xA8, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xBC,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF, 0xBA, FIL_,
		0xCC, 0x94, FIL_, 0xE1, 0xBD, 0xA9, FIL_, 0xCC,
		0x81, FIL_, 0xCE, 0x8F, FIL_, 0x01, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0xB4, FIL_, 0x01, 0xCD, 0x85,
		FIL_, 0xE1, 0xBF, 0x84, FIL_, 0x08, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0xB3, FIL_, 0xCC, 0x84, FIL_,
		0xE1, 0xBE, 0xB1, FIL_, 0xCC, 0x86, FIL_, 0xE1,
		0xBE, 0xB0, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD,
		0xB0, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xAC, FIL_,
		0xCC, 0x94, FIL_, 0xE1, 0xBC, 0x81, FIL_, 0xCC,
		0x93, FIL_, 0xE1, 0xBC, 0x80, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBE, 0xB6, FIL_, 0x04, 0xCC, 0x93,
		FIL_, 0xE1, 0xBC, 0x90, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBD, 0xB2, FIL_, 0xCC, 0x94, FIL_, 0xE1,
		0xBC, 0x91, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xAD,
		FIL_, 0x06, 0xCC, 0x94, FIL_, 0xE1, 0xBC, 0xA1,
		FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xAE, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBF, 0x83, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x86, FIL_, 0xCC, 0x93, FIL_,
		0xE1, 0xBC, 0xA0, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBD, 0xB4, FIL_, 0x08, 0xCC, 0x88, FIL_, 0xCF,
		0x8A, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xAF, FIL_,
		0xCC, 0x93, FIL_, 0xE1, 0xBC, 0xB0, FIL_, 0xCC,
		0x94, FIL_, 0xE1, 0xBC, 0xB1, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBD, 0xB6, FIL_, 0xCC, 0x86, FIL_,
		0xE1, 0xBF, 0x90, FIL_, 0xCC, 0x84, FIL_, 0xE1,
		0xBF, 0x91, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF,
		0x96, FIL_, 0x04, 0xCC, 0x93, FIL_, 0xE1, 0xBD,
		0x80, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xB8,
		FIL_, 0xCC, 0x94, FIL_, 0xE1, 0xBD, 0x81, FIL_,
		0xCC, 0x81, FIL_, 0xCF, 0x8C, FIL_, 0x02, 0xCC,
		0x93, FIL_, 0xE1, 0xBF, 0xA4, FIL_, 0xCC, 0x94,
		FIL_, 0xE1, 0xBF, 0xA5, FIL_, 0x08, 0xCC, 0x81,
		FIL_, 0xCF, 0x8D, FIL_, 0xCC, 0x94, FIL_, 0xE1,
		0xBD, 0x91, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF,
		0xA6, FIL_, 0xCC, 0x88, FIL_, 0xCF, 0x8B, FIL_,
		0xCC, 0x84, FIL_, 0xE1, 0xBF, 0xA1, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBD, 0xBA, FIL_, 0xCC, 0x93,
		FIL_, 0xE1, 0xBD, 0x90, FIL_, 0xCC, 0x86, FIL_,
		0xE1, 0xBF, 0xA0, FIL_, 0x06, 0xCC, 0x80, FIL_,
		0xE1, 0xBD, 0xBC, FIL_, 0xCC, 0x94, FIL_, 0xE1,
		0xBD, 0xA1, FIL_, 0xCC, 0x93, FIL_, 0xE1, 0xBD,
		0xA0, FIL_, 0xCC, 0x81, FIL_, 0xCF, 0x8E, FIL_,
		0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xB3, FIL_, 0xCD,
		0x82, FIL_, 0xE1, 0xBF, 0xB6, FIL_, 0x03, 0xCC,
		0x80, FIL_, 0xE1, 0xBF, 0x92, FIL_, 0xCD, 0x82,
		FIL_, 0xE1, 0xBF, 0x97, FIL_, 0xCC, 0x81, FIL_,
		0xCE, 0x90, FIL_, 0x03, 0xCD, 0x82, FIL_, 0xE1,
		0xBF, 0xA7, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF,
		0xA2, FIL_, 0xCC, 0x81, FIL_, 0xCE, 0xB0, FIL_,
		0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xB4, FIL_,
		0x02, 0xCC, 0x88, FIL_, 0xCF, 0x94, FIL_, 0xCC,
		0x81, FIL_, 0xCF, 0x93, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD0, 0x87, FIL_, 0x02, 0xCC, 0x88, FIL_,
		0xD3, 0x92, FIL_, 0xCC, 0x86, FIL_, 0xD3, 0x90,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xD0, 0x83, FIL_,
		0x03, 0xCC, 0x88, FIL_, 0xD0, 0x81, FIL_, 0xCC,
		0x80, FIL_, 0xD0, 0x80, FIL_, 0xCC, 0x86, FIL_,
		0xD3, 0x96, FIL_, 0x02, 0xCC, 0x86, FIL_, 0xD3,
		0x81, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0x9C, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9E, FIL_, 0x04,
		0xCC, 0x84, FIL_, 0xD3, 0xA2, FIL_, 0xCC, 0x88,
		FIL_, 0xD3, 0xA4, FIL_, 0xCC, 0x86, FIL_, 0xD0,
		0x99, FIL_, 0xCC, 0x80, FIL_, 0xD0, 0x8D, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xD0, 0x8C, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xA6, FIL_, 0x04, 0xCC,
		0x8B, FIL_, 0xD3, 0xB2, FIL_, 0xCC, 0x88, FIL_,
		0xD3, 0xB0, FIL_, 0xCC, 0x86, FIL_, 0xD0, 0x8E,
		FIL_, 0xCC, 0x84, FIL_, 0xD3, 0xAE, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xB4, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xB8, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD3, 0xAC, FIL_, 0x02, 0xCC, 0x86, FIL_,
		0xD3, 0x91, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0x93,
		FIL_, 0x01, 0xCC, 0x81, FIL_, 0xD1, 0x93, FIL_,
		0x03, 0xCC, 0x80, FIL_, 0xD1, 0x90, FIL_, 0xCC,
		0x86, FIL_, 0xD3, 0x97, FIL_, 0xCC, 0x88, FIL_,
		0xD1, 0x91, FIL_, 0x02, 0xCC, 0x86, FIL_, 0xD3,
		0x82, FIL_, 0xCC, 0x88, FIL_, 0xD3, 0x9D, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9F, FIL_, 0x04,
		0xCC, 0x86, FIL_, 0xD0, 0xB9, FIL_, 0xCC, 0x88,
		FIL_, 0xD3, 0xA5, FIL_, 0xCC, 0x84, FIL_, 0xD3,
		0xA3, FIL_, 0xCC, 0x80, FIL_, 0xD1, 0x9D, FIL_,
		0x01, 0xCC, 0x81, FIL_, 0xD1, 0x9C, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xA7, FIL_, 0x04, 0xCC,
		0x8B, FIL_, 0xD3, 0xB3, FIL_, 0xCC, 0x84, FIL_,
		0xD3, 0xAF, FIL_, 0xCC, 0x86, FIL_, 0xD1, 0x9E,
		FIL_, 0xCC, 0x88, FIL_, 0xD3, 0xB1, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xB5, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xB9, FIL_, 0x01, 0xCC, 0x88,
		FIL_, 0xD3, 0xAD, FIL_, 0x01, 0xCC, 0x88, FIL_,
		0xD1, 0x97, FIL_, 0x01, 0xCC, 0x8F, FIL_, 0xD1,
		0xB6, FIL_, 0x01, 0xCC, 0x8F, FIL_, 0xD1, 0xB7,
		FIL_, 0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9A, FIL_,
		0x01, 0xCC, 0x88, FIL_, 0xD3, 0x9B, FIL_, 0x01,
		0xCC, 0x88, FIL_, 0xD3, 0xAA, FIL_, 0x01, 0xCC,
		0x88, FIL_, 0xD3, 0xAB, FIL_, 0x03, 0xD9, 0x94,
		FIL_, 0xD8, 0xA3, FIL_, 0xD9, 0x95, FIL_, 0xD8,
		0xA5, FIL_, 0xD9, 0x93, FIL_, 0xD8, 0xA2, FIL_,
		0x01, 0xD9, 0x94, FIL_, 0xD8, 0xA4, FIL_, 0x01,
		0xD9, 0x94, FIL_, 0xD8, 0xA6, FIL_, 0x01, 0xD9,
		0x94, FIL_, 0xDB, 0x82, FIL_, 0x01, 0xD9, 0x94,
		FIL_, 0xDB, 0x93, FIL_, 0x01, 0xD9, 0x94, FIL_,
		0xDB, 0x80, FIL_, 0x01, 0xE0, 0xA4, 0xBC, FIL_,
		0xE0, 0xA4, 0xA9, FIL_, 0x01, 0xE0, 0xA4, 0xBC,
		FIL_, 0xE0, 0xA4, 0xB1, FIL_, 0x01, 0xE0, 0xA4,
		0xBC, FIL_, 0xE0, 0xA4, 0xB4, FIL_, 0x02, 0xE0,
		0xA6, 0xBE, FIL_, 0xE0, 0xA7, 0x8B, FIL_, 0xE0,
		0xA7, 0x97, FIL_, 0xE0, 0xA7, 0x8C, FIL_, 0x03,
		0xE0, 0xAD, 0x96, FIL_, 0xE0, 0xAD, 0x88, FIL_,
		0xE0, 0xAC, 0xBE, FIL_, 0xE0, 0xAD, 0x8B, FIL_,
		0xE0, 0xAD, 0x97, FIL_, 0xE0, 0xAD, 0x8C, FIL_,
		0x01, 0xE0, 0xAF, 0x97, FIL_, 0xE0, 0xAE, 0x94,
		FIL_, 0x02, 0xE0, 0xAF, 0x97, FIL_, 0xE0, 0xAF,
		0x8C, FIL_, 0xE0, 0xAE, 0xBE, FIL_, 0xE0, 0xAF,
		0x8A, FIL_, 0x01, 0xE0, 0xAE, 0xBE, FIL_, 0xE0,
		0xAF, 0x8B, FIL_, 0x01, 0xE0, 0xB1, 0x96, FIL_,
		0xE0, 0xB1, 0x88, FIL_, 0x01, 0xE0, 0xB3, 0x95,
		FIL_, 0xE0, 0xB3, 0x80, FIL_, 0x03, 0xE0, 0xB3,
		0x82, FIL_, 0xE0, 0xB3, 0x8A, FIL_, 0xE0, 0xB3,
		0x96, FIL_, 0xE0, 0xB3, 0x88, FIL_, 0xE0, 0xB3,
		0x95, FIL_, 0xE0, 0xB3, 0x87, FIL_, 0x01, 0xE0,
		0xB3, 0x95, FIL_, 0xE0, 0xB3, 0x8B, FIL_, 0x02,
		0xE0, 0xB4, 0xBE, FIL_, 0xE0, 0xB5, 0x8A, FIL_,
		0xE0, 0xB5, 0x97, FIL_, 0xE0, 0xB5, 0x8C, FIL_,
		0x01, 0xE0, 0xB4, 0xBE, FIL_, 0xE0, 0xB5, 0x8B,
		FIL_, 0x03, 0xE0, 0xB7, 0x9F, FIL_, 0xE0, 0xB7,
		0x9E, FIL_, 0xE0, 0xB7, 0x8A, FIL_, 0xE0, 0xB7,
		0x9A, FIL_, 0xE0, 0xB7, 0x8F, FIL_, 0xE0, 0xB7,
		0x9C, FIL_, 0x01, 0xE0, 0xB7, 0x8A, FIL_, 0xE0,
		0xB7, 0x9D, FIL_, 0x01, 0xE1, 0x80, 0xAE, FIL_,
		0xE1, 0x80, 0xA6, FIL_, 0x01, 0xE1, 0xAC, 0xB5,
		FIL_, 0xE1, 0xAC, 0x86, FIL_, 0x01, 0xE1, 0xAC,
		0xB5, FIL_, 0xE1, 0xAC, 0x88, FIL_, 0x01, 0xE1,
		0xAC, 0xB5, FIL_, 0xE1, 0xAC, 0x8A, FIL_, 0x01,
		0xE1, 0xAC, 0xB5, FIL_, 0xE1, 0xAC, 0x8C, FIL_,
		0x01, 0xE1, 0xAC, 0xB5, FIL_, 0xE1, 0xAC, 0x8E,
		FIL_, 0x01, 0xE1, 0xAC, 0xB5, FIL_, 0xE1, 0xAC,
		0x92, FIL_, 0x01, 0xE1, 0xAC, 0xB5, FIL_, 0xE1,
		0xAC, 0xBB, FIL_, 0x01, 0xE1, 0xAC, 0xB5, FIL_,
		0xE1, 0xAC, 0xBD, FIL_, 0x01, 0xE1, 0xAC, 0xB5,
		FIL_, 0xE1, 0xAD, 0x80, FIL_, 0x01, 0xE1, 0xAC,
		0xB5, FIL_, 0xE1, 0xAD, 0x81, FIL_, 0x01, 0xE1,
		0xAC, 0xB5, FIL_, 0xE1, 0xAD, 0x83, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xE1, 0xB8, 0xB8, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xE1, 0xB8, 0xB9, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xE1, 0xB9, 0x9C, FIL_, 0x01,
		0xCC, 0x84, FIL_, 0xE1, 0xB9, 0x9D, FIL_, 0x01,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xA8, FIL_, 0x01,
		0xCC, 0x87, FIL_, 0xE1, 0xB9, 0xA9, FIL_, 0x02,
		0xCC, 0x86, FIL_, 0xE1, 0xBA, 0xB6, FIL_, 0xCC,
		0x82, FIL_, 0xE1, 0xBA, 0xAC, FIL_, 0x02, 0xCC,
		0x82, FIL_, 0xE1, 0xBA, 0xAD, FIL_, 0xCC, 0x86,
		FIL_, 0xE1, 0xBA, 0xB7, FIL_, 0x01, 0xCC, 0x82,
		FIL_, 0xE1, 0xBB, 0x86, FIL_, 0x01, 0xCC, 0x82,
		FIL_, 0xE1, 0xBB, 0x87, FIL_, 0x01, 0xCC, 0x82,
		FIL_, 0xE1, 0xBB, 0x98, FIL_, 0x01, 0xCC, 0x82,
		FIL_, 0xE1, 0xBB, 0x99, FIL_, 0x04, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0x80, FIL_, 0xCD, 0x82, FIL_,
		0xE1, 0xBC, 0x86, FIL_, 0xCC, 0x80, FIL_, 0xE1,
		0xBC, 0x82, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC,
		0x84, FIL_, 0x04, 0xCD, 0x82, FIL_, 0xE1, 0xBC,
		0x87, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x85,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0x83, FIL_,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x81, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x82, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x83, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x84, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x85, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x86, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x87, FIL_, 0x04,
		0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x8C, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0x8A, FIL_, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0x88, FIL_, 0xCD, 0x82, FIL_,
		0xE1, 0xBC, 0x8E, FIL_, 0x04, 0xCC, 0x80, FIL_,
		0xE1, 0xBC, 0x8B, FIL_, 0xCD, 0x82, FIL_, 0xE1,
		0xBC, 0x8F, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC,
		0x8D, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x89,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8A,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8B,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8C,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8D,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8E,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x8F,
		FIL_, 0x02, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0x92,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x94, FIL_,
		0x02, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0x93, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBC, 0x95, FIL_, 0x02,
		0xCC, 0x80, FIL_, 0xE1, 0xBC, 0x9A, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBC, 0x9C, FIL_, 0x02, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0x9B, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBC, 0x9D, FIL_, 0x04, 0xCC, 0x80,
		FIL_, 0xE1, 0xBC, 0xA2, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBC, 0xA4, FIL_, 0xCD, 0x82, FIL_, 0xE1,
		0xBC, 0xA6, FIL_, 0xCD, 0x85, FIL_, 0xE1, 0xBE,
		0x90, FIL_, 0x04, 0xCD, 0x85, FIL_, 0xE1, 0xBE,
		0x91, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xA5,
		FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBC, 0xA7, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xA3, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x92, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x93, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x94, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x95, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x96, FIL_, 0x01,
		0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x97, FIL_, 0x04,
		0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xAC, FIL_, 0xCC,
		0x80, FIL_, 0xE1, 0xBC, 0xAA, FIL_, 0xCD, 0x85,
		FIL_, 0xE1, 0xBE, 0x98, FIL_, 0xCD, 0x82, FIL_,
		0xE1, 0xBC, 0xAE, FIL_, 0x04, 0xCD, 0x82, FIL_,
		0xE1, 0xBC, 0xAF, FIL_, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0x99, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC,
		0xAD, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xAB,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9A,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9B,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9C,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9D,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9E,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0x9F,
		FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xB4,
		FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xB2, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBC, 0xB6, FIL_, 0x03,
		0xCC, 0x80, FIL_, 0xE1, 0xBC, 0xB3, FIL_, 0xCD,
		0x82, FIL_, 0xE1, 0xBC, 0xB7, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBC, 0xB5, FIL_, 0x03, 0xCC, 0x81,
		FIL_, 0xE1, 0xBC, 0xBC, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBC, 0xBA, FIL_, 0xCD, 0x82, FIL_, 0xE1,
		0xBC, 0xBE, FIL_, 0x03, 0xCC, 0x80, FIL_, 0xE1,
		0xBC, 0xBB, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBC,
		0xBF, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBC, 0xBD,
		FIL_, 0x02, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0x82,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBD, 0x84, FIL_,
		0x02, 0xCC, 0x81, FIL_, 0xE1, 0xBD, 0x85, FIL_,
		0xCC, 0x80, FIL_, 0xE1, 0xBD, 0x83, FIL_, 0x02,
		0xCC, 0x80, FIL_, 0xE1, 0xBD, 0x8A, FIL_, 0xCC,
		0x81, FIL_, 0xE1, 0xBD, 0x8C, FIL_, 0x02, 0xCC,
		0x80, FIL_, 0xE1, 0xBD, 0x8B, FIL_, 0xCC, 0x81,
		FIL_, 0xE1, 0xBD, 0x8D, FIL_, 0x03, 0xCD, 0x82,
		FIL_, 0xE1, 0xBD, 0x96, FIL_, 0xCC, 0x80, FIL_,
		0xE1, 0xBD, 0x92, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBD, 0x94, FIL_, 0x03, 0xCC, 0x80, FIL_, 0xE1,
		0xBD, 0x93, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBD,
		0x97, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBD, 0x95,
		FIL_, 0x03, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0x9B,
		FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBD, 0x9F, FIL_,
		0xCC, 0x81, FIL_, 0xE1, 0xBD, 0x9D, FIL_, 0x04,
		0xCD, 0x82, FIL_, 0xE1, 0xBD, 0xA6, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA0, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBD, 0xA2, FIL_, 0xCC, 0x81, FIL_,
		0xE1, 0xBD, 0xA4, FIL_, 0x04, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0xA1, FIL_, 0xCD, 0x82, FIL_, 0xE1,
		0xBD, 0xA7, FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBD,
		0xA5, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xA3,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA2,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA3,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA4,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA5,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA6,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBE, 0xA7,
		FIL_, 0x04, 0xCC, 0x80, FIL_, 0xE1, 0xBD, 0xAA,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBD, 0xAC, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBD, 0xAE, FIL_, 0xCD,
		0x85, FIL_, 0xE1, 0xBE, 0xA8, FIL_, 0x04, 0xCD,
		0x82, FIL_, 0xE1, 0xBD, 0xAF, FIL_, 0xCC, 0x80,
		FIL_, 0xE1, 0xBD, 0xAB, FIL_, 0xCD, 0x85, FIL_,
		0xE1, 0xBE, 0xA9, FIL_, 0xCC, 0x81, FIL_, 0xE1,
		0xBD, 0xAD, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAA, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAB, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAC, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAD, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAE, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xAF, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xB2, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBF, 0x82, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBF, 0xB2, FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1,
		0xBE, 0xB7, FIL_, 0x03, 0xCC, 0x81, FIL_, 0xE1,
		0xBF, 0x8E, FIL_, 0xCC, 0x80, FIL_, 0xE1, 0xBF,
		0x8D, FIL_, 0xCD, 0x82, FIL_, 0xE1, 0xBF, 0x8F,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0x87,
		FIL_, 0x01, 0xCD, 0x85, FIL_, 0xE1, 0xBF, 0xB7,
		FIL_, 0x03, 0xCC, 0x80, FIL_, 0xE1, 0xBF, 0x9D,
		FIL_, 0xCC, 0x81, FIL_, 0xE1, 0xBF, 0x9E, FIL_,
		0xCD, 0x82, FIL_, 0xE1, 0xBF, 0x9F, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x86, 0x9A, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x86, 0x9B, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x86, 0xAE, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x87, 0x8D, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x87, 0x8F, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x87, 0x8E, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x88, 0x84, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x88, 0x89, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x88, 0x8C, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x88, 0xA4, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x88, 0xA6, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0x81, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0x84, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0x87, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0x89, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xAD, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xA2, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB0, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB1, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB4, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB5, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB8, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x89, 0xB9, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x80, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x81, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xA0, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xA1, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x84, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x85, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x88, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0x89, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xA2, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xA3, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0xAC, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0xAD, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0xAE, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8A, 0xAF, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xAA, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xAB, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xAC, FIL_, 0x01,
		0xCC, 0xB8, FIL_, 0xE2, 0x8B, 0xAD, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0x94, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0x8C,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81,
		0x8E, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x81, 0x90, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x81, 0x92, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x81, 0x94, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x81, 0x96, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x81, 0x98, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0x9A, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0x9C,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81,
		0x9E, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x81, 0xA0, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x81, 0xA2, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x81, 0xA5, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x81, 0xA7, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x81, 0xA9, FIL_, 0x02,
		0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x81, 0xB1, FIL_,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xB0, FIL_,
		0x02, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81, 0xB3,
		FIL_, 0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x81, 0xB4,
		FIL_, 0x02, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x81,
		0xB6, FIL_, 0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x81,
		0xB7, FIL_, 0x02, 0xE3, 0x82, 0x9A, FIL_, 0xE3,
		0x81, 0xBA, FIL_, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x81, 0xB9, FIL_, 0x02, 0xE3, 0x82, 0x9A, FIL_,
		0xE3, 0x81, 0xBD, FIL_, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x81, 0xBC, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x82, 0x9E, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x83, 0xB4, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x82, 0xAC, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0xAE, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0xB0,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82,
		0xB2, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x82, 0xB4, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x82, 0xB6, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x82, 0xB8, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x82, 0xBA, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x82, 0xBC, FIL_, 0x01,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x82, 0xBE, FIL_,
		0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0x80,
		FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83,
		0x82, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x83, 0x85, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x83, 0x87, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x83, 0x89, FIL_, 0x02, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x83, 0x90, FIL_, 0xE3, 0x82,
		0x9A, FIL_, 0xE3, 0x83, 0x91, FIL_, 0x02, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x83, 0x93, FIL_, 0xE3,
		0x82, 0x9A, FIL_, 0xE3, 0x83, 0x94, FIL_, 0x02,
		0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x83, 0x97, FIL_,
		0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0x96, FIL_,
		0x02, 0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x83, 0x9A,
		FIL_, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83, 0x99,
		FIL_, 0x02, 0xE3, 0x82, 0x99, FIL_, 0xE3, 0x83,
		0x9C, FIL_, 0xE3, 0x82, 0x9A, FIL_, 0xE3, 0x83,
		0x9D, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_, 0xE3,
		0x83, 0xB7, FIL_, 0x01, 0xE3, 0x82, 0x99, FIL_,
		0xE3, 0x83, 0xB8, FIL_, 0x01, 0xE3, 0x82, 0x99,
		FIL_, 0xE3, 0x83, 0xB9, FIL_, 0x01, 0xE3, 0x82,
		0x99, FIL_, 0xE3, 0x83, 0xBA, FIL_, 0x01, 0xE3,
		0x82, 0x99, FIL_, 0xE3, 0x83, 0xBE, FIL_,
	},
};

static const uchar_t u8_decomp_b2_tbl[2][2][256] = {
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 5,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 6,  N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 7,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},
	{
		{
			0,  N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			1,  2,  3,  4,  N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 5,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},
		{
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, 6,  N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, 7,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
			N_, N_, N_, N_, N_, N_, N_, N_,
		},

	},

};

static const u8_displacement_t u8_decomp_b3_tbl[2][8][256] = {
	{
		{	/* Third byte table 0. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0, 0 },
			{ 1, 35 }, { 2, 247 }, { 3, 474 },
			{ 4, 693 }, { 5, 709 }, { 6, 951 },
			{ N_, 0 }, { 7, 1139 }, { 8, 1152 },
			{ N_, 0 }, { 9, 1177 }, { 10, 1199 },
			{ 11, 1295 }, { 12, 1360 }, { 13, 1405 },
			{ N_, 0 }, { 14, 1450 }, { N_, 0 },
			{ N_, 0 }, { 15, 1620 }, { N_, 0 },
			{ 16, 1624 }, { 17, 1649 }, { N_, 0 },
			{ 18, 1665 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 1. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 19, 1680 },
			{ 20, 1701 }, { N_, 0 }, { 21, 1757 },
			{ 22, 1792 }, { 23, 1806 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 24, 1834 },
			{ 25, 1869 }, { 26, 1876 }, { N_, 0 },
			{ 27, 1897 }, { N_, 0 }, { 28, 1904 },
			{ N_, 0 }, { 29, 1942 }, { N_, 0 },
			{ 30, 1963 }, { 31, 1994 }, { N_, 0 },
			{ 32, 2000 }, { 33, 2006 }, { 34, 2018 },
			{ 35, 2021 }, { 36, 2109 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 2. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 37, 2158 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 0x8000, 2165 }, { 0x8001, 2445 },
			{ 0x8002, 2741 }, { 0x8003, 3029 }, { 0x8004, 3337 },
			{ 0x8005, 3725 }, { 0x8006, 4053 }, { 0x8007, 4536 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 3. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 38, 4895 },
			{ 39, 4964 }, { 40, 4999 }, { N_, 0 },
			{ 41, 5018 }, { 42, 5098 }, { 43, 5230 },
			{ 44, 5248 }, { 45, 5266 }, { 46, 5326 },
			{ 47, 5410 }, { 48, 5470 }, { 49, 5518 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 50, 5526 }, { 51, 5596 },
			{ 52, 5767 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 53, 5810 }, { 54, 5822 }, { N_, 0 },
			{ 55, 5830 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 56, 5836 }, { 57, 5839 }, { 58, 5842 },
			{ 59, 6034 }, { 60, 6226 }, { 61, 6418 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 4. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 62, 6484 },
			{ 63, 6497 }, { 64, 6672 }, { 65, 6770 },
			{ 66, 6923 }, { 67, 6968 }, { 68, 7160 },
			{ N_, 0 }, { 0x8008, 7247 }, { 69, 7597 },
			{ 70, 7773 }, { 71, 7950 }, { 0x8009, 8142 },
			{ 0x800A, 8919 }, { 72, 9351 }, { 73, 9522 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 5. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0x800B, 9743 },
			{ 0x800C, 9999 }, { 0x800D, 10255 }, { 0x800E, 10511 },
			{ 74, 10767 }, { 75, 10967 }, { N_, 0 },
			{ N_, 0 }, { 76, 11139 }, { 77, 11303 },
			{ 78, 11468 }, { 79, 11576 }, { 0x800F, 11740 },
			{ 0x8010, 12006 }, { 0x8011, 12280 }, { 0x8012, 12546 },
			{ 80, 12812 }, { 0x8013, 13060 }, { 0x8014, 13348 },
			{ 81, 13720 }, { 82, 13898 }, { 83, 13933 },
			{ 84, 14045 }, { 85, 14197 }, { 86, 14347 },
			{ 87, 14410 }, { 88, 14540 }, { 89, 14729 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 6. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 90, 14829 }, { 91, 14912 },
			{ 92, 14969 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 93, 14982 }, { 94, 15046 }, { 95, 15109 },
			{ 96, 15163 }, { 97, 15225 }, { 98, 15282 },
			{ 99, 15341 }, { 100, 15405 }, { 101, 15469 },
			{ 102, 15533 }, { 103, 15597 }, { 104, 15681 },
			{ 105, 15812 }, { 106, 15942 }, { 107, 16072 },
			{ 108, 16202 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 7. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 0x8015, 16273 }, { 0x8016, 16536 },
			{ 0x8017, 16799 }, { 0x8018, 17064 }, { 0x8019, 17329 },
			{ 0x801A, 17601 }, { 0x801B, 17878 }, { 0x801C, 18147 },
			{ 109, 18419 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
	},
	{
		{	/* Third byte table 0. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0, 0 },
			{ 1, 35 }, { 2, 247 }, { 3, 474 },
			{ 4, 693 }, { 5, 709 }, { 6, 951 },
			{ N_, 0 }, { 7, 1139 }, { 8, 1152 },
			{ N_, 0 }, { 9, 1177 }, { 10, 1199 },
			{ 11, 1295 }, { 12, 1362 }, { 13, 1407 },
			{ N_, 0 }, { 14, 1452 }, { N_, 0 },
			{ N_, 0 }, { 15, 1622 }, { N_, 0 },
			{ 16, 1626 }, { 17, 1651 }, { N_, 0 },
			{ 18, 1667 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 1. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 19, 1682 },
			{ 20, 1703 }, { N_, 0 }, { 21, 1759 },
			{ 22, 1794 }, { 23, 1808 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 24, 1836 },
			{ 25, 1871 }, { 26, 1878 }, { N_, 0 },
			{ 27, 1899 }, { N_, 0 }, { 28, 1906 },
			{ N_, 0 }, { 29, 1944 }, { N_, 0 },
			{ 30, 1965 }, { 31, 1996 }, { N_, 0 },
			{ 32, 2002 }, { 33, 2008 }, { 34, 2020 },
			{ 35, 2023 }, { 36, 2111 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 2. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 37, 2160 },
			{ N_, 0 }, { N_, 0 }, { 38, 2167 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 39, 2170 }, { 40, 2226 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 41, 2247 }, { 42, 2268 }, { 43, 2340 },
			{ N_, 0 }, { 0x8000, 2414 }, { 0x8001, 2694 },
			{ 0x8002, 2990 }, { 0x8003, 3278 }, { 0x8004, 3586 },
			{ 0x8005, 3974 }, { 0x8006, 4302 }, { 0x8007, 4785 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 3. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 44, 5144 },
			{ 45, 5213 }, { 46, 5248 }, { N_, 0 },
			{ 47, 5273 }, { 48, 5358 }, { 49, 5490 },
			{ 50, 5508 }, { 51, 5526 }, { 52, 5586 },
			{ 53, 5670 }, { 54, 5730 }, { 55, 5778 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 56, 5786 }, { 57, 5856 },
			{ 58, 6027 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 59, 6070 }, { 60, 6082 }, { N_, 0 },
			{ 61, 6090 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 62, 6096 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 63, 6099 }, { 64, 6102 }, { 65, 6105 },
			{ 66, 6297 }, { 67, 6489 }, { 68, 6681 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 4. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 69, 6747 },
			{ 70, 6760 }, { 71, 6935 }, { 72, 7033 },
			{ 73, 7186 }, { 74, 7231 }, { 75, 7423 },
			{ N_, 0 }, { 0x8008, 7510 }, { 76, 7891 },
			{ 77, 8103 }, { 78, 8280 }, { 0x8009, 8482 },
			{ 0x800A, 9259 }, { 79, 9701 }, { 80, 9872 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 5. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { 0x800B, 10106 },
			{ 0x800C, 10362 }, { 0x800D, 10618 }, { 0x800E, 10874 },
			{ 81, 11130 }, { 82, 11330 }, { 0x800F, 11566 },
			{ 83, 11822 }, { 84, 11932 }, { 85, 12096 },
			{ 86, 12261 }, { 87, 12369 }, { 0x8010, 12533 },
			{ 0x8011, 12799 }, { 0x8012, 13073 }, { 0x8013, 13339 },
			{ 88, 13605 }, { 0x8014, 13853 }, { 0x8015, 14141 },
			{ 89, 14513 }, { 90, 14691 }, { 91, 14746 },
			{ 92, 14860 }, { 93, 15012 }, { 94, 15162 },
			{ 95, 15225 }, { 96, 15355 }, { 97, 15544 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 6. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 98, 15644 }, { 99, 15727 },
			{ 100, 15784 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ 101, 15797 }, { 102, 15861 }, { 103, 15924 },
			{ 104, 15978 }, { 105, 16041 }, { 106, 16098 },
			{ 107, 16157 }, { 108, 16221 }, { 109, 16285 },
			{ 110, 16349 }, { 111, 16413 }, { 112, 16501 },
			{ 113, 16632 }, { 114, 16762 }, { 115, 16892 },
			{ 116, 17022 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
		{	/* Third byte table 7. */
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { 0x8016, 17097 }, { 0x8017, 17360 },
			{ 0x8018, 17623 }, { 0x8019, 17888 }, { 0x801A, 18153 },
			{ 0x801B, 18425 }, { 0x801C, 18702 }, { 0x801D, 18971 },
			{ 117, 19243 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 }, { N_, 0 }, { N_, 0 },
			{ N_, 0 },
		},
	},
};

static const uchar_t u8_decomp_b4_tbl[2][118][257] = {
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   1,   1,   1,   1,   1,   1,
			1,   4,   4,   5,   5,   5,   5,   5,
			8,   8,   8,   9,   10,  13,  15,  15,
			15,  18,  19,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  24,
			28,  32,  36,  40,  44,  48,  52,  56,
			60,  60,  64,  68,  72,  76,  80,  84,
			84,  84,  88,  92,  96,  100, 104, 104,
			104, 108, 112, 116, 120, 124, 128, 128,
			132, 136, 140, 144, 148, 152, 156, 160,
			164, 164, 168, 172, 176, 180, 184, 188,
			188, 188, 192, 196, 200, 204, 208, 208,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  64,  64,  68,  72,  76,  80,  84,
			88,  92,  96,  100, 104, 108, 112, 116,
			120, 124, 128, 132, 136, 140, 144, 144,
			144, 148, 152, 156, 160, 164, 168, 172,
			176, 180, 180, 182, 184, 188, 192, 196,
			200, 200, 204, 208, 212, 216, 220, 224,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   3,   3,   7,   11,  15,  19,
			23,  27,  30,  30,  30,  34,  38,  42,
			46,  50,  54,  54,  54,  58,  62,  66,
			70,  74,  78,  82,  86,  90,  94,  98,
			102, 106, 110, 114, 118, 122, 126, 126,
			126, 130, 134, 138, 142, 146, 150, 154,
			158, 162, 166, 170, 174, 178, 182, 186,
			190, 194, 198, 202, 206, 210, 214, 218,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			12,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   4,   8,   12,
			14,  16,  18,  20,  22,  24,  28,  32,
			36,  40,  44,  48,  52,  56,  62,  68,
			74,  80,  86,  92,  98,  104, 104, 110,
			116, 122, 128, 133, 138, 138, 138, 142,
			146, 150, 154, 158, 162, 168, 174, 179,
			184, 188, 190, 192, 194, 198, 202, 202,
			202, 206, 210, 216, 222, 227, 232, 237,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 112, 112, 116,
			120, 120, 120, 120, 120, 120, 120, 124,
			128, 132, 136, 142, 148, 154, 160, 164,
			168, 174, 180, 184, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   3,   4,   5,   7,   9,   11,
			12,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  18,
			18,  20,  21,  22,  23,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   6,   9,   14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  17,  17,  17,
			17,  17,  17,  20,  20,  20,  20,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   14,  19,
			22,  27,  32,  37,  37,  42,  42,  47,
			52,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  64,  69,  74,  79,  84,
			89,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   5,   10,  15,  20,  25,
			25,  27,  29,  31,  41,  51,  53,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  57,  59,  61,  61,  63,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,  65,  65,  65,  65,  65,  65,  65,
			65,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  15,  15,  15,
			20,  20,  20,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  15,  15,  15,
			20,  20,  20,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  40,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   5,   10,  10,  10,  10,  10,
			10,  10,  10,  10,  10,  10,  10,  10,
			10,  15,  20,  25,  30,  30,  30,  35,
			40,  40,  40,  45,  50,  55,  60,  65,
			70,  70,  70,  75,  80,  85,  90,  95,
			100, 100, 100, 105, 110, 115, 120, 125,
			130, 135, 140, 145, 150, 155, 160, 160,
			160, 165, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   5,   10,  15,  20,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   4,   8,
			12,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   5,   10,  10,  10,  10,  10,
			10,  10,  10,  10,  10,  10,  10,  10,
			10,  10,  10,  10,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   14,  14,  14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   14,  21,  28,  35,  42,  49,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  21,  28,  28,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   7,   7,   14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   14,  21,  21,  21,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  28,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   7,   7,   7,   7,
			14,  21,  21,  28,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   7,   14,  24,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   14,  14,
			14,  14,  14,  21,  21,  21,  21,  21,
			28,  28,  28,  28,  28,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  49,  49,  56,  63,
			72,  79,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  21,  21,
			21,  21,  21,  28,  28,  28,  28,  28,
			35,  35,  35,  35,  35,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  13,  14,  15,  16,  17,
			18,  19,  20,  21,  21,  21,  21,  21,
			21,  21,  24,  24,  24,  24,  24,  24,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  28,  30,  33,
			33,  33,  33,  33,  33,  33,  33,  33,
			34,  34,  34,  34,  40,  49,  49,  55,
			64,  64,  64,  64,  64,  66,  66,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			2,   4,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			18,  18,  18,  18,  18,  18,  18,  18,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  20,  21,  21,  21,  22,  23,  24,
			25,  26,  27,  28,  31,  32,  33,  34,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  14,  15,  16,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  17,  17,  17,  17,  17,  17,  17,
			17,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,
		},
		{	/* Fourth byte table 41. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   7,   10,  10,  13,  16,
			18,  18,  21,  22,  23,  24,  25,  26,
			28,  29,  30,  31,  32,  32,  33,  35,
			35,  35,  36,  37,  38,  39,  40,  40,
			40,  42,  45,  47,  47,  48,  48,  51,
			51,  52,  52,  54,  58,  59,  60,  60,
			61,  62,  63,  63,  64,  65,  67,  69,
			71,  73,  74,  74,  74,  74,  76,  78,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,  80,  80,  80,  80,  80,  80,  80,
			80,
		},
		{	/* Fourth byte table 42. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   3,   3,   3,   3,   4,   5,
			6,   7,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   13,  18,  23,  28,
			33,  38,  43,  48,  53,  58,  63,  68,
			72,  73,  75,  78,  80,  81,  83,  86,
			90,  92,  93,  95,  98,  99,  100, 101,
			102, 103, 105, 108, 110, 111, 113, 116,
			120, 122, 123, 125, 128, 129, 130, 131,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132,
		},
		{	/* Fourth byte table 43. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   6,   12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,
		},
		{	/* Fourth byte table 44. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   6,   12,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,
		},
		{	/* Fourth byte table 45. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   6,   6,
			6,   6,   12,  12,  12,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  24,  24,  30,
			30,  30,  30,  30,  30,  36,  45,  45,
			51,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,
		},
		{	/* Fourth byte table 46. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   6,   6,   6,   12,  12,  12,
			18,  18,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  28,  28,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  40,  44,
			48,  54,  60,  60,  60,  66,  72,  72,
			72,  78,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,
		},
		{	/* Fourth byte table 47. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  12,  12,  18,  24,  24,
			24,  30,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  42,  48,  54,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,
		},
		{	/* Fourth byte table 48. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  18,  24,  24,  24,  24,
			24,  24,  24,  30,  36,  42,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,
		},
		{	/* Fourth byte table 49. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   4,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,
		},
		{	/* Fourth byte table 50. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   11,  13,  15,  17,  19,  21,
			23,  25,  27,  29,  31,  34,  37,  40,
			43,  46,  49,  52,  55,  58,  62,  66,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,
		},
		{	/* Fourth byte table 51. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  53,  56,  59,  62,  65,  68,
			71,  74,  77,  80,  83,  86,  89,  92,
			95,  98,  101, 104, 107, 110, 113, 116,
			119, 122, 125, 128, 131, 134, 137, 140,
			143, 146, 149, 152, 155, 158, 161, 162,
			163, 164, 165, 166, 167, 168, 169, 170,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171,
		},
		{	/* Fourth byte table 52. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,
		},
		{	/* Fourth byte table 53. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,
		},
		{	/* Fourth byte table 54. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   5,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,
		},
		{	/* Fourth byte table 55. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 56. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 57. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 58. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 59. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 60. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 61. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,
		},
		{	/* Fourth byte table 62. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   4,
			4,   7,   10,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 63. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   14,
			14,  21,  21,  28,  28,  35,  35,  42,
			42,  49,  49,  56,  56,  63,  63,  70,
			70,  77,  77,  84,  84,  84,  91,  91,
			98,  98,  105, 105, 105, 105, 105, 105,
			105, 112, 119, 119, 126, 133, 133, 140,
			147, 147, 154, 161, 161, 168, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175,
		},
		{	/* Fourth byte table 64. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   7,
			7,   7,   7,   7,   11,  15,  15,  22,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  35,  35,  42,
			42,  49,  49,  56,  56,  63,  63,  70,
			70,  77,  77,  84,  84,  91,  91,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,
		},
		{	/* Fourth byte table 65. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   14,  14,  14,  21,  21,
			28,  28,  35,  35,  35,  35,  35,  35,
			35,  42,  49,  49,  56,  63,  63,  70,
			77,  77,  84,  91,  91,  98,  105, 105,
			105, 105, 105, 105, 105, 105, 105, 105,
			105, 105, 105, 105, 105, 105, 105, 105,
			105, 105, 105, 105, 105, 112, 112, 112,
			119, 126, 133, 140, 140, 140, 140, 147,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153,
		},
		{	/* Fourth byte table 66. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   3,   6,   9,   12,  15,  18,
			21,  24,  27,  30,  33,  36,  39,  42,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 67. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 68. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			45,  45,  45,  48,  51,  54,  57,  60,
			63,  66,  69,  72,  75,  78,  81,  84,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,
		},
		{	/* Fourth byte table 69. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  15,  20,  20,  20,  20,
			20,  20,  20,  20,  20,  20,  20,  20,
			20,  20,  22,  24,  26,  28,  30,  32,
			34,  36,  38,  40,  42,  44,  46,  48,
			50,  53,  56,  59,  62,  65,  68,  71,
			74,  77,  80,  83,  86,  89,  92,  98,
			104, 110, 116, 122, 128, 134, 140, 146,
			152, 158, 164, 170, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176, 176, 176, 176, 176, 176, 176, 176,
			176,
		},
		{	/* Fourth byte table 70. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 149, 151, 153, 155, 157, 159,
			161, 163, 165, 167, 169, 171, 173, 175,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177,
		},
		{	/* Fourth byte table 71. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  41,  46,  51,  51,  51,  51,
			51,  54,  57,  60,  63,  66,  69,  72,
			75,  78,  81,  84,  87,  90,  93,  96,
			99,  102, 105, 108, 111, 114, 117, 120,
			123, 126, 129, 132, 135, 138, 141, 144,
			147, 150, 153, 156, 159, 162, 165, 168,
			171, 174, 177, 180, 183, 186, 189, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 72. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   7,   9,   11,  13,  15,
			17,  20,  24,  26,  28,  31,  34,  36,
			38,  40,  43,  46,  49,  52,  55,  57,
			59,  61,  63,  65,  68,  70,  72,  74,
			77,  80,  82,  85,  88,  91,  93,  96,
			101, 107, 109, 112, 115, 118, 121, 128,
			136, 138, 140, 143, 145, 147, 149, 152,
			154, 156, 158, 160, 162, 165, 167, 169,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171,
		},
		{	/* Fourth byte table 73. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   10,  12,  14,  16,  22,
			25,  27,  29,  31,  33,  35,  37,  39,
			41,  43,  45,  48,  50,  52,  55,  58,
			60,  64,  67,  69,  71,  73,  75,  75,
			75,  79,  83,  87,  91,  95,  99,  103,
			107, 111, 116, 121, 126, 131, 136, 141,
			146, 151, 156, 161, 166, 171, 176, 181,
			186, 191, 196, 201, 206, 211, 216, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221, 221, 221, 221, 221, 221, 221, 221,
			221,
		},
		{	/* Fourth byte table 74. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  56,
			56,  60,  60,  64,  64,  64,  68,  72,
			76,  80,  84,  88,  92,  96,  100, 104,
			104, 108, 108, 112, 112, 112, 116, 120,
			120, 120, 120, 124, 128, 132, 136, 136,
			136, 140, 144, 148, 152, 156, 160, 164,
			168, 172, 176, 180, 184, 188, 192, 196,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200,
		},
		{	/* Fourth byte table 75. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 116, 120, 124,
			128, 132, 136, 140, 144, 148, 152, 156,
			160, 164, 168, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172, 172, 172, 172, 172, 172, 172, 172,
			172,
		},
		{	/* Fourth byte table 76. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   9,   12,  14,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  20,  24,  28,  32,
			36,  36,  36,  36,  36,  36,  41,  41,
			46,  48,  50,  52,  54,  56,  58,  60,
			62,  64,  65,  70,  75,  82,  89,  94,
			99,  104, 109, 114, 119, 124, 129, 134,
			134, 139, 144, 149, 154, 159, 159, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164,
		},
		{	/* Fourth byte table 77. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  20,  20,  25,
			30,  35,  40,  45,  50,  55,  60,  65,
			69,  71,  73,  75,  77,  79,  81,  83,
			85,  87,  89,  91,  93,  95,  97,  99,
			101, 103, 105, 107, 109, 111, 113, 115,
			117, 119, 121, 123, 125, 127, 129, 131,
			133, 135, 137, 139, 141, 143, 145, 147,
			149, 151, 153, 155, 157, 159, 161, 163,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165,
		},
		{	/* Fourth byte table 78. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  52,  54,  56,  58,  60,  62,
			64,  66,  68,  70,  72,  76,  80,  82,
			84,  86,  88,  90,  92,  94,  96,  98,
			100, 104, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108,
		},
		{	/* Fourth byte table 79. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   2,   4,   6,   8,
			10,  12,  14,  16,  18,  20,  24,  26,
			28,  30,  32,  34,  36,  38,  40,  42,
			44,  46,  48,  54,  60,  66,  72,  78,
			84,  90,  96,  102, 108, 114, 120, 126,
			132, 138, 144, 150, 156, 158, 160, 162,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164,
		},
		{	/* Fourth byte table 80. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 116, 120, 124,
			128, 132, 136, 140, 144, 148, 152, 156,
			160, 164, 168, 172, 176, 180, 184, 188,
			192, 196, 200, 204, 208, 212, 216, 220,
			224, 228, 232, 236, 240, 244, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248,
		},
		{	/* Fourth byte table 81. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  18,  24,  30,  36,  42,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  54,  60,  68,  76,  84,  92,  100,
			108, 116, 122, 155, 170, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178,
		},
		{	/* Fourth byte table 82. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   5,   8,   9,   10,  11,  12,
			13,  14,  17,  20,  23,  26,  29,  32,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 83. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  15,  15,
			15,  15,  18,  21,  24,  27,  28,  29,
			30,  31,  34,  35,  35,  36,  37,  38,
			39,  42,  43,  44,  45,  46,  49,  52,
			53,  54,  55,  56,  57,  58,  59,  60,
			60,  61,  62,  63,  64,  64,  64,  64,
			64,  67,  71,  74,  74,  77,  77,  80,
			84,  87,  91,  94,  98,  101, 105, 108,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112, 112, 112, 112, 112, 112, 112, 112,
			112,
		},
		{	/* Fourth byte table 84. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   6,   10,  14,  18,  22,  26,
			30,  34,  38,  42,  46,  50,  52,  54,
			56,  58,  60,  62,  64,  66,  68,  70,
			72,  74,  76,  78,  80,  82,  84,  86,
			88,  90,  92,  94,  96,  98,  100, 102,
			104, 106, 108, 110, 112, 114, 116, 118,
			120, 122, 124, 126, 128, 130, 132, 134,
			136, 138, 140, 142, 144, 146, 148, 150,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152,
		},
		{	/* Fourth byte table 85. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  52,  54,  56,  58,  60,  62,
			64,  66,  68,  70,  72,  74,  76,  78,
			80,  82,  84,  86,  88,  90,  92,  94,
			96,  98,  100, 102, 104, 106, 112, 118,
			124, 130, 136, 142, 146, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150,
		},
		{	/* Fourth byte table 86. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   1,   2,   3,   4,   5,   6,
			7,   8,   9,   10,  11,  12,  13,  14,
			15,  16,  17,  18,  19,  20,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,
		},
		{	/* Fourth byte table 87. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			34,  37,  40,  43,  46,  49,  52,  55,
			58,  61,  64,  67,  70,  73,  76,  79,
			82,  85,  88,  91,  94,  97,  100, 103,
			106, 109, 112, 115, 118, 121, 124, 127,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 88. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189,
		},
		{	/* Fourth byte table 89. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   3,   6,   9,   12,  15,
			18,  18,  18,  21,  24,  27,  30,  33,
			36,  36,  36,  39,  42,  45,  48,  51,
			54,  54,  54,  57,  60,  63,  63,  63,
			63,  65,  67,  69,  72,  74,  76,  79,
			79,  82,  85,  88,  91,  94,  97,  100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100,
		},
		{	/* Fourth byte table 90. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			18,  31,  44,  57,  70,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,
		},
		{	/* Fourth byte table 91. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   18,  31,  44,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,
		},
		{	/* Fourth byte table 92. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 93. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 94. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,
		},
		{	/* Fourth byte table 95. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  29,  30,
			31,  31,  31,  32,  32,  32,  33,  34,
			34,  34,  35,  36,  37,  38,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  50,  51,  51,  52,  53,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,
		},
		{	/* Fourth byte table 96. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   1,   2,   3,   3,   4,   5,
			6,   7,   8,   9,   10,  11,  12,  13,
			14,  15,  16,  17,  18,  19,  20,  21,
			22,  23,  24,  25,  26,  27,  28,  29,
			30,  31,  32,  33,  34,  35,  36,  37,
			38,  39,  40,  41,  42,  43,  44,  45,
			46,  47,  48,  49,  50,  51,  52,  53,
			54,  55,  56,  57,  58,  59,  60,  61,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,  62,  62,  62,  62,  62,  62,  62,
			62,
		},
		{	/* Fourth byte table 97. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   6,
			7,   8,   9,   10,  10,  10,  11,  12,
			13,  14,  15,  16,  17,  18,  18,  19,
			20,  21,  22,  23,  24,  25,  25,  26,
			27,  28,  29,  30,  31,  32,  33,  34,
			35,  36,  37,  38,  39,  40,  41,  42,
			43,  44,  45,  46,  47,  48,  49,  50,
			51,  52,  53,  53,  54,  55,  56,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,
		},
		{	/* Fourth byte table 98. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   5,   6,
			6,   6,   6,   7,   8,   9,   10,  11,
			12,  13,  13,  14,  15,  16,  17,  18,
			19,  20,  21,  22,  23,  24,  25,  26,
			27,  28,  29,  30,  31,  32,  33,  34,
			35,  36,  37,  38,  39,  40,  41,  42,
			43,  44,  45,  46,  47,  48,  49,  50,
			51,  52,  53,  54,  55,  56,  57,  58,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,
		},
		{	/* Fourth byte table 99. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 100. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 101. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 102. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 103. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  36,  36,  36,
			36,  38,  40,  42,  44,  46,  48,  50,
			52,  54,  56,  58,  60,  62,  64,  66,
			68,  70,  72,  74,  76,  78,  80,  82,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,
		},
		{	/* Fourth byte table 104. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   5,   7,   9,   11,  13,  15,
			17,  19,  21,  23,  25,  27,  29,  31,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  58,  60,  62,  64,
			66,  68,  70,  72,  74,  76,  78,  80,
			82,  84,  86,  88,  90,  92,  94,  96,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 123, 125, 127, 129,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131,
		},
		{	/* Fourth byte table 105. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  85,  87,  89,  91,  93,  95,
			97,  99,  101, 103, 105, 107, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 106. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  85,  87,  89,  91,  93,  95,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 107. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  21,  23,  25,  27,  29,  31,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  86,  88,  90,  92,  94,  96,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 108. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   9,   11,  13,  15,
			17,  19,  21,  21,  21,  21,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  64,  65,  66,  67,  68,  69,  70,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,  71,  71,  71,  71,  71,  71,  71,
			71,
		},
		{	/* Fourth byte table 109. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   9,   13,  17,  21,  25,  29,
			33,  37,  42,  46,  50,  54,  58,  62,
			66,  71,  75,  80,  85,  90,  94,  98,
			102, 106, 110, 114, 118, 122, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127,
		},
		{	/* Fourth byte table 110. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 111. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 112. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 113. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 114. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 115. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 116. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
		{	/* Fourth byte table 117. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,
		},
	},
	{
		{	/* Fourth byte table 0. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   1,   1,   1,   1,   1,   1,
			1,   4,   4,   5,   5,   5,   5,   5,
			8,   8,   8,   9,   10,  13,  15,  15,
			15,  18,  19,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 1. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  24,
			28,  32,  36,  40,  44,  48,  52,  56,
			60,  60,  64,  68,  72,  76,  80,  84,
			84,  84,  88,  92,  96,  100, 104, 104,
			104, 108, 112, 116, 120, 124, 128, 128,
			132, 136, 140, 144, 148, 152, 156, 160,
			164, 164, 168, 172, 176, 180, 184, 188,
			188, 188, 192, 196, 200, 204, 208, 208,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212,
		},
		{	/* Fourth byte table 2. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  64,  64,  68,  72,  76,  80,  84,
			88,  92,  96,  100, 104, 108, 112, 116,
			120, 124, 128, 132, 136, 140, 144, 144,
			144, 148, 152, 156, 160, 164, 168, 172,
			176, 180, 180, 182, 184, 188, 192, 196,
			200, 200, 204, 208, 212, 216, 220, 224,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227, 227, 227, 227, 227, 227, 227, 227,
			227,
		},
		{	/* Fourth byte table 3. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   3,   3,   7,   11,  15,  19,
			23,  27,  30,  30,  30,  34,  38,  42,
			46,  50,  54,  54,  54,  58,  62,  66,
			70,  74,  78,  82,  86,  90,  94,  98,
			102, 106, 110, 114, 118, 122, 126, 126,
			126, 130, 134, 138, 142, 146, 150, 154,
			158, 162, 166, 170, 174, 178, 182, 186,
			190, 194, 198, 202, 206, 210, 214, 218,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219, 219, 219, 219, 219, 219, 219, 219,
			219,
		},
		{	/* Fourth byte table 4. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			12,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 5. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   4,   8,   12,
			14,  16,  18,  20,  22,  24,  28,  32,
			36,  40,  44,  48,  52,  56,  62,  68,
			74,  80,  86,  92,  98,  104, 104, 110,
			116, 122, 128, 133, 138, 138, 138, 142,
			146, 150, 154, 158, 162, 168, 174, 179,
			184, 188, 190, 192, 194, 198, 202, 202,
			202, 206, 210, 216, 222, 227, 232, 237,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242, 242, 242, 242, 242, 242, 242, 242,
			242,
		},
		{	/* Fourth byte table 6. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 112, 112, 116,
			120, 120, 120, 120, 120, 120, 120, 124,
			128, 132, 136, 142, 148, 154, 160, 164,
			168, 174, 180, 184, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188, 188, 188, 188, 188, 188, 188, 188,
			188,
		},
		{	/* Fourth byte table 7. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   3,   4,   5,   7,   9,   11,
			12,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 8. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  18,
			18,  20,  21,  22,  23,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 9. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   6,   9,   14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  17,  17,  17,
			17,  17,  17,  20,  20,  20,  20,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,  22,  22,  22,  22,  22,  22,  22,
			22,
		},
		{	/* Fourth byte table 10. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   14,  19,
			22,  27,  32,  37,  37,  42,  42,  47,
			52,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  64,  69,  74,  79,  84,
			89,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,  96,  96,  96,  96,  96,  96,  96,
			96,
		},
		{	/* Fourth byte table 11. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   5,   10,  15,  20,  25,
			25,  27,  29,  31,  41,  51,  53,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  57,  59,  61,  61,  63,  65,  65,
			65,  65,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,  67,  67,  67,  67,  67,  67,  67,
			67,
		},
		{	/* Fourth byte table 12. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  15,  15,  15,
			20,  20,  20,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  40,  40,  40,  40,  40,  40,
			40,  40,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 13. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  15,  15,  15,
			20,  20,  20,  20,  20,  25,  30,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  40,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 14. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   5,   10,  10,  10,  10,  10,
			10,  10,  10,  10,  10,  10,  10,  10,
			10,  15,  20,  25,  30,  30,  30,  35,
			40,  40,  40,  45,  50,  55,  60,  65,
			70,  70,  70,  75,  80,  85,  90,  95,
			100, 100, 100, 105, 110, 115, 120, 125,
			130, 135, 140, 145, 150, 155, 160, 160,
			160, 165, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170, 170, 170, 170, 170, 170, 170, 170,
			170,
		},
		{	/* Fourth byte table 15. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,   4,   4,   4,   4,   4,   4,   4,
			4,
		},
		{	/* Fourth byte table 16. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   5,   10,  15,  20,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 17. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   4,   8,
			12,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,
		},
		{	/* Fourth byte table 18. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   5,   10,  10,  10,  10,  10,
			10,  10,  10,  10,  10,  10,  10,  10,
			10,  10,  10,  10,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,  15,  15,  15,  15,  15,  15,  15,
			15,
		},
		{	/* Fourth byte table 19. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   14,  14,  14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 20. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   14,  21,  28,  35,  42,  49,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,
		},
		{	/* Fourth byte table 21. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  21,  28,  28,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 22. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   7,   7,   14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  14,  14,
			14,
		},
		{	/* Fourth byte table 23. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   14,  21,  21,  21,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,
		},
		{	/* Fourth byte table 24. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  28,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 25. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 26. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 27. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 28. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   7,   7,   7,   7,   7,
			14,  21,  21,  28,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,  38,  38,  38,  38,  38,  38,  38,
			38,
		},
		{	/* Fourth byte table 29. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   14,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 30. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   7,   7,   14,  24,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,  31,  31,  31,  31,  31,  31,  31,
			31,
		},
		{	/* Fourth byte table 31. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 32. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 33. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,
		},
		{	/* Fourth byte table 34. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 35. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   14,  14,
			14,  14,  14,  21,  21,  21,  21,  21,
			28,  28,  28,  28,  28,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  49,  49,  56,  63,
			72,  79,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,
		},
		{	/* Fourth byte table 36. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   14,  14,  14,  14,
			14,  14,  14,  14,  14,  14,  21,  21,
			21,  21,  21,  28,  28,  28,  28,  28,
			35,  35,  35,  35,  35,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,  49,  49,  49,  49,  49,  49,  49,
			49,
		},
		{	/* Fourth byte table 37. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,   7,   7,   7,   7,   7,   7,   7,
			7,
		},
		{	/* Fourth byte table 38. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 39. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   7,
			7,   14,  14,  21,  21,  28,  28,  35,
			35,  35,  35,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  42,  42,  42,  42,
			42,  42,  42,  42,  49,  49,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,  56,  56,  56,  56,  56,  56,  56,
			56,
		},
		{	/* Fourth byte table 40. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   14,  14,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 41. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   1,   3,   4,
			4,   5,   6,   8,   9,   10,  11,  12,
			13,  14,  15,  16,  16,  17,  19,  20,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,  21,  21,  21,  21,  21,  21,  21,
			21,
		},
		{	/* Fourth byte table 42. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   6,   8,   11,
			12,  13,  14,  16,  18,  20,  21,  21,
			22,  23,  25,  26,  28,  31,  34,  35,
			36,  37,  40,  42,  43,  46,  48,  50,
			52,  54,  56,  57,  58,  59,  60,  62,
			64,  66,  68,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,  72,  72,  72,  72,  72,  72,  72,
			72,
		},
		{	/* Fourth byte table 43. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   2,   3,   5,   7,
			9,   10,  12,  14,  16,  18,  20,  22,
			25,  27,  29,  32,  34,  36,  38,  40,
			42,  44,  46,  48,  50,  52,  54,  56,
			58,  61,  63,  65,  66,  68,  70,  72,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,  74,  74,  74,  74,  74,  74,  74,
			74,
		},
		{	/* Fourth byte table 44. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  13,  14,  15,  16,  17,
			18,  19,  20,  21,  21,  21,  21,  21,
			21,  21,  24,  24,  24,  24,  24,  24,
			27,  27,  27,  27,  27,  27,  27,  27,
			27,  27,  27,  27,  27,  28,  30,  33,
			33,  33,  33,  33,  33,  33,  33,  33,
			34,  34,  34,  34,  40,  49,  49,  55,
			64,  64,  64,  64,  64,  66,  66,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,  69,  69,  69,  69,  69,  69,  69,
			69,
		},
		{	/* Fourth byte table 45. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			2,   4,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			18,  18,  18,  18,  18,  18,  18,  18,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  19,  19,  19,  19,  19,  19,  19,
			19,  20,  21,  21,  21,  22,  23,  24,
			25,  26,  27,  28,  31,  32,  33,  34,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,  35,  35,  35,  35,  35,  35,  35,
			35,
		},
		{	/* Fourth byte table 46. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  14,  15,  16,  17,
			17,  18,  19,  20,  21,  23,  23,  23,
			23,  23,  23,  23,  23,  23,  23,  23,
			23,  23,  23,  23,  23,  23,  23,  23,
			23,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,  25,  25,  25,  25,  25,  25,  25,
			25,
		},
		{	/* Fourth byte table 47. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   7,   10,  10,  13,  16,
			18,  18,  21,  22,  23,  24,  25,  26,
			28,  29,  30,  31,  32,  32,  33,  35,
			35,  35,  36,  37,  38,  39,  40,  40,
			40,  42,  45,  47,  47,  48,  48,  51,
			51,  52,  52,  54,  58,  59,  60,  60,
			61,  62,  63,  63,  64,  65,  67,  69,
			71,  73,  74,  74,  77,  79,  81,  83,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,  85,  85,  85,  85,  85,  85,  85,
			85,
		},
		{	/* Fourth byte table 48. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   3,   3,   3,   3,   4,   5,
			6,   7,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   13,  18,  23,  28,
			33,  38,  43,  48,  53,  58,  63,  68,
			72,  73,  75,  78,  80,  81,  83,  86,
			90,  92,  93,  95,  98,  99,  100, 101,
			102, 103, 105, 108, 110, 111, 113, 116,
			120, 122, 123, 125, 128, 129, 130, 131,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132, 132, 132, 132, 132, 132, 132, 132,
			132,
		},
		{	/* Fourth byte table 49. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   6,   12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,
		},
		{	/* Fourth byte table 50. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   6,   12,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,
		},
		{	/* Fourth byte table 51. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   6,   6,
			6,   6,   12,  12,  12,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  18,  18,  18,
			18,  18,  18,  18,  18,  24,  24,  30,
			30,  30,  30,  30,  30,  36,  45,  45,
			51,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,
		},
		{	/* Fourth byte table 52. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   6,   6,   6,   12,  12,  12,
			18,  18,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  24,  24,  24,  24,  24,  24,  24,
			24,  28,  28,  34,  34,  34,  34,  34,
			34,  34,  34,  34,  34,  34,  40,  44,
			48,  54,  60,  60,  60,  66,  72,  72,
			72,  78,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,  84,  84,  84,  84,  84,  84,  84,
			84,
		},
		{	/* Fourth byte table 53. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  12,  12,  18,  24,  24,
			24,  30,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  36,  36,  36,
			36,  36,  36,  36,  36,  42,  48,  54,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,  60,  60,  60,  60,  60,  60,  60,
			60,
		},
		{	/* Fourth byte table 54. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  18,  24,  24,  24,  24,
			24,  24,  24,  30,  36,  42,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,
		},
		{	/* Fourth byte table 55. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   4,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,
		},
		{	/* Fourth byte table 56. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   11,  13,  15,  17,  19,  21,
			23,  25,  27,  29,  31,  34,  37,  40,
			43,  46,  49,  52,  55,  58,  62,  66,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,  70,  70,  70,  70,  70,  70,  70,
			70,
		},
		{	/* Fourth byte table 57. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  53,  56,  59,  62,  65,  68,
			71,  74,  77,  80,  83,  86,  89,  92,
			95,  98,  101, 104, 107, 110, 113, 116,
			119, 122, 125, 128, 131, 134, 137, 140,
			143, 146, 149, 152, 155, 158, 161, 162,
			163, 164, 165, 166, 167, 168, 169, 170,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171,
		},
		{	/* Fourth byte table 58. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,  43,  43,  43,  43,  43,  43,  43,
			43,
		},
		{	/* Fourth byte table 59. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,  12,  12,  12,  12,  12,  12,  12,
			12,
		},
		{	/* Fourth byte table 60. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   3,   5,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,   8,   8,   8,   8,   8,   8,   8,
			8,
		},
		{	/* Fourth byte table 61. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,   6,   6,   6,   6,   6,   6,   6,
			6,
		},
		{	/* Fourth byte table 62. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 63. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 64. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,   3,   3,   3,   3,   3,   3,   3,
			3,
		},
		{	/* Fourth byte table 65. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 66. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 67. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 68. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,  66,  66,  66,  66,  66,  66,  66,
			66,
		},
		{	/* Fourth byte table 69. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   1,
			1,   1,   1,   1,   1,   1,   1,   4,
			4,   7,   10,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 70. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   14,
			14,  21,  21,  28,  28,  35,  35,  42,
			42,  49,  49,  56,  56,  63,  63,  70,
			70,  77,  77,  84,  84,  84,  91,  91,
			98,  98,  105, 105, 105, 105, 105, 105,
			105, 112, 119, 119, 126, 133, 133, 140,
			147, 147, 154, 161, 161, 168, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175, 175, 175, 175, 175, 175, 175, 175,
			175,
		},
		{	/* Fourth byte table 71. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   7,   7,   7,
			7,   7,   7,   7,   11,  15,  15,  22,
			28,  28,  28,  28,  28,  28,  28,  28,
			28,  28,  28,  28,  28,  35,  35,  42,
			42,  49,  49,  56,  56,  63,  63,  70,
			70,  77,  77,  84,  84,  91,  91,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,  98,  98,  98,  98,  98,  98,  98,
			98,
		},
		{	/* Fourth byte table 72. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   7,   7,   14,  14,  14,  21,  21,
			28,  28,  35,  35,  35,  35,  35,  35,
			35,  42,  49,  49,  56,  63,  63,  70,
			77,  77,  84,  91,  91,  98,  105, 105,
			105, 105, 105, 105, 105, 105, 105, 105,
			105, 105, 105, 105, 105, 105, 105, 105,
			105, 105, 105, 105, 105, 112, 112, 112,
			119, 126, 133, 140, 140, 140, 140, 147,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153, 153, 153, 153, 153, 153, 153, 153,
			153,
		},
		{	/* Fourth byte table 73. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   3,   6,   9,   12,  15,  18,
			21,  24,  27,  30,  33,  36,  39,  42,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,  45,  45,  45,  45,  45,  45,  45,
			45,
		},
		{	/* Fourth byte table 74. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192, 192, 192, 192, 192, 192, 192, 192,
			192,
		},
		{	/* Fourth byte table 75. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			45,  45,  45,  48,  51,  54,  57,  60,
			63,  66,  69,  72,  75,  78,  81,  84,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,  87,  87,  87,  87,  87,  87,  87,
			87,
		},
		{	/* Fourth byte table 76. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  15,  20,  20,  20,  20,
			20,  20,  20,  20,  20,  20,  20,  20,
			20,  23,  25,  27,  29,  31,  33,  35,
			37,  39,  41,  43,  45,  47,  49,  51,
			53,  56,  59,  62,  65,  68,  71,  74,
			77,  80,  83,  86,  89,  92,  95,  101,
			107, 113, 119, 125, 131, 137, 143, 149,
			155, 161, 167, 173, 179, 194, 206, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212, 212, 212, 212, 212, 212, 212, 212,
			212,
		},
		{	/* Fourth byte table 77. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 149, 151, 153, 155, 157, 159,
			161, 163, 165, 167, 169, 171, 173, 175,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177, 177, 177, 177, 177, 177, 177, 177,
			177,
		},
		{	/* Fourth byte table 78. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  41,  46,  51,  53,  56,  58,
			61,  64,  67,  70,  73,  76,  79,  82,
			85,  88,  91,  94,  97,  100, 103, 106,
			109, 112, 115, 118, 121, 124, 127, 130,
			133, 136, 139, 142, 145, 148, 151, 154,
			157, 160, 163, 166, 169, 172, 175, 178,
			181, 184, 187, 190, 193, 196, 199, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202, 202, 202, 202, 202, 202, 202, 202,
			202,
		},
		{	/* Fourth byte table 79. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   7,   9,   11,  13,  15,
			17,  20,  24,  26,  28,  31,  34,  36,
			38,  40,  43,  46,  49,  52,  55,  57,
			59,  61,  63,  65,  68,  70,  72,  74,
			77,  80,  82,  85,  88,  91,  93,  96,
			101, 107, 109, 112, 115, 118, 121, 128,
			136, 138, 140, 143, 145, 147, 149, 152,
			154, 156, 158, 160, 162, 165, 167, 169,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171, 171, 171, 171, 171, 171, 171, 171,
			171,
		},
		{	/* Fourth byte table 80. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   10,  12,  14,  16,  22,
			25,  27,  29,  31,  33,  35,  37,  39,
			41,  43,  45,  48,  50,  52,  55,  58,
			60,  64,  67,  69,  71,  73,  75,  80,
			85,  89,  93,  97,  101, 105, 109, 113,
			117, 121, 126, 131, 136, 141, 146, 151,
			156, 161, 166, 171, 176, 181, 186, 191,
			196, 201, 206, 211, 216, 221, 226, 231,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234, 234, 234, 234, 234, 234, 234, 234,
			234,
		},
		{	/* Fourth byte table 81. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  56,
			56,  60,  60,  64,  64,  64,  68,  72,
			76,  80,  84,  88,  92,  96,  100, 104,
			104, 108, 108, 112, 112, 112, 116, 120,
			120, 120, 120, 124, 128, 132, 136, 136,
			136, 140, 144, 148, 152, 156, 160, 164,
			168, 172, 176, 180, 184, 188, 192, 196,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200, 200, 200, 200, 200, 200, 200, 200,
			200,
		},
		{	/* Fourth byte table 82. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 116, 120, 124,
			128, 132, 136, 140, 144, 148, 152, 156,
			160, 164, 168, 172, 172, 172, 172, 172,
			172, 176, 180, 184, 188, 192, 196, 200,
			204, 208, 212, 216, 220, 224, 228, 232,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236, 236, 236, 236, 236, 236, 236, 236,
			236,
		},
		{	/* Fourth byte table 83. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			65,  70,  75,  79,  83,  87,  92,  97,
			102, 106, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110, 110, 110, 110, 110, 110, 110, 110,
			110,
		},
		{	/* Fourth byte table 84. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   9,   12,  14,  16,
			16,  16,  16,  16,  16,  16,  16,  16,
			16,  16,  16,  16,  20,  24,  28,  32,
			36,  36,  36,  36,  36,  36,  41,  41,
			46,  48,  50,  52,  54,  56,  58,  60,
			62,  64,  65,  70,  75,  82,  89,  94,
			99,  104, 109, 114, 119, 124, 129, 134,
			134, 139, 144, 149, 154, 159, 159, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164,
		},
		{	/* Fourth byte table 85. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   5,   10,  10,  15,  20,  20,  25,
			30,  35,  40,  45,  50,  55,  60,  65,
			69,  71,  73,  75,  77,  79,  81,  83,
			85,  87,  89,  91,  93,  95,  97,  99,
			101, 103, 105, 107, 109, 111, 113, 115,
			117, 119, 121, 123, 125, 127, 129, 131,
			133, 135, 137, 139, 141, 143, 145, 147,
			149, 151, 153, 155, 157, 159, 161, 163,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165, 165, 165, 165, 165, 165, 165, 165,
			165,
		},
		{	/* Fourth byte table 86. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  52,  54,  56,  58,  60,  62,
			64,  66,  68,  70,  72,  76,  80,  82,
			84,  86,  88,  90,  92,  94,  96,  98,
			100, 104, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108, 108, 108, 108, 108, 108, 108, 108,
			108,
		},
		{	/* Fourth byte table 87. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   2,   4,   6,   8,
			10,  12,  14,  16,  18,  20,  24,  26,
			28,  30,  32,  34,  36,  38,  40,  42,
			44,  46,  48,  54,  60,  66,  72,  78,
			84,  90,  96,  102, 108, 114, 120, 126,
			132, 138, 144, 150, 156, 158, 160, 162,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164, 164, 164, 164, 164, 164, 164, 164,
			164,
		},
		{	/* Fourth byte table 88. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   8,   12,  16,  20,  24,  28,
			32,  36,  40,  44,  48,  52,  56,  60,
			64,  68,  72,  76,  80,  84,  88,  92,
			96,  100, 104, 108, 112, 116, 120, 124,
			128, 132, 136, 140, 144, 148, 152, 156,
			160, 164, 168, 172, 176, 180, 184, 188,
			192, 196, 200, 204, 208, 212, 216, 220,
			224, 228, 232, 236, 240, 244, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248, 248, 248, 248, 248, 248, 248, 248,
			248,
		},
		{	/* Fourth byte table 89. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   6,   12,  18,  24,  30,  36,  42,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  48,  48,  48,  48,  48,  48,  48,
			48,  54,  60,  68,  76,  84,  92,  100,
			108, 116, 122, 155, 170, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178, 178, 178, 178, 178, 178, 178, 178,
			178,
		},
		{	/* Fourth byte table 90. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   4,   7,   8,   9,   10,  11,
			14,  17,  20,  20,  20,  20,  20,  20,
			20,  20,  20,  20,  20,  20,  20,  20,
			20,  20,  20,  20,  20,  20,  20,  20,
			20,  22,  25,  28,  29,  30,  31,  32,
			33,  34,  37,  40,  43,  46,  49,  52,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,  55,  55,  55,  55,  55,  55,  55,
			55,
		},
		{	/* Fourth byte table 91. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  15,  15,
			16,  17,  20,  23,  26,  29,  30,  31,
			32,  33,  36,  37,  37,  38,  39,  40,
			41,  44,  45,  46,  47,  48,  51,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			62,  63,  64,  65,  66,  66,  66,  66,
			66,  69,  73,  76,  76,  79,  79,  82,
			86,  89,  93,  96,  100, 103, 107, 110,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114, 114, 114, 114, 114, 114, 114, 114,
			114,
		},
		{	/* Fourth byte table 92. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   6,   10,  14,  18,  22,  26,
			30,  34,  38,  42,  46,  50,  52,  54,
			56,  58,  60,  62,  64,  66,  68,  70,
			72,  74,  76,  78,  80,  82,  84,  86,
			88,  90,  92,  94,  96,  98,  100, 102,
			104, 106, 108, 110, 112, 114, 116, 118,
			120, 122, 124, 126, 128, 130, 132, 134,
			136, 138, 140, 142, 144, 146, 148, 150,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152, 152, 152, 152, 152, 152, 152, 152,
			152,
		},
		{	/* Fourth byte table 93. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  44,  46,
			48,  50,  52,  54,  56,  58,  60,  62,
			64,  66,  68,  70,  72,  74,  76,  78,
			80,  82,  84,  86,  88,  90,  92,  94,
			96,  98,  100, 102, 104, 106, 112, 118,
			124, 130, 136, 142, 146, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150, 150, 150, 150, 150, 150, 150, 150,
			150,
		},
		{	/* Fourth byte table 94. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   1,   2,   3,   4,   5,   6,
			7,   8,   9,   10,  11,  12,  13,  14,
			15,  16,  17,  18,  19,  20,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,
		},
		{	/* Fourth byte table 95. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			34,  37,  40,  43,  46,  49,  52,  55,
			58,  61,  64,  67,  70,  73,  76,  79,
			82,  85,  88,  91,  94,  97,  100, 103,
			106, 109, 112, 115, 118, 121, 124, 127,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 96. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   3,   6,   9,   12,  15,  18,  21,
			24,  27,  30,  33,  36,  39,  42,  45,
			48,  51,  54,  57,  60,  63,  66,  69,
			72,  75,  78,  81,  84,  87,  90,  93,
			96,  99,  102, 105, 108, 111, 114, 117,
			120, 123, 126, 129, 132, 135, 138, 141,
			144, 147, 150, 153, 156, 159, 162, 165,
			168, 171, 174, 177, 180, 183, 186, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189, 189, 189, 189, 189, 189, 189, 189,
			189,
		},
		{	/* Fourth byte table 97. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   3,   6,   9,   12,  15,
			18,  18,  18,  21,  24,  27,  30,  33,
			36,  36,  36,  39,  42,  45,  48,  51,
			54,  54,  54,  57,  60,  63,  63,  63,
			63,  65,  67,  69,  72,  74,  76,  79,
			79,  82,  85,  88,  91,  94,  97,  100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100, 100, 100, 100, 100, 100, 100, 100,
			100,
		},
		{	/* Fourth byte table 98. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   9,
			18,  31,  44,  57,  70,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,  83,  83,  83,  83,  83,  83,  83,
			83,
		},
		{	/* Fourth byte table 99. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   9,   18,  31,  44,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,
		},
		{	/* Fourth byte table 100. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,  13,  13,  13,  13,  13,  13,  13,
			13,
		},
		{	/* Fourth byte table 101. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 102. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,
		},
		{	/* Fourth byte table 103. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  29,  30,
			31,  31,  31,  32,  32,  32,  33,  34,
			34,  34,  35,  36,  37,  38,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  50,  51,  51,  52,  53,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,  54,  54,  54,  54,  54,  54,  54,
			54,
		},
		{	/* Fourth byte table 104. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   4,   5,   6,
			7,   8,   9,   10,  11,  12,  13,  14,
			15,  16,  17,  18,  19,  20,  21,  22,
			23,  24,  25,  26,  27,  28,  29,  30,
			31,  32,  33,  34,  35,  36,  37,  38,
			39,  40,  41,  42,  43,  44,  45,  46,
			47,  48,  49,  50,  51,  52,  53,  54,
			55,  56,  57,  58,  59,  60,  61,  62,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,  63,  63,  63,  63,  63,  63,  63,
			63,
		},
		{	/* Fourth byte table 105. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   6,
			7,   8,   9,   10,  10,  10,  11,  12,
			13,  14,  15,  16,  17,  18,  18,  19,
			20,  21,  22,  23,  24,  25,  25,  26,
			27,  28,  29,  30,  31,  32,  33,  34,
			35,  36,  37,  38,  39,  40,  41,  42,
			43,  44,  45,  46,  47,  48,  49,  50,
			51,  52,  53,  53,  54,  55,  56,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,  57,  57,  57,  57,  57,  57,  57,
			57,
		},
		{	/* Fourth byte table 106. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   5,   6,
			6,   6,   6,   7,   8,   9,   10,  11,
			12,  13,  13,  14,  15,  16,  17,  18,
			19,  20,  21,  22,  23,  24,  25,  26,
			27,  28,  29,  30,  31,  32,  33,  34,
			35,  36,  37,  38,  39,  40,  41,  42,
			43,  44,  45,  46,  47,  48,  49,  50,
			51,  52,  53,  54,  55,  56,  57,  58,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,  59,  59,  59,  59,  59,  59,  59,
			59,
		},
		{	/* Fourth byte table 107. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 108. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 109. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 110. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  37,  38,  39,
			40,  41,  42,  43,  44,  45,  46,  47,
			48,  49,  50,  51,  52,  53,  54,  55,
			56,  57,  58,  59,  60,  61,  62,  63,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,  64,  64,  64,  64,  64,  64,  64,
			64,
		},
		{	/* Fourth byte table 111. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   1,   2,   3,   4,   5,   6,   7,
			8,   9,   10,  11,  12,  13,  14,  15,
			16,  17,  18,  19,  20,  21,  22,  23,
			24,  25,  26,  27,  28,  29,  30,  31,
			32,  33,  34,  35,  36,  38,  40,  40,
			40,  42,  44,  46,  48,  50,  52,  54,
			56,  58,  60,  62,  64,  66,  68,  70,
			72,  74,  76,  78,  80,  82,  84,  86,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,  88,  88,  88,  88,  88,  88,  88,
			88,
		},
		{	/* Fourth byte table 112. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   5,   7,   9,   11,  13,  15,
			17,  19,  21,  23,  25,  27,  29,  31,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  58,  60,  62,  64,
			66,  68,  70,  72,  74,  76,  78,  80,
			82,  84,  86,  88,  90,  92,  94,  96,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 123, 125, 127, 129,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131, 131, 131, 131, 131, 131, 131, 131,
			131,
		},
		{	/* Fourth byte table 113. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			32,  34,  36,  38,  40,  42,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  85,  87,  89,  91,  93,  95,
			97,  99,  101, 103, 105, 107, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 114. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  20,  22,  24,  26,  28,  30,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  85,  87,  89,  91,  93,  95,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 115. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   8,   10,  12,  14,
			16,  18,  21,  23,  25,  27,  29,  31,
			33,  35,  37,  39,  41,  43,  45,  47,
			49,  51,  53,  55,  57,  59,  61,  63,
			65,  67,  69,  71,  73,  75,  77,  79,
			81,  83,  86,  88,  90,  92,  94,  96,
			98,  100, 102, 104, 106, 108, 110, 112,
			114, 116, 118, 120, 122, 124, 126, 128,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130, 130, 130, 130, 130, 130, 130, 130,
			130,
		},
		{	/* Fourth byte table 116. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   2,   4,   6,   9,   11,  13,  15,
			17,  19,  21,  23,  25,  25,  25,  26,
			27,  28,  29,  30,  31,  32,  33,  34,
			35,  36,  37,  38,  39,  40,  41,  42,
			43,  44,  45,  46,  47,  48,  49,  50,
			51,  52,  53,  54,  55,  56,  57,  58,
			59,  60,  61,  62,  63,  64,  65,  66,
			67,  68,  69,  70,  71,  72,  73,  74,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,  75,  75,  75,  75,  75,  75,  75,
			75,
		},
		{	/* Fourth byte table 117. */
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   0,   0,   0,   0,   0,   0,   0,
			0,   4,   9,   13,  17,  21,  25,  29,
			33,  37,  42,  46,  50,  54,  58,  62,
			66,  71,  75,  80,  85,  90,  94,  98,
			102, 106, 110, 114, 118, 122, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127, 127, 127, 127, 127, 127, 127, 127,
			127,
		},
	},
};

static const uint16_t u8_decomp_b4_16bit_tbl[2][30][257] = {
	{
		{	/* Fourth byte 16-bit table 0. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   38,   44,   48,   52,   56,   60,   64,
			68,   72,   76,   80,   84,   90,   96,   102,
			108,  112,  116,  120,  124,  130,  136,  140,
			144,  148,  152,  156,  160,  164,  168,  172,
			176,  180,  184,  188,  192,  196,  200,  206,
			212,  216,  220,  224,  228,  232,  236,  240,
			244,  250,  256,  260,  264,  268,  272,  276,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,
		},
		{	/* Fourth byte 16-bit table 1. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   54,   60,   66,
			72,   78,   84,   90,   96,   100,  104,  108,
			112,  116,  120,  124,  128,  134,  140,  144,
			148,  152,  156,  160,  164,  170,  176,  182,
			188,  194,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  262,  268,  274,  280,  284,  288,  292,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,
		},
		{	/* Fourth byte 16-bit table 2. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  107,  116,  116,  116,  116,
			116,  120,  124,  128,  132,  138,  144,  150,
			156,  162,  168,  174,  180,  186,  192,  198,
			204,  210,  216,  222,  228,  234,  240,  246,
			252,  256,  260,  264,  268,  272,  276,  282,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,
		},
		{	/* Fourth byte 16-bit table 3. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   52,   56,   60,   64,   68,   72,   76,
			80,   86,   92,   98,   104,  110,  116,  122,
			128,  134,  140,  146,  152,  158,  164,  170,
			176,  182,  188,  194,  200,  204,  208,  212,
			216,  222,  228,  234,  240,  246,  252,  258,
			264,  270,  276,  280,  284,  288,  292,  296,
			300,  304,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,
		},
		{	/* Fourth byte 16-bit table 4. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   17,   24,   31,   38,   45,
			52,   57,   62,   69,   76,   83,   90,   97,
			104,  109,  114,  121,  128,  135,  142,  142,
			142,  147,  152,  159,  166,  173,  180,  180,
			180,  185,  190,  197,  204,  211,  218,  225,
			232,  237,  242,  249,  256,  263,  270,  277,
			284,  289,  294,  301,  308,  315,  322,  329,
			336,  341,  346,  353,  360,  367,  374,  381,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,
		},
		{	/* Fourth byte 16-bit table 5. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   17,   24,   31,   38,   38,
			38,   43,   48,   55,   62,   69,   76,   76,
			76,   81,   86,   93,   100,  107,  114,  121,
			128,  128,  133,  133,  140,  140,  147,  147,
			154,  159,  164,  171,  178,  185,  192,  199,
			206,  211,  216,  223,  230,  237,  244,  251,
			258,  263,  268,  273,  278,  283,  288,  293,
			298,  303,  308,  313,  318,  323,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,
		},
		{	/* Fourth byte 16-bit table 6. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    7,    14,   23,   32,   41,   50,   59,
			68,   75,   82,   91,   100,  109,  118,  127,
			136,  143,  150,  159,  168,  177,  186,  195,
			204,  211,  218,  227,  236,  245,  254,  263,
			272,  279,  286,  295,  304,  313,  322,  331,
			340,  347,  354,  363,  372,  381,  390,  399,
			408,  413,  418,  425,  430,  437,  437,  442,
			449,  454,  459,  464,  469,  474,  477,  480,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,
		},
		{	/* Fourth byte 16-bit table 7. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    3,    14,   21,   26,   33,   33,   38,
			45,   50,   55,   60,   65,   70,   82,   94,
			106,  111,  116,  123,  130,  130,  130,  135,
			142,  147,  152,  157,  162,  162,  174,  186,
			198,  203,  208,  215,  222,  227,  232,  237,
			244,  249,  254,  259,  264,  269,  280,  291,
			293,  293,  293,  300,  305,  312,  312,  317,
			324,  329,  334,  339,  344,  349,  356,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,
		},
		{	/* Fourth byte 16-bit table 8. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   15,   20,   25,   30,   35,
			40,   45,   50,   55,   60,   65,   70,   78,
			86,   94,   102,  110,  118,  126,  134,  142,
			150,  158,  166,  174,  182,  190,  190,  190,
			190,  195,  200,  205,  210,  215,  220,  225,
			230,  235,  240,  245,  250,  255,  260,  265,
			270,  275,  280,  285,  290,  295,  300,  305,
			310,  315,  320,  325,  330,  335,  340,  345,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,  350,  350,  350,  350,  350,  350,  350,
			350,
		},
		{	/* Fourth byte 16-bit table 9. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   27,   42,   51,   66,   75,   84,
			102,  114,  123,  132,  141,  153,  165,  177,
			189,  201,  213,  225,  243,  249,  267,  285,
			300,  312,  330,  348,  360,  369,  378,  390,
			402,  417,  432,  441,  450,  462,  471,  480,
			486,  492,  501,  510,  528,  540,  555,  573,
			585,  594,  603,  621,  633,  651,  660,  675,
			684,  696,  705,  717,  732,  744,  759,  771,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,
		},
		{	/* Fourth byte 16-bit table 10. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   24,   33,   45,   54,   63,   72,
			87,   99,   105,  123,  132,  147,  159,  171,
			180,  189,  201,  207,  219,  234,  240,  258,
			267,  271,  275,  279,  283,  287,  291,  295,
			299,  303,  307,  312,  317,  322,  327,  332,
			337,  342,  347,  352,  357,  362,  367,  372,
			377,  382,  385,  387,  389,  392,  394,  396,
			396,  396,  396,  396,  402,  408,  414,  420,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,  432,  432,  432,  432,  432,  432,  432,
			432,
		},
		{	/* Fourth byte 16-bit table 11. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 12. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 13. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 14. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 15. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   34,   38,
			42,   46,   50,   54,   58,   62,   66,   70,
			74,   78,   82,   86,   90,   94,   98,   102,
			106,  110,  114,  118,  122,  126,  130,  134,
			138,  142,  146,  150,  154,  158,  162,  166,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 16. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  125,
			130,  135,  140,  145,  150,  156,  162,  168,
			174,  180,  186,  190,  194,  198,  202,  206,
			210,  214,  218,  222,  226,  230,  234,  238,
			242,  246,  250,  254,  258,  262,  266,  270,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,
		},
		{	/* Fourth byte 16-bit table 17. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			98,   104,  110,  116,  122,  126,  130,  134,
			138,  142,  146,  150,  154,  158,  162,  166,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 18. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			130,  136,  140,  144,  148,  152,  156,  160,
			164,  168,  172,  176,  180,  184,  188,  192,
			196,  200,  204,  210,  216,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 19. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   54,   60,   66,   72,   78,   84,   90,
			96,   102,  108,  114,  120,  126,  132,  138,
			144,  150,  156,  162,  168,  174,  180,  186,
			192,  198,  204,  210,  216,  222,  228,  234,
			240,  246,  252,  258,  264,  270,  276,  282,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,
		},
		{	/* Fourth byte 16-bit table 20. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   54,   60,   66,   72,   78,   84,   90,
			96,   96,   96,   102,  108,  114,  120,  126,
			132,  138,  144,  150,  156,  162,  168,  174,
			180,  186,  192,  198,  204,  210,  216,  222,
			228,  234,  240,  246,  252,  258,  264,  270,
			276,  282,  288,  294,  300,  306,  312,  318,
			324,  330,  336,  342,  348,  354,  360,  366,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,
		},
		{	/* Fourth byte 16-bit table 21. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   17,   21,   25,   29,
			33,   37,   41,   45,   49,   53,   58,   62,
			66,   70,   74,   79,   83,   87,   91,   96,
			100,  104,  108,  112,  116,  121,  125,  129,
			133,  137,  141,  145,  149,  153,  157,  161,
			165,  169,  173,  177,  181,  185,  189,  193,
			197,  201,  205,  209,  213,  218,  222,  226,
			230,  235,  239,  243,  247,  251,  255,  259,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,
		},
		{	/* Fourth byte 16-bit table 22. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  105,  109,  113,  117,  121,  125,
			129,  134,  139,  143,  147,  151,  155,  159,
			163,  167,  171,  175,  179,  184,  188,  192,
			196,  200,  205,  209,  213,  217,  221,  225,
			229,  233,  237,  241,  246,  250,  255,  259,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,
		},
		{	/* Fourth byte 16-bit table 23. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   41,   45,   49,   53,   57,   61,
			66,   70,   75,   80,   84,   88,   92,   96,
			101,  106,  110,  114,  118,  122,  126,  130,
			134,  138,  142,  146,  150,  155,  159,  163,
			167,  171,  175,  179,  183,  187,  191,  195,
			199,  203,  207,  211,  215,  219,  223,  227,
			231,  236,  240,  244,  248,  252,  256,  261,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,
		},
		{	/* Fourth byte 16-bit table 24. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   45,   49,   53,   57,   61,
			65,   69,   73,   77,   81,   85,   89,   93,
			97,   101,  105,  109,  113,  117,  122,  126,
			130,  134,  138,  142,  147,  151,  155,  159,
			163,  167,  171,  175,  179,  184,  188,  192,
			196,  201,  205,  209,  213,  217,  221,  225,
			230,  235,  240,  244,  249,  253,  257,  261,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,
		},
		{	/* Fourth byte 16-bit table 25. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   29,
			33,   37,   41,   45,   49,   53,   58,   62,
			66,   71,   76,   80,   84,   88,   92,   96,
			100,  104,  108,  112,  117,  121,  126,  130,
			135,  139,  143,  147,  152,  156,  160,  165,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  227,  231,
			236,  240,  245,  249,  254,  259,  264,  268,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,
		},
		{	/* Fourth byte 16-bit table 26. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    9,    14,   19,   24,   28,   32,
			36,   40,   44,   48,   52,   56,   61,   65,
			69,   73,   77,   82,   86,   91,   96,   100,
			104,  108,  112,  116,  120,  125,  130,  135,
			139,  143,  148,  152,  156,  160,  165,  169,
			173,  177,  181,  185,  190,  194,  198,  202,
			206,  210,  214,  219,  224,  228,  233,  237,
			242,  246,  250,  254,  259,  264,  268,  273,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,
		},
		{	/* Fourth byte 16-bit table 27. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    9,    13,   17,   21,   25,   29,
			34,   39,   44,   49,   53,   57,   61,   65,
			69,   73,   77,   81,   85,   89,   93,   97,
			102,  106,  110,  114,  118,  122,  126,  130,
			134,  138,  142,  146,  150,  155,  160,  165,
			169,  173,  177,  181,  186,  190,  195,  199,
			203,  208,  213,  217,  221,  225,  229,  233,
			237,  241,  245,  249,  253,  257,  261,  265,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,
		},
		{	/* Fourth byte 16-bit table 28. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   25,   29,
			33,   37,   41,   45,   50,   55,   59,   63,
			67,   71,   75,   79,   84,   88,   92,   96,
			100,  105,  110,  114,  118,  122,  127,  131,
			135,  140,  145,  149,  153,  157,  162,  166,
			170,  174,  178,  182,  186,  190,  195,  199,
			203,  207,  212,  216,  220,  224,  228,  233,
			238,  242,  246,  250,  255,  259,  264,  268,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,
		},
		{	/* Fourth byte 16-bit table 29. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,
		},
	},
	{
		{	/* Fourth byte 16-bit table 0. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   38,   44,   48,   52,   56,   60,   64,
			68,   72,   76,   80,   84,   90,   96,   102,
			108,  112,  116,  120,  124,  130,  136,  140,
			144,  148,  152,  156,  160,  164,  168,  172,
			176,  180,  184,  188,  192,  196,  200,  206,
			212,  216,  220,  224,  228,  232,  236,  240,
			244,  250,  256,  260,  264,  268,  272,  276,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,  280,  280,  280,  280,  280,  280,  280,
			280,
		},
		{	/* Fourth byte 16-bit table 1. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   54,   60,   66,
			72,   78,   84,   90,   96,   100,  104,  108,
			112,  116,  120,  124,  128,  134,  140,  144,
			148,  152,  156,  160,  164,  170,  176,  182,
			188,  194,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  262,  268,  274,  280,  284,  288,  292,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,  296,  296,  296,  296,  296,  296,  296,
			296,
		},
		{	/* Fourth byte 16-bit table 2. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  107,  116,  116,  116,  116,
			116,  120,  124,  128,  132,  138,  144,  150,
			156,  162,  168,  174,  180,  186,  192,  198,
			204,  210,  216,  222,  228,  234,  240,  246,
			252,  256,  260,  264,  268,  272,  276,  282,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,
		},
		{	/* Fourth byte 16-bit table 3. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   52,   56,   60,   64,   68,   72,   76,
			80,   86,   92,   98,   104,  110,  116,  122,
			128,  134,  140,  146,  152,  158,  164,  170,
			176,  182,  188,  194,  200,  204,  208,  212,
			216,  222,  228,  234,  240,  246,  252,  258,
			264,  270,  276,  280,  284,  288,  292,  296,
			300,  304,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,  308,  308,  308,  308,  308,  308,  308,
			308,
		},
		{	/* Fourth byte 16-bit table 4. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   17,   24,   31,   38,   45,
			52,   57,   62,   69,   76,   83,   90,   97,
			104,  109,  114,  121,  128,  135,  142,  142,
			142,  147,  152,  159,  166,  173,  180,  180,
			180,  185,  190,  197,  204,  211,  218,  225,
			232,  237,  242,  249,  256,  263,  270,  277,
			284,  289,  294,  301,  308,  315,  322,  329,
			336,  341,  346,  353,  360,  367,  374,  381,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,  388,  388,  388,  388,  388,  388,  388,
			388,
		},
		{	/* Fourth byte 16-bit table 5. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   17,   24,   31,   38,   38,
			38,   43,   48,   55,   62,   69,   76,   76,
			76,   81,   86,   93,   100,  107,  114,  121,
			128,  128,  133,  133,  140,  140,  147,  147,
			154,  159,  164,  171,  178,  185,  192,  199,
			206,  211,  216,  223,  230,  237,  244,  251,
			258,  263,  268,  273,  278,  283,  288,  293,
			298,  303,  308,  313,  318,  323,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,  328,  328,  328,  328,  328,  328,  328,
			328,
		},
		{	/* Fourth byte 16-bit table 6. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    7,    14,   23,   32,   41,   50,   59,
			68,   75,   82,   91,   100,  109,  118,  127,
			136,  143,  150,  159,  168,  177,  186,  195,
			204,  211,  218,  227,  236,  245,  254,  263,
			272,  279,  286,  295,  304,  313,  322,  331,
			340,  347,  354,  363,  372,  381,  390,  399,
			408,  413,  418,  425,  430,  437,  437,  442,
			449,  454,  459,  464,  469,  474,  477,  480,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,  483,  483,  483,  483,  483,  483,  483,
			483,
		},
		{	/* Fourth byte 16-bit table 7. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    3,    14,   21,   26,   33,   33,   38,
			45,   50,   55,   60,   65,   70,   82,   94,
			106,  111,  116,  123,  130,  130,  130,  135,
			142,  147,  152,  157,  162,  162,  174,  186,
			198,  203,  208,  215,  222,  227,  232,  237,
			244,  249,  254,  259,  264,  269,  280,  291,
			293,  293,  293,  300,  305,  312,  312,  317,
			324,  329,  334,  339,  344,  349,  356,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,  359,  359,  359,  359,  359,  359,  359,
			359,
		},
		{	/* Fourth byte 16-bit table 8. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    10,   15,   20,   25,   30,   35,
			40,   45,   50,   55,   60,   65,   70,   78,
			86,   94,   102,  110,  118,  126,  134,  142,
			150,  158,  166,  174,  182,  190,  207,  221,
			221,  226,  231,  236,  241,  246,  251,  256,
			261,  266,  271,  276,  281,  286,  291,  296,
			301,  306,  311,  316,  321,  326,  331,  336,
			341,  346,  351,  356,  361,  366,  371,  376,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,  381,  381,  381,  381,  381,  381,  381,
			381,
		},
		{	/* Fourth byte 16-bit table 9. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   27,   42,   51,   66,   75,   84,
			102,  114,  123,  132,  141,  153,  165,  177,
			189,  201,  213,  225,  243,  249,  267,  285,
			300,  312,  330,  348,  360,  369,  378,  390,
			402,  417,  432,  441,  450,  462,  471,  480,
			486,  492,  501,  510,  528,  540,  555,  573,
			585,  594,  603,  621,  633,  651,  660,  675,
			684,  696,  705,  717,  732,  744,  759,  771,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,  777,  777,  777,  777,  777,  777,  777,
			777,
		},
		{	/* Fourth byte 16-bit table 10. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    15,   24,   33,   45,   54,   63,   72,
			87,   99,   105,  123,  132,  147,  159,  171,
			180,  189,  201,  207,  219,  234,  240,  258,
			267,  271,  275,  279,  283,  287,  291,  295,
			299,  303,  307,  312,  317,  322,  327,  332,
			337,  342,  347,  352,  357,  362,  367,  372,
			377,  382,  385,  387,  389,  392,  394,  396,
			398,  401,  404,  406,  412,  418,  424,  430,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,  442,  442,  442,  442,  442,  442,  442,
			442,
		},
		{	/* Fourth byte 16-bit table 11. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 12. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 13. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 14. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 15. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			128,  132,  136,  140,  144,  148,  152,  156,
			160,  164,  168,  172,  176,  180,  184,  188,
			192,  196,  200,  204,  208,  212,  216,  220,
			224,  228,  232,  236,  240,  244,  248,  252,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,  256,  256,  256,  256,  256,  256,  256,
			256,
		},
		{	/* Fourth byte 16-bit table 16. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   34,   38,
			42,   46,   50,   54,   58,   62,   66,   70,
			74,   78,   82,   86,   90,   94,   98,   102,
			106,  110,  114,  118,  122,  126,  130,  134,
			138,  142,  146,  150,  154,  158,  162,  166,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 17. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  125,
			130,  135,  140,  145,  150,  156,  162,  168,
			174,  180,  186,  190,  194,  198,  202,  206,
			210,  214,  218,  222,  226,  230,  234,  238,
			242,  246,  250,  254,  258,  262,  266,  270,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,  274,  274,  274,  274,  274,  274,  274,
			274,
		},
		{	/* Fourth byte 16-bit table 18. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			98,   104,  110,  116,  122,  126,  130,  134,
			138,  142,  146,  150,  154,  158,  162,  166,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 19. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  104,  108,  112,  116,  120,  124,
			130,  136,  140,  144,  148,  152,  156,  160,
			164,  168,  172,  176,  180,  184,  188,  192,
			196,  200,  204,  210,  216,  222,  226,  230,
			234,  238,  242,  246,  250,  254,  258,  262,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,  266,  266,  266,  266,  266,  266,  266,
			266,
		},
		{	/* Fourth byte 16-bit table 20. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   54,   60,   66,   72,   78,   84,   90,
			96,   102,  108,  114,  120,  126,  132,  138,
			144,  150,  156,  162,  168,  174,  180,  186,
			192,  198,  204,  210,  216,  222,  228,  234,
			240,  246,  252,  258,  264,  270,  276,  282,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,  288,  288,  288,  288,  288,  288,  288,
			288,
		},
		{	/* Fourth byte 16-bit table 21. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    6,    12,   18,   24,   30,   36,   42,
			48,   54,   60,   66,   72,   78,   84,   90,
			96,   96,   96,   102,  108,  114,  120,  126,
			132,  138,  144,  150,  156,  162,  168,  174,
			180,  186,  192,  198,  204,  210,  216,  222,
			228,  234,  240,  246,  252,  258,  264,  270,
			276,  282,  288,  294,  300,  306,  312,  318,
			324,  330,  336,  342,  348,  354,  360,  366,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,  372,  372,  372,  372,  372,  372,  372,
			372,
		},
		{	/* Fourth byte 16-bit table 22. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   17,   21,   25,   29,
			33,   37,   41,   45,   49,   53,   58,   62,
			66,   70,   74,   79,   83,   87,   91,   96,
			100,  104,  108,  112,  116,  121,  125,  129,
			133,  137,  141,  145,  149,  153,  157,  161,
			165,  169,  173,  177,  181,  185,  189,  193,
			197,  201,  205,  209,  213,  218,  222,  226,
			230,  235,  239,  243,  247,  251,  255,  259,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,
		},
		{	/* Fourth byte 16-bit table 23. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   44,   48,   52,   56,   60,
			64,   68,   72,   76,   80,   84,   88,   92,
			96,   100,  105,  109,  113,  117,  121,  125,
			129,  134,  139,  143,  147,  151,  155,  159,
			163,  167,  171,  175,  179,  184,  188,  192,
			196,  200,  205,  209,  213,  217,  221,  225,
			229,  233,  237,  241,  246,  250,  255,  259,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,  263,  263,  263,  263,  263,  263,  263,
			263,
		},
		{	/* Fourth byte 16-bit table 24. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   41,   45,   49,   53,   57,   61,
			66,   70,   75,   80,   84,   88,   92,   96,
			101,  106,  110,  114,  118,  122,  126,  130,
			134,  138,  142,  146,  150,  155,  159,  163,
			167,  171,  175,  179,  183,  187,  191,  195,
			199,  203,  207,  211,  215,  219,  223,  227,
			231,  236,  240,  244,  248,  252,  256,  261,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,
		},
		{	/* Fourth byte 16-bit table 25. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   28,
			32,   36,   40,   45,   49,   53,   57,   61,
			65,   69,   73,   77,   81,   85,   89,   93,
			97,   101,  105,  109,  113,  117,  122,  126,
			130,  134,  138,  142,  147,  151,  155,  159,
			163,  167,  171,  175,  179,  184,  188,  192,
			196,  201,  205,  209,  213,  217,  221,  225,
			230,  235,  240,  244,  249,  253,  257,  261,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,  265,  265,  265,  265,  265,  265,  265,
			265,
		},
		{	/* Fourth byte 16-bit table 26. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   24,   29,
			33,   37,   41,   45,   49,   53,   58,   62,
			66,   71,   76,   80,   84,   88,   92,   96,
			100,  104,  108,  112,  117,  121,  126,  130,
			135,  139,  143,  147,  152,  156,  160,  165,
			170,  174,  178,  182,  186,  190,  194,  198,
			202,  206,  210,  214,  218,  222,  227,  231,
			236,  240,  245,  249,  254,  259,  264,  268,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,
		},
		{	/* Fourth byte 16-bit table 27. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    9,    14,   19,   24,   28,   32,
			36,   40,   44,   48,   52,   56,   61,   65,
			69,   73,   77,   82,   86,   91,   96,   100,
			104,  108,  112,  116,  120,  125,  130,  135,
			139,  143,  148,  152,  156,  160,  165,  169,
			173,  177,  181,  185,  190,  194,  198,  202,
			206,  210,  214,  219,  224,  228,  233,  237,
			242,  246,  250,  254,  259,  264,  268,  273,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,  277,  277,  277,  277,  277,  277,  277,
			277,
		},
		{	/* Fourth byte 16-bit table 28. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    5,    9,    13,   17,   21,   25,   29,
			34,   39,   44,   49,   53,   57,   61,   65,
			69,   73,   77,   81,   85,   89,   93,   97,
			102,  106,  110,  114,  118,  122,  126,  130,
			134,  138,  142,  146,  150,  155,  160,  165,
			169,  173,  177,  181,  186,  190,  195,  199,
			203,  208,  213,  217,  221,  225,  229,  233,
			237,  241,  245,  249,  253,  257,  261,  265,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,  269,  269,  269,  269,  269,  269,  269,
			269,
		},
		{	/* Fourth byte 16-bit table 29. */
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    0,    0,    0,    0,    0,    0,    0,
			0,    4,    8,    12,   16,   20,   25,   29,
			33,   37,   41,   45,   50,   55,   59,   63,
			67,   71,   75,   79,   84,   88,   92,   96,
			100,  105,  110,  114,  118,  122,  127,  131,
			135,  140,  145,  149,  153,  157,  162,  166,
			170,  174,  178,  182,  186,  190,  195,  199,
			203,  207,  212,  216,  220,  224,  228,  233,
			238,  242,  246,  250,  255,  259,  264,  268,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,  272,  272,  272,  272,  272,  272,  272,
			272,
		},
	},
};

static const uchar_t u8_decomp_final_tbl[2][19370] = {
	{
		0x20, 0x20, 0xCC, 0x88, 0x61, 0x20, 0xCC, 0x84,
		0x32, 0x33, 0x20, 0xCC, 0x81, 0xCE, 0xBC, 0x20,
		0xCC, 0xA7, 0x31, 0x6F, 0x31, 0xE2, 0x81, 0x84,
		0x34, 0x31, 0xE2, 0x81, 0x84, 0x32, 0x33, 0xE2,
		0x81, 0x84, 0x34, 0xF6, 0x41, 0xCC, 0x80, 0xF6,
		0x41, 0xCC, 0x81, 0xF6, 0x41, 0xCC, 0x82, 0xF6,
		0x41, 0xCC, 0x83, 0xF6, 0x41, 0xCC, 0x88, 0xF6,
		0x41, 0xCC, 0x8A, 0xF6, 0x43, 0xCC, 0xA7, 0xF6,
		0x45, 0xCC, 0x80, 0xF6, 0x45, 0xCC, 0x81, 0xF6,
		0x45, 0xCC, 0x82, 0xF6, 0x45, 0xCC, 0x88, 0xF6,
		0x49, 0xCC, 0x80, 0xF6, 0x49, 0xCC, 0x81, 0xF6,
		0x49, 0xCC, 0x82, 0xF6, 0x49, 0xCC, 0x88, 0xF6,
		0x4E, 0xCC, 0x83, 0xF6, 0x4F, 0xCC, 0x80, 0xF6,
		0x4F, 0xCC, 0x81, 0xF6, 0x4F, 0xCC, 0x82, 0xF6,
		0x4F, 0xCC, 0x83, 0xF6, 0x4F, 0xCC, 0x88, 0xF6,
		0x55, 0xCC, 0x80, 0xF6, 0x55, 0xCC, 0x81, 0xF6,
		0x55, 0xCC, 0x82, 0xF6, 0x55, 0xCC, 0x88, 0xF6,
		0x59, 0xCC, 0x81, 0xF6, 0x61, 0xCC, 0x80, 0xF6,
		0x61, 0xCC, 0x81, 0xF6, 0x61, 0xCC, 0x82, 0xF6,
		0x61, 0xCC, 0x83, 0xF6, 0x61, 0xCC, 0x88, 0xF6,
		0x61, 0xCC, 0x8A, 0xF6, 0x63, 0xCC, 0xA7, 0xF6,
		0x65, 0xCC, 0x80, 0xF6, 0x65, 0xCC, 0x81, 0xF6,
		0x65, 0xCC, 0x82, 0xF6, 0x65, 0xCC, 0x88, 0xF6,
		0x69, 0xCC, 0x80, 0xF6, 0x69, 0xCC, 0x81, 0xF6,
		0x69, 0xCC, 0x82, 0xF6, 0x69, 0xCC, 0x88, 0xF6,
		0x6E, 0xCC, 0x83, 0xF6, 0x6F, 0xCC, 0x80, 0xF6,
		0x6F, 0xCC, 0x81, 0xF6, 0x6F, 0xCC, 0x82, 0xF6,
		0x6F, 0xCC, 0x83, 0xF6, 0x6F, 0xCC, 0x88, 0xF6,
		0x75, 0xCC, 0x80, 0xF6, 0x75, 0xCC, 0x81, 0xF6,
		0x75, 0xCC, 0x82, 0xF6, 0x75, 0xCC, 0x88, 0xF6,
		0x79, 0xCC, 0x81, 0xF6, 0x79, 0xCC, 0x88, 0xF6,
		0x41, 0xCC, 0x84, 0xF6, 0x61, 0xCC, 0x84, 0xF6,
		0x41, 0xCC, 0x86, 0xF6, 0x61, 0xCC, 0x86, 0xF6,
		0x41, 0xCC, 0xA8, 0xF6, 0x61, 0xCC, 0xA8, 0xF6,
		0x43, 0xCC, 0x81, 0xF6, 0x63, 0xCC, 0x81, 0xF6,
		0x43, 0xCC, 0x82, 0xF6, 0x63, 0xCC, 0x82, 0xF6,
		0x43, 0xCC, 0x87, 0xF6, 0x63, 0xCC, 0x87, 0xF6,
		0x43, 0xCC, 0x8C, 0xF6, 0x63, 0xCC, 0x8C, 0xF6,
		0x44, 0xCC, 0x8C, 0xF6, 0x64, 0xCC, 0x8C, 0xF6,
		0x45, 0xCC, 0x84, 0xF6, 0x65, 0xCC, 0x84, 0xF6,
		0x45, 0xCC, 0x86, 0xF6, 0x65, 0xCC, 0x86, 0xF6,
		0x45, 0xCC, 0x87, 0xF6, 0x65, 0xCC, 0x87, 0xF6,
		0x45, 0xCC, 0xA8, 0xF6, 0x65, 0xCC, 0xA8, 0xF6,
		0x45, 0xCC, 0x8C, 0xF6, 0x65, 0xCC, 0x8C, 0xF6,
		0x47, 0xCC, 0x82, 0xF6, 0x67, 0xCC, 0x82, 0xF6,
		0x47, 0xCC, 0x86, 0xF6, 0x67, 0xCC, 0x86, 0xF6,
		0x47, 0xCC, 0x87, 0xF6, 0x67, 0xCC, 0x87, 0xF6,
		0x47, 0xCC, 0xA7, 0xF6, 0x67, 0xCC, 0xA7, 0xF6,
		0x48, 0xCC, 0x82, 0xF6, 0x68, 0xCC, 0x82, 0xF6,
		0x49, 0xCC, 0x83, 0xF6, 0x69, 0xCC, 0x83, 0xF6,
		0x49, 0xCC, 0x84, 0xF6, 0x69, 0xCC, 0x84, 0xF6,
		0x49, 0xCC, 0x86, 0xF6, 0x69, 0xCC, 0x86, 0xF6,
		0x49, 0xCC, 0xA8, 0xF6, 0x69, 0xCC, 0xA8, 0xF6,
		0x49, 0xCC, 0x87, 0x49, 0x4A, 0x69, 0x6A, 0xF6,
		0x4A, 0xCC, 0x82, 0xF6, 0x6A, 0xCC, 0x82, 0xF6,
		0x4B, 0xCC, 0xA7, 0xF6, 0x6B, 0xCC, 0xA7, 0xF6,
		0x4C, 0xCC, 0x81, 0xF6, 0x6C, 0xCC, 0x81, 0xF6,
		0x4C, 0xCC, 0xA7, 0xF6, 0x6C, 0xCC, 0xA7, 0xF6,
		0x4C, 0xCC, 0x8C, 0xF6, 0x6C, 0xCC, 0x8C, 0x4C,
		0xC2, 0xB7, 0x6C, 0xC2, 0xB7, 0xF6, 0x4E, 0xCC,
		0x81, 0xF6, 0x6E, 0xCC, 0x81, 0xF6, 0x4E, 0xCC,
		0xA7, 0xF6, 0x6E, 0xCC, 0xA7, 0xF6, 0x4E, 0xCC,
		0x8C, 0xF6, 0x6E, 0xCC, 0x8C, 0xCA, 0xBC, 0x6E,
		0xF6, 0x4F, 0xCC, 0x84, 0xF6, 0x6F, 0xCC, 0x84,
		0xF6, 0x4F, 0xCC, 0x86, 0xF6, 0x6F, 0xCC, 0x86,
		0xF6, 0x4F, 0xCC, 0x8B, 0xF6, 0x6F, 0xCC, 0x8B,
		0xF6, 0x52, 0xCC, 0x81, 0xF6, 0x72, 0xCC, 0x81,
		0xF6, 0x52, 0xCC, 0xA7, 0xF6, 0x72, 0xCC, 0xA7,
		0xF6, 0x52, 0xCC, 0x8C, 0xF6, 0x72, 0xCC, 0x8C,
		0xF6, 0x53, 0xCC, 0x81, 0xF6, 0x73, 0xCC, 0x81,
		0xF6, 0x53, 0xCC, 0x82, 0xF6, 0x73, 0xCC, 0x82,
		0xF6, 0x53, 0xCC, 0xA7, 0xF6, 0x73, 0xCC, 0xA7,
		0xF6, 0x53, 0xCC, 0x8C, 0xF6, 0x73, 0xCC, 0x8C,
		0xF6, 0x54, 0xCC, 0xA7, 0xF6, 0x74, 0xCC, 0xA7,
		0xF6, 0x54, 0xCC, 0x8C, 0xF6, 0x74, 0xCC, 0x8C,
		0xF6, 0x55, 0xCC, 0x83, 0xF6, 0x75, 0xCC, 0x83,
		0xF6, 0x55, 0xCC, 0x84, 0xF6, 0x75, 0xCC, 0x84,
		0xF6, 0x55, 0xCC, 0x86, 0xF6, 0x75, 0xCC, 0x86,
		0xF6, 0x55, 0xCC, 0x8A, 0xF6, 0x75, 0xCC, 0x8A,
		0xF6, 0x55, 0xCC, 0x8B, 0xF6, 0x75, 0xCC, 0x8B,
		0xF6, 0x55, 0xCC, 0xA8, 0xF6, 0x75, 0xCC, 0xA8,
		0xF6, 0x57, 0xCC, 0x82, 0xF6, 0x77, 0xCC, 0x82,
		0xF6, 0x59, 0xCC, 0x82, 0xF6, 0x79, 0xCC, 0x82,
		0xF6, 0x59, 0xCC, 0x88, 0xF6, 0x5A, 0xCC, 0x81,
		0xF6, 0x7A, 0xCC, 0x81, 0xF6, 0x5A, 0xCC, 0x87,
		0xF6, 0x7A, 0xCC, 0x87, 0xF6, 0x5A, 0xCC, 0x8C,
		0xF6, 0x7A, 0xCC, 0x8C, 0x73, 0xF6, 0x4F, 0xCC,
		0x9B, 0xF6, 0x6F, 0xCC, 0x9B, 0xF6, 0x55, 0xCC,
		0x9B, 0xF6, 0x75, 0xCC, 0x9B, 0x44, 0x5A, 0xCC,
		0x8C, 0x44, 0x7A, 0xCC, 0x8C, 0x64, 0x7A, 0xCC,
		0x8C, 0x4C, 0x4A, 0x4C, 0x6A, 0x6C, 0x6A, 0x4E,
		0x4A, 0x4E, 0x6A, 0x6E, 0x6A, 0xF6, 0x41, 0xCC,
		0x8C, 0xF6, 0x61, 0xCC, 0x8C, 0xF6, 0x49, 0xCC,
		0x8C, 0xF6, 0x69, 0xCC, 0x8C, 0xF6, 0x4F, 0xCC,
		0x8C, 0xF6, 0x6F, 0xCC, 0x8C, 0xF6, 0x55, 0xCC,
		0x8C, 0xF6, 0x75, 0xCC, 0x8C, 0xF6, 0x55, 0xCC,
		0x88, 0xCC, 0x84, 0xF6, 0x75, 0xCC, 0x88, 0xCC,
		0x84, 0xF6, 0x55, 0xCC, 0x88, 0xCC, 0x81, 0xF6,
		0x75, 0xCC, 0x88, 0xCC, 0x81, 0xF6, 0x55, 0xCC,
		0x88, 0xCC, 0x8C, 0xF6, 0x75, 0xCC, 0x88, 0xCC,
		0x8C, 0xF6, 0x55, 0xCC, 0x88, 0xCC, 0x80, 0xF6,
		0x75, 0xCC, 0x88, 0xCC, 0x80, 0xF6, 0x41, 0xCC,
		0x88, 0xCC, 0x84, 0xF6, 0x61, 0xCC, 0x88, 0xCC,
		0x84, 0xF6, 0x41, 0xCC, 0x87, 0xCC, 0x84, 0xF6,
		0x61, 0xCC, 0x87, 0xCC, 0x84, 0xF6, 0xC3, 0x86,
		0xCC, 0x84, 0xF6, 0xC3, 0xA6, 0xCC, 0x84, 0xF6,
		0x47, 0xCC, 0x8C, 0xF6, 0x67, 0xCC, 0x8C, 0xF6,
		0x4B, 0xCC, 0x8C, 0xF6, 0x6B, 0xCC, 0x8C, 0xF6,
		0x4F, 0xCC, 0xA8, 0xF6, 0x6F, 0xCC, 0xA8, 0xF6,
		0x4F, 0xCC, 0xA8, 0xCC, 0x84, 0xF6, 0x6F, 0xCC,
		0xA8, 0xCC, 0x84, 0xF6, 0xC6, 0xB7, 0xCC, 0x8C,
		0xF6, 0xCA, 0x92, 0xCC, 0x8C, 0xF6, 0x6A, 0xCC,
		0x8C, 0x44, 0x5A, 0x44, 0x7A, 0x64, 0x7A, 0xF6,
		0x47, 0xCC, 0x81, 0xF6, 0x67, 0xCC, 0x81, 0xF6,
		0x4E, 0xCC, 0x80, 0xF6, 0x6E, 0xCC, 0x80, 0xF6,
		0x41, 0xCC, 0x8A, 0xCC, 0x81, 0xF6, 0x61, 0xCC,
		0x8A, 0xCC, 0x81, 0xF6, 0xC3, 0x86, 0xCC, 0x81,
		0xF6, 0xC3, 0xA6, 0xCC, 0x81, 0xF6, 0xC3, 0x98,
		0xCC, 0x81, 0xF6, 0xC3, 0xB8, 0xCC, 0x81, 0xF6,
		0x41, 0xCC, 0x8F, 0xF6, 0x61, 0xCC, 0x8F, 0xF6,
		0x41, 0xCC, 0x91, 0xF6, 0x61, 0xCC, 0x91, 0xF6,
		0x45, 0xCC, 0x8F, 0xF6, 0x65, 0xCC, 0x8F, 0xF6,
		0x45, 0xCC, 0x91, 0xF6, 0x65, 0xCC, 0x91, 0xF6,
		0x49, 0xCC, 0x8F, 0xF6, 0x69, 0xCC, 0x8F, 0xF6,
		0x49, 0xCC, 0x91, 0xF6, 0x69, 0xCC, 0x91, 0xF6,
		0x4F, 0xCC, 0x8F, 0xF6, 0x6F, 0xCC, 0x8F, 0xF6,
		0x4F, 0xCC, 0x91, 0xF6, 0x6F, 0xCC, 0x91, 0xF6,
		0x52, 0xCC, 0x8F, 0xF6, 0x72, 0xCC, 0x8F, 0xF6,
		0x52, 0xCC, 0x91, 0xF6, 0x72, 0xCC, 0x91, 0xF6,
		0x55, 0xCC, 0x8F, 0xF6, 0x75, 0xCC, 0x8F, 0xF6,
		0x55, 0xCC, 0x91, 0xF6, 0x75, 0xCC, 0x91, 0xF6,
		0x53, 0xCC, 0xA6, 0xF6, 0x73, 0xCC, 0xA6, 0xF6,
		0x54, 0xCC, 0xA6, 0xF6, 0x74, 0xCC, 0xA6, 0xF6,
		0x48, 0xCC, 0x8C, 0xF6, 0x68, 0xCC, 0x8C, 0xF6,
		0x41, 0xCC, 0x87, 0xF6, 0x61, 0xCC, 0x87, 0xF6,
		0x45, 0xCC, 0xA7, 0xF6, 0x65, 0xCC, 0xA7, 0xF6,
		0x4F, 0xCC, 0x88, 0xCC, 0x84, 0xF6, 0x6F, 0xCC,
		0x88, 0xCC, 0x84, 0xF6, 0x4F, 0xCC, 0x83, 0xCC,
		0x84, 0xF6, 0x6F, 0xCC, 0x83, 0xCC, 0x84, 0xF6,
		0x4F, 0xCC, 0x87, 0xF6, 0x6F, 0xCC, 0x87, 0xF6,
		0x4F, 0xCC, 0x87, 0xCC, 0x84, 0xF6, 0x6F, 0xCC,
		0x87, 0xCC, 0x84, 0xF6, 0x59, 0xCC, 0x84, 0xF6,
		0x79, 0xCC, 0x84, 0x68, 0xC9, 0xA6, 0x6A, 0x72,
		0xC9, 0xB9, 0xC9, 0xBB, 0xCA, 0x81, 0x77, 0x79,
		0x20, 0xCC, 0x86, 0x20, 0xCC, 0x87, 0x20, 0xCC,
		0x8A, 0x20, 0xCC, 0xA8, 0x20, 0xCC, 0x83, 0x20,
		0xCC, 0x8B, 0xC9, 0xA3, 0x6C, 0x73, 0x78, 0xCA,
		0x95, 0xF6, 0xCC, 0x80, 0xF6, 0xCC, 0x81, 0xF6,
		0xCC, 0x93, 0xF6, 0xCC, 0x88, 0xCC, 0x81, 0xF6,
		0xCA, 0xB9, 0x20, 0xCD, 0x85, 0xF6, 0x3B, 0x20,
		0xCC, 0x81, 0xF5, 0x05, 0xC2, 0xA8, 0xCC, 0x81,
		0x20, 0xCC, 0x88, 0xCC, 0x81, 0xF6, 0xCE, 0x91,
		0xCC, 0x81, 0xF6, 0xC2, 0xB7, 0xF6, 0xCE, 0x95,
		0xCC, 0x81, 0xF6, 0xCE, 0x97, 0xCC, 0x81, 0xF6,
		0xCE, 0x99, 0xCC, 0x81, 0xF6, 0xCE, 0x9F, 0xCC,
		0x81, 0xF6, 0xCE, 0xA5, 0xCC, 0x81, 0xF6, 0xCE,
		0xA9, 0xCC, 0x81, 0xF6, 0xCE, 0xB9, 0xCC, 0x88,
		0xCC, 0x81, 0xF6, 0xCE, 0x99, 0xCC, 0x88, 0xF6,
		0xCE, 0xA5, 0xCC, 0x88, 0xF6, 0xCE, 0xB1, 0xCC,
		0x81, 0xF6, 0xCE, 0xB5, 0xCC, 0x81, 0xF6, 0xCE,
		0xB7, 0xCC, 0x81, 0xF6, 0xCE, 0xB9, 0xCC, 0x81,
		0xF6, 0xCF, 0x85, 0xCC, 0x88, 0xCC, 0x81, 0xF6,
		0xCE, 0xB9, 0xCC, 0x88, 0xF6, 0xCF, 0x85, 0xCC,
		0x88, 0xF6, 0xCE, 0xBF, 0xCC, 0x81, 0xF6, 0xCF,
		0x85, 0xCC, 0x81, 0xF6, 0xCF, 0x89, 0xCC, 0x81,
		0xCE, 0xB2, 0xCE, 0xB8, 0xCE, 0xA5, 0xF5, 0x05,
		0xCF, 0x92, 0xCC, 0x81, 0xCE, 0xA5, 0xCC, 0x81,
		0xF5, 0x05, 0xCF, 0x92, 0xCC, 0x88, 0xCE, 0xA5,
		0xCC, 0x88, 0xCF, 0x86, 0xCF, 0x80, 0xCE, 0xBA,
		0xCF, 0x81, 0xCF, 0x82, 0xCE, 0x98, 0xCE, 0xB5,
		0xF6, 0xD0, 0x95, 0xCC, 0x80, 0xF6, 0xD0, 0x95,
		0xCC, 0x88, 0xF6, 0xD0, 0x93, 0xCC, 0x81, 0xF6,
		0xD0, 0x86, 0xCC, 0x88, 0xF6, 0xD0, 0x9A, 0xCC,
		0x81, 0xF6, 0xD0, 0x98, 0xCC, 0x80, 0xF6, 0xD0,
		0xA3, 0xCC, 0x86, 0xF6, 0xD0, 0x98, 0xCC, 0x86,
		0xF6, 0xD0, 0xB8, 0xCC, 0x86, 0xF6, 0xD0, 0xB5,
		0xCC, 0x80, 0xF6, 0xD0, 0xB5, 0xCC, 0x88, 0xF6,
		0xD0, 0xB3, 0xCC, 0x81, 0xF6, 0xD1, 0x96, 0xCC,
		0x88, 0xF6, 0xD0, 0xBA, 0xCC, 0x81, 0xF6, 0xD0,
		0xB8, 0xCC, 0x80, 0xF6, 0xD1, 0x83, 0xCC, 0x86,
		0xF6, 0xD1, 0xB4, 0xCC, 0x8F, 0xF6, 0xD1, 0xB5,
		0xCC, 0x8F, 0xF6, 0xD0, 0x96, 0xCC, 0x86, 0xF6,
		0xD0, 0xB6, 0xCC, 0x86, 0xF6, 0xD0, 0x90, 0xCC,
		0x86, 0xF6, 0xD0, 0xB0, 0xCC, 0x86, 0xF6, 0xD0,
		0x90, 0xCC, 0x88, 0xF6, 0xD0, 0xB0, 0xCC, 0x88,
		0xF6, 0xD0, 0x95, 0xCC, 0x86, 0xF6, 0xD0, 0xB5,
		0xCC, 0x86, 0xF6, 0xD3, 0x98, 0xCC, 0x88, 0xF6,
		0xD3, 0x99, 0xCC, 0x88, 0xF6, 0xD0, 0x96, 0xCC,
		0x88, 0xF6, 0xD0, 0xB6, 0xCC, 0x88, 0xF6, 0xD0,
		0x97, 0xCC, 0x88, 0xF6, 0xD0, 0xB7, 0xCC, 0x88,
		0xF6, 0xD0, 0x98, 0xCC, 0x84, 0xF6, 0xD0, 0xB8,
		0xCC, 0x84, 0xF6, 0xD0, 0x98, 0xCC, 0x88, 0xF6,
		0xD0, 0xB8, 0xCC, 0x88, 0xF6, 0xD0, 0x9E, 0xCC,
		0x88, 0xF6, 0xD0, 0xBE, 0xCC, 0x88, 0xF6, 0xD3,
		0xA8, 0xCC, 0x88, 0xF6, 0xD3, 0xA9, 0xCC, 0x88,
		0xF6, 0xD0, 0xAD, 0xCC, 0x88, 0xF6, 0xD1, 0x8D,
		0xCC, 0x88, 0xF6, 0xD0, 0xA3, 0xCC, 0x84, 0xF6,
		0xD1, 0x83, 0xCC, 0x84, 0xF6, 0xD0, 0xA3, 0xCC,
		0x88, 0xF6, 0xD1, 0x83, 0xCC, 0x88, 0xF6, 0xD0,
		0xA3, 0xCC, 0x8B, 0xF6, 0xD1, 0x83, 0xCC, 0x8B,
		0xF6, 0xD0, 0xA7, 0xCC, 0x88, 0xF6, 0xD1, 0x87,
		0xCC, 0x88, 0xF6, 0xD0, 0xAB, 0xCC, 0x88, 0xF6,
		0xD1, 0x8B, 0xCC, 0x88, 0xD5, 0xA5, 0xD6, 0x82,
		0xF6, 0xD8, 0xA7, 0xD9, 0x93, 0xF6, 0xD8, 0xA7,
		0xD9, 0x94, 0xF6, 0xD9, 0x88, 0xD9, 0x94, 0xF6,
		0xD8, 0xA7, 0xD9, 0x95, 0xF6, 0xD9, 0x8A, 0xD9,
		0x94, 0xD8, 0xA7, 0xD9, 0xB4, 0xD9, 0x88, 0xD9,
		0xB4, 0xDB, 0x87, 0xD9, 0xB4, 0xD9, 0x8A, 0xD9,
		0xB4, 0xF6, 0xDB, 0x95, 0xD9, 0x94, 0xF6, 0xDB,
		0x81, 0xD9, 0x94, 0xF6, 0xDB, 0x92, 0xD9, 0x94,
		0xF6, 0xE0, 0xA4, 0xA8, 0xE0, 0xA4, 0xBC, 0xF6,
		0xE0, 0xA4, 0xB0, 0xE0, 0xA4, 0xBC, 0xF6, 0xE0,
		0xA4, 0xB3, 0xE0, 0xA4, 0xBC, 0xF6, 0xE0, 0xA4,
		0x95, 0xE0, 0xA4, 0xBC, 0xF6, 0xE0, 0xA4, 0x96,
		0xE0, 0xA4, 0xBC, 0xF6, 0xE0, 0xA4, 0x97, 0xE0,
		0xA4, 0xBC, 0xF6, 0xE0, 0xA4, 0x9C, 0xE0, 0xA4,
		0xBC, 0xF6, 0xE0, 0xA4, 0xA1, 0xE0, 0xA4, 0xBC,
		0xF6, 0xE0, 0xA4, 0xA2, 0xE0, 0xA4, 0xBC, 0xF6,
		0xE0, 0xA4, 0xAB, 0xE0, 0xA4, 0xBC, 0xF6, 0xE0,
		0xA4, 0xAF, 0xE0, 0xA4, 0xBC, 0xF6, 0xE0, 0xA7,
		0x87, 0xE0, 0xA6, 0xBE, 0xF6, 0xE0, 0xA7, 0x87,
		0xE0, 0xA7, 0x97, 0xF6, 0xE0, 0xA6, 0xA1, 0xE0,
		0xA6, 0xBC, 0xF6, 0xE0, 0xA6, 0xA2, 0xE0, 0xA6,
		0xBC, 0xF6, 0xE0, 0xA6, 0xAF, 0xE0, 0xA6, 0xBC,
		0xF6, 0xE0, 0xA8, 0xB2, 0xE0, 0xA8, 0xBC, 0xF6,
		0xE0, 0xA8, 0xB8, 0xE0, 0xA8, 0xBC, 0xF6, 0xE0,
		0xA8, 0x96, 0xE0, 0xA8, 0xBC, 0xF6, 0xE0, 0xA8,
		0x97, 0xE0, 0xA8, 0xBC, 0xF6, 0xE0, 0xA8, 0x9C,
		0xE0, 0xA8, 0xBC, 0xF6, 0xE0, 0xA8, 0xAB, 0xE0,
		0xA8, 0xBC, 0xF6, 0xE0, 0xAD, 0x87, 0xE0, 0xAD,
		0x96, 0xF6, 0xE0, 0xAD, 0x87, 0xE0, 0xAC, 0xBE,
		0xF6, 0xE0, 0xAD, 0x87, 0xE0, 0xAD, 0x97, 0xF6,
		0xE0, 0xAC, 0xA1, 0xE0, 0xAC, 0xBC, 0xF6, 0xE0,
		0xAC, 0xA2, 0xE0, 0xAC, 0xBC, 0xF6, 0xE0, 0xAE,
		0x92, 0xE0, 0xAF, 0x97, 0xF6, 0xE0, 0xAF, 0x86,
		0xE0, 0xAE, 0xBE, 0xF6, 0xE0, 0xAF, 0x87, 0xE0,
		0xAE, 0xBE, 0xF6, 0xE0, 0xAF, 0x86, 0xE0, 0xAF,
		0x97, 0xF6, 0xE0, 0xB1, 0x86, 0xE0, 0xB1, 0x96,
		0xF6, 0xE0, 0xB2, 0xBF, 0xE0, 0xB3, 0x95, 0xF6,
		0xE0, 0xB3, 0x86, 0xE0, 0xB3, 0x95, 0xF6, 0xE0,
		0xB3, 0x86, 0xE0, 0xB3, 0x96, 0xF6, 0xE0, 0xB3,
		0x86, 0xE0, 0xB3, 0x82, 0xF6, 0xE0, 0xB3, 0x86,
		0xE0, 0xB3, 0x82, 0xE0, 0xB3, 0x95, 0xF6, 0xE0,
		0xB5, 0x86, 0xE0, 0xB4, 0xBE, 0xF6, 0xE0, 0xB5,
		0x87, 0xE0, 0xB4, 0xBE, 0xF6, 0xE0, 0xB5, 0x86,
		0xE0, 0xB5, 0x97, 0xF6, 0xE0, 0xB7, 0x99, 0xE0,
		0xB7, 0x8A, 0xF6, 0xE0, 0xB7, 0x99, 0xE0, 0xB7,
		0x8F, 0xF6, 0xE0, 0xB7, 0x99, 0xE0, 0xB7, 0x8F,
		0xE0, 0xB7, 0x8A, 0xF6, 0xE0, 0xB7, 0x99, 0xE0,
		0xB7, 0x9F, 0xE0, 0xB9, 0x8D, 0xE0, 0xB8, 0xB2,
		0xE0, 0xBB, 0x8D, 0xE0, 0xBA, 0xB2, 0xE0, 0xBA,
		0xAB, 0xE0, 0xBA, 0x99, 0xE0, 0xBA, 0xAB, 0xE0,
		0xBA, 0xA1, 0xE0, 0xBC, 0x8B, 0xF6, 0xE0, 0xBD,
		0x82, 0xE0, 0xBE, 0xB7, 0xF6, 0xE0, 0xBD, 0x8C,
		0xE0, 0xBE, 0xB7, 0xF6, 0xE0, 0xBD, 0x91, 0xE0,
		0xBE, 0xB7, 0xF6, 0xE0, 0xBD, 0x96, 0xE0, 0xBE,
		0xB7, 0xF6, 0xE0, 0xBD, 0x9B, 0xE0, 0xBE, 0xB7,
		0xF6, 0xE0, 0xBD, 0x80, 0xE0, 0xBE, 0xB5, 0xF6,
		0xE0, 0xBD, 0xB1, 0xE0, 0xBD, 0xB2, 0xF6, 0xE0,
		0xBD, 0xB1, 0xE0, 0xBD, 0xB4, 0xF6, 0xE0, 0xBE,
		0xB2, 0xE0, 0xBE, 0x80, 0xE0, 0xBE, 0xB2, 0xE0,
		0xBD, 0xB1, 0xE0, 0xBE, 0x80, 0xF6, 0xE0, 0xBE,
		0xB3, 0xE0, 0xBE, 0x80, 0xE0, 0xBE, 0xB3, 0xE0,
		0xBD, 0xB1, 0xE0, 0xBE, 0x80, 0xF6, 0xE0, 0xBD,
		0xB1, 0xE0, 0xBE, 0x80, 0xF6, 0xE0, 0xBE, 0x92,
		0xE0, 0xBE, 0xB7, 0xF6, 0xE0, 0xBE, 0x9C, 0xE0,
		0xBE, 0xB7, 0xF6, 0xE0, 0xBE, 0xA1, 0xE0, 0xBE,
		0xB7, 0xF6, 0xE0, 0xBE, 0xA6, 0xE0, 0xBE, 0xB7,
		0xF6, 0xE0, 0xBE, 0xAB, 0xE0, 0xBE, 0xB7, 0xF6,
		0xE0, 0xBE, 0x90, 0xE0, 0xBE, 0xB5, 0xF6, 0xE1,
		0x80, 0xA5, 0xE1, 0x80, 0xAE, 0xF6, 0x41, 0xCC,
		0xA5, 0xF6, 0x61, 0xCC, 0xA5, 0xF6, 0x42, 0xCC,
		0x87, 0xF6, 0x62, 0xCC, 0x87, 0xF6, 0x42, 0xCC,
		0xA3, 0xF6, 0x62, 0xCC, 0xA3, 0xF6, 0x42, 0xCC,
		0xB1, 0xF6, 0x62, 0xCC, 0xB1, 0xF6, 0x43, 0xCC,
		0xA7, 0xCC, 0x81, 0xF6, 0x63, 0xCC, 0xA7, 0xCC,
		0x81, 0xF6, 0x44, 0xCC, 0x87, 0xF6, 0x64, 0xCC,
		0x87, 0xF6, 0x44, 0xCC, 0xA3, 0xF6, 0x64, 0xCC,
		0xA3, 0xF6, 0x44, 0xCC, 0xB1, 0xF6, 0x64, 0xCC,
		0xB1, 0xF6, 0x44, 0xCC, 0xA7, 0xF6, 0x64, 0xCC,
		0xA7, 0xF6, 0x44, 0xCC, 0xAD, 0xF6, 0x64, 0xCC,
		0xAD, 0xF6, 0x45, 0xCC, 0x84, 0xCC, 0x80, 0xF6,
		0x65, 0xCC, 0x84, 0xCC, 0x80, 0xF6, 0x45, 0xCC,
		0x84, 0xCC, 0x81, 0xF6, 0x65, 0xCC, 0x84, 0xCC,
		0x81, 0xF6, 0x45, 0xCC, 0xAD, 0xF6, 0x65, 0xCC,
		0xAD, 0xF6, 0x45, 0xCC, 0xB0, 0xF6, 0x65, 0xCC,
		0xB0, 0xF6, 0x45, 0xCC, 0xA7, 0xCC, 0x86, 0xF6,
		0x65, 0xCC, 0xA7, 0xCC, 0x86, 0xF6, 0x46, 0xCC,
		0x87, 0xF6, 0x66, 0xCC, 0x87, 0xF6, 0x47, 0xCC,
		0x84, 0xF6, 0x67, 0xCC, 0x84, 0xF6, 0x48, 0xCC,
		0x87, 0xF6, 0x68, 0xCC, 0x87, 0xF6, 0x48, 0xCC,
		0xA3, 0xF6, 0x68, 0xCC, 0xA3, 0xF6, 0x48, 0xCC,
		0x88, 0xF6, 0x68, 0xCC, 0x88, 0xF6, 0x48, 0xCC,
		0xA7, 0xF6, 0x68, 0xCC, 0xA7, 0xF6, 0x48, 0xCC,
		0xAE, 0xF6, 0x68, 0xCC, 0xAE, 0xF6, 0x49, 0xCC,
		0xB0, 0xF6, 0x69, 0xCC, 0xB0, 0xF6, 0x49, 0xCC,
		0x88, 0xCC, 0x81, 0xF6, 0x69, 0xCC, 0x88, 0xCC,
		0x81, 0xF6, 0x4B, 0xCC, 0x81, 0xF6, 0x6B, 0xCC,
		0x81, 0xF6, 0x4B, 0xCC, 0xA3, 0xF6, 0x6B, 0xCC,
		0xA3, 0xF6, 0x4B, 0xCC, 0xB1, 0xF6, 0x6B, 0xCC,
		0xB1, 0xF6, 0x4C, 0xCC, 0xA3, 0xF6, 0x6C, 0xCC,
		0xA3, 0xF6, 0x4C, 0xCC, 0xA3, 0xCC, 0x84, 0xF6,
		0x6C, 0xCC, 0xA3, 0xCC, 0x84, 0xF6, 0x4C, 0xCC,
		0xB1, 0xF6, 0x6C, 0xCC, 0xB1, 0xF6, 0x4C, 0xCC,
		0xAD, 0xF6, 0x6C, 0xCC, 0xAD, 0xF6, 0x4D, 0xCC,
		0x81, 0xF6, 0x6D, 0xCC, 0x81, 0xF6, 0x4D, 0xCC,
		0x87, 0xF6, 0x6D, 0xCC, 0x87, 0xF6, 0x4D, 0xCC,
		0xA3, 0xF6, 0x6D, 0xCC, 0xA3, 0xF6, 0x4E, 0xCC,
		0x87, 0xF6, 0x6E, 0xCC, 0x87, 0xF6, 0x4E, 0xCC,
		0xA3, 0xF6, 0x6E, 0xCC, 0xA3, 0xF6, 0x4E, 0xCC,
		0xB1, 0xF6, 0x6E, 0xCC, 0xB1, 0xF6, 0x4E, 0xCC,
		0xAD, 0xF6, 0x6E, 0xCC, 0xAD, 0xF6, 0x4F, 0xCC,
		0x83, 0xCC, 0x81, 0xF6, 0x6F, 0xCC, 0x83, 0xCC,
		0x81, 0xF6, 0x4F, 0xCC, 0x83, 0xCC, 0x88, 0xF6,
		0x6F, 0xCC, 0x83, 0xCC, 0x88, 0xF6, 0x4F, 0xCC,
		0x84, 0xCC, 0x80, 0xF6, 0x6F, 0xCC, 0x84, 0xCC,
		0x80, 0xF6, 0x4F, 0xCC, 0x84, 0xCC, 0x81, 0xF6,
		0x6F, 0xCC, 0x84, 0xCC, 0x81, 0xF6, 0x50, 0xCC,
		0x81, 0xF6, 0x70, 0xCC, 0x81, 0xF6, 0x50, 0xCC,
		0x87, 0xF6, 0x70, 0xCC, 0x87, 0xF6, 0x52, 0xCC,
		0x87, 0xF6, 0x72, 0xCC, 0x87, 0xF6, 0x52, 0xCC,
		0xA3, 0xF6, 0x72, 0xCC, 0xA3, 0xF6, 0x52, 0xCC,
		0xA3, 0xCC, 0x84, 0xF6, 0x72, 0xCC, 0xA3, 0xCC,
		0x84, 0xF6, 0x52, 0xCC, 0xB1, 0xF6, 0x72, 0xCC,
		0xB1, 0xF6, 0x53, 0xCC, 0x87, 0xF6, 0x73, 0xCC,
		0x87, 0xF6, 0x53, 0xCC, 0xA3, 0xF6, 0x73, 0xCC,
		0xA3, 0xF6, 0x53, 0xCC, 0x81, 0xCC, 0x87, 0xF6,
		0x73, 0xCC, 0x81, 0xCC, 0x87, 0xF6, 0x53, 0xCC,
		0x8C, 0xCC, 0x87, 0xF6, 0x73, 0xCC, 0x8C, 0xCC,
		0x87, 0xF6, 0x53, 0xCC, 0xA3, 0xCC, 0x87, 0xF6,
		0x73, 0xCC, 0xA3, 0xCC, 0x87, 0xF6, 0x54, 0xCC,
		0x87, 0xF6, 0x74, 0xCC, 0x87, 0xF6, 0x54, 0xCC,
		0xA3, 0xF6, 0x74, 0xCC, 0xA3, 0xF6, 0x54, 0xCC,
		0xB1, 0xF6, 0x74, 0xCC, 0xB1, 0xF6, 0x54, 0xCC,
		0xAD, 0xF6, 0x74, 0xCC, 0xAD, 0xF6, 0x55, 0xCC,
		0xA4, 0xF6, 0x75, 0xCC, 0xA4, 0xF6, 0x55, 0xCC,
		0xB0, 0xF6, 0x75, 0xCC, 0xB0, 0xF6, 0x55, 0xCC,
		0xAD, 0xF6, 0x75, 0xCC, 0xAD, 0xF6, 0x55, 0xCC,
		0x83, 0xCC, 0x81, 0xF6, 0x75, 0xCC, 0x83, 0xCC,
		0x81, 0xF6, 0x55, 0xCC, 0x84, 0xCC, 0x88, 0xF6,
		0x75, 0xCC, 0x84, 0xCC, 0x88, 0xF6, 0x56, 0xCC,
		0x83, 0xF6, 0x76, 0xCC, 0x83, 0xF6, 0x56, 0xCC,
		0xA3, 0xF6, 0x76, 0xCC, 0xA3, 0xF6, 0x57, 0xCC,
		0x80, 0xF6, 0x77, 0xCC, 0x80, 0xF6, 0x57, 0xCC,
		0x81, 0xF6, 0x77, 0xCC, 0x81, 0xF6, 0x57, 0xCC,
		0x88, 0xF6, 0x77, 0xCC, 0x88, 0xF6, 0x57, 0xCC,
		0x87, 0xF6, 0x77, 0xCC, 0x87, 0xF6, 0x57, 0xCC,
		0xA3, 0xF6, 0x77, 0xCC, 0xA3, 0xF6, 0x58, 0xCC,
		0x87, 0xF6, 0x78, 0xCC, 0x87, 0xF6, 0x58, 0xCC,
		0x88, 0xF6, 0x78, 0xCC, 0x88, 0xF6, 0x59, 0xCC,
		0x87, 0xF6, 0x79, 0xCC, 0x87, 0xF6, 0x5A, 0xCC,
		0x82, 0xF6, 0x7A, 0xCC, 0x82, 0xF6, 0x5A, 0xCC,
		0xA3, 0xF6, 0x7A, 0xCC, 0xA3, 0xF6, 0x5A, 0xCC,
		0xB1, 0xF6, 0x7A, 0xCC, 0xB1, 0xF6, 0x68, 0xCC,
		0xB1, 0xF6, 0x74, 0xCC, 0x88, 0xF6, 0x77, 0xCC,
		0x8A, 0xF6, 0x79, 0xCC, 0x8A, 0x61, 0xCA, 0xBE,
		0xF5, 0x05, 0xC5, 0xBF, 0xCC, 0x87, 0x73, 0xCC,
		0x87, 0xF6, 0x41, 0xCC, 0xA3, 0xF6, 0x61, 0xCC,
		0xA3, 0xF6, 0x41, 0xCC, 0x89, 0xF6, 0x61, 0xCC,
		0x89, 0xF6, 0x41, 0xCC, 0x82, 0xCC, 0x81, 0xF6,
		0x61, 0xCC, 0x82, 0xCC, 0x81, 0xF6, 0x41, 0xCC,
		0x82, 0xCC, 0x80, 0xF6, 0x61, 0xCC, 0x82, 0xCC,
		0x80, 0xF6, 0x41, 0xCC, 0x82, 0xCC, 0x89, 0xF6,
		0x61, 0xCC, 0x82, 0xCC, 0x89, 0xF6, 0x41, 0xCC,
		0x82, 0xCC, 0x83, 0xF6, 0x61, 0xCC, 0x82, 0xCC,
		0x83, 0xF6, 0x41, 0xCC, 0xA3, 0xCC, 0x82, 0xF6,
		0x61, 0xCC, 0xA3, 0xCC, 0x82, 0xF6, 0x41, 0xCC,
		0x86, 0xCC, 0x81, 0xF6, 0x61, 0xCC, 0x86, 0xCC,
		0x81, 0xF6, 0x41, 0xCC, 0x86, 0xCC, 0x80, 0xF6,
		0x61, 0xCC, 0x86, 0xCC, 0x80, 0xF6, 0x41, 0xCC,
		0x86, 0xCC, 0x89, 0xF6, 0x61, 0xCC, 0x86, 0xCC,
		0x89, 0xF6, 0x41, 0xCC, 0x86, 0xCC, 0x83, 0xF6,
		0x61, 0xCC, 0x86, 0xCC, 0x83, 0xF6, 0x41, 0xCC,
		0xA3, 0xCC, 0x86, 0xF6, 0x61, 0xCC, 0xA3, 0xCC,
		0x86, 0xF6, 0x45, 0xCC, 0xA3, 0xF6, 0x65, 0xCC,
		0xA3, 0xF6, 0x45, 0xCC, 0x89, 0xF6, 0x65, 0xCC,
		0x89, 0xF6, 0x45, 0xCC, 0x83, 0xF6, 0x65, 0xCC,
		0x83, 0xF6, 0x45, 0xCC, 0x82, 0xCC, 0x81, 0xF6,
		0x65, 0xCC, 0x82, 0xCC, 0x81, 0xF6, 0x45, 0xCC,
		0x82, 0xCC, 0x80, 0xF6, 0x65, 0xCC, 0x82, 0xCC,
		0x80, 0xF6, 0x45, 0xCC, 0x82, 0xCC, 0x89, 0xF6,
		0x65, 0xCC, 0x82, 0xCC, 0x89, 0xF6, 0x45, 0xCC,
		0x82, 0xCC, 0x83, 0xF6, 0x65, 0xCC, 0x82, 0xCC,
		0x83, 0xF6, 0x45, 0xCC, 0xA3, 0xCC, 0x82, 0xF6,
		0x65, 0xCC, 0xA3, 0xCC, 0x82, 0xF6, 0x49, 0xCC,
		0x89, 0xF6, 0x69, 0xCC, 0x89, 0xF6, 0x49, 0xCC,
		0xA3, 0xF6, 0x69, 0xCC, 0xA3, 0xF6, 0x4F, 0xCC,
		0xA3, 0xF6, 0x6F, 0xCC, 0xA3, 0xF6, 0x4F, 0xCC,
		0x89, 0xF6, 0x6F, 0xCC, 0x89, 0xF6, 0x4F, 0xCC,
		0x82, 0xCC, 0x81, 0xF6, 0x6F, 0xCC, 0x82, 0xCC,
		0x81, 0xF6, 0x4F, 0xCC, 0x82, 0xCC, 0x80, 0xF6,
		0x6F, 0xCC, 0x82, 0xCC, 0x80, 0xF6, 0x4F, 0xCC,
		0x82, 0xCC, 0x89, 0xF6, 0x6F, 0xCC, 0x82, 0xCC,
		0x89, 0xF6, 0x4F, 0xCC, 0x82, 0xCC, 0x83, 0xF6,
		0x6F, 0xCC, 0x82, 0xCC, 0x83, 0xF6, 0x4F, 0xCC,
		0xA3, 0xCC, 0x82, 0xF6, 0x6F, 0xCC, 0xA3, 0xCC,
		0x82, 0xF6, 0x4F, 0xCC, 0x9B, 0xCC, 0x81, 0xF6,
		0x6F, 0xCC, 0x9B, 0xCC, 0x81, 0xF6, 0x4F, 0xCC,
		0x9B, 0xCC, 0x80, 0xF6, 0x6F, 0xCC, 0x9B, 0xCC,
		0x80, 0xF6, 0x4F, 0xCC, 0x9B, 0xCC, 0x89, 0xF6,
		0x6F, 0xCC, 0x9B, 0xCC, 0x89, 0xF6, 0x4F, 0xCC,
		0x9B, 0xCC, 0x83, 0xF6, 0x6F, 0xCC, 0x9B, 0xCC,
		0x83, 0xF6, 0x4F, 0xCC, 0x9B, 0xCC, 0xA3, 0xF6,
		0x6F, 0xCC, 0x9B, 0xCC, 0xA3, 0xF6, 0x55, 0xCC,
		0xA3, 0xF6, 0x75, 0xCC, 0xA3, 0xF6, 0x55, 0xCC,
		0x89, 0xF6, 0x75, 0xCC, 0x89, 0xF6, 0x55, 0xCC,
		0x9B, 0xCC, 0x81, 0xF6, 0x75, 0xCC, 0x9B, 0xCC,
		0x81, 0xF6, 0x55, 0xCC, 0x9B, 0xCC, 0x80, 0xF6,
		0x75, 0xCC, 0x9B, 0xCC, 0x80, 0xF6, 0x55, 0xCC,
		0x9B, 0xCC, 0x89, 0xF6, 0x75, 0xCC, 0x9B, 0xCC,
		0x89, 0xF6, 0x55, 0xCC, 0x9B, 0xCC, 0x83, 0xF6,
		0x75, 0xCC, 0x9B, 0xCC, 0x83, 0xF6, 0x55, 0xCC,
		0x9B, 0xCC, 0xA3, 0xF6, 0x75, 0xCC, 0x9B, 0xCC,
		0xA3, 0xF6, 0x59, 0xCC, 0x80, 0xF6, 0x79, 0xCC,
		0x80, 0xF6, 0x59, 0xCC, 0xA3, 0xF6, 0x79, 0xCC,
		0xA3, 0xF6, 0x59, 0xCC, 0x89, 0xF6, 0x79, 0xCC,
		0x89, 0xF6, 0x59, 0xCC, 0x83, 0xF6, 0x79, 0xCC,
		0x83, 0xF6, 0xCE, 0xB1, 0xCC, 0x93, 0xF6, 0xCE,
		0xB1, 0xCC, 0x94, 0xF6, 0xCE, 0xB1, 0xCC, 0x93,
		0xCC, 0x80, 0xF6, 0xCE, 0xB1, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCE, 0xB1, 0xCC, 0x93, 0xCC, 0x81,
		0xF6, 0xCE, 0xB1, 0xCC, 0x94, 0xCC, 0x81, 0xF6,
		0xCE, 0xB1, 0xCC, 0x93, 0xCD, 0x82, 0xF6, 0xCE,
		0xB1, 0xCC, 0x94, 0xCD, 0x82, 0xF6, 0xCE, 0x91,
		0xCC, 0x93, 0xF6, 0xCE, 0x91, 0xCC, 0x94, 0xF6,
		0xCE, 0x91, 0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE,
		0x91, 0xCC, 0x94, 0xCC, 0x80, 0xF6, 0xCE, 0x91,
		0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCE, 0x91, 0xCC,
		0x94, 0xCC, 0x81, 0xF6, 0xCE, 0x91, 0xCC, 0x93,
		0xCD, 0x82, 0xF6, 0xCE, 0x91, 0xCC, 0x94, 0xCD,
		0x82, 0xF6, 0xCE, 0xB5, 0xCC, 0x93, 0xF6, 0xCE,
		0xB5, 0xCC, 0x94, 0xF6, 0xCE, 0xB5, 0xCC, 0x93,
		0xCC, 0x80, 0xF6, 0xCE, 0xB5, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCE, 0xB5, 0xCC, 0x93, 0xCC, 0x81,
		0xF6, 0xCE, 0xB5, 0xCC, 0x94, 0xCC, 0x81, 0xF6,
		0xCE, 0x95, 0xCC, 0x93, 0xF6, 0xCE, 0x95, 0xCC,
		0x94, 0xF6, 0xCE, 0x95, 0xCC, 0x93, 0xCC, 0x80,
		0xF6, 0xCE, 0x95, 0xCC, 0x94, 0xCC, 0x80, 0xF6,
		0xCE, 0x95, 0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCE,
		0x95, 0xCC, 0x94, 0xCC, 0x81, 0xF6, 0xCE, 0xB7,
		0xCC, 0x93, 0xF6, 0xCE, 0xB7, 0xCC, 0x94, 0xF6,
		0xCE, 0xB7, 0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE,
		0xB7, 0xCC, 0x94, 0xCC, 0x80, 0xF6, 0xCE, 0xB7,
		0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCE, 0xB7, 0xCC,
		0x94, 0xCC, 0x81, 0xF6, 0xCE, 0xB7, 0xCC, 0x93,
		0xCD, 0x82, 0xF6, 0xCE, 0xB7, 0xCC, 0x94, 0xCD,
		0x82, 0xF6, 0xCE, 0x97, 0xCC, 0x93, 0xF6, 0xCE,
		0x97, 0xCC, 0x94, 0xF6, 0xCE, 0x97, 0xCC, 0x93,
		0xCC, 0x80, 0xF6, 0xCE, 0x97, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCE, 0x97, 0xCC, 0x93, 0xCC, 0x81,
		0xF6, 0xCE, 0x97, 0xCC, 0x94, 0xCC, 0x81, 0xF6,
		0xCE, 0x97, 0xCC, 0x93, 0xCD, 0x82, 0xF6, 0xCE,
		0x97, 0xCC, 0x94, 0xCD, 0x82, 0xF6, 0xCE, 0xB9,
		0xCC, 0x93, 0xF6, 0xCE, 0xB9, 0xCC, 0x94, 0xF6,
		0xCE, 0xB9, 0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE,
		0xB9, 0xCC, 0x94, 0xCC, 0x80, 0xF6, 0xCE, 0xB9,
		0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCE, 0xB9, 0xCC,
		0x94, 0xCC, 0x81, 0xF6, 0xCE, 0xB9, 0xCC, 0x93,
		0xCD, 0x82, 0xF6, 0xCE, 0xB9, 0xCC, 0x94, 0xCD,
		0x82, 0xF6, 0xCE, 0x99, 0xCC, 0x93, 0xF6, 0xCE,
		0x99, 0xCC, 0x94, 0xF6, 0xCE, 0x99, 0xCC, 0x93,
		0xCC, 0x80, 0xF6, 0xCE, 0x99, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCE, 0x99, 0xCC, 0x93, 0xCC, 0x81,
		0xF6, 0xCE, 0x99, 0xCC, 0x94, 0xCC, 0x81, 0xF6,
		0xCE, 0x99, 0xCC, 0x93, 0xCD, 0x82, 0xF6, 0xCE,
		0x99, 0xCC, 0x94, 0xCD, 0x82, 0xF6, 0xCE, 0xBF,
		0xCC, 0x93, 0xF6, 0xCE, 0xBF, 0xCC, 0x94, 0xF6,
		0xCE, 0xBF, 0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE,
		0xBF, 0xCC, 0x94, 0xCC, 0x80, 0xF6, 0xCE, 0xBF,
		0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCE, 0xBF, 0xCC,
		0x94, 0xCC, 0x81, 0xF6, 0xCE, 0x9F, 0xCC, 0x93,
		0xF6, 0xCE, 0x9F, 0xCC, 0x94, 0xF6, 0xCE, 0x9F,
		0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE, 0x9F, 0xCC,
		0x94, 0xCC, 0x80, 0xF6, 0xCE, 0x9F, 0xCC, 0x93,
		0xCC, 0x81, 0xF6, 0xCE, 0x9F, 0xCC, 0x94, 0xCC,
		0x81, 0xF6, 0xCF, 0x85, 0xCC, 0x93, 0xF6, 0xCF,
		0x85, 0xCC, 0x94, 0xF6, 0xCF, 0x85, 0xCC, 0x93,
		0xCC, 0x80, 0xF6, 0xCF, 0x85, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCF, 0x85, 0xCC, 0x93, 0xCC, 0x81,
		0xF6, 0xCF, 0x85, 0xCC, 0x94, 0xCC, 0x81, 0xF6,
		0xCF, 0x85, 0xCC, 0x93, 0xCD, 0x82, 0xF6, 0xCF,
		0x85, 0xCC, 0x94, 0xCD, 0x82, 0xF6, 0xCE, 0xA5,
		0xCC, 0x94, 0xF6, 0xCE, 0xA5, 0xCC, 0x94, 0xCC,
		0x80, 0xF6, 0xCE, 0xA5, 0xCC, 0x94, 0xCC, 0x81,
		0xF6, 0xCE, 0xA5, 0xCC, 0x94, 0xCD, 0x82, 0xF6,
		0xCF, 0x89, 0xCC, 0x93, 0xF6, 0xCF, 0x89, 0xCC,
		0x94, 0xF6, 0xCF, 0x89, 0xCC, 0x93, 0xCC, 0x80,
		0xF6, 0xCF, 0x89, 0xCC, 0x94, 0xCC, 0x80, 0xF6,
		0xCF, 0x89, 0xCC, 0x93, 0xCC, 0x81, 0xF6, 0xCF,
		0x89, 0xCC, 0x94, 0xCC, 0x81, 0xF6, 0xCF, 0x89,
		0xCC, 0x93, 0xCD, 0x82, 0xF6, 0xCF, 0x89, 0xCC,
		0x94, 0xCD, 0x82, 0xF6, 0xCE, 0xA9, 0xCC, 0x93,
		0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xF6, 0xCE, 0xA9,
		0xCC, 0x93, 0xCC, 0x80, 0xF6, 0xCE, 0xA9, 0xCC,
		0x94, 0xCC, 0x80, 0xF6, 0xCE, 0xA9, 0xCC, 0x93,
		0xCC, 0x81, 0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xCC,
		0x81, 0xF6, 0xCE, 0xA9, 0xCC, 0x93, 0xCD, 0x82,
		0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xCD, 0x82, 0xF6,
		0xCE, 0xB1, 0xCC, 0x80, 0xF6, 0xCE, 0xB1, 0xCC,
		0x81, 0xF6, 0xCE, 0xB5, 0xCC, 0x80, 0xF6, 0xCE,
		0xB5, 0xCC, 0x81, 0xF6, 0xCE, 0xB7, 0xCC, 0x80,
		0xF6, 0xCE, 0xB7, 0xCC, 0x81, 0xF6, 0xCE, 0xB9,
		0xCC, 0x80, 0xF6, 0xCE, 0xB9, 0xCC, 0x81, 0xF6,
		0xCE, 0xBF, 0xCC, 0x80, 0xF6, 0xCE, 0xBF, 0xCC,
		0x81, 0xF6, 0xCF, 0x85, 0xCC, 0x80, 0xF6, 0xCF,
		0x85, 0xCC, 0x81, 0xF6, 0xCF, 0x89, 0xCC, 0x80,
		0xF6, 0xCF, 0x89, 0xCC, 0x81, 0xF6, 0xCE, 0xB1,
		0xCC, 0x93, 0xCD, 0x85, 0xF6, 0xCE, 0xB1, 0xCC,
		0x94, 0xCD, 0x85, 0xF6, 0xCE, 0xB1, 0xCC, 0x93,
		0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE, 0xB1, 0xCC,
		0x94, 0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE, 0xB1,
		0xCC, 0x93, 0xCC, 0x81, 0xCD, 0x85, 0xF6, 0xCE,
		0xB1, 0xCC, 0x94, 0xCC, 0x81, 0xCD, 0x85, 0xF6,
		0xCE, 0xB1, 0xCC, 0x93, 0xCD, 0x82, 0xCD, 0x85,
		0xF6, 0xCE, 0xB1, 0xCC, 0x94, 0xCD, 0x82, 0xCD,
		0x85, 0xF6, 0xCE, 0x91, 0xCC, 0x93, 0xCD, 0x85,
		0xF6, 0xCE, 0x91, 0xCC, 0x94, 0xCD, 0x85, 0xF6,
		0xCE, 0x91, 0xCC, 0x93, 0xCC, 0x80, 0xCD, 0x85,
		0xF6, 0xCE, 0x91, 0xCC, 0x94, 0xCC, 0x80, 0xCD,
		0x85, 0xF6, 0xCE, 0x91, 0xCC, 0x93, 0xCC, 0x81,
		0xCD, 0x85, 0xF6, 0xCE, 0x91, 0xCC, 0x94, 0xCC,
		0x81, 0xCD, 0x85, 0xF6, 0xCE, 0x91, 0xCC, 0x93,
		0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0x91, 0xCC,
		0x94, 0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0xB7,
		0xCC, 0x93, 0xCD, 0x85, 0xF6, 0xCE, 0xB7, 0xCC,
		0x94, 0xCD, 0x85, 0xF6, 0xCE, 0xB7, 0xCC, 0x93,
		0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE, 0xB7, 0xCC,
		0x94, 0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE, 0xB7,
		0xCC, 0x93, 0xCC, 0x81, 0xCD, 0x85, 0xF6, 0xCE,
		0xB7, 0xCC, 0x94, 0xCC, 0x81, 0xCD, 0x85, 0xF6,
		0xCE, 0xB7, 0xCC, 0x93, 0xCD, 0x82, 0xCD, 0x85,
		0xF6, 0xCE, 0xB7, 0xCC, 0x94, 0xCD, 0x82, 0xCD,
		0x85, 0xF6, 0xCE, 0x97, 0xCC, 0x93, 0xCD, 0x85,
		0xF6, 0xCE, 0x97, 0xCC, 0x94, 0xCD, 0x85, 0xF6,
		0xCE, 0x97, 0xCC, 0x93, 0xCC, 0x80, 0xCD, 0x85,
		0xF6, 0xCE, 0x97, 0xCC, 0x94, 0xCC, 0x80, 0xCD,
		0x85, 0xF6, 0xCE, 0x97, 0xCC, 0x93, 0xCC, 0x81,
		0xCD, 0x85, 0xF6, 0xCE, 0x97, 0xCC, 0x94, 0xCC,
		0x81, 0xCD, 0x85, 0xF6, 0xCE, 0x97, 0xCC, 0x93,
		0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0x97, 0xCC,
		0x94, 0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCF, 0x89,
		0xCC, 0x93, 0xCD, 0x85, 0xF6, 0xCF, 0x89, 0xCC,
		0x94, 0xCD, 0x85, 0xF6, 0xCF, 0x89, 0xCC, 0x93,
		0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCF, 0x89, 0xCC,
		0x94, 0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCF, 0x89,
		0xCC, 0x93, 0xCC, 0x81, 0xCD, 0x85, 0xF6, 0xCF,
		0x89, 0xCC, 0x94, 0xCC, 0x81, 0xCD, 0x85, 0xF6,
		0xCF, 0x89, 0xCC, 0x93, 0xCD, 0x82, 0xCD, 0x85,
		0xF6, 0xCF, 0x89, 0xCC, 0x94, 0xCD, 0x82, 0xCD,
		0x85, 0xF6, 0xCE, 0xA9, 0xCC, 0x93, 0xCD, 0x85,
		0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xCD, 0x85, 0xF6,
		0xCE, 0xA9, 0xCC, 0x93, 0xCC, 0x80, 0xCD, 0x85,
		0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xCC, 0x80, 0xCD,
		0x85, 0xF6, 0xCE, 0xA9, 0xCC, 0x93, 0xCC, 0x81,
		0xCD, 0x85, 0xF6, 0xCE, 0xA9, 0xCC, 0x94, 0xCC,
		0x81, 0xCD, 0x85, 0xF6, 0xCE, 0xA9, 0xCC, 0x93,
		0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0xA9, 0xCC,
		0x94, 0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0xB1,
		0xCC, 0x86, 0xF6, 0xCE, 0xB1, 0xCC, 0x84, 0xF6,
		0xCE, 0xB1, 0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE,
		0xB1, 0xCD, 0x85, 0xF6, 0xCE, 0xB1, 0xCC, 0x81,
		0xCD, 0x85, 0xF6, 0xCE, 0xB1, 0xCD, 0x82, 0xF6,
		0xCE, 0xB1, 0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE,
		0x91, 0xCC, 0x86, 0xF6, 0xCE, 0x91, 0xCC, 0x84,
		0xF6, 0xCE, 0x91, 0xCC, 0x80, 0xF6, 0xCE, 0x91,
		0xCC, 0x81, 0xF6, 0xCE, 0x91, 0xCD, 0x85, 0x20,
		0xCC, 0x93, 0xF6, 0xCE, 0xB9, 0x20, 0xCC, 0x93,
		0x20, 0xCD, 0x82, 0xF5, 0x05, 0xC2, 0xA8, 0xCD,
		0x82, 0x20, 0xCC, 0x88, 0xCD, 0x82, 0xF6, 0xCE,
		0xB7, 0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCE, 0xB7,
		0xCD, 0x85, 0xF6, 0xCE, 0xB7, 0xCC, 0x81, 0xCD,
		0x85, 0xF6, 0xCE, 0xB7, 0xCD, 0x82, 0xF6, 0xCE,
		0xB7, 0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0x95,
		0xCC, 0x80, 0xF6, 0xCE, 0x95, 0xCC, 0x81, 0xF6,
		0xCE, 0x97, 0xCC, 0x80, 0xF6, 0xCE, 0x97, 0xCC,
		0x81, 0xF6, 0xCE, 0x97, 0xCD, 0x85, 0xF5, 0x06,
		0xE1, 0xBE, 0xBF, 0xCC, 0x80, 0x20, 0xCC, 0x93,
		0xCC, 0x80, 0xF5, 0x06, 0xE1, 0xBE, 0xBF, 0xCC,
		0x81, 0x20, 0xCC, 0x93, 0xCC, 0x81, 0xF5, 0x06,
		0xE1, 0xBE, 0xBF, 0xCD, 0x82, 0x20, 0xCC, 0x93,
		0xCD, 0x82, 0xF6, 0xCE, 0xB9, 0xCC, 0x86, 0xF6,
		0xCE, 0xB9, 0xCC, 0x84, 0xF6, 0xCE, 0xB9, 0xCC,
		0x88, 0xCC, 0x80, 0xF6, 0xCE, 0xB9, 0xCC, 0x88,
		0xCC, 0x81, 0xF6, 0xCE, 0xB9, 0xCD, 0x82, 0xF6,
		0xCE, 0xB9, 0xCC, 0x88, 0xCD, 0x82, 0xF6, 0xCE,
		0x99, 0xCC, 0x86, 0xF6, 0xCE, 0x99, 0xCC, 0x84,
		0xF6, 0xCE, 0x99, 0xCC, 0x80, 0xF6, 0xCE, 0x99,
		0xCC, 0x81, 0xF5, 0x06, 0xE1, 0xBF, 0xBE, 0xCC,
		0x80, 0x20, 0xCC, 0x94, 0xCC, 0x80, 0xF5, 0x06,
		0xE1, 0xBF, 0xBE, 0xCC, 0x81, 0x20, 0xCC, 0x94,
		0xCC, 0x81, 0xF5, 0x06, 0xE1, 0xBF, 0xBE, 0xCD,
		0x82, 0x20, 0xCC, 0x94, 0xCD, 0x82, 0xF6, 0xCF,
		0x85, 0xCC, 0x86, 0xF6, 0xCF, 0x85, 0xCC, 0x84,
		0xF6, 0xCF, 0x85, 0xCC, 0x88, 0xCC, 0x80, 0xF6,
		0xCF, 0x85, 0xCC, 0x88, 0xCC, 0x81, 0xF6, 0xCF,
		0x81, 0xCC, 0x93, 0xF6, 0xCF, 0x81, 0xCC, 0x94,
		0xF6, 0xCF, 0x85, 0xCD, 0x82, 0xF6, 0xCF, 0x85,
		0xCC, 0x88, 0xCD, 0x82, 0xF6, 0xCE, 0xA5, 0xCC,
		0x86, 0xF6, 0xCE, 0xA5, 0xCC, 0x84, 0xF6, 0xCE,
		0xA5, 0xCC, 0x80, 0xF6, 0xCE, 0xA5, 0xCC, 0x81,
		0xF6, 0xCE, 0xA1, 0xCC, 0x94, 0xF5, 0x05, 0xC2,
		0xA8, 0xCC, 0x80, 0x20, 0xCC, 0x88, 0xCC, 0x80,
		0xF5, 0x05, 0xC2, 0xA8, 0xCC, 0x81, 0x20, 0xCC,
		0x88, 0xCC, 0x81, 0xF6, 0x60, 0xF6, 0xCF, 0x89,
		0xCC, 0x80, 0xCD, 0x85, 0xF6, 0xCF, 0x89, 0xCD,
		0x85, 0xF6, 0xCF, 0x89, 0xCC, 0x81, 0xCD, 0x85,
		0xF6, 0xCF, 0x89, 0xCD, 0x82, 0xF6, 0xCF, 0x89,
		0xCD, 0x82, 0xCD, 0x85, 0xF6, 0xCE, 0x9F, 0xCC,
		0x80, 0xF6, 0xCE, 0x9F, 0xCC, 0x81, 0xF6, 0xCE,
		0xA9, 0xCC, 0x80, 0xF6, 0xCE, 0xA9, 0xCC, 0x81,
		0xF6, 0xCE, 0xA9, 0xCD, 0x85, 0xF5, 0x03, 0xC2,
		0xB4, 0x20, 0xCC, 0x81, 0x20, 0xCC, 0x94, 0xF5,
		0x04, 0xE2, 0x80, 0x82, 0x20, 0xF5, 0x04, 0xE2,
		0x80, 0x83, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x20, 0x20, 0xE2, 0x80, 0x90, 0x20,
		0xCC, 0xB3, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E, 0x2E,
		0x20, 0xE2, 0x80, 0xB2, 0xE2, 0x80, 0xB2, 0xE2,
		0x80, 0xB2, 0xE2, 0x80, 0xB2, 0xE2, 0x80, 0xB2,
		0xE2, 0x80, 0xB5, 0xE2, 0x80, 0xB5, 0xE2, 0x80,
		0xB5, 0xE2, 0x80, 0xB5, 0xE2, 0x80, 0xB5, 0x21,
		0x21, 0x20, 0xCC, 0x85, 0x3F, 0x3F, 0x3F, 0x21,
		0x21, 0x3F, 0xE2, 0x80, 0xB2, 0xE2, 0x80, 0xB2,
		0xE2, 0x80, 0xB2, 0xE2, 0x80, 0xB2, 0x20, 0x30,
		0x69, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x2B,
		0xE2, 0x88, 0x92, 0x3D, 0x28, 0x29, 0x6E, 0x30,
		0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
		0x39, 0x2B, 0xE2, 0x88, 0x92, 0x3D, 0x28, 0x29,
		0x52, 0x73, 0x61, 0x2F, 0x63, 0x61, 0x2F, 0x73,
		0x43, 0xC2, 0xB0, 0x43, 0x63, 0x2F, 0x6F, 0x63,
		0x2F, 0x75, 0xC6, 0x90, 0xC2, 0xB0, 0x46, 0x67,
		0x48, 0x48, 0x48, 0x68, 0xC4, 0xA7, 0x49, 0x49,
		0x4C, 0x6C, 0x4E, 0x4E, 0x6F, 0x50, 0x51, 0x52,
		0x52, 0x52, 0x53, 0x4D, 0x54, 0x45, 0x4C, 0x54,
		0x4D, 0x5A, 0xF6, 0xCE, 0xA9, 0x5A, 0xF6, 0x4B,
		0xF6, 0x41, 0xCC, 0x8A, 0x42, 0x43, 0x65, 0x45,
		0x46, 0x4D, 0x6F, 0xD7, 0x90, 0xD7, 0x91, 0xD7,
		0x92, 0xD7, 0x93, 0x69, 0xCE, 0xB3, 0xCE, 0x93,
		0xCE, 0xA0, 0xE2, 0x88, 0x91, 0x44, 0x64, 0x65,
		0x69, 0x6A, 0x31, 0xE2, 0x81, 0x84, 0x33, 0x32,
		0xE2, 0x81, 0x84, 0x33, 0x31, 0xE2, 0x81, 0x84,
		0x35, 0x32, 0xE2, 0x81, 0x84, 0x35, 0x33, 0xE2,
		0x81, 0x84, 0x35, 0x34, 0xE2, 0x81, 0x84, 0x35,
		0x31, 0xE2, 0x81, 0x84, 0x36, 0x35, 0xE2, 0x81,
		0x84, 0x36, 0x31, 0xE2, 0x81, 0x84, 0x38, 0x33,
		0xE2, 0x81, 0x84, 0x38, 0x35, 0xE2, 0x81, 0x84,
		0x38, 0x37, 0xE2, 0x81, 0x84, 0x38, 0x31, 0xE2,
		0x81, 0x84, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49,
		0x49, 0x56, 0x56, 0x56, 0x49, 0x56, 0x49, 0x49,
		0x56, 0x49, 0x49, 0x49, 0x49, 0x58, 0x58, 0x58,
		0x49, 0x58, 0x49, 0x49, 0x4C, 0x43, 0x44, 0x4D,
		0x69, 0x69, 0x69, 0x69, 0x69, 0x69, 0x69, 0x76,
		0x76, 0x76, 0x69, 0x76, 0x69, 0x69, 0x76, 0x69,
		0x69, 0x69, 0x69, 0x78, 0x78, 0x78, 0x69, 0x78,
		0x69, 0x69, 0x6C, 0x63, 0x64, 0x6D, 0xF6, 0xE2,
		0x86, 0x90, 0xCC, 0xB8, 0xF6, 0xE2, 0x86, 0x92,
		0xCC, 0xB8, 0xF6, 0xE2, 0x86, 0x94, 0xCC, 0xB8,
		0xF6, 0xE2, 0x87, 0x90, 0xCC, 0xB8, 0xF6, 0xE2,
		0x87, 0x94, 0xCC, 0xB8, 0xF6, 0xE2, 0x87, 0x92,
		0xCC, 0xB8, 0xF6, 0xE2, 0x88, 0x83, 0xCC, 0xB8,
		0xF6, 0xE2, 0x88, 0x88, 0xCC, 0xB8, 0xF6, 0xE2,
		0x88, 0x8B, 0xCC, 0xB8, 0xF6, 0xE2, 0x88, 0xA3,
		0xCC, 0xB8, 0xF6, 0xE2, 0x88, 0xA5, 0xCC, 0xB8,
		0xE2, 0x88, 0xAB, 0xE2, 0x88, 0xAB, 0xE2, 0x88,
		0xAB, 0xE2, 0x88, 0xAB, 0xE2, 0x88, 0xAB, 0xE2,
		0x88, 0xAE, 0xE2, 0x88, 0xAE, 0xE2, 0x88, 0xAE,
		0xE2, 0x88, 0xAE, 0xE2, 0x88, 0xAE, 0xF6, 0xE2,
		0x88, 0xBC, 0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0x83,
		0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0x85, 0xCC, 0xB8,
		0xF6, 0xE2, 0x89, 0x88, 0xCC, 0xB8, 0xF6, 0x3D,
		0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xA1, 0xCC, 0xB8,
		0xF6, 0xE2, 0x89, 0x8D, 0xCC, 0xB8, 0xF6, 0x3C,
		0xCC, 0xB8, 0xF6, 0x3E, 0xCC, 0xB8, 0xF6, 0xE2,
		0x89, 0xA4, 0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xA5,
		0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xB2, 0xCC, 0xB8,
		0xF6, 0xE2, 0x89, 0xB3, 0xCC, 0xB8, 0xF6, 0xE2,
		0x89, 0xB6, 0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xB7,
		0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xBA, 0xCC, 0xB8,
		0xF6, 0xE2, 0x89, 0xBB, 0xCC, 0xB8, 0xF6, 0xE2,
		0x8A, 0x82, 0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0x83,
		0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0x86, 0xCC, 0xB8,
		0xF6, 0xE2, 0x8A, 0x87, 0xCC, 0xB8, 0xF6, 0xE2,
		0x8A, 0xA2, 0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0xA8,
		0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0xA9, 0xCC, 0xB8,
		0xF6, 0xE2, 0x8A, 0xAB, 0xCC, 0xB8, 0xF6, 0xE2,
		0x89, 0xBC, 0xCC, 0xB8, 0xF6, 0xE2, 0x89, 0xBD,
		0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0x91, 0xCC, 0xB8,
		0xF6, 0xE2, 0x8A, 0x92, 0xCC, 0xB8, 0xF6, 0xE2,
		0x8A, 0xB2, 0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0xB3,
		0xCC, 0xB8, 0xF6, 0xE2, 0x8A, 0xB4, 0xCC, 0xB8,
		0xF6, 0xE2, 0x8A, 0xB5, 0xCC, 0xB8, 0xF6, 0xE3,
		0x80, 0x88, 0xF6, 0xE3, 0x80, 0x89, 0x31, 0x32,
		0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x31,
		0x30, 0x31, 0x31, 0x31, 0x32, 0x31, 0x33, 0x31,
		0x34, 0x31, 0x35, 0x31, 0x36, 0x31, 0x37, 0x31,
		0x38, 0x31, 0x39, 0x32, 0x30, 0x28, 0x31, 0x29,
		0x28, 0x32, 0x29, 0x28, 0x33, 0x29, 0x28, 0x34,
		0x29, 0x28, 0x35, 0x29, 0x28, 0x36, 0x29, 0x28,
		0x37, 0x29, 0x28, 0x38, 0x29, 0x28, 0x39, 0x29,
		0x28, 0x31, 0x30, 0x29, 0x28, 0x31, 0x31, 0x29,
		0x28, 0x31, 0x32, 0x29, 0x28, 0x31, 0x33, 0x29,
		0x28, 0x31, 0x34, 0x29, 0x28, 0x31, 0x35, 0x29,
		0x28, 0x31, 0x36, 0x29, 0x28, 0x31, 0x37, 0x29,
		0x28, 0x31, 0x38, 0x29, 0x28, 0x31, 0x39, 0x29,
		0x28, 0x32, 0x30, 0x29, 0x31, 0x2E, 0x32, 0x2E,
		0x33, 0x2E, 0x34, 0x2E, 0x35, 0x2E, 0x36, 0x2E,
		0x37, 0x2E, 0x38, 0x2E, 0x39, 0x2E, 0x31, 0x30,
		0x2E, 0x31, 0x31, 0x2E, 0x31, 0x32, 0x2E, 0x31,
		0x33, 0x2E, 0x31, 0x34, 0x2E, 0x31, 0x35, 0x2E,
		0x31, 0x36, 0x2E, 0x31, 0x37, 0x2E, 0x31, 0x38,
		0x2E, 0x31, 0x39, 0x2E, 0x32, 0x30, 0x2E, 0x28,
		0x61, 0x29, 0x28, 0x62, 0x29, 0x28, 0x63, 0x29,
		0x28, 0x64, 0x29, 0x28, 0x65, 0x29, 0x28, 0x66,
		0x29, 0x28, 0x67, 0x29, 0x28, 0x68, 0x29, 0x28,
		0x69, 0x29, 0x28, 0x6A, 0x29, 0x28, 0x6B, 0x29,
		0x28, 0x6C, 0x29, 0x28, 0x6D, 0x29, 0x28, 0x6E,
		0x29, 0x28, 0x6F, 0x29, 0x28, 0x70, 0x29, 0x28,
		0x71, 0x29, 0x28, 0x72, 0x29, 0x28, 0x73, 0x29,
		0x28, 0x74, 0x29, 0x28, 0x75, 0x29, 0x28, 0x76,
		0x29, 0x28, 0x77, 0x29, 0x28, 0x78, 0x29, 0x28,
		0x79, 0x29, 0x28, 0x7A, 0x29, 0x41, 0x42, 0x43,
		0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B,
		0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53,
		0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x61,
		0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
		0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71,
		0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79,
		0x7A, 0x30, 0xE2, 0x88, 0xAB, 0xE2, 0x88, 0xAB,
		0xE2, 0x88, 0xAB, 0xE2, 0x88, 0xAB, 0x3A, 0x3A,
		0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0xF6, 0xE2,
		0xAB, 0x9D, 0xCC, 0xB8, 0xE6, 0xAF, 0x8D, 0xE9,
		0xBE, 0x9F, 0xE4, 0xB8, 0x80, 0xE4, 0xB8, 0xA8,
		0xE4, 0xB8, 0xB6, 0xE4, 0xB8, 0xBF, 0xE4, 0xB9,
		0x99, 0xE4, 0xBA, 0x85, 0xE4, 0xBA, 0x8C, 0xE4,
		0xBA, 0xA0, 0xE4, 0xBA, 0xBA, 0xE5, 0x84, 0xBF,
		0xE5, 0x85, 0xA5, 0xE5, 0x85, 0xAB, 0xE5, 0x86,
		0x82, 0xE5, 0x86, 0x96, 0xE5, 0x86, 0xAB, 0xE5,
		0x87, 0xA0, 0xE5, 0x87, 0xB5, 0xE5, 0x88, 0x80,
		0xE5, 0x8A, 0x9B, 0xE5, 0x8B, 0xB9, 0xE5, 0x8C,
		0x95, 0xE5, 0x8C, 0x9A, 0xE5, 0x8C, 0xB8, 0xE5,
		0x8D, 0x81, 0xE5, 0x8D, 0x9C, 0xE5, 0x8D, 0xA9,
		0xE5, 0x8E, 0x82, 0xE5, 0x8E, 0xB6, 0xE5, 0x8F,
		0x88, 0xE5, 0x8F, 0xA3, 0xE5, 0x9B, 0x97, 0xE5,
		0x9C, 0x9F, 0xE5, 0xA3, 0xAB, 0xE5, 0xA4, 0x82,
		0xE5, 0xA4, 0x8A, 0xE5, 0xA4, 0x95, 0xE5, 0xA4,
		0xA7, 0xE5, 0xA5, 0xB3, 0xE5, 0xAD, 0x90, 0xE5,
		0xAE, 0x80, 0xE5, 0xAF, 0xB8, 0xE5, 0xB0, 0x8F,
		0xE5, 0xB0, 0xA2, 0xE5, 0xB0, 0xB8, 0xE5, 0xB1,
		0xAE, 0xE5, 0xB1, 0xB1, 0xE5, 0xB7, 0x9B, 0xE5,
		0xB7, 0xA5, 0xE5, 0xB7, 0xB1, 0xE5, 0xB7, 0xBE,
		0xE5, 0xB9, 0xB2, 0xE5, 0xB9, 0xBA, 0xE5, 0xB9,
		0xBF, 0xE5, 0xBB, 0xB4, 0xE5, 0xBB, 0xBE, 0xE5,
		0xBC, 0x8B, 0xE5, 0xBC, 0x93, 0xE5, 0xBD, 0x90,
		0xE5, 0xBD, 0xA1, 0xE5, 0xBD, 0xB3, 0xE5, 0xBF,
		0x83, 0xE6, 0x88, 0x88, 0xE6, 0x88, 0xB6, 0xE6,
		0x89, 0x8B, 0xE6, 0x94, 0xAF, 0xE6, 0x94, 0xB4,
		0xE6, 0x96, 0x87, 0xE6, 0x96, 0x97, 0xE6, 0x96,
		0xA4, 0xE6, 0x96, 0xB9, 0xE6, 0x97, 0xA0, 0xE6,
		0x97, 0xA5, 0xE6, 0x9B, 0xB0, 0xE6, 0x9C, 0x88,
		0xE6, 0x9C, 0xA8, 0xE6, 0xAC, 0xA0, 0xE6, 0xAD,
		0xA2, 0xE6, 0xAD, 0xB9, 0xE6, 0xAE, 0xB3, 0xE6,
		0xAF, 0x8B, 0xE6, 0xAF, 0x94, 0xE6, 0xAF, 0x9B,
		0xE6, 0xB0, 0x8F, 0xE6, 0xB0, 0x94, 0xE6, 0xB0,
		0xB4, 0xE7, 0x81, 0xAB, 0xE7, 0x88, 0xAA, 0xE7,
		0x88, 0xB6, 0xE7, 0x88, 0xBB, 0xE7, 0x88, 0xBF,
		0xE7, 0x89, 0x87, 0xE7, 0x89, 0x99, 0xE7, 0x89,
		0x9B, 0xE7, 0x8A, 0xAC, 0xE7, 0x8E, 0x84, 0xE7,
		0x8E, 0x89, 0xE7, 0x93, 0x9C, 0xE7, 0x93, 0xA6,
		0xE7, 0x94, 0x98, 0xE7, 0x94, 0x9F, 0xE7, 0x94,
		0xA8, 0xE7, 0x94, 0xB0, 0xE7, 0x96, 0x8B, 0xE7,
		0x96, 0x92, 0xE7, 0x99, 0xB6, 0xE7, 0x99, 0xBD,
		0xE7, 0x9A, 0xAE, 0xE7, 0x9A, 0xBF, 0xE7, 0x9B,
		0xAE, 0xE7, 0x9F, 0x9B, 0xE7, 0x9F, 0xA2, 0xE7,
		0x9F, 0xB3, 0xE7, 0xA4, 0xBA, 0xE7, 0xA6, 0xB8,
		0xE7, 0xA6, 0xBE, 0xE7, 0xA9, 0xB4, 0xE7, 0xAB,
		0x8B, 0xE7, 0xAB, 0xB9, 0xE7, 0xB1, 0xB3, 0xE7,
		0xB3, 0xB8, 0xE7, 0xBC, 0xB6, 0xE7, 0xBD, 0x91,
		0xE7, 0xBE, 0x8A, 0xE7, 0xBE, 0xBD, 0xE8, 0x80,
		0x81, 0xE8, 0x80, 0x8C, 0xE8, 0x80, 0x92, 0xE8,
		0x80, 0xB3, 0xE8, 0x81, 0xBF, 0xE8, 0x82, 0x89,
		0xE8, 0x87, 0xA3, 0xE8, 0x87, 0xAA, 0xE8, 0x87,
		0xB3, 0xE8, 0x87, 0xBC, 0xE8, 0x88, 0x8C, 0xE8,
		0x88, 0x9B, 0xE8, 0x88, 0x9F, 0xE8, 0x89, 0xAE,
		0xE8, 0x89, 0xB2, 0xE8, 0x89, 0xB8, 0xE8, 0x99,
		0x8D, 0xE8, 0x99, 0xAB, 0xE8, 0xA1, 0x80, 0xE8,
		0xA1, 0x8C, 0xE8, 0xA1, 0xA3, 0xE8, 0xA5, 0xBE,
		0xE8, 0xA6, 0x8B, 0xE8, 0xA7, 0x92, 0xE8, 0xA8,
		0x80, 0xE8, 0xB0, 0xB7, 0xE8, 0xB1, 0x86, 0xE8,
		0xB1, 0x95, 0xE8, 0xB1, 0xB8, 0xE8, 0xB2, 0x9D,
		0xE8, 0xB5, 0xA4, 0xE8, 0xB5, 0xB0, 0xE8, 0xB6,
		0xB3, 0xE8, 0xBA, 0xAB, 0xE8, 0xBB, 0x8A, 0xE8,
		0xBE, 0x9B, 0xE8, 0xBE, 0xB0, 0xE8, 0xBE, 0xB5,
		0xE9, 0x82, 0x91, 0xE9, 0x85, 0x89, 0xE9, 0x87,
		0x86, 0xE9, 0x87, 0x8C, 0xE9, 0x87, 0x91, 0xE9,
		0x95, 0xB7, 0xE9, 0x96, 0x80, 0xE9, 0x98, 0x9C,
		0xE9, 0x9A, 0xB6, 0xE9, 0x9A, 0xB9, 0xE9, 0x9B,
		0xA8, 0xE9, 0x9D, 0x91, 0xE9, 0x9D, 0x9E, 0xE9,
		0x9D, 0xA2, 0xE9, 0x9D, 0xA9, 0xE9, 0x9F, 0x8B,
		0xE9, 0x9F, 0xAD, 0xE9, 0x9F, 0xB3, 0xE9, 0xA0,
		0x81, 0xE9, 0xA2, 0xA8, 0xE9, 0xA3, 0x9B, 0xE9,
		0xA3, 0x9F, 0xE9, 0xA6, 0x96, 0xE9, 0xA6, 0x99,
		0xE9, 0xA6, 0xAC, 0xE9, 0xAA, 0xA8, 0xE9, 0xAB,
		0x98, 0xE9, 0xAB, 0x9F, 0xE9, 0xAC, 0xA5, 0xE9,
		0xAC, 0xAF, 0xE9, 0xAC, 0xB2, 0xE9, 0xAC, 0xBC,
		0xE9, 0xAD, 0x9A, 0xE9, 0xB3, 0xA5, 0xE9, 0xB9,
		0xB5, 0xE9, 0xB9, 0xBF, 0xE9, 0xBA, 0xA5, 0xE9,
		0xBA, 0xBB, 0xE9, 0xBB, 0x83, 0xE9, 0xBB, 0x8D,
		0xE9, 0xBB, 0x91, 0xE9, 0xBB, 0xB9, 0xE9, 0xBB,
		0xBD, 0xE9, 0xBC, 0x8E, 0xE9, 0xBC, 0x93, 0xE9,
		0xBC, 0xA0, 0xE9, 0xBC, 0xBB, 0xE9, 0xBD, 0x8A,
		0xE9, 0xBD, 0x92, 0xE9, 0xBE, 0x8D, 0xE9, 0xBE,
		0x9C, 0xE9, 0xBE, 0xA0, 0x20, 0xE3, 0x80, 0x92,
		0xE5, 0x8D, 0x81, 0xE5, 0x8D, 0x84, 0xE5, 0x8D,
		0x85, 0xF6, 0xE3, 0x81, 0x8B, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x81, 0x8D, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x81, 0x8F, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x81, 0x91, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81,
		0x93, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81, 0x95,
		0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81, 0x97, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x81, 0x99, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x81, 0x9B, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x81, 0x9D, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x81, 0x9F, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x81, 0xA1, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81,
		0xA4, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81, 0xA6,
		0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81, 0xA8, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x81, 0xAF, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x81, 0xAF, 0xE3, 0x82, 0x9A,
		0xF6, 0xE3, 0x81, 0xB2, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x81, 0xB2, 0xE3, 0x82, 0x9A, 0xF6, 0xE3,
		0x81, 0xB5, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81,
		0xB5, 0xE3, 0x82, 0x9A, 0xF6, 0xE3, 0x81, 0xB8,
		0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x81, 0xB8, 0xE3,
		0x82, 0x9A, 0xF6, 0xE3, 0x81, 0xBB, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x81, 0xBB, 0xE3, 0x82, 0x9A,
		0xF6, 0xE3, 0x81, 0x86, 0xE3, 0x82, 0x99, 0x20,
		0xE3, 0x82, 0x99, 0x20, 0xE3, 0x82, 0x9A, 0xF6,
		0xE3, 0x82, 0x9D, 0xE3, 0x82, 0x99, 0xE3, 0x82,
		0x88, 0xE3, 0x82, 0x8A, 0xF6, 0xE3, 0x82, 0xAB,
		0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x82, 0xAD, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x82, 0xAF, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x82, 0xB1, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x82, 0xB3, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x82, 0xB5, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x82, 0xB7, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x82,
		0xB9, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x82, 0xBB,
		0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x82, 0xBD, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x82, 0xBF, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x83, 0x81, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x83, 0x84, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x83, 0x86, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x83, 0x88, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x83,
		0x8F, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x83, 0x8F,
		0xE3, 0x82, 0x9A, 0xF6, 0xE3, 0x83, 0x92, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x83, 0x92, 0xE3, 0x82,
		0x9A, 0xF6, 0xE3, 0x83, 0x95, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x83, 0x95, 0xE3, 0x82, 0x9A, 0xF6,
		0xE3, 0x83, 0x98, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x83, 0x98, 0xE3, 0x82, 0x9A, 0xF6, 0xE3, 0x83,
		0x9B, 0xE3, 0x82, 0x99, 0xF6, 0xE3, 0x83, 0x9B,
		0xE3, 0x82, 0x9A, 0xF6, 0xE3, 0x82, 0xA6, 0xE3,
		0x82, 0x99, 0xF6, 0xE3, 0x83, 0xAF, 0xE3, 0x82,
		0x99, 0xF6, 0xE3, 0x83, 0xB0, 0xE3, 0x82, 0x99,
		0xF6, 0xE3, 0x83, 0xB1, 0xE3, 0x82, 0x99, 0xF6,
		0xE3, 0x83, 0xB2, 0xE3, 0x82, 0x99, 0xF6, 0xE3,
		0x83, 0xBD, 0xE3, 0x82, 0x99, 0xE3, 0x82, 0xB3,
		0xE3, 0x83, 0x88, 0xE1, 0x84, 0x80, 0xE1, 0x84,
		0x81, 0xE1, 0x86, 0xAA, 0xE1, 0x84, 0x82, 0xE1,
		0x86, 0xAC, 0xE1, 0x86, 0xAD, 0xE1, 0x84, 0x83,
		0xE1, 0x84, 0x84, 0xE1, 0x84, 0x85, 0xE1, 0x86,
		0xB0, 0xE1, 0x86, 0xB1, 0xE1, 0x86, 0xB2, 0xE1,
		0x86, 0xB3, 0xE1, 0x86, 0xB4, 0xE1, 0x86, 0xB5,
		0xE1, 0x84, 0x9A, 0xE1, 0x84, 0x86, 0xE1, 0x84,
		0x87, 0xE1, 0x84, 0x88, 0xE1, 0x84, 0xA1, 0xE1,
		0x84, 0x89, 0xE1, 0x84, 0x8A, 0xE1, 0x84, 0x8B,
		0xE1, 0x84, 0x8C, 0xE1, 0x84, 0x8D, 0xE1, 0x84,
		0x8E, 0xE1, 0x84, 0x8F, 0xE1, 0x84, 0x90, 0xE1,
		0x84, 0x91, 0xE1, 0x84, 0x92, 0xE1, 0x85, 0xA1,
		0xE1, 0x85, 0xA2, 0xE1, 0x85, 0xA3, 0xE1, 0x85,
		0xA4, 0xE1, 0x85, 0xA5, 0xE1, 0x85, 0xA6, 0xE1,
		0x85, 0xA7, 0xE1, 0x85, 0xA8, 0xE1, 0x85, 0xA9,
		0xE1, 0x85, 0xAA, 0xE1, 0x85, 0xAB, 0xE1, 0x85,
		0xAC, 0xE1, 0x85, 0xAD, 0xE1, 0x85, 0xAE, 0xE1,
		0x85, 0xAF, 0xE1, 0x85, 0xB0, 0xE1, 0x85, 0xB1,
		0xE1, 0x85, 0xB2, 0xE1, 0x85, 0xB3, 0xE1, 0x85,
		0xB4, 0xE1, 0x85, 0xB5, 0xE1, 0x85, 0xA0, 0xE1,
		0x84, 0x94, 0xE1, 0x84, 0x95, 0xE1, 0x87, 0x87,
		0xE1, 0x87, 0x88, 0xE1, 0x87, 0x8C, 0xE1, 0x87,
		0x8E, 0xE1, 0x87, 0x93, 0xE1, 0x87, 0x97, 0xE1,
		0x87, 0x99, 0xE1, 0x84, 0x9C, 0xE1, 0x87, 0x9D,
		0xE1, 0x87, 0x9F, 0xE1, 0x84, 0x9D, 0xE1, 0x84,
		0x9E, 0xE1, 0x84, 0xA0, 0xE1, 0x84, 0xA2, 0xE1,
		0x84, 0xA3, 0xE1, 0x84, 0xA7, 0xE1, 0x84, 0xA9,
		0xE1, 0x84, 0xAB, 0xE1, 0x84, 0xAC, 0xE1, 0x84,
		0xAD, 0xE1, 0x84, 0xAE, 0xE1, 0x84, 0xAF, 0xE1,
		0x84, 0xB2, 0xE1, 0x84, 0xB6, 0xE1, 0x85, 0x80,
		0xE1, 0x85, 0x87, 0xE1, 0x85, 0x8C, 0xE1, 0x87,
		0xB1, 0xE1, 0x87, 0xB2, 0xE1, 0x85, 0x97, 0xE1,
		0x85, 0x98, 0xE1, 0x85, 0x99, 0xE1, 0x86, 0x84,
		0xE1, 0x86, 0x85, 0xE1, 0x86, 0x88, 0xE1, 0x86,
		0x91, 0xE1, 0x86, 0x92, 0xE1, 0x86, 0x94, 0xE1,
		0x86, 0x9E, 0xE1, 0x86, 0xA1, 0xE4, 0xB8, 0x80,
		0xE4, 0xBA, 0x8C, 0xE4, 0xB8, 0x89, 0xE5, 0x9B,
		0x9B, 0xE4, 0xB8, 0x8A, 0xE4, 0xB8, 0xAD, 0xE4,
		0xB8, 0x8B, 0xE7, 0x94, 0xB2, 0xE4, 0xB9, 0x99,
		0xE4, 0xB8, 0x99, 0xE4, 0xB8, 0x81, 0xE5, 0xA4,
		0xA9, 0xE5, 0x9C, 0xB0, 0xE4, 0xBA, 0xBA, 0x28,
		0xE1, 0x84, 0x80, 0x29, 0x28, 0xE1, 0x84, 0x82,
		0x29, 0x28, 0xE1, 0x84, 0x83, 0x29, 0x28, 0xE1,
		0x84, 0x85, 0x29, 0x28, 0xE1, 0x84, 0x86, 0x29,
		0x28, 0xE1, 0x84, 0x87, 0x29, 0x28, 0xE1, 0x84,
		0x89, 0x29, 0x28, 0xE1, 0x84, 0x8B, 0x29, 0x28,
		0xE1, 0x84, 0x8C, 0x29, 0x28, 0xE1, 0x84, 0x8E,
		0x29, 0x28, 0xE1, 0x84, 0x8F, 0x29, 0x28, 0xE1,
		0x84, 0x90, 0x29, 0x28, 0xE1, 0x84, 0x91, 0x29,
		0x28, 0xE1, 0x84, 0x92, 0x29, 0x28, 0xE1, 0x84,
		0x80, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x82, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x83, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x85, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x86, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x87, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x89, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x8B, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x8C, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x8E, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x8F, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x90, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x91, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x92, 0xE1, 0x85, 0xA1, 0x29, 0x28, 0xE1, 0x84,
		0x8C, 0xE1, 0x85, 0xAE, 0x29, 0x28, 0xE4, 0xB8,
		0x80, 0x29, 0x28, 0xE4, 0xBA, 0x8C, 0x29, 0x28,
		0xE4, 0xB8, 0x89, 0x29, 0x28, 0xE5, 0x9B, 0x9B,
		0x29, 0x28, 0xE4, 0xBA, 0x94, 0x29, 0x28, 0xE5,
		0x85, 0xAD, 0x29, 0x28, 0xE4, 0xB8, 0x83, 0x29,
		0x28, 0xE5, 0x85, 0xAB, 0x29, 0x28, 0xE4, 0xB9,
		0x9D, 0x29, 0x28, 0xE5, 0x8D, 0x81, 0x29, 0x28,
		0xE6, 0x9C, 0x88, 0x29, 0x28, 0xE7, 0x81, 0xAB,
		0x29, 0x28, 0xE6, 0xB0, 0xB4, 0x29, 0x28, 0xE6,
		0x9C, 0xA8, 0x29, 0x28, 0xE9, 0x87, 0x91, 0x29,
		0x28, 0xE5, 0x9C, 0x9F, 0x29, 0x28, 0xE6, 0x97,
		0xA5, 0x29, 0x28, 0xE6, 0xA0, 0xAA, 0x29, 0x28,
		0xE6, 0x9C, 0x89, 0x29, 0x28, 0xE7, 0xA4, 0xBE,
		0x29, 0x28, 0xE5, 0x90, 0x8D, 0x29, 0x28, 0xE7,
		0x89, 0xB9, 0x29, 0x28, 0xE8, 0xB2, 0xA1, 0x29,
		0x28, 0xE7, 0xA5, 0x9D, 0x29, 0x28, 0xE5, 0x8A,
		0xB4, 0x29, 0x28, 0xE4, 0xBB, 0xA3, 0x29, 0x28,
		0xE5, 0x91, 0xBC, 0x29, 0x28, 0xE5, 0xAD, 0xA6,
		0x29, 0x28, 0xE7, 0x9B, 0xA3, 0x29, 0x28, 0xE4,
		0xBC, 0x81, 0x29, 0x28, 0xE8, 0xB3, 0x87, 0x29,
		0x28, 0xE5, 0x8D, 0x94, 0x29, 0x28, 0xE7, 0xA5,
		0xAD, 0x29, 0x28, 0xE4, 0xBC, 0x91, 0x29, 0x28,
		0xE8, 0x87, 0xAA, 0x29, 0x28, 0xE8, 0x87, 0xB3,
		0x29, 0x32, 0x31, 0x32, 0x32, 0x32, 0x33, 0x32,
		0x34, 0x32, 0x35, 0x32, 0x36, 0x32, 0x37, 0x32,
		0x38, 0x32, 0x39, 0x33, 0x30, 0x33, 0x31, 0x33,
		0x32, 0x33, 0x33, 0x33, 0x34, 0x33, 0x35, 0xE1,
		0x84, 0x80, 0xE1, 0x84, 0x82, 0xE1, 0x84, 0x83,
		0xE1, 0x84, 0x85, 0xE1, 0x84, 0x86, 0xE1, 0x84,
		0x87, 0xE1, 0x84, 0x89, 0xE1, 0x84, 0x8B, 0xE1,
		0x84, 0x8C, 0xE1, 0x84, 0x8E, 0xE1, 0x84, 0x8F,
		0xE1, 0x84, 0x90, 0xE1, 0x84, 0x91, 0xE1, 0x84,
		0x92, 0xE1, 0x84, 0x80, 0xE1, 0x85, 0xA1, 0xE1,
		0x84, 0x82, 0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x83,
		0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x85, 0xE1, 0x85,
		0xA1, 0xE1, 0x84, 0x86, 0xE1, 0x85, 0xA1, 0xE1,
		0x84, 0x87, 0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x89,
		0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x8B, 0xE1, 0x85,
		0xA1, 0xE1, 0x84, 0x8C, 0xE1, 0x85, 0xA1, 0xE1,
		0x84, 0x8E, 0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x8F,
		0xE1, 0x85, 0xA1, 0xE1, 0x84, 0x90, 0xE1, 0x85,
		0xA1, 0xE1, 0x84, 0x91, 0xE1, 0x85, 0xA1, 0xE1,
		0x84, 0x92, 0xE1, 0x85, 0xA1, 0xE4, 0xB8, 0x80,
		0xE4, 0xBA, 0x8C, 0xE4, 0xB8, 0x89, 0xE5, 0x9B,
		0x9B, 0xE4, 0xBA, 0x94, 0xE5, 0x85, 0xAD, 0xE4,
		0xB8, 0x83, 0xE5, 0x85, 0xAB, 0xE4, 0xB9, 0x9D,
		0xE5, 0x8D, 0x81, 0xE6, 0x9C, 0x88, 0xE7, 0x81,
		0xAB, 0xE6, 0xB0, 0xB4, 0xE6, 0x9C, 0xA8, 0xE9,
		0x87, 0x91, 0xE5, 0x9C, 0x9F, 0xE6, 0x97, 0xA5,
		0xE6, 0xA0, 0xAA, 0xE6, 0x9C, 0x89, 0xE7, 0xA4,
		0xBE, 0xE5, 0x90, 0x8D, 0xE7, 0x89, 0xB9, 0xE8,
		0xB2, 0xA1, 0xE7, 0xA5, 0x9D, 0xE5, 0x8A, 0xB4,
		0xE7, 0xA7, 0x98, 0xE7, 0x94, 0xB7, 0xE5, 0xA5,
		0xB3, 0xE9, 0x81, 0xA9, 0xE5, 0x84, 0xAA, 0xE5,
		0x8D, 0xB0, 0xE6, 0xB3, 0xA8, 0xE9, 0xA0, 0x85,
		0xE4, 0xBC, 0x91, 0xE5, 0x86, 0x99, 0xE6, 0xAD,
		0xA3, 0xE4, 0xB8, 0x8A, 0xE4, 0xB8, 0xAD, 0xE4,
		0xB8, 0x8B, 0xE5, 0xB7, 0xA6, 0xE5, 0x8F, 0xB3,
		0xE5, 0x8C, 0xBB, 0xE5, 0xAE, 0x97, 0xE5, 0xAD,
		0xA6, 0xE7, 0x9B, 0xA3, 0xE4, 0xBC, 0x81, 0xE8,
		0xB3, 0x87, 0xE5, 0x8D, 0x94, 0xE5, 0xA4, 0x9C,
		0x33, 0x36, 0x33, 0x37, 0x33, 0x38, 0x33, 0x39,
		0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x33,
		0x34, 0x34, 0x34, 0x35, 0x34, 0x36, 0x34, 0x37,
		0x34, 0x38, 0x34, 0x39, 0x35, 0x30, 0x31, 0xE6,
		0x9C, 0x88, 0x32, 0xE6, 0x9C, 0x88, 0x33, 0xE6,
		0x9C, 0x88, 0x34, 0xE6, 0x9C, 0x88, 0x35, 0xE6,
		0x9C, 0x88, 0x36, 0xE6, 0x9C, 0x88, 0x37, 0xE6,
		0x9C, 0x88, 0x38, 0xE6, 0x9C, 0x88, 0x39, 0xE6,
		0x9C, 0x88, 0x31, 0x30, 0xE6, 0x9C, 0x88, 0x31,
		0x31, 0xE6, 0x9C, 0x88, 0x31, 0x32, 0xE6, 0x9C,
		0x88, 0xE3, 0x82, 0xA2, 0xE3, 0x82, 0xA4, 0xE3,
		0x82, 0xA6, 0xE3, 0x82, 0xA8, 0xE3, 0x82, 0xAA,
		0xE3, 0x82, 0xAB, 0xE3, 0x82, 0xAD, 0xE3, 0x82,
		0xAF, 0xE3, 0x82, 0xB1, 0xE3, 0x82, 0xB3, 0xE3,
		0x82, 0xB5, 0xE3, 0x82, 0xB7, 0xE3, 0x82, 0xB9,
		0xE3, 0x82, 0xBB, 0xE3, 0x82, 0xBD, 0xE3, 0x82,
		0xBF, 0xE3, 0x83, 0x81, 0xE3, 0x83, 0x84, 0xE3,
		0x83, 0x86, 0xE3, 0x83, 0x88, 0xE3, 0x83, 0x8A,
		0xE3, 0x83, 0x8B, 0xE3, 0x83, 0x8C, 0xE3, 0x83,
		0x8D, 0xE3, 0x83, 0x8E, 0xE3, 0x83, 0x8F, 0xE3,
		0x83, 0x92, 0xE3, 0x83, 0x95, 0xE3, 0x83, 0x98,
		0xE3, 0x83, 0x9B, 0xE3, 0x83, 0x9E, 0xE3, 0x83,
		0x9F, 0xE3, 0x83, 0xA0, 0xE3, 0x83, 0xA1, 0xE3,
		0x83, 0xA2, 0xE3, 0x83, 0xA4, 0xE3, 0x83, 0xA6,
		0xE3, 0x83, 0xA8, 0xE3, 0x83, 0xA9, 0xE3, 0x83,
		0xAA, 0xE3, 0x83, 0xAB, 0xE3, 0x83, 0xAC, 0xE3,
		0x83, 0xAD, 0xE3, 0x83, 0xAF, 0xE3, 0x83, 0xB0,
		0xE3, 0x83, 0xB1, 0xE3, 0x83, 0xB2, 0xE3, 0x82,
		0xA2, 0xE3, 0x83, 0x8F, 0xE3, 0x82, 0x9A, 0xE3,
		0x83, 0xBC, 0xE3, 0x83, 0x88, 0xE3, 0x82, 0xA2,
		0xE3, 0x83, 0xAB, 0xE3, 0x83, 0x95, 0xE3, 0x82,
		0xA1, 0xE3, 0x82, 0xA2, 0xE3, 0x83, 0xB3, 0xE3,
		0x83, 0x98, 0xE3, 0x82, 0x9A, 0xE3, 0x82, 0xA2,
		0xE3, 0x82, 0xA2, 0xE3, 0x83, 0xBC, 0xE3, 0x83,
		0xAB, 0xE3, 0x82, 0xA4, 0xE3, 0x83, 0x8B, 0xE3,
		0x83, 0xB3, 0xE3, 0x82, 0xAF, 0xE3, 0x82, 0x99,
		0xE3, 0x82, 0xA4, 0xE3, 0x83, 0xB3, 0xE3, 0x83,
		0x81, 0xE3, 0x82, 0xA6, 0xE3, 0x82, 0xA9, 0xE3,
		0x83, 0xB3, 0xE3, 0x82, 0xA8, 0xE3, 0x82, 0xB9,
		0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xBC, 0xE3, 0x83,
		0x88, 0xE3, 0x82, 0x99, 0xE3, 0x82, 0xA8, 0xE3,
		0x83, 0xBC, 0xE3, 0x82, 0xAB, 0xE3, 0x83, 0xBC,
		0xE3, 0x82, 0xAA, 0xE3, 0x83, 0xB3, 0xE3, 0x82,
		0xB9, 0xE3, 0x82, 0xAA, 0xE3, 0x83, 0xBC, 0xE3,
		0x83, 0xA0, 0xE3, 0x82, 0xAB, 0xE3, 0x82, 0xA4,
		0xE3, 0x83, 0xAA, 0xE3, 0x82, 0xAB, 0xE3, 0x83,
		0xA9, 0xE3, 0x83, 0x83, 0xE3, 0x83, 0x88, 0xE3,
		0x82, 0xAB, 0xE3, 0x83, 0xAD, 0xE3, 0x83, 0xAA,
		0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xAB, 0xE3, 0x82,
		0x99, 0xE3, 0x83, 0xAD, 0xE3, 0x83, 0xB3, 0xE3,
		0x82, 0xAB, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0xB3,
		0xE3, 0x83, 0x9E, 0xE3, 0x82, 0xAD, 0xE3, 0x82,
		0x99, 0xE3, 0x82, 0xAB, 0xE3, 0x82, 0x99, 0xE3,
		0x82, 0xAD, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0x8B,
		0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xAD, 0xE3, 0x83,
		0xA5, 0xE3, 0x83, 0xAA, 0xE3, 0x83, 0xBC, 0xE3,
		0x82, 0xAD, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0xAB,
		0xE3, 0x82, 0xBF, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0xBC, 0xE3, 0x82, 0xAD, 0xE3, 0x83, 0xAD, 0xE3,
		0x82, 0xAD, 0xE3, 0x83, 0xAD, 0xE3, 0x82, 0xAF,
		0xE3, 0x82, 0x99, 0xE3, 0x83, 0xA9, 0xE3, 0x83,
		0xA0, 0xE3, 0x82, 0xAD, 0xE3, 0x83, 0xAD, 0xE3,
		0x83, 0xA1, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0x88,
		0xE3, 0x83, 0xAB, 0xE3, 0x82, 0xAD, 0xE3, 0x83,
		0xAD, 0xE3, 0x83, 0xAF, 0xE3, 0x83, 0x83, 0xE3,
		0x83, 0x88, 0xE3, 0x82, 0xAF, 0xE3, 0x82, 0x99,
		0xE3, 0x83, 0xA9, 0xE3, 0x83, 0xA0, 0xE3, 0x82,
		0xAF, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0xA9, 0xE3,
		0x83, 0xA0, 0xE3, 0x83, 0x88, 0xE3, 0x83, 0xB3,
		0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xAB, 0xE3, 0x82,
		0xBB, 0xE3, 0x82, 0x99, 0xE3, 0x82, 0xA4, 0xE3,
		0x83, 0xAD, 0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xAD,
		0xE3, 0x83, 0xBC, 0xE3, 0x83, 0x8D, 0xE3, 0x82,
		0xB1, 0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xB9, 0xE3,
		0x82, 0xB3, 0xE3, 0x83, 0xAB, 0xE3, 0x83, 0x8A,
		0xE3, 0x82, 0xB3, 0xE3, 0x83, 0xBC, 0xE3, 0x83,
		0x9B, 0xE3, 0x82, 0x9A, 0xE3, 0x82, 0xB5, 0xE3,
		0x82, 0xA4, 0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xAB,
		0xE3, 0x82, 0xB5, 0xE3, 0x83, 0xB3, 0xE3, 0x83,
		0x81, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0xA0, 0xE3,
		0x82, 0xB7, 0xE3, 0x83, 0xAA, 0xE3, 0x83, 0xB3,
		0xE3, 0x82, 0xAF, 0xE3, 0x82, 0x99, 0xE3, 0x82,
		0xBB, 0xE3, 0x83, 0xB3, 0xE3, 0x83, 0x81, 0xE3,
		0x82, 0xBB, 0xE3, 0x83, 0xB3, 0xE3, 0x83, 0x88,
		0xE3, 0x82, 0xBF, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0xBC, 0xE3, 0x82, 0xB9, 0xE3, 0x83, 0x86, 0xE3,
		0x82, 0x99, 0xE3, 0x82, 0xB7, 0xE3, 0x83, 0x88,
		0xE3, 0x82, 0x99, 0xE3, 0x83, 0xAB, 0xE3, 0x83,
		0x88, 0xE3, 0x83, 0xB3, 0xE3, 0x83, 0x8A, 0xE3,
		0x83, 0x8E, 0xE3, 0x83, 0x8E, 0xE3, 0x83, 0x83,
		0xE3, 0x83, 0x88, 0xE3, 0x83, 0x8F, 0xE3, 0x82,
		0xA4, 0xE3, 0x83, 0x84, 0xE3, 0x83, 0x8F, 0xE3,
		0x82, 0x9A, 0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xBB,
		0xE3, 0x83, 0xB3, 0xE3, 0x83, 0x88, 0xE3, 0x83,
		0x8F, 0xE3, 0x82, 0x9A, 0xE3, 0x83, 0xBC, 0xE3,
		0x83, 0x84, 0xE3, 0x83, 0x8F, 0xE3, 0x82, 0x99,
		0xE3, 0x83, 0xBC, 0xE3, 0x83, 0xAC, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0x92, 0xE3, 0x82, 0x9A, 0xE3,
		0x82, 0xA2, 0xE3, 0x82, 0xB9, 0xE3, 0x83, 0x88,
		0xE3, 0x83, 0xAB, 0xE3, 0x83, 0x92, 0xE3, 0x82,
		0x9A, 0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xAB, 0xE3,
		0x83, 0x92, 0xE3, 0x82, 0x9A, 0xE3, 0x82, 0xB3,
		0xE3, 0x83, 0x92, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0x95, 0xE3, 0x82, 0xA1, 0xE3,
		0x83, 0xA9, 0xE3, 0x83, 0x83, 0xE3, 0x83, 0x88,
		0xE3, 0x82, 0x99, 0xE3, 0x83, 0x95, 0xE3, 0x82,
		0xA3, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0x88, 0xE3,
		0x83, 0x95, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0x83,
		0xE3, 0x82, 0xB7, 0xE3, 0x82, 0xA7, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0x95, 0xE3, 0x83, 0xA9, 0xE3,
		0x83, 0xB3, 0xE3, 0x83, 0x98, 0xE3, 0x82, 0xAF,
		0xE3, 0x82, 0xBF, 0xE3, 0x83, 0xBC, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0x98, 0xE3, 0x82, 0x9A, 0xE3,
		0x82, 0xBD, 0xE3, 0x83, 0x98, 0xE3, 0x82, 0x9A,
		0xE3, 0x83, 0x8B, 0xE3, 0x83, 0x92, 0xE3, 0x83,
		0x98, 0xE3, 0x83, 0xAB, 0xE3, 0x83, 0x84, 0xE3,
		0x83, 0x98, 0xE3, 0x82, 0x9A, 0xE3, 0x83, 0xB3,
		0xE3, 0x82, 0xB9, 0xE3, 0x83, 0x98, 0xE3, 0x82,
		0x9A, 0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xB7, 0xE3,
		0x82, 0x99, 0xE3, 0x83, 0x98, 0xE3, 0x82, 0x99,
		0xE3, 0x83, 0xBC, 0xE3, 0x82, 0xBF, 0xE3, 0x83,
		0x9B, 0xE3, 0x82, 0x9A, 0xE3, 0x82, 0xA4, 0xE3,
		0x83, 0xB3, 0xE3, 0x83, 0x88, 0xE3, 0x83, 0x9B,
		0xE3, 0x82, 0x99, 0xE3, 0x83, 0xAB, 0xE3, 0x83,
		0x88, 0xE3, 0x83, 0x9B, 0xE3, 0x83, 0xB3, 0xE3,
		0x83, 0x9B, 0xE3, 0x82, 0x9A, 0xE3, 0x83, 0xB3,
		0xE3, 0x83, 0x88, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0x9B, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0xAB, 0xE3,
		0x83, 0x9B, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0xB3,
		0xE3, 0x83, 0x9E, 0xE3, 0x82, 0xA4, 0xE3, 0x82,
		0xAF, 0xE3, 0x83, 0xAD, 0xE3, 0x83, 0x9E, 0xE3,
		0x82, 0xA4, 0xE3, 0x83, 0xAB, 0xE3, 0x83, 0x9E,
		0xE3, 0x83, 0x83, 0xE3, 0x83, 0x8F, 0xE3, 0x83,
		0x9E, 0xE3, 0x83, 0xAB, 0xE3, 0x82, 0xAF, 0xE3,
		0x83, 0x9E, 0xE3, 0x83, 0xB3, 0xE3, 0x82, 0xB7,
		0xE3, 0x83, 0xA7, 0xE3, 0x83, 0xB3, 0xE3, 0x83,
		0x9F, 0xE3, 0x82, 0xAF, 0xE3, 0x83, 0xAD, 0xE3,
		0x83, 0xB3, 0xE3, 0x83, 0x9F, 0xE3, 0x83, 0xAA,
		0xE3, 0x83, 0x9F, 0xE3, 0x83, 0xAA, 0xE3, 0x83,
		0x8F, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0xBC, 0xE3,
		0x83, 0xAB, 0xE3, 0x83, 0xA1, 0xE3, 0x82, 0xAB,
		0xE3, 0x82, 0x99, 0xE3, 0x83, 0xA1, 0xE3, 0x82,
		0xAB, 0xE3, 0x82, 0x99, 0xE3, 0x83, 0x88, 0xE3,
		0x83, 0xB3, 0xE3, 0x83, 0xA1, 0xE3, 0x83, 0xBC,
		0xE3, 0x83, 0x88, 0xE3, 0x83, 0xAB, 0xE3, 0x83,
		0xA4, 0xE3, 0x83, 0xBC, 0xE3, 0x83, 0x88, 0xE3,
		0x82, 0x99, 0xE3, 0x83, 0xA4, 0xE3, 0x83, 0xBC,
		0xE3, 0x83, 0xAB, 0xE3, 0x83, 0xA6, 0xE3, 0x82,
		0xA2, 0xE3, 0x83, 0xB3, 0xE3, 0x83, 0xAA, 0xE3,
		0x83, 0x83, 0xE3, 0x83, 0x88, 0xE3, 0x83, 0xAB,
		0xE3, 0x83, 0xAA, 0xE3, 0x83, 0xA9, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0x92, 0xE3, 0x82, 0x9A, 0xE3,
		0x83, 0xBC, 0xE3, 0x83, 0xAB, 0xE3, 0x83, 0xBC,
		0xE3, 0x83, 0x95, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0xAB, 0xE3, 0x83, 0xAC, 0xE3, 0x83, 0xA0, 0xE3,
		0x83, 0xAC, 0xE3, 0x83, 0xB3, 0xE3, 0x83, 0x88,
		0xE3, 0x82, 0xB1, 0xE3, 0x82, 0x99, 0xE3, 0x83,
		0xB3, 0xE3, 0x83, 0xAF, 0xE3, 0x83, 0x83, 0xE3,
		0x83, 0x88, 0x30, 0xE7, 0x82, 0xB9, 0x31, 0xE7,
		0x82, 0xB9, 0x32, 0xE7, 0x82, 0xB9, 0x33, 0xE7,
		0x82, 0xB9, 0x34, 0xE7, 0x82, 0xB9, 0x35, 0xE7,
		0x82, 0xB9, 0x36, 0xE7, 0x82, 0xB9, 0x37, 0xE7,
		0x82, 0xB9, 0x38, 0xE7, 0x82, 0xB9, 0x39, 0xE7,
		0x82, 0xB9, 0x31, 0x30, 0xE7, 0x82, 0xB9, 0x31,
		0x31, 0xE7, 0x82, 0xB9, 0x31, 0x32, 0xE7, 0x82,
		0xB9, 0x31, 0x33, 0xE7, 0x82, 0xB9, 0x31, 0x34,
		0xE7, 0x82, 0xB9, 0x31, 0x35, 0xE7, 0x82, 0xB9,
		0x31, 0x36, 0xE7, 0x82, 0xB9, 0x31, 0x37, 0xE7,
		0x82, 0xB9, 0x31, 0x38, 0xE7, 0x82, 0xB9, 0x31,
		0x39, 0xE7, 0x82, 0xB9, 0x32, 0x30, 0xE7, 0x82,
		0xB9, 0x32, 0x31, 0xE7, 0x82, 0xB9, 0x32, 0x32,
		0xE7, 0x82, 0xB9, 0x32, 0x33, 0xE7, 0x82, 0xB9,
		0x32, 0x34, 0xE7, 0x82, 0xB9, 0x68, 0x50, 0x61,
		0x64, 0x61, 0x41, 0x55, 0x62, 0x61, 0x72, 0x6F,
		0x56, 0x70, 0x63, 0xE5, 0xB9, 0xB3, 0xE6, 0x88,
		0x90, 0xE6, 0x98, 0xAD, 0xE5, 0x92, 0x8C, 0xE5,
		0xA4, 0xA7, 0xE6, 0xAD, 0xA3, 0xE6, 0x98, 0x8E,
		0xE6, 0xB2, 0xBB, 0xE6, 0xA0, 0xAA, 0xE5, 0xBC,
		0x8F, 0xE4, 0xBC, 0x9A, 0xE7, 0xA4, 0xBE, 0x70,
		0x41, 0x6E, 0x41, 0xCE, 0xBC, 0x41, 0x6D, 0x41,
		0x6B, 0x41, 0x4B, 0x42, 0x4D, 0x42, 0x47, 0x42,
		0x63, 0x61, 0x6C, 0x6B, 0x63, 0x61, 0x6C, 0x70,
		0x46, 0x6E, 0x46, 0xCE, 0xBC, 0x46, 0xCE, 0xBC,
		0x67, 0x6D, 0x67, 0x6B, 0x67, 0x48, 0x7A, 0x6B,
		0x48, 0x7A, 0x4D, 0x48, 0x7A, 0x47, 0x48, 0x7A,
		0x54, 0x48, 0x7A, 0xCE, 0xBC, 0x6C, 0x6D, 0x6C,
		0x64, 0x6C, 0x6B, 0x6C, 0x66, 0x6D, 0x6E, 0x6D,
		0xCE, 0xBC, 0x6D, 0x6D, 0x6D, 0x63, 0x6D, 0x6B,
		0x6D, 0x6D, 0x6D, 0x32, 0x63, 0x6D, 0x32, 0x6D,
		0x32, 0x6B, 0x6D, 0x32, 0x6D, 0x6D, 0x33, 0x63,
		0x6D, 0x33, 0x6D, 0x33, 0x6B, 0x6D, 0x33, 0x6D,
		0xE2, 0x88, 0x95, 0x73, 0x6D, 0xE2, 0x88, 0x95,
		0x73, 0x32, 0x50, 0x61, 0x6B, 0x50, 0x61, 0x4D,
		0x50, 0x61, 0x47, 0x50, 0x61, 0x72, 0x61, 0x64,
		0x72, 0x61, 0x64, 0xE2, 0x88, 0x95, 0x73, 0x72,
		0x61, 0x64, 0xE2, 0x88, 0x95, 0x73, 0x32, 0x70,
		0x73, 0x6E, 0x73, 0xCE, 0xBC, 0x73, 0x6D, 0x73,
		0x70, 0x56, 0x6E, 0x56, 0xCE, 0xBC, 0x56, 0x6D,
		0x56, 0x6B, 0x56, 0x4D, 0x56, 0x70, 0x57, 0x6E,
		0x57, 0xCE, 0xBC, 0x57, 0x6D, 0x57, 0x6B, 0x57,
		0x4D, 0x57, 0x6B, 0xCE, 0xA9, 0x4D, 0xCE, 0xA9,
		0x61, 0x2E, 0x6D, 0x2E, 0x42, 0x71, 0x63, 0x63,
		0x63, 0x64, 0x43, 0xE2, 0x88, 0x95, 0x6B, 0x67,
		0x43, 0x6F, 0x2E, 0x64, 0x42, 0x47, 0x79, 0x68,
		0x61, 0x48, 0x50, 0x69, 0x6E, 0x4B, 0x4B, 0x4B,
		0x4D, 0x6B, 0x74, 0x6C, 0x6D, 0x6C, 0x6E, 0x6C,
		0x6F, 0x67, 0x6C, 0x78, 0x6D, 0x62, 0x6D, 0x69,
		0x6C, 0x6D, 0x6F, 0x6C, 0x50, 0x48, 0x70, 0x2E,
		0x6D, 0x2E, 0x50, 0x50, 0x4D, 0x50, 0x52, 0x73,
		0x72, 0x53, 0x76, 0x57, 0x62, 0x31, 0xE6, 0x97,
		0xA5, 0x32, 0xE6, 0x97, 0xA5, 0x33, 0xE6, 0x97,
		0xA5, 0x34, 0xE6, 0x97, 0xA5, 0x35, 0xE6, 0x97,
		0xA5, 0x36, 0xE6, 0x97, 0xA5, 0x37, 0xE6, 0x97,
		0xA5, 0x38, 0xE6, 0x97, 0xA5, 0x39, 0xE6, 0x97,
		0xA5, 0x31, 0x30, 0xE6, 0x97, 0xA5, 0x31, 0x31,
		0xE6, 0x97, 0xA5, 0x31, 0x32, 0xE6, 0x97, 0xA5,
		0x31, 0x33, 0xE6, 0x97, 0xA5, 0x31, 0x34, 0xE6,
		0x97, 0xA5, 0x31, 0x35, 0xE6, 0x97, 0xA5, 0x31,
		0x36, 0xE6, 0x97, 0xA5, 0x31, 0x37, 0xE6, 0x97,
		0xA5, 0x31, 0x38, 0xE6, 0x97, 0xA5, 0x31, 0x39,
		0xE6, 0x97, 0xA5, 0x32, 0x30, 0xE6, 0x97, 0xA5,
		0x32, 0x31, 0xE6, 0x97, 0xA5, 0x32, 0x32, 0xE6,
		0x97, 0xA5, 0x32, 0x33, 0xE6, 0x97, 0xA5, 0x32,
		0x34, 0xE6, 0x97, 0xA5, 0x32, 0x35, 0xE6, 0x97,
		0xA5, 0x32, 0x36, 0xE6, 0x97, 0xA5, 0x32, 0x37,
		0xE6, 0x97, 0xA5, 0x32, 0x38, 0xE6, 0x97, 0xA5,
		0x32, 0x39, 0xE6, 0x97, 0xA5, 0x33, 0x30, 0xE6,
		0x97, 0xA5, 0x33, 0x31, 0xE6, 0x97, 0xA5, 0xF6,
		0xE8, 0xB1, 0x88, 0xF6, 0xE6, 0x9B, 0xB4, 0xF6,
		0xE8, 0xBB, 0x8A, 0xF6, 0xE8, 0xB3, 0x88, 0xF6,
		0xE6, 0xBB, 0x91, 0xF6, 0xE4, 0xB8, 0xB2, 0xF6,
		0xE5, 0x8F, 0xA5, 0xF6, 0xE9, 0xBE, 0x9C, 0xF6,
		0xE9, 0xBE, 0x9C, 0xF6, 0xE5, 0xA5, 0x91, 0xF6,
		0xE9, 0x87, 0x91, 0xF6, 0xE5, 0x96, 0x87, 0xF6,
		0xE5, 0xA5, 0x88, 0xF6, 0xE6, 0x87, 0xB6, 0xF6,
		0xE7, 0x99, 0xA9, 0xF6, 0xE7, 0xBE, 0x85, 0xF6,
		0xE8, 0x98, 0xBF, 0xF6, 0xE8, 0x9E, 0xBA, 0xF6,
		0xE8, 0xA3, 0xB8, 0xF6, 0xE9, 0x82, 0x8F, 0xF6,
		0xE6, 0xA8, 0x82, 0xF6, 0xE6, 0xB4, 0x9B, 0xF6,
		0xE7, 0x83, 0x99, 0xF6, 0xE7, 0x8F, 0x9E, 0xF6,
		0xE8, 0x90, 0xBD, 0xF6, 0xE9, 0x85, 0xAA, 0xF6,
		0xE9, 0xA7, 0xB1, 0xF6, 0xE4, 0xBA, 0x82, 0xF6,
		0xE5, 0x8D, 0xB5, 0xF6, 0xE6, 0xAC, 0x84, 0xF6,
		0xE7, 0x88, 0x9B, 0xF6, 0xE8, 0x98, 0xAD, 0xF6,
		0xE9, 0xB8, 0x9E, 0xF6, 0xE5, 0xB5, 0x90, 0xF6,
		0xE6, 0xBF, 0xAB, 0xF6, 0xE8, 0x97, 0x8D, 0xF6,
		0xE8, 0xA5, 0xA4, 0xF6, 0xE6, 0x8B, 0x89, 0xF6,
		0xE8, 0x87, 0x98, 0xF6, 0xE8, 0xA0, 0x9F, 0xF6,
		0xE5, 0xBB, 0x8A, 0xF6, 0xE6, 0x9C, 0x97, 0xF6,
		0xE6, 0xB5, 0xAA, 0xF6, 0xE7, 0x8B, 0xBC, 0xF6,
		0xE9, 0x83, 0x8E, 0xF6, 0xE4, 0xBE, 0x86, 0xF6,
		0xE5, 0x86, 0xB7, 0xF6, 0xE5, 0x8B, 0x9E, 0xF6,
		0xE6, 0x93, 0x84, 0xF6, 0xE6, 0xAB, 0x93, 0xF6,
		0xE7, 0x88, 0x90, 0xF6, 0xE7, 0x9B, 0xA7, 0xF6,
		0xE8, 0x80, 0x81, 0xF6, 0xE8, 0x98, 0x86, 0xF6,
		0xE8, 0x99, 0x9C, 0xF6, 0xE8, 0xB7, 0xAF, 0xF6,
		0xE9, 0x9C, 0xB2, 0xF6, 0xE9, 0xAD, 0xAF, 0xF6,
		0xE9, 0xB7, 0xBA, 0xF6, 0xE7, 0xA2, 0x8C, 0xF6,
		0xE7, 0xA5, 0xBF, 0xF6, 0xE7, 0xB6, 0xA0, 0xF6,
		0xE8, 0x8F, 0x89, 0xF6, 0xE9, 0x8C, 0x84, 0xF6,
		0xE9, 0xB9, 0xBF, 0xF6, 0xE8, 0xAB, 0x96, 0xF6,
		0xE5, 0xA3, 0x9F, 0xF6, 0xE5, 0xBC, 0x84, 0xF6,
		0xE7, 0xB1, 0xA0, 0xF6, 0xE8, 0x81, 0xBE, 0xF6,
		0xE7, 0x89, 0xA2, 0xF6, 0xE7, 0xA3, 0x8A, 0xF6,
		0xE8, 0xB3, 0x82, 0xF6, 0xE9, 0x9B, 0xB7, 0xF6,
		0xE5, 0xA3, 0x98, 0xF6, 0xE5, 0xB1, 0xA2, 0xF6,
		0xE6, 0xA8, 0x93, 0xF6, 0xE6, 0xB7, 0x9A, 0xF6,
		0xE6, 0xBC, 0x8F, 0xF6, 0xE7, 0xB4, 0xAF, 0xF6,
		0xE7, 0xB8, 0xB7, 0xF6, 0xE9, 0x99, 0x8B, 0xF6,
		0xE5, 0x8B, 0x92, 0xF6, 0xE8, 0x82, 0x8B, 0xF6,
		0xE5, 0x87, 0x9C, 0xF6, 0xE5, 0x87, 0x8C, 0xF6,
		0xE7, 0xA8, 0x9C, 0xF6, 0xE7, 0xB6, 0xBE, 0xF6,
		0xE8, 0x8F, 0xB1, 0xF6, 0xE9, 0x99, 0xB5, 0xF6,
		0xE8, 0xAE, 0x80, 0xF6, 0xE6, 0x8B, 0x8F, 0xF6,
		0xE6, 0xA8, 0x82, 0xF6, 0xE8, 0xAB, 0xBE, 0xF6,
		0xE4, 0xB8, 0xB9, 0xF6, 0xE5, 0xAF, 0xA7, 0xF6,
		0xE6, 0x80, 0x92, 0xF6, 0xE7, 0x8E, 0x87, 0xF6,
		0xE7, 0x95, 0xB0, 0xF6, 0xE5, 0x8C, 0x97, 0xF6,
		0xE7, 0xA3, 0xBB, 0xF6, 0xE4, 0xBE, 0xBF, 0xF6,
		0xE5, 0xBE, 0xA9, 0xF6, 0xE4, 0xB8, 0x8D, 0xF6,
		0xE6, 0xB3, 0x8C, 0xF6, 0xE6, 0x95, 0xB8, 0xF6,
		0xE7, 0xB4, 0xA2, 0xF6, 0xE5, 0x8F, 0x83, 0xF6,
		0xE5, 0xA1, 0x9E, 0xF6, 0xE7, 0x9C, 0x81, 0xF6,
		0xE8, 0x91, 0x89, 0xF6, 0xE8, 0xAA, 0xAA, 0xF6,
		0xE6, 0xAE, 0xBA, 0xF6, 0xE8, 0xBE, 0xB0, 0xF6,
		0xE6, 0xB2, 0x88, 0xF6, 0xE6, 0x8B, 0xBE, 0xF6,
		0xE8, 0x8B, 0xA5, 0xF6, 0xE6, 0x8E, 0xA0, 0xF6,
		0xE7, 0x95, 0xA5, 0xF6, 0xE4, 0xBA, 0xAE, 0xF6,
		0xE5, 0x85, 0xA9, 0xF6, 0xE5, 0x87, 0x89, 0xF6,
		0xE6, 0xA2, 0x81, 0xF6, 0xE7, 0xB3, 0xA7, 0xF6,
		0xE8, 0x89, 0xAF, 0xF6, 0xE8, 0xAB, 0x92, 0xF6,
		0xE9, 0x87, 0x8F, 0xF6, 0xE5, 0x8B, 0xB5, 0xF6,
		0xE5, 0x91, 0x82, 0xF6, 0xE5, 0xA5, 0xB3, 0xF6,
		0xE5, 0xBB, 0xAC, 0xF6, 0xE6, 0x97, 0x85, 0xF6,
		0xE6, 0xBF, 0xBE, 0xF6, 0xE7, 0xA4, 0xAA, 0xF6,
		0xE9, 0x96, 0xAD, 0xF6, 0xE9, 0xA9, 0xAA, 0xF6,
		0xE9, 0xBA, 0x97, 0xF6, 0xE9, 0xBB, 0x8E, 0xF6,
		0xE5, 0x8A, 0x9B, 0xF6, 0xE6, 0x9B, 0x86, 0xF6,
		0xE6, 0xAD, 0xB7, 0xF6, 0xE8, 0xBD, 0xA2, 0xF6,
		0xE5, 0xB9, 0xB4, 0xF6, 0xE6, 0x86, 0x90, 0xF6,
		0xE6, 0x88, 0x80, 0xF6, 0xE6, 0x92, 0x9A, 0xF6,
		0xE6, 0xBC, 0xA3, 0xF6, 0xE7, 0x85, 0x89, 0xF6,
		0xE7, 0x92, 0x89, 0xF6, 0xE7, 0xA7, 0x8A, 0xF6,
		0xE7, 0xB7, 0xB4, 0xF6, 0xE8, 0x81, 0xAF, 0xF6,
		0xE8, 0xBC, 0xA6, 0xF6, 0xE8, 0x93, 0xAE, 0xF6,
		0xE9, 0x80, 0xA3, 0xF6, 0xE9, 0x8D, 0x8A, 0xF6,
		0xE5, 0x88, 0x97, 0xF6, 0xE5, 0x8A, 0xA3, 0xF6,
		0xE5, 0x92, 0xBD, 0xF6, 0xE7, 0x83, 0x88, 0xF6,
		0xE8, 0xA3, 0x82, 0xF6, 0xE8, 0xAA, 0xAA, 0xF6,
		0xE5, 0xBB, 0x89, 0xF6, 0xE5, 0xBF, 0xB5, 0xF6,
		0xE6, 0x8D, 0xBB, 0xF6, 0xE6, 0xAE, 0xAE, 0xF6,
		0xE7, 0xB0, 0xBE, 0xF6, 0xE7, 0x8D, 0xB5, 0xF6,
		0xE4, 0xBB, 0xA4, 0xF6, 0xE5, 0x9B, 0xB9, 0xF6,
		0xE5, 0xAF, 0xA7, 0xF6, 0xE5, 0xB6, 0xBA, 0xF6,
		0xE6, 0x80, 0x9C, 0xF6, 0xE7, 0x8E, 0xB2, 0xF6,
		0xE7, 0x91, 0xA9, 0xF6, 0xE7, 0xBE, 0x9A, 0xF6,
		0xE8, 0x81, 0x86, 0xF6, 0xE9, 0x88, 0xB4, 0xF6,
		0xE9, 0x9B, 0xB6, 0xF6, 0xE9, 0x9D, 0x88, 0xF6,
		0xE9, 0xA0, 0x98, 0xF6, 0xE4, 0xBE, 0x8B, 0xF6,
		0xE7, 0xA6, 0xAE, 0xF6, 0xE9, 0x86, 0xB4, 0xF6,
		0xE9, 0x9A, 0xB8, 0xF6, 0xE6, 0x83, 0xA1, 0xF6,
		0xE4, 0xBA, 0x86, 0xF6, 0xE5, 0x83, 0x9A, 0xF6,
		0xE5, 0xAF, 0xAE, 0xF6, 0xE5, 0xB0, 0xBF, 0xF6,
		0xE6, 0x96, 0x99, 0xF6, 0xE6, 0xA8, 0x82, 0xF6,
		0xE7, 0x87, 0x8E, 0xF6, 0xE7, 0x99, 0x82, 0xF6,
		0xE8, 0x93, 0xBC, 0xF6, 0xE9, 0x81, 0xBC, 0xF6,
		0xE9, 0xBE, 0x8D, 0xF6, 0xE6, 0x9A, 0x88, 0xF6,
		0xE9, 0x98, 0xAE, 0xF6, 0xE5, 0x8A, 0x89, 0xF6,
		0xE6, 0x9D, 0xBB, 0xF6, 0xE6, 0x9F, 0xB3, 0xF6,
		0xE6, 0xB5, 0x81, 0xF6, 0xE6, 0xBA, 0x9C, 0xF6,
		0xE7, 0x90, 0x89, 0xF6, 0xE7, 0x95, 0x99, 0xF6,
		0xE7, 0xA1, 0xAB, 0xF6, 0xE7, 0xB4, 0x90, 0xF6,
		0xE9, 0xA1, 0x9E, 0xF6, 0xE5, 0x85, 0xAD, 0xF6,
		0xE6, 0x88, 0xAE, 0xF6, 0xE9, 0x99, 0xB8, 0xF6,
		0xE5, 0x80, 0xAB, 0xF6, 0xE5, 0xB4, 0x99, 0xF6,
		0xE6, 0xB7, 0xAA, 0xF6, 0xE8, 0xBC, 0xAA, 0xF6,
		0xE5, 0xBE, 0x8B, 0xF6, 0xE6, 0x85, 0x84, 0xF6,
		0xE6, 0xA0, 0x97, 0xF6, 0xE7, 0x8E, 0x87, 0xF6,
		0xE9, 0x9A, 0x86, 0xF6, 0xE5, 0x88, 0xA9, 0xF6,
		0xE5, 0x90, 0x8F, 0xF6, 0xE5, 0xB1, 0xA5, 0xF6,
		0xE6, 0x98, 0x93, 0xF6, 0xE6, 0x9D, 0x8E, 0xF6,
		0xE6, 0xA2, 0xA8, 0xF6, 0xE6, 0xB3, 0xA5, 0xF6,
		0xE7, 0x90, 0x86, 0xF6, 0xE7, 0x97, 0xA2, 0xF6,
		0xE7, 0xBD, 0xB9, 0xF6, 0xE8, 0xA3, 0x8F, 0xF6,
		0xE8, 0xA3, 0xA1, 0xF6, 0xE9, 0x87, 0x8C, 0xF6,
		0xE9, 0x9B, 0xA2, 0xF6, 0xE5, 0x8C, 0xBF, 0xF6,
		0xE6, 0xBA, 0xBA, 0xF6, 0xE5, 0x90, 0x9D, 0xF6,
		0xE7, 0x87, 0x90, 0xF6, 0xE7, 0x92, 0x98, 0xF6,
		0xE8, 0x97, 0xBA, 0xF6, 0xE9, 0x9A, 0xA3, 0xF6,
		0xE9, 0xB1, 0x97, 0xF6, 0xE9, 0xBA, 0x9F, 0xF6,
		0xE6, 0x9E, 0x97, 0xF6, 0xE6, 0xB7, 0x8B, 0xF6,
		0xE8, 0x87, 0xA8, 0xF6, 0xE7, 0xAB, 0x8B, 0xF6,
		0xE7, 0xAC, 0xA0, 0xF6, 0xE7, 0xB2, 0x92, 0xF6,
		0xE7, 0x8B, 0x80, 0xF6, 0xE7, 0x82, 0x99, 0xF6,
		0xE8, 0xAD, 0x98, 0xF6, 0xE4, 0xBB, 0x80, 0xF6,
		0xE8, 0x8C, 0xB6, 0xF6, 0xE5, 0x88, 0xBA, 0xF6,
		0xE5, 0x88, 0x87, 0xF6, 0xE5, 0xBA, 0xA6, 0xF6,
		0xE6, 0x8B, 0x93, 0xF6, 0xE7, 0xB3, 0x96, 0xF6,
		0xE5, 0xAE, 0x85, 0xF6, 0xE6, 0xB4, 0x9E, 0xF6,
		0xE6, 0x9A, 0xB4, 0xF6, 0xE8, 0xBC, 0xBB, 0xF6,
		0xE8, 0xA1, 0x8C, 0xF6, 0xE9, 0x99, 0x8D, 0xF6,
		0xE8, 0xA6, 0x8B, 0xF6, 0xE5, 0xBB, 0x93, 0xF6,
		0xE5, 0x85, 0x80, 0xF6, 0xE5, 0x97, 0x80, 0xF6,
		0xE5, 0xA1, 0x9A, 0xF6, 0xE6, 0x99, 0xB4, 0xF6,
		0xE5, 0x87, 0x9E, 0xF6, 0xE7, 0x8C, 0xAA, 0xF6,
		0xE7, 0x9B, 0x8A, 0xF6, 0xE7, 0xA4, 0xBC, 0xF6,
		0xE7, 0xA5, 0x9E, 0xF6, 0xE7, 0xA5, 0xA5, 0xF6,
		0xE7, 0xA6, 0x8F, 0xF6, 0xE9, 0x9D, 0x96, 0xF6,
		0xE7, 0xB2, 0xBE, 0xF6, 0xE7, 0xBE, 0xBD, 0xF6,
		0xE8, 0x98, 0x92, 0xF6, 0xE8, 0xAB, 0xB8, 0xF6,
		0xE9, 0x80, 0xB8, 0xF6, 0xE9, 0x83, 0xBD, 0xF6,
		0xE9, 0xA3, 0xAF, 0xF6, 0xE9, 0xA3, 0xBC, 0xF6,
		0xE9, 0xA4, 0xA8, 0xF6, 0xE9, 0xB6, 0xB4, 0xF6,
		0xE4, 0xBE, 0xAE, 0xF6, 0xE5, 0x83, 0xA7, 0xF6,
		0xE5, 0x85, 0x8D, 0xF6, 0xE5, 0x8B, 0x89, 0xF6,
		0xE5, 0x8B, 0xA4, 0xF6, 0xE5, 0x8D, 0x91, 0xF6,
		0xE5, 0x96, 0x9D, 0xF6, 0xE5, 0x98, 0x86, 0xF6,
		0xE5, 0x99, 0xA8, 0xF6, 0xE5, 0xA1, 0x80, 0xF6,
		0xE5, 0xA2, 0xA8, 0xF6, 0xE5, 0xB1, 0xA4, 0xF6,
		0xE5, 0xB1, 0xAE, 0xF6, 0xE6, 0x82, 0x94, 0xF6,
		0xE6, 0x85, 0xA8, 0xF6, 0xE6, 0x86, 0x8E, 0xF6,
		0xE6, 0x87, 0xB2, 0xF6, 0xE6, 0x95, 0x8F, 0xF6,
		0xE6, 0x97, 0xA2, 0xF6, 0xE6, 0x9A, 0x91, 0xF6,
		0xE6, 0xA2, 0x85, 0xF6, 0xE6, 0xB5, 0xB7, 0xF6,
		0xE6, 0xB8, 0x9A, 0xF6, 0xE6, 0xBC, 0xA2, 0xF6,
		0xE7, 0x85, 0xAE, 0xF6, 0xE7, 0x88, 0xAB, 0xF6,
		0xE7, 0x90, 0xA2, 0xF6, 0xE7, 0xA2, 0x91, 0xF6,
		0xE7, 0xA4, 0xBE, 0xF6, 0xE7, 0xA5, 0x89, 0xF6,
		0xE7, 0xA5, 0x88, 0xF6, 0xE7, 0xA5, 0x90, 0xF6,
		0xE7, 0xA5, 0x96, 0xF6, 0xE7, 0xA5, 0x9D, 0xF6,
		0xE7, 0xA6, 0x8D, 0xF6, 0xE7, 0xA6, 0x8E, 0xF6,
		0xE7, 0xA9, 0x80, 0xF6, 0xE7, 0xAA, 0x81, 0xF6,
		0xE7, 0xAF, 0x80, 0xF6, 0xE7, 0xB7, 0xB4, 0xF6,
		0xE7, 0xB8, 0x89, 0xF6, 0xE7, 0xB9, 0x81, 0xF6,
		0xE7, 0xBD, 0xB2, 0xF6, 0xE8, 0x80, 0x85, 0xF6,
		0xE8, 0x87, 0xAD, 0xF6, 0xE8, 0x89, 0xB9, 0xF6,
		0xE8, 0x89, 0xB9, 0xF6, 0xE8, 0x91, 0x97, 0xF6,
		0xE8, 0xA4, 0x90, 0xF6, 0xE8, 0xA6, 0x96, 0xF6,
		0xE8, 0xAC, 0x81, 0xF6, 0xE8, 0xAC, 0xB9, 0xF6,
		0xE8, 0xB3, 0x93, 0xF6, 0xE8, 0xB4, 0x88, 0xF6,
		0xE8, 0xBE, 0xB6, 0xF6, 0xE9, 0x80, 0xB8, 0xF6,
		0xE9, 0x9B, 0xA3, 0xF6, 0xE9, 0x9F, 0xBF, 0xF6,
		0xE9, 0xA0, 0xBB, 0x66, 0x66, 0x66, 0x69, 0x66,
		0x6C, 0x66, 0x66, 0x69, 0x66, 0x66, 0x6C, 0x73,
		0x74, 0x73, 0x74, 0xD5, 0xB4, 0xD5, 0xB6, 0xD5,
		0xB4, 0xD5, 0xA5, 0xD5, 0xB4, 0xD5, 0xAB, 0xD5,
		0xBE, 0xD5, 0xB6, 0xD5, 0xB4, 0xD5, 0xAD, 0xF6,
		0xD7, 0x99, 0xD6, 0xB4, 0xF6, 0xD7, 0xB2, 0xD6,
		0xB7, 0xD7, 0xA2, 0xD7, 0x90, 0xD7, 0x93, 0xD7,
		0x94, 0xD7, 0x9B, 0xD7, 0x9C, 0xD7, 0x9D, 0xD7,
		0xA8, 0xD7, 0xAA, 0x2B, 0xF6, 0xD7, 0xA9, 0xD7,
		0x81, 0xF6, 0xD7, 0xA9, 0xD7, 0x82, 0xF6, 0xD7,
		0xA9, 0xD6, 0xBC, 0xD7, 0x81, 0xF6, 0xD7, 0xA9,
		0xD6, 0xBC, 0xD7, 0x82, 0xF6, 0xD7, 0x90, 0xD6,
		0xB7, 0xF6, 0xD7, 0x90, 0xD6, 0xB8, 0xF6, 0xD7,
		0x90, 0xD6, 0xBC, 0xF6, 0xD7, 0x91, 0xD6, 0xBC,
		0xF6, 0xD7, 0x92, 0xD6, 0xBC, 0xF6, 0xD7, 0x93,
		0xD6, 0xBC, 0xF6, 0xD7, 0x94, 0xD6, 0xBC, 0xF6,
		0xD7, 0x95, 0xD6, 0xBC, 0xF6, 0xD7, 0x96, 0xD6,
		0xBC, 0xF6, 0xD7, 0x98, 0xD6, 0xBC, 0xF6, 0xD7,
		0x99, 0xD6, 0xBC, 0xF6, 0xD7, 0x9A, 0xD6, 0xBC,
		0xF6, 0xD7, 0x9B, 0xD6, 0xBC, 0xF6, 0xD7, 0x9C,
		0xD6, 0xBC, 0xF6, 0xD7, 0x9E, 0xD6, 0xBC, 0xF6,
		0xD7, 0xA0, 0xD6, 0xBC, 0xF6, 0xD7, 0xA1, 0xD6,
		0xBC, 0xF6, 0xD7, 0xA3, 0xD6, 0xBC, 0xF6, 0xD7,
		0xA4, 0xD6, 0xBC, 0xF6, 0xD7, 0xA6, 0xD6, 0xBC,
		0xF6, 0xD7, 0xA7, 0xD6, 0xBC, 0xF6, 0xD7, 0xA8,
		0xD6, 0xBC, 0xF6, 0xD7, 0xA9, 0xD6, 0xBC, 0xF6,
		0xD7, 0xAA, 0xD6, 0xBC, 0xF6, 0xD7, 0x95, 0xD6,
		0xB9, 0xF6, 0xD7, 0x91, 0xD6, 0xBF, 0xF6, 0xD7,
		0x9B, 0xD6, 0xBF, 0xF6, 0xD7, 0xA4, 0xD6, 0xBF,
		0xD7, 0x90, 0xD7, 0x9C, 0xD9, 0xB1, 0xD9, 0xB1,
		0xD9, 0xBB, 0xD9, 0xBB, 0xD9, 0xBB, 0xD9, 0xBB,
		0xD9, 0xBE, 0xD9, 0xBE, 0xD9, 0xBE, 0xD9, 0xBE,
		0xDA, 0x80, 0xDA, 0x80, 0xDA, 0x80, 0xDA, 0x80,
		0xD9, 0xBA, 0xD9, 0xBA, 0xD9, 0xBA, 0xD9, 0xBA,
		0xD9, 0xBF, 0xD9, 0xBF, 0xD9, 0xBF, 0xD9, 0xBF,
		0xD9, 0xB9, 0xD9, 0xB9, 0xD9, 0xB9, 0xD9, 0xB9,
		0xDA, 0xA4, 0xDA, 0xA4, 0xDA, 0xA4, 0xDA, 0xA4,
		0xDA, 0xA6, 0xDA, 0xA6, 0xDA, 0xA6, 0xDA, 0xA6,
		0xDA, 0x84, 0xDA, 0x84, 0xDA, 0x84, 0xDA, 0x84,
		0xDA, 0x83, 0xDA, 0x83, 0xDA, 0x83, 0xDA, 0x83,
		0xDA, 0x86, 0xDA, 0x86, 0xDA, 0x86, 0xDA, 0x86,
		0xDA, 0x87, 0xDA, 0x87, 0xDA, 0x87, 0xDA, 0x87,
		0xDA, 0x8D, 0xDA, 0x8D, 0xDA, 0x8C, 0xDA, 0x8C,
		0xDA, 0x8E, 0xDA, 0x8E, 0xDA, 0x88, 0xDA, 0x88,
		0xDA, 0x98, 0xDA, 0x98, 0xDA, 0x91, 0xDA, 0x91,
		0xDA, 0xA9, 0xDA, 0xA9, 0xDA, 0xA9, 0xDA, 0xA9,
		0xDA, 0xAF, 0xDA, 0xAF, 0xDA, 0xAF, 0xDA, 0xAF,
		0xDA, 0xB3, 0xDA, 0xB3, 0xDA, 0xB3, 0xDA, 0xB3,
		0xDA, 0xB1, 0xDA, 0xB1, 0xDA, 0xB1, 0xDA, 0xB1,
		0xDA, 0xBA, 0xDA, 0xBA, 0xDA, 0xBB, 0xDA, 0xBB,
		0xDA, 0xBB, 0xDA, 0xBB, 0xDB, 0x95, 0xD9, 0x94,
		0xDB, 0x95, 0xD9, 0x94, 0xDB, 0x81, 0xDB, 0x81,
		0xDB, 0x81, 0xDB, 0x81, 0xDA, 0xBE, 0xDA, 0xBE,
		0xDA, 0xBE, 0xDA, 0xBE, 0xDB, 0x92, 0xDB, 0x92,
		0xDB, 0x92, 0xD9, 0x94, 0xDB, 0x92, 0xD9, 0x94,
		0xDA, 0xAD, 0xDA, 0xAD, 0xDA, 0xAD, 0xDA, 0xAD,
		0xDB, 0x87, 0xDB, 0x87, 0xDB, 0x86, 0xDB, 0x86,
		0xDB, 0x88, 0xDB, 0x88, 0xDB, 0x87, 0xD9, 0xB4,
		0xDB, 0x8B, 0xDB, 0x8B, 0xDB, 0x85, 0xDB, 0x85,
		0xDB, 0x89, 0xDB, 0x89, 0xDB, 0x90, 0xDB, 0x90,
		0xDB, 0x90, 0xDB, 0x90, 0xD9, 0x89, 0xD9, 0x89,
		0xD9, 0x8A, 0xD9, 0x94, 0xD8, 0xA7, 0xD9, 0x8A,
		0xD9, 0x94, 0xD8, 0xA7, 0xD9, 0x8A, 0xD9, 0x94,
		0xDB, 0x95, 0xD9, 0x8A, 0xD9, 0x94, 0xDB, 0x95,
		0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x88, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x88, 0xD9, 0x8A, 0xD9, 0x94,
		0xDB, 0x87, 0xD9, 0x8A, 0xD9, 0x94, 0xDB, 0x87,
		0xD9, 0x8A, 0xD9, 0x94, 0xDB, 0x86, 0xD9, 0x8A,
		0xD9, 0x94, 0xDB, 0x86, 0xD9, 0x8A, 0xD9, 0x94,
		0xDB, 0x88, 0xD9, 0x8A, 0xD9, 0x94, 0xDB, 0x88,
		0xD9, 0x8A, 0xD9, 0x94, 0xDB, 0x90, 0xD9, 0x8A,
		0xD9, 0x94, 0xDB, 0x90, 0xD9, 0x8A, 0xD9, 0x94,
		0xDB, 0x90, 0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x89,
		0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x89, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x89, 0xDB, 0x8C, 0xDB, 0x8C,
		0xDB, 0x8C, 0xDB, 0x8C, 0xD9, 0x8A, 0xD9, 0x94,
		0xD8, 0xAC, 0xD9, 0x8A, 0xD9, 0x94, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x85, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x89, 0xD9, 0x8A, 0xD9, 0x94,
		0xD9, 0x8A, 0xD8, 0xA8, 0xD8, 0xAC, 0xD8, 0xA8,
		0xD8, 0xAD, 0xD8, 0xA8, 0xD8, 0xAE, 0xD8, 0xA8,
		0xD9, 0x85, 0xD8, 0xA8, 0xD9, 0x89, 0xD8, 0xA8,
		0xD9, 0x8A, 0xD8, 0xAA, 0xD8, 0xAC, 0xD8, 0xAA,
		0xD8, 0xAD, 0xD8, 0xAA, 0xD8, 0xAE, 0xD8, 0xAA,
		0xD9, 0x85, 0xD8, 0xAA, 0xD9, 0x89, 0xD8, 0xAA,
		0xD9, 0x8A, 0xD8, 0xAB, 0xD8, 0xAC, 0xD8, 0xAB,
		0xD9, 0x85, 0xD8, 0xAB, 0xD9, 0x89, 0xD8, 0xAB,
		0xD9, 0x8A, 0xD8, 0xAC, 0xD8, 0xAD, 0xD8, 0xAC,
		0xD9, 0x85, 0xD8, 0xAD, 0xD8, 0xAC, 0xD8, 0xAD,
		0xD9, 0x85, 0xD8, 0xAE, 0xD8, 0xAC, 0xD8, 0xAE,
		0xD8, 0xAD, 0xD8, 0xAE, 0xD9, 0x85, 0xD8, 0xB3,
		0xD8, 0xAC, 0xD8, 0xB3, 0xD8, 0xAD, 0xD8, 0xB3,
		0xD8, 0xAE, 0xD8, 0xB3, 0xD9, 0x85, 0xD8, 0xB5,
		0xD8, 0xAD, 0xD8, 0xB5, 0xD9, 0x85, 0xD8, 0xB6,
		0xD8, 0xAC, 0xD8, 0xB6, 0xD8, 0xAD, 0xD8, 0xB6,
		0xD8, 0xAE, 0xD8, 0xB6, 0xD9, 0x85, 0xD8, 0xB7,
		0xD8, 0xAD, 0xD8, 0xB7, 0xD9, 0x85, 0xD8, 0xB8,
		0xD9, 0x85, 0xD8, 0xB9, 0xD8, 0xAC, 0xD8, 0xB9,
		0xD9, 0x85, 0xD8, 0xBA, 0xD8, 0xAC, 0xD8, 0xBA,
		0xD9, 0x85, 0xD9, 0x81, 0xD8, 0xAC, 0xD9, 0x81,
		0xD8, 0xAD, 0xD9, 0x81, 0xD8, 0xAE, 0xD9, 0x81,
		0xD9, 0x85, 0xD9, 0x81, 0xD9, 0x89, 0xD9, 0x81,
		0xD9, 0x8A, 0xD9, 0x82, 0xD8, 0xAD, 0xD9, 0x82,
		0xD9, 0x85, 0xD9, 0x82, 0xD9, 0x89, 0xD9, 0x82,
		0xD9, 0x8A, 0xD9, 0x83, 0xD8, 0xA7, 0xD9, 0x83,
		0xD8, 0xAC, 0xD9, 0x83, 0xD8, 0xAD, 0xD9, 0x83,
		0xD8, 0xAE, 0xD9, 0x83, 0xD9, 0x84, 0xD9, 0x83,
		0xD9, 0x85, 0xD9, 0x83, 0xD9, 0x89, 0xD9, 0x83,
		0xD9, 0x8A, 0xD9, 0x84, 0xD8, 0xAC, 0xD9, 0x84,
		0xD8, 0xAD, 0xD9, 0x84, 0xD8, 0xAE, 0xD9, 0x84,
		0xD9, 0x85, 0xD9, 0x84, 0xD9, 0x89, 0xD9, 0x84,
		0xD9, 0x8A, 0xD9, 0x85, 0xD8, 0xAC, 0xD9, 0x85,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAE, 0xD9, 0x85,
		0xD9, 0x85, 0xD9, 0x85, 0xD9, 0x89, 0xD9, 0x85,
		0xD9, 0x8A, 0xD9, 0x86, 0xD8, 0xAC, 0xD9, 0x86,
		0xD8, 0xAD, 0xD9, 0x86, 0xD8, 0xAE, 0xD9, 0x86,
		0xD9, 0x85, 0xD9, 0x86, 0xD9, 0x89, 0xD9, 0x86,
		0xD9, 0x8A, 0xD9, 0x87, 0xD8, 0xAC, 0xD9, 0x87,
		0xD9, 0x85, 0xD9, 0x87, 0xD9, 0x89, 0xD9, 0x87,
		0xD9, 0x8A, 0xD9, 0x8A, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xAD, 0xD9, 0x8A, 0xD8, 0xAE, 0xD9, 0x8A,
		0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x89, 0xD9, 0x8A,
		0xD9, 0x8A, 0xD8, 0xB0, 0xD9, 0xB0, 0xD8, 0xB1,
		0xD9, 0xB0, 0xD9, 0x89, 0xD9, 0xB0, 0x20, 0xD9,
		0x8C, 0xD9, 0x91, 0x20, 0xD9, 0x8D, 0xD9, 0x91,
		0x20, 0xD9, 0x8E, 0xD9, 0x91, 0x20, 0xD9, 0x8F,
		0xD9, 0x91, 0x20, 0xD9, 0x90, 0xD9, 0x91, 0x20,
		0xD9, 0x91, 0xD9, 0xB0, 0xD9, 0x8A, 0xD9, 0x94,
		0xD8, 0xB1, 0xD9, 0x8A, 0xD9, 0x94, 0xD8, 0xB2,
		0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x85, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x86, 0xD9, 0x8A, 0xD9, 0x94,
		0xD9, 0x89, 0xD9, 0x8A, 0xD9, 0x94, 0xD9, 0x8A,
		0xD8, 0xA8, 0xD8, 0xB1, 0xD8, 0xA8, 0xD8, 0xB2,
		0xD8, 0xA8, 0xD9, 0x85, 0xD8, 0xA8, 0xD9, 0x86,
		0xD8, 0xA8, 0xD9, 0x89, 0xD8, 0xA8, 0xD9, 0x8A,
		0xD8, 0xAA, 0xD8, 0xB1, 0xD8, 0xAA, 0xD8, 0xB2,
		0xD8, 0xAA, 0xD9, 0x85, 0xD8, 0xAA, 0xD9, 0x86,
		0xD8, 0xAA, 0xD9, 0x89, 0xD8, 0xAA, 0xD9, 0x8A,
		0xD8, 0xAB, 0xD8, 0xB1, 0xD8, 0xAB, 0xD8, 0xB2,
		0xD8, 0xAB, 0xD9, 0x85, 0xD8, 0xAB, 0xD9, 0x86,
		0xD8, 0xAB, 0xD9, 0x89, 0xD8, 0xAB, 0xD9, 0x8A,
		0xD9, 0x81, 0xD9, 0x89, 0xD9, 0x81, 0xD9, 0x8A,
		0xD9, 0x82, 0xD9, 0x89, 0xD9, 0x82, 0xD9, 0x8A,
		0xD9, 0x83, 0xD8, 0xA7, 0xD9, 0x83, 0xD9, 0x84,
		0xD9, 0x83, 0xD9, 0x85, 0xD9, 0x83, 0xD9, 0x89,
		0xD9, 0x83, 0xD9, 0x8A, 0xD9, 0x84, 0xD9, 0x85,
		0xD9, 0x84, 0xD9, 0x89, 0xD9, 0x84, 0xD9, 0x8A,
		0xD9, 0x85, 0xD8, 0xA7, 0xD9, 0x85, 0xD9, 0x85,
		0xD9, 0x86, 0xD8, 0xB1, 0xD9, 0x86, 0xD8, 0xB2,
		0xD9, 0x86, 0xD9, 0x85, 0xD9, 0x86, 0xD9, 0x86,
		0xD9, 0x86, 0xD9, 0x89, 0xD9, 0x86, 0xD9, 0x8A,
		0xD9, 0x89, 0xD9, 0xB0, 0xD9, 0x8A, 0xD8, 0xB1,
		0xD9, 0x8A, 0xD8, 0xB2, 0xD9, 0x8A, 0xD9, 0x85,
		0xD9, 0x8A, 0xD9, 0x86, 0xD9, 0x8A, 0xD9, 0x89,
		0xD9, 0x8A, 0xD9, 0x8A, 0xD9, 0x8A, 0xD9, 0x94,
		0xD8, 0xAC, 0xD9, 0x8A, 0xD9, 0x94, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD9, 0x94, 0xD8, 0xAE, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x94,
		0xD9, 0x87, 0xD8, 0xA8, 0xD8, 0xAC, 0xD8, 0xA8,
		0xD8, 0xAD, 0xD8, 0xA8, 0xD8, 0xAE, 0xD8, 0xA8,
		0xD9, 0x85, 0xD8, 0xA8, 0xD9, 0x87, 0xD8, 0xAA,
		0xD8, 0xAC, 0xD8, 0xAA, 0xD8, 0xAD, 0xD8, 0xAA,
		0xD8, 0xAE, 0xD8, 0xAA, 0xD9, 0x85, 0xD8, 0xAA,
		0xD9, 0x87, 0xD8, 0xAB, 0xD9, 0x85, 0xD8, 0xAC,
		0xD8, 0xAD, 0xD8, 0xAC, 0xD9, 0x85, 0xD8, 0xAD,
		0xD8, 0xAC, 0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAE,
		0xD8, 0xAC, 0xD8, 0xAE, 0xD9, 0x85, 0xD8, 0xB3,
		0xD8, 0xAC, 0xD8, 0xB3, 0xD8, 0xAD, 0xD8, 0xB3,
		0xD8, 0xAE, 0xD8, 0xB3, 0xD9, 0x85, 0xD8, 0xB5,
		0xD8, 0xAD, 0xD8, 0xB5, 0xD8, 0xAE, 0xD8, 0xB5,
		0xD9, 0x85, 0xD8, 0xB6, 0xD8, 0xAC, 0xD8, 0xB6,
		0xD8, 0xAD, 0xD8, 0xB6, 0xD8, 0xAE, 0xD8, 0xB6,
		0xD9, 0x85, 0xD8, 0xB7, 0xD8, 0xAD, 0xD8, 0xB8,
		0xD9, 0x85, 0xD8, 0xB9, 0xD8, 0xAC, 0xD8, 0xB9,
		0xD9, 0x85, 0xD8, 0xBA, 0xD8, 0xAC, 0xD8, 0xBA,
		0xD9, 0x85, 0xD9, 0x81, 0xD8, 0xAC, 0xD9, 0x81,
		0xD8, 0xAD, 0xD9, 0x81, 0xD8, 0xAE, 0xD9, 0x81,
		0xD9, 0x85, 0xD9, 0x82, 0xD8, 0xAD, 0xD9, 0x82,
		0xD9, 0x85, 0xD9, 0x83, 0xD8, 0xAC, 0xD9, 0x83,
		0xD8, 0xAD, 0xD9, 0x83, 0xD8, 0xAE, 0xD9, 0x83,
		0xD9, 0x84, 0xD9, 0x83, 0xD9, 0x85, 0xD9, 0x84,
		0xD8, 0xAC, 0xD9, 0x84, 0xD8, 0xAD, 0xD9, 0x84,
		0xD8, 0xAE, 0xD9, 0x84, 0xD9, 0x85, 0xD9, 0x84,
		0xD9, 0x87, 0xD9, 0x85, 0xD8, 0xAC, 0xD9, 0x85,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAE, 0xD9, 0x85,
		0xD9, 0x85, 0xD9, 0x86, 0xD8, 0xAC, 0xD9, 0x86,
		0xD8, 0xAD, 0xD9, 0x86, 0xD8, 0xAE, 0xD9, 0x86,
		0xD9, 0x85, 0xD9, 0x86, 0xD9, 0x87, 0xD9, 0x87,
		0xD8, 0xAC, 0xD9, 0x87, 0xD9, 0x85, 0xD9, 0x87,
		0xD9, 0xB0, 0xD9, 0x8A, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xAD, 0xD9, 0x8A, 0xD8, 0xAE, 0xD9, 0x8A,
		0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x87, 0xD9, 0x8A,
		0xD9, 0x94, 0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x94,
		0xD9, 0x87, 0xD8, 0xA8, 0xD9, 0x85, 0xD8, 0xA8,
		0xD9, 0x87, 0xD8, 0xAA, 0xD9, 0x85, 0xD8, 0xAA,
		0xD9, 0x87, 0xD8, 0xAB, 0xD9, 0x85, 0xD8, 0xAB,
		0xD9, 0x87, 0xD8, 0xB3, 0xD9, 0x85, 0xD8, 0xB3,
		0xD9, 0x87, 0xD8, 0xB4, 0xD9, 0x85, 0xD8, 0xB4,
		0xD9, 0x87, 0xD9, 0x83, 0xD9, 0x84, 0xD9, 0x83,
		0xD9, 0x85, 0xD9, 0x84, 0xD9, 0x85, 0xD9, 0x86,
		0xD9, 0x85, 0xD9, 0x86, 0xD9, 0x87, 0xD9, 0x8A,
		0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x87, 0xD9, 0x80,
		0xD9, 0x8E, 0xD9, 0x91, 0xD9, 0x80, 0xD9, 0x8F,
		0xD9, 0x91, 0xD9, 0x80, 0xD9, 0x90, 0xD9, 0x91,
		0xD8, 0xB7, 0xD9, 0x89, 0xD8, 0xB7, 0xD9, 0x8A,
		0xD8, 0xB9, 0xD9, 0x89, 0xD8, 0xB9, 0xD9, 0x8A,
		0xD8, 0xBA, 0xD9, 0x89, 0xD8, 0xBA, 0xD9, 0x8A,
		0xD8, 0xB3, 0xD9, 0x89, 0xD8, 0xB3, 0xD9, 0x8A,
		0xD8, 0xB4, 0xD9, 0x89, 0xD8, 0xB4, 0xD9, 0x8A,
		0xD8, 0xAD, 0xD9, 0x89, 0xD8, 0xAD, 0xD9, 0x8A,
		0xD8, 0xAC, 0xD9, 0x89, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xAE, 0xD9, 0x89, 0xD8, 0xAE, 0xD9, 0x8A,
		0xD8, 0xB5, 0xD9, 0x89, 0xD8, 0xB5, 0xD9, 0x8A,
		0xD8, 0xB6, 0xD9, 0x89, 0xD8, 0xB6, 0xD9, 0x8A,
		0xD8, 0xB4, 0xD8, 0xAC, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD8, 0xB4, 0xD8, 0xAE, 0xD8, 0xB4, 0xD9, 0x85,
		0xD8, 0xB4, 0xD8, 0xB1, 0xD8, 0xB3, 0xD8, 0xB1,
		0xD8, 0xB5, 0xD8, 0xB1, 0xD8, 0xB6, 0xD8, 0xB1,
		0xD8, 0xB7, 0xD9, 0x89, 0xD8, 0xB7, 0xD9, 0x8A,
		0xD8, 0xB9, 0xD9, 0x89, 0xD8, 0xB9, 0xD9, 0x8A,
		0xD8, 0xBA, 0xD9, 0x89, 0xD8, 0xBA, 0xD9, 0x8A,
		0xD8, 0xB3, 0xD9, 0x89, 0xD8, 0xB3, 0xD9, 0x8A,
		0xD8, 0xB4, 0xD9, 0x89, 0xD8, 0xB4, 0xD9, 0x8A,
		0xD8, 0xAD, 0xD9, 0x89, 0xD8, 0xAD, 0xD9, 0x8A,
		0xD8, 0xAC, 0xD9, 0x89, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xAE, 0xD9, 0x89, 0xD8, 0xAE, 0xD9, 0x8A,
		0xD8, 0xB5, 0xD9, 0x89, 0xD8, 0xB5, 0xD9, 0x8A,
		0xD8, 0xB6, 0xD9, 0x89, 0xD8, 0xB6, 0xD9, 0x8A,
		0xD8, 0xB4, 0xD8, 0xAC, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD8, 0xB4, 0xD8, 0xAE, 0xD8, 0xB4, 0xD9, 0x85,
		0xD8, 0xB4, 0xD8, 0xB1, 0xD8, 0xB3, 0xD8, 0xB1,
		0xD8, 0xB5, 0xD8, 0xB1, 0xD8, 0xB6, 0xD8, 0xB1,
		0xD8, 0xB4, 0xD8, 0xAC, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD8, 0xB4, 0xD8, 0xAE, 0xD8, 0xB4, 0xD9, 0x85,
		0xD8, 0xB3, 0xD9, 0x87, 0xD8, 0xB4, 0xD9, 0x87,
		0xD8, 0xB7, 0xD9, 0x85, 0xD8, 0xB3, 0xD8, 0xAC,
		0xD8, 0xB3, 0xD8, 0xAD, 0xD8, 0xB3, 0xD8, 0xAE,
		0xD8, 0xB4, 0xD8, 0xAC, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD8, 0xB4, 0xD8, 0xAE, 0xD8, 0xB7, 0xD9, 0x85,
		0xD8, 0xB8, 0xD9, 0x85, 0xD8, 0xA7, 0xD9, 0x8B,
		0xD8, 0xA7, 0xD9, 0x8B, 0xD8, 0xAA, 0xD8, 0xAC,
		0xD9, 0x85, 0xD8, 0xAA, 0xD8, 0xAD, 0xD8, 0xAC,
		0xD8, 0xAA, 0xD8, 0xAD, 0xD8, 0xAC, 0xD8, 0xAA,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAA, 0xD8, 0xAE,
		0xD9, 0x85, 0xD8, 0xAA, 0xD9, 0x85, 0xD8, 0xAC,
		0xD8, 0xAA, 0xD9, 0x85, 0xD8, 0xAD, 0xD8, 0xAA,
		0xD9, 0x85, 0xD8, 0xAE, 0xD8, 0xAC, 0xD9, 0x85,
		0xD8, 0xAD, 0xD8, 0xAC, 0xD9, 0x85, 0xD8, 0xAD,
		0xD8, 0xAD, 0xD9, 0x85, 0xD9, 0x8A, 0xD8, 0xAD,
		0xD9, 0x85, 0xD9, 0x89, 0xD8, 0xB3, 0xD8, 0xAD,
		0xD8, 0xAC, 0xD8, 0xB3, 0xD8, 0xAC, 0xD8, 0xAD,
		0xD8, 0xB3, 0xD8, 0xAC, 0xD9, 0x89, 0xD8, 0xB3,
		0xD9, 0x85, 0xD8, 0xAD, 0xD8, 0xB3, 0xD9, 0x85,
		0xD8, 0xAD, 0xD8, 0xB3, 0xD9, 0x85, 0xD8, 0xAC,
		0xD8, 0xB3, 0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB3,
		0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB5, 0xD8, 0xAD,
		0xD8, 0xAD, 0xD8, 0xB5, 0xD8, 0xAD, 0xD8, 0xAD,
		0xD8, 0xB5, 0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB4,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD9, 0x85, 0xD8, 0xB4, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xB4, 0xD9, 0x85, 0xD8, 0xAE, 0xD8, 0xB4,
		0xD9, 0x85, 0xD8, 0xAE, 0xD8, 0xB4, 0xD9, 0x85,
		0xD9, 0x85, 0xD8, 0xB4, 0xD9, 0x85, 0xD9, 0x85,
		0xD8, 0xB6, 0xD8, 0xAD, 0xD9, 0x89, 0xD8, 0xB6,
		0xD8, 0xAE, 0xD9, 0x85, 0xD8, 0xB6, 0xD8, 0xAE,
		0xD9, 0x85, 0xD8, 0xB7, 0xD9, 0x85, 0xD8, 0xAD,
		0xD8, 0xB7, 0xD9, 0x85, 0xD8, 0xAD, 0xD8, 0xB7,
		0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB7, 0xD9, 0x85,
		0xD9, 0x8A, 0xD8, 0xB9, 0xD8, 0xAC, 0xD9, 0x85,
		0xD8, 0xB9, 0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB9,
		0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB9, 0xD9, 0x85,
		0xD9, 0x89, 0xD8, 0xBA, 0xD9, 0x85, 0xD9, 0x85,
		0xD8, 0xBA, 0xD9, 0x85, 0xD9, 0x8A, 0xD8, 0xBA,
		0xD9, 0x85, 0xD9, 0x89, 0xD9, 0x81, 0xD8, 0xAE,
		0xD9, 0x85, 0xD9, 0x81, 0xD8, 0xAE, 0xD9, 0x85,
		0xD9, 0x82, 0xD9, 0x85, 0xD8, 0xAD, 0xD9, 0x82,
		0xD9, 0x85, 0xD9, 0x85, 0xD9, 0x84, 0xD8, 0xAD,
		0xD9, 0x85, 0xD9, 0x84, 0xD8, 0xAD, 0xD9, 0x8A,
		0xD9, 0x84, 0xD8, 0xAD, 0xD9, 0x89, 0xD9, 0x84,
		0xD8, 0xAC, 0xD8, 0xAC, 0xD9, 0x84, 0xD8, 0xAC,
		0xD8, 0xAC, 0xD9, 0x84, 0xD8, 0xAE, 0xD9, 0x85,
		0xD9, 0x84, 0xD8, 0xAE, 0xD9, 0x85, 0xD9, 0x84,
		0xD9, 0x85, 0xD8, 0xAD, 0xD9, 0x84, 0xD9, 0x85,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAD, 0xD8, 0xAC,
		0xD9, 0x85, 0xD8, 0xAD, 0xD9, 0x85, 0xD9, 0x85,
		0xD8, 0xAD, 0xD9, 0x8A, 0xD9, 0x85, 0xD8, 0xAC,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xAC, 0xD9, 0x85,
		0xD9, 0x85, 0xD8, 0xAE, 0xD8, 0xAC, 0xD9, 0x85,
		0xD8, 0xAE, 0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xAC,
		0xD8, 0xAE, 0xD9, 0x87, 0xD9, 0x85, 0xD8, 0xAC,
		0xD9, 0x87, 0xD9, 0x85, 0xD9, 0x85, 0xD9, 0x86,
		0xD8, 0xAD, 0xD9, 0x85, 0xD9, 0x86, 0xD8, 0xAD,
		0xD9, 0x89, 0xD9, 0x86, 0xD8, 0xAC, 0xD9, 0x85,
		0xD9, 0x86, 0xD8, 0xAC, 0xD9, 0x85, 0xD9, 0x86,
		0xD8, 0xAC, 0xD9, 0x89, 0xD9, 0x86, 0xD9, 0x85,
		0xD9, 0x8A, 0xD9, 0x86, 0xD9, 0x85, 0xD9, 0x89,
		0xD9, 0x8A, 0xD9, 0x85, 0xD9, 0x85, 0xD9, 0x8A,
		0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xA8, 0xD8, 0xAE,
		0xD9, 0x8A, 0xD8, 0xAA, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xAA, 0xD8, 0xAC, 0xD9, 0x89, 0xD8, 0xAA,
		0xD8, 0xAE, 0xD9, 0x8A, 0xD8, 0xAA, 0xD8, 0xAE,
		0xD9, 0x89, 0xD8, 0xAA, 0xD9, 0x85, 0xD9, 0x8A,
		0xD8, 0xAA, 0xD9, 0x85, 0xD9, 0x89, 0xD8, 0xAC,
		0xD9, 0x85, 0xD9, 0x8A, 0xD8, 0xAC, 0xD8, 0xAD,
		0xD9, 0x89, 0xD8, 0xAC, 0xD9, 0x85, 0xD9, 0x89,
		0xD8, 0xB3, 0xD8, 0xAE, 0xD9, 0x89, 0xD8, 0xB5,
		0xD8, 0xAD, 0xD9, 0x8A, 0xD8, 0xB4, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD8, 0xB6, 0xD8, 0xAD, 0xD9, 0x8A,
		0xD9, 0x84, 0xD8, 0xAC, 0xD9, 0x8A, 0xD9, 0x84,
		0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x8A, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD9, 0x8A, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD9, 0x8A, 0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x85,
		0xD9, 0x85, 0xD9, 0x8A, 0xD9, 0x82, 0xD9, 0x85,
		0xD9, 0x8A, 0xD9, 0x86, 0xD8, 0xAD, 0xD9, 0x8A,
		0xD9, 0x82, 0xD9, 0x85, 0xD8, 0xAD, 0xD9, 0x84,
		0xD8, 0xAD, 0xD9, 0x85, 0xD8, 0xB9, 0xD9, 0x85,
		0xD9, 0x8A, 0xD9, 0x83, 0xD9, 0x85, 0xD9, 0x8A,
		0xD9, 0x86, 0xD8, 0xAC, 0xD8, 0xAD, 0xD9, 0x85,
		0xD8, 0xAE, 0xD9, 0x8A, 0xD9, 0x84, 0xD8, 0xAC,
		0xD9, 0x85, 0xD9, 0x83, 0xD9, 0x85, 0xD9, 0x85,
		0xD9, 0x84, 0xD8, 0xAC, 0xD9, 0x85, 0xD9, 0x86,
		0xD8, 0xAC, 0xD8, 0xAD, 0xD8, 0xAC, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD8, 0xAD, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD9, 0x85, 0xD8, 0xAC, 0xD9, 0x8A, 0xD9, 0x81,
		0xD9, 0x85, 0xD9, 0x8A, 0xD8, 0xA8, 0xD8, 0xAD,
		0xD9, 0x8A, 0xD9, 0x83, 0xD9, 0x85, 0xD9, 0x85,
		0xD8, 0xB9, 0xD8, 0xAC, 0xD9, 0x85, 0xD8, 0xB5,
		0xD9, 0x85, 0xD9, 0x85, 0xD8, 0xB3, 0xD8, 0xAE,
		0xD9, 0x8A, 0xD9, 0x86, 0xD8, 0xAC, 0xD9, 0x8A,
		0xD8, 0xB5, 0xD9, 0x84, 0xDB, 0x92, 0xD9, 0x82,
		0xD9, 0x84, 0xDB, 0x92, 0xD8, 0xA7, 0xD9, 0x84,
		0xD9, 0x84, 0xD9, 0x87, 0xD8, 0xA7, 0xD9, 0x83,
		0xD8, 0xA8, 0xD8, 0xB1, 0xD9, 0x85, 0xD8, 0xAD,
		0xD9, 0x85, 0xD8, 0xAF, 0xD8, 0xB5, 0xD9, 0x84,
		0xD8, 0xB9, 0xD9, 0x85, 0xD8, 0xB1, 0xD8, 0xB3,
		0xD9, 0x88, 0xD9, 0x84, 0xD8, 0xB9, 0xD9, 0x84,
		0xD9, 0x8A, 0xD9, 0x87, 0xD9, 0x88, 0xD8, 0xB3,
		0xD9, 0x84, 0xD9, 0x85, 0xD8, 0xB5, 0xD9, 0x84,
		0xD9, 0x89, 0xD8, 0xB5, 0xD9, 0x84, 0xD9, 0x89,
		0x20, 0xD8, 0xA7, 0xD9, 0x84, 0xD9, 0x84, 0xD9,
		0x87, 0x20, 0xD8, 0xB9, 0xD9, 0x84, 0xD9, 0x8A,
		0xD9, 0x87, 0x20, 0xD9, 0x88, 0xD8, 0xB3, 0xD9,
		0x84, 0xD9, 0x85, 0xD8, 0xAC, 0xD9, 0x84, 0x20,
		0xD8, 0xAC, 0xD9, 0x84, 0xD8, 0xA7, 0xD9, 0x84,
		0xD9, 0x87, 0xD8, 0xB1, 0xDB, 0x8C, 0xD8, 0xA7,
		0xD9, 0x84, 0x2E, 0x2E, 0xE2, 0x80, 0x94, 0xE2,
		0x80, 0x93, 0x5F, 0x5F, 0x28, 0x29, 0x7B, 0x7D,
		0xE3, 0x80, 0x94, 0xE3, 0x80, 0x95, 0xE3, 0x80,
		0x90, 0xE3, 0x80, 0x91, 0xE3, 0x80, 0x8A, 0xE3,
		0x80, 0x8B, 0xE3, 0x80, 0x88, 0xE3, 0x80, 0x89,
		0xE3, 0x80, 0x8C, 0xE3, 0x80, 0x8D, 0xE3, 0x80,
		0x8E, 0xE3, 0x80, 0x8F, 0x20, 0xCC, 0x85, 0x20,
		0xCC, 0x85, 0x20, 0xCC, 0x85, 0x20, 0xCC, 0x85,
		0x5F, 0x5F, 0x5F, 0x2C, 0xE3, 0x80, 0x81, 0x2E,
		0x3B, 0x3A, 0x3F, 0x21, 0xE2, 0x80, 0x94, 0x28,
		0x29, 0x7B, 0x7D, 0xE3, 0x80, 0x94, 0xE3, 0x80,
		0x95, 0x23, 0x26, 0x2A, 0x2B, 0x2D, 0x3C, 0x3E,
		0x3D, 0x5C, 0x24, 0x25, 0x40, 0x20, 0xD9, 0x8B,
		0xD9, 0x80, 0xD9, 0x8B, 0x20, 0xD9, 0x8C, 0x20,
		0xD9, 0x8D, 0x20, 0xD9, 0x8E, 0xD9, 0x80, 0xD9,
		0x8E, 0x20, 0xD9, 0x8F, 0xD9, 0x80, 0xD9, 0x8F,
		0x20, 0xD9, 0x90, 0xD9, 0x80, 0xD9, 0x90, 0x20,
		0xD9, 0x91, 0xD9, 0x80, 0xD9, 0x91, 0x20, 0xD9,
		0x92, 0xD9, 0x80, 0xD9, 0x92, 0xD8, 0xA1, 0xD8,
		0xA7, 0xD9, 0x93, 0xD8, 0xA7, 0xD9, 0x93, 0xD8,
		0xA7, 0xD9, 0x94, 0xD8, 0xA7, 0xD9, 0x94, 0xD9,
		0x88, 0xD9, 0x94, 0xD9, 0x88, 0xD9, 0x94, 0xD8,
		0xA7, 0xD9, 0x95, 0xD8, 0xA7, 0xD9, 0x95, 0xD9,
		0x8A, 0xD9, 0x94, 0xD9, 0x8A, 0xD9, 0x94, 0xD9,
		0x8A, 0xD9, 0x94, 0xD9, 0x8A, 0xD9, 0x94, 0xD8,
		0xA7, 0xD8, 0xA7, 0xD8, 0xA8, 0xD8, 0xA8, 0xD8,
		0xA8, 0xD8, 0xA8, 0xD8, 0xA9, 0xD8, 0xA9, 0xD8,
		0xAA, 0xD8, 0xAA, 0xD8, 0xAA, 0xD8, 0xAA, 0xD8,
		0xAB, 0xD8, 0xAB, 0xD8, 0xAB, 0xD8, 0xAB, 0xD8,
		0xAC, 0xD8, 0xAC, 0xD8, 0xAC, 0xD8, 0xAC, 0xD8,
		0xAD, 0xD8, 0xAD, 0xD8, 0xAD, 0xD8, 0xAD, 0xD8,
		0xAE, 0xD8, 0xAE, 0xD8, 0xAE, 0xD8, 0xAE, 0xD8,
		0xAF, 0xD8, 0xAF, 0xD8, 0xB0, 0xD8, 0xB0, 0xD8,
		0xB1, 0xD8, 0xB1, 0xD8, 0xB2, 0xD8, 0xB2, 0xD8,
		0xB3, 0xD8, 0xB3, 0xD8, 0xB3, 0xD8, 0xB3, 0xD8,
		0xB4, 0xD8, 0xB4, 0xD8, 0xB4, 0xD8, 0xB4, 0xD8,
		0xB5, 0xD8, 0xB5, 0xD8, 0xB5, 0xD8, 0xB5, 0xD8,
		0xB6, 0xD8, 0xB6, 0xD8, 0xB6, 0xD8, 0xB6, 0xD8,
		0xB7, 0xD8, 0xB7, 0xD8, 0xB7, 0xD8, 0xB7, 0xD8,
		0xB8, 0xD8, 0xB8, 0xD8, 0xB8, 0xD8, 0xB8, 0xD8,
		0xB9, 0xD8, 0xB9, 0xD8, 0xB9, 0xD8, 0xB9, 0xD8,
		0xBA, 0xD8, 0xBA, 0xD8, 0xBA, 0xD8, 0xBA, 0xD9,
		0x81, 0xD9, 0x81, 0xD9, 0x81, 0xD9, 0x81, 0xD9,
		0x82, 0xD9, 0x82, 0xD9, 0x82, 0xD9, 0x82, 0xD9,
		0x83, 0xD9, 0x83, 0xD9, 0x83, 0xD9, 0x83, 0xD9,
		0x84, 0xD9, 0x84, 0xD9, 0x84, 0xD9, 0x84, 0xD9,
		0x85, 0xD9, 0x85, 0xD9, 0x85, 0xD9, 0x85, 0xD9,
		0x86, 0xD9, 0x86, 0xD9, 0x86, 0xD9, 0x86, 0xD9,
		0x87, 0xD9, 0x87, 0xD9, 0x87, 0xD9, 0x87, 0xD9,
		0x88, 0xD9, 0x88, 0xD9, 0x89, 0xD9, 0x89, 0xD9,
		0x8A, 0xD9, 0x8A, 0xD9, 0x8A, 0xD9, 0x8A, 0xD9,
		0x84, 0xD8, 0xA7, 0xD9, 0x93, 0xD9, 0x84, 0xD8,
		0xA7, 0xD9, 0x93, 0xD9, 0x84, 0xD8, 0xA7, 0xD9,
		0x94, 0xD9, 0x84, 0xD8, 0xA7, 0xD9, 0x94, 0xD9,
		0x84, 0xD8, 0xA7, 0xD9, 0x95, 0xD9, 0x84, 0xD8,
		0xA7, 0xD9, 0x95, 0xD9, 0x84, 0xD8, 0xA7, 0xD9,
		0x84, 0xD8, 0xA7, 0x21, 0x22, 0x23, 0x24, 0x25,
		0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D,
		0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
		0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D,
		0x3E, 0x3F, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45,
		0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D,
		0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55,
		0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
		0x5E, 0x5F, 0x60, 0x61, 0x62, 0x63, 0x64, 0x65,
		0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D,
		0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75,
		0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D,
		0x7E, 0xE2, 0xA6, 0x85, 0xE2, 0xA6, 0x86, 0xE3,
		0x80, 0x82, 0xE3, 0x80, 0x8C, 0xE3, 0x80, 0x8D,
		0xE3, 0x80, 0x81, 0xE3, 0x83, 0xBB, 0xE3, 0x83,
		0xB2, 0xE3, 0x82, 0xA1, 0xE3, 0x82, 0xA3, 0xE3,
		0x82, 0xA5, 0xE3, 0x82, 0xA7, 0xE3, 0x82, 0xA9,
		0xE3, 0x83, 0xA3, 0xE3, 0x83, 0xA5, 0xE3, 0x83,
		0xA7, 0xE3, 0x83, 0x83, 0xE3, 0x83, 0xBC, 0xE3,
		0x82, 0xA2, 0xE3, 0x82, 0xA4, 0xE3, 0x82, 0xA6,
		0xE3, 0x82, 0xA8, 0xE3, 0x82, 0xAA, 0xE3, 0x82,
		0xAB, 0xE3, 0x82, 0xAD, 0xE3, 0x82, 0xAF, 0xE3,
		0x82, 0xB1, 0xE3, 0x82, 0xB3, 0xE3, 0x82, 0xB5,
		0xE3, 0x82, 0xB7, 0xE3, 0x82, 0xB9, 0xE3, 0x82,
		0xBB, 0xE3, 0x82, 0xBD, 0xE3, 0x82, 0xBF, 0xE3,
		0x83, 0x81, 0xE3, 0x83, 0x84, 0xE3, 0x83, 0x86,
		0xE3, 0x83, 0x88, 0xE3, 0x83, 0x8A, 0xE3, 0x83,
		0x8B, 0xE3, 0x83, 0x8C, 0xE3, 0x83, 0x8D, 0xE3,
		0x83, 0x8E, 0xE3, 0x83, 0x8F, 0xE3, 0x83, 0x92,
		0xE3, 0x83, 0x95, 0xE3, 0x83, 0x98, 0xE3, 0x83,
		0x9B, 0xE3, 0x83, 0x9E, 0xE3, 0x83, 0x9F, 0xE3,
		0x83, 0xA0, 0xE3, 0x83, 0xA1, 0xE3, 0x83, 0xA2,
		0xE3, 0x83, 0xA4, 0xE3, 0x83, 0xA6, 0xE3, 0x83,
		0xA8, 0xE3, 0x83, 0xA9, 0xE3, 0x83, 0xAA, 0xE3,
		0x83, 0xAB, 0xE3, 0x83, 0xAC, 0xE3, 0x83, 0xAD,
		0xE3, 0x83, 0xAF, 0xE3, 0x83, 0xB3, 0xE3, 0x82,
		0x99, 0xE3, 0x82, 0x9A, 0xE1, 0x85, 0xA0, 0xE1,
		0x84, 0x80, 0xE1, 0x84, 0x81, 0xE1, 0x86, 0xAA,
		0xE1, 0x84, 0x82, 0xE1, 0x86, 0xAC, 0xE1, 0x86,
		0xAD, 0xE1, 0x84, 0x83, 0xE1, 0x84, 0x84, 0xE1,
		0x84, 0x85, 0xE1, 0x86, 0xB0, 0xE1, 0x86, 0xB1,
		0xE1, 0x86, 0xB2, 0xE1, 0x86, 0xB3, 0xE1, 0x86,
		0xB4, 0xE1, 0x86, 0xB5, 0xE1, 0x84, 0x9A, 0xE1,
		0x84, 0x86, 0xE1, 0x84, 0x87, 0xE1, 0x84, 0x88,
		0xE1, 0x84, 0xA1, 0xE1, 0x84, 0x89, 0xE1, 0x84,
		0x8A, 0xE1, 0x84, 0x8B, 0xE1, 0x84, 0x8C, 0xE1,
		0x84, 0x8D, 0xE1, 0x84, 0x8E, 0xE1, 0x84, 0x8F,
		0xE1, 0x84, 0x90, 0xE1, 0x84, 0x91, 0xE1, 0x84,
		0x92, 0xE1, 0x85, 0xA1, 0xE1, 0x85, 0xA2, 0xE1,
		0x85, 0xA3, 0xE1, 0x85, 0xA4, 0xE1, 0x85, 0xA5,
		0xE1, 0x85, 0xA6, 0xE1, 0x85, 0xA7, 0xE1, 0x85,
		0xA8, 0xE1, 0x85, 0xA9, 0xE1, 0x85, 0xAA, 0xE1,
		0x85, 0xAB, 0xE1, 0x85, 0xAC, 0xE1, 0x85, 0xAD,
		0xE1, 0x85, 0xAE, 0xE1, 0x85, 0xAF, 0xE1, 0x85,
		0xB0, 0xE1, 0x85, 0xB1, 0xE1, 0x85, 0xB2, 0xE1,
		0x85, 0xB3, 0xE1, 0x85, 0xB4, 0xE1, 0x85, 0xB5,
		0xC2, 0xA2, 0xC2, 0xA3, 0xC2, 0xAC, 0x20, 0xCC,
		0x84, 0xC2, 0xA6, 0xC2, 0xA5, 0xE2, 0x82, 0xA9,
		0xE2, 0x94, 0x82, 0xE2, 0x86, 0x90, 0xE2, 0x86,
		0x91, 0xE2, 0x86, 0x92, 0xE2, 0x86, 0x93, 0xE2,
		0x96, 0xA0, 0xE2, 0x97, 0x8B, 0xF6, 0xF0, 0x9D,
		0x85, 0x97, 0xF0, 0x9D, 0x85, 0xA5, 0xF6, 0xF0,
		0x9D, 0x85, 0x98, 0xF0, 0x9D, 0x85, 0xA5, 0xF6,
		0xF0, 0x9D, 0x85, 0x98, 0xF0, 0x9D, 0x85, 0xA5,
		0xF0, 0x9D, 0x85, 0xAE, 0xF6, 