/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 */

#include "config.h"

#include <assert.h>
#include <iconv.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

/*
 * XXX For macOS 10.12.5 (Sierra) at least, we seem to need to use
 * langinfo.h, otherwise libiconv_open() fails, which may result in
 * confusing behaviour if a caller does not handle errors carefully
 * (it took a while to figure that out for libdsm for exactly this reason).
 * So we change __APPLE__ to __OLD_APPLE__ below, although the latter symbol
 * must be manually defined should you need it.
 * All bets are off if your MacOS X does not have langinfo.h
 * bjb 25-May-2017
 */
#if HAVE_LANGINFO_H && !defined( __OLD_APPLE__ )
# include <langinfo.h>
#endif

#include "libdsm_common.h"
#include "libdsm_debug.h"
#include "smb_utils.h"

/*
 * XXX for now, always use an instance of libiconv built in a subtree
 * of libdsm.
 * A problematic quirk is that GNU libiconv can build with either or both
 * of functions iconv/libiconv, iconv_open/libiconv_open,
 * iconv_close/libiconv_close defined.  If the system library uses the
 * "iconv" prefix, GNU libiconv can be installed with the "libiconv" prefix
 * to help to avoid confusion.  It's not clear that its build parameters
 * allow us to force the definitions that we want for any of our supported
 * platforms.
 * We will expect to use the "libiconv" prefix versions of these functions.
 *
 * For some additional details, see:
 * https://stackoverflow.com/questions/40464430/how-to-build-a-static-lib-of-iconv-on-osx-without-libiconv-symbol-names
 */
#undef iconv
#undef iconv_close
#undef iconv_open
#define iconv libiconv
#define iconv_close libiconv_close
#define iconv_open libiconv_open
extern size_t libiconv (iconv_t cd,  char* * inbuf, size_t *inbytesleft,
						char* * outbuf, size_t *outbytesleft);
extern int libiconv_close (iconv_t cd);
extern iconv_t libiconv_open (const char* tocode, const char* fromcode);


#ifndef lint
static MAYBE_UNUSED const char copyright[] =
"Copyright (c) 2003-2017\n\
Distributed Systems Software.  All rights reserved.";
static MAYBE_UNUSED const char revid[] =
  "$Id: smb_utils.c 2964 2017-05-25 20:50:03Z brachman $";
#endif

static const char *
current_encoding(void)
{
#if defined( __OLD_APPLE__ )
  return("UTF8");
#elif !HAVE_LANGINFO_H
  return("UTF-8");
#else
  static int locale_set = 0;

  if (!locale_set) {
	setlocale(LC_ALL, "");
	locale_set = 1;
  }
  //BDSM_dbg("%s\n", nl_langinfo(CODESET));
  return(nl_langinfo(CODESET));
#endif
}

static size_t
smb_iconv(const char *src, size_t src_len, char **dst,
		  const char *src_enc, const char *dst_enc)
{
  unsigned int mul;
  iconv_t ic;
  size_t ret = 0;

  assert(src != NULL && dst != NULL && src_enc != NULL && dst_enc != NULL);

  if (!src_len) {
	*dst = NULL;
	return(0);
  }

  if ((ic = iconv_open(dst_enc, src_enc)) == (iconv_t) -1) {
	BDSM_dbg("Unable to open iconv to convert from %s to %s\n",
			 src_enc, dst_enc);
	*dst = NULL;
	return(0);
  }

  for (mul = 4; mul < 16; mul++) {
	size_t outlen = mul * src_len;
	char *out = malloc(outlen);
	const char *inp = src;

	size_t inb = src_len;
	char *outp = out;
	size_t outb = outlen;

	if (!out)
	  break;
	if (iconv(ic, (char **)&inp, &inb, &outp, &outb) != (size_t)(-1)) {
	  ret = outlen - outb;
	  *dst = out;
	  break;
	}
	free(out);
	if (errno != E2BIG)
	  break;
  }
  iconv_close(ic);

  if (ret == 0)
	*dst = NULL;
  return(ret);
}

size_t
smb_to_utf16(const char *src, size_t src_len, char **dst)
{

  return(smb_iconv(src, src_len, dst, current_encoding(), "UCS-2LE"));
}

size_t
smb_from_utf16(const char *src, size_t src_len, char **dst)
{

  return(smb_iconv(src, src_len, dst, "UCS-2LE", current_encoding()));
}
