#pragma once

#include <string>
#include <memory>
#include <GL/glew.h>

/**
 * \brief
 * Basic interface for all GL textures.
 *
 * This interface represents a texture which is bound to OpenGL, with an OpenGL
 * texture number (as returned from glGenTextures()). This may be a 2D, 3D, cube
 * map or any other kind of texture object supported by OpenGL.
 */
class Texture
{
public:
    /**
     * \brief
	 * Destructor
	 */
	virtual ~Texture() {}

    /**
     * \brief
     * Constant indicating an invalid texture size.
     */
    const static std::size_t INVALID_SIZE = 0;

    /**
     * \brief
     * Return the string name of this texture.
     */
    virtual std::string getName() const = 0;

    /**
     * \brief
     * Return the GL texture identifier for this texture.
     */
    virtual GLuint getGLTexNum() const = 0;

    /**
     * \brief
     * Return the width of this texture in pixels. May return INVALID_SIZE if
     * this texture does not have a valid size.
     */
    virtual std::size_t getWidth() const = 0;

    /**
     * \brief
     * Return the height of this texture in pixels. May return INVALID_SIZE if
     * this texture does not have a valid size.
     */
    virtual std::size_t getHeight() const = 0;
};
typedef std::shared_ptr<Texture> TexturePtr;

