// ---------------------------------------------------------------------
//
// Copyright (C) 2013, 2014 by the deal.II authors
//
// This file is part of the deal.II library.
//
// The deal.II library is free software; you can use it, redistribute
// it, and/or modify it under the terms of the GNU Lesser General
// Public License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// The full text of the license can be found in the file LICENSE.md at
// the top level directory of deal.II.
//
// ---------------------------------------------------------------------

/**
 * @page changes_between_5_0_and_5_1 Changes between Version 5.0 and 5.1

<p>
This is the list of changes made between the deal.II releases listed above.
All entries are signed with the names of the author. Regular
contributor's names are abbreviated by WB (Wolfgang Bangerth), GK
(Guido Kanschat), RH (Ralf Hartmann).
</p>


<a name="incompatible"></a>
<h3 style="color:red">Incompatibilities</h3>

<p style="color:red">
Following are a few modifications to the library that unfortunately
are incompatible with previous versions of the library, but which we
deem necessary for the future maintainability of the
library. Unfortunately, some of these changes will require
modifications to application programs. We apologize for the
inconvenience this causes.
</p>


<ol>

  <li> <p> Changed: The call <code
  class="class">MGTransferBlock</code>::<code
  class="member">build_matrices</code> and to the same function in
  derived classes receaves a <code>DoFHandler</code> as
  an additional argument. It is needed to prebuild the transfer
  between vectors and multigrid vectors, since the loop over all cells
  is to slow.
  <br>
  (GK 2004/08/27)
  </p>

  <li> <p>
       Changed: Previously, parallel PETSc matrices only took the sizes of the
       matrix and the number of rows to be stored locally as arguments. They
       chose the partitioning of columns to be the same as that for the
       rows. However, this does not work for non-quadratic parallel matrices,
       and leads to very hard to find errors. Therefore, all constructors and
       reinit functions of the parallel sparse matrix classes now take an
       additional argument indicating the partitioning of columns of the matrix.
       <br>
       (WB 2004/06/02)
       </p>
</ol>



<a name="general"></a>
<h3>General</h3>

<ol>
  <li> <p>
       New: Support of shared libraries under Cygwin / Windows systems. Shared
       libraries are used as default. To use, make sure the library path is included
       in your <code>PATH</code> environment variable.
       <br>
       (Ralf B. Schulz, 2004/12/20)
       </p>

  <li> <p>
       Fixed: Examples do not use obsolete classes
       <code>QGaussN</code> anymore.
       <br>
       (GK 2004/12/18)
       </p>

  <li> <p>
       Fixed: Configuration scripts were changed to allow any file suffix for
       shared and static libraries to allow in the future the creation of dlls
       under cygwin.
       <br>
       (Ralf B. Schulz, 2004/12/17)
       </p>

  <li> <p>
       New: Configuration now detects the Intel Fortran compiler and can set
       compilation flags accordingly.
       <br>
       (WB 2004/11/04)
       </p>

  <li> <p>
       Extended: deal.II 5.0.0 didn't work with the PETSc release 2.2.1 (which
       came out after we released version 5.0.0). This should now be fixed:
       deal.II can be linked against both PETSc 2.2.0 and 2.2.1.
       <br>
       (WB 2004/10/07)
       </p>

  <li> <p>
       Improved: The documentation generated by Doxygen now states the header
       file defining a class. Furthermore, all deal.II
       exceptions are listed as classes and will soon be found in the module
       <tt>Exceptions</tt>.
       <br>
       (GK 2004/09/16)
       </p>

  <li> <p>
       New: configuration option <tt>--with-umfpack</tt> for using the
       UMFPack version and enabling the class <code
       class="class">SparseDirectUMFPACK</code>, both included by
       Wolfgang.
       <br>
       Deal.II comes with its own copy of the <a
       href="http://www.cise.ufl.edu/research/sparse/umfpack/">UMFPACK</a>
       library, courtesy of its author. In order to use, follow the steps
       listed <a href="../readme.html#umfpack">here</a>. Note that UMFPACK
       comes with its own license; to use UMFPACK, please read the <a
       href="../readme.html#license">ReadMe</a> file and make sure that you
       agree with its license.
       <br>
       (GK 2004/08/25)
       </p>

  <li> <p>
       Fixed: None of the formulas in the step-8 tutorial program web
       page were visible. This is now fixed.
       <br>
       (WB 2004/06/29)
       </p>

</ol>


<a name="base"></a>
<h3>base</h3>

<ol>
  <li> <p>
       New: The <code>MultithreadInfo</code> class now also detects multiple
       processors on Mac OS X.
       <br>
       (Helmut M&uuml;ller 2004/11/29)
  </p>

  <li> <p>
       New: The <code>
       TableHandler::write_tex</code> now accepts the additional boolean
       argument <code>with_header</code> which is set to
       true by default and tells the function whether to add the latex
       header and footer (i.e. the \\documentclass{...},
       \\begin{document} and \\end{document} stuff) to the table.<br>
       In addition to this, there are two new members in the above class:
       <code> TableHandler::tex_set_table_caption</code> and
       <code> TableHandler::tex_set_table_label</code> to
       add a caption and a label to the tex generated table.
       <br>
       (Luca Heltai 2004/10/29)
  </p>

  <li> <p>
       Fixed: <code
       class="member">DataOutBase::write_tecplot</code> for dim=2 and spacedim=3
       sometimes did not write the variable name <code>z</code> when
       only outputting faces of cells. This is now fixed.
       <br>
       (RH 2004/10/29)
       </p>

  <li> <p>
       New: a class template <code>VectorSlice</code>
       allows access to consecutive portions of a vector.
       <br>
       (GK 2004/09/16)
       </p>

  <li> <p> New: The classes <code
       class="class">TableIndices&lt;N&gt;</code> and <code
       class="class">Table&lt;N,T&gt;</code> are now implemented also
       for <code>N=7</code>. The <code
       class="class">Table&lt;N,T&gt;</code> class represents an
       <code>N</code>-dimensional array and might replace the
       N-times-nested-use of the <code
       class="class">std::vector</code> class.
       <br>
       (RH 2004/08/13)
       </p>

  <li> <p>
       New: Class <code>TableIndices</code> now has
       operators that check for equality and inequality of objects.
       <br>
       (WB 2004/07/28)
       </p>

  <li> <p>
       New: A class <code>PointerComparison</code> for comparing
       pointers that may or may not be of the same type.
       <br>
       (WB 2004/06/22)
       </p>

  <li> <p>
       Removed: The <code
       class="class">ParameterHandler</code> class contained a remnant from
       back in 1997 when it was modeled after a similar class in DiffPack: it
       had a <code>status</code> flag that one could obtain via the <code
       class="member">ok</code> function. It was never really used for
       anything, and has thus finally been removed. The <code
       class="member">ok</code> is consequently gone as well.
       <br>
       (WB 2004/06/06)
       </p>

  <li> <p>
       New: An object of the new <code
       class="class">ConditionalOStream</code> class allows to print
       to an output stream depending on a condition, which is active
       or not. This is particular useful for parallel computations
       when only one process should print to standard output, while in all
       other processes we simply want output suppressed.
       <br>
       (RH 2004/05/26)
       </p>
</ol>



<a name="lac"></a>
<h3>lac</h3>

<ol>
  <li> <p>
       Fixed: PETSc had changed some of its interfaces in version 2.2.1, which
       prevented deal.II from working with it (it couldn't be compiled at
       all). We have added checks that make sure that it can now again be
       compiled with PETSc versions 2.1.6, 2.2.0, and 2.2.1.
       <br>
       (WB 2004/10/07)
       </p>

  <li> <p>
       New: A class <code>PreconditionLU</code> which
       provides a wrapper to the complete LU decomposition
       preconditioner of PETSc. Furthermore a class
       <code>SolverPreOnly</code> was implemented. It
       is a wrapper for the PETSc solver type KSPPREONLY, which
       only applies the preconditioner. In conjunction with
       <code>PreconditionLU</code> this provides a
       simple direct solver, which could be used for small to medium
       sized problems on a single processor machine.
       <br>
       (Oliver Kayser-Herold 2004/07/27)
       </p>

 <li> <p>
       Improved: <code>VectorTools::point_difference</code>
       used to use an algorithm to find the cell the given point is in that
       was linear in the total number of active cells. It has been rewritten
       to use
       <code>GridTools::find_active_cell_around_point</code>
       which is only logarithmic in its complexity.
       <br>
       (WB 2004/07/07)
       </p>

  <li> <p>
       Fixed: Block matrix iterators could get into all kind of interesting
       (and invalid) states when some of the blocks had empty rows. In this
       common case, we would frequently skip elements when looping over the
       elements of a block matrix. These cases should now be fixed.
       <br>
       (WB 2004/07/07)
       </p>

  <li> <p>
       Removed: Block matrix iterators used to have a function
       <code>it-&gt;index()</code> that returned something like
       the position within a row. However, this was fragile, and has been
       removed. If you want an ordering of elements within a row, use the
       <code>operator &lt;</code> to compare iterators.
       <br>
       (WB 2004/07/07)
       </p>

  <li> <p>
       Improved: The <code
       class="class">PETScWrappers::SolverGMRES::AdditionalData</code>
       class now takes an additional flag indicating the use of left
       or right preconditioning.
       <br>
       (RH 2004/06/24)
       </p>

  <li> <p>
       Improved: The <code>SparseDirectMA27</code> class can now
       handle float as well as double input matrices and vectors.
       <br>
       (WB 2004/06/23)
       </p>

  <li> <p>
       Fixed: The <code
       class="member">SparseMatrix::vmult</code>-type functions
       <code>vmult</code>, <code>Tvmult</code>, <code>vmult_add</code>, and
       <code>Tvmult_add</code> take two different template arguments for input
       and output vectors, but were only instantiated in case the arguments
       were the same, and could also not be compiled if they weren't. Both
       problems are now fixed.
       <br>
       (WB 2004/06/22)
       </p>

  <li> <p>
       Improved: The <code>CompressedSparsityPattern</code>
       class used one of the C++ standard containers to store the column
       indices of nonzero entries in a sparse matrix. This proved to be
       inefficient since it requires the allocation of 20 bytes each time an
       element was added, which for large matrices can be millions of
       times. The new storage format uses a more compact data structure, and a
       cache that requires memory allocation only every 8 additions, on
       average. This should significantly reduce the total amount of memory
       required as well as memory fragmentation. It also cuts run-time for
       element addition by more than half.
       <br>
       (WB 2004/06/21)
       </p>

  <li> <p>
       Fixed: <code
       class="member">CompressedSparsityPattern::max_entries_per_row()</code>
       ignored the first row and thus sometimes returned a value that was too
       low. This is now fixed.
       <br>
       (WB 2004/06/21)
       </p>

  <li> <p>
       Fixed: <code>BlockSparseMatrix::clear()</code> did not
       do what it was supposed to do: it emptied the individual blocks and
       removed them, but it still kept the number of blocks
       unchanged. Subsequent accesses to these blocks, or to their information
       yielded segmentation faults.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       New: Block matrices and vectors have been factored into abstract base
       classes and concrete implementation classes. While the previous classes
       still exist in all their functionality, this allowed us to now also
       have block matrices and vectors for PETSc sequential and parallel
       objects.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       New: Vector and block vector classes had a commented out template
       constructor constructing such a vector from a vector object with a
       different template argument, for example constructing a <code
       class="class">Vector&lt;double&gt;</code> from a <code
       class="class">Vector&lt;float&gt;</code>. This constructor has been
       commented out a long time ago due to a compiler bug in which the
       <code>explicit</code> keyword on template constructors was ignored, a
       fact that is dangerous since it may lead the compiler to generate
       temporaries without our ado. This bug is now detected during
       configuration time of the library, and these constructors are available
       whenever the compiler does not contain this bug.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       New: In analogy to the PETSc vector classes, the PETSc matrix classes
       now also have member functions <code>local_range</code>,
       <code>in_local_range</code>, and <code
       class="member">local_size</code>.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       New: Parallel PETSc matrix and vector classes now have member functions
       <code>get_mpi_communicator</code> that returns the MPI
       communicator object these objects operate on.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       Changed: The PETSc linear solver classes now take a constant, rather
       than a nonconstant reference to the MPI communicator to be used. This
       prevents some unnecessary compiler problems in conjunction with the new
       <code>get_mpi_communicator</code> function.
       <br>
       (WB 2004/06/02)
       </p>

  <li> <p>
       New: Parallel and sequential PETSc sparse matrix classes can now be
       initialized (via either constructor or reinit functions) with a
       compressed sparsity pattern object, allowing for more efficient
       preallocation of nonzero entries.
       <br>
       (WB 2004/06/02)
       </p>
</ol>



<a name="deal.II"></a>
<h3>deal.II</h3>

<ol>
  <li> <p>
       Improved: <code>GeometryInfo</code> has two new
       fields <code>unit_normal_direction</code> and
       <code>unit_normal_orientation</code>,
       indicating the direction of the unit normal vector for each
       face of the reference cell.
       <br>
       (GK 2004/12/18)
       </p>

  <li> <p>
       Fixed: In rare cases of 3d meshes with a certain topology,
       we triggered an assertion in <code
       class="class">TriaAccessor</code>::<code
       class="member">neighbor_child_on_subface</code>. It turns out
       that the code actually computes the correct answer, but the
       assertion had a condition that doesn't always have to be
       satisfied. This bogus assertion is now fixed.
       <br>
       (WB 2004/11/12)
       </p>

  <li> <p> Fixed: The <code>GridGenerator</code>::<code
       class="member">cylinder</code> function in 3d assigned the
       wrong boundary value to the top and bottom part of the cylinder
       if the half length of the cylinder was not equal to 1. This is
       now fixed.
       <br>
       (Ralf Schulz 2004/10/27)
       </p>

  <li> <p>
       Improved: Now the <code>FE_Q</code> class supports hanging node
       constraints for elements of arbitrary polynomial degree also in
       3D.
       <br>
       (Oliver Kayser-Herold 2004/10/21)
       </p>

  <li> <p>
       Fixed: The <code
       class="class">StraightBoundary&lt;3&gt;</code>::<code
       class="member">get_new_point_on_quad</code>
       did not work on general grids. This is now fixed.
       <br>
       (RH 2004/10/15)
       </p>

  <li> <p>
       Improved: The <code>CylinderBoundary</code>
       represented the hull of a circular tubes along the x-axis. It
       is now extended to allow for circular tubes also along the y-
       and z-axis.
       <br>
       (RH 2004/10/15)
       </p>

  <li> <p>
       Fixed: The <code>ConstraintMatrix</code> class had some
       algorithms that were linear in the number of constraints. Since these
       functions had to be called for each constraint, this resulted in a
       quadratic behavior. To make things worse, these algorithms traversed
       large memory blocks leading to a vast number of cache misses which made
       them really slow. This is now fixed: the algorithm is O(1) and should
       only access single elements in memory, and one 3d testcase is now a
       full 5 per cent faster on about 10 minutes runtime.
       <br>
       (WB 2004/10/04)
       </p>

  <li> <p>
       New: The <code>GridOut</code>::<code
       class="member">write_gnuplot</code> function now supports
       curved boundaries also for <code>dim==3</code>.
       <br>
       (RH 2004/09/20)
       </p>

  <li> <p>
       Fixed: The documentation of the <code
       class="member">Triangulation</code> class mentioned that no
       places in the library use or touch the user pointers. That is
       wrong, the <code>SolutionTransfer</code> class
       actually does. This is now properly documented.
       <br>
       (WB 2004/09/15)
       </p>

  <li> <p>
       Fixed: The <code
       class="member">DerivativeApproximation::approximate_second_derivative</code>
       function produced wrong results ("not a number", or an exception instead of
       "zero") if the field it was given was constant. This is now fixed.
       <br>
       (WB 2004/08/05)
       </p>

  <li> <p>
       New: The <code>MatrixTools::apply_boundary_values</code>
       that works on block matrices and vectors is now templatized over the
       number type, i.e. it also works for float matrices and vectors.
       <br>
       (WB 2004/06/22)
       </p>

  <li> <p>
       New: The new <code>FEValuesBase::get_cell</code>
       function returns the current cell, i.e. the latest cell the
       <code>FEValues</code> object was reinited with.
       <br>
       (RH 2004/06/22)
       </p>

  <li> <p>
       Changed: The <code
       class="member">MatrixTools::local_apply_boundary_values</code> function
       used to set the diagonal entries of boundary nodes to one. This is a
       really bad choice, and the algorithm we use now is much better. There
       are still a few problems when using this function for matrices that
       will be solved as a Schur complement; there is nothing we can do in
       that function in these cases, since we are lacking fundamental pieces
       of information, but the cases where this applies and the strategies to
       work with this problem anyway are now well documented in the
       documentation of the <code>MatrixTools</code> class.
       <br>
       (WB 2004/06/07)
       </p>

  <li> <p>
       Fixed: The <code>GridGenerator::cylinder_shell</code>
       function generated cells were all inside-out, i.e. had negative
       Jacobians. In usual finite element computations this simply leads to
       all components of the linear system being negated, so it is not
       harmful. It is fixed now anyway.
       <br>
       (WB 2004/06/07)
       </p>
</ol>



*/
