/**
 * Ext JS Library 3.4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.ns('Ext.ux.form');

/**
 * @class Ext.ux.form.SpinnerField
 * @extends Ext.form.NumberField
 * Creates a field utilizing Ext.ux.Spinner
 * @xtype spinnerfield
 */
Ext.ux.form.SpinnerField = Ext.extend(Ext.form.NumberField, {
    actionMode: 'wrap',
    deferHeight: true,
    autoSize: Ext.emptyFn,
    onBlur: Ext.emptyFn,
    adjustSize: Ext.BoxComponent.prototype.adjustSize,

    constructor: function (config) {
        var spinnerConfig = Ext.copyTo(
            {},
            config,
            'incrementValue,alternateIncrementValue,accelerate,defaultValue,triggerClass,splitterClass'
        );

        var spl = (this.spinner = new Ext.ux.Spinner(spinnerConfig));

        var plugins = config.plugins
            ? Ext.isArray(config.plugins)
                ? config.plugins.push(spl)
                : [config.plugins, spl]
            : spl;

        Ext.ux.form.SpinnerField.superclass.constructor.call(
            this,
            Ext.apply(config, { plugins: plugins })
        );
    },

    // private
    getResizeEl: function () {
        return this.wrap;
    },

    // private
    getPositionEl: function () {
        return this.wrap;
    },

    // private
    alignErrorIcon: function () {
        if (this.wrap) {
            this.errorIcon.alignTo(this.wrap, 'tl-tr', [2, 0]);
        }
    },

    validateBlur: function () {
        return true;
    },
});

Ext.reg('spinnerfield', Ext.ux.form.SpinnerField);

//backwards compat
Ext.form.SpinnerField = Ext.ux.form.SpinnerField;
