/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QMenu>
#include <QStyle>
#include <QSettings>
#include <QResizeEvent>

#include "dsearchwidget.h"

dsearchwidget::dsearchwidget(QWidget *parent):QLineEdit(parent)
{
  findToolButton = new QToolButton(this);
  findToolButton->setToolTip(tr("Initiate Search"));
  findToolButton->setIconSize(QSize(16, 16));
  findToolButton->setCursor(Qt::ArrowCursor);
  findToolButton->setStyleSheet("QToolButton {"
				"border: none; "
				"}");
  pulldownToolButton = new QToolButton(this);
  pulldownToolButton->setCursor(Qt::ArrowCursor);
  pulldownToolButton->setIcon(QIcon("Icons/16x16/dooble.png"));
  pulldownToolButton->setIconSize(QSize(16, 16));
  pulldownToolButton->setStyleSheet("QToolButton {"
				    "border: none; "
#ifdef Q_WS_MAC
				    "padding-right: 10px; "
#else
				    "padding-right: 15px; "
#endif
				    "}");

  QMenu *menu = new QMenu();

  menu->setActiveAction
    (menu->addAction(QIcon("Icons/16x16/dooble.png"), "Dooble Search"));
  menu->addAction(QIcon("Icons/16x16/kvk.png"), "KVK Booksearch");
  menu->addAction(QIcon("Icons/16x16/lilirasa.png"), "Lilirasa");
  menu->addAction(QIcon("Icons/16x16/metager.png"), "Metager");
  menu->addAction(QIcon("Icons/16x16/openpc.png"), "OpenDesktop Apps");
  menu->addAction(QIcon("Icons/16x16/osm.png"), "OpenStreetMap");
  menu->addAction(QIcon("Icons/16x16/sciencenet.png"), "Sciencenet");
  menu->addAction(QIcon("Icons/16x16/wikipedia.png"), "Wikipedia");
  menu->addAction(QIcon("Icons/16x16/yacy.png"), "YaCy Suche");
  menu->addSeparator();
  menu->addAction(QIcon("Icons/16x16/dooble.png"), "My Dooble Search");
  connect(menu, SIGNAL(triggered(QAction *)), this,
	  SLOT(slotSearchTypeChanged(QAction *)));
  pulldownToolButton->setMenu(menu);
  pulldownToolButton->setPopupMode(QToolButton::InstantPopup);
  slotSetIcons();

  int frameWidth = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);

  setStyleSheet
    (QString("QLineEdit {padding-right: %1px; padding-left: %2px;}").arg
     (findToolButton->sizeHint().width() + frameWidth + 1).arg
     (pulldownToolButton->sizeHint().width() + frameWidth + 1));
  setMaximumWidth(150);
#if QT_VERSION >= 0x040500
  setMinimumHeight(sizeHint().height() + 5);
#endif
}

void dsearchwidget::resizeEvent(QResizeEvent *event)
{
  Q_UNUSED(event);
  int frameWidth = style()->pixelMetric(QStyle::PM_DefaultFrameWidth);
  QSize size1 = findToolButton->sizeHint();
  QSize size2 = pulldownToolButton->sizeHint();

  findToolButton->move
    (rect().right() - frameWidth - size1.width(),
     (rect().bottom() + 2 - size1.height()) / 2);
  pulldownToolButton->move
    (frameWidth - rect().left() + 1,
     (rect().bottom() + 2 - size2.height()) / 2);
}

QString dsearchwidget::type(void)
{
  if(pulldownToolButton->menu()->activeAction())
    return pulldownToolButton->menu()->activeAction()->text().toLower();
  else
    return "dooble search";
}

QToolButton *dsearchwidget::findButton(void)
{
  return findToolButton;
}

void dsearchwidget::slotSearchTypeChanged(QAction *action)
{
  pulldownToolButton->setIcon(action->icon());
  pulldownToolButton->menu()->setActiveAction(action);
}

void dsearchwidget::slotSetIcons(void)
{
  QSettings settings;
  QSettings cfgSettings
    (settings.value("iconSet").toString(), QSettings::IniFormat);

  cfgSettings.beginGroup("searchWidget");
  findToolButton->setIcon
    (QIcon(cfgSettings.value("findToolButton").toString()));
}
