/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2019 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/** @file fcml_gas_mnemonics.hpp
 * Declarations of AT&T mnemonics for C++.
 *
 * @copyright Copyright (C) 2010-2015 Slawomir Wojtasiak. All rights reserved.
 * This project is released under the GNU Lesser General Public License.
 */

#ifndef FCML_GAS_MNEMONICS_HPP_
#define FCML_GAS_MNEMONICS_HPP_

#include "fcml_types.h"

namespace fcml {
namespace gas {

extern const fcml_cstring M_AAA;
extern const fcml_cstring M_AAD;
extern const fcml_cstring M_AAM;
extern const fcml_cstring M_AAS;
extern const fcml_cstring M_ADC;
extern const fcml_cstring M_ADCB;
extern const fcml_cstring M_ADCL;
extern const fcml_cstring M_ADCQ;
extern const fcml_cstring M_ADCW;
extern const fcml_cstring M_ADCX;
extern const fcml_cstring M_ADD;
extern const fcml_cstring M_ADDB;
extern const fcml_cstring M_ADDL;
extern const fcml_cstring M_ADDPD;
extern const fcml_cstring M_ADDPS;
extern const fcml_cstring M_ADDQ;
extern const fcml_cstring M_ADDSD;
extern const fcml_cstring M_ADDSS;
extern const fcml_cstring M_ADDSUBPD;
extern const fcml_cstring M_ADDSUBPS;
extern const fcml_cstring M_ADDW;
extern const fcml_cstring M_ADOX;
extern const fcml_cstring M_AESDEC;
extern const fcml_cstring M_AESDECLAST;
extern const fcml_cstring M_AESENC;
extern const fcml_cstring M_AESENCLAST;
extern const fcml_cstring M_AESIMC;
extern const fcml_cstring M_AESKEYGENASSIST;
extern const fcml_cstring M_AND;
extern const fcml_cstring M_ANDB;
extern const fcml_cstring M_ANDL;
extern const fcml_cstring M_ANDN;
extern const fcml_cstring M_ANDNPD;
extern const fcml_cstring M_ANDNPS;
extern const fcml_cstring M_ANDPD;
extern const fcml_cstring M_ANDPS;
extern const fcml_cstring M_ANDQ;
extern const fcml_cstring M_ANDW;
extern const fcml_cstring M_ARPL;
extern const fcml_cstring M_BEXR;
extern const fcml_cstring M_BEXTR;
extern const fcml_cstring M_BLCFILL;
extern const fcml_cstring M_BLCI;
extern const fcml_cstring M_BLCIC;
extern const fcml_cstring M_BLCMSK;
extern const fcml_cstring M_BLCS;
extern const fcml_cstring M_BLENDPD;
extern const fcml_cstring M_BLENDPS;
extern const fcml_cstring M_BLENDVPD;
extern const fcml_cstring M_BLENDVPS;
extern const fcml_cstring M_BLSFILL;
extern const fcml_cstring M_BLSI;
extern const fcml_cstring M_BLSIC;
extern const fcml_cstring M_BLSMSK;
extern const fcml_cstring M_BLSR;
extern const fcml_cstring M_BOUND;
extern const fcml_cstring M_BSF;
extern const fcml_cstring M_BSR;
extern const fcml_cstring M_BSWAP;
extern const fcml_cstring M_BT;
extern const fcml_cstring M_BTC;
extern const fcml_cstring M_BTCL;
extern const fcml_cstring M_BTCQ;
extern const fcml_cstring M_BTCW;
extern const fcml_cstring M_BTL;
extern const fcml_cstring M_BTQ;
extern const fcml_cstring M_BTR;
extern const fcml_cstring M_BTRL;
extern const fcml_cstring M_BTRQ;
extern const fcml_cstring M_BTRW;
extern const fcml_cstring M_BTS;
extern const fcml_cstring M_BTSL;
extern const fcml_cstring M_BTSQ;
extern const fcml_cstring M_BTSW;
extern const fcml_cstring M_BTW;
extern const fcml_cstring M_BZHI;
extern const fcml_cstring M_CALL;
extern const fcml_cstring M_CALLQ;
extern const fcml_cstring M_CALLW;
extern const fcml_cstring M_CBTW;
extern const fcml_cstring M_CLAC;
extern const fcml_cstring M_CLC;
extern const fcml_cstring M_CLD;
extern const fcml_cstring M_CLFLUSH;
extern const fcml_cstring M_CLGI;
extern const fcml_cstring M_CLI;
extern const fcml_cstring M_CLTD;
extern const fcml_cstring M_CLTQ;
extern const fcml_cstring M_CLTS;
extern const fcml_cstring M_CMC;
extern const fcml_cstring M_CMOVA;
extern const fcml_cstring M_CMOVAE;
extern const fcml_cstring M_CMOVB;
extern const fcml_cstring M_CMOVBE;
extern const fcml_cstring M_CMOVC;
extern const fcml_cstring M_CMOVENE;
extern const fcml_cstring M_CMOVG;
extern const fcml_cstring M_CMOVGE;
extern const fcml_cstring M_CMOVL;
extern const fcml_cstring M_CMOVLE;
extern const fcml_cstring M_CMOVNA;
extern const fcml_cstring M_CMOVNAE;
extern const fcml_cstring M_CMOVNB;
extern const fcml_cstring M_CMOVNBE;
extern const fcml_cstring M_CMOVNC;
extern const fcml_cstring M_CMOVNG;
extern const fcml_cstring M_CMOVNGE;
extern const fcml_cstring M_CMOVNL;
extern const fcml_cstring M_CMOVNLE;
extern const fcml_cstring M_CMOVNO;
extern const fcml_cstring M_CMOVNP;
extern const fcml_cstring M_CMOVNS;
extern const fcml_cstring M_CMOVNZ;
extern const fcml_cstring M_CMOVO;
extern const fcml_cstring M_CMOVP;
extern const fcml_cstring M_CMOVPE;
extern const fcml_cstring M_CMOVPO;
extern const fcml_cstring M_CMOVS;
extern const fcml_cstring M_CMOVZ;
extern const fcml_cstring M_CMP;
extern const fcml_cstring M_CMPB;
extern const fcml_cstring M_CMPEQPD;
extern const fcml_cstring M_CMPEQPS;
extern const fcml_cstring M_CMPEQSD;
extern const fcml_cstring M_CMPEQSS;
extern const fcml_cstring M_CMPL;
extern const fcml_cstring M_CMPLEPD;
extern const fcml_cstring M_CMPLEPS;
extern const fcml_cstring M_CMPLESD;
extern const fcml_cstring M_CMPLESS;
extern const fcml_cstring M_CMPLTPD;
extern const fcml_cstring M_CMPLTPS;
extern const fcml_cstring M_CMPLTSD;
extern const fcml_cstring M_CMPLTSS;
extern const fcml_cstring M_CMPNEQPD;
extern const fcml_cstring M_CMPNEQPS;
extern const fcml_cstring M_CMPNEQSD;
extern const fcml_cstring M_CMPNEQSS;
extern const fcml_cstring M_CMPNLEPD;
extern const fcml_cstring M_CMPNLEPS;
extern const fcml_cstring M_CMPNLESD;
extern const fcml_cstring M_CMPNLESS;
extern const fcml_cstring M_CMPNLTPD;
extern const fcml_cstring M_CMPNLTPS;
extern const fcml_cstring M_CMPNLTSD;
extern const fcml_cstring M_CMPNLTSS;
extern const fcml_cstring M_CMPORDPD;
extern const fcml_cstring M_CMPORDPS;
extern const fcml_cstring M_CMPORDSD;
extern const fcml_cstring M_CMPORDSS;
extern const fcml_cstring M_CMPPD;
extern const fcml_cstring M_CMPPS;
extern const fcml_cstring M_CMPQ;
extern const fcml_cstring M_CMPSB;
extern const fcml_cstring M_CMPSD;
extern const fcml_cstring M_CMPSL;
extern const fcml_cstring M_CMPSQ;
extern const fcml_cstring M_CMPSS;
extern const fcml_cstring M_CMPSW;
extern const fcml_cstring M_CMPUNORDPD;
extern const fcml_cstring M_CMPUNORDPS;
extern const fcml_cstring M_CMPUNORDSD;
extern const fcml_cstring M_CMPUNORDSS;
extern const fcml_cstring M_CMPW;
extern const fcml_cstring M_CMPXCHG;
extern const fcml_cstring M_CMPXCHG16B;
extern const fcml_cstring M_CMPXCHG8B;
extern const fcml_cstring M_COMISD;
extern const fcml_cstring M_COMISS;
extern const fcml_cstring M_CPUID;
extern const fcml_cstring M_CQTO;
extern const fcml_cstring M_CRC32B;
extern const fcml_cstring M_CRC32L;
extern const fcml_cstring M_CRC32Q;
extern const fcml_cstring M_CRC32W;
extern const fcml_cstring M_CVTDQ2PD;
extern const fcml_cstring M_CVTDQ2PS;
extern const fcml_cstring M_CVTPD2DQ;
extern const fcml_cstring M_CVTPD2PI;
extern const fcml_cstring M_CVTPD2PS;
extern const fcml_cstring M_CVTPI2PD;
extern const fcml_cstring M_CVTPI2PS;
extern const fcml_cstring M_CVTPS2DQ;
extern const fcml_cstring M_CVTPS2PD;
extern const fcml_cstring M_CVTPS2PI;
extern const fcml_cstring M_CVTSD2SI;
extern const fcml_cstring M_CVTSD2SS;
extern const fcml_cstring M_CVTSI2SDL;
extern const fcml_cstring M_CVTSI2SDQ;
extern const fcml_cstring M_CVTSI2SSL;
extern const fcml_cstring M_CVTSI2SSQ;
extern const fcml_cstring M_CVTSS2SD;
extern const fcml_cstring M_CVTSS2SI;
extern const fcml_cstring M_CVTTPD2DQ;
extern const fcml_cstring M_CVTTPD2PI;
extern const fcml_cstring M_CVTTPS2DQ;
extern const fcml_cstring M_CVTTPS2PI;
extern const fcml_cstring M_CVTTSD2SI;
extern const fcml_cstring M_CVTTSS2SI;
extern const fcml_cstring M_CWTD;
extern const fcml_cstring M_CWTL;
extern const fcml_cstring M_DAA;
extern const fcml_cstring M_DAS;
extern const fcml_cstring M_DEC;
extern const fcml_cstring M_DECB;
extern const fcml_cstring M_DECL;
extern const fcml_cstring M_DECQ;
extern const fcml_cstring M_DECW;
extern const fcml_cstring M_DIV;
extern const fcml_cstring M_DIVB;
extern const fcml_cstring M_DIVL;
extern const fcml_cstring M_DIVPD;
extern const fcml_cstring M_DIVPS;
extern const fcml_cstring M_DIVQ;
extern const fcml_cstring M_DIVSD;
extern const fcml_cstring M_DIVSS;
extern const fcml_cstring M_DIVW;
extern const fcml_cstring M_DPPD;
extern const fcml_cstring M_DPPS;
extern const fcml_cstring M_EMMS;
extern const fcml_cstring M_ENTER;
extern const fcml_cstring M_ENTERQ;
extern const fcml_cstring M_EXTRACTPS;
extern const fcml_cstring M_EXTRQ;
extern const fcml_cstring M_F2XM1;
extern const fcml_cstring M_FABS;
extern const fcml_cstring M_FADD;
extern const fcml_cstring M_FADDL;
extern const fcml_cstring M_FADDP;
extern const fcml_cstring M_FADDS;
extern const fcml_cstring M_FBLD;
extern const fcml_cstring M_FBSTP;
extern const fcml_cstring M_FCHS;
extern const fcml_cstring M_FCLEX;
extern const fcml_cstring M_FCMOVB;
extern const fcml_cstring M_FCMOVBE;
extern const fcml_cstring M_FCMOVE;
extern const fcml_cstring M_FCMOVNB;
extern const fcml_cstring M_FCMOVNBE;
extern const fcml_cstring M_FCMOVNE;
extern const fcml_cstring M_FCMOVNU;
extern const fcml_cstring M_FCMOVU;
extern const fcml_cstring M_FCOM;
extern const fcml_cstring M_FCOMI;
extern const fcml_cstring M_FCOMIP;
extern const fcml_cstring M_FCOML;
extern const fcml_cstring M_FCOMP;
extern const fcml_cstring M_FCOMPL;
extern const fcml_cstring M_FCOMPP;
extern const fcml_cstring M_FCOMPS;
extern const fcml_cstring M_FCOMS;
extern const fcml_cstring M_FCOS;
extern const fcml_cstring M_FDECSTP;
extern const fcml_cstring M_FDIV;
extern const fcml_cstring M_FDIVL;
extern const fcml_cstring M_FDIVP;
extern const fcml_cstring M_FDIVR;
extern const fcml_cstring M_FDIVRL;
extern const fcml_cstring M_FDIVRP;
extern const fcml_cstring M_FDIVRS;
extern const fcml_cstring M_FDIVS;
extern const fcml_cstring M_FEMMS;
extern const fcml_cstring M_FFREE;
extern const fcml_cstring M_FIADD;
extern const fcml_cstring M_FIADDL;
extern const fcml_cstring M_FICOM;
extern const fcml_cstring M_FICOML;
extern const fcml_cstring M_FICOMP;
extern const fcml_cstring M_FICOMPL;
extern const fcml_cstring M_FIDIV;
extern const fcml_cstring M_FIDIVL;
extern const fcml_cstring M_FIDIVR;
extern const fcml_cstring M_FIDIVRL;
extern const fcml_cstring M_FILD;
extern const fcml_cstring M_FILDL;
extern const fcml_cstring M_FILDLL;
extern const fcml_cstring M_FIMUL;
extern const fcml_cstring M_FIMULL;
extern const fcml_cstring M_FINCSTP;
extern const fcml_cstring M_FINIT;
extern const fcml_cstring M_FIST;
extern const fcml_cstring M_FISTL;
extern const fcml_cstring M_FISTP;
extern const fcml_cstring M_FISTPL;
extern const fcml_cstring M_FISTPLL;
extern const fcml_cstring M_FISTTP;
extern const fcml_cstring M_FISTTPL;
extern const fcml_cstring M_FISTTPLL;
extern const fcml_cstring M_FISUB;
extern const fcml_cstring M_FISUBL;
extern const fcml_cstring M_FISUBR;
extern const fcml_cstring M_FISUBRL;
extern const fcml_cstring M_FLD;
extern const fcml_cstring M_FLD1;
extern const fcml_cstring M_FLDCW;
extern const fcml_cstring M_FLDENV;
extern const fcml_cstring M_FLDENVS;
extern const fcml_cstring M_FLDL;
extern const fcml_cstring M_FLDL2E;
extern const fcml_cstring M_FLDL2T;
extern const fcml_cstring M_FLDLG2;
extern const fcml_cstring M_FLDLN2;
extern const fcml_cstring M_FLDPI;
extern const fcml_cstring M_FLDS;
extern const fcml_cstring M_FLDT;
extern const fcml_cstring M_FLDZ;
extern const fcml_cstring M_FMUL;
extern const fcml_cstring M_FMULL;
extern const fcml_cstring M_FMULP;
extern const fcml_cstring M_FMULS;
extern const fcml_cstring M_FNCLEX;
extern const fcml_cstring M_FNINIT;
extern const fcml_cstring M_FNOP;
extern const fcml_cstring M_FNSAVE;
extern const fcml_cstring M_FNSAVES;
extern const fcml_cstring M_FNSTCW;
extern const fcml_cstring M_FNSTENV;
extern const fcml_cstring M_FNSTENVS;
extern const fcml_cstring M_FNSTSW;
extern const fcml_cstring M_FPATAN;
extern const fcml_cstring M_FPREM;
extern const fcml_cstring M_FPREM1;
extern const fcml_cstring M_FPTAN;
extern const fcml_cstring M_FRNDINT;
extern const fcml_cstring M_FRSTOR;
extern const fcml_cstring M_FRSTORS;
extern const fcml_cstring M_FSAVE;
extern const fcml_cstring M_FSAVES;
extern const fcml_cstring M_FSCALE;
extern const fcml_cstring M_FSIN;
extern const fcml_cstring M_FSINCOS;
extern const fcml_cstring M_FSQRT;
extern const fcml_cstring M_FST;
extern const fcml_cstring M_FSTCW;
extern const fcml_cstring M_FSTENV;
extern const fcml_cstring M_FSTENVS;
extern const fcml_cstring M_FSTL;
extern const fcml_cstring M_FSTP;
extern const fcml_cstring M_FSTPL;
extern const fcml_cstring M_FSTPS;
extern const fcml_cstring M_FSTPT;
extern const fcml_cstring M_FSTS;
extern const fcml_cstring M_FSTSW;
extern const fcml_cstring M_FSUB;
extern const fcml_cstring M_FSUBL;
extern const fcml_cstring M_FSUBP;
extern const fcml_cstring M_FSUBR;
extern const fcml_cstring M_FSUBRL;
extern const fcml_cstring M_FSUBRP;
extern const fcml_cstring M_FSUBRS;
extern const fcml_cstring M_FSUBS;
extern const fcml_cstring M_FTST;
extern const fcml_cstring M_FUCOM;
extern const fcml_cstring M_FUCOMI;
extern const fcml_cstring M_FUCOMIP;
extern const fcml_cstring M_FUCOMP;
extern const fcml_cstring M_FUCOMPP;
extern const fcml_cstring M_FWAIT;
extern const fcml_cstring M_FXAM;
extern const fcml_cstring M_FXCH;
extern const fcml_cstring M_FXRSTOR;
extern const fcml_cstring M_FXRSTOR64;
extern const fcml_cstring M_FXSAVE;
extern const fcml_cstring M_FXSAVE64;
extern const fcml_cstring M_FXTRACT;
extern const fcml_cstring M_FYL2X;
extern const fcml_cstring M_FYL2XP1;
extern const fcml_cstring M_GETSEC;
extern const fcml_cstring M_HADDPD;
extern const fcml_cstring M_HADDPS;
extern const fcml_cstring M_HLT;
extern const fcml_cstring M_HSUBPD;
extern const fcml_cstring M_HSUBPS;
extern const fcml_cstring M_IDIV;
extern const fcml_cstring M_IDIVB;
extern const fcml_cstring M_IDIVL;
extern const fcml_cstring M_IDIVQ;
extern const fcml_cstring M_IDIVW;
extern const fcml_cstring M_IMUL;
extern const fcml_cstring M_IMULB;
extern const fcml_cstring M_IMULL;
extern const fcml_cstring M_IMULQ;
extern const fcml_cstring M_IMULW;
extern const fcml_cstring M_IN;
extern const fcml_cstring M_INC;
extern const fcml_cstring M_INCB;
extern const fcml_cstring M_INCL;
extern const fcml_cstring M_INCQ;
extern const fcml_cstring M_INCW;
extern const fcml_cstring M_INSB;
extern const fcml_cstring M_INSERTPS;
extern const fcml_cstring M_INSERTQ;
extern const fcml_cstring M_INSL;
extern const fcml_cstring M_INSW;
extern const fcml_cstring M_INT;
extern const fcml_cstring M_INT3;
extern const fcml_cstring M_INTO;
extern const fcml_cstring M_INVD;
extern const fcml_cstring M_INVEPT;
extern const fcml_cstring M_INVLPG;
extern const fcml_cstring M_INVLPGA;
extern const fcml_cstring M_INVPCID;
extern const fcml_cstring M_INVVPID;
extern const fcml_cstring M_IRET;
extern const fcml_cstring M_IRETQ;
extern const fcml_cstring M_IRETW;
extern const fcml_cstring M_JA;
extern const fcml_cstring M_JAE;
extern const fcml_cstring M_JB;
extern const fcml_cstring M_JBE;
extern const fcml_cstring M_JC;
extern const fcml_cstring M_JCXZ;
extern const fcml_cstring M_JECXZ;
extern const fcml_cstring M_JENE;
extern const fcml_cstring M_JG;
extern const fcml_cstring M_JGE;
extern const fcml_cstring M_JL;
extern const fcml_cstring M_JLE;
extern const fcml_cstring M_JMP;
extern const fcml_cstring M_JMPQ;
extern const fcml_cstring M_JMPW;
extern const fcml_cstring M_JNA;
extern const fcml_cstring M_JNAE;
extern const fcml_cstring M_JNB;
extern const fcml_cstring M_JNBE;
extern const fcml_cstring M_JNC;
extern const fcml_cstring M_JNG;
extern const fcml_cstring M_JNGE;
extern const fcml_cstring M_JNL;
extern const fcml_cstring M_JNLE;
extern const fcml_cstring M_JNO;
extern const fcml_cstring M_JNP;
extern const fcml_cstring M_JNS;
extern const fcml_cstring M_JNZ;
extern const fcml_cstring M_JO;
extern const fcml_cstring M_JP;
extern const fcml_cstring M_JPE;
extern const fcml_cstring M_JPO;
extern const fcml_cstring M_JRCXZ;
extern const fcml_cstring M_JS;
extern const fcml_cstring M_JZ;
extern const fcml_cstring M_KADDB;
extern const fcml_cstring M_KADDD;
extern const fcml_cstring M_KADDQ;
extern const fcml_cstring M_KADDW;
extern const fcml_cstring M_KANDB;
extern const fcml_cstring M_KANDD;
extern const fcml_cstring M_KANDNB;
extern const fcml_cstring M_KANDND;
extern const fcml_cstring M_KANDNQ;
extern const fcml_cstring M_KANDNW;
extern const fcml_cstring M_KANDQ;
extern const fcml_cstring M_KANDW;
extern const fcml_cstring M_KMOVB;
extern const fcml_cstring M_KMOVD;
extern const fcml_cstring M_KMOVQ;
extern const fcml_cstring M_KMOVW;
extern const fcml_cstring M_KNOTB;
extern const fcml_cstring M_KNOTD;
extern const fcml_cstring M_KNOTQ;
extern const fcml_cstring M_KNOTW;
extern const fcml_cstring M_KORB;
extern const fcml_cstring M_KORD;
extern const fcml_cstring M_KORQ;
extern const fcml_cstring M_KORTESTB;
extern const fcml_cstring M_KORTESTD;
extern const fcml_cstring M_KORTESTQ;
extern const fcml_cstring M_KORTESTW;
extern const fcml_cstring M_KORW;
extern const fcml_cstring M_KSHIFTLB;
extern const fcml_cstring M_KSHIFTLD;
extern const fcml_cstring M_KSHIFTLQ;
extern const fcml_cstring M_KSHIFTLW;
extern const fcml_cstring M_KSHIFTRB;
extern const fcml_cstring M_KSHIFTRD;
extern const fcml_cstring M_KSHIFTRQ;
extern const fcml_cstring M_KSHIFTRW;
extern const fcml_cstring M_KTESTB;
extern const fcml_cstring M_KTESTD;
extern const fcml_cstring M_KTESTQ;
extern const fcml_cstring M_KTESTW;
extern const fcml_cstring M_KXNORB;
extern const fcml_cstring M_KXNORD;
extern const fcml_cstring M_KXNORQ;
extern const fcml_cstring M_KXNORW;
extern const fcml_cstring M_KXORB;
extern const fcml_cstring M_KXORD;
extern const fcml_cstring M_KXORQ;
extern const fcml_cstring M_KXORW;
extern const fcml_cstring M_LAHF;
extern const fcml_cstring M_LAR;
extern const fcml_cstring M_LCALL;
extern const fcml_cstring M_LCALLQ;
extern const fcml_cstring M_LCALLW;
extern const fcml_cstring M_LDDQU;
extern const fcml_cstring M_LDMXCSR;
extern const fcml_cstring M_LDS;
extern const fcml_cstring M_LEA;
extern const fcml_cstring M_LEAVE;
extern const fcml_cstring M_LES;
extern const fcml_cstring M_LFENCE;
extern const fcml_cstring M_LFS;
extern const fcml_cstring M_LGDT;
extern const fcml_cstring M_LGS;
extern const fcml_cstring M_LIDT;
extern const fcml_cstring M_LJMP;
extern const fcml_cstring M_LJMPL;
extern const fcml_cstring M_LJMPQ;
extern const fcml_cstring M_LJMPW;
extern const fcml_cstring M_LLDT;
extern const fcml_cstring M_LLWPCB;
extern const fcml_cstring M_LMSW;
extern const fcml_cstring M_LODS;
extern const fcml_cstring M_LODSB;
extern const fcml_cstring M_LODSL;
extern const fcml_cstring M_LODSQ;
extern const fcml_cstring M_LODSW;
extern const fcml_cstring M_LOOP;
extern const fcml_cstring M_LOOPE;
extern const fcml_cstring M_LOOPNE;
extern const fcml_cstring M_LOOPNZ;
extern const fcml_cstring M_LOOPZ;
extern const fcml_cstring M_LRET;
extern const fcml_cstring M_LRETQ;
extern const fcml_cstring M_LRETW;
extern const fcml_cstring M_LSL;
extern const fcml_cstring M_LSS;
extern const fcml_cstring M_LTR;
extern const fcml_cstring M_LWPINS;
extern const fcml_cstring M_LWPVAL;
extern const fcml_cstring M_LZCNT;
extern const fcml_cstring M_MASKMOVDQU;
extern const fcml_cstring M_MASKMOVQ;
extern const fcml_cstring M_MAXPD;
extern const fcml_cstring M_MAXPS;
extern const fcml_cstring M_MAXSD;
extern const fcml_cstring M_MAXSS;
extern const fcml_cstring M_MFENCE;
extern const fcml_cstring M_MINPD;
extern const fcml_cstring M_MINPS;
extern const fcml_cstring M_MINSD;
extern const fcml_cstring M_MINSS;
extern const fcml_cstring M_MONITOR;
extern const fcml_cstring M_MOV;
extern const fcml_cstring M_MOVABS;
extern const fcml_cstring M_MOVAPD;
extern const fcml_cstring M_MOVAPS;
extern const fcml_cstring M_MOVB;
extern const fcml_cstring M_MOVBE;
extern const fcml_cstring M_MOVD;
extern const fcml_cstring M_MOVDDUP;
extern const fcml_cstring M_MOVDQ2Q;
extern const fcml_cstring M_MOVDQA;
extern const fcml_cstring M_MOVDQU;
extern const fcml_cstring M_MOVHLPS;
extern const fcml_cstring M_MOVHPD;
extern const fcml_cstring M_MOVHPS;
extern const fcml_cstring M_MOVL;
extern const fcml_cstring M_MOVLHPS;
extern const fcml_cstring M_MOVLPD;
extern const fcml_cstring M_MOVLPS;
extern const fcml_cstring M_MOVMSKPD;
extern const fcml_cstring M_MOVMSKPS;
extern const fcml_cstring M_MOVNTDQ;
extern const fcml_cstring M_MOVNTDQA;
extern const fcml_cstring M_MOVNTI;
extern const fcml_cstring M_MOVNTPD;
extern const fcml_cstring M_MOVNTPS;
extern const fcml_cstring M_MOVNTQ;
extern const fcml_cstring M_MOVNTSD;
extern const fcml_cstring M_MOVNTSS;
extern const fcml_cstring M_MOVQ;
extern const fcml_cstring M_MOVQ2DQ;
extern const fcml_cstring M_MOVS;
extern const fcml_cstring M_MOVSB;
extern const fcml_cstring M_MOVSBL;
extern const fcml_cstring M_MOVSBQ;
extern const fcml_cstring M_MOVSBW;
extern const fcml_cstring M_MOVSD;
extern const fcml_cstring M_MOVSHDUP;
extern const fcml_cstring M_MOVSL;
extern const fcml_cstring M_MOVSLDUP;
extern const fcml_cstring M_MOVSQ;
extern const fcml_cstring M_MOVSS;
extern const fcml_cstring M_MOVSW;
extern const fcml_cstring M_MOVSWL;
extern const fcml_cstring M_MOVSWQ;
extern const fcml_cstring M_MOVSWW;
extern const fcml_cstring M_MOVSXD;
extern const fcml_cstring M_MOVUPD;
extern const fcml_cstring M_MOVUPS;
extern const fcml_cstring M_MOVW;
extern const fcml_cstring M_MOVZBL;
extern const fcml_cstring M_MOVZBQ;
extern const fcml_cstring M_MOVZBW;
extern const fcml_cstring M_MOVZWL;
extern const fcml_cstring M_MOVZWQ;
extern const fcml_cstring M_MOVZWW;
extern const fcml_cstring M_MPSADBW;
extern const fcml_cstring M_MUL;
extern const fcml_cstring M_MULB;
extern const fcml_cstring M_MULL;
extern const fcml_cstring M_MULPD;
extern const fcml_cstring M_MULPS;
extern const fcml_cstring M_MULQ;
extern const fcml_cstring M_MULSD;
extern const fcml_cstring M_MULSS;
extern const fcml_cstring M_MULW;
extern const fcml_cstring M_MULX;
extern const fcml_cstring M_MWAIT;
extern const fcml_cstring M_NEG;
extern const fcml_cstring M_NEGB;
extern const fcml_cstring M_NEGL;
extern const fcml_cstring M_NEGQ;
extern const fcml_cstring M_NEGW;
extern const fcml_cstring M_NOP;
extern const fcml_cstring M_NOPL;
extern const fcml_cstring M_NOPQ;
extern const fcml_cstring M_NOPW;
extern const fcml_cstring M_NOT;
extern const fcml_cstring M_NOTB;
extern const fcml_cstring M_NOTL;
extern const fcml_cstring M_NOTQ;
extern const fcml_cstring M_NOTW;
extern const fcml_cstring M_OR;
extern const fcml_cstring M_ORB;
extern const fcml_cstring M_ORL;
extern const fcml_cstring M_ORPD;
extern const fcml_cstring M_ORPS;
extern const fcml_cstring M_ORQ;
extern const fcml_cstring M_ORW;
extern const fcml_cstring M_OUT;
extern const fcml_cstring M_OUTSB;
extern const fcml_cstring M_OUTSL;
extern const fcml_cstring M_OUTSW;
extern const fcml_cstring M_PABSB;
extern const fcml_cstring M_PABSD;
extern const fcml_cstring M_PABSW;
extern const fcml_cstring M_PACKSSDW;
extern const fcml_cstring M_PACKSSWB;
extern const fcml_cstring M_PACKUSDW;
extern const fcml_cstring M_PACKUSWB;
extern const fcml_cstring M_PADDB;
extern const fcml_cstring M_PADDD;
extern const fcml_cstring M_PADDQ;
extern const fcml_cstring M_PADDSB;
extern const fcml_cstring M_PADDSW;
extern const fcml_cstring M_PADDUSB;
extern const fcml_cstring M_PADDUSW;
extern const fcml_cstring M_PADDW;
extern const fcml_cstring M_PALIGNR;
extern const fcml_cstring M_PAND;
extern const fcml_cstring M_PANDN;
extern const fcml_cstring M_PAUSE;
extern const fcml_cstring M_PAVGB;
extern const fcml_cstring M_PAVGUSB;
extern const fcml_cstring M_PAVGW;
extern const fcml_cstring M_PBLENDVB;
extern const fcml_cstring M_PBLENDW;
extern const fcml_cstring M_PCLMULQDQ;
extern const fcml_cstring M_PCMPEQB;
extern const fcml_cstring M_PCMPEQD;
extern const fcml_cstring M_PCMPEQQ;
extern const fcml_cstring M_PCMPEQW;
extern const fcml_cstring M_PCMPESTRI;
extern const fcml_cstring M_PCMPESTRM;
extern const fcml_cstring M_PCMPGTB;
extern const fcml_cstring M_PCMPGTD;
extern const fcml_cstring M_PCMPGTQ;
extern const fcml_cstring M_PCMPGTW;
extern const fcml_cstring M_PCMPISTRI;
extern const fcml_cstring M_PCMPISTRM;
extern const fcml_cstring M_PDEP;
extern const fcml_cstring M_PEXT;
extern const fcml_cstring M_PEXTRB;
extern const fcml_cstring M_PEXTRD;
extern const fcml_cstring M_PEXTRQ;
extern const fcml_cstring M_PEXTRW;
extern const fcml_cstring M_PF2ID;
extern const fcml_cstring M_PF2IW;
extern const fcml_cstring M_PFACC;
extern const fcml_cstring M_PFADD;
extern const fcml_cstring M_PFCMPEQ;
extern const fcml_cstring M_PFCMPGE;
extern const fcml_cstring M_PFCMPGT;
extern const fcml_cstring M_PFMAX;
extern const fcml_cstring M_PFMIN;
extern const fcml_cstring M_PFMUL;
extern const fcml_cstring M_PFNACC;
extern const fcml_cstring M_PFPNACC;
extern const fcml_cstring M_PFRCP;
extern const fcml_cstring M_PFRCPIT1;
extern const fcml_cstring M_PFRCPIT2;
extern const fcml_cstring M_PFRSQIT1;
extern const fcml_cstring M_PFRSQRT;
extern const fcml_cstring M_PFSUB;
extern const fcml_cstring M_PFSUBR;
extern const fcml_cstring M_PHADDD;
extern const fcml_cstring M_PHADDSW;
extern const fcml_cstring M_PHADDW;
extern const fcml_cstring M_PHMINPOSUW;
extern const fcml_cstring M_PHSUBD;
extern const fcml_cstring M_PHSUBSW;
extern const fcml_cstring M_PHSUBW;
extern const fcml_cstring M_PI2FD;
extern const fcml_cstring M_PI2FW;
extern const fcml_cstring M_PINSRB;
extern const fcml_cstring M_PINSRD;
extern const fcml_cstring M_PINSRQ;
extern const fcml_cstring M_PINSRW;
extern const fcml_cstring M_PMADDUBSW;
extern const fcml_cstring M_PMADDWD;
extern const fcml_cstring M_PMAXSB;
extern const fcml_cstring M_PMAXSD;
extern const fcml_cstring M_PMAXSW;
extern const fcml_cstring M_PMAXUB;
extern const fcml_cstring M_PMAXUD;
extern const fcml_cstring M_PMAXUW;
extern const fcml_cstring M_PMINSB;
extern const fcml_cstring M_PMINSD;
extern const fcml_cstring M_PMINSW;
extern const fcml_cstring M_PMINUB;
extern const fcml_cstring M_PMINUD;
extern const fcml_cstring M_PMINUW;
extern const fcml_cstring M_PMOVMSKB;
extern const fcml_cstring M_PMOVSXBD;
extern const fcml_cstring M_PMOVSXBQ;
extern const fcml_cstring M_PMOVSXBW;
extern const fcml_cstring M_PMOVSXDQ;
extern const fcml_cstring M_PMOVSXWD;
extern const fcml_cstring M_PMOVSXWQ;
extern const fcml_cstring M_PMOVZXBD;
extern const fcml_cstring M_PMOVZXBQ;
extern const fcml_cstring M_PMOVZXBW;
extern const fcml_cstring M_PMOVZXDQ;
extern const fcml_cstring M_PMOVZXWD;
extern const fcml_cstring M_PMOVZXWQ;
extern const fcml_cstring M_PMULDQ;
extern const fcml_cstring M_PMULHRSW;
extern const fcml_cstring M_PMULHRW;
extern const fcml_cstring M_PMULHUW;
extern const fcml_cstring M_PMULHW;
extern const fcml_cstring M_PMULLD;
extern const fcml_cstring M_PMULLW;
extern const fcml_cstring M_PMULUDQ;
extern const fcml_cstring M_POP;
extern const fcml_cstring M_POPA;
extern const fcml_cstring M_POPAW;
extern const fcml_cstring M_POPCNT;
extern const fcml_cstring M_POPF;
extern const fcml_cstring M_POPFQ;
extern const fcml_cstring M_POPFW;
extern const fcml_cstring M_POPL;
extern const fcml_cstring M_POPQ;
extern const fcml_cstring M_POPW;
extern const fcml_cstring M_POR;
extern const fcml_cstring M_PREFETCH;
extern const fcml_cstring M_PREFETCHNTA;
extern const fcml_cstring M_PREFETCHT0;
extern const fcml_cstring M_PREFETCHT1;
extern const fcml_cstring M_PREFETCHT2;
extern const fcml_cstring M_PREFETCHW;
extern const fcml_cstring M_PREFETCHWT1;
extern const fcml_cstring M_PSADBW;
extern const fcml_cstring M_PSHUFB;
extern const fcml_cstring M_PSHUFD;
extern const fcml_cstring M_PSHUFHW;
extern const fcml_cstring M_PSHUFLW;
extern const fcml_cstring M_PSHUFW;
extern const fcml_cstring M_PSIGNB;
extern const fcml_cstring M_PSIGND;
extern const fcml_cstring M_PSIGNW;
extern const fcml_cstring M_PSLLD;
extern const fcml_cstring M_PSLLDQ;
extern const fcml_cstring M_PSLLQ;
extern const fcml_cstring M_PSLLW;
extern const fcml_cstring M_PSRAD;
extern const fcml_cstring M_PSRAW;
extern const fcml_cstring M_PSRLD;
extern const fcml_cstring M_PSRLDQ;
extern const fcml_cstring M_PSRLQ;
extern const fcml_cstring M_PSRLW;
extern const fcml_cstring M_PSUBB;
extern const fcml_cstring M_PSUBD;
extern const fcml_cstring M_PSUBQ;
extern const fcml_cstring M_PSUBSB;
extern const fcml_cstring M_PSUBSW;
extern const fcml_cstring M_PSUBUSB;
extern const fcml_cstring M_PSUBUSW;
extern const fcml_cstring M_PSUBW;
extern const fcml_cstring M_PSWAPD;
extern const fcml_cstring M_PTEST;
extern const fcml_cstring M_PUNPCKHBW;
extern const fcml_cstring M_PUNPCKHDQ;
extern const fcml_cstring M_PUNPCKHQDQ;
extern const fcml_cstring M_PUNPCKHWD;
extern const fcml_cstring M_PUNPCKLBW;
extern const fcml_cstring M_PUNPCKLDQ;
extern const fcml_cstring M_PUNPCKLQDQ;
extern const fcml_cstring M_PUNPCKLWD;
extern const fcml_cstring M_PUSH;
extern const fcml_cstring M_PUSHA;
extern const fcml_cstring M_PUSHAW;
extern const fcml_cstring M_PUSHB;
extern const fcml_cstring M_PUSHF;
extern const fcml_cstring M_PUSHFQ;
extern const fcml_cstring M_PUSHFW;
extern const fcml_cstring M_PUSHL;
extern const fcml_cstring M_PUSHQ;
extern const fcml_cstring M_PUSHW;
extern const fcml_cstring M_PXOR;
extern const fcml_cstring M_RCL;
extern const fcml_cstring M_RCLB;
extern const fcml_cstring M_RCLL;
extern const fcml_cstring M_RCLQ;
extern const fcml_cstring M_RCLW;
extern const fcml_cstring M_RCPPS;
extern const fcml_cstring M_RCPSS;
extern const fcml_cstring M_RCR;
extern const fcml_cstring M_RCRB;
extern const fcml_cstring M_RCRL;
extern const fcml_cstring M_RCRQ;
extern const fcml_cstring M_RCRW;
extern const fcml_cstring M_RDFSBASE;
extern const fcml_cstring M_RDGSBASE;
extern const fcml_cstring M_RDMSR;
extern const fcml_cstring M_RDPMC;
extern const fcml_cstring M_RDRAND;
extern const fcml_cstring M_RDSEED;
extern const fcml_cstring M_RDTSC;
extern const fcml_cstring M_RDTSCP;
extern const fcml_cstring M_RET;
extern const fcml_cstring M_RETQ;
extern const fcml_cstring M_RETW;
extern const fcml_cstring M_ROL;
extern const fcml_cstring M_ROLB;
extern const fcml_cstring M_ROLL;
extern const fcml_cstring M_ROLQ;
extern const fcml_cstring M_ROLW;
extern const fcml_cstring M_ROR;
extern const fcml_cstring M_RORB;
extern const fcml_cstring M_RORL;
extern const fcml_cstring M_RORQ;
extern const fcml_cstring M_RORW;
extern const fcml_cstring M_RORX;
extern const fcml_cstring M_ROUNDPD;
extern const fcml_cstring M_ROUNDPS;
extern const fcml_cstring M_ROUNDSD;
extern const fcml_cstring M_ROUNDSS;
extern const fcml_cstring M_RSM;
extern const fcml_cstring M_RSQRTPS;
extern const fcml_cstring M_RSQRTSS;
extern const fcml_cstring M_SAHF;
extern const fcml_cstring M_SAL;
extern const fcml_cstring M_SALB;
extern const fcml_cstring M_SALL;
extern const fcml_cstring M_SALQ;
extern const fcml_cstring M_SALW;
extern const fcml_cstring M_SAR;
extern const fcml_cstring M_SARB;
extern const fcml_cstring M_SARL;
extern const fcml_cstring M_SARQ;
extern const fcml_cstring M_SARW;
extern const fcml_cstring M_SARX;
extern const fcml_cstring M_SBB;
extern const fcml_cstring M_SBBB;
extern const fcml_cstring M_SBBL;
extern const fcml_cstring M_SBBQ;
extern const fcml_cstring M_SBBW;
extern const fcml_cstring M_SCAS;
extern const fcml_cstring M_SCASB;
extern const fcml_cstring M_SCASL;
extern const fcml_cstring M_SCASQ;
extern const fcml_cstring M_SCASW;
extern const fcml_cstring M_SETA;
extern const fcml_cstring M_SETAE;
extern const fcml_cstring M_SETB;
extern const fcml_cstring M_SETBE;
extern const fcml_cstring M_SETC;
extern const fcml_cstring M_SETENE;
extern const fcml_cstring M_SETG;
extern const fcml_cstring M_SETGE;
extern const fcml_cstring M_SETL;
extern const fcml_cstring M_SETLE;
extern const fcml_cstring M_SETNA;
extern const fcml_cstring M_SETNAE;
extern const fcml_cstring M_SETNB;
extern const fcml_cstring M_SETNBE;
extern const fcml_cstring M_SETNC;
extern const fcml_cstring M_SETNG;
extern const fcml_cstring M_SETNGE;
extern const fcml_cstring M_SETNL;
extern const fcml_cstring M_SETNLE;
extern const fcml_cstring M_SETNO;
extern const fcml_cstring M_SETNP;
extern const fcml_cstring M_SETNS;
extern const fcml_cstring M_SETNZ;
extern const fcml_cstring M_SETO;
extern const fcml_cstring M_SETP;
extern const fcml_cstring M_SETPE;
extern const fcml_cstring M_SETPO;
extern const fcml_cstring M_SETS;
extern const fcml_cstring M_SETZ;
extern const fcml_cstring M_SFENCE;
extern const fcml_cstring M_SGDT;
extern const fcml_cstring M_SHL;
extern const fcml_cstring M_SHLB;
extern const fcml_cstring M_SHLD;
extern const fcml_cstring M_SHLL;
extern const fcml_cstring M_SHLQ;
extern const fcml_cstring M_SHLW;
extern const fcml_cstring M_SHLX;
extern const fcml_cstring M_SHR;
extern const fcml_cstring M_SHRB;
extern const fcml_cstring M_SHRD;
extern const fcml_cstring M_SHRL;
extern const fcml_cstring M_SHRQ;
extern const fcml_cstring M_SHRW;
extern const fcml_cstring M_SHRX;
extern const fcml_cstring M_SHUFPD;
extern const fcml_cstring M_SHUFPS;
extern const fcml_cstring M_SIDT;
extern const fcml_cstring M_SKINIT;
extern const fcml_cstring M_SLDT;
extern const fcml_cstring M_SLWPCB;
extern const fcml_cstring M_SMSW;
extern const fcml_cstring M_SQRTPD;
extern const fcml_cstring M_SQRTPS;
extern const fcml_cstring M_SQRTSD;
extern const fcml_cstring M_SQRTSS;
extern const fcml_cstring M_STAC;
extern const fcml_cstring M_STC;
extern const fcml_cstring M_STD;
extern const fcml_cstring M_STGI;
extern const fcml_cstring M_STI;
extern const fcml_cstring M_STMXCSR;
extern const fcml_cstring M_STOS;
extern const fcml_cstring M_STOSB;
extern const fcml_cstring M_STOSL;
extern const fcml_cstring M_STOSQ;
extern const fcml_cstring M_STOSW;
extern const fcml_cstring M_STR;
extern const fcml_cstring M_SUB;
extern const fcml_cstring M_SUBB;
extern const fcml_cstring M_SUBL;
extern const fcml_cstring M_SUBPD;
extern const fcml_cstring M_SUBPS;
extern const fcml_cstring M_SUBQ;
extern const fcml_cstring M_SUBSD;
extern const fcml_cstring M_SUBSS;
extern const fcml_cstring M_SUBW;
extern const fcml_cstring M_SWAPGS;
extern const fcml_cstring M_SYSCALL;
extern const fcml_cstring M_SYSENTER;
extern const fcml_cstring M_SYSEXIT;
extern const fcml_cstring M_SYSRET;
extern const fcml_cstring M_T1MSKC;
extern const fcml_cstring M_TEST;
extern const fcml_cstring M_TESTB;
extern const fcml_cstring M_TESTL;
extern const fcml_cstring M_TESTQ;
extern const fcml_cstring M_TESTW;
extern const fcml_cstring M_TZCNT;
extern const fcml_cstring M_TZMSK;
extern const fcml_cstring M_UCOMISD;
extern const fcml_cstring M_UCOMISS;
extern const fcml_cstring M_UD2;
extern const fcml_cstring M_UNPCKHPD;
extern const fcml_cstring M_UNPCKHPS;
extern const fcml_cstring M_UNPCKLPD;
extern const fcml_cstring M_UNPCKLPS;
extern const fcml_cstring M_V4FMADDPS;
extern const fcml_cstring M_V4FMADDSS;
extern const fcml_cstring M_V4FNMADDPS;
extern const fcml_cstring M_V4FNMADDSS;
extern const fcml_cstring M_VADDPD;
extern const fcml_cstring M_VADDPS;
extern const fcml_cstring M_VADDSD;
extern const fcml_cstring M_VADDSS;
extern const fcml_cstring M_VADDSUBPD;
extern const fcml_cstring M_VADDSUBPS;
extern const fcml_cstring M_VAESDEC;
extern const fcml_cstring M_VAESDECLAST;
extern const fcml_cstring M_VAESENC;
extern const fcml_cstring M_VAESENCLAST;
extern const fcml_cstring M_VAESIMC;
extern const fcml_cstring M_VAESKEYGENASSIST;
extern const fcml_cstring M_VALIGND;
extern const fcml_cstring M_VALIGNQ;
extern const fcml_cstring M_VANDNPD;
extern const fcml_cstring M_VANDNPS;
extern const fcml_cstring M_VANDPD;
extern const fcml_cstring M_VANDPS;
extern const fcml_cstring M_VBLENDMPD;
extern const fcml_cstring M_VBLENDMPS;
extern const fcml_cstring M_VBLENDPD;
extern const fcml_cstring M_VBLENDPS;
extern const fcml_cstring M_VBLENDVPD;
extern const fcml_cstring M_VBLENDVPS;
extern const fcml_cstring M_VBROADCASTF128;
extern const fcml_cstring M_VBROADCASTF32X2;
extern const fcml_cstring M_VBROADCASTF32X4;
extern const fcml_cstring M_VBROADCASTF32X8;
extern const fcml_cstring M_VBROADCASTF64X2;
extern const fcml_cstring M_VBROADCASTF64X4;
extern const fcml_cstring M_VBROADCASTI128;
extern const fcml_cstring M_VBROADCASTI32X2;
extern const fcml_cstring M_VBROADCASTI32X4;
extern const fcml_cstring M_VBROADCASTI32X8;
extern const fcml_cstring M_VBROADCASTI64X2;
extern const fcml_cstring M_VBROADCASTI64X4;
extern const fcml_cstring M_VBROADCASTSD;
extern const fcml_cstring M_VBROADCASTSS;
extern const fcml_cstring M_VCMPEQ_OSPD;
extern const fcml_cstring M_VCMPEQ_OSPS;
extern const fcml_cstring M_VCMPEQ_OSSD;
extern const fcml_cstring M_VCMPEQ_OSSS;
extern const fcml_cstring M_VCMPEQ_UQPD;
extern const fcml_cstring M_VCMPEQ_UQPS;
extern const fcml_cstring M_VCMPEQ_UQSD;
extern const fcml_cstring M_VCMPEQ_UQSS;
extern const fcml_cstring M_VCMPEQ_USPD;
extern const fcml_cstring M_VCMPEQ_USPS;
extern const fcml_cstring M_VCMPEQ_USSD;
extern const fcml_cstring M_VCMPEQ_USSS;
extern const fcml_cstring M_VCMPEQPD;
extern const fcml_cstring M_VCMPEQPS;
extern const fcml_cstring M_VCMPEQSD;
extern const fcml_cstring M_VCMPEQSS;
extern const fcml_cstring M_VCMPFALSE_OSPD;
extern const fcml_cstring M_VCMPFALSE_OSPS;
extern const fcml_cstring M_VCMPFALSE_OSSD;
extern const fcml_cstring M_VCMPFALSE_OSSS;
extern const fcml_cstring M_VCMPFALSEPD;
extern const fcml_cstring M_VCMPFALSEPS;
extern const fcml_cstring M_VCMPFALSESD;
extern const fcml_cstring M_VCMPFALSESS;
extern const fcml_cstring M_VCMPGE_OQPD;
extern const fcml_cstring M_VCMPGE_OQPS;
extern const fcml_cstring M_VCMPGE_OQSD;
extern const fcml_cstring M_VCMPGE_OQSS;
extern const fcml_cstring M_VCMPGEPD;
extern const fcml_cstring M_VCMPGEPS;
extern const fcml_cstring M_VCMPGESD;
extern const fcml_cstring M_VCMPGESS;
extern const fcml_cstring M_VCMPGT_OQPD;
extern const fcml_cstring M_VCMPGT_OQPS;
extern const fcml_cstring M_VCMPGT_OQSD;
extern const fcml_cstring M_VCMPGT_OQSS;
extern const fcml_cstring M_VCMPGTPD;
extern const fcml_cstring M_VCMPGTPS;
extern const fcml_cstring M_VCMPGTSD;
extern const fcml_cstring M_VCMPGTSS;
extern const fcml_cstring M_VCMPLE_OQPD;
extern const fcml_cstring M_VCMPLE_OQPS;
extern const fcml_cstring M_VCMPLE_OQSD;
extern const fcml_cstring M_VCMPLE_OQSS;
extern const fcml_cstring M_VCMPLEPD;
extern const fcml_cstring M_VCMPLEPS;
extern const fcml_cstring M_VCMPLESD;
extern const fcml_cstring M_VCMPLESS;
extern const fcml_cstring M_VCMPLT_OQPD;
extern const fcml_cstring M_VCMPLT_OQPS;
extern const fcml_cstring M_VCMPLT_OQSD;
extern const fcml_cstring M_VCMPLT_OQSS;
extern const fcml_cstring M_VCMPLTPD;
extern const fcml_cstring M_VCMPLTPS;
extern const fcml_cstring M_VCMPLTSD;
extern const fcml_cstring M_VCMPLTSS;
extern const fcml_cstring M_VCMPNEQ_OQPD;
extern const fcml_cstring M_VCMPNEQ_OQPS;
extern const fcml_cstring M_VCMPNEQ_OQSD;
extern const fcml_cstring M_VCMPNEQ_OQSS;
extern const fcml_cstring M_VCMPNEQ_OSPD;
extern const fcml_cstring M_VCMPNEQ_OSPS;
extern const fcml_cstring M_VCMPNEQ_OSSD;
extern const fcml_cstring M_VCMPNEQ_OSSS;
extern const fcml_cstring M_VCMPNEQ_USPD;
extern const fcml_cstring M_VCMPNEQ_USPS;
extern const fcml_cstring M_VCMPNEQ_USSD;
extern const fcml_cstring M_VCMPNEQ_USSS;
extern const fcml_cstring M_VCMPNEQPD;
extern const fcml_cstring M_VCMPNEQPS;
extern const fcml_cstring M_VCMPNEQSD;
extern const fcml_cstring M_VCMPNEQSS;
extern const fcml_cstring M_VCMPNGE_UQPD;
extern const fcml_cstring M_VCMPNGE_UQPS;
extern const fcml_cstring M_VCMPNGE_UQSD;
extern const fcml_cstring M_VCMPNGE_UQSS;
extern const fcml_cstring M_VCMPNGEPD;
extern const fcml_cstring M_VCMPNGEPS;
extern const fcml_cstring M_VCMPNGESD;
extern const fcml_cstring M_VCMPNGESS;
extern const fcml_cstring M_VCMPNGT_UQPD;
extern const fcml_cstring M_VCMPNGT_UQPS;
extern const fcml_cstring M_VCMPNGT_UQSD;
extern const fcml_cstring M_VCMPNGT_UQSS;
extern const fcml_cstring M_VCMPNGTPD;
extern const fcml_cstring M_VCMPNGTPS;
extern const fcml_cstring M_VCMPNGTSD;
extern const fcml_cstring M_VCMPNGTSS;
extern const fcml_cstring M_VCMPNLE_UQPD;
extern const fcml_cstring M_VCMPNLE_UQPS;
extern const fcml_cstring M_VCMPNLE_UQSD;
extern const fcml_cstring M_VCMPNLE_UQSS;
extern const fcml_cstring M_VCMPNLEPD;
extern const fcml_cstring M_VCMPNLEPS;
extern const fcml_cstring M_VCMPNLESD;
extern const fcml_cstring M_VCMPNLESS;
extern const fcml_cstring M_VCMPNLT_UQPD;
extern const fcml_cstring M_VCMPNLT_UQPS;
extern const fcml_cstring M_VCMPNLT_UQSD;
extern const fcml_cstring M_VCMPNLT_UQSS;
extern const fcml_cstring M_VCMPNLTPD;
extern const fcml_cstring M_VCMPNLTPS;
extern const fcml_cstring M_VCMPNLTSD;
extern const fcml_cstring M_VCMPNLTSS;
extern const fcml_cstring M_VCMPORD_SPD;
extern const fcml_cstring M_VCMPORD_SPS;
extern const fcml_cstring M_VCMPORD_SSD;
extern const fcml_cstring M_VCMPORD_SSS;
extern const fcml_cstring M_VCMPORDPD;
extern const fcml_cstring M_VCMPORDPS;
extern const fcml_cstring M_VCMPORDSD;
extern const fcml_cstring M_VCMPORDSS;
extern const fcml_cstring M_VCMPPD;
extern const fcml_cstring M_VCMPPS;
extern const fcml_cstring M_VCMPSD;
extern const fcml_cstring M_VCMPSS;
extern const fcml_cstring M_VCMPTRUE_USPD;
extern const fcml_cstring M_VCMPTRUE_USPS;
extern const fcml_cstring M_VCMPTRUE_USSD;
extern const fcml_cstring M_VCMPTRUE_USSS;
extern const fcml_cstring M_VCMPTRUEPD;
extern const fcml_cstring M_VCMPTRUEPS;
extern const fcml_cstring M_VCMPTRUESD;
extern const fcml_cstring M_VCMPTRUESS;
extern const fcml_cstring M_VCMPUNORD_SPD;
extern const fcml_cstring M_VCMPUNORD_SPS;
extern const fcml_cstring M_VCMPUNORD_SSD;
extern const fcml_cstring M_VCMPUNORD_SSS;
extern const fcml_cstring M_VCMPUNORDPD;
extern const fcml_cstring M_VCMPUNORDPS;
extern const fcml_cstring M_VCMPUNORDSD;
extern const fcml_cstring M_VCMPUNORDSS;
extern const fcml_cstring M_VCOMISD;
extern const fcml_cstring M_VCOMISS;
extern const fcml_cstring M_VCOMPRESSPD;
extern const fcml_cstring M_VCOMPRESSPS;
extern const fcml_cstring M_VCVTDQ2PD;
extern const fcml_cstring M_VCVTDQ2PS;
extern const fcml_cstring M_VCVTPD2DQ;
extern const fcml_cstring M_VCVTPD2DQX;
extern const fcml_cstring M_VCVTPD2DQY;
extern const fcml_cstring M_VCVTPD2PS;
extern const fcml_cstring M_VCVTPD2PSX;
extern const fcml_cstring M_VCVTPD2PSY;
extern const fcml_cstring M_VCVTPD2QQ;
extern const fcml_cstring M_VCVTPD2UDQ;
extern const fcml_cstring M_VCVTPD2UDQX;
extern const fcml_cstring M_VCVTPD2UDQY;
extern const fcml_cstring M_VCVTPD2UQQ;
extern const fcml_cstring M_VCVTPH2PS;
extern const fcml_cstring M_VCVTPS2DQ;
extern const fcml_cstring M_VCVTPS2PD;
extern const fcml_cstring M_VCVTPS2PH;
extern const fcml_cstring M_VCVTPS2QQ;
extern const fcml_cstring M_VCVTPS2UDQ;
extern const fcml_cstring M_VCVTPS2UQQ;
extern const fcml_cstring M_VCVTQQ2PD;
extern const fcml_cstring M_VCVTQQ2PS;
extern const fcml_cstring M_VCVTQQ2PSX;
extern const fcml_cstring M_VCVTQQ2PSY;
extern const fcml_cstring M_VCVTSD2SI;
extern const fcml_cstring M_VCVTSD2SS;
extern const fcml_cstring M_VCVTSD2USI;
extern const fcml_cstring M_VCVTSI2SDL;
extern const fcml_cstring M_VCVTSI2SDQ;
extern const fcml_cstring M_VCVTSI2SSL;
extern const fcml_cstring M_VCVTSI2SSQ;
extern const fcml_cstring M_VCVTSS2SD;
extern const fcml_cstring M_VCVTSS2SI;
extern const fcml_cstring M_VCVTSS2USI;
extern const fcml_cstring M_VCVTTPD2DQ;
extern const fcml_cstring M_VCVTTPD2DQX;
extern const fcml_cstring M_VCVTTPD2DQY;
extern const fcml_cstring M_VCVTTPD2QQ;
extern const fcml_cstring M_VCVTTPD2UDQ;
extern const fcml_cstring M_VCVTTPD2UDQX;
extern const fcml_cstring M_VCVTTPD2UDQY;
extern const fcml_cstring M_VCVTTPD2UQQ;
extern const fcml_cstring M_VCVTTPS2DQ;
extern const fcml_cstring M_VCVTTPS2QQ;
extern const fcml_cstring M_VCVTTPS2UDQ;
extern const fcml_cstring M_VCVTTPS2UQQ;
extern const fcml_cstring M_VCVTTSD2SI;
extern const fcml_cstring M_VCVTTSD2USI;
extern const fcml_cstring M_VCVTTSS2SI;
extern const fcml_cstring M_VCVTTSS2USI;
extern const fcml_cstring M_VCVTUDQ2PD;
extern const fcml_cstring M_VCVTUDQ2PS;
extern const fcml_cstring M_VCVTUQQ2PD;
extern const fcml_cstring M_VCVTUQQ2PS;
extern const fcml_cstring M_VCVTUQQ2PSX;
extern const fcml_cstring M_VCVTUQQ2PSY;
extern const fcml_cstring M_VCVTUSI2SD;
extern const fcml_cstring M_VCVTUSI2SS;
extern const fcml_cstring M_VDBPSADBW;
extern const fcml_cstring M_VDIVPD;
extern const fcml_cstring M_VDIVPS;
extern const fcml_cstring M_VDIVSD;
extern const fcml_cstring M_VDIVSS;
extern const fcml_cstring M_VDPPD;
extern const fcml_cstring M_VDPPS;
extern const fcml_cstring M_VERR;
extern const fcml_cstring M_VERW;
extern const fcml_cstring M_VEXP2PD;
extern const fcml_cstring M_VEXP2PS;
extern const fcml_cstring M_VEXPANDPD;
extern const fcml_cstring M_VEXPANDPS;
extern const fcml_cstring M_VEXTRACTF128;
extern const fcml_cstring M_VEXTRACTF32X4;
extern const fcml_cstring M_VEXTRACTF32X8;
extern const fcml_cstring M_VEXTRACTF64X2;
extern const fcml_cstring M_VEXTRACTF64X4;
extern const fcml_cstring M_VEXTRACTI128;
extern const fcml_cstring M_VEXTRACTI32X4;
extern const fcml_cstring M_VEXTRACTI32X8;
extern const fcml_cstring M_VEXTRACTI64X2;
extern const fcml_cstring M_VEXTRACTI64X4;
extern const fcml_cstring M_VEXTRACTPS;
extern const fcml_cstring M_VFIXUPIMMPD;
extern const fcml_cstring M_VFIXUPIMMPS;
extern const fcml_cstring M_VFIXUPIMMSD;
extern const fcml_cstring M_VFIXUPIMMSS;
extern const fcml_cstring M_VFMADD132PD;
extern const fcml_cstring M_VFMADD132PS;
extern const fcml_cstring M_VFMADD132SD;
extern const fcml_cstring M_VFMADD132SS;
extern const fcml_cstring M_VFMADD213PD;
extern const fcml_cstring M_VFMADD213PS;
extern const fcml_cstring M_VFMADD213SD;
extern const fcml_cstring M_VFMADD213SS;
extern const fcml_cstring M_VFMADD231PD;
extern const fcml_cstring M_VFMADD231PS;
extern const fcml_cstring M_VFMADD231SD;
extern const fcml_cstring M_VFMADD231SS;
extern const fcml_cstring M_VFMADDPD;
extern const fcml_cstring M_VFMADDPS;
extern const fcml_cstring M_VFMADDSD;
extern const fcml_cstring M_VFMADDSS;
extern const fcml_cstring M_VFMADDSUB132PD;
extern const fcml_cstring M_VFMADDSUB132PS;
extern const fcml_cstring M_VFMADDSUB213PD;
extern const fcml_cstring M_VFMADDSUB213PS;
extern const fcml_cstring M_VFMADDSUB231PD;
extern const fcml_cstring M_VFMADDSUB231PS;
extern const fcml_cstring M_VFMADDSUBPD;
extern const fcml_cstring M_VFMADDSUBPS;
extern const fcml_cstring M_VFMSUB132PD;
extern const fcml_cstring M_VFMSUB132PS;
extern const fcml_cstring M_VFMSUB132SD;
extern const fcml_cstring M_VFMSUB132SS;
extern const fcml_cstring M_VFMSUB213PD;
extern const fcml_cstring M_VFMSUB213PS;
extern const fcml_cstring M_VFMSUB213SD;
extern const fcml_cstring M_VFMSUB213SS;
extern const fcml_cstring M_VFMSUB231PD;
extern const fcml_cstring M_VFMSUB231PS;
extern const fcml_cstring M_VFMSUB231SD;
extern const fcml_cstring M_VFMSUB231SS;
extern const fcml_cstring M_VFMSUBADD132PD;
extern const fcml_cstring M_VFMSUBADD132PS;
extern const fcml_cstring M_VFMSUBADD213PD;
extern const fcml_cstring M_VFMSUBADD213PS;
extern const fcml_cstring M_VFMSUBADD231PD;
extern const fcml_cstring M_VFMSUBADD231PS;
extern const fcml_cstring M_VFMSUBADDPD;
extern const fcml_cstring M_VFMSUBADDPS;
extern const fcml_cstring M_VFMSUBPD;
extern const fcml_cstring M_VFMSUBPS;
extern const fcml_cstring M_VFMSUBSD;
extern const fcml_cstring M_VFMSUBSS;
extern const fcml_cstring M_VFNMADD132PD;
extern const fcml_cstring M_VFNMADD132PS;
extern const fcml_cstring M_VFNMADD132SD;
extern const fcml_cstring M_VFNMADD132SS;
extern const fcml_cstring M_VFNMADD213PD;
extern const fcml_cstring M_VFNMADD213PS;
extern const fcml_cstring M_VFNMADD213SD;
extern const fcml_cstring M_VFNMADD213SS;
extern const fcml_cstring M_VFNMADD231PD;
extern const fcml_cstring M_VFNMADD231PS;
extern const fcml_cstring M_VFNMADD231SD;
extern const fcml_cstring M_VFNMADD231SS;
extern const fcml_cstring M_VFNMADDPD;
extern const fcml_cstring M_VFNMADDPS;
extern const fcml_cstring M_VFNMADDSD;
extern const fcml_cstring M_VFNMADDSS;
extern const fcml_cstring M_VFNMSUB132PD;
extern const fcml_cstring M_VFNMSUB132PS;
extern const fcml_cstring M_VFNMSUB132SD;
extern const fcml_cstring M_VFNMSUB132SS;
extern const fcml_cstring M_VFNMSUB213PD;
extern const fcml_cstring M_VFNMSUB213PS;
extern const fcml_cstring M_VFNMSUB213SD;
extern const fcml_cstring M_VFNMSUB213SS;
extern const fcml_cstring M_VFNMSUB231PD;
extern const fcml_cstring M_VFNMSUB231PS;
extern const fcml_cstring M_VFNMSUB231SD;
extern const fcml_cstring M_VFNMSUB231SS;
extern const fcml_cstring M_VFNMSUBPD;
extern const fcml_cstring M_VFNMSUBPS;
extern const fcml_cstring M_VFNMSUBSD;
extern const fcml_cstring M_VFNMSUBSS;
extern const fcml_cstring M_VFPCLASSPD;
extern const fcml_cstring M_VFPCLASSPS;
extern const fcml_cstring M_VFPCLASSSD;
extern const fcml_cstring M_VFPCLASSSS;
extern const fcml_cstring M_VFRCZPD;
extern const fcml_cstring M_VFRCZPS;
extern const fcml_cstring M_VFRCZSD;
extern const fcml_cstring M_VFRCZSS;
extern const fcml_cstring M_VGATHERDPD;
extern const fcml_cstring M_VGATHERDPS;
extern const fcml_cstring M_VGATHERPF0DPD;
extern const fcml_cstring M_VGATHERPF0DPS;
extern const fcml_cstring M_VGATHERPF0QPD;
extern const fcml_cstring M_VGATHERPF0QPS;
extern const fcml_cstring M_VGATHERPF1DPD;
extern const fcml_cstring M_VGATHERPF1DPS;
extern const fcml_cstring M_VGATHERPF1QPD;
extern const fcml_cstring M_VGATHERPF1QPS;
extern const fcml_cstring M_VGATHERQPD;
extern const fcml_cstring M_VGATHERQPS;
extern const fcml_cstring M_VGETEXPPD;
extern const fcml_cstring M_VGETEXPPS;
extern const fcml_cstring M_VGETEXPSD;
extern const fcml_cstring M_VGETEXPSS;
extern const fcml_cstring M_VGETMANTPD;
extern const fcml_cstring M_VGETMANTPS;
extern const fcml_cstring M_VGETMANTSD;
extern const fcml_cstring M_VGETMANTSS;
extern const fcml_cstring M_VHADDPD;
extern const fcml_cstring M_VHADDPS;
extern const fcml_cstring M_VHSUBPD;
extern const fcml_cstring M_VHSUBPS;
extern const fcml_cstring M_VINSERTF128;
extern const fcml_cstring M_VINSERTF32X4;
extern const fcml_cstring M_VINSERTF32X8;
extern const fcml_cstring M_VINSERTF64X2;
extern const fcml_cstring M_VINSERTF64X4;
extern const fcml_cstring M_VINSERTI128;
extern const fcml_cstring M_VINSERTI32X4;
extern const fcml_cstring M_VINSERTI32X8;
extern const fcml_cstring M_VINSERTI64X2;
extern const fcml_cstring M_VINSERTI64X4;
extern const fcml_cstring M_VINSERTPS;
extern const fcml_cstring M_VLDDQU;
extern const fcml_cstring M_VLDMXCSR;
extern const fcml_cstring M_VMASKMOVDQU;
extern const fcml_cstring M_VMASKMOVPD;
extern const fcml_cstring M_VMASKMOVPS;
extern const fcml_cstring M_VMAXPD;
extern const fcml_cstring M_VMAXPS;
extern const fcml_cstring M_VMAXSD;
extern const fcml_cstring M_VMAXSS;
extern const fcml_cstring M_VMCALL;
extern const fcml_cstring M_VMCLEAR;
extern const fcml_cstring M_VMFUNC;
extern const fcml_cstring M_VMINPD;
extern const fcml_cstring M_VMINPS;
extern const fcml_cstring M_VMINSD;
extern const fcml_cstring M_VMINSS;
extern const fcml_cstring M_VMLAUNCH;
extern const fcml_cstring M_VMLOAD;
extern const fcml_cstring M_VMMCALL;
extern const fcml_cstring M_VMOVAPD;
extern const fcml_cstring M_VMOVAPS;
extern const fcml_cstring M_VMOVD;
extern const fcml_cstring M_VMOVDDUP;
extern const fcml_cstring M_VMOVDQA;
extern const fcml_cstring M_VMOVDQA32;
extern const fcml_cstring M_VMOVDQA64;
extern const fcml_cstring M_VMOVDQU;
extern const fcml_cstring M_VMOVDQU16;
extern const fcml_cstring M_VMOVDQU32;
extern const fcml_cstring M_VMOVDQU64;
extern const fcml_cstring M_VMOVDQU8;
extern const fcml_cstring M_VMOVHLPS;
extern const fcml_cstring M_VMOVHPD;
extern const fcml_cstring M_VMOVHPS;
extern const fcml_cstring M_VMOVLHPS;
extern const fcml_cstring M_VMOVLPD;
extern const fcml_cstring M_VMOVLPS;
extern const fcml_cstring M_VMOVMSKPD;
extern const fcml_cstring M_VMOVMSKPS;
extern const fcml_cstring M_VMOVNTDQ;
extern const fcml_cstring M_VMOVNTDQA;
extern const fcml_cstring M_VMOVNTPD;
extern const fcml_cstring M_VMOVNTPS;
extern const fcml_cstring M_VMOVQ;
extern const fcml_cstring M_VMOVSD;
extern const fcml_cstring M_VMOVSHDUP;
extern const fcml_cstring M_VMOVSLDUP;
extern const fcml_cstring M_VMOVSS;
extern const fcml_cstring M_VMOVUPD;
extern const fcml_cstring M_VMOVUPS;
extern const fcml_cstring M_VMPSADBW;
extern const fcml_cstring M_VMPTRLD;
extern const fcml_cstring M_VMPTRST;
extern const fcml_cstring M_VMREAD;
extern const fcml_cstring M_VMRESUME;
extern const fcml_cstring M_VMRUN;
extern const fcml_cstring M_VMSAVE;
extern const fcml_cstring M_VMULPD;
extern const fcml_cstring M_VMULPS;
extern const fcml_cstring M_VMULSD;
extern const fcml_cstring M_VMULSS;
extern const fcml_cstring M_VMWRITE;
extern const fcml_cstring M_VMXOFF;
extern const fcml_cstring M_VMXON;
extern const fcml_cstring M_VORPD;
extern const fcml_cstring M_VORPS;
extern const fcml_cstring M_VP4DPWSSD;
extern const fcml_cstring M_VP4DPWSSDS;
extern const fcml_cstring M_VPABSB;
extern const fcml_cstring M_VPABSD;
extern const fcml_cstring M_VPABSQ;
extern const fcml_cstring M_VPABSW;
extern const fcml_cstring M_VPACKSSDW;
extern const fcml_cstring M_VPACKSSWB;
extern const fcml_cstring M_VPACKUSDW;
extern const fcml_cstring M_VPACKUSWB;
extern const fcml_cstring M_VPADDB;
extern const fcml_cstring M_VPADDD;
extern const fcml_cstring M_VPADDQ;
extern const fcml_cstring M_VPADDSB;
extern const fcml_cstring M_VPADDSW;
extern const fcml_cstring M_VPADDUSB;
extern const fcml_cstring M_VPADDUSW;
extern const fcml_cstring M_VPADDW;
extern const fcml_cstring M_VPALIGNR;
extern const fcml_cstring M_VPAND;
extern const fcml_cstring M_VPANDD;
extern const fcml_cstring M_VPANDN;
extern const fcml_cstring M_VPANDND;
extern const fcml_cstring M_VPANDNQ;
extern const fcml_cstring M_VPANDQ;
extern const fcml_cstring M_VPAVGB;
extern const fcml_cstring M_VPAVGW;
extern const fcml_cstring M_VPBLENDD;
extern const fcml_cstring M_VPBLENDMB;
extern const fcml_cstring M_VPBLENDMD;
extern const fcml_cstring M_VPBLENDMQ;
extern const fcml_cstring M_VPBLENDMW;
extern const fcml_cstring M_VPBLENDVB;
extern const fcml_cstring M_VPBLENDW;
extern const fcml_cstring M_VPBROADCASTB;
extern const fcml_cstring M_VPBROADCASTD;
extern const fcml_cstring M_VPBROADCASTMB2Q;
extern const fcml_cstring M_VPBROADCASTMW2D;
extern const fcml_cstring M_VPBROADCASTQ;
extern const fcml_cstring M_VPBROADCASTW;
extern const fcml_cstring M_VPCLMULQDQ;
extern const fcml_cstring M_VPCMOV;
extern const fcml_cstring M_VPCMPB;
extern const fcml_cstring M_VPCMPD;
extern const fcml_cstring M_VPCMPEQB;
extern const fcml_cstring M_VPCMPEQD;
extern const fcml_cstring M_VPCMPEQQ;
extern const fcml_cstring M_VPCMPEQW;
extern const fcml_cstring M_VPCMPESTRI;
extern const fcml_cstring M_VPCMPESTRM;
extern const fcml_cstring M_VPCMPGTB;
extern const fcml_cstring M_VPCMPGTD;
extern const fcml_cstring M_VPCMPGTQ;
extern const fcml_cstring M_VPCMPGTW;
extern const fcml_cstring M_VPCMPISTRI;
extern const fcml_cstring M_VPCMPISTRM;
extern const fcml_cstring M_VPCMPQ;
extern const fcml_cstring M_VPCMPUB;
extern const fcml_cstring M_VPCMPUD;
extern const fcml_cstring M_VPCMPUQ;
extern const fcml_cstring M_VPCMPUW;
extern const fcml_cstring M_VPCMPW;
extern const fcml_cstring M_VPCOMB;
extern const fcml_cstring M_VPCOMD;
extern const fcml_cstring M_VPCOMEQB;
extern const fcml_cstring M_VPCOMEQD;
extern const fcml_cstring M_VPCOMEQQ;
extern const fcml_cstring M_VPCOMEQUB;
extern const fcml_cstring M_VPCOMEQUD;
extern const fcml_cstring M_VPCOMEQUQ;
extern const fcml_cstring M_VPCOMEQUW;
extern const fcml_cstring M_VPCOMEQW;
extern const fcml_cstring M_VPCOMFALSEB;
extern const fcml_cstring M_VPCOMFALSED;
extern const fcml_cstring M_VPCOMFALSEQ;
extern const fcml_cstring M_VPCOMFALSEUB;
extern const fcml_cstring M_VPCOMFALSEUD;
extern const fcml_cstring M_VPCOMFALSEUQ;
extern const fcml_cstring M_VPCOMFALSEUW;
extern const fcml_cstring M_VPCOMFALSEW;
extern const fcml_cstring M_VPCOMGEB;
extern const fcml_cstring M_VPCOMGED;
extern const fcml_cstring M_VPCOMGEQ;
extern const fcml_cstring M_VPCOMGEUB;
extern const fcml_cstring M_VPCOMGEUD;
extern const fcml_cstring M_VPCOMGEUQ;
extern const fcml_cstring M_VPCOMGEUW;
extern const fcml_cstring M_VPCOMGEW;
extern const fcml_cstring M_VPCOMGTB;
extern const fcml_cstring M_VPCOMGTD;
extern const fcml_cstring M_VPCOMGTQ;
extern const fcml_cstring M_VPCOMGTUB;
extern const fcml_cstring M_VPCOMGTUD;
extern const fcml_cstring M_VPCOMGTUQ;
extern const fcml_cstring M_VPCOMGTUW;
extern const fcml_cstring M_VPCOMGTW;
extern const fcml_cstring M_VPCOMLEB;
extern const fcml_cstring M_VPCOMLED;
extern const fcml_cstring M_VPCOMLEQ;
extern const fcml_cstring M_VPCOMLEUB;
extern const fcml_cstring M_VPCOMLEUD;
extern const fcml_cstring M_VPCOMLEUQ;
extern const fcml_cstring M_VPCOMLEUW;
extern const fcml_cstring M_VPCOMLEW;
extern const fcml_cstring M_VPCOMLTB;
extern const fcml_cstring M_VPCOMLTD;
extern const fcml_cstring M_VPCOMLTQ;
extern const fcml_cstring M_VPCOMLTUB;
extern const fcml_cstring M_VPCOMLTUD;
extern const fcml_cstring M_VPCOMLTUQ;
extern const fcml_cstring M_VPCOMLTUW;
extern const fcml_cstring M_VPCOMLTW;
extern const fcml_cstring M_VPCOMNEQB;
extern const fcml_cstring M_VPCOMNEQD;
extern const fcml_cstring M_VPCOMNEQQ;
extern const fcml_cstring M_VPCOMNEQUB;
extern const fcml_cstring M_VPCOMNEQUD;
extern const fcml_cstring M_VPCOMNEQUQ;
extern const fcml_cstring M_VPCOMNEQUW;
extern const fcml_cstring M_VPCOMNEQW;
extern const fcml_cstring M_VPCOMPRESSD;
extern const fcml_cstring M_VPCOMPRESSQ;
extern const fcml_cstring M_VPCOMQ;
extern const fcml_cstring M_VPCOMTRUEB;
extern const fcml_cstring M_VPCOMTRUED;
extern const fcml_cstring M_VPCOMTRUEQ;
extern const fcml_cstring M_VPCOMTRUEUB;
extern const fcml_cstring M_VPCOMTRUEUD;
extern const fcml_cstring M_VPCOMTRUEUQ;
extern const fcml_cstring M_VPCOMTRUEUW;
extern const fcml_cstring M_VPCOMTRUEW;
extern const fcml_cstring M_VPCOMUB;
extern const fcml_cstring M_VPCOMUD;
extern const fcml_cstring M_VPCOMUQ;
extern const fcml_cstring M_VPCOMUW;
extern const fcml_cstring M_VPCOMW;
extern const fcml_cstring M_VPERM2F128;
extern const fcml_cstring M_VPERM2I128;
extern const fcml_cstring M_VPERMB;
extern const fcml_cstring M_VPERMD;
extern const fcml_cstring M_VPERMI2B;
extern const fcml_cstring M_VPERMI2D;
extern const fcml_cstring M_VPERMI2PD;
extern const fcml_cstring M_VPERMI2PS;
extern const fcml_cstring M_VPERMI2Q;
extern const fcml_cstring M_VPERMI2W;
extern const fcml_cstring M_VPERMIL2PD;
extern const fcml_cstring M_VPERMIL2PS;
extern const fcml_cstring M_VPERMILPD;
extern const fcml_cstring M_VPERMILPS;
extern const fcml_cstring M_VPERMPD;
extern const fcml_cstring M_VPERMPS;
extern const fcml_cstring M_VPERMQ;
extern const fcml_cstring M_VPERMT2B;
extern const fcml_cstring M_VPERMT2D;
extern const fcml_cstring M_VPERMT2PD;
extern const fcml_cstring M_VPERMT2PS;
extern const fcml_cstring M_VPERMT2Q;
extern const fcml_cstring M_VPERMT2W;
extern const fcml_cstring M_VPERMW;
extern const fcml_cstring M_VPEXPANDD;
extern const fcml_cstring M_VPEXPANDQ;
extern const fcml_cstring M_VPEXTRB;
extern const fcml_cstring M_VPEXTRD;
extern const fcml_cstring M_VPEXTRQ;
extern const fcml_cstring M_VPEXTRW;
extern const fcml_cstring M_VPGATHERDD;
extern const fcml_cstring M_VPGATHERDQ;
extern const fcml_cstring M_VPGATHERQD;
extern const fcml_cstring M_VPGATHERQQ;
extern const fcml_cstring M_VPHADDBD;
extern const fcml_cstring M_VPHADDBQ;
extern const fcml_cstring M_VPHADDBW;
extern const fcml_cstring M_VPHADDD;
extern const fcml_cstring M_VPHADDDQ;
extern const fcml_cstring M_VPHADDSW;
extern const fcml_cstring M_VPHADDUBD;
extern const fcml_cstring M_VPHADDUBQ;
extern const fcml_cstring M_VPHADDUBW;
extern const fcml_cstring M_VPHADDUDQ;
extern const fcml_cstring M_VPHADDUWD;
extern const fcml_cstring M_VPHADDUWQ;
extern const fcml_cstring M_VPHADDW;
extern const fcml_cstring M_VPHADDWD;
extern const fcml_cstring M_VPHADDWQ;
extern const fcml_cstring M_VPHMINPOSUW;
extern const fcml_cstring M_VPHSUBBW;
extern const fcml_cstring M_VPHSUBD;
extern const fcml_cstring M_VPHSUBDQ;
extern const fcml_cstring M_VPHSUBSW;
extern const fcml_cstring M_VPHSUBW;
extern const fcml_cstring M_VPHSUBWD;
extern const fcml_cstring M_VPINSRB;
extern const fcml_cstring M_VPINSRD;
extern const fcml_cstring M_VPINSRQ;
extern const fcml_cstring M_VPINSRW;
extern const fcml_cstring M_VPLZCNTD;
extern const fcml_cstring M_VPLZCNTQ;
extern const fcml_cstring M_VPMACSDD;
extern const fcml_cstring M_VPMACSDQH;
extern const fcml_cstring M_VPMACSDQL;
extern const fcml_cstring M_VPMACSSDD;
extern const fcml_cstring M_VPMACSSDQH;
extern const fcml_cstring M_VPMACSSDQL;
extern const fcml_cstring M_VPMACSSWD;
extern const fcml_cstring M_VPMACSSWW;
extern const fcml_cstring M_VPMACSWD;
extern const fcml_cstring M_VPMACSWW;
extern const fcml_cstring M_VPMADCSSWD;
extern const fcml_cstring M_VPMADCSWD;
extern const fcml_cstring M_VPMADD52HUQ;
extern const fcml_cstring M_VPMADD52LUQ;
extern const fcml_cstring M_VPMADDUBSW;
extern const fcml_cstring M_VPMADDWD;
extern const fcml_cstring M_VPMASKMOV;
extern const fcml_cstring M_VPMASKMOVD;
extern const fcml_cstring M_VPMASKMOVQ;
extern const fcml_cstring M_VPMAXSB;
extern const fcml_cstring M_VPMAXSD;
extern const fcml_cstring M_VPMAXSQ;
extern const fcml_cstring M_VPMAXSW;
extern const fcml_cstring M_VPMAXUB;
extern const fcml_cstring M_VPMAXUD;
extern const fcml_cstring M_VPMAXUQ;
extern const fcml_cstring M_VPMAXUW;
extern const fcml_cstring M_VPMINSB;
extern const fcml_cstring M_VPMINSD;
extern const fcml_cstring M_VPMINSQ;
extern const fcml_cstring M_VPMINSW;
extern const fcml_cstring M_VPMINUB;
extern const fcml_cstring M_VPMINUD;
extern const fcml_cstring M_VPMINUQ;
extern const fcml_cstring M_VPMINUW;
extern const fcml_cstring M_VPMOVB2M;
extern const fcml_cstring M_VPMOVD2M;
extern const fcml_cstring M_VPMOVDB;
extern const fcml_cstring M_VPMOVDW;
extern const fcml_cstring M_VPMOVM2B;
extern const fcml_cstring M_VPMOVM2D;
extern const fcml_cstring M_VPMOVM2Q;
extern const fcml_cstring M_VPMOVM2W;
extern const fcml_cstring M_VPMOVMSKB;
extern const fcml_cstring M_VPMOVQ2M;
extern const fcml_cstring M_VPMOVQB;
extern const fcml_cstring M_VPMOVQD;
extern const fcml_cstring M_VPMOVQW;
extern const fcml_cstring M_VPMOVSDB;
extern const fcml_cstring M_VPMOVSDW;
extern const fcml_cstring M_VPMOVSQB;
extern const fcml_cstring M_VPMOVSQD;
extern const fcml_cstring M_VPMOVSQW;
extern const fcml_cstring M_VPMOVSWB;
extern const fcml_cstring M_VPMOVSXBD;
extern const fcml_cstring M_VPMOVSXBQ;
extern const fcml_cstring M_VPMOVSXBW;
extern const fcml_cstring M_VPMOVSXDQ;
extern const fcml_cstring M_VPMOVSXWD;
extern const fcml_cstring M_VPMOVSXWQ;
extern const fcml_cstring M_VPMOVUSDB;
extern const fcml_cstring M_VPMOVUSDW;
extern const fcml_cstring M_VPMOVUSQB;
extern const fcml_cstring M_VPMOVUSQD;
extern const fcml_cstring M_VPMOVUSQW;
extern const fcml_cstring M_VPMOVUSWB;
extern const fcml_cstring M_VPMOVW2M;
extern const fcml_cstring M_VPMOVWB;
extern const fcml_cstring M_VPMOVZXBD;
extern const fcml_cstring M_VPMOVZXBQ;
extern const fcml_cstring M_VPMOVZXBW;
extern const fcml_cstring M_VPMOVZXDQ;
extern const fcml_cstring M_VPMOVZXWD;
extern const fcml_cstring M_VPMOVZXWQ;
extern const fcml_cstring M_VPMULDQ;
extern const fcml_cstring M_VPMULHRSW;
extern const fcml_cstring M_VPMULHUW;
extern const fcml_cstring M_VPMULHW;
extern const fcml_cstring M_VPMULLD;
extern const fcml_cstring M_VPMULLQ;
extern const fcml_cstring M_VPMULLW;
extern const fcml_cstring M_VPMULTISHIFTQB;
extern const fcml_cstring M_VPMULUDQ;
extern const fcml_cstring M_VPOR;
extern const fcml_cstring M_VPORD;
extern const fcml_cstring M_VPORQ;
extern const fcml_cstring M_VPPERM;
extern const fcml_cstring M_VPROLD;
extern const fcml_cstring M_VPROLQ;
extern const fcml_cstring M_VPROLVD;
extern const fcml_cstring M_VPROLVQ;
extern const fcml_cstring M_VPRORD;
extern const fcml_cstring M_VPRORQ;
extern const fcml_cstring M_VPRORVD;
extern const fcml_cstring M_VPRORVQ;
extern const fcml_cstring M_VPROTB;
extern const fcml_cstring M_VPROTD;
extern const fcml_cstring M_VPROTQ;
extern const fcml_cstring M_VPROTW;
extern const fcml_cstring M_VPSADBW;
extern const fcml_cstring M_VPSCATTERDD;
extern const fcml_cstring M_VPSCATTERDQ;
extern const fcml_cstring M_VPSCATTERQD;
extern const fcml_cstring M_VPSCATTERQQ;
extern const fcml_cstring M_VPSHAB;
extern const fcml_cstring M_VPSHAD;
extern const fcml_cstring M_VPSHAQ;
extern const fcml_cstring M_VPSHAW;
extern const fcml_cstring M_VPSHLB;
extern const fcml_cstring M_VPSHLD;
extern const fcml_cstring M_VPSHLQ;
extern const fcml_cstring M_VPSHLW;
extern const fcml_cstring M_VPSHUFB;
extern const fcml_cstring M_VPSHUFD;
extern const fcml_cstring M_VPSHUFHW;
extern const fcml_cstring M_VPSHUFLW;
extern const fcml_cstring M_VPSIGNB;
extern const fcml_cstring M_VPSIGND;
extern const fcml_cstring M_VPSIGNW;
extern const fcml_cstring M_VPSLLD;
extern const fcml_cstring M_VPSLLDQ;
extern const fcml_cstring M_VPSLLQ;
extern const fcml_cstring M_VPSLLVD;
extern const fcml_cstring M_VPSLLVQ;
extern const fcml_cstring M_VPSLLVW;
extern const fcml_cstring M_VPSLLW;
extern const fcml_cstring M_VPSRAD;
extern const fcml_cstring M_VPSRAQ;
extern const fcml_cstring M_VPSRAVD;
extern const fcml_cstring M_VPSRAVQ;
extern const fcml_cstring M_VPSRAVW;
extern const fcml_cstring M_VPSRAW;
extern const fcml_cstring M_VPSRLD;
extern const fcml_cstring M_VPSRLDQ;
extern const fcml_cstring M_VPSRLQ;
extern const fcml_cstring M_VPSRLVD;
extern const fcml_cstring M_VPSRLVQ;
extern const fcml_cstring M_VPSRLVW;
extern const fcml_cstring M_VPSRLW;
extern const fcml_cstring M_VPSUBB;
extern const fcml_cstring M_VPSUBD;
extern const fcml_cstring M_VPSUBQ;
extern const fcml_cstring M_VPSUBSB;
extern const fcml_cstring M_VPSUBSW;
extern const fcml_cstring M_VPSUBUSB;
extern const fcml_cstring M_VPSUBUSW;
extern const fcml_cstring M_VPSUBW;
extern const fcml_cstring M_VPTERNLOGD;
extern const fcml_cstring M_VPTERNLOGQ;
extern const fcml_cstring M_VPTEST;
extern const fcml_cstring M_VPTESTMB;
extern const fcml_cstring M_VPTESTMD;
extern const fcml_cstring M_VPTESTMQ;
extern const fcml_cstring M_VPTESTMW;
extern const fcml_cstring M_VPTESTNMB;
extern const fcml_cstring M_VPTESTNMD;
extern const fcml_cstring M_VPTESTNMQ;
extern const fcml_cstring M_VPTESTNMW;
extern const fcml_cstring M_VPUNPCKHBW;
extern const fcml_cstring M_VPUNPCKHDQ;
extern const fcml_cstring M_VPUNPCKHQDQ;
extern const fcml_cstring M_VPUNPCKHWD;
extern const fcml_cstring M_VPUNPCKLBW;
extern const fcml_cstring M_VPUNPCKLDQ;
extern const fcml_cstring M_VPUNPCKLQDQ;
extern const fcml_cstring M_VPUNPCKLWD;
extern const fcml_cstring M_VPXOR;
extern const fcml_cstring M_VPXORD;
extern const fcml_cstring M_VPXORQ;
extern const fcml_cstring M_VRANGEPD;
extern const fcml_cstring M_VRANGEPS;
extern const fcml_cstring M_VRANGESD;
extern const fcml_cstring M_VRANGESS;
extern const fcml_cstring M_VRCP14PD;
extern const fcml_cstring M_VRCP14PS;
extern const fcml_cstring M_VRCP14SD;
extern const fcml_cstring M_VRCP14SS;
extern const fcml_cstring M_VRCP28PD;
extern const fcml_cstring M_VRCP28PS;
extern const fcml_cstring M_VRCP28SD;
extern const fcml_cstring M_VRCP28SS;
extern const fcml_cstring M_VRCPPS;
extern const fcml_cstring M_VRCPSS;
extern const fcml_cstring M_VREDUCEPD;
extern const fcml_cstring M_VREDUCEPS;
extern const fcml_cstring M_VREDUCESD;
extern const fcml_cstring M_VREDUCESS;
extern const fcml_cstring M_VRNDSCALEPD;
extern const fcml_cstring M_VRNDSCALEPS;
extern const fcml_cstring M_VRNDSCALESD;
extern const fcml_cstring M_VRNDSCALESS;
extern const fcml_cstring M_VROUNDPD;
extern const fcml_cstring M_VROUNDPS;
extern const fcml_cstring M_VROUNDSD;
extern const fcml_cstring M_VROUNDSS;
extern const fcml_cstring M_VRSQRT14PD;
extern const fcml_cstring M_VRSQRT14PS;
extern const fcml_cstring M_VRSQRT14SD;
extern const fcml_cstring M_VRSQRT14SS;
extern const fcml_cstring M_VRSQRT28PD;
extern const fcml_cstring M_VRSQRT28PS;
extern const fcml_cstring M_VRSQRT28SD;
extern const fcml_cstring M_VRSQRT28SS;
extern const fcml_cstring M_VRSQRTPS;
extern const fcml_cstring M_VRSQRTSS;
extern const fcml_cstring M_VSCALEFPD;
extern const fcml_cstring M_VSCALEFPS;
extern const fcml_cstring M_VSCALEFSD;
extern const fcml_cstring M_VSCALEFSS;
extern const fcml_cstring M_VSCATTERDPD;
extern const fcml_cstring M_VSCATTERDPS;
extern const fcml_cstring M_VSCATTERPF0DPD;
extern const fcml_cstring M_VSCATTERPF0DPS;
extern const fcml_cstring M_VSCATTERPF0QPD;
extern const fcml_cstring M_VSCATTERPF0QPS;
extern const fcml_cstring M_VSCATTERPF1DPD;
extern const fcml_cstring M_VSCATTERPF1DPS;
extern const fcml_cstring M_VSCATTERPF1QPD;
extern const fcml_cstring M_VSCATTERPF1QPS;
extern const fcml_cstring M_VSCATTERQPD;
extern const fcml_cstring M_VSCATTERQPS;
extern const fcml_cstring M_VSHUFF32X4;
extern const fcml_cstring M_VSHUFF64X2;
extern const fcml_cstring M_VSHUFI32X4;
extern const fcml_cstring M_VSHUFI64X2;
extern const fcml_cstring M_VSHUFPD;
extern const fcml_cstring M_VSHUFPS;
extern const fcml_cstring M_VSQRTPD;
extern const fcml_cstring M_VSQRTPS;
extern const fcml_cstring M_VSQRTSD;
extern const fcml_cstring M_VSQRTSS;
extern const fcml_cstring M_VSTMXCSR;
extern const fcml_cstring M_VSUBPD;
extern const fcml_cstring M_VSUBPS;
extern const fcml_cstring M_VSUBSD;
extern const fcml_cstring M_VSUBSS;
extern const fcml_cstring M_VTESTPD;
extern const fcml_cstring M_VTESTPS;
extern const fcml_cstring M_VUCOMISD;
extern const fcml_cstring M_VUCOMISS;
extern const fcml_cstring M_VUNPCKHPD;
extern const fcml_cstring M_VUNPCKHPS;
extern const fcml_cstring M_VUNPCKLPD;
extern const fcml_cstring M_VUNPCKLPS;
extern const fcml_cstring M_VXORPD;
extern const fcml_cstring M_VXORPS;
extern const fcml_cstring M_VZEROALL;
extern const fcml_cstring M_VZEROUPPER;
extern const fcml_cstring M_WAIT;
extern const fcml_cstring M_WBINVD;
extern const fcml_cstring M_WRFSBASE;
extern const fcml_cstring M_WRGSBASE;
extern const fcml_cstring M_WRMSR;
extern const fcml_cstring M_XABORT;
extern const fcml_cstring M_XADD;
extern const fcml_cstring M_XBEGIN;
extern const fcml_cstring M_XCHG;
extern const fcml_cstring M_XEND;
extern const fcml_cstring M_XGETBV;
extern const fcml_cstring M_XLAT;
extern const fcml_cstring M_XLATB;
extern const fcml_cstring M_XOR;
extern const fcml_cstring M_XORB;
extern const fcml_cstring M_XORL;
extern const fcml_cstring M_XORPD;
extern const fcml_cstring M_XORPS;
extern const fcml_cstring M_XORQ;
extern const fcml_cstring M_XORW;
extern const fcml_cstring M_XRSTOR;
extern const fcml_cstring M_XRSTOR64;
extern const fcml_cstring M_XSAVE;
extern const fcml_cstring M_XSAVE64;
extern const fcml_cstring M_XSAVEOPT;
extern const fcml_cstring M_XSAVEOPT64;
extern const fcml_cstring M_XSETBV;
extern const fcml_cstring M_XTEST;

}
}

#endif /* FCML_GAS_MNEMONICS_HPP_ */
