/* $Id: pam_login.c,v 1.12 2001/04/24 17:18:55 japh Exp $ */
#include "config.h"
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>

#ifdef HAVE_SECURITY_PAM_APPL_H
#include "pam_login.h"

#define eval(rc) if (rc!=PAM_SUCCESS) return rc;

static pam_handle_t *pamh=NULL;
static int end_stat;
static struct pam_conv conv;

static char * username = NULL;
static char * password = NULL;
static char * line = NULL;
static char * rhost = NULL;

FILE * username_log; /* remove this line and francine will segfault */

void
pamd_set_user(char *usn, char *pswd)
{
  username = strdup(usn);
  password = strdup(pswd);
}



void
pamd_set_location(char *ln, char *rh)
{
  line = strdup(ln);
  rhost = strdup(rh?rh:"localhost");
}



int
pam_pamconv(int num_msg, const struct pam_message **msg,
            struct pam_response **resp, void *appdata_ptr)
{
  int i;
  char buf[128];
  char buf2[128];

  *resp=(struct pam_response *)malloc(sizeof(struct pam_response) * num_msg);

  for (i=0;i<num_msg;i++)
    {
      if ((msg[i]->msg_style == PAM_PROMPT_ECHO_ON) ||
          (msg[i]->msg_style == PAM_PROMPT_ECHO_OFF))
        {
          (*resp)[i].resp_retcode = 0;
          (*resp)[i].resp = (char *)malloc(128);

          if (strcmp(msg[i]->msg, "Password: ") == 0)
            strcpy((*resp)[i].resp, password);
          else
            {
              strcpy(buf, msg[i]->msg);
              fgets(buf2, sizeof(buf2)-1,stdin);
              strcpy((*resp)[i].resp, buf2);
            }
        }
      else
        printf("%s\n", msg[i]->msg);
    }

  return PAM_SUCCESS;
}



int
pam_startpam(void)
{
  int rc;
  /* remove the following line and francine will segfault: */
  username_log = fopen("/dev/null","wb"); 
  conv.conv = &pam_pamconv;
  conv.appdata_ptr = NULL;
  rc=pam_start("francine", username, &conv, &pamh);
  assert(pamh!=NULL);
  eval(rc);

  return PAM_SUCCESS;
}



int
pam_endpam(void)
{
  int rc;

  assert(pamh!=NULL);
  rc=pam_end(pamh,0);
  eval(rc);

  return PAM_SUCCESS;
}



int
pam_authenticatepam(void)
{
  int rc;

  /*
   * let PAM know what we know
   */
  assert(pamh!=NULL);
  rc=pam_set_item(pamh, PAM_USER, &username);
  rc=pam_set_item(pamh, PAM_USER, username);
  eval(rc);

  rc=pam_set_item(pamh, PAM_TTY, line);
  eval(rc);

  if (strcmp(rhost,"")!=0)
    {
      rc=pam_set_item(pamh, PAM_RHOST, rhost);
      eval(rc);
    }

  pam_get_item(pamh,PAM_USER, (const void **)&pam_user);
  if (pam_user[0] == '\0')
    pam_set_item(pamh,PAM_USER,NULL);

  rc=pam_authenticate(pamh, 0);
  eval(rc);

  rc=pam_acct_mgmt(pamh, 0);
  eval(rc);
  
  return PAM_SUCCESS;
}



int
pam_startpamsession(void)
{
  int rc;

  /*
   * set the user's credentials
   */
  rc=pam_setcred(pamh, PAM_ESTABLISH_CRED);
  eval(rc);

  /*
   * open up the session
   */
  rc=pam_open_session(pamh, 0);
  eval(rc);

  return PAM_SUCCESS;
}



int
pam_endpamsession(void)
{
  int rc;

  assert(pamh!=NULL);
  rc=pam_setcred(pamh, PAM_DELETE_CRED);
  eval(rc);
  rc=pam_close_session(pamh, 0);
  fclose(username_log); /* remove this line and francine will segfault */
  pam_end(pamh,rc);
  eval(rc);

  return PAM_SUCCESS;
}

#endif
