/* $Id: speech.c,v 1.3 2001/04/17 11:47:37 japh Exp $ */
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "conf.h"

int speech_device_is_accessible(char *);

void do_speech_output(char * str)
{
  FILE * f;
  if (speech_device_is_accessible(get_speech_device()))
    {
      f = fopen(get_speech_device(),"a");
      if (f!=NULL)
	{
	  fprintf(f,"%s\n",str);
	  fclose(f);
	}
    }
}

/* not a very clean solution, should be rewritten */
int speech_device_is_accessible(char * fn)
{
  struct stat fn_stat;
  int rc = stat(fn,&fn_stat);
  /* if we couldn't stat the file, we can't access it, either */
  if (-1 == rc)
    {
      return 0;
    }
  /* 
   * if the speech device is neither a char device (dectalk, etc.) nor a 
   * fifo (speechd + festival), we don't want to write to it.
   */
  if (!(fn_stat.st_mode&S_IFCHR) && !(fn_stat.st_mode&S_IFIFO))
    {
      return 0;
    }
  return 1;
}
