/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#define __MULTI_TAP_DELAY_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#ifndef __DELAY_H
 #include "delay.h"
#endif

#ifndef __MIX_H
 #include "mixer.h"
#endif


typedef struct multi_tap_delay{
  sample *(* get_buffer)(struct multi_tap_delay *);
  void (*next_buffer)(struct multi_tap_delay *);
  sample_producer **(*get_children)(struct multi_tap_delay *);
  char **(*get_header)(struct multi_tap_delay *);
  char **(*get_code)(struct multi_tap_delay *);
  char **(*get_footer)(struct multi_tap_delay *);
  int num_taps;
  sample_producer *input;
  delay** combs;
  mixer *mix;
  sample_producer *unused; /* list terminator */
}multi_tap_delay;

multi_tap_delay *multi_tap_delay_new(int num_taps, sample_producer *input);
sample *multi_tap_delay_get_buffer(multi_tap_delay *this);
void multi_tap_delay_next_buffer(multi_tap_delay *this);

/*
  Local Variables:
  mode: font-lock
  End:
*/

