/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __ALL_PASS_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#define MAX_FEEDBACK 32768
#define MIN_FEEDBACK 0

typedef struct all_pass{
  sample *(* get_buffer)(struct all_pass *);
  void (*next_buffer)(struct all_pass *);
  sample_producer **(*get_children)(struct all_pass *);
  char **(*get_header)(struct all_pass *);
  char **(*get_code)(struct all_pass *);
  char **(*get_footer)(struct all_pass *);
  int next;
  sample *delay_buffer;
  sample_producer *input;
  sample_producer *unused; /* dummy member to terminate list of children */
  sample *buffer;
  int feedback;
  double delay_time_milli;
  int delay_size;
  int d_index;
  int biggest_size;
}all_pass;


all_pass *all_pass_new(double delay_time_milli,int feedback, 
		       sample_producer *input);
sample *all_pass_get_buffer(all_pass *this);
void all_pass_next_buffer(all_pass *this);
void all_pass_set_time(all_pass *this,double delay_time_milli);
void all_pass_set_feedback(all_pass *this,int feedback);

/*
  Local Variables:
  mode: font-lock
  End:
*/

