/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2008-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#ifndef makeCoalParcelSurfaceReactionModels_H
#define makeCoalParcelSurfaceReactionModels_H

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include <specie/thermoPhysicsTypes.H>
#include <lagrangianIntermediate/ReactingMultiphaseCloud_.H>

#include <lagrangianIntermediate/NoSurfaceReaction.H>
#include <coalCombustion/COxidationDiffusionLimitedRate.H>
#include <coalCombustion/COxidationKineticDiffusionLimitedRate.H>
#include <coalCombustion/COxidationMurphyShaddix.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#define makeCoalSurfaceReactionModels(ParcelType)                             \
                                                                              \
    makeCoalSurfaceReactionModelThermoType                                    \
    (                                                                         \
        ParcelType,                                                           \
        constGasThermoPhysics                                                 \
    );                                                                        \
    makeCoalSurfaceReactionModelThermoType                                    \
    (                                                                         \
        ParcelType,                                                           \
        gasThermoPhysics                                                      \
    );                                                                        \
    makeCoalSurfaceReactionModelThermoType                                    \
    (                                                                         \
        ParcelType,                                                           \
        icoPoly8ThermoPhysics                                                 \
    );


#define makeCoalSurfaceReactionModelThermoType(ParcelType, ThermoType)        \
                                                                              \
    makeSurfaceReactionModel                                                  \
    (                                                                         \
        ReactingMultiphaseCloud<ParcelType<ThermoType> >                      \
    );                                                                        \
                                                                              \
    makeSurfaceReactionModelThermoType                                        \
    (                                                                         \
        NoSurfaceReaction,                                                    \
        ReactingMultiphaseCloud,                                              \
        ParcelType,                                                           \
        ThermoType                                                            \
    );                                                                        \
    makeSurfaceReactionModelThermoType                                        \
    (                                                                         \
        COxidationDiffusionLimitedRate,                                       \
        ReactingMultiphaseCloud,                                              \
        ParcelType,                                                           \
        ThermoType                                                            \
    );                                                                        \
    makeSurfaceReactionModelThermoType                                        \
    (                                                                         \
        COxidationKineticDiffusionLimitedRate,                                \
        ReactingMultiphaseCloud,                                              \
        ParcelType,                                                           \
        ThermoType                                                            \
    );                                                                        \
    makeSurfaceReactionModelThermoType                                        \
    (                                                                         \
        COxidationMurphyShaddix,                                              \
        ReactingMultiphaseCloud,                                              \
        ParcelType,                                                           \
        ThermoType                                                            \
    );


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
