/*
 * Decompiled with CFR 0.152.
 */
import bemused.BemusedProtocol;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import translate.Translate;

public class ControlForm
extends Form
implements CommandListener,
ItemCommandListener {
    Controller controller;
    Command exitCommand;
    Command disconnectCommand;
    Command shutdownCommand;
    Command textCommand;
    Command numericCommand;
    Command moreCommand;
    Command browseCommand;
    Command getItemDataCommand;
    StringItem statusItem;
    NavigationWidget naviItem;
    String[] lastPlaylistItems;
    int lastPlaylistPos;
    Translate t = Translate.getInstance();

    public ControlForm(Controller controller) {
        super("Freevused");
        this.controller = controller;
        this.setCommandListener(this);
        this.naviItem = new NavigationWidget(controller, 0, this.getWidth(), -1);
        this.naviItem.setLayout(this.naviItem.getLayout() | 3);
        this.statusItem = new StringItem(null, Translate.get("Press any key to control"));
        this.statusItem.setLayout(this.statusItem.getLayout() | 3);
        this.statusItem.setPreferredSize(this.getWidth(), -1);
        this.statusItem.setFont(Font.getFont((int)0, (int)1, (int)8));
        this.append((Item)this.naviItem);
        this.append((Item)this.statusItem);
        this.exitCommand = new Command(Translate.get("Exit"), 7, 2);
        this.addCommand(this.exitCommand);
        this.numericCommand = new Command(Translate.get("Numeric"), Translate.get("Numeric keys"), 1, 2);
        this.addCommand(this.numericCommand);
        this.moreCommand = new Command(Translate.get("More"), Translate.get("More actions"), 1, 2);
        this.addCommand(this.moreCommand);
        this.textCommand = new Command(Translate.get("Text"), Translate.get("Send text"), 1, 2);
        this.addCommand(this.textCommand);
        this.browseCommand = new Command(Translate.get("Browse"), Translate.get("Browse menu"), 1, 2);
        this.addCommand(this.browseCommand);
        this.getItemDataCommand = new Command(Translate.get("Get data"), Translate.get("Get item data"), 1, 2);
        this.addCommand(this.getItemDataCommand);
    }

    public void setStatus(BemusedProtocol.ItemData itemData) {
        this.statusItem.setText(itemData.data);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.controller.exit();
        } else if (command == this.disconnectCommand) {
            this.controller.disconnect();
        } else if (command == this.shutdownCommand) {
            this.controller.getPlayer().shutdownSystem();
        } else if (command == this.textCommand) {
            this.controller.showTextForm();
        } else if (command == this.moreCommand) {
            this.controller.showMoreActions();
        } else if (command == this.numericCommand) {
            this.controller.showNumericForm();
        } else if (command == this.browseCommand) {
            this.controller.showBrowseForm();
        } else if (command == this.getItemDataCommand) {
            this.controller.getPlayer().requestItemData();
        }
    }

    public void commandAction(Command command, Item item) {
    }
}

