#include <Python.h>
#include <SDL.h>
#include <pygame.h>
#include <goom_core.h>

#include <config.h>
#include <unistd.h>

#include <getopt.h>

#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>


// a couple of handy macros
#define RAISE(x,y) (PyErr_SetString((x), (y)), (PyObject*)NULL)
#define RETURN_NONE return (Py_INCREF(Py_None), Py_None);

#define INC(x) { Py_XDECREF(x); }
#define DEC(x) { Py_XINCREF(x); }


/* Local Vars */
typedef struct 
{
  int nch;
  int bs;
  unsigned long long count;
} data_t;

SDL_Surface* surf =  NULL;
data_t*   mmap_area;
int16_t   data[ 2 ][ 512 ];
uint32_t  *render_data = NULL;
unsigned long long counter = 0;

int FXMODE = -1;
int init = 0;
int width = 100;
int height = 100;
int cinema = 0;
int fd = 0;
char* sharedfile = NULL;
char* message = NULL;
char* songtitle = NULL;

/* ***** Method Declarations ***************************************************/
int data_import_init(void);
void data_import_clean(void);
int set_resolution(void);

static PyObject* pygoom_set_exportfile(PyObject *self, PyObject *args);
static PyObject* pygoom_set_resolution(PyObject *self, PyObject *args);
static PyObject* pygoom_set_visual(PyObject *self, PyObject *args);
static PyObject* pygoom_set_message(PyObject *self, PyObject *args);
static PyObject* pygoom_set_title(PyObject *self, PyObject *args);
static PyObject* pygoom_get_exportfile(PyObject *self, PyObject *args);
static PyObject* pygoom_cleanup(PyObject *self, PyObject *args);
static PyObject* pygoom_process(PyObject *self, PyObject *args);

/* ***** Python Declarations ***************************************************/
// methods defined by the module
static PyMethodDef pygoomMethods[] = {

 {"set_exportfile", pygoom_set_exportfile, METH_VARARGS, "Set the export file used by MPlayer"},
 {"set_visual",     pygoom_set_visual,     METH_VARARGS, "Set the export file used by MPlayer"},
 {"set_resolution", pygoom_set_resolution, METH_VARARGS, "Get the export file used bu MPlayer"},
 {"set_message",    pygoom_set_message,    METH_VARARGS, "Get the export file used bu MPlayer"},
 {"set_title",      pygoom_set_title,      METH_VARARGS, "Get the export file used bu MPlayer"},
 {"get_exportfile", pygoom_get_exportfile, METH_NOARGS,  "Get the export file used bu MPlayer"},
 {"get_surface",    pygoom_process,        METH_NOARGS,	 "Get the export file used bu MPlayer"},
 {"quit",           pygoom_cleanup,        METH_NOARGS,  "Get the export file used bu MPlayer"},


 { NULL, NULL, 0, NULL }
};



