package junit.test.svg;

import java.awt.Color;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGStopElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGEllipseElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/12/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGStopElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGStopElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try
		{ 
			new SVGStopElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}

		try
		{ 
			node.setAttribute(SVGAttributes.SVG_OFFSET, "dsd");
			new SVGStopElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_OFFSET, "0.5");
			new SVGStopElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetStopColor()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_OFFSET, "0.5");
			SVGStopElement e = new SVGStopElement(node, null);
			assertEquals(e.getStopColor(), Color.BLACK);
			
			node.setAttribute(SVGAttributes.SVG_OFFSET, "0.5");
			node.setAttribute(SVGAttributes.SVG_STOP_COLOR, "blue");
			e = new SVGStopElement(node, null);
			assertEquals(e.getStopColor(), Color.BLUE);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetOffset()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_OFFSET, "0.5");
			SVGStopElement e = new SVGStopElement(node, null);
			assertEquals(e.getOffset(), 0.5);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_OFFSET, "0.5");
			SVGStopElement s = new SVGStopElement(node, null);
			assertTrue(s.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_STOP;
	}
}
