/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcas_modules.h
    \brief  The LCAS authorization plugins/modules should "include" this file.
    \author Martijn Steenbakkers for the EU DataGrid.

    This file includes the header files that are needed by the LCAS authorization
    plugins/modules.
    \ingroup APIforLcasPlugins
*/
/*!
    \defgroup APIforLcasPlugins The API to be used by the LCAS plugins
    \brief The API is available by including the header lcas_modules.h
*/

#ifndef LCAS_MODULES_H
#define LCAS_MODULES_H

/******************************************************************************
                             Include header files
******************************************************************************/

#ifndef NOGLOBUS
    #include <gssapi.h>
#endif /* NOGLOBUS */
#include "lcas_utils.h"
#include "lcas_log.h"
#include "lcas_types.h"
#include "lcas_defines.h"

#endif /* LCAS_MODULES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/interface/lcas_modules.h,v $
    $Date: 2010-05-03 10:43:18 $
    $Revision: 1.3 $
    $Author: okoeroo $
******************************************************************************/
