local l = require "luxio"

local fd, r, errno

fd, errno = l.open("test-lock-file", l.O_RDWR)
assert(fd >= 0)

t = {
   l_type = l.F_WRLCK,
   l_whence = l.SEEK_SET,
   l_start = 0,
   l_len = 4096
}

r, errno = l.fcntl(fd, l.F_GETLK, t)
print("fnctl: r,errno:", r, errno)
print("held by pid, waiting for unlock", t.l_pid)

t.l_type = l.F_WRLCK
r, errno = l.fcntl(fd, l.F_SETLKW, t)
print("fnctl: r,errno:", r, errno)
