/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_m3upi (IcelakeX Uncore M3UPI)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_m3upi_ag0_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag0_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag0_bl_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag0_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag1_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag1_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag1_bl_crd_acquired0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ag1_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_cha_ad_credits_empty[]={
  { .uname   = "REQ",
    .udesc   = "Requests (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "Snoops (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA",
    .udesc   = "VNA Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WB",
    .udesc   = "Writebacks (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_distress_asserted[]={
  { .uname   = "DPT_LOCAL",
    .udesc   = "DPT Local (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_NONLOCAL",
    .udesc   = "DPT Remote (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_IV",
    .udesc   = "DPT Stalled - IV (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_NOCRD",
    .udesc   = "DPT Stalled -  No Credit (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HORZ",
    .udesc   = "Horizontal (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_LOCAL",
    .udesc   = "PMM Local (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_NONLOCAL",
    .udesc   = "PMM Remote (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VERT",
    .udesc   = "Vertical (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_egress_ordering[]={
  { .uname   = "IV_SNOOPGO_DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_SNOOPGO_UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_horz_ring_akc_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_horz_ring_bl_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_horz_ring_iv_in_use[]={
  { .uname   = "LEFT",
    .udesc   = "Left (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT",
    .udesc   = "Right (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_m2_bl_credits_empty[]={
  { .uname   = "IIO1_NCB",
    .udesc   = "IIO0 and IIO1 share the same ring destination. (1 VN0 credit only) (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO2_NCB",
    .udesc   = "IIO2 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO3_NCB",
    .udesc   = "IIO3 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO4_NCB",
    .udesc   = "IIO4 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO5_NCB",
    .udesc   = "IIO5 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS",
    .udesc   = "All IIO targets for NCS are in single mask. ORs them together (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_SEL",
    .udesc   = "Selected M2p BL NCS credits (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UBOX_NCB",
    .udesc   = "IIO5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_misc_external[]={
  { .uname   = "MBE_INST0",
    .udesc   = "Number of cycles MBE is high for MS2IDI0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MBE_INST1",
    .udesc   = "Number of cycles MBE is high for MS2IDI1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_multi_slot_rcvd[]={
  { .uname   = "AD_SLOT0",
    .udesc   = "AD - Slot 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SLOT1",
    .udesc   = "AD - Slot 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SLOT2",
    .udesc   = "AD - Slot 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_SLOT0",
    .udesc   = "AK - Slot 0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_SLOT2",
    .udesc   = "AK - Slot 2 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_SLOT0",
    .udesc   = "BL - Slot 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ring_bounces_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ring_sink_starved_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "Acknowledgements to Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_ring_sink_starved_vert[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "Acknowledgements to core (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "Data Responses to core (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "Snoops of processor's cache. (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_arb_lost_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_arb_misc[]={
  { .uname   = "ADBL_PARALLEL_WIN_VN0",
    .udesc   = "AD, BL Parallel Win VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ADBL_PARALLEL_WIN_VN1",
    .udesc   = "AD, BL Parallel Win VN1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ALL_PARALLEL_WIN",
    .udesc   = "Max Parallel Win (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_PROG_AD_VN0",
    .udesc   = "No Progress on Pending AD VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_PROG_AD_VN1",
    .udesc   = "No Progress on Pending AD VN1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_PROG_BL_VN0",
    .udesc   = "No Progress on Pending BL VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_PROG_BL_VN1",
    .udesc   = "No Progress on Pending BL VN1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN01_PARALLEL_WIN",
    .udesc   = "VN0, VN1 Parallel Win (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_arb_nocrd_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_arb_noreq_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_bypassed[]={
  { .uname   = "AD_S0_BL_ARB",
    .udesc   = "AD to Slot 0 on BL Arb (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_S0_IDLE",
    .udesc   = "AD to Slot 0 on Idle (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_S1_BL_SLOT",
    .udesc   = "AD + BL to Slot 1 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_S2_BL_SLOT",
    .udesc   = "AD + BL to Slot 2 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_crd_misc[]={
  { .uname   = "ANY_BGF_FIFO",
    .udesc   = "Any In BGF FIFO (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY_BGF_PATH",
    .udesc   = "Any in BGF Path (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT1_FOR_D2K",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT2_FOR_D2K",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_NO_D2K_FOR_ARB",
    .udesc   = "No D2K For Arb (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NO_D2K_FOR_ARB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_crd_occ[]={
  { .uname   = "CONSUMED",
    .udesc   = "Credits Consumed (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "D2K_CRD",
    .udesc   = "D2K Credits (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLITS_IN_FIFO",
    .udesc   = "Packets in BGF FIFO (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLITS_IN_PATH",
    .udesc   = "Packets in BGF Path (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_FIFO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_TOTAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TxQ_CRD",
    .udesc   = "Transmit Credits (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA_IN_USE",
    .udesc   = "VNA In Use (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_cycles_ne_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_data_flits_not_sent[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "NO_BGF",
    .udesc   = "No BGF Credits (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_TXQ",
    .udesc   = "No TxQ Credits (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TSV_HI",
    .udesc   = "TSV High (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VALID_FOR_FLIT",
    .udesc   = "Cycle valid for Flit (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_flits_gen_bl[]={
  { .uname   = "P0_WAIT",
    .udesc   = "Wait on Pump 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_AT_LIMIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_BUSY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_FIFO_FULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_HOLD_P0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1P_TO_LIMBO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1_WAIT",
    .udesc   = "Wait on Pump 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_flits_misc[]={
  { .uname   = "S2REQ_IN_HOLDOFF",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2REQ_IN_SERVICE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2REQ_RECEIVED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S2REQ_WITHDRAWN",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_flits_slot_bl[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NEED_DATA",
    .udesc   = "Needs Data Flit (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P0_WAIT",
    .udesc   = "Wait on Pump 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1_NOT_REQ",
    .udesc   = "Don't Need Pump 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1_NOT_REQ_BUT_BUBBLE",
    .udesc   = "Don't Need Pump 1 - Bubble (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1_NOT_REQ_NOT_AVAIL",
    .udesc   = "Don't Need Pump 1 - Not Avail (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "P1_WAIT",
    .udesc   = "Wait on Pump 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_flit_gen_hdr1[]={
  { .uname   = "ACCUM",
    .udesc   = "Accumulate (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ACCUM_READ",
    .udesc   = "Accumulate Ready (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ACCUM_WASTED",
    .udesc   = "Accumulate Wasted (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AHEAD_BLOCKED",
    .udesc   = "Run-Ahead - Blocked (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AHEAD_MSG1_AFTER",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AHEAD_MSG1_DURING",
    .udesc   = "Run-Ahead - Message (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AHEAD_MSG2_AFTER",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AHEAD_MSG2_SENT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_flit_gen_hdr2[]={
  { .uname   = "PAR",
    .udesc   = "Parallel Ok (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PAR_FLIT",
    .udesc   = "Parallel Flit Finished (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PAR_MSG",
    .udesc   = "Parallel Message (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RMSTALL",
    .udesc   = "Rate-matching Stall (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RMSTALL_NOMSG",
    .udesc   = "Rate-matching Stall - No Message (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_hdr_flits_sent[]={
  { .uname   = "1_MSG",
    .udesc   = "One Message (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "1_MSG_VNX",
    .udesc   = "One Message in non-VNA (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "2_MSGS",
    .udesc   = "Two Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "3_MSGS",
    .udesc   = "Three Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOTS_1",
    .udesc   = "One Slot Taken (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOTS_2",
    .udesc   = "Two Slots Taken (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOTS_3",
    .udesc   = "All Slots Taken (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_hdr_flit_not_sent[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_BGF_CRD",
    .udesc   = "No BGF Credits (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_BGF_NO_MSG",
    .udesc   = "No BGF Credits + No Extra Message Slotted (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_TXQ_CRD",
    .udesc   = "No TxQ Credits (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NO_TXQ_NO_MSG",
    .udesc   = "No TxQ Credits + No Extra Message Slotted (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TSV_HI",
    .udesc   = "TSV High (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VALID_FOR_FLIT",
    .udesc   = "Cycle valid for Flit (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_held[]={
  { .uname   = "CANT_SLOT_AD",
    .udesc   = "Can't Slot AD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CANT_SLOT_BL",
    .udesc   = "Can't Slot BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARALLEL_ATTEMPT",
    .udesc   = "Parallel Attempt (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARALLEL_SUCCESS",
    .udesc   = "Parallel Success (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0",
    .udesc   = "VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1",
    .udesc   = "VN1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_inserts_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_occupancy_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_packing_miss_vn1[]={
  { .uname   = "AD_REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS",
    .udesc   = "NCS on BL (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_vna_crd[]={
  { .uname   = "ANY_IN_USE",
    .udesc   = "Any In Use (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CORRECTED",
    .udesc   = "Corrected (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT1",
    .udesc   = "Level < 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT10",
    .udesc   = "Level < 10 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT4",
    .udesc   = "Level < 4 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LT5",
    .udesc   = "Level < 5 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxc_vna_crd_misc[]={
  { .uname   = "REQ_ADBL_ALLOC_L5",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ_VN01_ALLOC_LT10",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_JUST_AD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_JUST_BL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_ONLY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_JUST_AD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_JUST_BL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_ONLY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxr_crd_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IFV",
    .udesc   = "IFV - Credited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxr_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_rxr_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_stall0_no_txr_horz_crd_ad_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag1[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_stall1_no_txr_horz_crd_ad_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_stall1_no_txr_horz_crd_bl_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_ad_flq_bypass[]={
  { .uname   = "AD_SLOT0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SLOT1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_SLOT2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_EARLY_RSP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_ad_flq_cycles_ne[]={
  { .uname   = "VN0_REQ",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_SNP",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_REQ",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_SNP",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_ad_flq_inserts[]={
  { .uname   = "VN0_REQ",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_SNP",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_REQ",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_SNP",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_ad_flq_occupancy[]={
  { .uname   = "VN0_REQ",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_SNP",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_REQ",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_SNP",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_bl_arb_fail[]={
  { .uname   = "VN0_NCB",
    .udesc   = "VN0 NCB Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_NCS",
    .udesc   = "VN0 NCS Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCB",
    .udesc   = "VN1 NCS Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCS",
    .udesc   = "VN1 NCB Messages (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_bl_flq_cycles_ne[]={
  { .uname   = "VN0_REQ",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_SNP",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_REQ",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_SNP",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_bl_flq_inserts[]={
  { .uname   = "VN0_NCB",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_NCS",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 NCS Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 NCB Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCB",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCS",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1_NCB Messages (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1_NCS Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_bl_flq_occupancy[]={
  { .uname   = "VN0_NCB",
    .udesc   = "VN0 NCB Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_NCS",
    .udesc   = "VN0 NCS Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCB",
    .udesc   = "VN1_NCS Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCS",
    .udesc   = "VN1_NCB Messages (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txc_bl_wb_flq_occupancy[]={
  { .uname   = "VN0_LOCAL",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_THROUGH",
    .udesc   = "VN0 WB Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WRPULL",
    .udesc   = "VN0 NCB Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_LOCAL",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_THROUGH",
    .udesc   = "VN1 WB Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WRPULL",
    .udesc   = "VN1_NCS Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_horz_ads_used[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_horz_cycles_full[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_horz_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_horz_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_horz_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_ads_used[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_bypass[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG1",
    .udesc   = "IV - Agent 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_cycles_full1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_cycles_ne0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_inserts1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_occupancy0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_occupancy1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_starved0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_txr_vert_starved1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGC",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_upi_peer_ad_credits_empty[]={
  { .uname   = "VN0_REQ",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_SNP",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_REQ",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_SNP",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA",
    .udesc   = "VNA (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_upi_peer_bl_credits_empty[]={
  { .uname   = "VN0_NCS_NCB",
    .udesc   = "VN0 RSP Messages (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_RSP",
    .udesc   = "VN0 REQ Messages (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN0_WB",
    .udesc   = "VN0 SNP Messages (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_NCS_NCB",
    .udesc   = "VN1 RSP Messages (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_RSP",
    .udesc   = "VN1 REQ Messages (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VN1_WB",
    .udesc   = "VN1 SNP Messages (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VNA",
    .udesc   = "VNA (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vert_ring_akc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vert_ring_bl_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vert_ring_iv_in_use[]={
  { .uname   = "DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vert_ring_tgc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vn0_no_credits[]={
  { .uname   = "NCB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WB",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_vn1_no_credits[]={
  { .uname   = "NCB",
    .udesc   = "WB on BL (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS",
    .udesc   = "NCB on BL (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REQ",
    .udesc   = "REQ on AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSP",
    .udesc   = "RSP on AD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "SNP on AD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WB",
    .udesc   = "RSP on BL (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_wb_occ_compare[]={
  { .uname   = "BOTHNONZERO_RT_EQ_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BOTHNONZERO_RT_EQ_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xa000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BOTHNONZERO_RT_GT_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BOTHNONZERO_RT_GT_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x9000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BOTHNONZERO_RT_LT_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BOTHNONZERO_RT_LT_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0xc000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_EQ_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_EQ_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_GT_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_GT_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_LT_LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RT_LT_LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_wb_pending[]={
  { .uname   = "LOCALDEST_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCALDEST_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_AND_RT_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_AND_RT_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ROUTETHRU_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ROUTETHRU_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WAITING4PULL_VN0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WAITING4PULL_VN1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m3upi_xpt_pftch[]={
  { .uname   = "ARB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ARRIVED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BYPASS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLITTED",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOST_ARB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOST_OLD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOST_QFULL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_m3upi_pe[]={
  { .name   = "UNC_M3UPI_AG0_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0080,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m3upi_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG0_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0081,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m3upi_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG0_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0082,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_ad_crd_occupancy0),
    .umasks = icx_unc_m3upi_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG0_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0083,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_ad_crd_occupancy1),
    .umasks = icx_unc_m3upi_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG0_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0088,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_bl_crd_occupancy0), /* shared */
    .umasks = icx_unc_m3upi_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG0_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0089,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m3upi_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG0_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008a,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_bl_crd_occupancy0),
    .umasks = icx_unc_m3upi_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG0_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008b,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag0_bl_crd_occupancy1),
    .umasks = icx_unc_m3upi_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG1_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0084,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m3upi_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG1_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0085,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m3upi_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG1_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0086,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_ad_crd_occupancy0),
    .umasks = icx_unc_m3upi_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M3UPI_AG1_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0087,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_ad_crd_occupancy1),
    .umasks = icx_unc_m3upi_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG1_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_bl_crd_acquired0),
    .umasks = icx_unc_m3upi_ag1_bl_crd_acquired0,
  },
  { .name   = "UNC_M3UPI_AG1_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m3upi_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_AG1_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall0_no_txr_horz_crd_ad_ag0), /* shared */
    .umasks = icx_unc_m3upi_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M3UPI_AG1_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008f,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ag1_bl_crd_occupancy1),
    .umasks = icx_unc_m3upi_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M3UPI_CHA_AD_CREDITS_EMPTY",
    .desc   = "CBox AD Credits Empty",
    .code   = 0x0022,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_cha_ad_credits_empty),
    .umasks = icx_unc_m3upi_cha_ad_credits_empty,
  },
  { .name   = "UNC_M3UPI_CLOCKTICKS",
    .desc   = "Clockticks of the mesh to UPI (M3UPI)",
    .code   = 0x0001,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_CMS_CLOCKTICKS",
    .desc   = "CMS Clockticks (experimental)",
    .code   = 0x00c0,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_D2C_SENT",
    .desc   = "D2C Sent (experimental)",
    .code   = 0x002b,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_D2U_SENT",
    .desc   = "D2U Sent (experimental)",
    .code   = 0x002a,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_DISTRESS_ASSERTED",
    .desc   = "Distress signal asserted",
    .code   = 0x00af,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_distress_asserted),
    .umasks = icx_unc_m3upi_distress_asserted,
  },
  { .name   = "UNC_M3UPI_EGRESS_ORDERING",
    .desc   = "Egress Blocking due to Ordering requirements",
    .code   = 0x00ba,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_egress_ordering),
    .umasks = icx_unc_m3upi_egress_ordering,
  },
  { .name   = "UNC_M3UPI_HORZ_RING_AD_IN_USE",
    .desc   = "Horizontal AD Ring In Use",
    .code   = 0x00b6,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_horz_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m3upi_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M3UPI_HORZ_RING_AKC_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00bb,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_horz_ring_akc_in_use),
    .umasks = icx_unc_m3upi_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M3UPI_HORZ_RING_AK_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00b7,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_horz_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m3upi_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M3UPI_HORZ_RING_BL_IN_USE",
    .desc   = "Horizontal BL Ring in Use",
    .code   = 0x00b8,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_horz_ring_bl_in_use),
    .umasks = icx_unc_m3upi_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M3UPI_HORZ_RING_IV_IN_USE",
    .desc   = "Horizontal IV Ring in Use",
    .code   = 0x00b9,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_horz_ring_iv_in_use),
    .umasks = icx_unc_m3upi_horz_ring_iv_in_use,
  },
  { .name   = "UNC_M3UPI_M2_BL_CREDITS_EMPTY",
    .desc   = "M2 BL Credits Empty",
    .code   = 0x0023,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_m2_bl_credits_empty),
    .umasks = icx_unc_m3upi_m2_bl_credits_empty,
  },
  { .name   = "UNC_M3UPI_MISC_EXTERNAL",
    .desc   = "Miscellaneous Events (mostly from MS2IDI)",
    .code   = 0x00e6,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_misc_external),
    .umasks = icx_unc_m3upi_misc_external,
  },
  { .name   = "UNC_M3UPI_MULTI_SLOT_RCVD",
    .desc   = "Multi Slot Flit Received",
    .code   = 0x003e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_multi_slot_rcvd),
    .umasks = icx_unc_m3upi_multi_slot_rcvd,
  },
  { .name   = "UNC_M3UPI_RING_BOUNCES_HORZ",
    .desc   = "Messages that bounced on the Horizontal Ring.",
    .code   = 0x00ac,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ring_bounces_horz),
    .umasks = icx_unc_m3upi_ring_bounces_horz,
  },
  { .name   = "UNC_M3UPI_RING_BOUNCES_VERT",
    .desc   = "Messages that bounced on the Vertical Ring.",
    .code   = 0x00aa,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ring_sink_starved_vert), /* shared */
    .umasks = icx_unc_m3upi_ring_sink_starved_vert,
  },
  { .name   = "UNC_M3UPI_RING_SINK_STARVED_HORZ",
    .desc   = "Sink Starvation on Horizontal Ring",
    .code   = 0x00ad,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ring_sink_starved_horz),
    .umasks = icx_unc_m3upi_ring_sink_starved_horz,
  },
  { .name   = "UNC_M3UPI_RING_SINK_STARVED_VERT",
    .desc   = "Sink Starvation on Vertical Ring",
    .code   = 0x00ab,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_ring_sink_starved_vert),
    .umasks = icx_unc_m3upi_ring_sink_starved_vert,
  },
  { .name   = "UNC_M3UPI_RING_SRC_THRTL",
    .desc   = "Source Throttle (experimental)",
    .code   = 0x00ae,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_LOST_VN0",
    .desc   = "Lost Arb for VN0",
    .code   = 0x004b,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_lost_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_arb_lost_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_LOST_VN1",
    .desc   = "Lost Arb for VN1",
    .code   = 0x004c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_lost_vn1),
    .umasks = icx_unc_m3upi_rxc_arb_lost_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_MISC",
    .desc   = "Arb Miscellaneous",
    .code   = 0x004d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_misc),
    .umasks = icx_unc_m3upi_rxc_arb_misc,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_NOCRD_VN0",
    .desc   = "No Credits to Arb for VN0",
    .code   = 0x0047,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_nocrd_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_arb_nocrd_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_NOCRD_VN1",
    .desc   = "No Credits to Arb for VN1",
    .code   = 0x0048,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_nocrd_vn1),
    .umasks = icx_unc_m3upi_rxc_arb_nocrd_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_NOREQ_VN0",
    .desc   = "Can't Arb for VN0",
    .code   = 0x0049,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_noreq_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_arb_noreq_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_ARB_NOREQ_VN1",
    .desc   = "Can't Arb for VN1",
    .code   = 0x004a,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_arb_noreq_vn1),
    .umasks = icx_unc_m3upi_rxc_arb_noreq_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_BYPASSED",
    .desc   = "Ingress Queue Bypasses",
    .code   = 0x0040,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x7ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_bypassed),
    .umasks = icx_unc_m3upi_rxc_bypassed,
  },
  { .name   = "UNC_M3UPI_RxC_CRD_MISC",
    .desc   = "Miscellaneous Credit Events",
    .code   = 0x005f,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_crd_misc),
    .umasks = icx_unc_m3upi_rxc_crd_misc,
  },
  { .name   = "UNC_M3UPI_RxC_CRD_OCC",
    .desc   = "Credit Occupancy",
    .code   = 0x0060,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_crd_occ),
    .umasks = icx_unc_m3upi_rxc_crd_occ,
  },
  { .name   = "UNC_M3UPI_RxC_CYCLES_NE_VN0",
    .desc   = "VN0 Ingress (from CMS) Queue - Cycles Not Empty",
    .code   = 0x0043,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_cycles_ne_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_cycles_ne_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_CYCLES_NE_VN1",
    .desc   = "VN1 Ingress (from CMS) Queue - Cycles Not Empty",
    .code   = 0x0044,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_cycles_ne_vn1),
    .umasks = icx_unc_m3upi_rxc_cycles_ne_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_DATA_FLITS_NOT_SENT",
    .desc   = "Data Flit Not Sent",
    .code   = 0x0055,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_data_flits_not_sent),
    .umasks = icx_unc_m3upi_rxc_data_flits_not_sent,
  },
  { .name   = "UNC_M3UPI_RxC_FLITS_GEN_BL",
    .desc   = "Generating BL Data Flit Sequence",
    .code   = 0x0057,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_flits_gen_bl),
    .umasks = icx_unc_m3upi_rxc_flits_gen_bl,
  },
  { .name   = "UNC_M3UPI_RxC_FLITS_MISC",
    .desc   = "UNC_M3UPI_RxC_FLITS_MISC.S2REQ_RECEIVED",
    .code   = 0x0058,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_flits_misc),
    .umasks = icx_unc_m3upi_rxc_flits_misc,
  },
  { .name   = "UNC_M3UPI_RxC_FLITS_SLOT_BL",
    .desc   = "Slotting BL Message Into Header Flit",
    .code   = 0x0056,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_flits_slot_bl),
    .umasks = icx_unc_m3upi_rxc_flits_slot_bl,
  },
  { .name   = "UNC_M3UPI_RxC_FLIT_GEN_HDR1",
    .desc   = "Flit Gen - Header 1",
    .code   = 0x0051,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_flit_gen_hdr1),
    .umasks = icx_unc_m3upi_rxc_flit_gen_hdr1,
  },
  { .name   = "UNC_M3UPI_RxC_FLIT_GEN_HDR2",
    .desc   = "Flit Gen - Header 2",
    .code   = 0x0052,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_flit_gen_hdr2),
    .umasks = icx_unc_m3upi_rxc_flit_gen_hdr2,
  },
  { .name   = "UNC_M3UPI_RxC_HDR_FLITS_SENT",
    .desc   = "Sent Header Flit",
    .code   = 0x0054,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_hdr_flits_sent),
    .umasks = icx_unc_m3upi_rxc_hdr_flits_sent,
  },
  { .name   = "UNC_M3UPI_RxC_HDR_FLIT_NOT_SENT",
    .desc   = "Header Not Sent",
    .code   = 0x0053,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_hdr_flit_not_sent),
    .umasks = icx_unc_m3upi_rxc_hdr_flit_not_sent,
  },
  { .name   = "UNC_M3UPI_RxC_HELD",
    .desc   = "Message Held",
    .code   = 0x0050,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x7ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_held),
    .umasks = icx_unc_m3upi_rxc_held,
  },
  { .name   = "UNC_M3UPI_RxC_INSERTS_VN0",
    .desc   = "VN0 Ingress (from CMS) Queue - Inserts",
    .code   = 0x0041,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_inserts_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_inserts_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_INSERTS_VN1",
    .desc   = "VN1 Ingress (from CMS) Queue - Inserts",
    .code   = 0x0042,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_inserts_vn1),
    .umasks = icx_unc_m3upi_rxc_inserts_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_OCCUPANCY_VN0",
    .desc   = "VN0 Ingress (from CMS) Queue - Occupancy",
    .code   = 0x0045,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_occupancy_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_occupancy_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_OCCUPANCY_VN1",
    .desc   = "VN1 Ingress (from CMS) Queue - Occupancy",
    .code   = 0x0046,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_occupancy_vn1),
    .umasks = icx_unc_m3upi_rxc_occupancy_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_PACKING_MISS_VN0",
    .desc   = "VN0 message can't slot into flit",
    .code   = 0x004e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x7ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_packing_miss_vn1), /* shared */
    .umasks = icx_unc_m3upi_rxc_packing_miss_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_PACKING_MISS_VN1",
    .desc   = "VN1 message can't slot into flit",
    .code   = 0x004f,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x7ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_packing_miss_vn1),
    .umasks = icx_unc_m3upi_rxc_packing_miss_vn1,
  },
  { .name   = "UNC_M3UPI_RxC_VNA_CRD",
    .desc   = "Remote VNA Credits",
    .code   = 0x005a,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_vna_crd),
    .umasks = icx_unc_m3upi_rxc_vna_crd,
  },
  { .name   = "UNC_M3UPI_RxC_VNA_CRD_MISC",
    .desc   = "UNC_M3UPI_RxC_VNA_CRD_MISC.REQ_VN01_ALLOC_LT10",
    .code   = 0x0059,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxc_vna_crd_misc),
    .umasks = icx_unc_m3upi_rxc_vna_crd_misc,
  },
  { .name   = "UNC_M3UPI_RxR_BUSY_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e5,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_ads_used), /* shared */
    .umasks = icx_unc_m3upi_txr_horz_ads_used,
  },
  { .name   = "UNC_M3UPI_RxR_BYPASS",
    .desc   = "Transgress Ingress Bypass",
    .code   = 0x00e2,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxr_inserts), /* shared */
    .umasks = icx_unc_m3upi_rxr_inserts,
  },
  { .name   = "UNC_M3UPI_RxR_CRD_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e3,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxr_crd_starved),
    .umasks = icx_unc_m3upi_rxr_crd_starved,
  },
  { .name   = "UNC_M3UPI_RxR_CRD_STARVED_1",
    .desc   = "Transgress Injection Starvation (experimental)",
    .code   = 0x00e4,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_RxR_INSERTS",
    .desc   = "Transgress Ingress Allocations",
    .code   = 0x00e1,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxr_inserts),
    .umasks = icx_unc_m3upi_rxr_inserts,
  },
  { .name   = "UNC_M3UPI_RxR_OCCUPANCY",
    .desc   = "Transgress Ingress Occupancy",
    .code   = 0x00e0,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_rxr_occupancy),
    .umasks = icx_unc_m3upi_rxr_occupancy,
  },
  { .name   = "UNC_M3UPI_STALL0_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d0,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall0_no_txr_horz_crd_ad_ag0),
    .umasks = icx_unc_m3upi_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M3UPI_STALL0_NO_TxR_HORZ_CRD_AD_AG1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d2,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag0), /* shared */
    .umasks = icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M3UPI_STALL0_NO_TxR_HORZ_CRD_BL_AG0",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d4,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag0),
    .umasks = icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M3UPI_STALL0_NO_TxR_HORZ_CRD_BL_AG1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d6,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag1),
    .umasks = icx_unc_m3upi_stall0_no_txr_horz_crd_bl_ag1,
  },
  { .name   = "UNC_M3UPI_STALL1_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d1,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall1_no_txr_horz_crd_ad_ag1_1), /* shared */
    .umasks = icx_unc_m3upi_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M3UPI_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d3,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall1_no_txr_horz_crd_ad_ag1_1),
    .umasks = icx_unc_m3upi_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M3UPI_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d5,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall1_no_txr_horz_crd_bl_ag1_1), /* shared */
    .umasks = icx_unc_m3upi_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M3UPI_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d7,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_stall1_no_txr_horz_crd_bl_ag1_1),
    .umasks = icx_unc_m3upi_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M3UPI_TxC_AD_ARB_FAIL",
    .desc   = "Failed ARB for AD",
    .code   = 0x0030,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_ad_flq_cycles_ne), /* shared */
    .umasks = icx_unc_m3upi_txc_ad_flq_cycles_ne,
  },
  { .name   = "UNC_M3UPI_TxC_AD_FLQ_BYPASS",
    .desc   = "AD FlowQ Bypass",
    .code   = 0x002c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_ad_flq_bypass),
    .umasks = icx_unc_m3upi_txc_ad_flq_bypass,
  },
  { .name   = "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE",
    .desc   = "AD Flow Q Not Empty",
    .code   = 0x0027,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_ad_flq_cycles_ne),
    .umasks = icx_unc_m3upi_txc_ad_flq_cycles_ne,
  },
  { .name   = "UNC_M3UPI_TxC_AD_FLQ_INSERTS",
    .desc   = "AD Flow Q Inserts",
    .code   = 0x002d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_ad_flq_inserts),
    .umasks = icx_unc_m3upi_txc_ad_flq_inserts,
  },
  { .name   = "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY",
    .desc   = "AD Flow Q Occupancy",
    .code   = 0x001c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_ad_flq_occupancy),
    .umasks = icx_unc_m3upi_txc_ad_flq_occupancy,
  },
  { .name   = "UNC_M3UPI_TxC_AK_FLQ_INSERTS",
    .desc   = "AK Flow Q Inserts (experimental)",
    .code   = 0x002f,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_TxC_AK_FLQ_OCCUPANCY",
    .desc   = "AK Flow Q Occupancy (experimental)",
    .code   = 0x001e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x1ull,
  },
  { .name   = "UNC_M3UPI_TxC_BL_ARB_FAIL",
    .desc   = "Failed ARB for BL",
    .code   = 0x0035,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_bl_arb_fail),
    .umasks = icx_unc_m3upi_txc_bl_arb_fail,
  },
  { .name   = "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE",
    .desc   = "BL Flow Q Not Empty",
    .code   = 0x0028,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_bl_flq_cycles_ne),
    .umasks = icx_unc_m3upi_txc_bl_flq_cycles_ne,
  },
  { .name   = "UNC_M3UPI_TxC_BL_FLQ_INSERTS",
    .desc   = "BL Flow Q Inserts",
    .code   = 0x002e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_bl_flq_inserts),
    .umasks = icx_unc_m3upi_txc_bl_flq_inserts,
  },
  { .name   = "UNC_M3UPI_TxC_BL_FLQ_OCCUPANCY",
    .desc   = "BL Flow Q Occupancy",
    .code   = 0x001d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_bl_flq_occupancy),
    .umasks = icx_unc_m3upi_txc_bl_flq_occupancy,
  },
  { .name   = "UNC_M3UPI_TxC_BL_WB_FLQ_OCCUPANCY",
    .desc   = "BL Flow Q Occupancy",
    .code   = 0x001f,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txc_bl_wb_flq_occupancy),
    .umasks = icx_unc_m3upi_txc_bl_wb_flq_occupancy,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_ADS_USED",
    .desc   = "CMS Horizontal ADS Used",
    .code   = 0x00a6,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_ads_used),
    .umasks = icx_unc_m3upi_txr_horz_ads_used,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_BYPASS",
    .desc   = "CMS Horizontal Bypass Used",
    .code   = 0x00a7,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_cycles_full), /* shared */
    .umasks = icx_unc_m3upi_txr_horz_cycles_full,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_CYCLES_FULL",
    .desc   = "Cycles CMS Horizontal Egress Queue is Full",
    .code   = 0x00a2,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_cycles_full),
    .umasks = icx_unc_m3upi_txr_horz_cycles_full,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_CYCLES_NE",
    .desc   = "Cycles CMS Horizontal Egress Queue is Not Empty",
    .code   = 0x00a3,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_inserts), /* shared */
    .umasks = icx_unc_m3upi_txr_horz_inserts,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_INSERTS",
    .desc   = "CMS Horizontal Egress Inserts",
    .code   = 0x00a1,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_inserts),
    .umasks = icx_unc_m3upi_txr_horz_inserts,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_NACK",
    .desc   = "CMS Horizontal Egress NACKs",
    .code   = 0x00a4,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_occupancy), /* shared */
    .umasks = icx_unc_m3upi_txr_horz_occupancy,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_OCCUPANCY",
    .desc   = "CMS Horizontal Egress Occupancy",
    .code   = 0x00a0,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_occupancy),
    .umasks = icx_unc_m3upi_txr_horz_occupancy,
  },
  { .name   = "UNC_M3UPI_TxR_HORZ_STARVED",
    .desc   = "CMS Horizontal Egress Injection Starvation",
    .code   = 0x00a5,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_horz_starved),
    .umasks = icx_unc_m3upi_txr_horz_starved,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_ADS_USED",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_ads_used),
    .umasks = icx_unc_m3upi_txr_vert_ads_used,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_BYPASS",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_bypass),
    .umasks = icx_unc_m3upi_txr_vert_bypass,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_BYPASS_1",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_cycles_full1), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_CYCLES_FULL0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0094,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_cycles_ne0), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_CYCLES_FULL1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0095,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_cycles_full1),
    .umasks = icx_unc_m3upi_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_CYCLES_NE0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0096,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_cycles_ne0),
    .umasks = icx_unc_m3upi_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_CYCLES_NE1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0097,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_inserts1), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_inserts1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_INSERTS0",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0092,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_occupancy0), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_occupancy0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_INSERTS1",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0093,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_inserts1),
    .umasks = icx_unc_m3upi_txr_vert_inserts1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_NACK0",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0098,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_starved0), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_starved0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_NACK1",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0099,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_occupancy1), /* shared */
    .umasks = icx_unc_m3upi_txr_vert_occupancy1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_OCCUPANCY0",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0090,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_occupancy0),
    .umasks = icx_unc_m3upi_txr_vert_occupancy0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_OCCUPANCY1",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0091,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_occupancy1),
    .umasks = icx_unc_m3upi_txr_vert_occupancy1,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_STARVED0",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009a,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_starved0),
    .umasks = icx_unc_m3upi_txr_vert_starved0,
  },
  { .name   = "UNC_M3UPI_TxR_VERT_STARVED1",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009b,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_txr_vert_starved1),
    .umasks = icx_unc_m3upi_txr_vert_starved1,
  },
  { .name   = "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY",
    .desc   = "UPI0 AD Credits Empty",
    .code   = 0x0020,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_upi_peer_ad_credits_empty),
    .umasks = icx_unc_m3upi_upi_peer_ad_credits_empty,
  },
  { .name   = "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY",
    .desc   = "UPI0 BL Credits Empty",
    .code   = 0x0021,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_upi_peer_bl_credits_empty),
    .umasks = icx_unc_m3upi_upi_peer_bl_credits_empty,
  },
  { .name   = "UNC_M3UPI_UPI_PREFETCH_SPAWN",
    .desc   = "FlowQ Generated Prefetch (experimental)",
    .code   = 0x0029,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M3UPI_VERT_RING_AD_IN_USE",
    .desc   = "Vertical AD Ring In Use",
    .code   = 0x00b0,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m3upi_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M3UPI_VERT_RING_AKC_IN_USE",
    .desc   = "Vertical AKC Ring In Use",
    .code   = 0x00b4,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_akc_in_use),
    .umasks = icx_unc_m3upi_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M3UPI_VERT_RING_AK_IN_USE",
    .desc   = "Vertical AK Ring In Use",
    .code   = 0x00b1,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m3upi_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M3UPI_VERT_RING_BL_IN_USE",
    .desc   = "Vertical BL Ring in Use",
    .code   = 0x00b2,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_bl_in_use),
    .umasks = icx_unc_m3upi_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M3UPI_VERT_RING_IV_IN_USE",
    .desc   = "Vertical IV Ring in Use",
    .code   = 0x00b3,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_iv_in_use),
    .umasks = icx_unc_m3upi_vert_ring_iv_in_use,
  },
  { .name   = "UNC_M3UPI_VERT_RING_TGC_IN_USE",
    .desc   = "Vertical TGC Ring In Use",
    .code   = 0x00b5,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vert_ring_tgc_in_use),
    .umasks = icx_unc_m3upi_vert_ring_tgc_in_use,
  },
  { .name   = "UNC_M3UPI_VN0_CREDITS_USED",
    .desc   = "VN0 Credit Used",
    .code   = 0x005b,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vn0_no_credits), /* shared */
    .umasks = icx_unc_m3upi_vn0_no_credits,
  },
  { .name   = "UNC_M3UPI_VN0_NO_CREDITS",
    .desc   = "VN0 No Credits",
    .code   = 0x005d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vn0_no_credits),
    .umasks = icx_unc_m3upi_vn0_no_credits,
  },
  { .name   = "UNC_M3UPI_VN1_CREDITS_USED",
    .desc   = "VN1 Credit Used",
    .code   = 0x005c,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vn1_no_credits), /* shared */
    .umasks = icx_unc_m3upi_vn1_no_credits,
  },
  { .name   = "UNC_M3UPI_VN1_NO_CREDITS",
    .desc   = "VN1 No Credits",
    .code   = 0x005e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_vn1_no_credits),
    .umasks = icx_unc_m3upi_vn1_no_credits,
  },
  { .name   = "UNC_M3UPI_WB_OCC_COMPARE",
    .desc   = "UNC_M3UPI_WB_OCC_COMPARE.RT_GT_LOCALDEST_VN0",
    .code   = 0x007e,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_wb_occ_compare),
    .umasks = icx_unc_m3upi_wb_occ_compare,
  },
  { .name   = "UNC_M3UPI_WB_PENDING",
    .desc   = "UNC_M3UPI_WB_PENDING.LOCALDEST_VN0",
    .code   = 0x007d,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_wb_pending),
    .umasks = icx_unc_m3upi_wb_pending,
  },
  { .name   = "UNC_M3UPI_XPT_PFTCH",
    .desc   = "UNC_M3UPI_XPT_PFTCH.ARRIVED",
    .code   = 0x0061,
    .modmsk = ICX_UNC_M3UPI_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m3upi_xpt_pftch),
    .umasks = icx_unc_m3upi_xpt_pftch,
  },
};
/* 130 events available */
