let logic = "logic";;
let symbol = "symbols";;
let fraction = "fractions";;
let letter = "letters";;
let asciiart = "ASCII art";;
let equivalence = "equivalence relations";;
let order = "order relations";;
let circle = "circles";;
let square = "squares";;
let triangle = "triangles";;
let arrow = "arrows";;
let set = "set theory";;
let math = "mathematics";;
let space = "spaces";;
let delimiter = "parentheses and delimiters";;
let miscellanea = "miscellanea";;


let predefined_virtuals = [

(* {{{ logics *)
 ["\\not"; "\\neg"; "\\lnot"                           ], "¬", [logic];
 ["\\ForAll"; "\\forall"                              ], "∀", [logic];
 ["\\exist"; "\\Exists"; "\\exists"                    ], "∃", [logic];
 ["\\nexist"; "\\nexists"; "\\NotExists"               ], "∄", [logic];
 ["\\and"; "\\land"; "\\wedge"                         ], "∧", [logic];
 ["\\or"; "\\vee"; "\\lor"                             ], "∨", [logic];
 ["\\vdash"; "\\RightTee"                             ], "⊢", [logic];
 ["\\dashv"; "\\LeftTee"                              ], "⊣", [logic];
 ["\\top"; "\\DownTee"                                ], "⊤", [logic];
 ["\\bot"; "\\perp"; "\\UpTee"; "\\bottom"              ], "⊥", [logic];
 ["\\models"                                         ], "⊧", [logic];
 ["\\vDash"; "\\DoubleRightTee"                       ], "⊨", [logic];
 ["\\Vdash"                                          ], "⊩", [logic];
 ["\\Vvdash"                                         ], "⊪", [logic];
 ["\\VDash"                                          ], "⊫", [logic];
 ["\\nvdash"                                         ], "⊬", [logic];
 ["\\nvDash"                                         ], "⊭", [logic];
 ["\\nVdash"                                         ], "⊮", [logic];
 ["\\nVDash"                                         ], "⊯", [logic];
 ["\\Wedge"; "\\xwedge"; "\\bigwedge"                  ], "⋀", [logic];
 ["\\Vee"; "\\xvee"; "\\bigvee"                        ], "⋁", [logic];
(* }}} *)

(* {{{ symbols *)
 ["\\cent"                                           ], "¢", [symbol];
 ["\\pound"                                          ], "£", [symbol];
 ["\\curren"                                         ], "¤", [symbol];
 ["\\yen"                                            ], "¥", [symbol];
 ["\\brvbar"                                         ], "¦", [symbol];
 ["\\sect"                                           ], "§", [symbol];
 ["\\uml"; "\\die"; "\\Dot"; "\\DoubleDot"              ], "¨", [symbol];
 ["\\macr"; "\\OverBar"                               ], "¯", [symbol];
 ["\\sup"                                           ], "^", [symbol];
 ["\\sup2"                                           ], "²", [symbol];
 ["\\sup3"                                           ], "³", [symbol];
 ["\\acute"; "\\DiacriticalAcute"                     ], "´", [symbol];
 ["\\para"                                           ], "¶", [symbol];
 ["\\middot"; "\\centerdot"; "\\CenterDot"             ], "·", [symbol];
 ["\\cedil"; "\\Cedilla"                              ], "¸", [symbol];
 ["\\sup1"                                           ], "¹", [symbol];
 ["\\iquest"                                         ], "¿", [symbol];
 ["\\thorn"                                          ], "þ", [symbol];
 ["\\imath"; "\\inodot"                               ], "ı", [symbol];
 ["\\Hacek"; "\\caron"                                ], "ˇ", [symbol];
 ["\\Breve"; "\\breve"                                ], "˘", [symbol];
 ["\\dot"; "\\DiacriticalDot"                         ], "˙", [symbol];
 ["\\ogon"                                           ], "˛", [symbol];
 ["\\tilde"; "\\DiacriticalTilde"                     ], "˜", [symbol];
 ["\\dblac"; "\\DiacriticalDoubleAcute"               ], "˝", [symbol];
 ["\\Hat"                                            ], "̂", [symbol];
 ["\\DownBreve"                                      ], "̑", [symbol];
 ["\\UnderBar"                                       ], "̲", [symbol];
 ["\\dash"; "\\hyphen"                                ], "‐", [symbol];
 ["\\ndash"                                          ], "–", [symbol];
 ["\\mdash"                                          ], "—", [symbol];
 ["\\horbar"                                         ], "―", [symbol];
 ["\\Vert"; "\\Verbar"                                ], "‖", [symbol];
 ["\\lsquo"; "\\OpenCurlyQuote"                       ], "‘", [symbol];
 ["\\rsquo"; "\\rsquor"; "\\CloseCurlyQuote"           ], "’", [symbol];
 ["\\lsquor"                                         ], "‚", [symbol];
 ["\\ldquo"; "\\OpenCurlyDoubleQuote"                 ], "“", [symbol];
 ["\\rdquo"; "\\rdquor"; "\\CloseCurlyDoubleQuote"     ], "”", [symbol];
 ["\\ldquor"                                         ], "„", [symbol];
 ["\\dagger"                                         ], "†", [symbol];
 ["\\Dagger"; "\\ddagger"                             ], "‡", [symbol];
 ["\\nldr"                                           ], "‥", [symbol];
 ["\\mldr"; "\\dots"; "\\ldots"; "\\hellip"             ], "…", [symbol];
 ["\\prime"                                          ], "′", [symbol];
 ["\\Prime"                                          ], "″", [symbol];
 ["\\tprime"                                         ], "‴", [symbol];
 ["\\bprime"; "\\backprime"                           ], "‵", [symbol];
 ["\\caret"                                          ], "⁁", [symbol];
 ["\\hybull"                                         ], "⁃", [symbol];
 ["\\bsemi"                                          ], "⁏", [symbol];
 ["\\qprime"                                         ], "⁗", [symbol];
 ["\\MediumSpace"                                    ], " ", [symbol];
 ["\\tdot"; "\\TripleDot"                             ], "⃛", [symbol];
 ["\\DotDot"                                         ], "⃜", [symbol];
 ["\\minus"                                          ], "−", [symbol];
 ["\\angrt"                                          ], "∟", [symbol];
 ["\\ang"; "\\angle"                                  ], "∠", [symbol];
 ["\\nang"                                           ], "∠̸", [symbol];
 ["\\angmsd"; "\\measuredangle"                       ], "∡", [symbol];
 ["\\angsph"                                         ], "∢", [symbol];
 ["\\par"; "\\parallel"; "\\DoubleVerticalBar"         ], "∥", [symbol];
 ["\\there4"; "\\Therefore"; "\\therefore"             ], "∴", [symbol];
 ["\\becaus"; "\\because"; "\\Because"                 ], "∵", [symbol];
 ["\\ratio"                                          ], "∶", [symbol];
 ["\\Colon"; "\\Proportion"                           ], "∷", [symbol];
 ["\\minusd"; "\\dotminus"                            ], "∸", [symbol];
 ["\\mDDot"                                          ], "∺", [symbol];
 ["\\homtht"                                         ], "∻", [symbol];
 ["\\sim"; "\\Tilde"                                  ], "∼", [symbol];
 ["\\mstpos"                                         ], "∾", [symbol];
 ["\\acd"                                            ], "∿", [symbol];
 ["\\wr"; "\\wreath"; "\\VerticalTilde"                ], "≀", [symbol];
 ["\\origof"                                         ], "⊶", [symbol];
 ["\\imof"                                           ], "⊷", [symbol];
 ["\\mumap"; "\\multimap"                             ], "⊸", [symbol];
 ["\\hercon"                                         ], "⊹", [symbol];
 ["\\intcal"; "\\intercal"                            ], "⊺", [symbol];
 ["\\veebar"                                         ], "⊻", [symbol];
 ["\\barwed"; "\\barwedge"                            ], "⊼", [symbol];
 ["\\barvee"                                         ], "⊽", [symbol];
 ["\\vangrt"                                         ], "⊾", [symbol];
 ["\\lrtri"                                          ], "⊿", [symbol];
 ["\\diam"; "\\Diamond"; "\\diamond"                   ], "⋄", [symbol];
 ["\\sdot"                                           ], "⋅", [symbol];
 ["\\Star"; "\\star"; "\\sstarf"                       ], "⋆", [symbol];
 ["\\divonx"; "\\divideontimes"                       ], "⋇", [symbol];
 ["\\bowtie"                                         ], "⋈", [symbol];
 ["\\ltimes"                                         ], "⋉", [symbol];
 ["\\rtimes"                                         ], "⋊", [symbol];
 ["\\lthree"; "\\leftthreetimes"                      ], "⋋", [symbol];
 ["\\rthree"; "\\rightthreetimes"                     ], "⋌", [symbol];
 ["\\cuvee"; "\\curlyvee"                             ], "⋎", [symbol];
 ["\\cuwed"; "\\curlywedge"                           ], "⋏", [symbol];
 ["\\fork"; "\\pitchfork"                             ], "⋔", [symbol];
 ["\\epar"                                           ], "⋕", [symbol];
 ["\\vdots"; "\\vellip"                               ], "⋮", [symbol];
 ["\\cdots"; "\\ctdot"                                ], "⋯", [symbol];
 ["\\utdot"                                          ], "⋰", [symbol];
 ["\\ddots"; "\\dtdot"                                ], "⋱", [symbol];
 ["\\Barwed"; "\\doublebarwedge"                      ], "⌆", [symbol];
 ["\\bnot"                                           ], "⌐", [symbol];
 ["\\profline"                                       ], "⌒", [symbol];
 ["\\profsurf"                                       ], "⌓", [symbol];
 ["\\telrec"                                         ], "⌕", [symbol];
 ["\\frown"                                          ], "⌢", [symbol];
 ["\\smile"                                          ], "⌣", [symbol];
 ["\\blank"                                          ], "␣", [symbol];
 ["\\HorizontalLine"                                 ], "─", [symbol];
 ["\\loz"; "\\lozenge";"<>"                                ], "◊", [symbol];
 ["\\starf"; "\\bigstar"                              ], "★", [symbol];
 ["\\phone"                                          ], "☎", [symbol];
 ["\\female"                                         ], "♀", [symbol];
 ["\\male"                                           ], "♂", [symbol];
 ["\\spades"; "\\spadesuit"                           ], "♠", [symbol];
 ["\\heartsuit"                                      ], "♡", [symbol];
 ["\\diamondsuit"                                    ], "♢", [symbol];
 ["\\clubs"; "\\clubsuit"                             ], "♣", [symbol];
 ["\\diams"                                          ], "♦", [symbol];
 ["\\sung"                                           ], "♪", [symbol];
 ["\\flat"                                           ], "♭", [symbol];
 ["\\natur"; "\\natural"                              ], "♮", [symbol];
 ["\\sharp"                                          ], "♯", [symbol];
 ["\\check"; "\\checkmark"                            ], "✓", [symbol];
 ["\\cross"                                          ], "✗", [symbol];
 ["\\malt"; "\\maltese"                               ], "✠", [symbol];
 ["\\sext"                                           ], "✶", [symbol];
 ["\\VerticalSeparator"                              ], "❘", [symbol];
 ["\\lozf"; "\\blacklozenge"                          ], "⧫", [symbol];
 ["\\OverParenthesis"                                ], "︵", [symbol];
 ["\\UnderParenthesis"                               ], "︶", [symbol];
 ["\\OverBrace"                                      ], "︷", [symbol];
 ["\\UnderBrace"                                     ], "︸", [symbol];
 ["\\Yang"                                           ], "⚊", [symbol];
(* }}} *)

(* {{{ fraction *)
 ["\\frac14"                                         ], "¼", [fraction];
 ["\\half"; "\\frac"                                  ], "½", [fraction];
 ["\\frac34"                                         ], "¾", [fraction];
 ["\\permil"                                         ], "‰", [fraction];
 ["\\pertenk"                                        ], "‱", [fraction];
 ["\\incare"                                         ], "℅", [fraction];
 ["\\frac13"                                         ], "⅓", [fraction];
 ["\\frac23"                                         ], "⅔", [fraction];
 ["\\frac15"                                         ], "⅕", [fraction];
 ["\\frac25"                                         ], "⅖", [fraction];
 ["\\frac35"                                         ], "⅗", [fraction];
 ["\\frac45"                                         ], "⅘", [fraction];
 ["\\frac16"                                         ], "⅙", [fraction];
 ["\\frac56"                                         ], "⅚", [fraction];
 ["\\frac18"                                         ], "⅛", [fraction];
 ["\\frac38"                                         ], "⅜", [fraction];
 ["\\frac58"                                         ], "⅝", [fraction];
 ["\\frac78"                                         ], "⅞", [fraction];
(* }}} *)

(* {{{ letters *)
 ["\\iexcl"                                          ], "¡", [letter];
 ["\\ordf"                                           ], "ª", [letter];
 ["\\micro"                                          ], "µ", [letter];
 ["\\Agrave"                                         ], "À", [letter];
 ["\\Aacute"                                         ], "Á", [letter];
 ["\\Acirc"                                          ], "Â", [letter];
 ["\\Atilde"                                         ], "Ã", [letter];
 ["\\Auml"                                           ], "Ä", [letter];
 ["\\Aring"                                          ], "Å", [letter];
 ["\\AElig"                                          ], "Æ", [letter];
 ["\\Ccedil"                                         ], "Ç", [letter];
 ["\\Egrave"                                         ], "È", [letter];
 ["\\Eacute"                                         ], "É", [letter];
 ["\\Ecirc"                                          ], "Ê", [letter];
 ["\\Euml"                                           ], "Ë", [letter];
 ["\\Igrave"                                         ], "Ì", [letter];
 ["\\Iacute"                                         ], "Í", [letter];
 ["\\Icirc"                                          ], "Î", [letter];
 ["\\Iuml"                                           ], "Ï", [letter];
 ["\\ETH"                                            ], "Ð", [letter];
 ["\\Ntilde"                                         ], "Ñ", [letter];
 ["\\Ograve"                                         ], "Ò", [letter];
 ["\\Oacute"                                         ], "Ó", [letter];
 ["\\Ocirc"                                          ], "Ô", [letter];
 ["\\Otilde"                                         ], "Õ", [letter];
 ["\\Ouml"                                           ], "Ö", [letter];
 ["\\Oslash"                                         ], "Ø", [letter];
 ["\\Ugrave"                                         ], "Ù", [letter];
 ["\\Uacute"                                         ], "Ú", [letter];
 ["\\Ucirc"                                          ], "Û", [letter];
 ["\\Uuml"                                           ], "Ü", [letter];
 ["\\Yacute"                                         ], "Ý", [letter];
 ["\\THORN"                                          ], "Þ", [letter];
 ["\\szlig"                                          ], "ß", [letter];
 ["\\agrave"                                         ], "à", [letter];
 ["\\aacute"                                         ], "á", [letter];
 ["\\acirc"                                          ], "â", [letter];
 ["\\atilde"                                         ], "ã", [letter];
 ["\\auml"                                           ], "ä", [letter];
 ["\\aring"                                          ], "å", [letter];
 ["\\aelig"                                          ], "æ", [letter];
 ["\\ccedil"                                         ], "ç", [letter];
 ["\\egrave"                                         ], "è", [letter];
 ["\\eacute"                                         ], "é", [letter];
 ["\\ecirc"                                          ], "ê", [letter];
 ["\\euml"                                           ], "ë", [letter];
 ["\\igrave"                                         ], "ì", [letter];
 ["\\iacute"                                         ], "í", [letter];
 ["\\icirc"                                          ], "î", [letter];
 ["\\iuml"                                           ], "ï", [letter];
 ["\\eth"                                            ], "ð", [letter];
 ["\\ntilde"                                         ], "ñ", [letter];
 ["\\ograve"                                         ], "ò", [letter];
 ["\\oacute"                                         ], "ó", [letter];
 ["\\ocirc"                                          ], "ô", [letter];
 ["\\otilde"                                         ], "õ", [letter];
 ["\\ouml"                                           ], "ö", [letter];
 ["\\ugrave"                                         ], "ù", [letter];
 ["\\uacute"                                         ], "ú", [letter];
 ["\\ucirc"                                          ], "û", [letter];
 ["\\uuml"                                           ], "ü", [letter];
 ["\\yacute"                                         ], "ý", [letter];
 ["\\yuml"                                           ], "ÿ", [letter];
 ["\\Amacr"                                          ], "Ā", [letter];
 ["\\amacr"                                          ], "ā", [letter];
 ["\\Abreve"                                         ], "Ă", [letter];
 ["\\abreve"                                         ], "ă", [letter];
 ["\\Aogon"                                          ], "Ą", [letter];
 ["\\aogon"                                          ], "ą", [letter];
 ["\\Cacute"                                         ], "Ć", [letter];
 ["\\cacute"                                         ], "ć", [letter];
 ["\\Ccirc"                                          ], "Ĉ", [letter];
 ["\\ccirc"                                          ], "ĉ", [letter];
 ["\\Cdot"                                           ], "Ċ", [letter];
 ["\\cdot"                                           ], "ċ", [letter];
 ["\\Ccaron"                                         ], "Č", [letter];
 ["\\ccaron"                                         ], "č", [letter];
 ["\\Dcaron"                                         ], "Ď", [letter];
 ["\\dcaron"                                         ], "ď", [letter];
 ["\\Dstrok"                                         ], "Đ", [letter];
 ["\\dstrok"                                         ], "đ", [letter];
 ["\\Emacr"                                          ], "Ē", [letter];
 ["\\emacr"                                          ], "ē", [letter];
 ["\\Edot"                                           ], "Ė", [letter];
 ["\\edot"                                           ], "ė", [letter];
 ["\\Eogon"                                          ], "Ę", [letter];
 ["\\eogon"                                          ], "ę", [letter];
 ["\\Ecaron"                                         ], "Ě", [letter];
 ["\\ecaron"                                         ], "ě", [letter];
 ["\\Gcirc"                                          ], "Ĝ", [letter];
 ["\\gcirc"                                          ], "ĝ", [letter];
 ["\\Gbreve"                                         ], "Ğ", [letter];
 ["\\gbreve"                                         ], "ğ", [letter];
 ["\\Gdot"                                           ], "Ġ", [letter];
 ["\\gdot"                                           ], "ġ", [letter];
 ["\\Gcedil"                                         ], "Ģ", [letter];
 ["\\Hcirc"                                          ], "Ĥ", [letter];
 ["\\hcirc"                                          ], "ĥ", [letter];
 ["\\Hstrok"                                         ], "Ħ", [letter];
 ["\\hstrok"                                         ], "ħ", [letter];
 ["\\Itilde"                                         ], "Ĩ", [letter];
 ["\\itilde"                                         ], "ĩ", [letter];
 ["\\Imacr"                                          ], "Ī", [letter];
 ["\\imacr"                                          ], "ī", [letter];
 ["\\Iogon"                                          ], "Į", [letter];
 ["\\iogon"                                          ], "į", [letter];
 ["\\Idot"                                           ], "İ", [letter];
 ["\\IJlig"                                          ], "Ĳ", [letter];
 ["\\ijlig"                                          ], "ĳ", [letter];
 ["\\Jcirc"                                          ], "Ĵ", [letter];
 ["\\jcirc"                                          ], "ĵ", [letter];
 ["\\Kcedil"                                         ], "Ķ", [letter];
 ["\\kcedil"                                         ], "ķ", [letter];
 ["\\kgreen"                                         ], "ĸ", [letter];
 ["\\Lacute"                                         ], "Ĺ", [letter];
 ["\\lacute"                                         ], "ĺ", [letter];
 ["\\Lcedil"                                         ], "Ļ", [letter];
 ["\\lcedil"                                         ], "ļ", [letter];
 ["\\Lcaron"                                         ], "Ľ", [letter];
 ["\\lcaron"                                         ], "ľ", [letter];
 ["\\Lmidot"                                         ], "Ŀ", [letter];
 ["\\lmidot"                                         ], "ŀ", [letter];
 ["\\Lstrok"                                         ], "Ł", [letter];
 ["\\lstrok"                                         ], "ł", [letter];
 ["\\Nacute"                                         ], "Ń", [letter];
 ["\\nacute"                                         ], "ń", [letter];
 ["\\Ncedil"                                         ], "Ņ", [letter];
 ["\\ncedil"                                         ], "ņ", [letter];
 ["\\Ncaron"                                         ], "Ň", [letter];
 ["\\ncaron"                                         ], "ň", [letter];
 ["\\napos"                                          ], "ŉ", [letter];
 ["\\ENG"                                            ], "Ŋ", [letter];
 ["\\eng"                                            ], "ŋ", [letter];
 ["\\Omacr"                                          ], "Ō", [letter];
 ["\\omacr"                                          ], "ō", [letter];
 ["\\Odblac"                                         ], "Ő", [letter];
 ["\\odblac"                                         ], "ő", [letter];
 ["\\OElig"                                          ], "Œ", [letter];
 ["\\oelig"                                          ], "œ", [letter];
 ["\\Racute"                                         ], "Ŕ", [letter];
 ["\\racute"                                         ], "ŕ", [letter];
 ["\\Rcedil"                                         ], "Ŗ", [letter];
 ["\\rcedil"                                         ], "ŗ", [letter];
 ["\\Rcaron"                                         ], "Ř", [letter];
 ["\\rcaron"                                         ], "ř", [letter];
 ["\\Sacute"                                         ], "Ś", [letter];
 ["\\sacute"                                         ], "ś", [letter];
 ["\\Scirc"                                          ], "Ŝ", [letter];
 ["\\scirc"                                          ], "ŝ", [letter];
 ["\\Scedil"                                         ], "Ş", [letter];
 ["\\scedil"                                         ], "ş", [letter];
 ["\\Scaron"                                         ], "Š", [letter];
 ["\\scaron"                                         ], "š", [letter];
 ["\\Tcedil"                                         ], "Ţ", [letter];
 ["\\tcedil"                                         ], "ţ", [letter];
 ["\\Tcaron"                                         ], "Ť", [letter];
 ["\\tcaron"                                         ], "ť", [letter];
 ["\\Tstrok"                                         ], "Ŧ", [letter];
 ["\\tstrok"                                         ], "ŧ", [letter];
 ["\\Utilde"                                         ], "Ũ", [letter];
 ["\\utilde"                                         ], "ũ", [letter];
 ["\\Umacr"                                          ], "Ū", [letter];
 ["\\umacr"                                          ], "ū", [letter];
 ["\\Ubreve"                                         ], "Ŭ", [letter];
 ["\\ubreve"                                         ], "ŭ", [letter];
 ["\\Uring"                                          ], "Ů", [letter];
 ["\\uring"                                          ], "ů", [letter];
 ["\\Udblac"                                         ], "Ű", [letter];
 ["\\udblac"                                         ], "ű", [letter];
 ["\\Uogon"                                          ], "Ų", [letter];
 ["\\uogon"                                          ], "ų", [letter];
 ["\\Wcirc"                                          ], "Ŵ", [letter];
 ["\\wcirc"                                          ], "ŵ", [letter];
 ["\\Ycirc"                                          ], "Ŷ", [letter];
 ["\\ycirc"                                          ], "ŷ", [letter];
 ["\\Yuml"                                           ], "Ÿ", [letter];
 ["\\Zacute"                                         ], "Ź", [letter];
 ["\\zacute"                                         ], "ź", [letter];
 ["\\Zdot"                                           ], "Ż", [letter];
 ["\\zdot"                                           ], "ż", [letter];
 ["\\Zcaron"                                         ], "Ž", [letter];
 ["\\zcaron"                                         ], "ž", [letter];
 ["\\fnof"                                           ], "ƒ", [letter];
 ["\\gacute"                                         ], "ǵ", [letter];
 ["\\epsiv"                                          ], "ɛ", [letter];
 ["\\Gamma"                                          ], "Γ", [letter];
 ["\\Delta"                                          ], "Δ", [letter];
 ["\\Theta"                                          ], "Θ", [letter];
 ["\\Lambda"                                         ], "Λ", [letter];
 ["\\Xi"                                             ], "Ξ", [letter];
 ["\\Pi"                                             ], "Π", [letter];
 ["\\Sigma"                                          ], "Σ", [letter];
 ["\\Phi"                                            ], "Φ", [letter];
 ["\\Psi"                                            ], "Ψ", [letter];
 ["\\Omega"                                          ], "Ω", [letter];
 ["\\alpha"                                          ], "α", [letter];
 ["\\beta"                                           ], "β", [letter];
 ["\\gamma"                                          ], "γ", [letter];
 ["\\delta"                                          ], "δ", [letter];
 ["\\epsi"; "\\varepsilon"; "\\straightepsilon"        ], "ε", [letter];
 ["\\zeta"                                           ], "ζ", [letter];
 ["\\eta"                                            ], "η", [letter];
 ["\\theta"                                          ], "θ", [letter];
 ["\\iota"                                           ], "ι", [letter];
 ["\\kappa"                                          ], "κ", [letter];
 ["\\lambda"                                         ], "λ", [letter];
 ["\\mu"                                             ], "μ", [letter];
 ["\\nu"                                             ], "ν", [letter];
 ["\\xi"                                             ], "ξ", [letter];
 ["\\o"                                              ], "ο", [letter];
 ["\\pi"                                             ], "π", [letter];
 ["\\rho"                                            ], "ρ", [letter];
 ["\\sigmav"; "\\varsigma"                            ], "ς", [letter];
 ["\\sigma"                                          ], "σ", [letter];
 ["\\tau"                                            ], "τ", [letter];
 ["\\upsi"; "\\upsilon"                               ], "υ", [letter];
 ["\\varphi"; "\\straightphi"                         ], "φ", [letter];
 ["\\chi"                                            ], "χ", [letter];
 ["\\psi"                                            ], "ψ", [letter];
 ["\\omega"                                          ], "ω", [letter];
 ["\\thetav"; "\\vartheta"                            ], "ϑ", [letter];
 ["\\Upsi"; "\\Upsilon"                               ], "ϒ", [letter];
 ["\\phi"; "\\phiv"                                   ], "ϕ", [letter];
 ["\\piv"; "\\varpi"                                  ], "ϖ", [letter];
 ["\\Gammad"; "\\gammad"; "\\digamma"                  ], "Ϝ", [letter];
 ["\\kappav"; "\\varkappa"                            ], "ϰ", [letter];
 ["\\rhov"; "\\varrho"                                ], "ϱ", [letter];
 ["\\epsilon"                                        ], "ϵ", [letter];
 ["\\bepsi"; "\\backepsilon"                          ], "϶", [letter];
 ["\\IOcy"                                           ], "Ё", [letter];
 ["\\DJcy"                                           ], "Ђ", [letter];
 ["\\GJcy"                                           ], "Ѓ", [letter];
 ["\\Jukcy"                                          ], "Є", [letter];
 ["\\DScy"                                           ], "Ѕ", [letter];
 ["\\Iukcy"                                          ], "І", [letter];
 ["\\YIcy"                                           ], "Ї", [letter];
 ["\\Jsercy"                                         ], "Ј", [letter];
 ["\\LJcy"                                           ], "Љ", [letter];
 ["\\NJcy"                                           ], "Њ", [letter];
 ["\\TSHcy"                                          ], "Ћ", [letter];
 ["\\KJcy"                                           ], "Ќ", [letter];
 ["\\Ubrcy"                                          ], "Ў", [letter];
 ["\\DZcy"                                           ], "Џ", [letter];
 ["\\Acy"                                            ], "А", [letter];
 ["\\Bcy"                                            ], "Б", [letter];
 ["\\Vcy"                                            ], "В", [letter];
 ["\\Gcy"                                            ], "Г", [letter];
 ["\\Dcy"                                            ], "Д", [letter];
 ["\\IEcy"                                           ], "Е", [letter];
 ["\\ZHcy"                                           ], "Ж", [letter];
 ["\\Zcy"                                            ], "З", [letter];
 ["\\Icy"                                            ], "И", [letter];
 ["\\Jcy"                                            ], "Й", [letter];
 ["\\Kcy"                                            ], "К", [letter];
 ["\\Lcy"                                            ], "Л", [letter];
 ["\\Mcy"                                            ], "М", [letter];
 ["\\Ncy"                                            ], "Н", [letter];
 ["\\Ocy"                                            ], "О", [letter];
 ["\\Pcy"                                            ], "П", [letter];
 ["\\Rcy"                                            ], "Р", [letter];
 ["\\Scy"                                            ], "С", [letter];
 ["\\Tcy"                                            ], "Т", [letter];
 ["\\Ucy"                                            ], "У", [letter];
 ["\\Fcy"                                            ], "Ф", [letter];
 ["\\KHcy"                                           ], "Х", [letter];
 ["\\TScy"                                           ], "Ц", [letter];
 ["\\CHcy"                                           ], "Ч", [letter];
 ["\\SHcy"                                           ], "Ш", [letter];
 ["\\SHCHcy"                                         ], "Щ", [letter];
 ["\\HARDcy"                                         ], "Ъ", [letter];
 ["\\Ycy"                                            ], "Ы", [letter];
 ["\\SOFTcy"                                         ], "Ь", [letter];
 ["\\Ecy"                                            ], "Э", [letter];
 ["\\YUcy"                                           ], "Ю", [letter];
 ["\\YAcy"                                           ], "Я", [letter];
 ["\\acy"                                            ], "а", [letter];
 ["\\bcy"                                            ], "б", [letter];
 ["\\vcy"                                            ], "в", [letter];
 ["\\gcy"                                            ], "г", [letter];
 ["\\dcy"                                            ], "д", [letter];
 ["\\iecy"                                           ], "е", [letter];
 ["\\zhcy"                                           ], "ж", [letter];
 ["\\zcy"                                            ], "з", [letter];
 ["\\icy"                                            ], "и", [letter];
 ["\\jcy"                                            ], "й", [letter];
 ["\\kcy"                                            ], "к", [letter];
 ["\\lcy"                                            ], "л", [letter];
 ["\\mcy"                                            ], "м", [letter];
 ["\\ncy"                                            ], "н", [letter];
 ["\\ocy"                                            ], "о", [letter];
 ["\\pcy"                                            ], "п", [letter];
 ["\\rcy"                                            ], "р", [letter];
 ["\\scy"                                            ], "с", [letter];
 ["\\tcy"                                            ], "т", [letter];
 ["\\ucy"                                            ], "у", [letter];
 ["\\fcy"                                            ], "ф", [letter];
 ["\\khcy"                                           ], "х", [letter];
 ["\\tscy"                                           ], "ц", [letter];
 ["\\chcy"                                           ], "ч", [letter];
 ["\\shcy"                                           ], "ш", [letter];
 ["\\shchcy"                                         ], "щ", [letter];
 ["\\hardcy"                                         ], "ъ", [letter];
 ["\\ycy"                                            ], "ы", [letter];
 ["\\softcy"                                         ], "ь", [letter];
 ["\\ecy"                                            ], "э", [letter];
 ["\\yucy"                                           ], "ю", [letter];
 ["\\yacy"                                           ], "я", [letter];
 ["\\iocy"                                           ], "ё", [letter];
 ["\\djcy"                                           ], "ђ", [letter];
 ["\\gjcy"                                           ], "ѓ", [letter];
 ["\\jukcy"                                          ], "є", [letter];
 ["\\dscy"                                           ], "ѕ", [letter];
 ["\\iukcy"                                          ], "і", [letter];
 ["\\yicy"                                           ], "ї", [letter];
 ["\\jsercy"                                         ], "ј", [letter];
 ["\\ljcy"                                           ], "љ", [letter];
 ["\\njcy"                                           ], "њ", [letter];
 ["\\tshcy"                                          ], "ћ", [letter];
 ["\\kjcy"                                           ], "ќ", [letter];
 ["\\ubrcy"                                          ], "ў", [letter];
 ["\\dzcy"                                           ], "џ", [letter];
 ["\\Copf"; "\\complexes"                             ], "ℂ", [letter];
 ["\\gscr"                                           ], "ℊ", [letter];
 ["\\Hscr"; "\\hamilt"; "\\HilbertSpace"               ], "ℋ", [letter];
 ["\\Hfr"; "\\Poincareplane"                          ], "ℌ", [letter];
 ["\\Hopf"; "\\quaternions"                           ], "ℍ", [letter];
 ["\\planckh"                                        ], "ℎ", [letter];
 ["\\hslash"; "\\plankv"                              ], "ℏ", [letter];
 ["\\hbar"; "\\planck"                                ], "ℏ︀", [letter];
 ["\\Iscr"; "\\imagline"                              ], "ℐ", [letter];
 ["\\Im"; "\\Ifr"; "\\image"; "\\imagpart"              ], "ℑ", [letter];
 ["\\Lscr"; "\\lagran"; "\\Laplacetrf"                 ], "ℒ", [letter];
 ["\\ell"; "\\lscr"                                   ], "ℓ", [letter];
 ["\\Nopf"; "\\naturals"                              ], "ℕ", [letter];
 ["\\numero"                                         ], "№", [letter];
 ["\\copysr"                                         ], "℗", [letter];
 ["\\wp"; "\\weierp"                                  ], "℘", [letter];
 ["\\Popf"; "\\primes"                                ], "ℙ", [letter];
 ["\\Qopf"; "\\rationals"                             ], "ℚ", [letter];
 ["\\Rscr"; "\\realine"                               ], "ℛ", [letter];
 ["\\Re"; "\\Rfr"; "\\real"; "\\realpart"               ], "ℜ", [letter];
 ["\\Ropf"; "\\reals"                                 ], "ℝ", [letter];
 ["\\rx"                                             ], "℞", [letter];
 ["\\trade"                                          ], "™", [letter];
 ["\\Zopf"; "\\integers"                              ], "ℤ", [letter];
 ["\\ohm"                                            ], "Ω", [letter];
 ["\\mho"                                            ], "℧", [letter];
 ["\\Zfr"; "\\zeetrf"                                 ], "ℨ", [letter];
 ["\\iiota"                                          ], "℩", [letter];
 ["\\angst"                                          ], "Å", [letter];
 ["\\Bscr"; "\\bernou"; "\\Bernoullis"                 ], "ℬ", [letter];
 ["\\Cfr"; "\\Cayleys"                                ], "ℭ", [letter];
 ["\\escr"                                           ], "ℯ", [letter];
 ["\\Escr"; "\\expectation"                           ], "ℰ", [letter];
 ["\\Fscr"; "\\Fouriertrf"                            ], "ℱ", [letter];
 ["\\Mscr"; "\\phmmat"; "\\Mellintrf"                  ], "ℳ", [letter];
 ["\\oscr"; "\\order"; "\\orderof"                     ], "ℴ", [letter];
 ["\\aleph"                                          ], "ℵ", [letter];
 ["\\beth"                                           ], "ℶ", [letter];
 ["\\gimel"                                          ], "ℷ", [letter];
 ["\\daleth"                                         ], "ℸ", [letter];
 ["\\DD"; "\\CapitalDifferentialD"                    ], "ⅅ", [letter];
 ["\\dd"; "\\DifferentialD"                           ], "ⅆ", [letter];
 ["\\ee"; "\\exponentiale"; "\\ExponentialE"           ], "ⅇ", [letter];
 ["\\ii"; "\\ImaginaryI"                              ], "ⅈ", [letter];
 ["\\comp"; "\\complement"                            ], "∁", [letter];
 ["\\part"; "\\partial"; "\\PartialD"                  ], "∂", [letter];
 ["\\npart"                                          ], "∂̸", [letter];
 ["\\easter"                                         ], "≛", [letter];
 ["\\fpartint"                                       ], "⨍", [letter];
 ["\\fflig"                                          ], "ﬀ", [letter];
 ["\\filig"                                          ], "ﬁ", [letter];
 ["\\fllig"                                          ], "ﬂ", [letter];
 ["\\ffilig"                                         ], "ﬃ", [letter];
 ["\\ffllig"                                         ], "ﬄ", [letter];
 ["\\Aopf"                                           ], "𝔸", [letter];
 ["\\Bopf"                                           ], "𝔹", [letter];
 ["\\Dopf"                                           ], "𝔻", [letter];
 ["\\Eopf"                                           ], "𝔼", [letter];
 ["\\Fopf"                                           ], "𝔽", [letter];
 ["\\Gopf"                                           ], "𝔾", [letter];
 ["\\Iopf"                                           ], "𝕀", [letter];
 ["\\Jopf"                                           ], "𝕁", [letter];
 ["\\Kopf"                                           ], "𝕂", [letter];
 ["\\Lopf"; "\\imped"                                 ], "𝕃", [letter];
 ["\\Mopf"                                           ], "𝕄", [letter];
 ["\\Oopf"                                           ], "𝕆", [letter];
 ["\\Sopf"                                           ], "𝕊", [letter];
 ["\\Topf"                                           ], "𝕋", [letter];
 ["\\Uopf"                                           ], "𝕌", [letter];
 ["\\Vopf"                                           ], "𝕍", [letter];
 ["\\Wopf"                                           ], "𝕎", [letter];
 ["\\Xopf"                                           ], "𝕏", [letter];
 ["\\Yopf"                                           ], "𝕐", [letter];
 ["\\aopf"                                           ], "𝕒", [letter];
 ["\\bopf"                                           ], "𝕓", [letter];
 ["\\copf"                                           ], "𝕔", [letter];
 ["\\dopf"                                           ], "𝕕", [letter];
 ["\\eopf"                                           ], "𝕖", [letter];
 ["\\fopf"                                           ], "𝕗", [letter];
 ["\\gopf"                                           ], "𝕘", [letter];
 ["\\hopf"                                           ], "𝕙", [letter];
 ["\\iopf"                                           ], "𝕚", [letter];
 ["\\jopf"                                           ], "𝕛", [letter];
 ["\\kopf"                                           ], "𝕜", [letter];
 ["\\lopf"                                           ], "𝕝", [letter];
 ["\\mopf"                                           ], "𝕞", [letter];
 ["\\nopf"                                           ], "𝕟", [letter];
 ["\\oopf"                                           ], "𝕠", [letter];
 ["\\popf"                                           ], "𝕡", [letter];
 ["\\qopf"                                           ], "𝕢", [letter];
 ["\\ropf"                                           ], "𝕣", [letter];
 ["\\sopf"                                           ], "𝕤", [letter];
 ["\\topf"                                           ], "𝕥", [letter];
 ["\\uopf"                                           ], "𝕦", [letter];
 ["\\vopf"                                           ], "𝕧", [letter];
 ["\\wopf"                                           ], "𝕨", [letter];
 ["\\xopf"                                           ], "𝕩", [letter];
 ["\\yopf"                                           ], "𝕪", [letter];
 ["\\zopf"                                           ], "𝕫", [letter];
(* }}} *)

(* {{{ ASCII art *)
 ["\\lceil"; "\\LeftCeiling"                          ], "⌈", [asciiart];
 ["\\rceil"; "\\RightCeiling"                         ], "⌉", [asciiart];
 ["\\lfloor"; "\\LeftFloor"                           ], "⌊", [asciiart];
 ["\\rfloor"; "\\RightFloor"                          ], "⌋", [asciiart];
 ["\\drcrop"                                         ], "⌌", [asciiart];
 ["\\dlcrop"                                         ], "⌍", [asciiart];
 ["\\urcrop"                                         ], "⌎", [asciiart];
 ["\\ulcrop"                                         ], "⌏", [asciiart];
 ["\\ulcorn"; "\\ulcorner"                            ], "⌜", [asciiart];
 ["\\urcorn"; "\\urcorner"                            ], "⌝", [asciiart];
 ["\\dlcorn"; "\\llcorner"                            ], "⌞", [asciiart];
 ["\\drcorn"; "\\lrcorner"                            ], "⌟", [asciiart];
 ["\\boxh"                                           ], "─", [asciiart];
 ["\\boxv"                                           ], "│", [asciiart];
 ["\\boxdr"                                          ], "┌", [asciiart];
 ["\\boxdl"                                          ], "┐", [asciiart];
 ["\\boxur"                                          ], "└", [asciiart];
 ["\\boxul"                                          ], "┘", [asciiart];
 ["\\boxvr"                                          ], "├", [asciiart];
 ["\\boxvl"                                          ], "┤", [asciiart];
 ["\\boxhd"                                          ], "┬", [asciiart];
 ["\\boxhu"                                          ], "┴", [asciiart];
 ["\\boxvh"                                          ], "┼", [asciiart];
 ["\\boxH"                                           ], "═", [asciiart];
 ["\\boxV"                                           ], "║", [asciiart];
 ["\\boxdR"                                          ], "╒", [asciiart];
 ["\\boxDr"                                          ], "╓", [asciiart];
 ["\\boxDR"                                          ], "╔", [asciiart];
 ["\\boxdL"                                          ], "╕", [asciiart];
 ["\\boxDl"                                          ], "╖", [asciiart];
 ["\\boxDL"                                          ], "╗", [asciiart];
 ["\\boxuR"                                          ], "╘", [asciiart];
 ["\\boxUr"                                          ], "╙", [asciiart];
 ["\\boxUR"                                          ], "╚", [asciiart];
 ["\\boxuL"                                          ], "╛", [asciiart];
 ["\\boxUl"                                          ], "╜", [asciiart];
 ["\\boxUL"                                          ], "╝", [asciiart];
 ["\\boxvR"                                          ], "╞", [asciiart];
 ["\\boxVr"                                          ], "╟", [asciiart];
 ["\\boxVR"                                          ], "╠", [asciiart];
 ["\\boxvL"                                          ], "╡", [asciiart];
 ["\\boxVl"                                          ], "╢", [asciiart];
 ["\\boxVL"                                          ], "╣", [asciiart];
 ["\\boxHd"                                          ], "╤", [asciiart];
 ["\\boxhD"                                          ], "╥", [asciiart];
 ["\\boxHD"                                          ], "╦", [asciiart];
 ["\\boxHu"                                          ], "╧", [asciiart];
 ["\\boxhU"                                          ], "╨", [asciiart];
 ["\\boxHU"                                          ], "╩", [asciiart];
 ["\\boxvH"                                          ], "╪", [asciiart];
 ["\\boxVh"                                          ], "╫", [asciiart];
 ["\\boxVH"                                          ], "╬", [asciiart];
 ["\\block"                                          ], "█", [asciiart];
 ["\\blk14"                                          ], "░", [asciiart];
 ["\\blk12"                                          ], "▒", [asciiart];
 ["\\blk34"                                          ], "▓", [asciiart];
(* }}} *)

(* {{{ equivalence *)
 ["\\bsim"; "\\backsim"                               ], "∽", [equivalence];
 ["\\nsim"; "\\NotTilde"                              ], "≁", [equivalence];
 ["\\nvsim"                                          ], "≁̸", [equivalence];
 ["\\esim"; "\\eqsim"; "\\EqualTilde"                  ], "≂", [equivalence];
 ["\\nesim"; "\\NotEqualTilde"                        ], "≂̸", [equivalence];
 ["\\sime"; "\\simeq"; "\\TildeEqual"                  ], "≃", [equivalence];
 ["\\nsime"; "\\nsimeq"; "\\NotTildeEqual"             ], "≄", [equivalence];
 ["\\cong"; "\\TildeFullEqual"                        ], "≅", [equivalence];
 ["\\simne"                                          ], "≆", [equivalence];
 ["\\ncong"; "\\NotTildeFullEqual"                    ], "≇", [equivalence];
 ["\\ap"; "\\approx"; "\\TildeTilde"                   ], "≈", [equivalence];
 ["\\nap"; "\\napprox"; "\\NotTildeTilde"              ], "≉", [equivalence];
 ["\\nvap"                                           ], "≉̸", [equivalence];
 ["\\apE"; "\\ape"; "\\approxeq"                       ], "≊", [equivalence];
 ["\\apid"                                           ], "≋", [equivalence];
 ["\\napid"                                          ], "≋̸", [equivalence];
 ["\\bcong"; "\\backcong"                             ], "≌", [equivalence];
 ["\\asymp"; "\\CupCap"                               ], "≍", [equivalence];
 ["\\bump"; "\\Bumpeq"; "\\HumpDownHump"               ], "≎", [equivalence];
 ["\\nbump"; "\\NotHumpDownHump"                      ], "≎̸", [equivalence];
 ["\\bumpe"; "\\bumpeq"; "\\HumpEqual"                 ], "≏", [equivalence];
 ["\\nbumpe"; "\\NotHumpEqual"                        ], "≏̸", [equivalence];
 ["\\esdot"; "\\doteq"; "\\DotEqual"                   ], "≐", [equivalence];
 ["\\eDot"; "\\doteqdot"                              ], "≑", [equivalence];
 ["\\efDot"; "\\fallingdotseq"                        ], "≒", [equivalence];
 ["\\erDot"; "\\risingdotseq"                         ], "≓", [equivalence];
 ["\\colone"; "\\Assign"; "\\coloneq"                  ], "≔", [equivalence];
 ["\\ecolon"; "\\eqcolon"                             ], "≕", [equivalence];
 ["\\ecir"; "\\eqcirc"                                ], "≖", [equivalence];
 ["\\cire"; "\\circeq"                                ], "≗", [equivalence];
 ["\\wedgeq"                                         ], "≙", [equivalence];
 ["\\veeeq"                                          ], "≚", [equivalence];
 ["\\trie"; "\\triangleq"                             ], "≜", [equivalence];
 ["\\def";":=" ], "≝", [equivalence];
 ["\\equest"; "\\questeq"                             ], "≟", [equivalence];
 ["\\ne"; "\\neq"; "\\NotEqual"                        ], "≠", [equivalence];
 ["\\equiv"; "\\Congruent"                            ], "≡", [equivalence];
 ["\\nequiv"; "\\NotCongruent"                        ], "≢", [equivalence];
 ["\\NotCupCap"                                      ], "≭", [equivalence];
 ["\\bsime"; "\\backsimeq"                            ], "⋍", [equivalence];
 ["\\bumpE"                                          ], "⪮", [equivalence];
(* }}} *)

(* {{{ order *)
 ["\\le"; "\\leq";"<="                                 ], "≤", [order];
 ["\\ge"; "\\geq"; "\\GreaterEqual"                    ], "≥", [order];
 ["\\lE"; "\\leqq"; "\\LessFullEqual"                  ], "≦", [order];
 ["\\gE"; "\\geqq"; "\\GreaterFullEqual"               ], "≧", [order];
 ["\\lnE"; "\\lne"; "\\lneq"; "\\lneqq"                 ], "≨", [order];
 ["\\gnE"; "\\gne"; "\\gneq"; "\\gneqq"                 ], "≩", [order];
 ["\\Lt"; "\\ll"; "\\NestedLessLess"                   ], "≪", [order];
 ["\\nLt"                                            ], "≪̸", [order];
 ["\\gg"; "\\Gt"; "\\NestedGreaterGreater"             ], "≫", [order];
 ["\\nGt"                                            ], "≫̸", [order];
 ["\\nlt"; "\\nvlt"; "\\nless"; "\\NotLess"             ], "≮", [order];
 ["\\ngt"; "\\ngtr"; "\\nvgt"; "\\NotGreater"           ], "≯", [order];
 ["\\nlE"; "\\nleq"; "\\nvle"; "\\nles"; "\\nleqq"; "\\nleqslant"; "\\NotLessSlantEqual"; "\\NotGreaterFullEqual"], "≰", [order];
 ["\\ngE"; "\\nges"; "\\nvge"; "\\ngeq"; "\\ngeqq"; "\\ngeqslant"; "\\NotGreaterSlantEqual"], "≱", [order];
 ["\\lap"; "\\lsim"; "\\lesssim"; "\\LessTilde"; "\\lessapprox"    ], "≲", [order];
 ["\\gap"; "\\gsim"; "\\gtrsim"; "\\gtrapprox"; "\\GreaterTilde"   ], "≳", [order];
 ["\\nlsim"; "\\NotLessTilde"                         ], "≴", [order];
 ["\\ngsim"; "\\NotGreaterTilde"                      ], "≵", [order];
 ["\\lessgtr"; "\\LessGreater"                        ], "≶", [order];
 ["\\gl"; "\\gtrless"; "\\GreaterLess"                 ], "≷", [order];
 ["\\ntlg"; "\\NotLessGreater"                        ], "≸", [order];
 ["\\ntgl"; "\\NotGreaterLess"                        ], "≹", [order];
 ["\\pr"; "\\prec"; "\\Precedes"                       ], "≺", [order];
 ["\\sc"; "\\succ"; "\\Succeeds"                       ], "≻", [order];
 ["\\prcue"; "\\preccurlyeq"; "\\PrecedesSlantEqual"   ], "≼", [order];
 ["\\sce"; "\\sccue"; "\\succeq"; "\\succcurlyeq"; "\\SucceedsEqual"; "\\SucceedsSlantEqual"], "≽", [order];
 ["\\scE"; "\\prap"; "\\prsim"; "\\precsim"; "\\precapprox"; "\\PrecedesTilde"], "≾", [order];
 ["\\scap"; "\\scsim"; "\\succsim"; "\\succapprox"; "\\SucceedsTilde"], "≿", [order];
 ["\\NotSucceedsTilde"                               ], "≿̸", [order];
 ["\\npr"; "\\nprec"; "\\NotPrecedes"                  ], "⊀", [order];
 ["\\nsc"; "\\nsucc"; "\\NotSucceeds"                  ], "⊁", [order];
 ["\\ltdot"; "\\lessdot"                              ], "⋖", [order];
 ["\\gtdot"; "\\gtrdot"                               ], "⋗", [order];
 ["\\Ll"                                             ], "⋘", [order];
 ["\\nLl"                                            ], "⋘̸", [order];
 ["\\Gg"; "\\ggg"                                     ], "⋙", [order];
 ["\\nGg"                                            ], "⋙̸", [order];
 ["\\lEg"; "\\leg"; "\\lesseqgtr"; "\\lesseqqgtr"; "\\LessEqualGreater"], "⋚", [order];
 ["\\gEl"; "\\gel"; "\\gtreqless"; "\\gtreqqless"; "\\GreaterEqualLess"], "⋛", [order];
 ["\\els"; "\\eqslantless"                            ], "⋜", [order];
 ["\\egs"; "\\eqslantgtr"                             ], "⋝", [order];
 ["\\cuepr"; "\\curlyeqprec"                          ], "⋞", [order];
 ["\\cuesc"; "\\curlyeqsucc"                          ], "⋟", [order];
 ["\\nprcue"; "\\NotPrecedesSlantEqual"               ], "⋠", [order];
 ["\\nsccue"; "\\NotSucceedsSlantEqual"               ], "⋡", [order];
 ["\\lnsim"                                          ], "⋦", [order];
 ["\\gnsim"                                          ], "⋧", [order];
 ["\\prnap"; "\\prnsim"; "\\precnsim"; "\\precnapprox"  ], "⋨", [order];
 ["\\scnap"; "\\scnsim"; "\\succnsim"; "\\succnapprox"  ], "⋩", [order];
 ["\\gtrarr"                                         ], "⥸", [order];
 ["\\les"; "\\leqslant"; "\\LessSlantEqual"            ], "⩽", [order];
 ["\\ges"; "\\geqslant"; "\\GreaterSlantEqual"         ], "⩾", [order];
 ["\\lesdot"                                         ], "⩿", [order];
 ["\\gesdot"                                         ], "⪀", [order];
 ["\\lesdoto"                                        ], "⪁", [order];
 ["\\gesdoto"                                        ], "⪂", [order];
 ["\\lesdotor"                                       ], "⪃", [order];
 ["\\gesdotol"                                       ], "⪄", [order];
 ["\\lnap"; "\\lnapprox"                              ], "⪉", [order];
 ["\\gnap"; "\\gnapprox"                              ], "⪊", [order];
 ["\\lsime"                                          ], "⪍", [order];
 ["\\gsime"                                          ], "⪎", [order];
 ["\\lsimg"                                          ], "⪏", [order];
 ["\\gsiml"                                          ], "⪐", [order];
 ["\\lgE"                                            ], "⪑", [order];
 ["\\glE"                                            ], "⪒", [order];
 ["\\lesges"                                         ], "⪓", [order];
 ["\\gesles"                                         ], "⪔", [order];
 ["\\elsdot"                                         ], "⪗", [order];
 ["\\egsdot"                                         ], "⪘", [order];
 ["\\el"                                             ], "⪙", [order];
 ["\\eg"                                             ], "⪚", [order];
 ["\\siml"                                           ], "⪝", [order];
 ["\\simg"                                           ], "⪞", [order];
 ["\\simlE"                                          ], "⪟", [order];
 ["\\simgE"                                          ], "⪠", [order];
 ["\\prE"; "\\pre"; "\\preceq"; "\\PrecedesEqual"       ], "⪯", [order];
 ["\\npre"; "\\npreceq"; "\\NotPrecedesEqual"          ], "⪯̸", [order];
 ["\\nsce"; "\\nsucceq"; "\\NotSucceedsEqual"          ], "⪰̸", [order];
 ["\\prnE"; "\\precneqq"                              ], "⪵", [order];
 ["\\scnE"; "\\succneqq"                              ], "⪶", [order];
(* }}} *)

(* {{{ circles *)
 ["\\copy"                                           ], "©", [circle];
 ["\\reg"; "\\circledR"                               ], "®", [circle];
 ["\\ordm"                                           ], "º", [circle];
 ["\\oslash"                                         ], "ø", [circle];
 ["\\ring"                                           ], "˚", [circle];
 ["\\bull"; "\\bullet"                                ], "•", [circle];
 ["\\circ"; "\\compfn"; "\\SmallCircle"                ], "∘", [circle];
 ["\\oplus"; "\\xoplus"; "\\bigoplus"; "\\CirclePlus"   ], "⊕", [circle];
 ["\\ominus"; "\\CircleMinus"                         ], "⊖", [circle];
 ["\\xotime"; "\\otimes"; "\\bigotimes"; "\\CircleTimes"], "⊗", [circle];
 ["\\osol"                                           ], "⊘", [circle];
 ["\\odot"; "\\xodot"; "\\bigodot"; "\\CircleDot"       ], "⊙", [circle];
 ["\\ocir"; "\\circledcirc"                           ], "⊚", [circle];
 ["\\oast"; "\\circledast"                            ], "⊛", [circle];
 ["\\odash"; "\\circleddash"                          ], "⊝", [circle];
 ["\\ovbar"                                          ], "⌽", [circle];
 ["\\NotNestedLessLess"                              ], "⒡̸", [circle];
 ["\\NotNestedGreaterGreater"                        ], "⒢̸", [circle];
 ["\\oS"; "\\circledS"                                ], "Ⓢ", [circle];
 ["\\cir";                                            ], "○", [circle];
 ["\\xcirc"; "\\bigcirc"                              ], "◯", [circle];
(* }}} *)

(* {{{ squares *)
 ["\\plusb"; "\\boxplus"                              ], "⊞", [square];
 ["\\minusb"; "\\boxminus"                            ], "⊟", [square];
 ["\\timesb"; "\\boxtimes"                            ], "⊠", [square];
 ["\\sdotb"; "\\dotsquare"                            ], "⊡", [square];
 ["\\uhblk"                                          ], "▀", [square];
 ["\\lhblk"                                          ], "▄", [square];
 ["\\squ"; "\\square"; "\\Square";"[]"                      ], "□", [square];
 ["\\squf"; "\\squarf"; "\\blacksquare"                ], "▪", [square];
 ["\\rect"                                           ], "▭", [square];
 ["\\marker"                                         ], "▮", [square];
 ["\\EmptySmallSquare"                               ], "◽", [square];
 ["\\FilledSmallSquare"                              ], "◾", [square];
(* }}} *)

(* {{{ triangles *)
 ["\\Del"; "\\nabla"                                  ], "∇", [triangle];
 ["\\vltri"; "\\LeftTriangle"; "\\vartriangleleft"     ], "⊲", [triangle];
 ["\\vrtri"; "\\RightTriangle"; "\\vartriangleright"   ], "⊳", [triangle];
 ["\\ltrie"; "\\trianglelefteq"; "\\LeftTriangleEqual" ], "⊴", [triangle];
 ["\\rtrie"; "\\trianglerighteq"; "\\RightTriangleEqual"         ], "⊵", [triangle];
 ["\\nltri"; "\\ntriangleleft"; "\\NotLeftTriangle"    ], "⋪", [triangle];
 ["\\nrtri"; "\\ntriangleright"; "\\NotRightTriangle"  ], "⋫", [triangle];
 ["\\nltrie"; "\\ntrianglelefteq"; "\\NotLeftTriangleEqual"      ], "⋬", [triangle];
 ["\\nvltrie"                                        ], "⋬̸", [triangle];
 ["\\nrtrie"; "\\ntrianglerighteq"; "\\NotRightTriangleEqual"    ], "⋭", [triangle];
 ["\\nvrtrie"                                        ], "⋭̸", [triangle];
 ["\\xutri"; "\\bigtriangleup"                        ], "△", [triangle];
 ["\\utrif"; "\\blacktriangle"                        ], "▴", [triangle];
 ["\\utri"; "\\triangle"                              ], "▵", [triangle];
 ["\\rtrif"; "\\blacktriangleright"                   ], "▸", [triangle];
 ["\\rtri"; "\\triangleright"                         ], "▹", [triangle];
 ["\\xdtri"; "\\bigtriangledown"                      ], "▽", [triangle];
 ["\\dtrif"; "\\blacktriangledown"                    ], "▾", [triangle];
 ["\\dtri"; "\\triangledown"                          ], "▿", [triangle];
 ["\\ltrif"; "\\blacktriangleleft"                    ], "◂", [triangle];
 ["\\ltri"; "\\triangleleft"                          ], "◃", [triangle];
 ["\\tridot"                                         ], "◬", [triangle];
 ["\\ultri"                                          ], "◸", [triangle];
 ["\\urtri"                                          ], "◹", [triangle];
 ["\\lltri"                                          ], "◺", [triangle];
 ["\\rtriltri"                                       ], "⧎", [triangle];
 ["\\LeftTriangleBar"                                ], "⧏", [triangle];
 ["\\NotLeftTriangleBar"                             ], "⧏̸", [triangle];
 ["\\RightTriangleBar"                               ], "⧐", [triangle];
 ["\\NotRightTriangleBar"                            ], "⧐̸", [triangle];
(* }}} *)

(* {{{ arrows *)
 ["\\larr"; "\\gets"; "\\leftarrow"; "\\LeftArrow"      ], "←", [arrow];
 ["\\uarr"; "\\UpArrow"; "\\uparrow"                   ], "↑", [arrow];
 ["\\to"; "\\rarr"; "\\RightArrow"; "\\rightarrow";"->"], "→", [arrow];
 ["\\darr"; "\\downarrow"; "\\DownArrow"               ], "↓", [arrow];
 ["\\harr"; "\\LeftRightArrow"; "\\leftrightarrow"     ], "↔", [arrow];
 ["\\varr"; "\\updownarrow"; "\\UpDownArrow"           ], "↕", [arrow];
 ["\\nwarr"; "\\nwarrow"; "\\UpperLeftArrow"           ], "↖", [arrow];
 ["\\nearr"; "\\nearrow"; "\\UpperRightArrow"          ], "↗", [arrow];
 ["\\searr"; "\\searrow"; "\\LowerRightArrow"          ], "↘", [arrow];
 ["\\swarr"; "\\swarrow"; "\\LowerLeftArrow"           ], "↙", [arrow];
 ["\\nlarr"; "\\nleftarrow"                           ], "↚", [arrow];
 ["\\nrarr"; "\\nrightarrow"                          ], "↛", [arrow];
 ["\\rarrw"; "\\rightsquigarrow"                      ], "↝", [arrow];
 ["\\nrarrw"                                         ], "↝̸", [arrow];
 ["\\Larr"; "\\twoheadleftarrow"                      ], "↞", [arrow];
 ["\\Uarr"                                           ], "↟", [arrow];
 ["\\Rarr"; "\\twoheadrightarrow"                     ], "↠", [arrow];
 ["\\Darr"                                           ], "↡", [arrow];
 ["\\larrtl"; "\\leftarrowtail"                       ], "↢", [arrow];
 ["\\ratail"; "\\rarrtl"; "\\rightarrowtail"           ], "↣", [arrow];
 ["\\mapstoleft"; "\\LeftTeeArrow"                    ], "↤", [arrow];
 ["\\mapstoup"; "\\UpTeeArrow"                        ], "↥", [arrow];
 ["\\map"; "\\mapsto"; "\\RightTeeArrow"               ], "↦", [arrow];
 ["\\mapstodown"; "\\DownTeeArrow"                    ], "↧", [arrow];
 ["\\larrhk"; "\\hookleftarrow"                       ], "↩", [arrow];
 ["\\rarrhk"; "\\hookrightarrow"                      ], "↪", [arrow];
 ["\\larrlp"; "\\looparrowleft"                       ], "↫", [arrow];
 ["\\rarrlp"; "\\looparrowright"                      ], "↬", [arrow];
 ["\\harrw"; "\\leftrightsquigarrow"                  ], "↭", [arrow];
 ["\\nharr"; "\\nleftrightarrow"                      ], "↮", [arrow];
 ["\\Lsh"; "\\lsh"                                    ], "↰", [arrow];
 ["\\Rsh"; "\\rsh"                                    ], "↱", [arrow];
 ["\\ldsh"                                           ], "↲", [arrow];
 ["\\rdsh"                                           ], "↳", [arrow];
 ["\\cularr"; "\\curvearrowleft"                      ], "↶", [arrow];
 ["\\curarr"; "\\curvearrowright"                     ], "↷", [arrow];
 ["\\olarr"; "\\circlearrowleft"                      ], "↺", [arrow];
 ["\\orarr"; "\\circlearrowright"                     ], "↻", [arrow];
 ["\\lharu"; "\\LeftVector"; "\\leftharpoonup"         ], "↼", [arrow];
 ["\\lhard"; "\\DownLeftVector"; "\\leftharpoondown"   ], "↽", [arrow];
 ["\\uharr"; "\\RightUpVector"; "\\upharpoonright"     ], "↾", [arrow];
 ["\\uharl"; "\\LeftUpVector"; "\\upharpoonleft"       ], "↿", [arrow];
 ["\\rharu"; "\\RightVector"; "\\rightharpoonup"       ], "⇀", [arrow];
 ["\\rhard"; "\\DownRightVector"; "\\rightharpoondown" ], "⇁", [arrow];
 ["\\dharr"; "\\RightDownVector"; "\\downharpoonright" ], "⇂", [arrow];
 ["\\dharl"; "\\LeftDownVector"; "\\downharpoonleft"   ], "⇃", [arrow];
 ["\\rlarr"; "\\rightleftarrows"; "\\RightArrowLeftArrow"        ], "⇄", [arrow];
 ["\\udarr"; "\\UpArrowDownArrow"                     ], "⇅", [arrow];
 ["\\lrarr"; "\\leftrightarrows"; "\\LeftArrowRightArrow"        ], "⇆", [arrow];
 ["\\llarr"; "\\leftleftarrows"                       ], "⇇", [arrow];
 ["\\uuarr"; "\\upuparrows"                           ], "⇈", [arrow];
 ["\\rrarr"; "\\rightrightarrows"                     ], "⇉", [arrow];
 ["\\ddarr"; "\\downdownarrows"                       ], "⇊", [arrow];
 ["\\lrhar"; "\\leftrightharpoons"; "\\ReverseEquilibrium"       ], "⇋", [arrow];
 ["\\rlhar"; "\\Equilibrium"; "\\rightleftharpoons"    ], "⇌", [arrow];
 ["\\nlArr"; "\\nvlArr"; "\\nLeftarrow"                ], "⇍", [arrow];
 ["\\nhArr"; "\\nvHarr"; "\\nLeftrightarrow"           ], "⇎", [arrow];
 ["\\nrArr"; "\\nvrArr"; "\\nRightarrow"               ], "⇏", [arrow];
 ["\\lArr"; "\\Leftarrow"; "\\DoubleLeftArrow"         ], "⇐", [arrow];
 ["\\uArr"; "\\Uparrow"; "\\DoubleUpArrow"             ], "⇑", [arrow];
 ["\\rArr"; "\\Implies"; "\\Rightarrow"; "\\Longrightarrow"; "\\DoubleRightArrow"; "=>"], "⇒", [arrow];
 ["\\dArr"; "\\Downarrow"; "\\DoubleDownArrow"         ], "⇓", [arrow];
 ["\\iff"; "\\hArr"; "\\Leftrightarrow"; "\\DoubleLeftRightArrow" ], "⇔", [arrow];
 ["\\vArr"; "\\Updownarrow"; "\\DoubleUpDownArrow"     ], "⇕", [arrow];
 ["\\nwArr"                                          ], "⇖", [arrow];
 ["\\neArr"                                          ], "⇗", [arrow];
 ["\\seArr"                                          ], "⇘", [arrow];
 ["\\swArr"                                          ], "⇙", [arrow];
 ["\\lAarr"; "\\Lleftarrow"                           ], "⇚", [arrow];
 ["\\rAarr"; "\\Rrightarrow"                          ], "⇛", [arrow];
 ["\\zigrarr"                                        ], "⇝", [arrow];
 ["\\larrb"; "\\LeftArrowBar"                         ], "⇤", [arrow];
 ["\\rarrb"; "\\RightArrowBar"                        ], "⇥", [arrow];
 ["\\duarr"; "\\DownArrowUpArrow"                     ], "⇵", [arrow];
 ["\\loarr"                                          ], "⇽", [arrow];
 ["\\roarr"                                          ], "⇾", [arrow];
 ["\\hoarr"                                          ], "⇿", [arrow];
 ["\\Map"                                            ], "⤅", [arrow];
 ["\\lbarr"                                          ], "⤌", [arrow];
 ["\\rbarr"; "\\bkarow"                               ], "⤍", [arrow];
 ["\\lBarr"                                          ], "⤎", [arrow];
 ["\\ac"; "\\rBarr"; "\\dbkarow"                       ], "⤏", [arrow];
 ["\\RBarr"; "\\drbkarow"                             ], "⤐", [arrow];
 ["\\DDotrahd"                                       ], "⤑", [arrow];
 ["\\UpArrowBar"                                     ], "⤒", [arrow];
 ["\\DownArrowBar"                                   ], "⤓", [arrow];
 ["\\Rarrtl"                                         ], "⤖", [arrow];
 ["\\latail"                                         ], "⤙", [arrow];
 ["\\lAtail"                                         ], "⤛", [arrow];
 ["\\rAtail"                                         ], "⤜", [arrow];
 ["\\larrfs"                                         ], "⤝", [arrow];
 ["\\rarrfs"                                         ], "⤞", [arrow];
 ["\\larrbfs"                                        ], "⤟", [arrow];
 ["\\rarrbfs"                                        ], "⤠", [arrow];
 ["\\nwarhk"                                         ], "⤣", [arrow];
 ["\\nearhk"                                         ], "⤤", [arrow];
 ["\\searhk"; "\\hksearow"                            ], "⤥", [arrow];
 ["\\swarhk"; "\\hkswarow"                            ], "⤦", [arrow];
 ["\\nwnear"                                         ], "⤧", [arrow];
 ["\\toea"; "\\nesear"                                ], "⤨", [arrow];
 ["\\tosa"; "\\seswar"                                ], "⤩", [arrow];
 ["\\swnwar"                                         ], "⤪", [arrow];
 ["\\rarrc"                                          ], "⤳", [arrow];
 ["\\nrarrc"                                         ], "⤳̸", [arrow];
 ["\\cudarrr"                                        ], "⤵", [arrow];
 ["\\ldca"                                           ], "⤶", [arrow];
 ["\\rdca"                                           ], "⤷", [arrow];
 ["\\cudarrl"                                        ], "⤸", [arrow];
 ["\\larrpl"                                         ], "⤹", [arrow];
 ["\\curarrm"                                        ], "⤼", [arrow];
 ["\\cularrp"                                        ], "⤽", [arrow];
 ["\\rarrpl"                                         ], "⥅", [arrow];
 ["\\harrcir"                                        ], "⥈", [arrow];
 ["\\Uarrocir"                                       ], "⥉", [arrow];
 ["\\lurdshar"                                       ], "⥊", [arrow];
 ["\\ldrushar"                                       ], "⥋", [arrow];
 ["\\LeftRightVector"                                ], "⥎", [arrow];
 ["\\RightUpDownVector"                              ], "⥏", [arrow];
 ["\\DownLeftRightVector"                            ], "⥐", [arrow];
 ["\\LeftUpDownVector"                               ], "⥑", [arrow];
 ["\\LeftVectorBar"                                  ], "⥒", [arrow];
 ["\\RightVectorBar"                                 ], "⥓", [arrow];
 ["\\RightUpVectorBar"                               ], "⥔", [arrow];
 ["\\RightDownVectorBar"                             ], "⥕", [arrow];
 ["\\DownLeftVectorBar"                              ], "⥖", [arrow];
 ["\\DownRightVectorBar"                             ], "⥗", [arrow];
 ["\\LeftUpVectorBar"                                ], "⥘", [arrow];
 ["\\LeftDownVectorBar"                              ], "⥙", [arrow];
 ["\\LeftTeeVector"                                  ], "⥚", [arrow];
 ["\\RightTeeVector"                                 ], "⥛", [arrow];
 ["\\RightUpTeeVector"                               ], "⥜", [arrow];
 ["\\RightDownTeeVector"                             ], "⥝", [arrow];
 ["\\DownLeftTeeVector"                              ], "⥞", [arrow];
 ["\\DownRightTeeVector"                             ], "⥟", [arrow];
 ["\\LeftUpTeeVector"                                ], "⥠", [arrow];
 ["\\LeftDownTeeVector"                              ], "⥡", [arrow];
 ["\\lHar"                                           ], "⥢", [arrow];
 ["\\uHar"                                           ], "⥣", [arrow];
 ["\\rHar"                                           ], "⥤", [arrow];
 ["\\dHar"                                           ], "⥥", [arrow];
 ["\\luruhar"                                        ], "⥦", [arrow];
 ["\\ldrdhar"                                        ], "⥧", [arrow];
 ["\\ruluhar"                                        ], "⥨", [arrow];
 ["\\rdldhar"                                        ], "⥩", [arrow];
 ["\\lharul"                                         ], "⥪", [arrow];
 ["\\llhard"                                         ], "⥫", [arrow];
 ["\\rharul"                                         ], "⥬", [arrow];
 ["\\lrhard"                                         ], "⥭", [arrow];
 ["\\udhar"; "\\UpEquilibrium"                        ], "⥮", [arrow];
 ["\\duhar"; "\\ReverseUpEquilibrium"                 ], "⥯", [arrow];
 ["\\RoundImplies"                                   ], "⥰", [arrow];
 ["\\erarr"                                          ], "⥱", [arrow];
 ["\\simrarr"                                        ], "⥲", [arrow];
 ["\\larrsim"                                        ], "⥳", [arrow];
 ["\\rarrsim"                                        ], "⥴", [arrow];
 ["\\rarrap"                                         ], "⥵", [arrow];
 ["\\ltlarr"                                         ], "⥶", [arrow];
 ["\\suplarr"                                        ], "⥻", [arrow];
 ["\\lfisht"                                         ], "⥼", [arrow];
 ["\\rfisht"                                         ], "⥽", [arrow];
 ["\\ufisht"                                         ], "⥾", [arrow];
 ["\\dfisht"                                         ], "⥿", [arrow];
(* }}} *)

(* {{{ set operations *)
 ["\\emptyv"; "\\varnothing"                          ], "∅", [set];
 ["\\in"; "\\isin"; "\\isinv"; "\\Element"              ], "∈", [set];
 ["\\notin"; "\\NotElement"                           ], "∉", [set];
 ["\\notinva"                                        ], "∉̸", [set];
 ["\\ni"; "\\niv"; "\\owns"; "\\SuchThat"; "\\ReverseElement"      ], "∋", [set];
 ["\\notni"; "\\notniva"; "\\NotReverseElement"        ], "∌", [set];
 ["\\coprod"; "\\Coproduct"                           ], "∐", [set];
 ["\\cap"                                            ], "∩", [set];
 ["\\cup"                                            ], "∪", [set];
 ["\\twixt"; "\\between"                              ], "≬", [set];
 ["\\subset"                                         ], "⊂", [set];
 ["\\supset"; "\\Superset"                            ], "⊃", [set];
 ["\\suphsol"                                        ], "⊃/", [set];
 ["\\nsub"; "\\vnsub"; "\\nsubset"; "\\NotSubset"       ], "⊄", [set];
 ["\\nsup"; "\\vnsup"; "\\nsupset"; "\\NotSuperset"     ], "⊅", [set];
 ["\\subE"; "\\sube"; "\\subseteq"; "\\subseteqq"; "\\SubsetEqual" ], "⊆", [set];
 ["\\supe"; "\\supE"; "\\supseteq"; "\\supseteqq"; "\\SupersetEqual"], "⊇", [set];
 ["\\nsube"; "\\nsubE"; "\\nsubseteq"; "\\nsubseteqq"; "\\NotSubsetEqual"], "⊈", [set];
 ["\\nsupe"; "\\nsupE"; "\\nsupseteq"; "\\nsupseteqq"; "\\NotSupersetEqual"], "⊉", [set];
 ["\\subne"; "\\subnE"; "\\subsetneq"; "\\subsetneqq"   ], "⊊", [set];
 ["\\supne"; "\\supnE"; "\\supsetneq"; "\\supsetneqq"   ], "⊋", [set];
 ["\\cupdot"                                         ], "⊍", [set];
 ["\\uplus"; "\\xuplus"; "\\biguplus"; "\\UnionPlus"    ], "⊎", [set];
 ["\\sqsub"; "\\sqsubset"; "\\SquareSubset"            ], "⊏", [set];
 ["\\NotSquareSubset"                                ], "⊏̸", [set];
 ["\\sqsup"; "\\sqsupset"; "\\SquareSuperset"          ], "⊐", [set];
 ["\\NotSquareSuperset"                              ], "⊐̸", [set];
 ["\\sqsube"; "\\sqsubseteq"; "\\SquareSubsetEqual"    ], "⊑", [set];
 ["\\sqsupe"; "\\sqsupseteq"; "\\SquareSupersetEqual"  ], "⊒", [set];
 ["\\sqcap"; "\\SquareIntersection"                   ], "⊓", [set];
 ["\\sqcup"; "\\xsqcup"; "\\bigsqcup"; "\\SquareUnion"  ], "⊔", [set];
 ["\\xcap"; "\\bigcap"; "\\Intersection"               ], "⋂", [set];
 ["\\xcup"; "\\Union"; "\\bigcup"                      ], "⋃", [set];
 ["\\Sub"; "\\Subset"                                 ], "⋐", [set];
 ["\\Sup"; "\\Supset"                                 ], "⋑", [set];
 ["\\Cap"                                            ], "⋒", [set];
 ["\\Cup"                                            ], "⋓", [set];
 ["\\nsqsube"; "\\NotSquareSubsetEqual"               ], "⋢", [set];
 ["\\nsqsupe"; "\\NotSquareSupersetEqual"             ], "⋣", [set];
 ["\\disin"                                          ], "⋲", [set];
 ["\\isinsv"                                         ], "⋳", [set];
 ["\\isins"                                          ], "⋴", [set];
 ["\\isindot"                                        ], "⋵", [set];
 ["\\notinvc"                                        ], "⋶", [set];
 ["\\notindot"                                       ], "⋶︀", [set];
 ["\\notinvb"                                        ], "⋷", [set];
 ["\\isinE"                                          ], "⋹", [set];
 ["\\nisd"                                           ], "⋺", [set];
 ["\\xnis"                                           ], "⋻", [set];
 ["\\nis"                                            ], "⋼", [set];
 ["\\notnivc"                                        ], "⋽", [set];
 ["\\notnivb"                                        ], "⋾", [set];
 ["\\subrarr"                                        ], "⥹", [set];
(* }}} *)

(* {{{ math *)
 ["\\pm"; "\\plusmn"; "\\PlusMinus"                    ], "±", [math];
 ["\\times"                                          ], "×", [math];
 ["\\div"; "\\divide"                                 ], "÷", [math];
 ["\\prod"; "\\Product"                               ], "∏", [math];
 ["\\sum"; "\\Sum"                                    ], "∑", [math];
 ["\\mp"; "\\mnplus"; "\\MinusPlus"                    ], "∓", [math];
 ["\\plusdo"; "\\dotplus"                             ], "∔", [math];
 ["\\setmn"; "\\setminus"; "\\Backslash"               ], "∖", [math];
 ["\\lowast"                                         ], "∗", [math];
 ["\\Sqrt"; "\\radic"                                 ], "√", [math];
 ["\\prop"; "\\vprop"; "\\propto"; "\\varpropto"; "\\Proportional" ], "∝", [math];
 ["\\infty"; "\\infin"                                ], "∞", [math];
 ["\\mid"; "\\divides"; "\\VerticalBar"                ], "∣", [math];
 ["\\nmid"; "\\ndivides"; "\\NotVerticalBar"           ], "∤", [math];
 ["\\npar"; "\\nparallel"; "\\NotDoubleVerticalBar"    ], "∦", [math];
 ["\\int"; "\\Integral"                               ], "∫", [math];
 ["\\Int"                                            ], "∬", [math];
 ["\\tint"; "\\iiint"                                 ], "∭", [math];
 ["\\oint"; "\\conint"; "\\ContourIntegral"            ], "∮", [math];
 ["\\Conint"; "\\DoubleContourIntegral"               ], "∯", [math];
 ["\\Cconint"                                        ], "∰", [math];
 ["\\cwint"                                          ], "∱", [math];
 ["\\cwconint"; "\\ClockwiseContourIntegral"          ], "∲", [math];
 ["\\awconint"; "\\CounterClockwiseContourIntegral"   ], "∳", [math];
 ["\\qint"; "\\iiiint"                                ], "⨌", [math];
 ["\\cirfnint"                                       ], "⨐", [math];
 ["\\awint"                                          ], "⨑", [math];
 ["\\rppolint"                                       ], "⨒", [math];
 ["\\scpolint"                                       ], "⨓", [math];
 ["\\npolint"                                        ], "⨔", [math];
 ["\\pointint"                                       ], "⨕", [math];
 ["\\quatint"                                        ], "⨖", [math];
 ["\\intlarhk"                                       ], "⨗", [math];
 ["\\Cross"                                          ], "⨯", [math];
(* }}} *)

(* {{{ spaces *)
 ["\\nbsp"; "\\NonBreakingSpace"                      ], " ", [space];
 ["\\shy"                                            ], "­", [space];
 ["\\ensp"                                           ], " ", [space];
 ["\\emsp"                                           ], " ", [space];
 ["\\emsp13"                                         ], " ", [space];
 ["\\emsp14"                                         ], " ", [space];
 ["\\numsp"                                          ], " ", [space];
 ["\\puncsp"                                         ], " ", [space];
 ["\\thinsp"; "\\ThinSpace"                           ], " ", [space];
 ["\\ThickSpace"                                     ], "   ", [space];
 ["\\hairsp"; "\\VeryThinSpace"                       ], " ", [space];
 ["\\ic"; "\\ZeroWidthSpace"; "\\InvisibleComma"       ], "​", [space];
 ["\\af"; "\\ApplyFunction"                           ], "⁡", [space];
 ["\\it"; "\\InvisibleTimes"                          ], "⁢", [space];
 ["\\NoBreak"                                        ], "﻿", [space];
(* }}} *)

(* {{{ parenteses *)
 ["\\laquo"                                          ], "«", [delimiter] ;
 ["\\raquo"                                          ], "»", [delimiter] ;
 ["\\lang"; "\\langle"; "\\LeftAngleBracket"           ], "〈", [delimiter] ;
 ["\\rang"; "\\rangle"; "\\RightAngleBracket"          ], "〉", [delimiter] ;
 ["\\lmoust"; "\\lmoustache"                          ], "⎰", [delimiter] ;
 ["\\rmoust"; "\\rmoustache"                          ], "⎱", [delimiter] ;
 ["\\Lang"                                           ], "《", [delimiter] ;
 ["\\Rang"                                           ], "》", [delimiter] ;
 ["\\lbbrk"                                          ], "〔", [delimiter] ;
 ["\\rbbrk"                                          ], "〕", [delimiter] ;
 ["\\lopar"                                          ], "〘", [delimiter] ;
 ["\\ropar"                                          ], "〙", [delimiter] ;
 ["\\lobrk"; "\\LeftDoubleBracket"                    ], "〚", [delimiter] ;
 ["\\robrk"; "\\RightDoubleBracket"                   ], "〛", [delimiter] ;
(* }}} *)

(* {{{ Missing font *)
 ["\\NegativeThickSpace"                             ], " ︀", [miscellanea];
 ["\\NegativeThinSpace"                              ], " ︀", [miscellanea];
 ["\\NegativeVeryThinSpace"                          ], " ︀", [miscellanea];
 ["\\NegativeMediumSpace"                            ], " ︀", [miscellanea];
 ["\\slarr"; "\\ShortLeftArrow"                       ], "←︀", [miscellanea];
 ["\\srarr"; "\\ShortRightArrow"                      ], "→︀", [miscellanea];
 ["\\empty"; "\\emptyset"                             ], "∅︀", [miscellanea];
 ["\\ssetmn"; "\\smallsetminus"                       ], "∖︀", [miscellanea];
 ["\\smid"; "\\shortmid"                              ], "∣︀", [miscellanea];
 ["\\nsmid"; "\\nshortmid"                            ], "∤︀", [miscellanea];
 ["\\spar"; "\\parsl"; "\\shortparallel"               ], "∥︀", [miscellanea];
 ["\\nparsl"                                         ], "∥︀⃥", [miscellanea];
 ["\\nspar"; "\\nshortparallel"                       ], "∦︀", [miscellanea];
 ["\\caps"                                           ], "∩︀", [miscellanea];
 ["\\cups"                                           ], "∪︀", [miscellanea];
 ["\\thksim"; "\\thicksim"                            ], "∼︀", [miscellanea];
 ["\\thkap"; "\\thickapprox"                          ], "≈︀", [miscellanea];
 ["\\nedot"                                          ], "≠︀", [miscellanea];
 ["\\bnequiv"                                        ], "≡⃥", [miscellanea];
 ["\\lvnE"; "\\lvertneqq"                             ], "≨︀", [miscellanea];
 ["\\gvnE"; "\\gvertneqq"                             ], "≩︀", [miscellanea];
 ["\\nLtv"; "\\NotLessLess"                           ], "≪̸︀", [miscellanea];
 ["\\nGtv"; "\\NotGreaterGreater"                     ], "≫̸︀", [miscellanea];
 ["\\nle"; "\\NotLessEqual"                           ], "≰⃥", [miscellanea];
 ["\\nge"; "\\NotGreaterEqual"                        ], "≱⃥", [miscellanea];
 ["\\vsubnE"; "\\vsubne"; "\\varsubsetneq"; "\\varsubsetneqq"     ], "⊊︀", [miscellanea];
 ["\\vsupne"; "\\vsupnE"; "\\varsupsetneq"; "\\varsupsetneqq"     ], "⊋︀", [miscellanea];
 ["\\sqcaps"                                         ], "⊓︀", [miscellanea];
 ["\\sqcups"                                         ], "⊔︀", [miscellanea];
 ["\\prurel"                                         ], "⊰", [miscellanea];
 ["\\lesg"                                           ], "⋚︀", [miscellanea];
 ["\\gesl"                                           ], "⋛︀", [miscellanea];
 ["\\ShortUpArrow"                                   ], "⌃︀", [miscellanea];
 ["\\ShortDownArrow"                                 ], "⌄︀", [miscellanea];
 ["\\target"                                         ], "⌖", [miscellanea];
 ["\\cylcty"                                         ], "⌭", [miscellanea];
 ["\\profalar"                                       ], "⌮", [miscellanea];
 ["\\topbot"                                         ], "⌶", [miscellanea];
 ["\\solbar"                                         ], "⌿", [miscellanea];
 ["\\angzarr"                                        ], "⍼", [miscellanea];
 ["\\tbrk"; "\\OverBracket"                           ], "⎴", [miscellanea];
 ["\\bbrk"; "\\UnderBracket"                          ], "⎵", [miscellanea];
 ["\\lbrke"                                          ], "⦋", [miscellanea];
 ["\\rbrke"                                          ], "⦌", [miscellanea];
 ["\\lbrkslu"                                        ], "⦍", [miscellanea];
 ["\\rbrksld"                                        ], "⦎", [miscellanea];
 ["\\lbrksld"                                        ], "⦏", [miscellanea];
 ["\\rbrkslu"                                        ], "⦐", [miscellanea];
 ["\\langd"                                          ], "⦑", [miscellanea];
 ["\\rangd"                                          ], "⦒", [miscellanea];
 ["\\lparlt"                                         ], "⦓", [miscellanea];
 ["\\rpargt"                                         ], "⦔", [miscellanea];
 ["\\gtlPar"                                         ], "⦕", [miscellanea];
 ["\\ltrPar"                                         ], "⦖", [miscellanea];
 ["\\vzigzag"                                        ], "⦚", [miscellanea];
 ["\\angrtvbd"                                       ], "⦝", [miscellanea];
 ["\\angrtvb"                                        ], "⦝︀", [miscellanea];
 ["\\ange"                                           ], "⦤", [miscellanea];
 ["\\range"                                          ], "⦥", [miscellanea];
 ["\\dwangle"                                        ], "⦦", [miscellanea];
 ["\\uwangle"                                        ], "⦧", [miscellanea];
 ["\\angmsdaa"                                       ], "⦨", [miscellanea];
 ["\\angmsdab"                                       ], "⦩", [miscellanea];
 ["\\angmsdac"                                       ], "⦪", [miscellanea];
 ["\\angmsdad"                                       ], "⦫", [miscellanea];
 ["\\angmsdae"                                       ], "⦬", [miscellanea];
 ["\\angmsdaf"                                       ], "⦭", [miscellanea];
 ["\\angmsdag"                                       ], "⦮", [miscellanea];
 ["\\angmsdah"                                       ], "⦯", [miscellanea];
 ["\\bemptyv"                                        ], "⦰", [miscellanea];
 ["\\demptyv"                                        ], "⦱", [miscellanea];
 ["\\cemptyv"                                        ], "⦲", [miscellanea];
 ["\\raemptyv"                                       ], "⦳", [miscellanea];
 ["\\laemptyv"                                       ], "⦴", [miscellanea];
 ["\\ohbar"                                          ], "⦵", [miscellanea];
 ["\\omid"                                           ], "⦶", [miscellanea];
 ["\\opar"                                           ], "⦷", [miscellanea];
 ["\\operp"                                          ], "⦹", [miscellanea];
 ["\\olcross"                                        ], "⦻", [miscellanea];
 ["\\odsold"                                         ], "⦼", [miscellanea];
 ["\\olcir"                                          ], "⦾", [miscellanea];
 ["\\ofcir"                                          ], "⦿", [miscellanea];
 ["\\olt"                                            ], "⧀", [miscellanea];
 ["\\ogt"                                            ], "⧁", [miscellanea];
 ["\\cirscir"                                        ], "⧂", [miscellanea];
 ["\\cirE"                                           ], "⧃", [miscellanea];
 ["\\solb"                                           ], "⧄", [miscellanea];
 ["\\bsolb"                                          ], "⧅", [miscellanea];
 ["\\boxbox"                                         ], "⧉", [miscellanea];
 ["\\trisb"                                          ], "⧍", [miscellanea];
 ["\\race"                                           ], "⧚", [miscellanea];
 ["\\acE"                                            ], "⧛", [miscellanea];
 ["\\iinfin"                                         ], "⧜", [miscellanea];
 ["\\nvinfin"                                        ], "⧞", [miscellanea];
 ["\\eparsl"                                         ], "⧣", [miscellanea];
 ["\\smeparsl"                                       ], "⧤", [miscellanea];
 ["\\eqvparsl"                                       ], "⧥", [miscellanea];
 ["\\RuleDelayed"                                    ], "⧴", [miscellanea];
 ["\\dsol"                                           ], "⧶", [miscellanea];
 ["\\pluscir"                                        ], "⨢", [miscellanea];
 ["\\plusacir"                                       ], "⨣", [miscellanea];
 ["\\simplus"                                        ], "⨤", [miscellanea];
 ["\\plusdu"                                         ], "⨥", [miscellanea];
 ["\\plussim"                                        ], "⨦", [miscellanea];
 ["\\plustwo"                                        ], "⨧", [miscellanea];
 ["\\mcomma"                                         ], "⨩", [miscellanea];
 ["\\minusdu"                                        ], "⨪", [miscellanea];
 ["\\loplus"                                         ], "⨭", [miscellanea];
 ["\\roplus"                                         ], "⨮", [miscellanea];
 ["\\timesd"                                         ], "⨰", [miscellanea];
 ["\\timesbar"                                       ], "⨱", [miscellanea];
 ["\\smashp"                                         ], "⨳", [miscellanea];
 ["\\lotimes"                                        ], "⨴", [miscellanea];
 ["\\rotimes"                                        ], "⨵", [miscellanea];
 ["\\otimesas"                                       ], "⨶", [miscellanea];
 ["\\Otimes"                                         ], "⨷", [miscellanea];
 ["\\odiv"                                           ], "⨸", [miscellanea];
 ["\\triplus"                                        ], "⨹", [miscellanea];
 ["\\triminus"                                       ], "⨺", [miscellanea];
 ["\\tritime"                                        ], "⨻", [miscellanea];
 ["\\iprod"; "\\intprod"                              ], "⨼", [miscellanea];
 ["\\amalg"                                          ], "⨿", [miscellanea];
 ["\\capdot"                                         ], "⩀", [miscellanea];
 ["\\ncup"                                           ], "⩂", [miscellanea];
 ["\\ncap"                                           ], "⩃", [miscellanea];
 ["\\capand"                                         ], "⩄", [miscellanea];
 ["\\cupor"                                          ], "⩅", [miscellanea];
 ["\\cupcap"                                         ], "⩆", [miscellanea];
 ["\\capcup"                                         ], "⩇", [miscellanea];
 ["\\cupbrcap"                                       ], "⩈", [miscellanea];
 ["\\capbrcup"                                       ], "⩉", [miscellanea];
 ["\\cupcup"                                         ], "⩊", [miscellanea];
 ["\\capcap"                                         ], "⩋", [miscellanea];
 ["\\ccups"                                          ], "⩌", [miscellanea];
 ["\\ccaps"                                          ], "⩍", [miscellanea];
 ["\\ccupssm"                                        ], "⩐", [miscellanea];
 ["\\And"                                            ], "⩓", [miscellanea];
 ["\\Or"                                             ], "⩔", [miscellanea];
 ["\\andand"                                         ], "⩕", [miscellanea];
 ["\\oror"                                           ], "⩖", [miscellanea];
 ["\\orslope"                                        ], "⩗", [miscellanea];
 ["\\andslope"                                       ], "⩘", [miscellanea];
 ["\\andv"                                           ], "⩚", [miscellanea];
 ["\\orv"                                            ], "⩛", [miscellanea];
 ["\\andd"                                           ], "⩜", [miscellanea];
 ["\\ord"                                            ], "⩝", [miscellanea];
 ["\\wedbar"                                         ], "⩟", [miscellanea];
 ["\\sdote"                                          ], "⩦", [miscellanea];
 ["\\simdot"                                         ], "⩪", [miscellanea];
 ["\\congdot"                                        ], "⩭", [miscellanea];
 ["\\ncongdot"                                       ], "⩭̸", [miscellanea];
 ["\\apacir"                                         ], "⩯", [miscellanea];
 ["\\napE"                                           ], "⩰̸", [miscellanea];
 ["\\eplus"                                          ], "⩱", [miscellanea];
 ["\\pluse"                                          ], "⩲", [miscellanea];
 ["\\Esim"                                           ], "⩳", [miscellanea];
 ["\\Colone"                                         ], "⩴", [miscellanea];
 ["\\Equal"                                          ], "⩵", [miscellanea];
 ["\\eDDot"; "\\ddotseq"                              ], "⩷", [miscellanea];
 ["\\equivDD"                                        ], "⩸", [miscellanea];
 ["\\ltcir"                                          ], "⩹", [miscellanea];
 ["\\gtcir"                                          ], "⩺", [miscellanea];
 ["\\ltquest"                                        ], "⩻", [miscellanea];
 ["\\gtquest"                                        ], "⩼", [miscellanea];
 ["\\LessLess"                                       ], "⪡", [miscellanea];
 ["\\GreaterGreater"                                 ], "⪢", [miscellanea];
 ["\\glj"                                            ], "⪤", [miscellanea];
 ["\\gla"                                            ], "⪥", [miscellanea];
 ["\\ltcc"                                           ], "⪦", [miscellanea];
 ["\\gtcc"                                           ], "⪧", [miscellanea];
 ["\\lescc"                                          ], "⪨", [miscellanea];
 ["\\gescc"                                          ], "⪩", [miscellanea];
 ["\\smt"                                            ], "⪪", [miscellanea];
 ["\\lat"                                            ], "⪫", [miscellanea];
 ["\\smte"                                           ], "⪬", [miscellanea];
 ["\\smtes"                                          ], "⪬︀", [miscellanea];
 ["\\late"                                           ], "⪭", [miscellanea];
 ["\\lates"                                          ], "⪭︀", [miscellanea];
 ["\\Sc"                                             ], "⪼", [miscellanea];
 ["\\subdot"                                         ], "⪽", [miscellanea];
 ["\\supdot"                                         ], "⪾", [miscellanea];
 ["\\subplus"                                        ], "⪿", [miscellanea];
 ["\\supplus"                                        ], "⫀", [miscellanea];
 ["\\submult"                                        ], "⫁", [miscellanea];
 ["\\supmult"                                        ], "⫂", [miscellanea];
 ["\\subedot"                                        ], "⫃", [miscellanea];
 ["\\supedot"                                        ], "⫄", [miscellanea];
 ["\\subsim"                                         ], "⫇", [miscellanea];
 ["\\supsim"                                         ], "⫈", [miscellanea];
 ["\\csub"                                           ], "⫏", [miscellanea];
 ["\\csup"                                           ], "⫐", [miscellanea];
 ["\\csube"                                          ], "⫑", [miscellanea];
 ["\\csupe"                                          ], "⫒", [miscellanea];
 ["\\subsup"                                         ], "⫓", [miscellanea];
 ["\\supsub"                                         ], "⫔", [miscellanea];
 ["\\subsub"                                         ], "⫕", [miscellanea];
 ["\\supsup"                                         ], "⫖", [miscellanea];
 ["\\suphsub"                                        ], "⫗", [miscellanea];
 ["\\supdsub"                                        ], "⫘", [miscellanea];
 ["\\forkv"                                          ], "⫙", [miscellanea];
 ["\\topfork"                                        ], "⫚", [miscellanea];
 ["\\mlcp"                                           ], "⫛", [miscellanea];
 ["\\Dashv"; "\\DoubleLeftTee"                        ], "⫤", [miscellanea];
 ["\\Vdashl"                                         ], "⫦", [miscellanea];
 ["\\Barv"                                           ], "⫧", [miscellanea];
 ["\\vBar"                                           ], "⫨", [miscellanea];
 ["\\vBarv"                                          ], "⫩", [miscellanea];
 ["\\Vbar"                                           ], "⫫", [miscellanea];
 ["\\Not"                                            ], "⫬", [miscellanea];
 ["\\bNot"                                           ], "⫭", [miscellanea];
 ["\\rnmid"                                          ], "⫮", [miscellanea];
 ["\\cirmid"                                         ], "⫯", [miscellanea];
 ["\\midcir"                                         ], "⫰", [miscellanea];
 ["\\topcir"                                         ], "⫱", [miscellanea];
 ["\\nhpar"                                          ], "⫲", [miscellanea];
 ["\\parsim"                                         ], "⫳", [miscellanea];
 ["\\loang"                                          ], "", [miscellanea];
 ["\\roang"                                          ], "", [miscellanea];
 ["\\xlarr"; "\\LongLeftArrow"                        ], "", [miscellanea];
 ["\\xrarr"; "\\LongRightArrow"                       ], "", [miscellanea];
 ["\\xharr"; "\\LongLeftRightArrow"                   ], "", [miscellanea];
 ["\\xlArr"; "\\DoubleLongLeftArrow"                  ], "", [miscellanea];
 ["\\xrArr"; "\\DoubleLongRightArrow"                 ], "", [miscellanea];
 ["\\xhArr"; "\\DoubleLongLeftRightArrow"             ], "", [miscellanea];
 ["\\xmap"                                           ], "", [miscellanea];
 ["\\FilledVerySmallSquare"                          ], "", [miscellanea];
 ["\\EmptyVerySmallSquare"                           ], "", [miscellanea];
 ["\\dzigrarr"                                       ], "", [miscellanea];
 ["\\Ascr"                                           ], "𝒜", [miscellanea];
 ["\\Cscr"                                           ], "𝒞", [miscellanea];
 ["\\Dscr"                                           ], "𝒟", [miscellanea];
 ["\\Gscr"                                           ], "𝒢", [miscellanea];
 ["\\Jscr"                                           ], "𝒥", [miscellanea];
 ["\\Kscr"                                           ], "𝒦", [miscellanea];
 ["\\Nscr"                                           ], "𝒩", [miscellanea];
 ["\\Oscr"                                           ], "𝒪", [miscellanea];
 ["\\Pscr"                                           ], "𝒫", [miscellanea];
 ["\\Qscr"                                           ], "𝒬", [miscellanea];
 ["\\Sscr"                                           ], "𝒮", [miscellanea];
 ["\\Tscr"                                           ], "𝒯", [miscellanea];
 ["\\Uscr"                                           ], "𝒰", [miscellanea];
 ["\\Vscr"                                           ], "𝒱", [miscellanea];
 ["\\Wscr"                                           ], "𝒲", [miscellanea];
 ["\\Xscr"                                           ], "𝒳", [miscellanea];
 ["\\Yscr"                                           ], "𝒴", [miscellanea];
 ["\\Zscr"                                           ], "𝒵", [miscellanea];
 ["\\ascr"                                           ], "𝒶", [miscellanea];
 ["\\bscr"                                           ], "𝒷", [miscellanea];
 ["\\cscr"                                           ], "𝒸", [miscellanea];
 ["\\dscr"                                           ], "𝒹", [miscellanea];
 ["\\fscr"                                           ], "𝒻", [miscellanea];
 ["\\hscr"                                           ], "𝒽", [miscellanea];
 ["\\iscr"                                           ], "𝒾", [miscellanea];
 ["\\jscr"                                           ], "𝒿", [miscellanea];
 ["\\kscr"                                           ], "𝓀", [miscellanea];
 ["\\mscr"                                           ], "𝓂", [miscellanea];
 ["\\nscr"                                           ], "𝓃", [miscellanea];
 ["\\pscr"                                           ], "𝓅", [miscellanea];
 ["\\qscr"                                           ], "𝓆", [miscellanea];
 ["\\rscr"                                           ], "𝓇", [miscellanea];
 ["\\sscr"                                           ], "𝓈", [miscellanea];
 ["\\tscr"                                           ], "𝓉", [miscellanea];
 ["\\uscr"                                           ], "𝓊", [miscellanea];
 ["\\vscr"                                           ], "𝓋", [miscellanea];
 ["\\wscr"                                           ], "𝓌", [miscellanea];
 ["\\xscr"                                           ], "𝓍", [miscellanea];
 ["\\yscr"                                           ], "𝓎", [miscellanea];
 ["\\zscr"                                           ], "𝓏", [miscellanea];
 ["\\Afr"                                            ], "𝔄", [miscellanea];
 ["\\Bfr"                                            ], "𝔅", [miscellanea];
 ["\\Dfr"                                            ], "𝔇", [miscellanea];
 ["\\Efr"                                            ], "𝔈", [miscellanea];
 ["\\Ffr"                                            ], "𝔉", [miscellanea];
 ["\\Gfr"                                            ], "𝔊", [miscellanea];
 ["\\Jfr"                                            ], "𝔍", [miscellanea];
 ["\\Kfr"                                            ], "𝔎", [miscellanea];
 ["\\Lfr"                                            ], "𝔏", [miscellanea];
 ["\\Mfr"                                            ], "𝔐", [miscellanea];
 ["\\Nfr"                                            ], "𝔑", [miscellanea];
 ["\\Ofr"                                            ], "𝔒", [miscellanea];
 ["\\Pfr"                                            ], "𝔓", [miscellanea];
 ["\\Qfr"                                            ], "𝔔", [miscellanea];
 ["\\Sfr"                                            ], "𝔖", [miscellanea];
 ["\\Tfr"                                            ], "𝔗", [miscellanea];
 ["\\Ufr"                                            ], "𝔘", [miscellanea];
 ["\\Vfr"                                            ], "𝔙", [miscellanea];
 ["\\Wfr"                                            ], "𝔚", [miscellanea];
 ["\\Xfr"                                            ], "𝔛", [miscellanea];
 ["\\Yfr"                                            ], "𝔜", [miscellanea];
 ["\\afr"                                            ], "𝔞", [miscellanea];
 ["\\bfr"                                            ], "𝔟", [miscellanea];
 ["\\cfr"                                            ], "𝔠", [miscellanea];
 ["\\dfr"                                            ], "𝔡", [miscellanea];
 ["\\efr"                                            ], "𝔢", [miscellanea];
 ["\\ffr"                                            ], "𝔣", [miscellanea];
 ["\\gfr"                                            ], "𝔤", [miscellanea];
 ["\\hfr"                                            ], "𝔥", [miscellanea];
 ["\\ifr"                                            ], "𝔦", [miscellanea];
 ["\\jfr"                                            ], "𝔧", [miscellanea];
 ["\\kfr"                                            ], "𝔨", [miscellanea];
 ["\\lfr"                                            ], "𝔩", [miscellanea];
 ["\\mfr"                                            ], "𝔪", [miscellanea];
 ["\\nfr"                                            ], "𝔫", [miscellanea];
 ["\\ofr"                                            ], "𝔬", [miscellanea];
 ["\\pfr"                                            ], "𝔭", [miscellanea];
 ["\\qfr"                                            ], "𝔮", [miscellanea];
 ["\\rfr"                                            ], "𝔯", [miscellanea];
 ["\\sfr"                                            ], "𝔰", [miscellanea];
 ["\\tfr"                                            ], "𝔱", [miscellanea];
 ["\\ufr"                                            ], "𝔲", [miscellanea];
 ["\\vfr"                                            ], "𝔳", [miscellanea];
 ["\\wfr"                                            ], "𝔴", [miscellanea];
 ["\\xfr"                                            ], "𝔵", [miscellanea];
 ["\\yfr"                                            ], "𝔶", [miscellanea];
 ["\\zfr"                                            ], "𝔷", [miscellanea];
(* }}} *)

]
;;

let load_predefined_virtuals () =
  List.iter 
    (fun a,b,c -> 
       Virtuals.add_virtual a (Glib.Utf8.first_char b) c) 
    predefined_virtuals
;;

let predefined_classes = [
 ["-"; "÷"; "⊢"; ];
 ["="; "≃"; "≈"; "≝"; "≡"; "≅"; "≐"; "≑"; ];  
 ["→"; "⇝"; "⇾"; "⤍"; "⤏"; "⤳"; ] ;
 ["⇒"; "➾"; "⇨"; "➡"; "⇉"; "⥤"; "⥰"; ] ;
 ["⇑"; "⇧"; "⬆"; ] ; 
 ["⇓"; "⇩"; "⬇"; ] ;
 ["↔"; "⇔"; "⬄"; "⬌"; ] ; 
 ["≤"; "≲"; "≼"; "≰"; "≴"; "⋠"; ];
 ["_" ; "⎽"; "⎼"; "⎻"; "⎺"; ];
 ["<"; "≺"; "≮"; "⊀"; "〈"; "«"; "❬"; "❮"; "❰"; ] ;
 ["("; "❨"; "❪"; "❲"; "（"; ];
 [")"; "❩"; "❫"; "❳"; "）"; ];
 ["["; "〚"; ] ;
 ["]"; "〛"; ] ;  
 ["{"; "❴"; "⦃" ] ;
 ["}"; "❵"; "⦄" ] ;
 ["□"; "◽"; "▪"; "◾"; ];
 ["◊"; "♢"; "⧫"; "♦"; "⟐"; "⟠"; ] ;
 ["▸"; "►"; "▶"; ] ;
 [">"; "〉"; "»"; "❭"; "❯"; "❱"; ] ;       
 ["a"; "α"; "𝕒"; "𝐚"; "𝛂"; "ⓐ"; ] ;
 ["A"; "ℵ"; "𝔸"; "𝐀"; "Ⓐ"; ] ;
 ["b"; "β"; "ß"; "𝕓"; "𝐛"; "𝛃"; "ⓑ"; ] ;
 ["B"; "ℶ"; "ℬ"; "𝔹"; "𝐁"; "Ⓑ"; ] ;
 ["c"; "𝕔"; "𝐜"; "ⓒ"; ] ;
 ["C"; "ℭ"; "∁"; "𝐂"; "Ⓒ"; ] ;
 ["d"; "δ"; "∂"; "𝕕"; "ⅆ"; "𝐝"; "𝛅"; "ⓓ"; ] ;
 ["D"; "Δ"; "𝔻"; "ⅅ"; "𝐃"; "𝚫"; "Ⓓ"; ] ;
 ["e"; "ɛ"; "ε"; "ϵ"; "Є"; "ℯ"; "𝕖"; "ⅇ"; "𝐞"; "𝛆"; "𝛜"; "ⓔ"; ] ;
 ["E"; "ℰ"; "𝔼"; "𝐄"; "Ⓔ"; ] ;
 ["f"; "φ"; "ψ"; "ϕ"; "⨍"; "𝕗"; "𝐟"; "𝛟"; "𝛙"; "ⓕ"; ] ;
 ["F"; "Φ"; "Ψ"; "ℱ"; "𝔽"; "𝐅"; "𝚽"; "𝚿"; "Ⓕ"; ] ;
 ["g"; "γ"; "ℊ"; "𝕘"; "𝐠"; "𝛄"; "ⓖ"; ] ;
 ["G"; "Γ"; "𝔾"; "𝐆"; "𝚪"; "Ⓖ"; ] ;
 ["h"; "η"; "ℌ"; "ℎ"; "𝕙"; "𝐡"; "ⓗ"; ] ;
 ["H"; "ℋ"; "ℍ"; "𝐇"; "Ⓗ"; ] ;
 ["i"; "ι"; "ℐ"; "𝕚"; "ⅈ"; "𝐢"; "𝛊"; "ⓘ"; ] ;
 ["I"; "𝕀"; "𝐈"; "Ⓘ"; ] ;
 ["j"; "𝕛"; "𝐣"; "ⓙ"; ] ;
 ["J"; "Ј"; "𝕁"; "𝐉"; "Ⓙ"; ] ;
 ["k"; "κ"; "𝕜"; "𝐤"; "𝛋"; "ⓚ"; ] ;
 ["K"; "𝕂"; "𝐊"; "Ⓚ"; ] ;
 ["l"; "λ"; "𝕝"; "𝐥"; "𝛌"; "ⓛ"; ] ;
 ["L"; "Λ"; "𝕃"; "𝐋"; "𝚲"; "Ⓛ"; ] ;
 ["m"; "μ"; "𝕞"; "𝐦"; "𝛍"; "ⓜ"; ] ;
 ["M"; "ℳ"; "𝕄"; "𝐌"; "Ⓜ"; ] ;
 ["n"; "𝕟"; "𝐧"; "𝛈"; "ⓝ"; ] ;
 ["N"; "ℕ"; "№"; "𝐍"; "Ⓝ"; ] ;
 ["o"; "θ"; "ϑ"; "𝕠"; "∘";  "ø"; "○"; "𝐨"; "𝛉"; "ⓞ"; ] ;
 ["O"; "Θ"; "𝕆"; "𝐎"; "𝚯"; "𝚹"; "Ⓞ"; ] ;
 ["p"; "π"; "𝕡"; "𝐩"; "𝛑"; "ⓟ"; ] ;
 ["P"; "Π"; "℘"; "ℙ"; "𝐏"; "𝚷"; "Ⓟ"; ] ;
 ["q"; "𝕢"; "𝐪"; "ⓠ"; ] ;
 ["Q"; "ℚ"; "𝐐"; "Ⓠ"; ] ;
 ["r"; "ρ"; "ϱ"; "𝕣"; "𝐫"; "𝛒"; "𝛠"; "ⓡ"; ] ;
 ["R"; "ℛ"; "ℜ"; "ℝ"; "𝐑"; "Ⓡ"; ] ;
 ["s"; "σ"; "ς"; "𝕤"; "𝐬"; "𝛔"; "ⓢ"; ] ;
 ["S"; "Σ"; "𝕊"; "𝐒"; "𝚺"; "Ⓢ"; ] ;
 ["t"; "τ"; "𝕥"; "𝐭"; "𝛕"; "ⓣ"; ] ;
 ["T"; "𝕋"; "𝐓"; "Ⓣ"; ] ;
 ["u"; "𝕦"; "𝐮"; "ⓤ"; ] ;
 ["U"; "𝕌"; "𝐔"; "Ⓤ"; ] ;
 ["v"; "ν"; "𝕧"; "𝐯"; "𝛖"; "𝛎"; "ⓥ"; ] ;
 ["V"; "𝕍"; "𝐕"; "Ⓥ"; ] ;
 ["w"; "ω"; "𝕨"; "𝐰"; "𝛚"; "ⓦ"; ] ;
 ["W"; "Ω"; "𝕎"; "𝐖"; "𝛀"; "Ⓦ"; ] ;
 ["x"; "ξ"; "χ"; "ϰ"; "𝕩"; "𝐱"; "𝛏"; "𝛘"; "𝛞"; "ⓧ"; ] ;
 ["X"; "Ξ"; "𝕏";"𝐗"; "𝚵"; "Ⓧ"; ] ;
 ["y"; "υ"; "𝕪"; "𝐲"; "ⓨ"; ] ;
 ["Y"; "ϒ"; "𝕐"; "𝐘"; "𝚼"; "Ⓨ"; ] ;
 ["z"; "ζ"; "𝕫"; "𝐳"; "𝛇"; "ⓩ"; ] ;
 ["Z"; "ℨ"; "ℤ"; "𝐙"; "Ⓩ"; ] ;
 ["0"; "𝟘"; "⓪"; ] ;
 ["1"; "𝟙"; "①"; ] ;
 ["2"; "𝟚"; "②"; ] ;
 ["3"; "𝟛"; "③"; ] ;
 ["4"; "𝟜"; "④"; ] ;
 ["5"; "𝟝"; "⑤"; ] ;
 ["6"; "𝟞"; "⑥"; ] ;
 ["7"; "𝟟"; "⑦"; ] ;
 ["8"; "𝟠"; "⑧"; ] ;
 ["9"; "𝟡"; "⑨"; ] ;
 ]
;;

let load_predefined_classes () =
  List.iter 
    (fun l -> Virtuals.add_eqclass (List.map (Glib.Utf8.first_char) l))
    predefined_classes;
;;

(* vim:set foldmethod=marker: *)
