/* Mednafen - Multi-system Emulator
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "main.h"
#include "video.h"

#define MK_COLOR_A(surface, r,g,b,a) ( ((a)<<surface->format->Ashift) | ((r)<<surface->format->Rshift) | ((g) << surface->format->Gshift) |((b) << surface->format->Bshift))

static double VirtualTime, DrawnTime, BlittedTime;
static uint64 VirtualLast, DrawnLast, BlittedLast;

//static uint32 VirtualTime[128], DrawnTime[128], BlittedTime[128];
//static uint32 VirtualIndex, DrawnIndex, BlittedIndex;
static SDL_Surface *FPSSurface = NULL;
static SDL_Rect FPSRect;

void FPS_Init(void)
{
 VirtualTime = 0;
 DrawnTime = 0;
 BlittedTime = 0;
}

void FPS_IncVirtual(void)
{
 uint64 curtime = SDL_GetTicks();
 double this_fps = (double)1000 / (curtime - VirtualLast);

 VirtualTime += (this_fps - VirtualTime) * 0.01;

 VirtualLast = curtime;
 printf("%f, %f\n", this_fps, VirtualTime);
}

void FPS_IncDrawn(void)
{

}

void FPS_IncBlitted(void)
{

}

static bool isactive = 0;
bool FPS_IsActive(void)
{
 return(isactive);
}

void FPS_ToggleView(void)
{
 isactive ^= 1;
}

void FPS_Draw(SDL_Surface *screen, int rs, int gs, int bs, int as)
{
 if(!isactive) 
 {
  if(FPSSurface)
  {
   SDL_FreeSurface(FPSSurface);
   FPSSurface = NULL;
  }
  return;
 }

 if(!FPSSurface)
 {
  FPSSurface = SDL_CreateRGBSurface(SDL_SWSURFACE, 9 * 5, 3 * 7, 32, 0xFF << rs, 0xFF << gs, 0xFF << bs, 0xFF << as);
  FPSRect.w = 9 * 5;
  FPSRect.h = 3 * 7;
  FPSRect.x = FPSRect.y = 0;
 }

 uint32 curtime = SDL_GetTicks();
 uint32 vt_frames_drawn = 0, dt_frames_drawn = 0, bt_frames_drawn = 0;
 uint32 vt_mintime, dt_mintime, bt_mintime;
 char virtfps[64], drawnfps[64], blitfps[64];

 if(VirtualTime > 0.00001)
  snprintf(virtfps, 64, "%f", VirtualTime);
 else
  snprintf(virtfps, 64, "?");

 if(DrawnTime > 0.00001)
  snprintf(drawnfps, 64, "%f", (double)1000 / DrawnTime);
 else
  snprintf(drawnfps, 64, "?");

 if(BlittedTime > 0.00001)
  snprintf(blitfps, 64, "%f", (double)1000 / BlittedTime);
 else
  snprintf(blitfps, 64, "?");

 SDL_FillRect(FPSSurface, NULL, MK_COLOR_A(FPSSurface, 0, 0, 0, 0x80));
 DrawTextTrans((uint32 *)FPSSurface->pixels, FPSSurface->pitch, FPSSurface->w, (UTF8*)virtfps, MK_COLOR_A(FPSSurface, 0xFF, 0xFF, 0xFF, 0xFF), FALSE, TRUE);
 DrawTextTrans((uint32 *)FPSSurface->pixels + 7 * (FPSSurface->pitch >> 2), FPSSurface->pitch, FPSSurface->w, (UTF8*)drawnfps, MK_COLOR_A(FPSSurface, 0xFF, 0xFF, 0xFF, 0xFF), FALSE, TRUE);
 DrawTextTrans((uint32 *)FPSSurface->pixels + 7 * 2 * (FPSSurface->pitch >> 2), FPSSurface->pitch, FPSSurface->w, (UTF8*)blitfps, MK_COLOR_A(FPSSurface, 0xFF, 0xFF, 0xFF, 0xFF), FALSE, TRUE);

 SDL_Rect drect;
 drect.x = 0;
 drect.y = 0;
 drect.w = FPSRect.w;
 drect.h = FPSRect.h;

 BlitRaw(FPSSurface, &FPSRect, &drect);

}
