#ifndef INOTIFY_WATCHERMAILDIR_H
#define INOTIFY_WATCHERMAILDIR_H

#include <stdint.h>

#include <string>

#include "compat.h"
#include "watcher.h"
#include "state.h"

// Watches a Maildir for changes
class watcher_maildir : public watcher
{
  public:
	watcher_maildir(struct inotify_state* state, const std::string& maildir);
	virtual ~watcher_maildir();

	virtual void process_event(const struct inotify_event& event);

  private:
	// Watch the maildir structure itself for cur/ and new/ removal
	// No need to watch for IN_DELETE_SELF because cur/ and new/ must go first
	static const uint32_t m_notify = IN_MOVED_FROM | IN_DELETE;

	// A Maildir's cur/ and new/ can be modified only by moving files into
	// or out of or by deleting a file from these directories.
	// New messages are hardlinked or moved into into cur/ or new/.
	static const uint32_t cn_notify = IN_CREATE | IN_MOVE | IN_DELETE;

	const std::string maildir;
	const std::string imap_name;

	struct inotify_state* state;
	int wd_maildir, wd_cur, wd_new;

	int start_watch(const char* dir, uint32_t notify);
	void stop_watch(int wd);
};

#endif // INOTIFY_WATCHERMAILDIR_H
