#ifndef INOTIFY_STATE_H
#define INOTIFY_STATE_H

#include <map>
#include <set>
#include <string>

#include "watcher.h"

class inotify_state
{
  public:
	inotify_state(const char* base_path);
	~inotify_state();

	const int inotify_fd;
	const std::string base_path;

	void add_imap_watcher(int wd, const std::string& imap_name, watcher* w);
	void remove_imap_watcher(int wd, const std::string& imap_name);

	watcher* get_watcher_by_wd(int wd);
	watcher* get_imap_watcher(const std::string& imap_name);

	bool is_new_wd(int wd) const;
	void reset_new_wds();

  private:
	std::map<int, watcher*> watchers; // wd -> watcher
	std::map<std::string, watcher*> imap2watcher; // imap name -> watcher
	std::set<int> new_wds; // wds
};

#endif // #define INOTIFY_STATE_H
