with Ada.Text_IO;

package body Commands is

   ------------------
   -- Handler_Task --
   ------------------

   task body Handler_Task is
      Available : Boolean;
      C : Character;
   begin
      select
         accept Start;
      or
         terminate;
      end select;
      loop
         Ada.Text_IO.Get_Immediate (C, Available);
         if Available then
            case C is
               when 'q' | 'Q' =>
                  Repository.Quit;
                  select
                     accept Stop;
                     exit;
                  or
                     terminate;
                  end select;
               when others =>
                  null;
            end case;
         end if;
         select
            accept Stop;
            exit;
         or
            delay 0.5;
         end select;
      end loop;
   end Handler_Task;

   protected body Repository is

      procedure Quit is
      begin
         Quit_Pressed := True;
         Ada.Text_IO.New_Line;
         Ada.Text_IO.Put_Line ("music213 will end at the end of this song");
      end Quit;

      function Have_To_Quit return Boolean is
      begin
         return Quit_Pressed;
      end Have_To_Quit;

   end Repository;

end Commands;
