/***************************************************************************
                          odinconf.h  -  description
                             -------------------
    begin                : Fri Nov 11 21:30:11 CEST 2003
    copyright            : (C) 2003 by Thies H. Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OdinConf_H
#define OdinConf_H

#include <tjutils/tjprocess.h>

#include <odinpara/jdxblock.h>
#include <odinpara/jdxtypes.h>
#include <odinpara/jdxarrays.h>

///////////////////////////////////////////////////////////////////

#define DEFAULT_METH_ROOT "odin-methods"

///////////////////////////////////////////////////////////////////

class QWidget; // forward declaration

///////////////////////////////////////////////////////////////////

struct OdinConf : public JcampDxBlock {

  OdinConf(const STD_string& label="unnamedOdinConf", bool ignore_environment = false);

  JDXfileName  sourcecode;
  JDXfileName  editor;
  JDXfileName  browser;
  JDXfileName  methroot;
  JDXfileName  smpfile;
  JDXfileName  protfile;
  JDXfileName  compiler;  // Set once on startup, do not include in file
  JDXfileName  linker;    // Set once on startup, do not include in file
  JDXstring    compiler_flags;
  JDXstring    extra_includes;
  JDXstring    extra_libs;
  JDXstringArr selectedMethods;
  JDXbool      attachDebugger;

  bool init(QWidget* parent);

  svector get_method_compile_chain() const;

  // helper functions
  static STD_string get_binprefix();
  static STD_string get_homedir();
  static STD_string get_seqexamplesdir();
  static STD_string get_samplesdir();
  static STD_string get_coilsdir();
  static STD_string get_confdir();
  static STD_string get_tmpdir();
  static STD_string get_manual_location();

  bool display_html(const STD_string& location, STD_list<Process>& subprocs);
  bool open_ascfile(const STD_string& filename, STD_list<Process>& subprocs);

  static STD_string get_installdir();

#ifndef USING_WIN32
  static bool start_proc(const STD_string& program, const STD_string& filename, STD_list<Process>& subprocs);
#endif

 private:
  static STD_string get_registryvalue(const STD_string& keyname, const STD_string& valuename);

  static STD_string get_datadir();

  static bool ignore_env; // for clean start in IDEA
};

#endif
