/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENGTL_COLOR_CONVERTER_H_
#define _OPENGTL_COLOR_CONVERTER_H_

#include <GTLCore/Export.h>

namespace GTLCore {
  struct RgbaF;
  class PixelDescription;
  class GTLCORE_EXPORT AbstractColorConverter
  {
    friend class ColorConverters;
    GTL_NO_COPY(AbstractColorConverter)
  protected:
    AbstractColorConverter(const GTLCore::PixelDescription& _pixelDescription);
    virtual ~AbstractColorConverter();
  public:
    static void release(const GTLCore::AbstractColorConverter* _acc);
    virtual void pixelToRgba(const char* _data, RgbaF* _rgba) const = 0;
    virtual void rgbaToPixel(const RgbaF* _rgba, char* _data) const = 0;
    virtual void vectorToRgba(const float* _data, RgbaF* _rgba) const;
    virtual void rgbaToVector(const RgbaF* _rgba, float* _data) const;
  private:
    // Those are placeholders for the future conversion to/from HSV and to/from LAB
    virtual void placeholder1() {}
    virtual void placeholder2() {}
    virtual void placeholder3() {}
    virtual void placeholder4() {}
    virtual void placeholder5() {}
    virtual void placeholder6() {}
    virtual void placeholder7() {}
    virtual void placeholder8() {}
  private:
    struct Private;
    Private* const d;
  };
};

#endif
