/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ChannelsFlags.h"

#include "Debug.h"
#include "SharedPointer.h"

using namespace GTLCore;

struct ChannelsFlags::Private : public GTLCore::SharedPointerData {
  Private(){}
  Private(const Private& _rhs) : value(_rhs.value) {} 
  gtl_uint64 value;
};



ChannelsFlags::ChannelsFlags() : d(new Private)
{
  d->ref();
  d->value = UINT64_MAX;
}

GTL_SHARED_DATA(ChannelsFlags)

void ChannelsFlags::disableChannel(int i)
{
  deref();
  GTL_ASSERT(i < 64);
  gtl_uint64 mask = gtl_uint64(1) << i;
  d->value = (d->value | mask) - mask;
}

void ChannelsFlags::enableChannel(int i)
{
  deref();
  GTL_ASSERT(i < 64);
  gtl_uint64 mask = gtl_uint64(1) << i;
  d->value = (d->value | mask);
}

bool ChannelsFlags::isChannelEnabled(int i) const
{
  GTL_ASSERT(i < 64);
  gtl_uint64 mask = gtl_uint64(1) << i;
  return (d->value & mask) == mask;
}

gtl_uint64 ChannelsFlags::value() const
{
  return d->value;
}

void ChannelsFlags::setValue(gtl_uint64 v)
{
  deref();
  d->value = v;
}
