/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENGTL_COLOR_H_
#define _OPENGTL_COLOR_H_

#include <GTLCore/Export.h>

namespace GTLCore {
  struct RgbaF;
  class GTLCORE_EXPORT Color {
    public:
      Color();
      Color(const Color&);
      Color& operator=(const Color&);
      Color(float r, float g, float b, float a = 1.0);
      ~Color();
      bool operator==(const Color&);
      float red() const;
      float green() const;
      float blue() const;
      float alpha() const;
      void setRed(float r);
      void setGreen(float r);
      void setBlue(float r);
      void setAlpha(float r);
      const RgbaF& rgbaf() const;
    private:
      void deref();
      struct Private;
      Private* d;
  };
}

#endif
