/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_BITARRAY_H_
#define _GTLCORE_BITARRAY_H_

#include <GTLCore/Export.h>
#include <GTLCore/StdTypes.h>

namespace GTLCore {
  /**
   * @ingroup GTLCore
   * Determine which channel is enabled. Current implementation is limited to 64 channels.
   */
  class GTLCORE_EXPORT ChannelsFlags {
    public:
      /**
       * Construct a @ref ChannelsFlag object where all channels
       * are enabled.
       */
      ChannelsFlags();
      ChannelsFlags(const ChannelsFlags& _rhs);
      ChannelsFlags& operator=(const ChannelsFlags& _rhs);
      ~ChannelsFlags();
      /**
       * Disable channel @p i
       */
      void disableChannel(int i);
      /**
       * Enable channel @p i
       */
      void enableChannel(int i);
      /**
       * Test if channel channel @p i is enabled
       */
      bool isChannelEnabled(int i) const;
      gtl_uint64 value() const;
      void setValue(gtl_uint64 v);
    private:
      void deref();
      struct Private;
      Private* d;
  };
}

#endif 
