/*
 *  Copyright (c) 2011 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_OPERATOR_OVERLOAD_CENTER_P_H_
#define _GTLCORE_OPERATOR_OVERLOAD_CENTER_P_H_

#include <GTLCore/Export.h>

namespace GTLCore
{
  class Type;
  namespace AST
  {
    class Expression;
    class BinaryExpression;
  }

  class OperatorOverloadExpressionFactory;
  namespace Operator
  {
    enum Type
    {
      Unknown = -1,
      Equal = 0
    };
  }
  /**
   * Operator overload is checked by the @ref ParserBase before any conversion attempt is made.
   * Which means that if an operator can support different type, it needs to check for them.
   */
  class GTLCORE_EXPORT OperatorOverloadCenter
  {
  public:
    OperatorOverloadCenter();
    ~OperatorOverloadCenter();
    AST::BinaryExpression* createBinaryExpression( AST::Expression* value1, AST::Expression* value2, Operator::Type type  ) const;
    void addOperatorOverloadExpressionFactory( GTLCore::OperatorOverloadExpressionFactory* _factory );
  private:
    struct Private;
    Private* const d;
  };
  /**
   * @internal
   * This class allows to create the \ref AST::BinaryExpression that can operate between two values
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT OperatorOverloadExpressionFactory {
    public:
      OperatorOverloadExpressionFactory( );
      virtual ~OperatorOverloadExpressionFactory();
      /**
       * Create the \ref AST::BinaryExpression that can affect the given @p value2 to the given @p value1
       */
      virtual AST::BinaryExpression* create( AST::Expression* value1, AST::Expression* value2, Operator::Type type ) const = 0;
      /**
       * @return true if this \ref OperatorOverloadExpressionFactory can create a BinaryExpression between @p srcType and @p dstType
       */
      virtual bool canOverload( const GTLCore::Type* srcType, const GTLCore::Type* dstType, Operator::Type type ) const = 0;
    private:
      struct Private;
      Private* const d;
  };

}

#endif
