/*
 *  Copyright (c) 2009-2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Source.h"

#include <GTLCore/SharedPointer.h>
#include <GTLCore/String.h>
#include "GTLCore/CompilationMessages.h"

namespace GTLFragment {

  /**
   * @internal
   * @ingroup GTLFragment
   */
  struct Source::Private : public GTLCore::SharedPointerData
  {
    Private() : metadata(0), metadataCompilationFailed(false), uptodate(false) {}
    Private(const Private& _rhs) : SharedPointerData(), name(_rhs.name), source(_rhs.source), metadata(0), metadataCompilationFailed(false), uptodate(false) {}
    
    void compileMetaData();
    void update();
    GTLCore::String name;
    GTLCore::String source;
    Metadata* metadata;
    bool metadataCompilationFailed;
    GTLCore::CompilationMessages compilationErrors;
    bool uptodate; ///< Hold wether name and type have been extracted from source
    virtual Private* clone();
    virtual void specificUpdate(const GTLCore::String& _source, GTLCore::String& name);
  };
}