## 2022-07-07 Version 2.1.0 Release Notes

### Features/Enhancements

* Rename package 'o.o.action.support.master' to 'o.o.action.support.clustermanager' (#3556) ([#3597](https://github.com/opensearch-project/opensearch/pull/3597))
* Support dynamic node role (#3436) ([#3585](https://github.com/opensearch-project/opensearch/pull/3585))
* Support use of IRSA for repository-s3 plugin credentials (#3475) ([#3486](https://github.com/opensearch-project/opensearch/pull/3486))
* Filter out invalid URI and HTTP method in the error message of no handler found for a REST request (#3459) ([#3485](https://github.com/opensearch-project/opensearch/pull/3485))
* Set term vector flags to false for ._index_prefix field (#1901). (#3119) ([#3447](https://github.com/opensearch-project/opensearch/pull/3447))
* Replace internal usages of 'master' term in 'server/src/test' directory (#2520) ([#3444](https://github.com/opensearch-project/opensearch/pull/3444))
* Rename master to cluster_manager in the XContent Parser of ClusterHealthResponse (#3432) ([#3438](https://github.com/opensearch-project/opensearch/pull/3438))
* Replace internal usages of 'master' term in 'server/src/internalClusterTest' directory (#2521) ([#3407](https://github.com/opensearch-project/opensearch/pull/3407))
* Replace 'master' terminology with 'cluster manager' in 'qa' directory (#3330) ([#3332](https://github.com/opensearch-project/opensearch/pull/3332))
* Replace 'master' terminology with 'cluster manager' in 'modules' directory (#3328) ([#3333](https://github.com/opensearch-project/opensearch/pull/3333))
* Replace 'master' terminology with 'cluster manager' in 'plugins' directory (#3329) ([#3334](https://github.com/opensearch-project/opensearch/pull/3334))
* Replace internal usages of 'master' term in 'test' directory (#3283) ([#3293](https://github.com/opensearch-project/opensearch/pull/3293))
* Replace internal usages of 'master' term in 'client' directory (#3088) ([#3284](https://github.com/opensearch-project/opensearch/pull/3284))
* Replace internal usages of 'master' term in 'test' directory (#3283) ([#3293](https://github.com/opensearch-project/opensearch/pull/3293))
* Replace internal usages of 'master' term in 'client' directory (#3088) ([#3284](https://github.com/opensearch-project/opensearch/pull/3284))
* Replace internal usages of 'master' term in 'server/src/main' directory (#2519) ([#3165](https://github.com/opensearch-project/opensearch/pull/3165))
* Rename ClusterBlock description 'no master' to 'no cluster-manager' (#3133) ([#3151](https://github.com/opensearch-project/opensearch/pull/3151))
* Correct the skip version, multi_terms aggregation is supported on 2.1 (#3072) ([#3073](https://github.com/opensearch-project/opensearch/pull/3073))
* Adds the replication type index setting, alongside a formal notion of feature flags (#3037) ([#3071](https://github.com/opensearch-project/opensearch/pull/3071))
* Add new multi_term aggregation (#2687) ([#3022](https://github.com/opensearch-project/opensearch/pull/3022))
* Add `positive_score_impact` support for `rank_features` (#2725) ([#2968](https://github.com/opensearch-project/opensearch/pull/2968))
* [Backport 2.x] Add resource stats to task framework ([#2655](https://github.com/opensearch-project/opensearch/pull/2655))
* Optimize Node, remove duplicate Settings (#2703) ([#2742](https://github.com/opensearch-project/opensearch/pull/2742))
* [Backport 2.x] Add request parameter 'cluster_manager_timeout' as the alternative for 'master_timeout', and deprecate 'master_timeout' - in CAT APIs ([#2716](https://github.com/opensearch-project/opensearch/pull/2716))
* Enable merge on refresh and merge on commit on Opensearch (#2535) ([#2600](https://github.com/opensearch-project/opensearch/pull/2600))
* Concurrent Searching (Experimental) (#1500) ([#2584](https://github.com/opensearch-project/opensearch/pull/2584))
* [Type removal] Remove type from BulkRequestParser (#3423) ([#3431](https://github.com/opensearch-project/opensearch/pull/3431))
* [Type removal] _type removal from tests of yaml tests (#3406) ([#3414](https://github.com/opensearch-project/opensearch/pull/3414))
* [2.x] Deprecate public methods and variables with master term in package 'org.opensearch.action.support.master' (#3617) ([#3643](https://github.com/opensearch-project/opensearch/pull/3643))
* Deprecate classes in org.opensearch.action.support.master (#3593) ([#3609](https://github.com/opensearch-project/opensearch/pull/3609))
* [TEST] Add back necessary tests for deprecated settings that are replaced during applying inclusive naming (#2825) ([#3353](https://github.com/opensearch-project/opensearch/pull/3353))
* Support use of IRSA for repository-s3 plugin credentials: added YAML Rest test case (#3499) ([#3520](https://github.com/opensearch-project/opensearch/pull/3520))
* [Backport 2.x] Add type mapping removal bwc tests for indexing, searching, snapshots ([#2921](https://github.com/opensearch-project/opensearch/pull/2921))


### Bug Fixes

* [BUG] Custom POM configuration for ZIP publication produces duplicit tags (url, scm) (#3656) ([#3680](https://github.com/opensearch-project/opensearch/pull/3680))
* [BUG] opensearch crashes on closed client connection before search reply (#3626) ([#3645](https://github.com/opensearch-project/opensearch/pull/3645))
* Fix false positive query timeouts due to using cached time (#3454) ([#3624](https://github.com/opensearch-project/opensearch/pull/3624))
* Fix NPE when minBound/maxBound is not set before being called. (#3605) ([#3610](https://github.com/opensearch-project/opensearch/pull/3610))
* Fix for bug showing incorrect awareness attributes count in AwarenessAllocationDecider (#3428) ([#3580](https://github.com/opensearch-project/opensearch/pull/3580))
* Add flat_skew setting to node overload decider (#3563) ([#3582](https://github.com/opensearch-project/opensearch/pull/3582))
* Fix the support of RestClient Node Sniffer for version 2.x and update tests (#3487) ([#3521](https://github.com/opensearch-project/opensearch/pull/3521))
* move bash flag to set statement (#3494) ([#3519](https://github.com/opensearch-project/opensearch/pull/3519))
* [BUG] Fixing org.opensearch.monitor.os.OsProbeTests > testLogWarnCpuMessageOnlyOnes when cgroups are available but cgroup stats is not (#3448) ([#3464](https://github.com/opensearch-project/opensearch/pull/3464))
* Removing unused method from TransportSearchAction (#3437) ([#3445](https://github.com/opensearch-project/opensearch/pull/3445))
* Fix Lucene-snapshots repo for jdk 17. (#3396) ([#3404](https://github.com/opensearch-project/opensearch/pull/3404))
* Temporary adding Apache Lucene repositories for snapshots (#3042) ([#3047](https://github.com/opensearch-project/opensearch/pull/3047))
* Excluding system indices from max shard limit validator (#2894) ([#2911](https://github.com/opensearch-project/opensearch/pull/2911))
* [Backport] [2.x] Bugfix to guard against stack overflow errors caused by very large reg-ex input  ([#2817](https://github.com/opensearch-project/opensearch/pull/2817))

### Infrastructure

* Move gradle-check code to its own scripts and upload codecov (#3742) ([#3747](https://github.com/opensearch-project/opensearch/pull/3747))
* Optimize Gradle builds by enabling local build caching (#3718) ([#3737](https://github.com/opensearch-project/opensearch/pull/3737))
* Update github action gradle-check to use pull_request_target for accessing token (#3728) ([#3731](https://github.com/opensearch-project/opensearch/pull/3731))
* Add gradle check test for github workflows (#3717) ([#3723](https://github.com/opensearch-project/opensearch/pull/3723))
* Used set to make shell scripts more strict (#3278) ([#3344](https://github.com/opensearch-project/opensearch/pull/3344))
* Bootstrap should implement a denylist of Java versions (ranges) (#3164) ([#3292](https://github.com/opensearch-project/opensearch/pull/3292))
* Add Github Workflow to build and publish lucene snapshots. (#2906) ([#3038](https://github.com/opensearch-project/opensearch/pull/3038))
* Remove JavaVersion in favour of standard Runtime.Version (java-version-checker) (#3027) ([#3034](https://github.com/opensearch-project/opensearch/pull/3034))
* Remove JavaVersion, use builtin Runtime.Version to deal with runtime versions (#3006) ([#3013](https://github.com/opensearch-project/opensearch/pull/3013))
* [Backport 2.x] Added a new line linter ([#2892](https://github.com/opensearch-project/opensearch/pull/2892))

### Maintenance

* Added bwc version 2.0.2 ([#3612](https://github.com/opensearch-project/opensearch/pull/3612))
* Added bwc version 1.3.4 (#3551) ([#3583](https://github.com/opensearch-project/opensearch/pull/3583))
* Bump guava from 18.0 to 23.0 in /plugins/ingest-attachment (#3357) ([#3534](https://github.com/opensearch-project/opensearch/pull/3534))
* Added bwc version 2.0.1 ([#3451](https://github.com/opensearch-project/opensearch/pull/3451))
* Bump google-auth-library-oauth2-http from 0.20.0 to 1.7.0 in /plugins/repository-gcs (#3473) ([#3488](https://github.com/opensearch-project/opensearch/pull/3488))
* Bump protobuf-java from 3.20.1 to 3.21.1 in /plugins/repository-hdfs (#3472) ([#3480](https://github.com/opensearch-project/opensearch/pull/3480))
* Bump reactor-core from 3.4.17 to 3.4.18 in /plugins/repository-azure (#3427) ([#3430](https://github.com/opensearch-project/opensearch/pull/3430))
* Bump com.gradle.enterprise from 3.10 to 3.10.1 (#3425) ([#3429](https://github.com/opensearch-project/opensearch/pull/3429))
* Bump reactor-netty-core from 1.0.16 to 1.0.19 in /plugins/repository-azure (#3360) ([#3386](https://github.com/opensearch-project/opensearch/pull/3386))
* Bump xz from 1.8 to 1.9 in /plugins/ingest-attachment (#3248) ([#3280](https://github.com/opensearch-project/opensearch/pull/3280))
* Upgrading ingest-attachment dependencies (#3111) ([#3279](https://github.com/opensearch-project/opensearch/pull/3279))
* Bump reactor-netty from 1.0.17 to 1.0.18 in /plugins/repository-azure (#3246) ([#3258](https://github.com/opensearch-project/opensearch/pull/3258))
* Bump google-http-client-appengine from 1.35.0 to 1.41.8 in /plugins/repository-gcs (#3247) ([#3259](https://github.com/opensearch-project/opensearch/pull/3259))
* Bump HdrHistogram from 2.1.9 to 2.1.12 in /server (#2135) ([#3200](https://github.com/opensearch-project/opensearch/pull/3200))
* Add bwc version 1.3.3 ([#3221](https://github.com/opensearch-project/opensearch/pull/3221))
* Bump commons-lang3 from 3.9 to 3.12.0 in /plugins/ingest-attachment (#3190) ([#3194](https://github.com/opensearch-project/opensearch/pull/3194))
* Bump google-api-client from 1.30.10 to 1.34.0 in /plugins/repository-gcs (#3161) ([#3191](https://github.com/opensearch-project/opensearch/pull/3191))
* Bump reactor-netty-http from 1.0.16 to 1.0.18 in /plugins/repository-azure (#3057) ([#3070](https://github.com/opensearch-project/opensearch/pull/3070))
* Bump com.gradle.enterprise from 3.9 to 3.10 (#3055) ([#3069](https://github.com/opensearch-project/opensearch/pull/3069))
* Bump protobuf-java from 3.20.0 to 3.20.1 in /plugins/repository-hdfs (#3062) ([#3068](https://github.com/opensearch-project/opensearch/pull/3068))
* Bump protobuf-java from 3.20.0 to 3.20.1 in /plugins/repository-hdfs (#3062) ([#3068](https://github.com/opensearch-project/opensearch/pull/3068))
* Bump json-schema-validator from 1.0.68 to 1.0.69 in /buildSrc (#3060) ([#3066](https://github.com/opensearch-project/opensearch/pull/3066))
* Add Gradle 7.4 Aggregated Test Reports (#2821) ([#2983](https://github.com/opensearch-project/opensearch/pull/2983))
* Bump google-oauth-client from 1.33.2 to 1.33.3 in /plugins/discovery-gce (#2943) ([#2966](https://github.com/opensearch-project/opensearch/pull/2966))
* Bump org.gradle.test-retry from 1.3.1 to 1.3.2 (#2940) ([#2960](https://github.com/opensearch-project/opensearch/pull/2960))
* Bump reactor-core from 3.4.15 to 3.4.17 in /plugins/repository-azure (#2947) ([#2961](https://github.com/opensearch-project/opensearch/pull/2961))
* Bump grpc-context from 1.29.0 to 1.45.1 in /plugins/repository-gcs (#2944) ([#2962](https://github.com/opensearch-project/opensearch/pull/2962))
* Bump guava from 30.1.1-jre to 31.1-jre in /plugins/repository-hdfs (#2948) ([#2959](https://github.com/opensearch-project/opensearch/pull/2959))
* Bump reactor-netty from 1.0.16 to 1.0.17 in /plugins/repository-azure (#2613) ([#2958](https://github.com/opensearch-project/opensearch/pull/2958))
* Bump hadoop-minicluster from 3.3.1 to 3.3.2 in /test/fixtures/hdfs-fixture (#2381) ([#2957](https://github.com/opensearch-project/opensearch/pull/2957))
* Bump com.diffplug.spotless from 6.4.1 to 6.4.2 (#2827) ([#2956](https://github.com/opensearch-project/opensearch/pull/2956))
* Bump jna from 5.10.0 to 5.11.0 in /buildSrc (#2946) ([#2955](https://github.com/opensearch-project/opensearch/pull/2955))
* Adding asm to version file and upgrading (#2933) ([#2951](https://github.com/opensearch-project/opensearch/pull/2951))
* [Backport 2.x] Update commons-logging to 1.2 ([#2823](https://github.com/opensearch-project/opensearch/pull/2823))
* Bump gradle-info-plugin from 7.1.3 to 11.3.3 in /buildSrc (#2831) ([#2842](https://github.com/opensearch-project/opensearch/pull/2842))
* Update azure-storage-blob to 12.15.0: fix test flakiness (#2795) ([#2798](https://github.com/opensearch-project/opensearch/pull/2798))
* Bump proto-google-common-protos from 1.16.0 to 2.8.0 in /plugins/repository-gcs (#2738) ([#2743](https://github.com/opensearch-project/opensearch/pull/2743))
* Update to Gradle 7.4.2 (#2688) ([#2692](https://github.com/opensearch-project/opensearch/pull/2692))
* Update Gradle to 7.4.1 (#2078) ([#2645](https://github.com/opensearch-project/opensearch/pull/2645))
* Lock 2.1 release to Lucene 9.2.0. ([#3676](https://github.com/opensearch-project/opensearch/pull/3676))
* [Dependency upgrade] google-oauth-client to 1.33.3 (#3500) ([#3501](https://github.com/opensearch-project/opensearch/pull/3501))

### Refactoring

* [Refactor] XContentType to parse Accept or Content-Type headers (#3077) ([#3103](https://github.com/opensearch-project/opensearch/pull/3103))
* Remove usages of MultiTermQuery.setRewriteMethodsetRewriteMethod (#2997) ([#3017](https://github.com/opensearch-project/opensearch/pull/3017))
* Refactoring GatedAutoCloseable and moving RecoveryState.Timer (#2965) ([#3014](https://github.com/opensearch-project/opensearch/pull/3014))
* Fixing flakiness of ShuffleForcedMergePolicyTests (#3591) ([#3592](https://github.com/opensearch-project/opensearch/pull/3592))
* Fix testSetAdditionalRolesCanAddDeprecatedMasterRole() by removing the initial assertion (#3441) ([#3443](https://github.com/opensearch-project/opensearch/pull/3443))
