//----------------------------------------------------------------------------
//
// License:  LGPL
// 
// See LICENSE.txt file in the top level directory for more details.
//
// Author:  David Burken
//
// Description: Test app for ossimTiffInfo class.
// 
//----------------------------------------------------------------------------
// $Id$

#include <iostream>
using namespace std;

#include <ossim/init/ossimInit.h>
#include <ossim/base/ossimKeywordlist.h>
#include <ossim/support_data/ossimTiffInfo.h>

int main(int argc, char *argv[])
{
   ossimInit::instance()->initialize(argc, argv);

   if (argc != 2)
   {
      cout << argv[0] << "<tiff_file>"
           << "\nPrint dump and geometry info for tiff_file." << endl;
      return 0;
   }

   ossimTiffInfo info;

   if ( info.open( ossimFilename(argv[1]) ) )
   {
      cout << "dump info:\n";
      info.print(cout);

      ossimKeywordlist kwl;
      if ( info.getImageGeometry(kwl, 0) )
      {
         cout << "geometry info:\n" << kwl << endl;
      }
      else
      {
         cout << "get image geometry failed..." << endl;
      }
   }
   else
   {
      cout << "Could not open: " << argv[1] << endl;
   }
   
   return 0;
}
