///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMVIZ_BENCHMARK_UTILITY_H
#define __ATOMVIZ_BENCHMARK_UTILITY_H

#include <core/Core.h>
#include <core/plugins/utility/UtilityPlugin.h>
#include <core/viewport/Window3D.h>

#include "../AtomViz.h"
#include <atomviz/atoms/AtomsRenderer.h>

namespace AtomViz {

class AtomVizOpenGLBenchmarkWindow : public QMainWindow
{
public:

	/// Opens the benchmark window.
	static AtomVizOpenGLBenchmarkWindow* showBenchmarkWindow();

public Q_SLOTS:

	/// This opens the file dialog and lets the user save the report to a PDF file.
	void saveReport();

private:

	/// Constructor.
	AtomVizOpenGLBenchmarkWindow(QWidget* parent);

	void performOpenGLTest();

	/// Renders test pictures for OpenGL compatibility check.
	QVector<QImage> renderCompatibilityTests();
	void appendTestImage(QString& report, int testIndex, const QString& description, const QImage& image, QTextDocument* document);

	QTextEdit* _contentWidget;

	/// The global window instance.
	static QPointer<AtomVizOpenGLBenchmarkWindow> _singletonInstance;

	Q_OBJECT
};

/**
 * \brief This utility applet lets the user benchmark the OpenGL rendering
 *        performance of his computer.
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT AtomVizBenchmarkUtility : public UtilityPlugin
{
public:

	/// Default constructor.
	AtomVizBenchmarkUtility() {}

	/// Shows the UI of the utility in the given RolloutContainer.
	virtual void openUtility(RolloutContainer* container, const RolloutInsertionParameters& rolloutParams = RolloutInsertionParameters()) {
		AtomVizOpenGLBenchmarkWindow::showBenchmarkWindow();
	}

	/// Removes the UI of the utility from the rollout container.
	virtual void closeUtility(RolloutContainer* container) {}

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(AtomVizBenchmarkUtility)
};

};

#endif // __ATOMVIZ_BENCHMARK_UTILITY_H
