///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/actions/ActionProxy.h>

namespace Core {

/******************************************************************************
* Constructor that accepts an already existing action.
******************************************************************************/
ActionProxy::ActionProxy(const Action::SmartPtr& action) : QWidgetAction(NULL), _action(action)
{
	CHECK_OBJECT_POINTER(_action);
	OVITO_ASSERT_MSG(_action->objectName().isEmpty() == false, "ActionProxy constructor", "The action object needs to have a valid identifier assigned.");

	setObjectName(_action->objectName());
	_action->initializeAction(this);
}

/******************************************************************************
* This function is called whenever the action proxy is added to a
* container widget that supports custom widgets.
******************************************************************************/
QWidget* ActionProxy::createWidget(QWidget* parent)
{
	if(_action)
		return _action->createWidget(parent);
	return NULL;
}

};
