///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>
#include <core/plugins/Plugin.h>
#include <core/plugins/PluginClass.h>
#include <core/plugins/PluginManager.h>
#include <core/scene/animation/TimeInterval.h>

namespace Scripting {

using namespace boost::python;

void ExportPlugins()
{
	class_<PluginClassDescriptor, noncopyable>("PluginClassDescriptor", no_init)
		.add_property("Name", make_function(&PluginClassDescriptor::name, return_value_policy<copy_const_reference>()))
		.add_property("IsAbstract", &PluginClassDescriptor::isAbstract)
		.add_property("IsSerializable", &PluginClassDescriptor::isSerializable)
		.add_property("BaseClass", make_function(&PluginClassDescriptor::baseClass, return_value_policy<reference_existing_object>()))
	;

	class_<PluginClass, noncopyable>("PluginClass", no_init)
		.def("AutoDeleteObject", &PluginClass::autoDeleteObject)
		.add_property("ObjectReferenceCount", &PluginClass::objectReferenceCount)
		.add_property("PluginClass", make_function(&PluginClass::pluginClassDescriptor, return_value_policy<reference_existing_object>()))
	;

	class_<TimeInterval>("TimeInterval", init<>())
		.def(init<TimeTicks>())
		.def(init<TimeTicks, TimeTicks>())

		.add_property("Start", &TimeInterval::start, &TimeInterval::setStart)
		.add_property("End", &TimeInterval::end, &TimeInterval::setEnd)

		.add_property("IsEmpty", &TimeInterval::isEmpty)
		.add_property("IsInfinite", &TimeInterval::isInfinite)

		.add_property("Duration", &TimeInterval::duration, &TimeInterval::setDuration)
		.def("SetInfinite", &TimeInterval::setInfinite)
		.def("SetEmpty", &TimeInterval::setEmpty)
		.def("SetInstant", &TimeInterval::setInstant)

		.def("Contains", &TimeInterval::contains)

		.setattr("Forever", TimeForever)
		.setattr("Never", TimeNever)
	;
}

};
